/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.FontSizer;

public class ThumbnailDialog
extends JDialog {
    protected static ThumbnailDialog thumbnailDialog;
    protected static String[] viewNames;
    protected static String[] formatNames;
    protected static Dimension defaultSize;
    protected static VideoFileFilter[] fileFilters;
    protected static PropertyChangeListener fileChooserListener;
    protected static JTextComponent chooserField;
    protected static boolean settingsOnly;
    protected TrackerPanel trackerPanel;
    protected JButton saveAsButton;
    protected JButton closeButton;
    protected JComponent sizePanel;
    protected JComponent viewPanel;
    protected JComponent formatPanel;
    protected JComboBox formatDropdown;
    protected JComboBox viewDropdown;
    protected JComboBox sizeDropdown;
    protected DefaultComboBoxModel formatModel;
    protected DefaultComboBoxModel viewModel;
    protected AffineTransform transform = new AffineTransform();
    protected BufferedImage sizedImage;
    protected HashMap<Object, Dimension> sizes;
    protected Dimension fullSize = new Dimension();
    protected Dimension thumbSize;
    protected boolean isRefreshing;
    protected String savedFilePath;
    protected JPanel buttonbar;

    static {
        viewNames = new String[]{"WholeFrame", "MainView", "VideoOnly"};
        formatNames = new String[]{"png", "jpg"};
        defaultSize = new Dimension(320, 240);
        fileFilters = new VideoFileFilter[formatNames.length];
    }

    public static ThumbnailDialog getDialog(TrackerPanel trackerPanel, boolean bl) {
        if (thumbnailDialog == null) {
            Object object;
            thumbnailDialog = new ThumbnailDialog(trackerPanel);
            fileChooserListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (chooserField != null) {
                        VideoFileFilter videoFileFilter = (VideoFileFilter)propertyChangeEvent.getNewValue();
                        final String string = videoFileFilter.getDefaultExtension();
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                String string2 = String.valueOf(XML.stripExtension(chooserField.getText())) + "." + string;
                                chooserField.setText(string2);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            };
            int n = 0;
            while (n < formatNames.length) {
                object = VideoIO.getVideoType(null, formatNames[n]);
                VideoFileFilter[] videoFileFilterArray = object.getFileFilters();
                int n2 = videoFileFilterArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    VideoFileFilter videoFileFilter = videoFileFilterArray[n3];
                    if (videoFileFilter.getDefaultExtension().equals(formatNames[n])) {
                        ThumbnailDialog.fileFilters[n] = videoFileFilter;
                        break;
                    }
                    ++n3;
                }
                ++n;
            }
            JFileChooser jFileChooser = TrackerIO.getChooser();
            object = "untitled.tmp";
            jFileChooser.setSelectedFile(new File((String)object));
            chooserField = ThumbnailDialog.getTextComponent(jFileChooser, (String)object);
            jFileChooser.setSelectedFile(new File(""));
        }
        boolean bl2 = settingsOnly = !bl;
        if (ThumbnailDialog.thumbnailDialog.trackerPanel != trackerPanel) {
            ThumbnailDialog.thumbnailDialog.trackerPanel = trackerPanel;
        }
        thumbnailDialog.refreshGUI();
        return thumbnailDialog;
    }

    public File saveThumbnail(String string) {
        File[] fileArray;
        Object object;
        Serializable serializable;
        int n = this.formatDropdown.getSelectedIndex();
        String string2 = formatNames[n];
        if (string == null) {
            serializable = TrackerIO.getChooser();
            ((JFileChooser)serializable).setAcceptAllFileFilterUsed(false);
            Object object2 = ((JFileChooser)serializable).getChoosableFileFilters();
            int n2 = ((FileFilter[])object2).length;
            int n3 = 0;
            while (n3 < n2) {
                object = object2[n3];
                ((JFileChooser)serializable).removeChoosableFileFilter((FileFilter)object);
                ++n3;
            }
            object2 = fileFilters;
            n2 = fileFilters.length;
            n3 = 0;
            while (n3 < n2) {
                object = object2[n3];
                ((JFileChooser)serializable).addChoosableFileFilter((FileFilter)object);
                ++n3;
            }
            ((JFileChooser)serializable).setFileFilter(fileFilters[n]);
            ((Container)serializable).addPropertyChangeListener("fileFilterChanged", fileChooserListener);
            ((JFileChooser)serializable).setDialogTitle(TrackerRes.getString("ThumbnailDialog.Chooser.SaveThumbnail.Title"));
            object = XML.stripExtension(this.trackerPanel.getTitle());
            ((JFileChooser)serializable).setSelectedFile(new File(String.valueOf(object) + "_thumbnail." + string2));
            fileArray = TrackerIO.getChooserFiles("save");
            ((Component)serializable).removePropertyChangeListener("fileFilterChanged", fileChooserListener);
            if (fileArray == null || fileArray.length == 0) {
                return null;
            }
            string = fileArray[0].getAbsolutePath();
            VideoFileFilter videoFileFilter = (VideoFileFilter)((JFileChooser)serializable).getFileFilter();
            object2 = videoFileFilter.getDefaultExtension();
            this.setFormat((String)object2);
            if (!videoFileFilter.accept(fileArray[0]) && !TrackerIO.canWrite(new File(string = String.valueOf(XML.stripExtension(string)) + "." + (String)object2))) {
                return null;
            }
        }
        if (XML.getExtension(string) == null) {
            string = String.valueOf(XML.stripExtension(string)) + "." + string2;
        }
        serializable = this.sizes.get(this.sizeDropdown.getSelectedItem());
        object = this.getThumbnailImage((Dimension)serializable);
        fileArray = VideoIO.writeImageFile((BufferedImage)object, string);
        return fileArray;
    }

    public BufferedImage getThumbnail() {
        Dimension dimension = this.sizes.get(this.sizeDropdown.getSelectedItem());
        return this.getThumbnailImage(dimension);
    }

    public void setFormat(String string) {
        int n = 0;
        while (n < formatNames.length) {
            if (string != null && formatNames[n].equals(string.toLowerCase())) {
                this.formatDropdown.setSelectedIndex(n);
                break;
            }
            ++n;
        }
    }

    public String getFormat() {
        return formatNames[this.formatDropdown.getSelectedIndex()];
    }

    private ThumbnailDialog(TrackerPanel trackerPanel) {
        super((Frame)trackerPanel.getTFrame(), true);
        this.trackerPanel = trackerPanel;
        this.setResizable(false);
        this.createGUI();
        this.refreshGUI();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n, n2);
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2));
        jPanel.add((Component)box, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        this.sizes = new HashMap();
        this.sizePanel = Box.createVerticalBox();
        this.sizeDropdown = new JComboBox();
        this.sizePanel.add(this.sizeDropdown);
        this.viewPanel = Box.createVerticalBox();
        this.viewModel = new DefaultComboBoxModel();
        this.viewDropdown = new JComboBox(this.viewModel);
        this.viewPanel.add(this.viewDropdown);
        this.viewDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && !ThumbnailDialog.this.isRefreshing) {
                    ThumbnailDialog.this.refreshSizeDropdown();
                }
            }
        });
        this.formatPanel = Box.createVerticalBox();
        this.formatModel = new DefaultComboBoxModel();
        this.formatDropdown = new JComboBox(this.formatModel);
        this.formatPanel.add(this.formatDropdown);
        box.add(jPanel2);
        box.add(jPanel3);
        jPanel2.add(this.viewPanel);
        jPanel3.add(this.sizePanel);
        jPanel3.add(this.formatPanel);
        this.saveAsButton = new JButton();
        this.saveAsButton.setForeground(new Color(0, 0, 102));
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThumbnailDialog.this.setVisible(false);
                ThumbnailDialog.this.saveThumbnail(null);
            }
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(new Color(0, 0, 102));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThumbnailDialog.this.setVisible(false);
                ThumbnailDialog.this.firePropertyChange("accepted", null, null);
            }
        });
        this.buttonbar = new JPanel();
        jPanel.add((Component)this.buttonbar, "South");
        this.buttonbar.add(this.saveAsButton);
        this.buttonbar.add(this.closeButton);
    }

    protected void refreshGUI() {
        String string = settingsOnly ? "ThumbnailDialog.Settings.Title" : "ThumbnailDialog.Title";
        String string2 = TrackerRes.getString(string);
        this.setTitle(string2);
        string2 = TrackerRes.getString("ExportVideoDialog.Subtitle.Size");
        Border border = BorderFactory.createEmptyBorder(0, 4, 6, 4);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string2);
        int n = FontSizer.getLevel();
        FontSizer.setFonts(titledBorder, n);
        this.sizePanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        string2 = TrackerRes.getString("ThumbnailDialog.Subtitle.Image");
        titledBorder = BorderFactory.createTitledBorder(string2);
        FontSizer.setFonts(titledBorder, n);
        this.viewPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        string2 = TrackerRes.getString("ExportVideoDialog.Subtitle.Format");
        titledBorder = BorderFactory.createTitledBorder(string2);
        FontSizer.setFonts(titledBorder, n);
        this.formatPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        this.saveAsButton.setText(TrackerRes.getString("ExportVideoDialog.Button.SaveAs"));
        if (settingsOnly) {
            this.buttonbar.remove(this.saveAsButton);
            this.closeButton.setText(TrackerRes.getString("Dialog.Button.OK"));
        } else {
            this.buttonbar.add((Component)this.saveAsButton, 0);
            this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        }
        this.isRefreshing = true;
        int n2 = this.formatDropdown.getSelectedIndex();
        n2 = Math.max(n2, 0);
        this.formatModel.removeAllElements();
        int n3 = 0;
        while (n3 < formatNames.length) {
            String string3 = TrackerRes.getString("ThumbnailDialog.Format." + formatNames[n3].toUpperCase());
            this.formatModel.addElement(string3);
            ++n3;
        }
        this.formatDropdown.setSelectedIndex(n2);
        n3 = this.trackerPanel.getVideo() == null ? viewNames.length - 2 : viewNames.length - 1;
        n2 = Math.min(this.viewDropdown.getSelectedIndex(), n3);
        n2 = Math.max(n2, 0);
        this.viewModel.removeAllElements();
        int n4 = 0;
        while (n4 <= n3) {
            String string4 = TrackerRes.getString("ThumbnailDialog.View." + viewNames[n4]);
            this.viewModel.addElement(string4);
            ++n4;
        }
        this.viewDropdown.setSelectedIndex(n2);
        this.isRefreshing = false;
        this.refreshSizeDropdown();
        this.pack();
    }

    private void refreshSizeDropdown() {
        Object object;
        Object object2;
        this.isRefreshing = true;
        Object object3 = this.sizeDropdown.getSelectedItem();
        this.sizeDropdown.removeAllItems();
        this.sizes.clear();
        switch (this.viewDropdown.getSelectedIndex()) {
            case 1: {
                object2 = this.trackerPanel.getMat().mat;
                this.fullSize.setSize(((Rectangle)object2).getWidth(), ((Rectangle)object2).getHeight());
                this.thumbSize = this.getFullThumbnailSize(this.fullSize);
                break;
            }
            case 2: {
                object = this.trackerPanel.getVideo().getImage();
                this.fullSize.setSize(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
                this.thumbSize = this.getFullThumbnailSize(this.fullSize);
                break;
            }
            default: {
                this.fullSize.setSize(this.trackerPanel.getTFrame().getSize());
                this.thumbSize = this.getFullThumbnailSize(this.fullSize);
            }
        }
        if (this.isAcceptedDimension(this.fullSize.width, this.fullSize.height)) {
            object2 = String.valueOf(this.fullSize.width) + "x" + this.fullSize.height;
            this.sizeDropdown.addItem(object2);
            this.sizes.put(object2, this.fullSize);
        }
        object2 = new Dimension(this.fullSize.width / 2, this.fullSize.height / 2);
        if (((Dimension)object2).width > this.thumbSize.width && ((Dimension)object2).height > this.thumbSize.height && this.isAcceptedDimension(((Dimension)object2).width, ((Dimension)object2).height)) {
            object = String.valueOf(((Dimension)object2).width) + "x" + ((Dimension)object2).height;
            this.sizeDropdown.addItem(object);
            this.sizes.put(object, (Dimension)object2);
        }
        Object object4 = object = String.valueOf(this.thumbSize.width) + "x" + this.thumbSize.height;
        this.sizeDropdown.addItem(object);
        this.sizes.put(object, this.thumbSize);
        double[] dArray = new double[]{0.75, 0.5, 0.375, 0.25};
        int n = 0;
        while (n < dArray.length) {
            object2 = new Dimension((int)((double)this.thumbSize.width * dArray[n]), (int)((double)this.thumbSize.height * dArray[n]));
            if (this.isAcceptedDimension(((Dimension)object2).width, ((Dimension)object2).height)) {
                object = String.valueOf(((Dimension)object2).width) + "x" + ((Dimension)object2).height;
                this.sizeDropdown.addItem(object);
                this.sizes.put(object, (Dimension)object2);
            }
            ++n;
        }
        this.sizeDropdown.setSelectedItem(this.sizes.keySet().contains(object3) ? object3 : object4);
        this.isRefreshing = false;
    }

    private Dimension getFullThumbnailSize(Dimension dimension) {
        double d = defaultSize.getWidth() / (double)dimension.width;
        double d2 = defaultSize.getHeight() / (double)dimension.height;
        double d3 = Math.min(d, d2);
        int n = (int)((double)dimension.width * d3);
        int n2 = (int)((double)dimension.height * d3);
        return new Dimension(n, n2);
    }

    private boolean isAcceptedDimension(int n, int n2) {
        return n >= 80 || n2 >= 60;
    }

    private BufferedImage getThumbnailImage(Dimension dimension) {
        BufferedImage bufferedImage;
        switch (this.viewDropdown.getSelectedIndex()) {
            case 1: {
                bufferedImage = this.trackerPanel.renderMat();
                break;
            }
            case 2: {
                bufferedImage = this.trackerPanel.getVideo().getImage();
                break;
            }
            default: {
                TFrame tFrame = this.trackerPanel.getTFrame();
                bufferedImage = (BufferedImage)tFrame.createImage(this.fullSize.width, this.fullSize.height);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                tFrame.paint(graphics2D);
                graphics2D.dispose();
            }
        }
        return this.getResizedImage(bufferedImage, dimension);
    }

    private BufferedImage getResizedImage(BufferedImage bufferedImage, Dimension dimension) {
        if (dimension.width == bufferedImage.getWidth() && dimension.height == bufferedImage.getHeight()) {
            return bufferedImage;
        }
        if (this.sizedImage == null || this.sizedImage.getWidth() != dimension.width || this.sizedImage.getHeight() != dimension.height) {
            this.sizedImage = new BufferedImage(dimension.width, dimension.height, bufferedImage.getType());
        }
        Graphics2D graphics2D = this.sizedImage.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, dimension.width, dimension.height, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        graphics2D.dispose();
        return this.sizedImage;
    }

    private static JTextComponent getTextComponent(Container container, String string) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            JTextComponent jTextComponent;
            if (componentArray[n] instanceof JTextComponent && string.equals(((JTextComponent)componentArray[n]).getText())) {
                return (JTextComponent)componentArray[n];
            }
            if (componentArray[n] instanceof Container && (jTextComponent = ThumbnailDialog.getTextComponent((Container)componentArray[n], string)) != null) {
                return jTextComponent;
            }
            ++n;
        }
        return null;
    }
}

