/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class TapeStep
extends Step {
    protected static TPoint endPoint1 = new TPoint();
    protected static TPoint endPoint2 = new TPoint();
    protected TapeMeasure tape;
    protected TPoint end1;
    protected TPoint end2;
    protected TPoint middle;
    protected Handle handle;
    protected double worldLength;
    protected double xAxisToTapeAngle;
    protected double tapeAngle;
    protected boolean endsEnabled = true;
    protected boolean drawLayoutBounds;
    protected boolean adjustingTips;
    protected Map<TrackerPanel, Shape> end1Shapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, Shape> end2Shapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, Shape> shaftShapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, TextLayout> textLayouts = new HashMap<TrackerPanel, TextLayout>();
    protected Map<TrackerPanel, Rectangle> layoutBounds = new HashMap<TrackerPanel, Rectangle>();

    public TapeStep(TapeMeasure tapeMeasure, int n, double d, double d2, double d3, double d4) {
        super(tapeMeasure, n);
        this.tape = tapeMeasure;
        this.end1 = new Tip(d, d2);
        this.end1.setTrackEditTrigger(true);
        this.end2 = new Tip(d3, d4);
        this.end2.setTrackEditTrigger(true);
        this.middle = new TPoint(d, d2);
        this.handle = new Handle((d + d3) / 2.0, (d2 + d4) / 2.0);
        this.handle.setTrackEditTrigger(true);
        this.points = new TPoint[]{this.end1, this.end2, this.handle, this.middle};
        this.screenPoints = new Point[TapeStep.getLength()];
    }

    public TPoint getEnd1() {
        return this.end1;
    }

    public TPoint getEnd2() {
        return this.end2;
    }

    public TPoint getHandle() {
        return this.handle;
    }

    public void setEndsEnabled(boolean bl) {
        this.endsEnabled = bl;
    }

    public boolean isEndsEnabled() {
        return this.endsEnabled;
    }

    @Override
    public void setFootprint(Footprint footprint) {
        if (footprint.getLength() >= 2) {
            super.setFootprint(footprint);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Shape shape;
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        this.setHitRectCenter(n, n2);
        boolean bl = false;
        Trackable trackable = null;
        if (this.endsEnabled) {
            shape = this.end1Shapes.get(trackerPanel);
            if (shape != null && shape.intersects(hitRect)) {
                trackable = this.end1;
            }
            shape = this.end2Shapes.get(trackerPanel);
            if (trackable == null && shape != null && shape.intersects(hitRect)) {
                trackable = this.end2;
            }
        }
        shape = this.shaftShapes.get(trackerPanel);
        if (trackable == null && shape != null && shape.intersects(hitRect)) {
            trackable = this.handle;
        }
        Rectangle rectangle = this.layoutBounds.get(trackerPanel);
        if (trackable == null && rectangle != null && rectangle.intersects(hitRect)) {
            bl = true;
            trackable = this.tape;
        }
        if (bl != this.drawLayoutBounds) {
            this.drawLayoutBounds = bl;
            this.repaint(trackerPanel);
        }
        if (this.end1.isAttached() && (trackable == this.end1 || trackable == this.handle)) {
            return null;
        }
        if (this.end2.isAttached() && (trackable == this.end2 || trackable == this.handle)) {
            return null;
        }
        return trackable;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.getMark(trackerPanel).draw(graphics2D, false);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.footprint.getColor());
        if (!this.tape.editing) {
            TextLayout textLayout = this.textLayouts.get(trackerPanel);
            Point point = this.getLayoutPosition(trackerPanel, textLayout);
            Font font = graphics2D.getFont();
            graphics2D.setFont(textLayoutFont);
            textLayout.draw(graphics2D, point.x, point.y);
            graphics2D.setFont(font);
            if (this.drawLayoutBounds && this.tape.isFieldsEnabled()) {
                Rectangle rectangle = this.layoutBounds.get(trackerPanel);
                graphics2D.drawRect(rectangle.x - 2, rectangle.y - 3, rectangle.width + 5, rectangle.height + 5);
            }
        }
        graphics2D.setPaint(paint);
    }

    @Override
    public TPoint getDefaultPoint() {
        TPoint tPoint = this.tape.trackerPanel.getSelectedPoint();
        if (tPoint == this.points[0]) {
            return this.points[0];
        }
        if (tPoint == this.points[1]) {
            return this.points[1];
        }
        return this.points[this.defaultIndex];
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.marks.get(trackerPanel);
        TPoint tPoint = null;
        if (mark == null) {
            Object object;
            if (this.tape.isStickMode()) {
                this.adjustTipsToLength();
            }
            tPoint = trackerPanel.getSelectedPoint();
            Point point = null;
            int n = 0;
            while (n < this.points.length) {
                this.screenPoints[n] = this.points[n].getScreenPosition(trackerPanel);
                if (tPoint == this.points[n]) {
                    point = this.screenPoints[n];
                }
                ++n;
            }
            mark = this.footprint.getMark(this.screenPoints);
            if (point != null) {
                final Color color = this.footprint.getColor();
                final Mark mark2 = mark;
                transform.setToTranslation(point.x, point.y);
                int n2 = FontSizer.getIntegerFactor();
                if (n2 > 1) {
                    transform.scale(n2, n2);
                }
                object = transform.createTransformedShape(selectionShape);
                mark = new Mark((Shape)object){
                    private final /* synthetic */ Shape val$selectedShape;
                    {
                        this.val$selectedShape = shape;
                    }

                    @Override
                    public void draw(Graphics2D graphics2D, boolean bl) {
                        mark2.draw(graphics2D, false);
                        Paint paint = graphics2D.getPaint();
                        graphics2D.setPaint(color);
                        if (this.val$selectedShape != null) {
                            graphics2D.fill(this.val$selectedShape);
                        }
                        graphics2D.setPaint(paint);
                    }

                    @Override
                    public Rectangle getBounds(boolean bl) {
                        Rectangle rectangle = mark2.getBounds(false);
                        if (this.val$selectedShape != null) {
                            rectangle.add(this.val$selectedShape.getBounds());
                        }
                        return rectangle;
                    }
                };
            }
            this.marks.put(trackerPanel, mark);
            Shape[] shapeArray = this.footprint.getHitShapes();
            this.end1Shapes.put(trackerPanel, shapeArray[0]);
            this.end2Shapes.put(trackerPanel, shapeArray[1]);
            this.shaftShapes.put(trackerPanel, shapeArray[2]);
            double d = this.getTapeLength(!this.tape.isStickMode());
            object = this.tape.getFormattedLength(d);
            TextLayout textLayout = new TextLayout((String)object, textLayoutFont, frc);
            this.textLayouts.put(trackerPanel, textLayout);
            point = this.getLayoutPosition(trackerPanel, textLayout);
            Rectangle rectangle = this.layoutBounds.get(trackerPanel);
            if (rectangle == null) {
                rectangle = new Rectangle();
                this.layoutBounds.put(trackerPanel, rectangle);
            }
            Rectangle2D rectangle2D = textLayout.getBounds();
            rectangle.setRect(point.x, (double)point.y - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return mark;
    }

    @Override
    public Rectangle getBounds(TrackerPanel trackerPanel) {
        Rectangle rectangle = this.getMark(trackerPanel).getBounds(false);
        rectangle.add(this.layoutBounds.get(trackerPanel));
        rectangle.grow(2, 2);
        return rectangle;
    }

    public double getTapeLength(boolean bl) {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 0.0;
        if (this.tape.trackerPanel != null) {
            d = this.tape.trackerPanel.getCoords().getScaleX(this.n);
            d2 = this.tape.trackerPanel.getCoords().getScaleY(this.n);
            d3 = this.tape.trackerPanel.getCoords().getAngle(this.n);
        }
        double d4 = (this.end2.getX() - this.end1.getX()) / d;
        double d5 = (this.end1.getY() - this.end2.getY()) / d2;
        this.tapeAngle = Math.atan2(d5, d4);
        this.xAxisToTapeAngle = this.tapeAngle - d3;
        this.tape.angleField.setValue(this.xAxisToTapeAngle);
        double d6 = bl ? Math.sqrt(d4 * d4 + d5 * d5) : this.worldLength;
        this.tape.magField.setValue(d6);
        return d6;
    }

    public double getTapeAngle() {
        return this.xAxisToTapeAngle;
    }

    public void setTapeLength(double d) {
        if (this.tape.isLocked() || this.tape.trackerPanel == null) {
            return;
        }
        d = Math.abs(d);
        d = Math.max(d, 1.0E-30);
        double d2 = this.getTapeLength(!this.tape.isStickMode()) / d;
        if (d2 == 1.0) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this.tape);
        if (this.tape.isReadOnly()) {
            this.worldLength = d;
            this.adjustTipsToLength();
            this.tape.repaint(this);
            Undo.postTrackEdit(this.tape, xMLControlElement);
            return;
        }
        if (this.tape.isStickMode()) {
            if (this.tape.isFixedLength()) {
                TapeStep tapeStep = (TapeStep)this.tape.steps.getStep(0);
                tapeStep.worldLength = d;
            } else {
                this.tape.lengthKeyFrames.add(this.n);
                this.worldLength = d;
            }
        }
        double d3 = d2 * this.tape.trackerPanel.getCoords().getScaleX(this.n);
        double d4 = d2 * this.tape.trackerPanel.getCoords().getScaleY(this.n);
        XMLControlElement xMLControlElement2 = new XMLControlElement(this.tape.trackerPanel.getCoords());
        this.tape.isStepChangingScale = true;
        this.tape.trackerPanel.getCoords().setScaleXY(this.n, d3, d4);
        this.tape.isStepChangingScale = false;
        if (this.tape.isStickMode()) {
            Undo.postTrackAndCoordsEdit(this.tape, xMLControlElement, xMLControlElement2);
        } else {
            Undo.postCoordsEdit(this.tape.trackerPanel, xMLControlElement2);
        }
        this.erase();
    }

    public void setTapeAngle(double d) {
        if (this.tape.isLocked() || this.tape.trackerPanel == null) {
            return;
        }
        if (this.tape.isReadOnly()) {
            XMLControlElement xMLControlElement = new XMLControlElement(this.tape);
            this.xAxisToTapeAngle = d;
            this.adjustTipsToAngle();
            this.tape.repaint(this);
            Undo.postTrackEdit(this.tape, xMLControlElement);
            return;
        }
        double d2 = d - this.xAxisToTapeAngle;
        ImageCoordSystem imageCoordSystem = this.tape.trackerPanel.getCoords();
        XMLControlElement xMLControlElement = new XMLControlElement(imageCoordSystem);
        double d3 = imageCoordSystem.getAngle(this.n);
        imageCoordSystem.setAngle(this.n, d3 - d2);
        Undo.postCoordsEdit(this.tape.trackerPanel, xMLControlElement);
    }

    @Override
    public Object clone() {
        TapeStep tapeStep = (TapeStep)super.clone();
        if (tapeStep != null) {
            TPoint[] tPointArray = tapeStep.points;
            TapeStep tapeStep2 = tapeStep;
            tapeStep2.getClass();
            tPointArray[0] = tapeStep.end1 = tapeStep2.new Tip(this.end1.getX(), this.end1.getY());
            TPoint[] tPointArray2 = tapeStep.points;
            TapeStep tapeStep3 = tapeStep;
            tapeStep3.getClass();
            tPointArray2[1] = tapeStep.end2 = tapeStep3.new Tip(this.end2.getX(), this.end2.getY());
            TPoint[] tPointArray3 = tapeStep.points;
            TapeStep tapeStep4 = tapeStep;
            tapeStep4.getClass();
            tapeStep.handle = tapeStep4.new Handle(this.handle.getX(), this.handle.getY());
            tPointArray3[2] = tapeStep.handle;
            tapeStep.points[3] = tapeStep.middle = new TPoint(this.middle.getX(), this.middle.getY());
            tapeStep.end1.setTrackEditTrigger(true);
            tapeStep.end2.setTrackEditTrigger(true);
            tapeStep.handle.setTrackEditTrigger(true);
            tapeStep.end1Shapes = new HashMap<TrackerPanel, Shape>();
            tapeStep.end2Shapes = new HashMap<TrackerPanel, Shape>();
            tapeStep.shaftShapes = new HashMap<TrackerPanel, Shape>();
            tapeStep.textLayouts = new HashMap<TrackerPanel, TextLayout>();
            tapeStep.layoutBounds = new HashMap<TrackerPanel, Rectangle>();
            tapeStep.worldLength = this.worldLength;
        }
        return tapeStep;
    }

    @Override
    public String toString() {
        return "TapeStep " + this.n + " [" + format.format(this.end1.x) + ", " + format.format(this.end1.y) + ", " + format.format(this.end2.x) + ", " + format.format(this.end2.y) + "]";
    }

    public static int getLength() {
        return 4;
    }

    protected void adjustTipsToLength() {
        if (this.adjustingTips) {
            return;
        }
        this.adjustingTips = true;
        double d = this.end1.sin(this.end2);
        double d2 = this.end1.cos(this.end2);
        double d3 = this.end1.distance(this.end2);
        double d4 = this.worldLength / this.getTapeLength(true);
        if (d3 == 0.0) {
            d = 0.0;
            d2 = 1.0;
            d3 = 1.0;
            double d5 = this.tape.trackerPanel.getCoords().getScaleX(this.n);
            d4 = this.worldLength * d5;
        }
        TPoint tPoint = this.tape.trackerPanel.getSelectedPoint();
        if (this.end1.isAttached()) {
            tPoint = this.end1;
        } else if (this.end2.isAttached()) {
            tPoint = this.end2;
        }
        if (tPoint instanceof Tip) {
            if (tPoint == this.end1) {
                double d6 = this.end1.getX() + d2 * d3 * d4;
                double d7 = this.end1.getY() - d * d3 * d4;
                this.end2.setLocation(d6, d7);
            } else {
                double d8 = this.end2.getX() - d2 * d3 * d4;
                double d9 = this.end2.getY() + d * d3 * d4;
                this.end1.setLocation(d8, d9);
            }
        } else if (tPoint == this.handle) {
            Point point = this.handle.getScreenPosition(this.tape.trackerPanel);
            this.handle.setPositionOnLine(point.x, point.y, this.tape.trackerPanel);
            d3 = this.handle.distance(this.end1);
            if (d3 == 0.0) {
                d3 = 0.5;
            }
            double d10 = this.handle.getX() - d2 * d3 * d4;
            double d11 = this.handle.getY() + d * d3 * d4;
            this.end1.setLocation(d10, d11);
            d3 = this.handle.distance(this.end2);
            if (d3 == 0.0) {
                d3 = 0.5;
            }
            d10 = this.handle.getX() + d2 * d3 * d4;
            d11 = this.handle.getY() - d * d3 * d4;
            this.end2.setLocation(d10, d11);
        } else {
            this.middle.center(this.end1, this.end2);
            double d12 = this.middle.getX() - d2 * d3 * d4 / 2.0;
            double d13 = this.middle.getY() + d * d3 * d4 / 2.0;
            double d14 = this.middle.getX() + d2 * d3 * d4 / 2.0;
            double d15 = this.middle.getY() - d * d3 * d4 / 2.0;
            this.end1.setLocation(d12, d13);
            this.end2.setLocation(d14, d15);
        }
        this.adjustingTips = false;
    }

    protected void adjustTipsToAngle() {
        if (this.adjustingTips) {
            return;
        }
        this.adjustingTips = true;
        double d = this.tape.trackerPanel.getCoords().getAngle(this.n);
        this.tapeAngle = this.xAxisToTapeAngle + d;
        double d2 = Math.sin(this.tapeAngle);
        double d3 = Math.cos(this.tapeAngle);
        double d4 = this.end1.distance(this.end2);
        TPoint tPoint = this.tape.trackerPanel.getSelectedPoint();
        if (this.end1.isAttached()) {
            tPoint = this.end1;
        } else if (this.end2.isAttached()) {
            tPoint = this.end2;
        }
        if (tPoint instanceof Tip) {
            if (tPoint == this.end1) {
                double d5 = this.end1.getX() + d3 * d4;
                double d6 = this.end1.getY() - d2 * d4;
                this.end2.setLocation(d5, d6);
            } else {
                double d7 = this.end2.getX() - d3 * d4;
                double d8 = this.end2.getY() + d2 * d4;
                this.end1.setLocation(d7, d8);
            }
        } else if (tPoint == this.handle) {
            d4 = this.handle.distance(this.end1);
            double d9 = this.handle.getX() - d3 * d4;
            double d10 = this.handle.getY() + d2 * d4;
            this.end1.setLocation(d9, d10);
            d4 = this.handle.distance(this.end2);
            d9 = this.handle.getX() + d3 * d4;
            d10 = this.handle.getY() - d2 * d4;
            this.end2.setLocation(d9, d10);
        } else {
            this.middle.center(this.end1, this.end2);
            double d11 = this.middle.getX() - d3 * d4 / 2.0;
            double d12 = this.middle.getY() + d2 * d4 / 2.0;
            double d13 = this.middle.getX() + d3 * d4 / 2.0;
            double d14 = this.middle.getY() - d2 * d4 / 2.0;
            this.end1.setLocation(d11, d12);
            this.end2.setLocation(d13, d14);
        }
        this.adjustingTips = false;
    }

    private Point getLayoutPosition(TrackerPanel trackerPanel, TextLayout textLayout) {
        this.middle.center(this.end1, this.end2);
        Point point = this.middle.getScreenPosition(trackerPanel);
        Rectangle2D rectangle2D = textLayout.getBounds();
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        endPoint1.setLocation(this.end1);
        endPoint2.setLocation(this.end2);
        if (!trackerPanel.isDrawingInImageSpace()) {
            AffineTransform affineTransform = trackerPanel.getCoords().getToWorldTransform(this.n);
            affineTransform.transform(endPoint1, endPoint1);
            TapeStep.endPoint1.y = -TapeStep.endPoint1.y;
            affineTransform.transform(endPoint2, endPoint2);
            TapeStep.endPoint2.y = -TapeStep.endPoint2.y;
        }
        double d3 = endPoint2.cos(endPoint1);
        double d4 = endPoint2.sin(endPoint1);
        double d5 = 6.0 + Math.abs(d * d4 / 2.0) + Math.abs(d2 * d3 / 2.0);
        if (d3 >= 0.0) {
            point.setLocation((int)((double)point.x - d5 * d4 - d / 2.0), (int)((double)point.y - d5 * d3 + d2 / 2.0));
        } else {
            point.setLocation((int)((double)point.x + d5 * d4 - d / 2.0), (int)((double)point.y + d5 * d3 + d2 / 2.0));
        }
        return point;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class Handle
    extends Step.Handle {
        public Handle(double d, double d2) {
            super(TapeStep.this, d, d2);
        }

        @Override
        public void setXY(double d, double d2) {
            if (TapeStep.this.track.locked) {
                return;
            }
            double d3 = d - this.getX();
            double d4 = d2 - this.getY();
            this.setLocation(d, d2);
            if (TapeStep.this.tape.isFixedPosition()) {
                TapeStep tapeStep = (TapeStep)TapeStep.this.tape.steps.getStep(0);
                tapeStep.end1.setLocation(TapeStep.this.end1.getX() + d3, TapeStep.this.end1.getY() + d4);
                tapeStep.end2.setLocation(TapeStep.this.end2.getX() + d3, TapeStep.this.end2.getY() + d4);
                tapeStep.erase();
                TapeStep.this.tape.refreshStep(TapeStep.this);
            } else {
                TapeStep.this.end1.setLocation(TapeStep.this.end1.getX() + d3, TapeStep.this.end1.getY() + d4);
                TapeStep.this.end2.setLocation(TapeStep.this.end2.getX() + d3, TapeStep.this.end2.getY() + d4);
                TapeStep.this.tape.keyFrames.add(TapeStep.this.n);
            }
            TapeStep.this.repaint();
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return TapeStep.this.n;
        }

        @Override
        public void setPositionOnLine(int n, int n2, TrackerPanel trackerPanel) {
            this.setPositionOnLine(n, n2, trackerPanel, TapeStep.this.end1, TapeStep.this.end2);
            TapeStep.this.repaint();
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            TapeStep tapeStep = (TapeStep)object;
            double[] dArray = new double[]{tapeStep.getEnd1().x, tapeStep.getEnd1().y, tapeStep.getEnd2().x, tapeStep.getEnd2().y};
            xMLControl.setValue("end_positions", dArray);
            xMLControl.setValue("worldlength", tapeStep.worldLength);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            TapeStep tapeStep = (TapeStep)object;
            double[] dArray = (double[])xMLControl.getObject("end_positions");
            tapeStep.getEnd1().setLocation(dArray[0], dArray[1]);
            tapeStep.getEnd2().setLocation(dArray[2], dArray[3]);
            tapeStep.worldLength = xMLControl.getDouble("worldlength");
            return object;
        }
    }

    class Tip
    extends TPoint {
        private double lastX;
        private double lastY;

        public Tip(double d, double d2) {
            super(d, d2);
        }

        @Override
        public void setXY(double d, double d2) {
            Object object;
            if (TapeStep.this.track.locked) {
                return;
            }
            if (TapeStep.this.tape.isStickMode() && this.isAdjusting()) {
                this.lastX = d;
                this.lastY = d2;
            }
            if (TapeStep.this.tape.isFixedPosition()) {
                object = (TapeStep)TapeStep.this.tape.steps.getStep(0);
                if (this == TapeStep.this.end1) {
                    ((TapeStep)object).end1.setLocation(d, d2);
                    ((TapeStep)object).end2.setLocation(TapeStep.this.end2);
                } else {
                    ((TapeStep)object).end2.setLocation(d, d2);
                    ((TapeStep)object).end1.setLocation(TapeStep.this.end1);
                }
                ((Step)object).erase();
                TapeStep.this.tape.refreshStep(TapeStep.this);
            } else {
                this.setLocation(d, d2);
                TapeStep.this.tape.keyFrames.add(TapeStep.this.n);
            }
            if (TapeStep.this.tape.isStickMode()) {
                object = TapeStep.this.tape.trackerPanel.getCoords();
                ((ImageCoordSystem)object).setAdjusting(this.isAdjusting());
                double d3 = TapeStep.this.getTapeLength(true);
                double d4 = d3 / TapeStep.this.getTapeLength(false);
                double d5 = d4 * ((ImageCoordSystem)object).getScaleX(TapeStep.this.n);
                double d6 = d4 * ((ImageCoordSystem)object).getScaleY(TapeStep.this.n);
                TapeStep.this.tape.isStepChangingScale = true;
                TapeStep.this.tape.trackerPanel.getCoords().setScaleXY(TapeStep.this.n, d5, d6);
                TapeStep.this.tape.isStepChangingScale = false;
            }
            TapeStep.this.tape.dataValid = false;
            TapeStep.this.tape.firePropertyChange("data", null, TapeStep.this.tape);
            TapeStep.this.repaint();
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return TapeStep.this.n;
        }

        @Override
        public void setAdjusting(boolean bl) {
            if (TapeStep.this.tape.isStickMode()) {
                boolean bl2 = this.isAdjusting();
                super.setAdjusting(bl);
                if (bl2 && !bl) {
                    this.setXY(this.lastX, this.lastY);
                }
            } else {
                super.setAdjusting(bl);
            }
        }

        @Override
        public boolean isCoordsEditTrigger() {
            return TapeStep.this.tape.isStickMode();
        }
    }
}

