/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.opensourcephysics.cabrillo.tracker.LineProfile;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.DataRefreshTool;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.ToolsRes;

public class TableTrackView
extends TrackView {
    static final String DEFINED_AS = ": ";
    protected TableTView parentView;
    protected DataTable dataTable;
    protected JButton columnsButton;
    protected JPopupMenu popup;
    protected JPanel columnsPanel;
    protected JScrollPane columnsScroller;
    protected DatasetManager data;
    protected DatasetManager tableData;
    protected JCheckBox[] checkBoxes;
    protected JMenuItem formatDialogItem;
    protected JMenu copyDataMenu;
    protected JMenuItem copyDataRawItem;
    protected JMenuItem copyDataFormattedItem;
    protected JMenu setDelimiterMenu;
    ButtonGroup delimiterButtonGroup = new ButtonGroup();
    protected JMenuItem addDelimiterItem;
    protected JMenuItem removeDelimiterItem;
    protected JMenuItem copyImageItem;
    protected JMenuItem snapshotItem;
    protected JMenuItem printItem;
    protected JMenuItem helpItem;
    protected JMenuItem dataToolItem;
    protected JMenuItem dataBuilderItem;
    protected JMenuItem deleteDataFunctionItem;
    protected JMenuItem createTextColumnItem;
    protected JMenu textColumnMenu;
    protected JMenu deleteTextColumnMenu;
    protected JMenu renameTextColumnMenu;
    protected String xVar;
    protected String yVar;
    protected boolean refresh = true;
    protected boolean highlightVisible = true;
    protected int highlightRow;
    protected int leadCol;
    protected Font font = new JTextField().getFont();
    protected TreeSet<Double> selectedIndepVarValues = new TreeSet();
    protected Map<String, TableCellRenderer> degreeRenderers = new HashMap<String, TableCellRenderer>();
    protected TextColumnTableModel textColumnModel;
    protected TextColumnEditor textColumnEditor;
    protected Set<String> textColumnsVisible = new TreeSet<String>();
    protected ArrayList<String> textColumnNames = new ArrayList();

    public TableTrackView(TTrack tTrack, TrackerPanel trackerPanel, TableTView tableTView) {
        super(tTrack, trackerPanel);
        this.parentView = tableTView;
        tTrack.addPropertyChangeListener("text_column", this);
        this.textColumnNames.addAll(tTrack.getTextColumnNames());
        this.textColumnEditor = new TextColumnEditor();
        this.dataTable = new DataTable(){

            @Override
            public void refreshTable() {
                int[] nArray = this.getSelectedRows();
                int[] nArray2 = this.getSelectedColumns();
                super.refreshTable();
                int n = 0;
                while (n < nArray.length) {
                    if (nArray[n] < this.getRowCount()) {
                        this.addRowSelectionInterval(nArray[n], nArray[n]);
                    }
                    ++n;
                }
                n = 0;
                while (n < nArray2.length) {
                    if (nArray2[n] < this.getColumnCount()) {
                        this.addColumnSelectionInterval(nArray2[n], nArray2[n]);
                    }
                    ++n;
                }
            }

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                return TableTrackView.this.textColumnEditor;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                int n3 = TableTrackView.this.dataTable.convertColumnIndexToModel(n2);
                return TableTrackView.this.dataTable.getModel().getColumnClass(n3).equals(String.class);
            }
        };
        this.data = tTrack.getData(this.trackerPanel);
        this.tableData = new DatasetManager();
        this.tableData.setXPointsLinked(true);
        this.dataTable.add(this.tableData);
        this.textColumnModel = new TextColumnTableModel();
        this.dataTable.add(this.textColumnModel);
        this.setViewportView(this.dataTable);
        this.dataTable.setPreferredScrollableViewportSize(new Dimension(160, 200));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TableTrackView.this.dataTable.clearSelection();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                TableTrackView.this.dataTable.requestFocusInWindow();
            }
        });
        this.dataTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                TableTrackView.this.dataTable.requestFocusInWindow();
            }
        });
        this.dataTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    int n = TableTrackView.this.dataTable.getSelectedRow();
                    int n2 = TableTrackView.this.dataTable.getSelectedColumn();
                    TableTrackView.this.dataTable.editCellAt(n, n2);
                    TableTrackView.this.textColumnEditor.field.selectAll();
                    Runnable runnable = new Runnable(){

                        @Override
                        public synchronized void run() {
                            (this).TableTrackView.this.textColumnEditor.field.requestFocusInWindow();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
        ListSelectionModel listSelectionModel = this.dataTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TableTrackView.this.selectedIndepVarValues.clear();
                int[] nArray = TableTrackView.this.dataTable.getSelectedRows();
                int n = 0;
                while (n < nArray.length) {
                    double d = TableTrackView.this.getIndepVarValueAtRow(nArray[n]);
                    if (!Double.isNaN(d)) {
                        TableTrackView.this.selectedIndepVarValues.add(d);
                    }
                    ++n;
                }
            }
        });
        this.setToolTipText(ToolsRes.getString("DataToolTab.Scroller.Tooltip"));
        this.highlightVisible = !(tTrack instanceof LineProfile);
        this.createGUI();
        boolean bl = true;
        int n = 0;
        while (n < 4) {
            String string = (String)tTrack.getProperty("tableVar" + n);
            if (string != null) {
                this.setVisible(Integer.parseInt(string), true);
                bl = false;
            }
            ++n;
        }
        if (bl) {
            this.setVisible(0, true);
            this.setVisible(1, true);
        }
    }

    @Override
    public void refresh(int n) {
        Object object;
        Object object2;
        Object object3;
        if (!this.isRefreshEnabled()) {
            return;
        }
        Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " refresh " + n);
        this.track.getData(this.trackerPanel);
        this.tableData.clear();
        int n2 = 0;
        ArrayList<Dataset> arrayList = this.data.getDatasets();
        this.dataTable.setUnits(arrayList.get(0).getXColumnName(), "", this.track.getDataDescription(0));
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            if (this.checkBoxes[n4].isSelected()) {
                object3 = arrayList.get(n4);
                object2 = ((Dataset)object3).getXColumnName();
                object = ((Dataset)object3).getYColumnName();
                boolean bl = ((String)object).startsWith(Tracker.THETA) || ((String)object).startsWith(Tracker.OMEGA) || ((String)object).startsWith(Tracker.ALPHA);
                boolean bl2 = this.trackerPanel.getTFrame() != null && !this.trackerPanel.getTFrame().anglesInRadians;
                Dataset dataset = this.tableData.getDataset(n2++);
                double[] dArray = ((Dataset)object3).getYPoints();
                String string = String.valueOf(this.track.getDataDescription(n4 + 1)) + " ";
                String string2 = "";
                if (bl) {
                    if (((String)object).startsWith(Tracker.THETA)) {
                        if (bl2) {
                            string2 = "\u00ba";
                            string = String.valueOf(string) + TrackerRes.getString("TableTrackView.Degrees.Tooltip");
                        } else {
                            string = String.valueOf(string) + TrackerRes.getString("TableTrackView.Radians.Tooltip");
                        }
                    } else if (((String)object).startsWith(Tracker.OMEGA)) {
                        string = bl2 ? String.valueOf(string) + TrackerRes.getString("TableTrackView.DegreesPerSecond.Tooltip") : String.valueOf(string) + TrackerRes.getString("TableTrackView.RadiansPerSecond.Tooltip");
                    } else if (((String)object).startsWith(Tracker.ALPHA)) {
                        string = bl2 ? String.valueOf(string) + TrackerRes.getString("TableTrackView.DegreesPerSecondSquared.Tooltip") : String.valueOf(string) + TrackerRes.getString("TableTrackView.RadiansPerSecondSquared.Tooltip");
                    }
                    TableCellRenderer tableCellRenderer = this.dataTable.getPrecisionRenderer((String)object);
                    if (bl2) {
                        int n5 = 0;
                        while (n5 < dArray.length) {
                            if (!Double.isNaN(dArray[n5])) {
                                int n6 = n5;
                                dArray[n6] = dArray[n6] * 57.29577951308232;
                            }
                            ++n5;
                        }
                        if (tableCellRenderer == null) {
                            this.dataTable.setFormatPattern((String)object, "0.0");
                            this.degreeRenderers.put((String)object, this.dataTable.getPrecisionRenderer((String)object));
                        }
                    } else if (tableCellRenderer != null && tableCellRenderer == this.degreeRenderers.get(object)) {
                        this.dataTable.setFormatPattern((String)object, null);
                        this.degreeRenderers.remove(object);
                    }
                }
                if ("".equals(string.trim())) {
                    string = "";
                }
                this.dataTable.setUnits((String)object, string2, string);
                dataset.append(((Dataset)object3).getXPoints(), dArray);
                dataset.setXYColumnNames((String)object2, (String)object);
                dataset.setYColumnVisible(true);
            }
            ++n4;
        }
        n4 = n2;
        while (n4 < this.tableData.getDatasets().size()) {
            this.tableData.setYColumnVisible(n4, false);
            ++n4;
        }
        if (n2 == 0) {
            Dataset dataset = arrayList.get(0);
            object3 = dataset.getXColumnName();
            object2 = this.tableData.getDataset(n2++);
            object = dataset.getXPoints();
            ((Dataset)object2).append((double[])object, (double[])object);
            ((Dataset)object2).setXYColumnNames((String)object3, (String)object3);
            ((Dataset)object2).setYColumnVisible(false);
        }
        this.dataTable.refreshTable();
        this.setHighlighted(n);
    }

    @Override
    void refreshGUI() {
        this.columnsButton.setText(TrackerRes.getString("TableTrackView.Button.SelectTableData"));
        this.columnsButton.setToolTipText(TrackerRes.getString("TableTrackView.Button.SelectTableData.ToolTip"));
        this.track.dataValid = false;
        this.track.getData(this.trackerPanel);
        this.refreshColumnCheckboxes();
        this.refresh(this.trackerPanel.getFrameNumber());
    }

    @Override
    void dispose() {
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    @Override
    public ArrayList<Component> getToolBarComponents() {
        return this.toolbarComponents;
    }

    @Override
    public JButton getViewButton() {
        return this.columnsButton;
    }

    @Override
    public boolean isCustomState() {
        int n;
        int n2;
        int n3 = this.checkBoxes.length;
        int n4 = 0;
        while (n4 < n3) {
            n2 = this.checkBoxes[n4].isSelected();
            int n5 = n = n4 < 2 ? 1 : 0;
            if (n != 0 && n2 == 0 || n == 0 && n2 != 0) {
                return true;
            }
            ++n4;
        }
        if (this.dataTable.getFormattedColumnNames().length > 0) {
            return true;
        }
        TableColumnModel tableColumnModel = this.dataTable.getColumnModel();
        n2 = tableColumnModel.getColumnCount();
        if (n2 == 0) {
            return true;
        }
        n = tableColumnModel.getColumn(0).getModelIndex();
        int n6 = 1;
        while (n6 < n2) {
            if (tableColumnModel.getColumn(n6).getModelIndex() < n) {
                return true;
            }
            n = tableColumnModel.getColumn(n6).getModelIndex();
            ++n6;
        }
        return false;
    }

    public void setVisible(int n, boolean bl) {
        int n2;
        if (n < this.checkBoxes.length) {
            this.checkBoxes[n].setSelected(bl);
        }
        if (n >= (n2 = this.data.getDatasets().size())) {
            String string = this.track.getTextColumnNames().get(n - n2);
            this.textColumnsVisible.add(string);
        }
        this.refresh(this.trackerPanel.getFrameNumber());
    }

    public void setVisible(String string, boolean bl) {
        int n = 0;
        while (n < this.checkBoxes.length) {
            String string2 = this.checkBoxes[n].getActionCommand();
            if (string2.equals(string) || TeXParser.removeSubscripting(string2).equals(string)) {
                this.setVisible(n, bl);
                break;
            }
            ++n;
        }
    }

    protected void setHighlighted(int n) {
        this.highlightRow = -1;
        if (!this.highlightVisible) {
            return;
        }
        Step[] stepArray = this.track.getSteps();
        int n2 = -1;
        VideoClip videoClip = null;
        if (this.track.trackerPanel != null) {
            videoClip = this.track.trackerPanel.getPlayer().getVideoClip();
        }
        int n3 = 0;
        while (n3 < stepArray.length) {
            if (stepArray[n3] != null && stepArray[n3].dataVisible && videoClip != null && videoClip.includesFrame(stepArray[n3].getFrameNumber())) {
                ++n2;
                if (stepArray[n3].getFrameNumber() == n) {
                    if (n2 >= this.dataTable.getRowCount()) {
                        return;
                    }
                    this.highlightRow = n2;
                    break;
                }
            }
            ++n3;
        }
        Runnable runnable = new Runnable(){

            @Override
            public synchronized void run() {
                if (TableTrackView.this.highlightRow >= TableTrackView.this.dataTable.getRowCount() || TableTrackView.this.highlightRow < 0) {
                    TableTrackView.this.dataTable.clearSelection();
                    return;
                }
                try {
                    TableTrackView.this.dataTable.setRowSelectionInterval(TableTrackView.this.highlightRow, TableTrackView.this.highlightRow);
                }
                catch (Exception exception) {}
                int n = TableTrackView.this.dataTable.getColumnCount();
                TableTrackView.this.dataTable.setColumnSelectionInterval(0, n - 1);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    String[] getVisibleColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.checkBoxes.length) {
            if (this.checkBoxes[n].isSelected()) {
                String string = this.checkBoxes[n].getText();
                int n2 = string.indexOf(DEFINED_AS);
                if (n2 > -1) {
                    string = string.substring(0, n2);
                }
                arrayList.add(string);
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    String[] getOrderedVisibleColumns() {
        TableColumnModel tableColumnModel = this.dataTable.getColumnModel();
        Integer[] integerArray = new Integer[tableColumnModel.getColumnCount()];
        int n = 0;
        while (n < integerArray.length) {
            integerArray[n] = tableColumnModel.getColumn(n).getModelIndex();
            ++n;
        }
        String[] stringArray = this.getVisibleColumns();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = this.track.getDataName(0);
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        String[] stringArray3 = new String[stringArray2.length];
        int n2 = 0;
        while (n2 < stringArray3.length) {
            if (n2 < integerArray.length && integerArray[n2] < stringArray2.length) {
                stringArray3[n2] = stringArray2[integerArray[n2]];
            }
            ++n2;
        }
        return stringArray3;
    }

    String[][] getColumnFormats() {
        String[] stringArray = this.dataTable.getFormattedColumnNames();
        String[][] stringArray2 = new String[stringArray.length][2];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n][0] = stringArray[n];
            stringArray2[n][1] = this.dataTable.getFormatPattern(stringArray[n]);
            ++n;
        }
        return stringArray2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.parentView.columnsDialog != null && propertyChangeEvent.getPropertyName().equals("track") && propertyChangeEvent.getNewValue() == this.track) {
            this.parentView.refreshColumnsDialog(this.getTrack());
        }
        if (propertyChangeEvent.getPropertyName().equals("text_column")) {
            void var3_9;
            String string = null;
            for (String string2 : this.track.getTextColumnNames()) {
                if (this.textColumnNames.contains(string2)) continue;
                string = string2;
            }
            Object var3_8 = null;
            for (String string3 : this.textColumnNames) {
                if (this.track.getTextColumnNames().contains(string3)) continue;
                String string4 = string3;
            }
            if (string != null && var3_9 != null) {
                if (this.textColumnsVisible.contains(var3_9)) {
                    this.textColumnsVisible.remove(var3_9);
                    this.textColumnsVisible.add(string);
                }
            } else if (var3_9 != null) {
                this.textColumnsVisible.remove(var3_9);
            }
            this.dataTable.refreshTable();
            if (this.getParent() instanceof TableTView) {
                TableTView tableTView = (TableTView)this.getParent();
                tableTView.refreshColumnsDialog(this.track);
            }
            this.textColumnNames.clear();
            this.textColumnNames.addAll(this.track.getTextColumnNames());
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    public void snapshot() {
        Container container = this;
        Container container2 = this.getParent();
        while (container2 != null) {
            if (container2 instanceof TViewChooser) {
                container = container2;
                break;
            }
            container2 = container2.getParent();
        }
        TrackerIO.ComponentImage componentImage = new TrackerIO.ComponentImage(container);
        BufferedImage bufferedImage = componentImage.getImage();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n == 0 || n2 == 0) {
            return;
        }
        MeasuredImage measuredImage = new MeasuredImage(bufferedImage, 0.0, n, n2, 0.0);
        OSPFrame oSPFrame = null;
        try {
            Class<?> clazz = Class.forName("org.opensourcephysics.frames.ImageFrame");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n3 = 0;
            while (n3 < constructorArray.length) {
                Class<?>[] classArray = constructorArray[n3].getParameterTypes();
                if (classArray.length == 1 && classArray[0] == MeasuredImage.class) {
                    oSPFrame = (OSPFrame)constructorArray[n3].newInstance(measuredImage);
                    break;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (oSPFrame == null) {
            return;
        }
        oSPFrame.setTitle(DisplayRes.getString("Snapshot.Title"));
        oSPFrame.setDefaultCloseOperation(2);
        oSPFrame.setKeepHidden(false);
        FontSizer.setFonts(oSPFrame, FontSizer.getLevel());
        oSPFrame.pack();
        oSPFrame.setVisible(true);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.dataTable != null) {
            this.dataTable.setRowHeight(font.getSize() + 4);
            this.dataTable.getTableHeader().setFont(font);
        }
    }

    protected TViewChooser getOwner() {
        TFrame tFrame = this.trackerPanel.getTFrame();
        Container[] containerArray = tFrame.getViews(this.trackerPanel);
        int n = 0;
        while (n < containerArray.length) {
            TableTView tableTView;
            TrackView trackView;
            TViewChooser tViewChooser;
            if (containerArray[n] instanceof TViewChooser && (tViewChooser = (TViewChooser)containerArray[n]).getSelectedView() instanceof TableTView && (trackView = (tableTView = (TableTView)tViewChooser.getSelectedView()).getTrackView(tableTView.getSelectedTrack())).equals(this)) {
                return tViewChooser;
            }
            ++n;
        }
        return null;
    }

    protected double getIndepVarValueAtRow(int n) {
        int n2 = this.dataTable.convertColumnIndexToView(0);
        Double d = null;
        try {
            d = (Double)this.dataTable.getValueAt(n, n2);
        }
        catch (Exception exception) {}
        return d == null ? Double.NaN : d;
    }

    protected int getRowFromIndepVarValue(double d) {
        int n = this.dataTable.convertColumnIndexToView(0);
        int n2 = 0;
        while (n2 < this.dataTable.getRowCount()) {
            if (d == (Double)this.dataTable.getValueAt(n2, n)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected double[] getSelectedIndepVarValues() {
        Double[] doubleArray = this.selectedIndepVarValues.toArray(new Double[0]);
        double[] dArray = new double[doubleArray.length];
        int n = 0;
        while (n < doubleArray.length) {
            dArray[n] = doubleArray[n];
            ++n;
        }
        return dArray;
    }

    protected void setSelectedIndepVarValues(double[] dArray) {
        if (this.dataTable.getRowCount() < 1) {
            return;
        }
        this.dataTable.removeRowSelectionInterval(0, this.dataTable.getRowCount() - 1);
        int n = 0;
        while (n < dArray.length) {
            int n2 = this.getRowFromIndepVarValue(dArray[n]);
            if (n2 > -1) {
                this.dataTable.addRowSelectionInterval(n2, n2);
            }
            ++n;
        }
    }

    protected void createGUI() {
        Serializable serializable;
        Object object;
        this.columnsPanel = new JPanel();
        this.columnsPanel.setBackground(Color.WHITE);
        this.columnsPanel.setLayout(new GridLayout(0, 4));
        this.columnsScroller = new JScrollPane(this.columnsPanel);
        Border border = BorderFactory.createEmptyBorder(0, 3, 0, 2);
        Border border2 = BorderFactory.createEtchedBorder();
        this.columnsScroller.setBorder(BorderFactory.createCompoundBorder(border, border2));
        this.columnsButton = new TButton(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                Dimension dimension2 = this.getMinimumSize();
                Container container = this.getParent();
                while (container != null) {
                    if (container instanceof TViewChooser) {
                        int n = ((TViewChooser)container).chooserButton.getHeight();
                        dimension.height = Math.max(n, dimension2.height);
                        break;
                    }
                    container = container.getParent();
                }
                return dimension;
            }
        };
        this.columnsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableTrackView.this.parentView.showColumnsDialog(TableTrackView.this.getTrack());
            }
        });
        this.refreshColumnCheckboxes();
        this.popup = new JPopupMenu();
        this.deleteDataFunctionItem = new JMenuItem();
        this.deleteDataFunctionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                FunctionTool functionTool = TableTrackView.this.trackerPanel.getDataBuilder();
                FunctionPanel functionPanel = functionTool.getPanel(TableTrackView.this.track.getName());
                Dataset dataset = TableTrackView.this.data.getDataset(n);
                functionPanel.getFunctionEditor().removeObject(dataset, true);
            }
        });
        this.formatDialogItem = new JMenuItem();
        this.formatDialogItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = TableTrackView.this.getDataColumnNames();
                int[] nArray = TableTrackView.this.dataTable.getSelectedColumns();
                String[] stringArray2 = new String[nArray.length];
                int n = 0;
                while (n < stringArray2.length) {
                    String string;
                    stringArray2[n] = string = TableTrackView.this.dataTable.getColumnName(nArray[n]);
                    ++n;
                }
                DataTable.NumberFormatDialog numberFormatDialog = TableTrackView.this.dataTable.getFormatDialog(stringArray, stringArray2);
                FontSizer.setFonts(numberFormatDialog, FontSizer.getLevel());
                numberFormatDialog.pack();
                numberFormatDialog.setVisible(true);
            }
        });
        this.copyDataMenu = new JMenu();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.copyTable(TableTrackView.this.dataTable, false, TableTrackView.this.track.getName());
            }
        };
        this.copyDataRawItem = new JMenuItem(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.copyTable(TableTrackView.this.dataTable, true, TableTrackView.this.track.getName());
            }
        };
        this.copyDataFormattedItem = new JMenuItem(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.setDelimiter(actionEvent.getActionCommand());
                TableTrackView.this.refreshGUI();
            }
        };
        this.setDelimiterMenu = new JMenu(abstractAction3);
        for (String object22 : TrackerIO.delimiters.keySet()) {
            object = TrackerIO.delimiters.get(object22);
            serializable = new JRadioButtonMenuItem(object22);
            serializable.setActionCommand((String)object);
            serializable.addActionListener(abstractAction3);
            this.delimiterButtonGroup.add((AbstractButton)serializable);
        }
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TrackerIO.delimiter;
                Object object = JOptionPane.showInputDialog(TableTrackView.this, TrackerRes.getString("TableTrackView.Dialog.CustomDelimiter.Message"), TrackerRes.getString("TableTrackView.Dialog.CustomDelimiter.Title"), -1, null, null, string);
                if (object != null) {
                    String string2 = object.toString();
                    TrackerIO.setDelimiter(string2);
                    TrackerIO.addCustomDelimiter(string2);
                    TableTrackView.this.refreshGUI();
                }
            }
        };
        this.addDelimiterItem = new JMenuItem(abstractAction4);
        AbstractAction abstractAction42 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = TrackerIO.customDelimiters.values().toArray(new String[1]);
                Object object = JOptionPane.showInputDialog(TableTrackView.this, TrackerRes.getString("TableTrackView.Dialog.RemoveDelimiter.Message"), TrackerRes.getString("TableTrackView.Dialog.RemoveDelimiter.Title"), -1, null, objectArray, null);
                if (object != null) {
                    String string = object.toString();
                    TrackerIO.removeCustomDelimiter(string);
                    TableTrackView.this.refreshGUI();
                }
            }
        };
        this.removeDelimiterItem = new JMenuItem(abstractAction42);
        object = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TViewChooser tViewChooser = TableTrackView.this.getOwner();
                if (tViewChooser != null) {
                    new TrackerIO.ComponentImage(tViewChooser).copyToClipboard();
                }
            }
        };
        this.copyImageItem = new JMenuItem((Action)object);
        serializable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableTrackView.this.snapshot();
            }
        };
        this.createTextColumnItem = new JMenuItem();
        this.createTextColumnItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TableTrackView.this.getUniqueColumnName(null, false);
                TableTrackView.this.track.addTextColumn(string);
                TableTrackView.this.textColumnsVisible.add(string);
                TableTrackView.this.dataTable.refreshTable();
                if (TableTrackView.this.getParent() instanceof TableTView) {
                    TableTView tableTView = (TableTView)TableTrackView.this.getParent();
                    tableTView.refreshColumnsDialog(TableTrackView.this.track);
                }
            }
        });
        this.textColumnMenu = new JMenu();
        this.deleteTextColumnMenu = new JMenu();
        this.renameTextColumnMenu = new JMenu();
        this.snapshotItem = new JMenuItem((Action)((Object)serializable));
        this.dataBuilderItem = new JMenuItem();
        this.dataBuilderItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableTrackView.this.trackerPanel.getDataBuilder().setSelectedPanel(TableTrackView.this.track.getName());
                TableTrackView.this.trackerPanel.getDataBuilder().setVisible(true);
            }
        });
        this.dataToolItem = new JMenuItem();
        this.dataToolItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatasetManager datasetManager = new DatasetManager();
                datasetManager.setID(TableTrackView.this.data.getID());
                datasetManager.setName(TableTrackView.this.track.getName());
                datasetManager.setXPointsLinked(true);
                int n = 0;
                ArrayList<Dataset> arrayList = TableTrackView.this.data.getDatasets();
                Dataset dataset = arrayList.get(0);
                XMLControlElement xMLControlElement = new XMLControlElement(dataset);
                dataset = datasetManager.getDataset(n++);
                xMLControlElement.loadObject(dataset, true, true);
                dataset.setYColumnVisible(false);
                dataset.setConnected(false);
                dataset.setMarkerShape(0);
                int n2 = 0;
                while (n2 < TableTrackView.this.checkBoxes.length) {
                    block3: {
                        block5: {
                            block4: {
                                if (!TableTrackView.this.checkBoxes[n2].isSelected()) break block3;
                                if (n2 < arrayList.size()) break block4;
                                dataset = TableTrackView.this.track.convertTextToDataColumn(TableTrackView.this.checkBoxes[n2].getActionCommand());
                                if (dataset != null) break block5;
                                break block3;
                            }
                            dataset = arrayList.get(n2);
                        }
                        xMLControlElement = new XMLControlElement(dataset);
                        dataset = datasetManager.getDataset(n++);
                        xMLControlElement.loadObject(dataset, true, true);
                        dataset.setMarkerColor(TableTrackView.this.track.getColor());
                        dataset.setConnected(true);
                        dataset.setXColumnVisible(false);
                    }
                    ++n2;
                }
                DataTool dataTool = DataTool.getTool();
                dataTool.setUseChooser(false);
                dataTool.setSaveChangesOnClose(false);
                DataRefreshTool dataRefreshTool = DataRefreshTool.getTool(TableTrackView.this.data);
                try {
                    dataTool.send(new LocalJob(datasetManager), dataRefreshTool);
                    dataTool.setVisible(true);
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        });
        this.printItem = new JMenuItem();
        this.printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TViewChooser tViewChooser = TableTrackView.this.getOwner();
                if (tViewChooser != null) {
                    new TrackerIO.ComponentImage(tViewChooser).print();
                }
            }
        });
        this.helpItem = new JMenuItem();
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = TableTrackView.this.trackerPanel.getTFrame();
                if (tFrame != null) {
                    tFrame.showHelp("datatable", 0);
                }
            }
        });
        this.dataTable.setSelectionMode(2);
        this.dataTable.getTableHeader().setToolTipText(TrackerRes.getString("TableTrackView.Header.Tooltip"));
        this.dataTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = TableTrackView.this.dataTable.columnAtPoint(point);
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    Dataset dataset;
                    if (TableTrackView.this.dataTable.getRowCount() > 0 && TableTrackView.this.dataTable.getSelectedRowCount() == 0) {
                        TableTrackView.this.dataTable.setColumnSelectionInterval(n, n);
                        TableTrackView.this.dataTable.setRowSelectionInterval(0, TableTrackView.this.dataTable.getRowCount() - 1);
                    }
                    TableTrackView.this.deleteDataFunctionItem.setActionCommand("");
                    String string = TableTrackView.this.dataTable.getColumnName(n);
                    int n2 = TableTrackView.this.data.getDatasetIndex(string);
                    if (n2 > -1 && (dataset = TableTrackView.this.data.getDataset(n2)) instanceof DataFunction) {
                        TableTrackView.this.deleteDataFunctionItem.setActionCommand(String.valueOf(n2));
                        String string2 = TrackerRes.getString("TableTrackView.MenuItem.DeleteDataFunction");
                        TableTrackView.this.deleteDataFunctionItem.setText(String.valueOf(string2) + " \"" + string + "\"");
                    }
                    TableTrackView.this.getPopup().show(TableTrackView.this.dataTable.getTableHeader(), mouseEvent.getX(), mouseEvent.getY() + 8);
                } else if (mouseEvent.getClickCount() == 2) {
                    TableTrackView.this.dataTable.setRowSelectionInterval(0, TableTrackView.this.dataTable.getRowCount() - 1);
                    TableTrackView.this.dataTable.setColumnSelectionInterval(n, n);
                    TableTrackView.this.leadCol = n;
                    TableTrackView.this.dataTable.sort(0);
                } else if (mouseEvent.isControlDown()) {
                    if (TableTrackView.this.dataTable.isColumnSelected(n)) {
                        TableTrackView.this.dataTable.removeColumnSelectionInterval(n, n);
                    } else {
                        TableTrackView.this.dataTable.addColumnSelectionInterval(n, n);
                        if (TableTrackView.this.dataTable.getSelectedColumns().length == 1) {
                            TableTrackView.this.leadCol = n;
                        }
                    }
                } else if (mouseEvent.isShiftDown() && TableTrackView.this.dataTable.getSelectedRows().length > 0 && TableTrackView.this.leadCol < TableTrackView.this.dataTable.getColumnCount()) {
                    TableTrackView.this.dataTable.setColumnSelectionInterval(n, TableTrackView.this.leadCol);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 || OSPRuntime.isPopupTrigger(mouseEvent)) {
                    return;
                }
                double[] dArray = TableTrackView.this.getSelectedIndepVarValues();
                TableTrackView.this.setSelectedIndepVarValues(dArray);
            }
        });
        this.dataTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TableTrackView.this.dataTable.selectAll();
                }
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    Dataset dataset;
                    Point point = mouseEvent.getPoint();
                    int n = TableTrackView.this.dataTable.columnAtPoint(point);
                    TableTrackView.this.deleteDataFunctionItem.setActionCommand("");
                    String string = TableTrackView.this.dataTable.getColumnName(n);
                    int n2 = TableTrackView.this.data.getDatasetIndex(string);
                    if (n2 > -1 && (dataset = TableTrackView.this.data.getDataset(n2)) instanceof DataFunction) {
                        TableTrackView.this.deleteDataFunctionItem.setActionCommand(String.valueOf(n2));
                        String string2 = TrackerRes.getString("TableTrackView.MenuItem.DeleteDataFunction");
                        TableTrackView.this.deleteDataFunctionItem.setText(String.valueOf(string2) + " \"" + string + "\"");
                    }
                    TableTrackView.this.getPopup().show(TableTrackView.this, mouseEvent.getX() - 10, mouseEvent.getY());
                }
            }
        });
        InputMap inputMap = this.dataTable.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(67, 128);
        AbstractAction abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.copyTable(TableTrackView.this.dataTable, false, TableTrackView.this.track.getName());
            }
        };
        ActionMap actionMap = this.dataTable.getActionMap();
        actionMap.put(inputMap.get(keyStroke), abstractAction5);
        keyStroke = KeyStroke.getKeyStroke(33, 0);
        abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TableTrackView.this.trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                TableTrackView.this.trackerPanel.getPlayer().back();
            }
        };
        actionMap.put(inputMap.get(keyStroke), abstractAction5);
        keyStroke = KeyStroke.getKeyStroke(33, 64);
        abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TableTrackView.this.trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                int n = TableTrackView.this.trackerPanel.getPlayer().getStepNumber() - 5;
                TableTrackView.this.trackerPanel.getPlayer().setStepNumber(n);
            }
        };
        actionMap.put(inputMap.get(keyStroke), abstractAction5);
        keyStroke = KeyStroke.getKeyStroke(34, 0);
        abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TableTrackView.this.trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                TableTrackView.this.trackerPanel.getPlayer().step();
            }
        };
        actionMap.put(inputMap.get(keyStroke), abstractAction5);
        keyStroke = KeyStroke.getKeyStroke(34, 64);
        abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TableTrackView.this.trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                int n = TableTrackView.this.trackerPanel.getPlayer().getStepNumber() + 5;
                TableTrackView.this.trackerPanel.getPlayer().setStepNumber(n);
            }
        };
        actionMap.put(inputMap.get(keyStroke), abstractAction5);
        keyStroke = KeyStroke.getKeyStroke(36, 0);
        abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TableTrackView.this.trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                TableTrackView.this.trackerPanel.getPlayer().setStepNumber(0);
            }
        };
        actionMap.put(inputMap.get(keyStroke), abstractAction5);
        keyStroke = KeyStroke.getKeyStroke(35, 0);
        abstractAction5 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TableTrackView.this.trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                VideoClip videoClip = TableTrackView.this.trackerPanel.getPlayer().getVideoClip();
                TableTrackView.this.trackerPanel.getPlayer().setStepNumber(videoClip.getStepCount() - 1);
            }
        };
        actionMap.put(inputMap.get(keyStroke), abstractAction5);
    }

    protected JPopupMenu getPopup() {
        this.formatDialogItem.setText(ToolsRes.getString("DataToolTable.Popup.MenuItem.NumberFormat"));
        this.copyImageItem.setText(TrackerRes.getString("TMenuBar.Menu.CopyImage"));
        this.snapshotItem.setText(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"));
        this.printItem.setText(TrackerRes.getString("TActions.Action.Print"));
        this.helpItem.setText(TrackerRes.getString("Tracker.Popup.MenuItem.Help"));
        this.createTextColumnItem.setText(TrackerRes.getString("TableTrackView.Action.CreateTextColumn.Text"));
        this.textColumnMenu.setText(TrackerRes.getString("TableTrackView.Menu.TextColumn.Text"));
        this.deleteTextColumnMenu.setText(TrackerRes.getString("TableTrackView.Action.DeleteTextColumn.Text"));
        this.renameTextColumnMenu.setText(TrackerRes.getString("TableTrackView.Action.RenameTextColumn.Text"));
        this.dataBuilderItem.setText(TrackerRes.getString("TView.Menuitem.Define"));
        this.dataToolItem.setText(TrackerRes.getString("TableTrackView.Popup.MenuItem.Analyze"));
        this.refreshCopyDataMenu(this.copyDataMenu);
        this.popup.removeAll();
        if (!"".equals(this.deleteDataFunctionItem.getActionCommand())) {
            this.popup.add(this.deleteDataFunctionItem);
            this.popup.addSeparator();
        }
        this.popup.add(this.formatDialogItem);
        if (this.track != null && this.track.trackerPanel != null && this.track.trackerPanel.isEnabled("edit.copyData")) {
            this.popup.addSeparator();
            this.popup.add(this.copyDataMenu);
        }
        this.popup.addSeparator();
        this.textColumnMenu.removeAll();
        this.popup.add(this.textColumnMenu);
        this.textColumnMenu.add(this.createTextColumnItem);
        if (this.track.getTextColumnNames().size() > 0) {
            JMenuItem jMenuItem;
            this.deleteTextColumnMenu.removeAll();
            this.textColumnMenu.add(this.deleteTextColumnMenu);
            for (String string : this.track.getTextColumnNames()) {
                jMenuItem = new JMenuItem(string);
                this.deleteTextColumnMenu.add(jMenuItem);
                jMenuItem.setActionCommand(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableTrackView.this.track.removeTextColumn(actionEvent.getActionCommand());
                    }
                });
            }
            this.renameTextColumnMenu.removeAll();
            this.textColumnMenu.add(this.renameTextColumnMenu);
            for (String string : this.track.getTextColumnNames()) {
                jMenuItem = new JMenuItem(string);
                this.renameTextColumnMenu.add(jMenuItem);
                jMenuItem.setActionCommand(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = actionEvent.getActionCommand();
                        String string2 = TableTrackView.this.getUniqueColumnName(string, false);
                        if (string2 != null && !string2.equals("") && !string2.equals(string)) {
                            TableTrackView.this.track.renameTextColumn(string, string2);
                        }
                    }
                });
            }
        }
        this.textColumnMenu.setEnabled(!this.track.isLocked());
        if (this.track != null && this.track.trackerPanel != null && this.track.trackerPanel.isEnabled("edit.copyImage")) {
            this.popup.addSeparator();
            this.popup.add(this.copyImageItem);
            this.popup.add(this.snapshotItem);
        }
        if (this.track != null && this.track.trackerPanel != null && (this.track.trackerPanel.isEnabled("data.builder") || this.track.trackerPanel.isEnabled("data.tool"))) {
            this.popup.addSeparator();
            if (this.track.trackerPanel.isEnabled("data.builder")) {
                this.popup.add(this.dataBuilderItem);
            }
            if (this.track.trackerPanel.isEnabled("data.tool")) {
                this.popup.add(this.dataToolItem);
            }
        }
        if (this.track != null && this.track.trackerPanel != null && this.track.trackerPanel.isEnabled("file.print")) {
            this.popup.addSeparator();
            this.popup.add(this.printItem);
        }
        this.popup.addSeparator();
        this.popup.add(this.helpItem);
        FontSizer.setFonts(this.popup, FontSizer.getLevel());
        return this.popup;
    }

    protected String getUniqueColumnName(String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        Object object = null;
        object = bl ? JOptionPane.showInputDialog(this.track.trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("TableTrackView.Dialog.NameColumn.TryAgain")) + "\n" + TrackerRes.getString("TableTrackView.Dialog.NameColumn.Message"), TrackerRes.getString("TableTrackView.Dialog.NameColumn.Title"), 2, null, null, string) : JOptionPane.showInputDialog(this.track.trackerPanel.getTFrame(), TrackerRes.getString("TableTrackView.Dialog.NameColumn.Message"), TrackerRes.getString("TableTrackView.Dialog.NameColumn.Title"), 3, null, null, string);
        if (object == null) {
            return null;
        }
        String string2 = ((String)object).trim();
        if (string2.equals(string)) {
            return string2;
        }
        boolean bl2 = true;
        String[] stringArray = this.getDataColumnNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            if (string3.equals(string2)) {
                bl2 = false;
                break;
            }
            ++n2;
        }
        if (bl2) {
            for (String string3 : this.track.getTextColumnNames()) {
                if (!string3.equals(string2)) continue;
                bl2 = false;
                break;
            }
        }
        if (!bl2) {
            return this.getUniqueColumnName(string, true);
        }
        return string2;
    }

    protected JMenu refreshCopyDataMenu(JMenu jMenu) {
        boolean bl;
        JMenuItem jMenuItem;
        jMenu.removeAll();
        jMenu.add(this.copyDataRawItem);
        jMenu.add(this.copyDataFormattedItem);
        jMenu.addSeparator();
        jMenu.add(this.setDelimiterMenu);
        if (this.dataTable.getSelectedRowCount() == 0) {
            jMenu.setText(TrackerRes.getString("TableTrackView.Action.CopyData"));
        } else {
            jMenu.setText(TrackerRes.getString("TableTrackView.MenuItem.CopySelectedData"));
        }
        this.copyDataRawItem.setText(TrackerRes.getString("TableTrackView.MenuItem.Unformatted"));
        this.copyDataFormattedItem.setText(TrackerRes.getString("TableTrackView.MenuItem.Formatted"));
        this.setDelimiterMenu.setText(TrackerRes.getString("TableTrackView.Menu.SetDelimiter"));
        this.addDelimiterItem.setText(TrackerRes.getString("TableTrackView.MenuItem.AddDelimiter"));
        this.removeDelimiterItem.setText(TrackerRes.getString("TableTrackView.MenuItem.RemoveDelimiter"));
        this.setDelimiterMenu.removeAll();
        String string = TrackerIO.getDelimiter();
        Enumeration<AbstractButton> enumeration = this.delimiterButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            jMenuItem = (JMenuItem)enumeration.nextElement();
            String string2 = jMenuItem.getActionCommand();
            if (TrackerIO.delimiters.containsValue(string2)) continue;
            this.delimiterButtonGroup.remove(jMenuItem);
        }
        enumeration = this.delimiterButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            jMenuItem = (JMenuItem)enumeration.nextElement();
            this.setDelimiterMenu.add(jMenuItem);
            if (!string.equals(jMenuItem.getActionCommand())) continue;
            jMenuItem.setSelected(true);
        }
        boolean bl2 = bl = !TrackerIO.customDelimiters.isEmpty();
        if (bl) {
            this.setDelimiterMenu.addSeparator();
            for (String string2 : TrackerIO.customDelimiters.keySet()) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2);
                jRadioButtonMenuItem.setActionCommand(TrackerIO.customDelimiters.get(string2));
                jRadioButtonMenuItem.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TrackerIO.setDelimiter(actionEvent.getActionCommand());
                    }
                });
                this.delimiterButtonGroup.add(jRadioButtonMenuItem);
                this.setDelimiterMenu.add(jRadioButtonMenuItem);
                if (!string.equals(jRadioButtonMenuItem.getActionCommand())) continue;
                jRadioButtonMenuItem.setSelected(true);
            }
        }
        this.setDelimiterMenu.addSeparator();
        this.setDelimiterMenu.add(this.addDelimiterItem);
        if (bl) {
            this.setDelimiterMenu.add(this.removeDelimiterItem);
        }
        return jMenu;
    }

    protected String[] getDataColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Dataset dataset = this.data.getDataset(0);
        String string = dataset.getXColumnName();
        arrayList.add(string);
        ArrayList<Integer> arrayList2 = this.track.getPreferredDataOrder();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n = 0;
        while (n < arrayList2.size()) {
            dataset = this.data.getDataset(arrayList2.get(n));
            string = dataset.getYColumnName();
            arrayList.add(string);
            arrayList3.add(arrayList2.get(n));
            ++n;
        }
        n = 0;
        while (n < this.data.getDatasets().size()) {
            if (!arrayList3.contains(n)) {
                dataset = this.data.getDataset(n);
                string = dataset.getYColumnName();
                arrayList.add(string);
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    protected JScrollPane refreshColumnCheckboxes() {
        String string;
        ArrayList<JCheckBox> arrayList;
        int n;
        JCheckBox[] jCheckBoxArray = this.checkBoxes;
        int n2 = this.data.getDatasets().size();
        int n3 = this.track.getTextColumnNames().size();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (jCheckBoxArray != null) {
            n = 0;
            while (n < jCheckBoxArray.length) {
                if (jCheckBoxArray[n].isSelected()) {
                    arrayList2.add(jCheckBoxArray[n].getText());
                }
                ++n;
            }
        }
        this.checkBoxes = new JCheckBox[n2 + n3];
        n = 0;
        while (n < n2) {
            arrayList = this.data.getDataset(n);
            string = ((Dataset)((Object)arrayList)).getYColumnName();
            String string2 = TeXParser.removeSubscripting(string);
            this.checkBoxes[n] = new JCheckBox(string2);
            boolean bl = arrayList2.contains(string2) || jCheckBoxArray != null && n2 >= jCheckBoxArray.length - n3 && n < jCheckBoxArray.length - n3 && jCheckBoxArray[n].isSelected();
            this.checkBoxes[n].setBackground(Color.white);
            this.checkBoxes[n].setFont(this.font);
            this.checkBoxes[n].setSelected(bl);
            this.checkBoxes[n].setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 0));
            this.checkBoxes[n].setActionCommand(string);
            this.checkBoxes[n].setToolTipText(this.track.getDataDescription(n + 1));
            this.checkBoxes[n].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TableTrackView.this.refresh) {
                        TableTrackView.this.refresh(TableTrackView.this.trackerPanel.getFrameNumber());
                    }
                    TableTrackView.this.trackerPanel.changed = true;
                }
            });
            this.checkBoxes[n].setOpaque(false);
            ++n;
        }
        n = n2;
        while (n < n2 + n3) {
            arrayList = this.track.getTextColumnNames().get(n - n2);
            string = TeXParser.removeSubscripting(arrayList);
            this.checkBoxes[n] = new JCheckBox(string);
            this.checkBoxes[n].setBackground(Color.white);
            this.checkBoxes[n].setFont(this.font);
            this.checkBoxes[n].setSelected(this.textColumnsVisible.contains(arrayList));
            this.checkBoxes[n].setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 0));
            this.checkBoxes[n].setActionCommand((String)((Object)arrayList));
            this.checkBoxes[n].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    if (jCheckBox.isSelected()) {
                        TableTrackView.this.textColumnsVisible.add(actionEvent.getActionCommand());
                    } else {
                        TableTrackView.this.textColumnsVisible.remove(actionEvent.getActionCommand());
                    }
                    if (TableTrackView.this.refresh) {
                        TableTrackView.this.refresh(TableTrackView.this.trackerPanel.getFrameNumber());
                    }
                    TableTrackView.this.trackerPanel.changed = true;
                }
            });
            this.checkBoxes[n].setOpaque(false);
            ++n;
        }
        this.columnsPanel.removeAll();
        ArrayList<Integer> arrayList3 = this.track.getPreferredDataOrder();
        arrayList = new ArrayList<JCheckBox>();
        int n4 = 0;
        while (n4 < arrayList3.size()) {
            this.columnsPanel.add(this.checkBoxes[arrayList3.get(n4)]);
            arrayList.add(this.checkBoxes[arrayList3.get(n4)]);
            ++n4;
        }
        n4 = 0;
        while (n4 < this.checkBoxes.length) {
            if (!arrayList.contains(this.checkBoxes[n4])) {
                this.columnsPanel.add(this.checkBoxes[n4]);
            }
            ++n4;
        }
        return this.columnsScroller;
    }

    class TextColumnEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        Color defaultEditingColor;
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();

        TextColumnEditor() {
            this.defaultEditingColor = this.field.getSelectionColor();
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.field.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        TextColumnEditor.this.stopCellEditing();
                    } else if (TextColumnEditor.this.field.isEnabled()) {
                        TextColumnEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    TextColumnEditor.this.field.requestFocusInWindow();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.field.setBackground(Color.white);
            this.field.setSelectionColor(this.defaultEditingColor);
            this.field.setEditable(true);
            if (object == null) {
                object = "";
            }
            this.field.setText(object.toString());
            return this.panel;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject == null || eventObject instanceof MouseEvent) {
                return !TableTrackView.this.track.isLocked();
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            TableTrackView.this.dataTable.requestFocusInWindow();
            if (this.field.getBackground() != Color.white) {
                this.field.setBackground(Color.white);
            }
            return this.field.getText();
        }
    }

    class TextColumnTableModel
    extends AbstractTableModel {
        TextColumnTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            int n2 = 0;
            for (String string : TableTrackView.this.track.getTextColumnNames()) {
                if (!TableTrackView.this.textColumnsVisible.contains(string)) continue;
                if (n2 == n) {
                    return string;
                }
                ++n2;
            }
            return "unknown";
        }

        @Override
        public int getRowCount() {
            return TableTrackView.this.tableData.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return TableTrackView.this.textColumnsVisible.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = this.getColumnName(n2);
            DatasetManager datasetManager = TableTrackView.this.track.getData(TableTrackView.this.track.trackerPanel);
            int n3 = datasetManager.getDatasetIndex("frame");
            if (n3 > -1) {
                double d = datasetManager.getDataset(n3).getYPoints()[n];
                return TableTrackView.this.track.getTextColumnEntry(string, (int)d);
            }
            return TableTrackView.this.track.getTextColumnEntry(string, n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = this.getColumnName(n2);
            DatasetManager datasetManager = TableTrackView.this.track.getData(TableTrackView.this.track.trackerPanel);
            int n3 = datasetManager.getDatasetIndex("frame");
            if (n3 > -1) {
                double d = datasetManager.getDataset(n3).getYPoints()[n];
                if (TableTrackView.this.track.setTextColumnEntry(string, (int)d, (String)object)) {
                    TableTrackView.this.trackerPanel.changed = true;
                }
                return;
            }
            if (TableTrackView.this.track.setTextColumnEntry(string, n, (String)object)) {
                TableTrackView.this.trackerPanel.changed = true;
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return !TableTrackView.this.track.isLocked();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }
}

