/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.ArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.CenterOfMass;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.MainTView;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.PageTView;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TActions;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackControl;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.FontSizer;

public class TToolBar
extends JToolBar
implements PropertyChangeListener {
    protected static Map<TrackerPanel, TToolBar> toolbars = new HashMap<TrackerPanel, TToolBar>();
    protected static int[] trailLengths;
    protected static Icon newTrackIcon;
    protected static Icon trackControlIcon;
    protected static Icon trackControlOnIcon;
    protected static Icon zoomIcon;
    protected static Icon clipOffIcon;
    protected static Icon clipOnIcon;
    protected static Icon axesOffIcon;
    protected static Icon axesOnIcon;
    protected static Icon tapeOffIcon;
    protected static Icon tapeOnIcon;
    protected static Icon tapeOffRolloverIcon;
    protected static Icon tapeOnRolloverIcon;
    protected static Icon stickOffIcon;
    protected static Icon stickOnIcon;
    protected static Icon stickOffRolloverIcon;
    protected static Icon stickOnRolloverIcon;
    protected static Icon pointsOffIcon;
    protected static Icon pointsOnIcon;
    protected static Icon velocOffIcon;
    protected static Icon velocOnIcon;
    protected static Icon accelOffIcon;
    protected static Icon accelOnIcon;
    protected static Icon traceOffIcon;
    protected static Icon traceOnIcon;
    protected static Icon labelsOffIcon;
    protected static Icon labelsOnIcon;
    protected static Icon stretchOffIcon;
    protected static Icon stretchOnIcon;
    protected static Icon xmassOffIcon;
    protected static Icon xmassOnIcon;
    protected static Icon autotrackerOffIcon;
    protected static Icon autotrackerOnIcon;
    protected static Icon infoIcon;
    protected static Icon refreshIcon;
    protected static Icon htmlIcon;
    protected static Icon[] trailIcons;
    protected static int[] stretchValues;
    protected static Icon separatorIcon;
    protected static NumberFormat zoomFormat;
    protected TrackerPanel trackerPanel;
    protected boolean refreshing;
    protected WindowListener infoListener;
    protected int vStretch = 1;
    protected int aStretch = 1;
    protected JButton openButton;
    protected JButton openBrowserButton;
    protected JButton saveButton;
    protected JButton saveZipButton;
    protected TButton newTrackButton;
    protected JButton trackControlButton;
    protected JButton clipSettingsButton;
    protected CalibrationButton calibrationButton;
    protected JButton axesButton;
    protected JButton zoomButton;
    protected JButton autotrackerButton;
    protected JButton traceVisButton;
    protected JButton pVisButton;
    protected JButton vVisButton;
    protected JButton aVisButton;
    protected JButton xMassButton;
    protected JButton trailButton;
    protected JButton labelsButton;
    protected JButton stretchButton;
    protected int trailLength = trailLengths[trailLengths.length - 2];
    protected JPopupMenu newPopup = new JPopupMenu();
    protected JPopupMenu selectPopup = new JPopupMenu();
    protected JMenu vStretchMenu;
    protected JMenu aStretchMenu;
    protected ButtonGroup vGroup;
    protected ButtonGroup aGroup;
    protected JMenuItem showTrackControlItem;
    protected JMenuItem selectNoneItem;
    protected JMenuItem stretchOffItem;
    protected JButton notesButton;
    protected JButton refreshButton;
    protected JButton desktopButton;
    protected Component toolbarFiller;
    protected int toolbarComponentHeight;
    protected JMenu cloneMenu;
    protected boolean notYetCalibrated = true;
    protected ComponentListener clipSettingsDialogListener;
    protected JPopupMenu zoomPopup = new JPopupMenu();
    protected ArrayList<PageTView.TabData> pageViewTabs = new ArrayList();

    static {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[2] = 15;
        trailLengths = nArray;
        trailIcons = new Icon[4];
        stretchValues = new int[]{1, 2, 3, 4, 6, 8, 12, 16, 24, 32};
        zoomFormat = NumberFormat.getNumberInstance();
        newTrackIcon = new ResizableIcon(Tracker.class.getResource("resources/images/poof.gif"));
        trackControlIcon = new ResizableIcon(Tracker.class.getResource("resources/images/track_control.gif"));
        trackControlOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/track_control_on.gif"));
        zoomIcon = new ResizableIcon(Tracker.class.getResource("resources/images/zoom.gif"));
        clipOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/clip_off.gif"));
        clipOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/clip_on.gif"));
        axesOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/axes.gif"));
        axesOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/axes_on.gif"));
        tapeOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/tape.gif"));
        tapeOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/tape_on.gif"));
        tapeOffRolloverIcon = new ResizableIcon(Tracker.class.getResource("resources/images/tape_rollover.gif"));
        tapeOnRolloverIcon = new ResizableIcon(Tracker.class.getResource("resources/images/tape_on_rollover.gif"));
        stickOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/stick.gif"));
        stickOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/stick_on.gif"));
        stickOffRolloverIcon = new ResizableIcon(Tracker.class.getResource("resources/images/stick_rollover.gif"));
        stickOnRolloverIcon = new ResizableIcon(Tracker.class.getResource("resources/images/stick_on_rollover.gif"));
        pointsOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/positions.gif"));
        pointsOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/positions_on.gif"));
        velocOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/velocities.gif"));
        velocOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/velocities_on.gif"));
        accelOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/accel.gif"));
        accelOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/accel_on.gif"));
        traceOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/trace.gif"));
        traceOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/trace_on.gif"));
        labelsOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/labels.gif"));
        labelsOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/labels_on.gif"));
        stretchOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/stretch.gif"));
        stretchOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/stretch_on.gif"));
        xmassOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/x_mass.gif"));
        xmassOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/x_mass_on.gif"));
        autotrackerOffIcon = new ResizableIcon(Tracker.class.getResource("resources/images/autotrack_off.gif"));
        autotrackerOnIcon = new ResizableIcon(Tracker.class.getResource("resources/images/autotrack_on.gif"));
        infoIcon = new ResizableIcon(Tracker.class.getResource("resources/images/info.gif"));
        refreshIcon = new ResizableIcon(Tracker.class.getResource("resources/images/refresh.gif"));
        refreshIcon = new ResizableIcon(Tracker.class.getResource("resources/images/refresh.gif"));
        htmlIcon = new ResizableIcon(Tracker.class.getResource("resources/images/html.gif"));
        TToolBar.trailIcons[0] = new ResizableIcon(Tracker.class.getResource("resources/images/trails_off.gif"));
        TToolBar.trailIcons[1] = new ResizableIcon(Tracker.class.getResource("resources/images/trails_1.gif"));
        TToolBar.trailIcons[2] = new ResizableIcon(Tracker.class.getResource("resources/images/trails_2.gif"));
        TToolBar.trailIcons[3] = new ResizableIcon(Tracker.class.getResource("resources/images/trails_on.gif"));
        separatorIcon = new ResizableIcon(Tracker.class.getResource("resources/images/separator.gif"));
        zoomFormat.setMaximumFractionDigits(0);
    }

    private TToolBar(TrackerPanel trackerPanel) {
        this.trackerPanel = trackerPanel;
        this.trackerPanel.addPropertyChangeListener("track", this);
        this.trackerPanel.addPropertyChangeListener("video", this);
        this.trackerPanel.addPropertyChangeListener("magnification", this);
        this.trackerPanel.addPropertyChangeListener("selectedtrack", this);
        this.trackerPanel.addPropertyChangeListener("selectedpoint", this);
        this.createGUI();
        this.refresh(true);
        this.validate();
    }

    protected void createGUI() {
        this.setFloatable(false);
        Map<String, AbstractAction> map = TActions.getActions(this.trackerPanel);
        this.openButton = new TButton(map.get("open"));
        this.openBrowserButton = new TButton(map.get("openBrowser"));
        this.saveButton = new TButton(map.get("save"));
        this.saveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                String string = TToolBar.this.trackerPanel.getTitle();
                String string2 = XML.getExtension(string);
                if (string2 == null || !string2.equals("trk")) {
                    string = String.valueOf(XML.stripExtension(string)) + ".trk";
                }
                TToolBar.this.saveButton.setToolTipText(String.valueOf(TrackerRes.getString("TToolBar.Button.Save.Tooltip")) + " \"" + string + "\"");
            }
        });
        this.saveZipButton = new TButton(map.get("saveZip"));
        this.clipSettingsDialogListener = new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                TToolBar.this.refresh(false);
            }
        };
        this.clipSettingsButton = new TButton(clipOffIcon, clipOnIcon);
        this.clipSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame;
                ClipControl clipControl;
                VideoClip videoClip = TToolBar.this.trackerPanel.getPlayer().getVideoClip();
                ClipInspector clipInspector = videoClip.getClipInspector(clipControl = TToolBar.this.trackerPanel.getPlayer().getClipControl(), tFrame = TToolBar.this.trackerPanel.getTFrame());
                if (clipInspector.isVisible()) {
                    clipInspector.setVisible(false);
                    return;
                }
                FontSizer.setFonts(clipInspector, FontSizer.getLevel());
                clipInspector.pack();
                Point point = new Frame().getLocation();
                Point point2 = clipInspector.getLocation();
                if (point2.x == point.x && point2.y == point.y) {
                    Rectangle rectangle = TToolBar.this.trackerPanel.getVisibleRect();
                    Point point3 = tFrame.getMainView((TrackerPanel)TToolBar.this.trackerPanel).scrollPane.getLocationOnScreen();
                    int n = point3.x + (rectangle.width - clipInspector.getBounds().width) / 2;
                    int n2 = point3.y + (rectangle.height - clipInspector.getBounds().height) / 2;
                    clipInspector.setLocation(n, n2);
                }
                clipInspector.initialize();
                clipInspector.removeComponentListener(TToolBar.this.clipSettingsDialogListener);
                clipInspector.addComponentListener(TToolBar.this.clipSettingsDialogListener);
                clipInspector.setVisible(true);
                TToolBar.this.refresh(false);
            }
        });
        this.axesButton = new TButton(axesOffIcon, axesOnIcon);
        this.axesButton.addActionListener(map.get("axesVisible"));
        this.calibrationButton = new CalibrationButton();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = TToolBar.this.trackerPanel.scrollPane.getViewport().getViewRect();
                MainTView mainTView = TToolBar.this.trackerPanel.getTFrame().getMainView(TToolBar.this.trackerPanel);
                mainTView.setZoomCenter(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                String string = actionEvent.getActionCommand();
                if (string.equals("auto")) {
                    TToolBar.this.trackerPanel.setMagnification(-1.0);
                } else {
                    double d = Double.parseDouble(string);
                    TToolBar.this.trackerPanel.setMagnification(d / 100.0);
                }
                TToolBar.this.refreshZoomButton();
            }
        };
        JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.ToFit"));
        jMenuItem.setActionCommand("auto");
        jMenuItem.addActionListener(abstractAction);
        this.zoomPopup.add(jMenuItem);
        this.zoomPopup.addSeparator();
        int n = 0;
        while (n < TrackerPanel.ZOOM_LEVELS.length) {
            int n2 = (int)(100.0 * TrackerPanel.ZOOM_LEVELS[n]);
            String string = String.valueOf(n2);
            jMenuItem = new JMenuItem(String.valueOf(string) + "%");
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(abstractAction);
            this.zoomPopup.add(jMenuItem);
            ++n;
        }
        this.zoomButton = new TButton(zoomIcon){

            @Override
            protected JPopupMenu getPopup() {
                FontSizer.setFonts(TToolBar.this.zoomPopup, FontSizer.getLevel());
                return TToolBar.this.zoomPopup;
            }
        };
        this.zoomButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TToolBar.this.trackerPanel.setMagnification(-1.0);
                    TToolBar.this.zoomPopup.setVisible(false);
                    TToolBar.this.refreshZoomButton();
                }
            }
        });
        this.newTrackButton = new TButton(newTrackIcon){

            @Override
            protected JPopupMenu getPopup() {
                return TToolBar.this.getNewTracksPopup();
            }
        };
        this.trackControlButton = new TButton(trackControlIcon, trackControlOnIcon);
        this.trackControlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackControl trackControl;
                trackControl.setVisible(!(trackControl = TrackControl.getControl(TToolBar.this.trackerPanel)).isVisible());
            }
        });
        this.autotrackerButton = new TButton(autotrackerOffIcon, autotrackerOnIcon);
        this.autotrackerButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                TToolBar.this.requestFocus();
            }
        });
        this.autotrackerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TToolBar.this.autotrackerButton.setSelected(!TToolBar.this.autotrackerButton.isSelected());
                AutoTracker autoTracker = TToolBar.this.trackerPanel.getAutoTracker();
                if (autoTracker.getTrack() == null) {
                    TTrack tTrack = TToolBar.this.trackerPanel.getSelectedTrack();
                    if (tTrack == null) {
                        for (TTrack tTrack2 : TToolBar.this.trackerPanel.getTracks()) {
                            if (!tTrack2.isAutoTrackable()) continue;
                            tTrack = tTrack2;
                            break;
                        }
                    }
                    autoTracker.setTrack(tTrack);
                }
                autoTracker.getWizard().setVisible(TToolBar.this.autotrackerButton.isSelected());
                TToolBar.this.trackerPanel.repaint();
            }
        });
        final AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton;
                jButton.setSelected(!(jButton = (JButton)actionEvent.getSource()).isSelected());
                TToolBar.this.refresh(true);
            }
        };
        this.pVisButton = new TButton(pointsOffIcon, pointsOnIcon);
        this.pVisButton.setSelected(true);
        this.pVisButton.addActionListener(abstractAction2);
        this.vVisButton = new TButton(velocOffIcon, velocOnIcon);
        this.vVisButton.addActionListener(abstractAction2);
        this.aVisButton = new TButton(accelOffIcon, accelOnIcon);
        this.aVisButton.addActionListener(abstractAction2);
        this.traceVisButton = new TButton(traceOffIcon, traceOnIcon);
        this.traceVisButton.addActionListener(abstractAction2);
        this.trailButton = new TButton(){

            @Override
            protected JPopupMenu getPopup() {
                JPopupMenu jPopupMenu = new JPopupMenu();
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = Integer.parseInt(actionEvent.getActionCommand());
                        (this).TToolBar.this.trailLength = trailLengths[n];
                        (this).TToolBar.this.trailButton.setSelected((this).TToolBar.this.trailLength != 1);
                        TToolBar.this.refresh(true);
                        (this).TToolBar.this.trackerPanel.repaint();
                    }
                };
                ButtonGroup buttonGroup = new ButtonGroup();
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(TrackerRes.getString("TrackControl.TrailMenu.NoTrail"));
                jRadioButtonMenuItem.setSelected(TToolBar.this.trailLength == trailLengths[0]);
                jRadioButtonMenuItem.setActionCommand(String.valueOf(0));
                jRadioButtonMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jRadioButtonMenuItem);
                buttonGroup.add(jRadioButtonMenuItem);
                jRadioButtonMenuItem = new JRadioButtonMenuItem(TrackerRes.getString("TrackControl.TrailMenu.ShortTrail"));
                jRadioButtonMenuItem.setSelected(TToolBar.this.trailLength == trailLengths[1]);
                jRadioButtonMenuItem.setActionCommand(String.valueOf(1));
                jRadioButtonMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jRadioButtonMenuItem);
                buttonGroup.add(jRadioButtonMenuItem);
                jRadioButtonMenuItem = new JRadioButtonMenuItem(TrackerRes.getString("TrackControl.TrailMenu.LongTrail"));
                jRadioButtonMenuItem.setSelected(TToolBar.this.trailLength == trailLengths[2]);
                jRadioButtonMenuItem.setActionCommand(String.valueOf(2));
                jRadioButtonMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jRadioButtonMenuItem);
                buttonGroup.add(jRadioButtonMenuItem);
                jRadioButtonMenuItem = new JRadioButtonMenuItem(TrackerRes.getString("TrackControl.TrailMenu.FullTrail"));
                jRadioButtonMenuItem.setSelected(TToolBar.this.trailLength == trailLengths[3]);
                jRadioButtonMenuItem.setActionCommand(String.valueOf(3));
                jRadioButtonMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jRadioButtonMenuItem);
                buttonGroup.add(jRadioButtonMenuItem);
                FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                return jPopupMenu;
            }
        };
        this.trailButton.setSelected(true);
        this.labelsButton = new TButton(labelsOffIcon, labelsOnIcon);
        this.labelsButton.setSelected(true);
        this.labelsButton.addActionListener(abstractAction2);
        this.xMassButton = new TButton(xmassOffIcon, xmassOnIcon);
        this.xMassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                abstractAction2.actionPerformed(actionEvent);
                TTrack tTrack = TToolBar.this.trackerPanel.getSelectedTrack();
                if (tTrack instanceof PointMass) {
                    TToolBar.this.trackerPanel.getTFrame().getTrackBar(TToolBar.this.trackerPanel).refresh();
                }
            }
        });
        this.vStretchMenu = new JMenu();
        this.aStretchMenu = new JMenu();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                TToolBar.this.trackerPanel.setSelectedPoint(null);
                TToolBar.this.vStretch = n;
                TToolBar.this.refresh(true);
            }
        };
        this.vGroup = new ButtonGroup();
        int n3 = 0;
        while (n3 < stretchValues.length) {
            String string = String.valueOf(stretchValues[n3]);
            jMenuItem = new JRadioButtonMenuItem("x" + string);
            if (n3 == 0) {
                jMenuItem.setText(TrackerRes.getString("TrackControl.StretchVectors.None"));
            }
            jMenuItem.setActionCommand(string);
            jMenuItem.setSelected(this.vStretch == stretchValues[n3]);
            jMenuItem.addActionListener(actionListener);
            this.vStretchMenu.add(jMenuItem);
            this.vGroup.add(jMenuItem);
            ++n3;
        }
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                TToolBar.this.trackerPanel.setSelectedPoint(null);
                TToolBar.this.aStretch = n;
                TToolBar.this.refresh(true);
            }
        };
        this.aGroup = new ButtonGroup();
        int n4 = 0;
        while (n4 < stretchValues.length) {
            String string = String.valueOf(stretchValues[n4]);
            jMenuItem = new JRadioButtonMenuItem("x" + string);
            if (n4 == 0) {
                jMenuItem.setText(TrackerRes.getString("TrackControl.StretchVectors.None"));
            }
            jMenuItem.setActionCommand(string);
            jMenuItem.setSelected(this.aStretch == stretchValues[n4]);
            jMenuItem.addActionListener(actionListener2);
            this.aStretchMenu.add(jMenuItem);
            this.aGroup.add(jMenuItem);
            ++n4;
        }
        this.stretchOffItem = new JMenuItem();
        this.stretchOffItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TToolBar.this.vStretch = 1;
                TToolBar.this.aStretch = 1;
                TToolBar.this.refresh(true);
            }
        });
        this.stretchButton = new TButton(stretchOffIcon, stretchOnIcon){

            @Override
            protected JPopupMenu getPopup() {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(TToolBar.this.vStretchMenu);
                jPopupMenu.add(TToolBar.this.aStretchMenu);
                jPopupMenu.addSeparator();
                jPopupMenu.add(TToolBar.this.stretchOffItem);
                FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                return jPopupMenu;
            }
        };
        this.toolbarFiller = Box.createHorizontalGlue();
        this.infoListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TToolBar.this.notesButton.setSelected(false);
            }
        };
        this.notesButton = new TButton(infoIcon);
        this.notesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = TToolBar.this.trackerPanel.getTFrame();
                if (tFrame != null && tFrame.getTrackerPanel(tFrame.getSelectedTab()) == TToolBar.this.trackerPanel) {
                    tFrame.notesDialog.removeWindowListener(TToolBar.this.infoListener);
                    tFrame.notesDialog.addWindowListener(TToolBar.this.infoListener);
                    Point point = new Frame().getLocation();
                    if (TToolBar.this.trackerPanel.infoX != Integer.MIN_VALUE || tFrame.notesDialog.getLocation().x == point.x) {
                        int n;
                        int n2;
                        Point point2 = tFrame.getLocationOnScreen();
                        if (TToolBar.this.trackerPanel.infoX != Integer.MIN_VALUE) {
                            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                            n2 = Math.max(point2.x + TToolBar.this.trackerPanel.infoX, 0);
                            n2 = Math.min(n2, dimension.width - tFrame.notesDialog.getWidth());
                            n = Math.max(point2.y + TToolBar.this.trackerPanel.infoY, 0);
                            n = Math.min(n, dimension.height - tFrame.notesDialog.getHeight());
                            TToolBar.this.trackerPanel.infoX = Integer.MIN_VALUE;
                        } else {
                            Point point3 = TToolBar.this.getLocationOnScreen();
                            Dimension dimension = tFrame.notesDialog.getSize();
                            Dimension dimension2 = TToolBar.this.getSize();
                            n2 = point3.x + (int)(0.5 * (double)(dimension2.width - dimension.width));
                            n = point2.y + 16;
                        }
                        tFrame.notesDialog.setLocation(n2, n);
                    }
                    TToolBar.this.notesButton.setSelected(!tFrame.notesDialog.isVisible());
                    tFrame.notesDialog.setVisible(TToolBar.this.notesButton.isSelected());
                    TToolBar.this.trackerPanel.refreshNotesDialog();
                }
            }
        });
        this.refreshButton = new TButton(refreshIcon){

            @Override
            protected JPopupMenu getPopup() {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("TToolbar.Button.Refresh.Popup.RefreshNow"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        (this).TToolBar.this.trackerPanel.refreshTrackData();
                        (this).TToolBar.this.trackerPanel.eraseAll();
                        (this).TToolBar.this.trackerPanel.repaintDirtyRegion();
                    }
                });
                jPopupMenu.add(jMenuItem);
                jPopupMenu.addSeparator();
                jMenuItem = new JCheckBoxMenuItem(TrackerRes.getString("TToolbar.Button.Refresh.Popup.AutoRefresh"));
                jMenuItem.setSelected(TToolBar.this.trackerPanel.isAutoRefresh);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        (this).TToolBar.this.trackerPanel.isAutoRefresh = jMenuItem.isSelected();
                        if ((this).TToolBar.this.trackerPanel.isAutoRefresh) {
                            (this).TToolBar.this.trackerPanel.refreshTrackData();
                            (this).TToolBar.this.trackerPanel.eraseAll();
                            (this).TToolBar.this.trackerPanel.repaintDirtyRegion();
                        }
                    }
                });
                jPopupMenu.add(jMenuItem);
                FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                return jPopupMenu;
            }
        };
        this.desktopButton = new TButton(htmlIcon){

            @Override
            protected JPopupMenu getPopup() {
                JMenuItem jMenuItem;
                String string;
                String string2;
                JMenu jMenu;
                JPopupMenu jPopupMenu = new JPopupMenu();
                if (!TToolBar.this.trackerPanel.supplementalFilePaths.isEmpty()) {
                    jMenu = new JMenu(TrackerRes.getString("TToolbar.Button.Desktop.Menu.OpenFile"));
                    jPopupMenu.add(jMenu);
                    for (String object : TToolBar.this.trackerPanel.supplementalFilePaths) {
                        string2 = XML.getName(object);
                        string = object;
                        jMenuItem = new JMenuItem(string2);
                        jMenuItem.setActionCommand(string);
                        jMenuItem.setToolTipText(string);
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                String string = actionEvent.getActionCommand();
                                OSPDesktop.displayURL(string);
                            }
                        });
                        jMenu.add(jMenuItem);
                    }
                }
                if (!TToolBar.this.pageViewTabs.isEmpty()) {
                    jMenu = new JMenu(TrackerRes.getString("TToolbar.Button.Desktop.Menu.OpenPage"));
                    jPopupMenu.add(jMenu);
                    for (PageTView.TabData tabData : TToolBar.this.pageViewTabs) {
                        if (tabData.url == null) continue;
                        string2 = tabData.title;
                        string = TToolBar.this.trackerPanel.pageViewFilePaths.get(tabData.text);
                        if (string == null) {
                            string = tabData.url.toExternalForm();
                        }
                        jMenuItem = new JMenuItem(string2);
                        jMenuItem.setActionCommand(string);
                        jMenuItem.setToolTipText(string);
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                String string = actionEvent.getActionCommand();
                                OSPDesktop.displayURL(string);
                            }
                        });
                        jMenu.add(jMenuItem);
                    }
                }
                FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                return jPopupMenu;
            }
        };
        this.cloneMenu = new JMenu();
        this.showTrackControlItem = new JCheckBoxMenuItem();
        this.showTrackControlItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackControl trackControl = TrackControl.getControl(TToolBar.this.trackerPanel);
                trackControl.setVisible(TToolBar.this.showTrackControlItem.isSelected());
            }
        });
        this.selectNoneItem = new JMenuItem();
        this.selectNoneItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TToolBar.this.trackerPanel.setSelectedTrack(null);
            }
        });
    }

    protected void refreshZoomButton() {
        double d = this.trackerPanel.getMagnification() * 100.0;
        this.zoomButton.setText(String.valueOf(zoomFormat.format(d)) + "%");
    }

    protected void refresh(final boolean bl) {
        Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " refresh");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TPoint tPoint;
                int n;
                Object[] objectArray;
                Object object;
                Object object2;
                TToolBar.this.refreshing = true;
                TToolBar.this.refreshZoomButton();
                TToolBar.this.calibrationButton.refresh();
                TToolBar.this.stretchButton.setSelected(TToolBar.this.vStretch > 1 || TToolBar.this.aStretch > 1);
                TToolBar.this.stretchOffItem.setText(TrackerRes.getString("TToolBar.MenuItem.StretchOff"));
                TToolBar.this.stretchOffItem.setEnabled(TToolBar.this.vStretch > 1 || TToolBar.this.aStretch > 1);
                Enumeration<AbstractButton> enumeration = TToolBar.this.vGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    if (!((AbstractButton)object2).getActionCommand().equals(String.valueOf(TToolBar.this.vStretch))) continue;
                    ((AbstractButton)object2).setSelected(true);
                }
                enumeration = TToolBar.this.aGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    if (!((AbstractButton)object2).getActionCommand().equals(String.valueOf(TToolBar.this.aStretch))) continue;
                    ((AbstractButton)object2).setSelected(true);
                }
                TToolBar.this.vStretchMenu.setText(TrackerRes.getString("PointMass.MenuItem.Velocity"));
                TToolBar.this.aStretchMenu.setText(TrackerRes.getString("PointMass.MenuItem.Acceleration"));
                TToolBar.this.openButton.setToolTipText(TrackerRes.getString("TToolBar.Button.Open.Tooltip"));
                TToolBar.this.openBrowserButton.setToolTipText(TrackerRes.getString("TToolBar.Button.OpenBrowser.Tooltip"));
                TToolBar.this.saveZipButton.setToolTipText(TrackerRes.getString("TToolBar.Button.SaveZip.Tooltip"));
                TToolBar.this.clipSettingsButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.ClipSettings.ToolTip"));
                TToolBar.this.axesButton.setToolTipText(TrackerRes.getString("TToolbar.Button.AxesVisible.Tooltip"));
                TToolBar.this.zoomButton.setToolTipText(TrackerRes.getString("TToolBar.Button.Zoom.Tooltip"));
                TToolBar.this.notesButton.setToolTipText(TrackerRes.getString("TActions.Action.Description"));
                TToolBar.this.refreshButton.setToolTipText(TrackerRes.getString("TToolbar.Button.Refresh.Tooltip"));
                TToolBar.this.desktopButton.setToolTipText(TrackerRes.getString("TToolbar.Button.Desktop.Tooltip"));
                TToolBar.this.pVisButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Positions.ToolTip"));
                TToolBar.this.vVisButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Velocities.ToolTip"));
                TToolBar.this.aVisButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Accelerations.ToolTip"));
                TToolBar.this.xMassButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Xmass.ToolTip"));
                TToolBar.this.trailButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Trails.ToolTip"));
                TToolBar.this.labelsButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Labels.ToolTip"));
                TToolBar.this.stretchButton.setToolTipText(TrackerRes.getString("TrackControl.Button.StretchVectors.ToolTip"));
                TToolBar.this.traceVisButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Trace.ToolTip"));
                TToolBar.this.newTrackButton.setText(TrackerRes.getString("TrackControl.Button.NewTrack"));
                TToolBar.this.newTrackButton.setToolTipText(TrackerRes.getString("TrackControl.Button.NewTrack.ToolTip"));
                TToolBar.this.trackControlButton.setToolTipText(TrackerRes.getString("TToolBar.Button.TrackControl.Tooltip"));
                TToolBar.this.autotrackerButton.setToolTipText(TrackerRes.getString("TToolBar.Button.AutoTracker.Tooltip"));
                object2 = TToolBar.this.trackerPanel.getPlayer().getVideoClip();
                ClipInspector clipInspector = ((VideoClip)object2).getClipInspector();
                TToolBar.this.clipSettingsButton.setSelected(clipInspector != null && clipInspector.isVisible());
                CoordAxes coordAxes = TToolBar.this.trackerPanel.getAxes();
                if (coordAxes != null) {
                    TToolBar.this.axesButton.setSelected(coordAxes.isVisible());
                    coordAxes.removePropertyChangeListener("visible", TToolBar.this);
                    coordAxes.addPropertyChangeListener("visible", TToolBar.this);
                }
                ArrayList<TTrack> arrayList = TToolBar.this.trackerPanel.getUserTracks();
                TToolBar.this.trackControlButton.setEnabled(!arrayList.isEmpty());
                TToolBar.this.autotrackerButton.setEnabled(TToolBar.this.trackerPanel.getVideo() != null);
                double d = 0.0;
                int n2 = 0;
                for (TTrack trackable2 : arrayList) {
                    if (!(trackable2 instanceof PointMass) || trackable2 instanceof CenterOfMass || trackable2 instanceof DynamicSystem) continue;
                    object = (TView[][])trackable2;
                    d += ((PointMass)object).getMass();
                    ++n2;
                }
                if (bl) {
                    for (TTrack tTrack : TToolBar.this.trackerPanel.getTracks()) {
                        ArrowFootprint arrowFootprint;
                        tTrack.removePropertyChangeListener("locked", TToolBar.this);
                        tTrack.addPropertyChangeListener("locked", TToolBar.this);
                        tTrack.setTrailLength(TToolBar.this.trailLength);
                        tTrack.setTrailVisible(TToolBar.this.trailButton.isSelected());
                        if (tTrack instanceof PointMass) {
                            object = (PointMass)tTrack;
                            ((PointMass)object).setTraceVisible(TToolBar.this.traceVisButton.isSelected());
                            ((PointMass)object).setPositionVisible(TToolBar.this.trackerPanel, TToolBar.this.pVisButton.isSelected());
                            ((PointMass)object).setVVisible(TToolBar.this.trackerPanel, TToolBar.this.vVisButton.isSelected());
                            ((PointMass)object).setAVisible(TToolBar.this.trackerPanel, TToolBar.this.aVisButton.isSelected());
                            ((PointMass)object).setLabelsVisible(TToolBar.this.trackerPanel, TToolBar.this.labelsButton.isSelected());
                            objectArray = ((PointMass)object).getVelocityFootprints();
                            n = 0;
                            while (n < objectArray.length) {
                                if (objectArray[n] instanceof ArrowFootprint) {
                                    arrowFootprint = (ArrowFootprint)objectArray[n];
                                    if (TToolBar.this.xMassButton.isSelected()) {
                                        arrowFootprint.setStretch((double)(TToolBar.this.vStretch * n2) * ((PointMass)object).getMass() / d);
                                        arrowFootprint.setSolidHead(false);
                                    } else {
                                        arrowFootprint.setStretch(TToolBar.this.vStretch);
                                        arrowFootprint.setSolidHead(false);
                                    }
                                }
                                ++n;
                            }
                            objectArray = ((PointMass)object).getAccelerationFootprints();
                            n = 0;
                            while (n < objectArray.length) {
                                if (objectArray[n] instanceof ArrowFootprint) {
                                    arrowFootprint = (ArrowFootprint)objectArray[n];
                                    if (TToolBar.this.xMassButton.isSelected()) {
                                        arrowFootprint.setStretch((double)(TToolBar.this.aStretch * n2) * ((PointMass)object).getMass() / d);
                                        arrowFootprint.setSolidHead(true);
                                    } else {
                                        arrowFootprint.setStretch(TToolBar.this.aStretch);
                                        arrowFootprint.setSolidHead(true);
                                    }
                                }
                                ++n;
                            }
                            ((TTrack)object).repaint();
                            continue;
                        }
                        if (!(tTrack instanceof Vector)) continue;
                        object = (Vector)tTrack;
                        ((Vector)object).setLabelsVisible(TToolBar.this.labelsButton.isSelected());
                        objectArray = ((TTrack)object).getFootprints();
                        n = 0;
                        while (n < objectArray.length) {
                            if (objectArray[n] instanceof ArrowFootprint) {
                                arrowFootprint = (ArrowFootprint)objectArray[n];
                                arrowFootprint.setStretch(TToolBar.this.vStretch);
                            }
                            ++n;
                        }
                        ((TTrack)object).repaint();
                    }
                }
                if ((tPoint = TToolBar.this.trackerPanel.getSelectedPoint()) != null) {
                    tPoint.showCoordinates(TToolBar.this.trackerPanel);
                }
                int n3 = 0;
                while (n3 < trailLengths.length) {
                    if (TToolBar.this.trailLength == trailLengths[n3]) {
                        TToolBar.this.trailButton.setIcon(trailIcons[n3]);
                        FontSizer.setFonts(TToolBar.this.trailButton, FontSizer.getLevel());
                    }
                    ++n3;
                }
                TToolBar.this.pageViewTabs.clear();
                TFrame tFrame = TToolBar.this.trackerPanel.getTFrame();
                if (tFrame != null) {
                    object = tFrame.getTViews(TToolBar.this.trackerPanel);
                    TView[][] tViewArray = object;
                    int n4 = ((TView[][])object).length;
                    n = 0;
                    while (n < n4) {
                        objectArray = tViewArray[n];
                        if (objectArray != null) {
                            TView[] tViewArray2 = objectArray;
                            int n5 = objectArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                TView tView = tViewArray2[n6];
                                if (tView != null && tView instanceof PageTView) {
                                    PageTView pageTView = (PageTView)tView;
                                    for (PageTView.TabView tabView : pageTView.tabs) {
                                        if (tabView.data.url == null) continue;
                                        TToolBar.this.pageViewTabs.add(tabView.data);
                                    }
                                }
                                ++n6;
                            }
                        }
                        ++n;
                    }
                    TToolBar.this.sortPageViewTabs();
                }
                TToolBar.this.removeAll();
                if (OSPRuntime.applet == null) {
                    boolean bl4;
                    if (TToolBar.this.trackerPanel.isEnabled("file.open")) {
                        TToolBar.this.add(TToolBar.this.openButton);
                    }
                    if (TToolBar.this.trackerPanel.isEnabled("file.save")) {
                        TToolBar.this.add(TToolBar.this.saveButton);
                    }
                    boolean bl2 = bl4 = TToolBar.this.trackerPanel.isEnabled("file.library") && (TToolBar.this.trackerPanel.isEnabled("file.open") || TToolBar.this.trackerPanel.isEnabled("file.export"));
                    if (bl4 && TToolBar.this.getComponentCount() > 0) {
                        TToolBar.this.add(TToolBar.this.getSeparator());
                    }
                    if (TToolBar.this.trackerPanel.isEnabled("file.open") && TToolBar.this.trackerPanel.isEnabled("file.library")) {
                        TToolBar.this.add(TToolBar.this.openBrowserButton);
                    }
                    if (TToolBar.this.trackerPanel.isEnabled("file.export") && TToolBar.this.trackerPanel.isEnabled("file.library")) {
                        TToolBar.this.add(TToolBar.this.saveZipButton);
                    }
                }
                if (TToolBar.this.getComponentCount() > 0) {
                    TToolBar.this.add(TToolBar.this.getSeparator());
                }
                boolean bl5 = false;
                if (TToolBar.this.trackerPanel.isEnabled("button.clipSettings")) {
                    TToolBar.this.add(TToolBar.this.clipSettingsButton);
                    bl5 = true;
                }
                if (TToolBar.this.trackerPanel.isEnabled("calibration.stick") || TToolBar.this.trackerPanel.isEnabled("calibration.tape") || TToolBar.this.trackerPanel.isEnabled("calibration.points") || TToolBar.this.trackerPanel.isEnabled("calibration.offsetOrigin")) {
                    TToolBar.this.add(TToolBar.this.calibrationButton);
                    bl5 = true;
                }
                if (TToolBar.this.trackerPanel.isEnabled("button.axes")) {
                    TToolBar.this.add(TToolBar.this.axesButton);
                    bl5 = true;
                }
                if (bl5) {
                    TToolBar.this.add(TToolBar.this.getSeparator());
                }
                if (TToolBar.this.trackerPanel.isCreateTracksEnabled()) {
                    TToolBar.this.add(TToolBar.this.newTrackButton);
                }
                TToolBar.this.add(TToolBar.this.trackControlButton);
                if (TToolBar.this.trackerPanel.isEnabled("track.autotrack")) {
                    TToolBar.this.add(TToolBar.this.autotrackerButton);
                }
                TToolBar.this.add(TToolBar.this.getSeparator());
                TToolBar.this.add(TToolBar.this.zoomButton);
                TToolBar.this.add(TToolBar.this.getSeparator());
                if (TToolBar.this.trackerPanel.isEnabled("button.trails") || TToolBar.this.trackerPanel.isEnabled("button.labels")) {
                    if (TToolBar.this.trackerPanel.isEnabled("button.trails")) {
                        TToolBar.this.add(TToolBar.this.trailButton);
                    }
                    if (TToolBar.this.trackerPanel.isEnabled("button.labels")) {
                        TToolBar.this.add(TToolBar.this.labelsButton);
                    }
                    TToolBar.this.add(TToolBar.this.getSeparator());
                }
                if (TToolBar.this.trackerPanel.isEnabled("button.path") || TToolBar.this.trackerPanel.isEnabled("button.x") || TToolBar.this.trackerPanel.isEnabled("button.v") || TToolBar.this.trackerPanel.isEnabled("button.a")) {
                    if (TToolBar.this.trackerPanel.isEnabled("button.path")) {
                        TToolBar.this.add(TToolBar.this.traceVisButton);
                    }
                    if (TToolBar.this.trackerPanel.isEnabled("button.x")) {
                        TToolBar.this.add(TToolBar.this.pVisButton);
                    }
                    if (TToolBar.this.trackerPanel.isEnabled("button.v")) {
                        TToolBar.this.add(TToolBar.this.vVisButton);
                    }
                    if (TToolBar.this.trackerPanel.isEnabled("button.a")) {
                        TToolBar.this.add(TToolBar.this.aVisButton);
                    }
                    TToolBar.this.add(TToolBar.this.getSeparator());
                }
                if (TToolBar.this.trackerPanel.isEnabled("button.stretch") || TToolBar.this.trackerPanel.isEnabled("button.xMass")) {
                    if (TToolBar.this.trackerPanel.isEnabled("button.stretch")) {
                        TToolBar.this.add(TToolBar.this.stretchButton);
                    }
                    if (TToolBar.this.trackerPanel.isEnabled("button.xMass")) {
                        TToolBar.this.add(TToolBar.this.xMassButton);
                    }
                }
                TToolBar.this.add(TToolBar.this.toolbarFiller);
                TToolBar.this.add(TToolBar.this.desktopButton);
                TToolBar.this.add(TToolBar.this.notesButton);
                boolean bl3 = !TToolBar.this.pageViewTabs.isEmpty();
                TToolBar.this.desktopButton.setEnabled(bl3 || !TToolBar.this.trackerPanel.supplementalFilePaths.isEmpty());
                TToolBar.this.add(TToolBar.this.refreshButton);
                FontSizer.setFonts(TToolBar.this.newTrackButton, FontSizer.getLevel());
                FontSizer.setFonts(TToolBar.this.zoomButton, FontSizer.getLevel());
                TToolBar.this.validate();
                TToolBar.this.repaint();
                TToolBar.this.refreshing = false;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("video")) {
            this.refresh(false);
        } else if (string.equals("selectedtrack")) {
            this.trackerPanel.refreshNotesDialog();
            this.refresh(false);
        } else if (string.equals("magnification")) {
            this.refreshZoomButton();
        } else if (string.equals("visible")) {
            if (propertyChangeEvent.getSource() == this.trackerPanel.getAxes()) {
                CoordAxes coordAxes = this.trackerPanel.getAxes();
                this.axesButton.setSelected(coordAxes.isVisible());
            } else {
                this.calibrationButton.refresh();
            }
        } else if (string.equals("locked")) {
            this.refresh(false);
        } else if (string.equals("selectedpoint")) {
            this.refresh(false);
        } else if (string.equals("track")) {
            if (propertyChangeEvent.getNewValue() == null && propertyChangeEvent.getOldValue() != null) {
                TTrack tTrack = (TTrack)propertyChangeEvent.getOldValue();
                this.trackerPanel.calibrationTools.remove(tTrack);
                this.trackerPanel.visibleTools.remove(tTrack);
                tTrack.removePropertyChangeListener("visible", this);
                if (this.trackerPanel.visibleTools.isEmpty()) {
                    this.calibrationButton.setSelected(false);
                }
            }
            this.refresh(true);
        }
    }

    protected JPopupMenu getNewTracksPopup() {
        this.newPopup.removeAll();
        TMenuBar tMenuBar = TMenuBar.getMenuBar(this.trackerPanel);
        tMenuBar.refresh();
        Component[] componentArray = tMenuBar.newTrackItems;
        int n = tMenuBar.newTrackItems.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            this.newPopup.add(component);
            ++n2;
        }
        if (tMenuBar.cloneMenu.getItemCount() > 0 && this.trackerPanel.isEnabled("new.clone")) {
            this.newPopup.addSeparator();
            this.newPopup.add(tMenuBar.cloneMenu);
        }
        return this.newPopup;
    }

    private JButton getSeparator() {
        JButton jButton = new JButton(separatorIcon);
        jButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        jButton.setOpaque(false);
        jButton.setContentAreaFilled(false);
        return jButton;
    }

    private void sortPageViewTabs() {
        Collections.sort(this.pageViewTabs, new Comparator<PageTView.TabData>(){

            @Override
            public int compare(PageTView.TabData tabData, PageTView.TabData tabData2) {
                return tabData.title.toLowerCase().compareTo(tabData2.title.toLowerCase());
            }
        });
    }

    public static synchronized TToolBar getToolbar(TrackerPanel trackerPanel) {
        TToolBar tToolBar = toolbars.get(trackerPanel);
        if (tToolBar == null) {
            tToolBar = new TToolBar(trackerPanel);
            toolbars.put(trackerPanel, tToolBar);
        }
        return tToolBar;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected class CalibrationButton
    extends TButton
    implements ActionListener {
        boolean showPopup;
        JPopupMenu popup = new JPopupMenu();

        private CalibrationButton() {
            this.setIcons(tapeOffIcon, tapeOnIcon);
            this.setRolloverIcon(tapeOffRolloverIcon);
            this.setRolloverSelectedIcon(tapeOnRolloverIcon);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = stickOffRolloverIcon.getIconWidth();
                    int n2 = ((CalibrationButton)CalibrationButton.this).TToolBar.this.calibrationButton.getWidth() - n;
                    CalibrationButton.this.showPopup = mouseEvent.getX() > 18 + n2 / 2 || ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.visibleTools.isEmpty();
                }
            });
            this.addActionListener(this);
        }

        @Override
        protected JPopupMenu getPopup() {
            if (!this.showPopup) {
                return null;
            }
            this.popup.removeAll();
            for (TTrack object2 : TToolBar.this.trackerPanel.calibrationTools) {
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(object2.getName());
                jCheckBoxMenuItem.setSelected(TToolBar.this.trackerPanel.visibleTools.contains(object2));
                jCheckBoxMenuItem.setActionCommand(object2.getName());
                jCheckBoxMenuItem.addActionListener(this);
                this.popup.add(jCheckBoxMenuItem);
            }
            JMenu jMenu = this.getCalibrationToolsMenu();
            if (jMenu.getItemCount() > 0) {
                if (!TToolBar.this.trackerPanel.calibrationTools.isEmpty()) {
                    this.popup.addSeparator();
                }
                this.popup.add(jMenu);
            }
            FontSizer.setFonts(this.popup, FontSizer.getLevel());
            return this.popup;
        }

        protected JMenu getCalibrationToolsMenu() {
            JMenuItem jMenuItem;
            JMenu jMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.NewTrack"));
            if (TToolBar.this.trackerPanel.isEnabled("calibration.stick")) {
                jMenuItem = new JMenuItem(TrackerRes.getString("Stick.Name"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TapeMeasure tapeMeasure = new TapeMeasure();
                        tapeMeasure.setColor(Color.BLUE);
                        tapeMeasure.setStickMode(true);
                        String string = TrackerRes.getString("CalibrationStick.New.Name");
                        int n = ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.getAlphabetIndex(string, " ");
                        String string2 = TrackerPanel.alphabet.substring(n, n + 1);
                        tapeMeasure.setName(String.valueOf(string) + " " + string2);
                        Rectangle rectangle = ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.getMat().mat;
                        double d = rectangle.x + rectangle.width / 2;
                        double d2 = rectangle.y + rectangle.height / 2;
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.addTrack(tapeMeasure);
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.calibrationButton.setSelected(true);
                        for (TTrack tTrack : ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.visibleTools) {
                            CalibrationButton.this.showCalibrationTool(tTrack);
                        }
                        tapeMeasure.createStep(0, d - 50.0, d2 - 10.0, d + 50.0, d2 - 10.0);
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.setSelectedTrack(tapeMeasure);
                    }
                });
                jMenu.add(jMenuItem);
            }
            if (TToolBar.this.trackerPanel.isEnabled("calibration.tape")) {
                jMenuItem = new JMenuItem(TrackerRes.getString("CalibrationTapeMeasure.Name"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TapeMeasure tapeMeasure = new TapeMeasure();
                        tapeMeasure.setColor(Color.BLUE);
                        tapeMeasure.setReadOnly(false);
                        String string = TrackerRes.getString("CalibrationTapeMeasure.New.Name");
                        int n = ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.getAlphabetIndex(string, " ");
                        String string2 = TrackerPanel.alphabet.substring(n, n + 1);
                        tapeMeasure.setName(String.valueOf(string) + " " + string2);
                        Rectangle rectangle = ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.getMat().mat;
                        double d = rectangle.x + rectangle.width / 2;
                        double d2 = rectangle.y + rectangle.height / 2;
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.addTrack(tapeMeasure);
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.calibrationButton.setSelected(true);
                        for (TTrack tTrack : ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.visibleTools) {
                            CalibrationButton.this.showCalibrationTool(tTrack);
                        }
                        tapeMeasure.createStep(0, d - 50.0, d2 - 30.0, d + 50.0, d2 - 30.0);
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.setSelectedTrack(tapeMeasure);
                    }
                });
                jMenu.add(jMenuItem);
            }
            if (TToolBar.this.trackerPanel.isEnabled("calibration.points")) {
                jMenuItem = new JMenuItem(TrackerRes.getString("Calibration.Name"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Calibration calibration = new Calibration();
                        String string = TrackerRes.getString("Calibration.New.Name");
                        int n = ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.getAlphabetIndex(string, " ");
                        String string2 = TrackerPanel.alphabet.substring(n, n + 1);
                        calibration.setName(String.valueOf(string) + " " + string2);
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.addTrack(calibration);
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.calibrationButton.setSelected(true);
                        for (TTrack tTrack : ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.visibleTools) {
                            CalibrationButton.this.showCalibrationTool(tTrack);
                        }
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.setSelectedTrack(calibration);
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.getAxes().setVisible(true);
                    }
                });
                jMenu.add(jMenuItem);
            }
            if (TToolBar.this.trackerPanel.isEnabled("calibration.offsetOrigin")) {
                jMenuItem = new JMenuItem(TrackerRes.getString("OffsetOrigin.Name"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        OffsetOrigin offsetOrigin = new OffsetOrigin();
                        String string = TrackerRes.getString("OffsetOrigin.New.Name");
                        int n = ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.getAlphabetIndex(string, " ");
                        String string2 = TrackerPanel.alphabet.substring(n, n + 1);
                        offsetOrigin.setName(String.valueOf(string) + " " + string2);
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.addTrack(offsetOrigin);
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.calibrationButton.setSelected(true);
                        for (TTrack tTrack : ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.visibleTools) {
                            CalibrationButton.this.showCalibrationTool(tTrack);
                        }
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.setSelectedTrack(offsetOrigin);
                        ((CalibrationButton)CalibrationButton.this).TToolBar.this.trackerPanel.getAxes().setVisible(true);
                    }
                });
                jMenu.add(jMenuItem);
            }
            return jMenu;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == TToolBar.this.calibrationButton) {
                if (this.showPopup) {
                    return;
                }
                TToolBar.this.trackerPanel.setSelectedPoint(null);
                TToolBar.this.trackerPanel.hideMouseBox();
                if (!TToolBar.this.calibrationButton.isSelected()) {
                    TToolBar.this.calibrationButton.setSelected(true);
                    for (TTrack tTrack : TToolBar.this.trackerPanel.visibleTools) {
                        this.showCalibrationTool(tTrack);
                    }
                } else {
                    TToolBar.this.calibrationButton.setSelected(false);
                    for (TTrack tTrack : TToolBar.this.trackerPanel.calibrationTools) {
                        this.hideCalibrationTool(tTrack);
                    }
                }
                TToolBar.this.trackerPanel.repaint();
            } else {
                TToolBar.this.trackerPanel.setSelectedPoint(null);
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                for (TTrack tTrack : TToolBar.this.trackerPanel.calibrationTools) {
                    if (!actionEvent.getActionCommand().equals(tTrack.getName())) continue;
                    if (jMenuItem.isSelected()) {
                        TToolBar.this.trackerPanel.visibleTools.add(tTrack);
                        TToolBar.this.calibrationButton.setSelected(true);
                        for (TTrack tTrack2 : TToolBar.this.trackerPanel.visibleTools) {
                            this.showCalibrationTool(tTrack2);
                        }
                        continue;
                    }
                    this.hideCalibrationTool(tTrack);
                    TToolBar.this.trackerPanel.visibleTools.remove(tTrack);
                    boolean bl = false;
                    for (TTrack tTrack2 : TToolBar.this.trackerPanel.visibleTools) {
                        boolean bl2 = bl = bl || tTrack2.isVisible();
                    }
                    TToolBar.this.calibrationButton.setSelected(bl);
                }
                this.refresh();
            }
        }

        void showCalibrationTool(TTrack tTrack) {
            int n;
            Step step;
            tTrack.erase();
            tTrack.setVisible(true);
            if (tTrack instanceof Calibration) {
                int n2 = TToolBar.this.trackerPanel.getFrameNumber();
                Step step2 = tTrack.getStep(n2);
                if (step2 == null || step2.getPoints()[1] == null) {
                    TToolBar.this.trackerPanel.setSelectedTrack(tTrack);
                }
            } else if (tTrack instanceof OffsetOrigin && (step = tTrack.getStep(n = TToolBar.this.trackerPanel.getFrameNumber())) == null) {
                TToolBar.this.trackerPanel.setSelectedTrack(tTrack);
            }
        }

        void hideCalibrationTool(TTrack tTrack) {
            tTrack.setVisible(false);
            if (TToolBar.this.trackerPanel.getSelectedTrack() == tTrack) {
                TToolBar.this.trackerPanel.setSelectedTrack(null);
            }
        }

        void refresh() {
            this.setToolTipText(TrackerRes.getString("TToolbar.Button.TapeVisible.Tooltip"));
            for (TTrack tTrack : TToolBar.this.trackerPanel.calibrationTools) {
                tTrack.removePropertyChangeListener("visible", TToolBar.this);
                tTrack.addPropertyChangeListener("visible", TToolBar.this);
            }
            boolean bl = false;
            for (TTrack tTrack : TToolBar.this.trackerPanel.calibrationTools) {
                boolean bl2 = bl = bl || tTrack.isVisible();
            }
            if (TToolBar.this.notYetCalibrated && bl) {
                TToolBar.this.notYetCalibrated = false;
                this.setSelected(true);
            }
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            TToolBar tToolBar = (TToolBar)object;
            xMLControl.setValue("trace", tToolBar.traceVisButton.isSelected());
            xMLControl.setValue("position", tToolBar.pVisButton.isSelected());
            xMLControl.setValue("velocity", tToolBar.vVisButton.isSelected());
            xMLControl.setValue("acceleration", tToolBar.aVisButton.isSelected());
            xMLControl.setValue("labels", tToolBar.labelsButton.isSelected());
            xMLControl.setValue("multiply_by_mass", tToolBar.xMassButton.isSelected());
            xMLControl.setValue("trail_length", tToolBar.trailLength);
            xMLControl.setValue("stretch", tToolBar.vStretch);
            xMLControl.setValue("stretch_acceleration", tToolBar.aStretch);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            TToolBar tToolBar = (TToolBar)object;
            tToolBar.traceVisButton.setSelected(xMLControl.getBoolean("trace"));
            tToolBar.pVisButton.setSelected(xMLControl.getBoolean("position"));
            tToolBar.vVisButton.setSelected(xMLControl.getBoolean("velocity"));
            tToolBar.aVisButton.setSelected(xMLControl.getBoolean("acceleration"));
            tToolBar.labelsButton.setSelected(xMLControl.getBoolean("labels"));
            tToolBar.xMassButton.setSelected(xMLControl.getBoolean("multiply_by_mass"));
            tToolBar.trailLength = xMLControl.getInt("trail_length");
            tToolBar.vStretch = xMLControl.getInt("stretch");
            tToolBar.aStretch = xMLControl.getPropertyNames().contains("stretch_acceleration") ? xMLControl.getInt("stretch_acceleration") : tToolBar.vStretch;
            return object;
        }
    }
}

