/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.ExportDataDialog;
import org.opensourcephysics.cabrillo.tracker.ExportVideoDialog;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TActions;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TableTrackView;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.ThumbnailDialog;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.TrackControl;
import org.opensourcephysics.cabrillo.tracker.TrackPlottingPanel;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionTool;

public class TMenuBar
extends JMenuBar
implements PropertyChangeListener {
    private static Map<TrackerPanel, TMenuBar> menuBars = new HashMap<TrackerPanel, TMenuBar>();
    private static XMLControl control = new XMLControlElement();
    protected TrackerPanel trackerPanel;
    protected TFrame frame;
    protected Map<String, AbstractAction> actions;
    protected JMenu fileMenu;
    protected JMenuItem newTabItem;
    protected JMenuItem openItem;
    protected JMenuItem openURLItem;
    protected JMenuItem openBrowserItem;
    protected JMenu openRecentMenu;
    protected JMenuItem closeItem;
    protected JMenuItem closeAllItem;
    protected JMenuItem saveItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem saveZipAsItem;
    protected JMenuItem saveVideoAsItem;
    protected JMenuItem saveTabsetAsItem;
    protected JMenu importMenu;
    protected JMenuItem importVideoItem;
    protected JMenuItem importTRKItem;
    protected JMenuItem importDataItem;
    protected JMenu exportMenu;
    protected JMenuItem exportZipItem;
    protected JMenuItem exportVideoItem;
    protected JMenuItem exportTRKItem;
    protected JMenuItem exportThumbnailItem;
    protected JMenuItem exportDataItem;
    protected JMenuItem captureVideoItem;
    protected JMenuItem propertiesItem;
    protected JMenuItem printFrameItem;
    protected JMenuItem exitItem;
    protected JMenu editMenu;
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenu copyDataMenu;
    protected JMenu copyImageMenu;
    protected JMenuItem copyMainViewImageItem;
    protected JMenuItem copyFrameImageItem;
    protected JMenuItem[] copyViewImageItems;
    protected JMenu copyObjectMenu;
    protected JMenuItem pasteItem;
    protected JMenu deleteTracksMenu;
    protected JMenuItem deleteSelectedPointItem;
    protected JMenuItem clearTracksItem;
    protected JMenuItem configItem;
    protected JMenu matSizeMenu;
    protected ButtonGroup matSizeGroup;
    protected JMenu fontSizeMenu;
    protected ButtonGroup fontSizeGroup;
    protected JRadioButtonMenuItem videoSizeItem;
    protected JMenu languageMenu;
    protected JMenuItem[] languageItems;
    protected JMenuItem propsItem;
    protected JMenu videoMenu;
    protected JCheckBoxMenuItem videoVisibleItem;
    protected JMenu filtersMenu;
    protected JMenu newFilterMenu;
    protected JMenuItem clearFiltersItem;
    protected JMenuItem openVideoItem;
    protected JMenuItem closeVideoItem;
    protected JMenu pasteImageMenu;
    protected JMenuItem pasteImageItem;
    protected JMenuItem pasteReplaceItem;
    protected JMenuItem pasteImageAfterItem;
    protected JMenuItem pasteImageBeforeItem;
    protected JMenu importImageMenu;
    protected JMenuItem addImageAfterItem;
    protected JMenuItem addImageBeforeItem;
    protected JMenuItem removeImageItem;
    protected JMenuItem editVideoItem;
    protected JMenuItem playAllStepsItem;
    protected JMenuItem playXuggleSmoothlyItem;
    protected JMenuItem aboutVideoItem;
    protected JMenuItem checkDurationsItem;
    protected JMenuItem emptyVideoItem;
    protected JMenu trackMenu;
    protected JMenu createMenu;
    protected JMenu cloneMenu;
    protected JMenu measuringToolsMenu;
    protected Component[] newTrackItems;
    protected JMenuItem newPointMassItem;
    protected JMenuItem newCMItem;
    protected JMenuItem newVectorItem;
    protected JMenuItem newVectorSumItem;
    protected JMenuItem newLineProfileItem;
    protected JMenuItem newRGBRegionItem;
    protected JMenuItem newProtractorItem;
    protected JMenuItem newTapeItem;
    protected JMenuItem newCircleFitterItem;
    protected JCheckBoxMenuItem axesVisibleItem;
    protected JMenuItem newAnalyticParticleItem;
    protected JMenu newDynamicParticleMenu;
    protected JMenuItem newDynamicParticleCartesianItem;
    protected JMenuItem newDynamicParticlePolarItem;
    protected JMenuItem newDynamicSystemItem;
    protected JMenuItem newDataTrackItem;
    protected JMenuItem emptyTracksItem;
    protected JMenu coordsMenu;
    protected JCheckBoxMenuItem lockedCoordsItem;
    protected JCheckBoxMenuItem fixedOriginItem;
    protected JCheckBoxMenuItem fixedAngleItem;
    protected JCheckBoxMenuItem fixedScaleItem;
    protected JMenu refFrameMenu;
    protected ButtonGroup refFrameGroup;
    protected JRadioButtonMenuItem defaultRefFrameItem;
    protected JMenu angleUnitsMenu;
    protected JMenuItem degreesItem;
    protected JMenuItem radiansItem;
    protected JMenuItem emptyCoordsItem;
    protected JMenu windowMenu;
    protected JMenuItem restoreItem;
    protected JCheckBoxMenuItem rightPaneItem;
    protected JCheckBoxMenuItem bottomPaneItem;
    protected JMenuItem trackControlItem;
    protected JMenuItem notesItem;
    protected JMenuItem dataBuilderItem;
    protected JMenuItem dataToolItem;
    protected boolean refreshing;

    public static synchronized TMenuBar getMenuBar(TrackerPanel trackerPanel) {
        TMenuBar tMenuBar = menuBars.get(trackerPanel);
        if (tMenuBar == null) {
            tMenuBar = new TMenuBar(trackerPanel);
            menuBars.put(trackerPanel, tMenuBar);
        }
        return tMenuBar;
    }

    protected void loadVideoMenu(JMenu jMenu) {
    }

    public static void clear() {
        menuBars.clear();
    }

    private TMenuBar(TrackerPanel trackerPanel) {
        this.setTrackerPanel(trackerPanel);
        this.actions = TActions.getActions(trackerPanel);
        this.createGUI();
        this.refresh();
    }

    protected void setTrackerPanel(TrackerPanel trackerPanel) {
        if (trackerPanel == null || trackerPanel == this.trackerPanel) {
            return;
        }
        if (this.trackerPanel != null) {
            this.trackerPanel.removePropertyChangeListener("locked", this);
            this.trackerPanel.removePropertyChangeListener("track", this);
            this.trackerPanel.removePropertyChangeListener("selectedtrack", this);
            this.trackerPanel.removePropertyChangeListener("selectedpoint", this);
            this.trackerPanel.removePropertyChangeListener("video", this);
            this.trackerPanel.removePropertyChangeListener("size", this);
            this.trackerPanel.removePropertyChangeListener("datafile", this);
        }
        this.trackerPanel = trackerPanel;
        this.trackerPanel.addPropertyChangeListener("locked", this);
        this.trackerPanel.addPropertyChangeListener("track", this);
        this.trackerPanel.addPropertyChangeListener("selectedtrack", this);
        this.trackerPanel.addPropertyChangeListener("selectedpoint", this);
        this.trackerPanel.addPropertyChangeListener("video", this);
        this.trackerPanel.addPropertyChangeListener("size", this);
        this.trackerPanel.addPropertyChangeListener("datafile", this);
    }

    protected void createGUI() {
        Object object;
        Object object2;
        Object object3;
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.fileMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.File"));
        this.add(this.fileMenu);
        this.fileMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!TMenuBar.this.fileMenu.isPopupMenuVisible()) {
                    return;
                }
                TMenuBar.this.exportDataItem.setEnabled(!TMenuBar.this.getDataViews().isEmpty());
            }
        });
        if (OSPRuntime.applet == null) {
            this.newTabItem = new JMenuItem(this.actions.get("newTab"));
            this.newTabItem.setAccelerator(KeyStroke.getKeyStroke(78, n));
            this.fileMenu.addSeparator();
            this.openItem = new JMenuItem(this.actions.get("open"));
            this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
            this.openURLItem = new JMenuItem(this.actions.get("openURL"));
            this.openBrowserItem = new JMenuItem(this.actions.get("openBrowser"));
            this.openRecentMenu = new JMenu();
            this.importMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Import"));
            this.importVideoItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Video"));
            this.importVideoItem.addActionListener(this.actions.get("openVideo"));
            this.importVideoItem.setAccelerator(KeyStroke.getKeyStroke(73, n));
            this.importTRKItem = new JMenuItem(this.actions.get("import"));
            this.importDataItem = new JMenuItem(this.actions.get("importData"));
            this.importMenu.add(this.importVideoItem);
            this.importMenu.add(this.importTRKItem);
            this.importMenu.add(this.importDataItem);
            this.closeItem = new JMenuItem(this.actions.get("close"));
            this.closeAllItem = new JMenuItem(this.actions.get("closeAll"));
            this.fileMenu.addSeparator();
            this.exportMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Export"));
            this.exportZipItem = new JMenuItem(this.actions.get("saveZip"));
            this.exportZipItem.setText(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.ExportZIP")) + "...");
            this.exportMenu.add(this.exportZipItem);
            this.exportVideoItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.VideoClip")) + "...");
            this.exportVideoItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExportVideoDialog exportVideoDialog = ExportVideoDialog.getDialog(TMenuBar.this.trackerPanel);
                    exportVideoDialog.setVisible(true);
                }
            });
            this.exportMenu.add(this.exportVideoItem);
            this.exportTRKItem = new JMenuItem(this.actions.get("export"));
            this.exportMenu.add(this.exportTRKItem);
            this.exportThumbnailItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.Thumbnail")) + "...");
            this.exportThumbnailItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ThumbnailDialog thumbnailDialog = ThumbnailDialog.getDialog(TMenuBar.this.trackerPanel, true);
                    thumbnailDialog.setVisible(true);
                }
            });
            this.exportMenu.add(this.exportThumbnailItem);
            this.exportDataItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Data"));
            this.exportDataItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExportDataDialog exportDataDialog = ExportDataDialog.getDialog(TMenuBar.this.trackerPanel);
                    exportDataDialog.setVisible(true);
                }
            });
            this.exportMenu.add(this.exportDataItem);
            this.fileMenu.addSeparator();
            this.saveItem = new JMenuItem(this.actions.get("save"));
            this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, n));
            this.saveAsItem = new JMenuItem(this.actions.get("saveAs"));
            this.saveZipAsItem = new JMenuItem(this.actions.get("saveZip"));
            this.saveVideoAsItem = new JMenuItem(this.actions.get("saveVideo"));
            this.saveTabsetAsItem = new JMenuItem(this.actions.get("saveTabsetAs"));
            this.fileMenu.addSeparator();
        }
        this.propertiesItem = new JMenuItem(this.actions.get("properties"));
        this.printFrameItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.PrintFrame"));
        this.printFrameItem.setAccelerator(KeyStroke.getKeyStroke(80, n));
        this.printFrameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = TMenuBar.this.trackerPanel.getTFrame();
                new TrackerIO.ComponentImage(tFrame).print();
            }
        });
        if (OSPRuntime.applet == null) {
            this.exitItem = new JMenuItem(this.actions.get("exit"));
            this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        }
        this.editMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Edit"));
        this.editMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Object object2;
                Object object3;
                Object object4;
                Container[] containerArray;
                Object object5;
                if (!TMenuBar.this.editMenu.isPopupMenuVisible()) {
                    return;
                }
                Step step = TMenuBar.this.trackerPanel.getSelectedStep();
                TTrack tTrack = TMenuBar.this.trackerPanel.getSelectedTrack();
                boolean bl = tTrack == null || tTrack.isLocked() || tTrack.isDependent();
                TMenuBar.this.deleteSelectedPointItem.setEnabled(!bl && step != null);
                String string = TMenuBar.this.actions.get("paste").getValue("Name").toString();
                TMenuBar.this.pasteItem.setText(string);
                TMenuBar.this.pasteItem.setEnabled(false);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(null);
                if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        object5 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        control.readXML((String)object5);
                        containerArray = control.getObjectClass();
                        if (control.failedToRead()) {
                            object4 = DataTool.parseData((String)object5, null);
                            if (object4 != null) {
                                object3 = null;
                                object2 = null;
                                for (Dataset object6 : ((DatasetManager)object4).getDatasets()) {
                                    if (object6.getYColumnName().equals("x")) {
                                        object3 = object6.getYPoints();
                                        continue;
                                    }
                                    if (!object6.getYColumnName().equals("y")) continue;
                                    object2 = object6.getYPoints();
                                }
                                if (object3 != null && object2 != null) {
                                    void var13_21;
                                    String string2 = ((DatasetManager)object4).getName();
                                    if (string2 == null || string2.trim().equals("")) {
                                        String string3 = TrackerRes.getString("ParticleDataTrack.New.Name");
                                    }
                                    String string4 = var13_21.replaceAll("_", " ");
                                    TMenuBar.this.pasteItem.setEnabled(true);
                                    TMenuBar.this.pasteItem.setText(String.valueOf(string) + " " + string4);
                                }
                            }
                        } else if (TTrack.class.isAssignableFrom((Class<?>)containerArray)) {
                            TMenuBar.this.pasteItem.setEnabled(true);
                            object4 = control.getString("name");
                            TMenuBar.this.pasteItem.setText(String.valueOf(string) + " " + object4);
                        } else if (ImageCoordSystem.class.isAssignableFrom((Class<?>)containerArray)) {
                            TMenuBar.this.pasteItem.setEnabled(true);
                            TMenuBar.this.pasteItem.setText(String.valueOf(string) + " " + TrackerRes.getString("TMenuBar.MenuItem.Coords"));
                        } else if (VideoClip.class.isAssignableFrom((Class<?>)containerArray)) {
                            TMenuBar.this.pasteItem.setEnabled(true);
                            TMenuBar.this.pasteItem.setText(String.valueOf(string) + " " + TrackerRes.getString("TMenuBar.MenuItem.VideoClip"));
                        }
                    }
                    catch (Exception exception) {}
                }
                object5 = TMenuBar.this.getDataViews();
                TMenuBar.this.copyDataMenu.removeAll();
                TMenuBar.this.copyDataMenu.setEnabled(!((AbstractMap)object5).isEmpty());
                if (((AbstractMap)object5).isEmpty()) {
                    TMenuBar.this.copyDataMenu.setText(TrackerRes.getString("TableTrackView.Action.CopyData"));
                } else if (((TreeMap)object5).size() == 1) {
                    containerArray = (Integer)((TreeMap)object5).firstKey();
                    object4 = (TableTrackView)((TreeMap)object5).get(containerArray);
                    ((TableTrackView)object4).refreshCopyDataMenu(TMenuBar.this.copyDataMenu);
                    object3 = TMenuBar.this.copyDataMenu.getText();
                    TMenuBar.this.copyDataMenu.setText(String.valueOf(object3) + " (" + containerArray + ")");
                } else {
                    TMenuBar.this.copyDataMenu.setText(TrackerRes.getString("TableTrackView.Action.CopyData"));
                    object4 = ((TreeMap)object5).keySet().iterator();
                    while (object4.hasNext()) {
                        int n = (Integer)object4.next();
                        object3 = (TableTrackView)((TreeMap)object5).get(n);
                        object2 = new JMenu();
                        TMenuBar.this.copyDataMenu.add(((TableTrackView)object3).refreshCopyDataMenu((JMenu)object2));
                        String string5 = ((AbstractButton)object2).getText();
                        ((AbstractButton)object2).setText(String.valueOf(string5) + " (" + n + ")");
                    }
                }
                TMenuBar.this.copyImageMenu.remove(TMenuBar.this.copyFrameImageItem);
                containerArray = TMenuBar.this.trackerPanel.getTFrame().getViews(TMenuBar.this.trackerPanel);
                if (TMenuBar.this.copyViewImageItems.length != containerArray.length) {
                    object4 = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = Integer.parseInt(actionEvent.getActionCommand());
                            new TrackerIO.ComponentImage(containerArray[n]).copyToClipboard();
                        }
                    };
                    TMenuBar.this.copyViewImageItems = new JMenuItem[containerArray.length];
                    int n = 0;
                    while (n < containerArray.length) {
                        TMenuBar.this.copyViewImageItems[n] = new JMenuItem();
                        object2 = String.valueOf(n);
                        TMenuBar.this.copyViewImageItems[n].setActionCommand((String)object2);
                        TMenuBar.this.copyViewImageItems[n].setAction((Action)object4);
                        ++n;
                    }
                }
                int n = 0;
                while (n < containerArray.length) {
                    if (TMenuBar.this.trackerPanel.getTFrame().isViewOpen(n, TMenuBar.this.trackerPanel)) {
                        String string2 = null;
                        if (containerArray[n] instanceof TViewChooser) {
                            object2 = (TViewChooser)containerArray[n];
                            string2 = ((TViewChooser)object2).getSelectedView().getViewName();
                        } else {
                            string2 = TrackerRes.getString("TFrame.View.Unknown");
                        }
                        TMenuBar.this.copyViewImageItems[n].setText(String.valueOf(string2) + " (" + (n + 1) + ")");
                        object2 = String.valueOf(n);
                        TMenuBar.this.copyViewImageItems[n].setActionCommand((String)object2);
                        TMenuBar.this.copyImageMenu.add(TMenuBar.this.copyViewImageItems[n]);
                    } else {
                        TMenuBar.this.copyImageMenu.remove(TMenuBar.this.copyViewImageItems[n]);
                    }
                    ++n;
                }
                TMenuBar.this.copyImageMenu.add(TMenuBar.this.copyFrameImageItem);
                FontSizer.setFonts(TMenuBar.this.editMenu, FontSizer.getLevel());
                TMenuBar.this.editMenu.revalidate();
            }
        });
        this.add(this.editMenu);
        this.undoItem = new JMenuItem();
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, n));
        this.undoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TMenuBar.this.trackerPanel.setSelectedPoint(null);
                Undo.undo(TMenuBar.this.trackerPanel);
            }
        });
        this.redoItem = new JMenuItem();
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, n));
        this.redoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Undo.redo(TMenuBar.this.trackerPanel);
                TMenuBar.this.trackerPanel.setSelectedPoint(null);
            }
        });
        this.pasteItem = this.editMenu.add(this.actions.get("paste"));
        this.pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, n));
        this.editMenu.addSeparator();
        this.copyDataMenu = new JMenu();
        this.copyImageMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.CopyImage"));
        this.copyFrameImageItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CopyFrame"));
        this.copyFrameImageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = TMenuBar.this.trackerPanel.getTFrame();
                new TrackerIO.ComponentImage(tFrame).copyToClipboard();
            }
        });
        this.copyMainViewImageItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.CopyMainView")) + " (0)");
        this.copyMainViewImageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new TrackerIO.ComponentImage(TMenuBar.this.trackerPanel).copyToClipboard();
            }
        });
        this.copyImageMenu.add(this.copyMainViewImageItem);
        this.copyViewImageItems = new JMenuItem[0];
        this.copyObjectMenu = new JMenu();
        this.pasteImageMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.PasteImage"));
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Image image = TrackerIO.getClipboardImage();
                if (image != null) {
                    ImageVideo imageVideo = new ImageVideo(image);
                    TMenuBar.this.trackerPanel.setVideo(imageVideo);
                }
            }
        };
        this.pasteImageItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.PasteImage"));
        this.pasteImageItem.addActionListener(abstractAction);
        this.editVideoItem = new JCheckBoxMenuItem(new AbstractAction(TrackerRes.getString("TMenuBar.MenuItem.EditVideoFrames")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block23: {
                    Video video = TMenuBar.this.trackerPanel.getVideo();
                    if (video != null && video instanceof ImageVideo) {
                        boolean bl = TMenuBar.this.editVideoItem.isSelected();
                        if (!bl) {
                            ImageVideo imageVideo = (ImageVideo)video;
                            try {
                                imageVideo.setEditable(false);
                                TMenuBar.this.refresh();
                                TTrackBar.refreshMemoryButton();
                            }
                            catch (Exception exception) {
                                Toolkit.getDefaultToolkit().beep();
                            }
                        } else {
                            String string = TrackerRes.getString("TMenuBar.Dialog.RequiresMemory.Message1");
                            string = String.valueOf(string) + "\n" + TrackerRes.getString("TMenuBar.Dialog.RequiresMemory.Message2");
                            int n = JOptionPane.showConfirmDialog(TMenuBar.this.trackerPanel.getTFrame(), string, TrackerRes.getString("TMenuBar.Dialog.RequiresMemory.Title"), 2, 1);
                            if (n == 0) {
                                boolean bl2 = false;
                                ImageVideo imageVideo = (ImageVideo)video;
                                try {
                                    imageVideo.setEditable(true);
                                    TMenuBar.this.refresh();
                                    TTrackBar.refreshMemoryButton();
                                }
                                catch (Exception exception) {
                                    Toolkit.getDefaultToolkit().beep();
                                    bl2 = true;
                                    if (!bl2) break block23;
                                    try {
                                        imageVideo.setEditable(false);
                                    }
                                    catch (Exception exception2) {
                                    }
                                    catch (Error error) {}
                                    System.gc();
                                    TMenuBar.this.refresh();
                                    TTrackBar.refreshMemoryButton();
                                    break block23;
                                }
                                catch (Error error) {
                                    try {
                                        Toolkit.getDefaultToolkit().beep();
                                        bl2 = true;
                                        throw error;
                                    }
                                    catch (Throwable throwable) {
                                        if (bl2) {
                                            try {
                                                imageVideo.setEditable(false);
                                            }
                                            catch (Exception exception) {
                                            }
                                            catch (Error error2) {}
                                            System.gc();
                                            TMenuBar.this.refresh();
                                            TTrackBar.refreshMemoryButton();
                                        }
                                        throw throwable;
                                    }
                                }
                                if (!bl2) break block23;
                                try {
                                    imageVideo.setEditable(false);
                                }
                                catch (Exception exception) {
                                }
                                catch (Error error) {}
                                System.gc();
                                TMenuBar.this.refresh();
                                TTrackBar.refreshMemoryButton();
                            } else {
                                TMenuBar.this.editVideoItem.setSelected(false);
                            }
                        }
                    }
                }
            }
        });
        this.pasteReplaceItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.PasteReplace"));
        this.pasteReplaceItem.addActionListener(abstractAction);
        this.pasteImageAfterItem = new JMenuItem(new AbstractAction(TrackerRes.getString("TMenuBar.MenuItem.PasteAfter")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Image image = TrackerIO.getClipboardImage();
                if (image != null) {
                    int n = TMenuBar.this.trackerPanel.getFrameNumber();
                    ImageVideo imageVideo = (ImageVideo)TMenuBar.this.trackerPanel.getVideo();
                    imageVideo.insert(image, n + 1);
                    VideoClip videoClip = TMenuBar.this.trackerPanel.getPlayer().getVideoClip();
                    videoClip.setStepCount(imageVideo.getFrameCount());
                    TMenuBar.this.trackerPanel.getPlayer().setStepNumber(videoClip.frameToStep(n + 1));
                    TMenuBar.this.refresh();
                }
            }
        });
        this.pasteImageBeforeItem = new JMenuItem(new AbstractAction(TrackerRes.getString("TMenuBar.MenuItem.PasteBefore")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Image image = TrackerIO.getClipboardImage();
                if (image != null) {
                    int n = TMenuBar.this.trackerPanel.getFrameNumber();
                    ImageVideo imageVideo = (ImageVideo)TMenuBar.this.trackerPanel.getVideo();
                    imageVideo.insert(image, n);
                    VideoClip videoClip = TMenuBar.this.trackerPanel.getPlayer().getVideoClip();
                    videoClip.setStepCount(imageVideo.getFrameCount());
                    TMenuBar.this.trackerPanel.getPlayer().setStepNumber(videoClip.frameToStep(n));
                    TMenuBar.this.refresh();
                }
            }
        });
        this.pasteImageMenu.add(this.pasteReplaceItem);
        this.deleteSelectedPointItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.DeleteSelectedPoint"));
        this.deleteSelectedPointItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TMenuBar.this.trackerPanel.deletePoint(TMenuBar.this.trackerPanel.getSelectedPoint());
            }
        });
        this.deleteTracksMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.DeleteTrack"));
        this.editMenu.add(this.deleteTracksMenu);
        this.editMenu.addSeparator();
        this.clearTracksItem = this.deleteTracksMenu.add(this.actions.get("clearTracks"));
        this.configItem = this.editMenu.add(this.actions.get("config"));
        this.matSizeMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.MatSize"));
        String[] stringArray = new String[]{"320x240", "480x360", "640x480", "800x600", "960x720", "1280x960"};
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                int n = string.indexOf("x");
                double d = Double.parseDouble(string.substring(0, n));
                double d2 = Double.parseDouble(string.substring(n + 1));
                TMenuBar.this.trackerPanel.setImageSize(d, d2);
            }
        };
        this.matSizeGroup = new ButtonGroup();
        this.fontSizeMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.FontSize"));
        this.fontSizeGroup = new ButtonGroup();
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                FontSizer.setLevel(n);
            }
        };
        int n2 = 0;
        while (n2 < 6) {
            object3 = n2 == 0 ? TrackerRes.getString("TMenuBar.MenuItem.DefaultFontSize") : "+" + n2;
            object2 = new JRadioButtonMenuItem((String)object3);
            ((AbstractButton)object2).addActionListener(abstractAction3);
            ((AbstractButton)object2).setActionCommand(String.valueOf(n2));
            this.fontSizeMenu.add((JMenuItem)object2);
            this.fontSizeGroup.add((AbstractButton)object2);
            if (n2 == FontSizer.getLevel()) {
                ((AbstractButton)object2).setSelected(true);
            }
            ++n2;
        }
        this.videoSizeItem = new JRadioButtonMenuItem();
        this.videoSizeItem.setActionCommand("0x0");
        this.videoSizeItem.addActionListener(abstractAction2);
        this.matSizeGroup.add(this.videoSizeItem);
        n2 = 0;
        while (n2 < stringArray.length) {
            object3 = new JRadioButtonMenuItem(stringArray[n2]);
            ((AbstractButton)object3).setActionCommand(stringArray[n2]);
            ((AbstractButton)object3).addActionListener(abstractAction2);
            this.matSizeGroup.add((AbstractButton)object3);
            ++n2;
        }
        this.languageMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.Language"));
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                int n = 0;
                while (n < Tracker.locales.length) {
                    if (string.equals(Tracker.locales[n].toString())) {
                        TrackerRes.setLocale(Tracker.locales[n]);
                        return;
                    }
                    ++n;
                }
            }
        };
        object3 = new ButtonGroup();
        this.languageItems = new JMenuItem[Tracker.locales.length];
        object2 = TrackerRes.locale.toString();
        if (((String)object2).startsWith("en_")) {
            object2 = "en";
        }
        int n3 = 0;
        while (n3 < this.languageItems.length) {
            object = OSPRuntime.getDisplayLanguage(Tracker.locales[n3]);
            if (Tracker.locales[n3].getLanguage().equals("pt")) {
                object = String.valueOf(object) + " (" + Tracker.locales[n3].getCountry() + ")";
            }
            this.languageItems[n3] = new JRadioButtonMenuItem((String)object);
            this.languageItems[n3].setActionCommand(Tracker.locales[n3].toString());
            this.languageItems[n3].addActionListener(abstractAction4);
            ((ButtonGroup)object3).add(this.languageItems[n3]);
            if (Tracker.locales[n3].toString().equals(object2)) {
                this.languageItems[n3].setSelected(true);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.languageItems.length) {
            this.languageMenu.add(this.languageItems[n3]);
            ++n3;
        }
        this.createMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.NewTrack"));
        this.newPointMassItem = new JMenuItem(this.actions.get("pointMass"));
        this.newCMItem = new JMenuItem(this.actions.get("cm"));
        this.newVectorItem = new JMenuItem(this.actions.get("vector"));
        this.newVectorSumItem = new JMenuItem(this.actions.get("vectorSum"));
        this.newLineProfileItem = new JMenuItem(this.actions.get("lineProfile"));
        this.newRGBRegionItem = new JMenuItem(this.actions.get("rgbRegion"));
        this.newProtractorItem = new JMenuItem(this.actions.get("protractor"));
        this.newTapeItem = new JMenuItem(this.actions.get("tape"));
        this.newCircleFitterItem = new JMenuItem(this.actions.get("circleFitter"));
        this.cloneMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.Clone"));
        this.measuringToolsMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.MeasuringTools"));
        this.videoMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Video"));
        this.videoMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(null);
                boolean bl = transferable != null && transferable.isDataFlavorSupported(DataFlavor.imageFlavor);
                TMenuBar.this.pasteImageMenu.setEnabled(bl);
                TMenuBar.this.pasteImageItem.setEnabled(bl);
                Video video = TMenuBar.this.trackerPanel.getVideo();
                if (video != null) {
                    Component component;
                    TMenuBar.this.videoVisibleItem.setSelected(video.isVisible());
                    boolean bl2 = TMenuBar.this.trackerPanel.isEnabled("video.filters");
                    boolean bl3 = true;
                    int n = 0;
                    while (n < TMenuBar.this.videoMenu.getItemCount()) {
                        component = TMenuBar.this.videoMenu.getItem(n);
                        if (component == TMenuBar.this.filtersMenu) {
                            bl3 = false;
                        }
                        ++n;
                    }
                    if (bl3 && bl2) {
                        TMenuBar.this.videoMenu.remove(TMenuBar.this.checkDurationsItem);
                        TMenuBar.this.videoMenu.remove(TMenuBar.this.aboutVideoItem);
                        n = TMenuBar.this.videoMenu.getMenuComponentCount() - 1;
                        while (n >= 0) {
                            component = TMenuBar.this.videoMenu.getMenuComponent(n);
                            if (component instanceof JMenuItem) break;
                            TMenuBar.this.videoMenu.remove(component);
                            --n;
                        }
                        TMenuBar.this.videoMenu.addSeparator();
                        TMenuBar.this.videoMenu.add(TMenuBar.this.filtersMenu);
                        TMenuBar.this.videoMenu.addSeparator();
                        TMenuBar.this.videoMenu.remove(TMenuBar.this.checkDurationsItem);
                        TMenuBar.this.videoMenu.add(TMenuBar.this.aboutVideoItem);
                    }
                }
                TMenuBar.this.videoMenu.revalidate();
            }
        });
        this.add(this.videoMenu);
        this.openVideoItem = this.videoMenu.add(this.actions.get("openVideo"));
        this.closeVideoItem = this.videoMenu.add(this.actions.get("closeVideo"));
        this.importImageMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.AddImage"));
        this.addImageAfterItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.AddAfter"));
        this.addImageAfterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TMenuBar.this.trackerPanel.getFrameNumber();
                int n2 = TMenuBar.this.trackerPanel.getPlayer().getStepNumber();
                File[] fileArray = TrackerIO.insertImagesIntoVideo(TMenuBar.this.trackerPanel, n + 1);
                if (fileArray != null) {
                    String[] stringArray = new String[fileArray.length];
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        stringArray[n3] = fileArray[n3].getPath();
                        ++n3;
                    }
                    Undo.postImageVideoEdit(TMenuBar.this.trackerPanel, stringArray, n + 1, n2, true);
                }
                TMenuBar.this.refresh();
            }
        });
        this.addImageBeforeItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.AddBefore"));
        this.addImageBeforeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TMenuBar.this.trackerPanel.getFrameNumber();
                int n2 = TMenuBar.this.trackerPanel.getPlayer().getStepNumber();
                File[] fileArray = TrackerIO.insertImagesIntoVideo(TMenuBar.this.trackerPanel, n);
                if (fileArray != null) {
                    String[] stringArray = new String[fileArray.length];
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        stringArray[n3] = fileArray[n3].getPath();
                        ++n3;
                    }
                    Undo.postImageVideoEdit(TMenuBar.this.trackerPanel, stringArray, n, n2, true);
                }
                TMenuBar.this.refresh();
            }
        });
        this.importImageMenu.add(this.addImageBeforeItem);
        this.importImageMenu.add(this.addImageAfterItem);
        this.removeImageItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.RemoveImage"));
        this.removeImageItem.setAccelerator(KeyStroke.getKeyStroke(82, n));
        this.removeImageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageVideo imageVideo = (ImageVideo)TMenuBar.this.trackerPanel.getVideo();
                int n = TMenuBar.this.trackerPanel.getFrameNumber();
                String string = imageVideo.remove(n);
                int n2 = imageVideo.getFrameCount();
                VideoClip videoClip = TMenuBar.this.trackerPanel.getPlayer().getVideoClip();
                videoClip.setStepCount(n2);
                int n3 = Math.min(n, n2 - 1);
                n3 = videoClip.frameToStep(n3);
                TMenuBar.this.trackerPanel.getPlayer().setStepNumber(n3);
                if (string != null && !string.equals("")) {
                    Undo.postImageVideoEdit(TMenuBar.this.trackerPanel, new String[]{string}, n, n3, false);
                }
                TMenuBar.this.refresh();
            }
        });
        this.playAllStepsItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.PlayAllSteps"), true);
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        this.playAllStepsItem.setSelected(videoClip.isPlayAllSteps());
        this.playAllStepsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPlayer videoPlayer = TMenuBar.this.trackerPanel.getPlayer();
                VideoClip videoClip = videoPlayer.getVideoClip();
                videoClip.setPlayAllSteps(TMenuBar.this.playAllStepsItem.isSelected());
                videoPlayer.setVideoClip(videoClip);
            }
        });
        this.videoVisibleItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.VideoVisible"));
        this.videoVisibleItem.setSelected(true);
        this.videoVisibleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Video video = TMenuBar.this.trackerPanel.getVideo();
                if (video == null) {
                    return;
                }
                if (itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) {
                    boolean bl = TMenuBar.this.videoVisibleItem.isSelected();
                    video.setVisible(bl);
                    TMenuBar.this.trackerPanel.setVideo(video);
                }
            }
        });
        this.playXuggleSmoothlyItem = new JCheckBoxMenuItem(TrackerRes.getString("XuggleVideo.MenuItem.SmoothPlay"));
        this.playXuggleSmoothlyItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Video video = TMenuBar.this.trackerPanel.getVideo();
                String string = "org.opensourcephysics.media.xuggle.XuggleVideo";
                if (video == null || !video.getClass().getName().equals(string)) {
                    return;
                }
                if (itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) {
                    boolean bl = TMenuBar.this.playXuggleSmoothlyItem.isSelected();
                    try {
                        Class<?> clazz = Class.forName(string);
                        Method method = clazz.getMethod("setSmoothPlay", Boolean.class);
                        method.invoke((Object)video, bl);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this.checkDurationsItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.CheckFrameDurations")) + "...");
        this.checkDurationsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerIO.findBadVideoFrames(TMenuBar.this.trackerPanel, TrackerIO.defaultBadFrameTolerance, true, false, false);
            }
        });
        this.aboutVideoItem = this.videoMenu.add(this.actions.get("aboutVideo"));
        this.filtersMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.VideoFilters"));
        this.newFilterMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.NewVideoFilter"));
        this.filtersMenu.add(this.newFilterMenu);
        this.filtersMenu.addSeparator();
        this.clearFiltersItem = this.filtersMenu.add(this.actions.get("clearFilters"));
        this.trackMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Tracks"));
        this.trackMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TMenuBar.this.refresh();
            }
        });
        this.trackMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (TMenuBar.this.createMenu.getItemCount() > 0) {
                    TMenuBar.this.trackMenu.add((Component)TMenuBar.this.createMenu, 0);
                }
            }
        });
        this.add(this.trackMenu);
        this.axesVisibleItem = new JCheckBoxMenuItem(this.actions.get("axesVisible"));
        this.coordsMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Coords"));
        this.coordsMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TMenuBar.this.refresh();
            }
        });
        this.add(this.coordsMenu);
        this.angleUnitsMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.AngleUnits"));
        this.angleUnitsMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TFrame tFrame = TMenuBar.this.trackerPanel.getTFrame();
                TMenuBar.this.radiansItem.setSelected(tFrame.anglesInRadians);
                TMenuBar.this.degreesItem.setSelected(!tFrame.anglesInRadians);
            }
        });
        this.coordsMenu.add(this.angleUnitsMenu);
        this.coordsMenu.addSeparator();
        object = new ButtonGroup();
        this.degreesItem = new JRadioButtonMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Degrees"));
        ((ButtonGroup)object).add(this.degreesItem);
        this.angleUnitsMenu.add(this.degreesItem);
        this.radiansItem = new JRadioButtonMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Radians"));
        ((ButtonGroup)object).add(this.radiansItem);
        this.angleUnitsMenu.add(this.radiansItem);
        this.radiansItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TFrame tFrame = TMenuBar.this.trackerPanel.getTFrame();
                tFrame.setAnglesInRadians(TMenuBar.this.radiansItem.isSelected());
            }
        });
        this.lockedCoordsItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CoordsLocked"));
        this.coordsMenu.add(this.lockedCoordsItem);
        this.lockedCoordsItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ImageCoordSystem imageCoordSystem = TMenuBar.this.trackerPanel.getCoords();
                imageCoordSystem.setLocked(TMenuBar.this.lockedCoordsItem.isSelected());
            }
        });
        this.coordsMenu.addSeparator();
        this.fixedOriginItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CoordsFixedOrigin"));
        this.fixedOriginItem.setSelected(true);
        this.coordsMenu.add(this.fixedOriginItem);
        this.fixedOriginItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = TMenuBar.this.trackerPanel.getFrameNumber();
                ImageCoordSystem imageCoordSystem = TMenuBar.this.trackerPanel.getCoords();
                XMLControlElement xMLControlElement = new XMLControlElement(TMenuBar.this.trackerPanel.getCoords());
                imageCoordSystem.setFixedOrigin(TMenuBar.this.fixedOriginItem.isSelected(), n);
                if (!TMenuBar.this.refreshing) {
                    Undo.postCoordsEdit(TMenuBar.this.trackerPanel, xMLControlElement);
                }
            }
        });
        this.fixedAngleItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CoordsFixedAngle"));
        this.fixedAngleItem.setSelected(true);
        this.coordsMenu.add(this.fixedAngleItem);
        this.fixedAngleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = TMenuBar.this.trackerPanel.getFrameNumber();
                ImageCoordSystem imageCoordSystem = TMenuBar.this.trackerPanel.getCoords();
                XMLControlElement xMLControlElement = new XMLControlElement(TMenuBar.this.trackerPanel.getCoords());
                imageCoordSystem.setFixedAngle(TMenuBar.this.fixedAngleItem.isSelected(), n);
                if (!TMenuBar.this.refreshing) {
                    Undo.postCoordsEdit(TMenuBar.this.trackerPanel, xMLControlElement);
                }
            }
        });
        this.fixedScaleItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CoordsFixedScale"));
        this.fixedScaleItem.setSelected(true);
        this.coordsMenu.add(this.fixedScaleItem);
        this.fixedScaleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = TMenuBar.this.trackerPanel.getFrameNumber();
                ImageCoordSystem imageCoordSystem = TMenuBar.this.trackerPanel.getCoords();
                XMLControlElement xMLControlElement = new XMLControlElement(TMenuBar.this.trackerPanel.getCoords());
                imageCoordSystem.setFixedScale(TMenuBar.this.fixedScaleItem.isSelected(), n);
                if (!TMenuBar.this.refreshing) {
                    Undo.postCoordsEdit(TMenuBar.this.trackerPanel, xMLControlElement);
                }
            }
        });
        this.coordsMenu.addSeparator();
        this.coordsMenu.addSeparator();
        this.refFrameMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.CoordsRefFrame"));
        this.coordsMenu.add(this.refFrameMenu);
        this.refFrameGroup = new ButtonGroup();
        this.defaultRefFrameItem = new JRadioButtonMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CoordsDefault"), true);
        this.defaultRefFrameItem.addActionListener(this.actions.get("refFrame"));
        this.newAnalyticParticleItem = new JMenuItem(TrackerRes.getString("AnalyticParticle.Name"));
        this.newAnalyticParticleItem.addActionListener(this.actions.get("analyticParticle"));
        this.newDynamicParticleMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.DynamicParticle"));
        this.newDynamicParticleCartesianItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Cartesian"));
        this.newDynamicParticleCartesianItem.addActionListener(this.actions.get("dynamicParticle"));
        this.newDynamicParticlePolarItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Polar"));
        this.newDynamicParticlePolarItem.addActionListener(this.actions.get("dynamicParticlePolar"));
        this.newDynamicSystemItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.TwoBody"));
        this.newDynamicSystemItem.addActionListener(this.actions.get("dynamicSystem"));
        this.newDataTrackItem = new JMenuItem(String.valueOf(TrackerRes.getString("ParticleDataTrack.Name")) + "...");
        this.newDataTrackItem.addActionListener(this.actions.get("dataTrack"));
        this.windowMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Window"));
        this.windowMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TMenuBar.this.trackerPanel.getTFrame().refreshWindowMenu(TMenuBar.this.trackerPanel);
                FontSizer.setFonts(TMenuBar.this.windowMenu, FontSizer.getLevel());
            }
        });
        this.add(this.windowMenu);
        this.restoreItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Restore"));
        this.restoreItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TMenuBar.this.trackerPanel.restoreViews();
            }
        });
        this.rightPaneItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.WindowRight"), false);
        this.rightPaneItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TMenuBar.this.getFrame() != null) {
                    JSplitPane jSplitPane = TMenuBar.this.frame.getSplitPane(TMenuBar.this.trackerPanel, 0);
                    if (TMenuBar.this.rightPaneItem.isSelected()) {
                        jSplitPane.setDividerLocation(TMenuBar.this.frame.defaultRightDivider);
                    } else {
                        jSplitPane.setDividerLocation(1.0);
                    }
                }
            }
        });
        this.bottomPaneItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.WindowBottom"), false);
        this.bottomPaneItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TMenuBar.this.getFrame() != null) {
                    JSplitPane jSplitPane = TMenuBar.this.frame.getSplitPane(TMenuBar.this.trackerPanel, 2);
                    if (TMenuBar.this.bottomPaneItem.isSelected()) {
                        jSplitPane.setDividerLocation(TMenuBar.this.frame.defaultBottomDivider);
                    } else {
                        jSplitPane.setDividerLocation(1.0);
                    }
                }
            }
        });
        this.trackControlItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.TrackControl"));
        this.trackControlItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackControl trackControl;
                trackControl.setVisible(!(trackControl = TrackControl.getControl(TMenuBar.this.trackerPanel)).isVisible());
            }
        });
        this.notesItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Description"));
        this.notesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TMenuBar.this.getFrame() != null) {
                    if (TMenuBar.this.frame.notesDialog.isVisible()) {
                        TMenuBar.this.frame.notesDialog.setVisible(false);
                    } else {
                        TMenuBar.this.frame.getToolBar((TrackerPanel)TMenuBar.this.trackerPanel).notesButton.doClick();
                    }
                }
            }
        });
        String string = TrackerRes.getString("TMenuBar.MenuItem.DataFunctionTool");
        string = String.valueOf(string) + " (" + TrackerRes.getString("TView.Menuitem.Define") + ")";
        this.dataBuilderItem = new JCheckBoxMenuItem(string);
        this.dataBuilderItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FunctionTool functionTool = TMenuBar.this.trackerPanel.getDataBuilder();
                if (functionTool.isVisible()) {
                    functionTool.setVisible(false);
                } else {
                    TTrack tTrack = TMenuBar.this.trackerPanel.getSelectedTrack();
                    if (tTrack != null) {
                        functionTool.setSelectedPanel(tTrack.getName());
                    }
                    functionTool.setVisible(true);
                }
            }
        });
        string = TrackerRes.getString("TMenuBar.MenuItem.DatasetTool");
        string = String.valueOf(string) + " (" + TrackerRes.getString("TableTrackView.Popup.MenuItem.Analyze") + ")";
        this.dataToolItem = new JCheckBoxMenuItem(string);
        this.dataToolItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackChooserTView trackChooserTView;
                TrackView trackView;
                TrackView trackView2;
                TView tView;
                int n;
                int n2;
                TView[] tViewArray;
                TView[] tViewArray2;
                String string;
                DataTool dataTool = DataTool.getTool();
                if (dataTool.isVisible()) {
                    dataTool.setVisible(false);
                    return;
                }
                boolean bl = false;
                TView[][] tViewArray3 = TMenuBar.this.getFrame().getTViews(TMenuBar.this.trackerPanel);
                String[] stringArray = TMenuBar.this.getFrame().getSelectedTViews(TMenuBar.this.trackerPanel);
                int n3 = 0;
                while (n3 < stringArray.length) {
                    string = stringArray[n3];
                    if (string != null && string.toLowerCase().startsWith("plot") && n3 < tViewArray3.length) {
                        tViewArray = tViewArray2 = tViewArray3[n3];
                        n2 = tViewArray2.length;
                        n = 0;
                        while (n < n2) {
                            tView = tViewArray[n];
                            if (tView instanceof PlotTView && (trackView2 = (PlotTrackView)(trackView = (trackChooserTView = (PlotTView)tView).getTrackView(trackChooserTView.getSelectedTrack()))) != null) {
                                TrackPlottingPanel[] trackPlottingPanelArray = trackView2.getPlots();
                                int n4 = trackPlottingPanelArray.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    TrackPlottingPanel trackPlottingPanel = trackPlottingPanelArray[n5];
                                    trackPlottingPanel.dataToolItem.doClick();
                                    bl = true;
                                    ++n5;
                                }
                            }
                            ++n;
                        }
                    }
                    ++n3;
                }
                if (!bl) {
                    n3 = 0;
                    while (n3 < stringArray.length) {
                        string = stringArray[n3];
                        if (string != null && string.toLowerCase().startsWith("table") && n3 < tViewArray3.length) {
                            tViewArray = tViewArray2 = tViewArray3[n3];
                            n2 = tViewArray2.length;
                            n = 0;
                            while (n < n2) {
                                tView = tViewArray[n];
                                if (tView instanceof TableTView && (trackView2 = (TableTrackView)(trackView = (trackChooserTView = (TableTView)tView).getTrackView(trackChooserTView.getSelectedTrack()))) != null) {
                                    ((TableTrackView)trackView2).dataToolItem.doClick();
                                }
                                ++n;
                            }
                        }
                        ++n3;
                    }
                }
                dataTool.setDefaultCloseOperation(1);
                dataTool.setVisible(true);
            }
        });
        JMenu jMenu = TMenuBar.getTrackerHelpMenu();
        this.add(jMenu);
        this.emptyVideoItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Empty"));
        this.emptyVideoItem.setEnabled(false);
        this.emptyTracksItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Empty"));
        this.emptyTracksItem.setEnabled(false);
        this.emptyCoordsItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Empty"));
        this.emptyCoordsItem.setEnabled(false);
    }

    protected static JMenu getTrackerHelpMenu() {
        JMenuItem jMenuItem;
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        final JMenu jMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Help"));
        JMenuItem jMenuItem2 = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.GettingStarted"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Container container = jMenu.getTopLevelAncestor();
                if (container instanceof TFrame) {
                    TFrame tFrame = (TFrame)container;
                    tFrame.showHelp("gettingstarted", 0);
                }
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.TrackerHelp"));
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(72, n));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Container container = jMenu.getTopLevelAncestor();
                if (container instanceof TFrame) {
                    TFrame tFrame = (TFrame)container;
                    tFrame.showHelp(null, 0);
                }
            }
        });
        jMenu.add(jMenuItem3);
        if (Tracker.trackerHome != null && Tracker.readmeAction != null) {
            jMenu.add(Tracker.readmeAction);
        }
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(TrackerRes.getString("Tracker.MenuItem.Hints"));
        jCheckBoxMenuItem.setSelected(Tracker.showHints);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame;
                int n;
                Tracker.showHints = jCheckBoxMenuItem.isSelected();
                Tracker.startupHintShown = false;
                Container container = jMenu.getTopLevelAncestor();
                if (container instanceof TFrame && (n = (tFrame = (TFrame)container).getSelectedTab()) > -1) {
                    TView[][] tViewArray;
                    TrackerPanel trackerPanel = tFrame.getTrackerPanel(n);
                    trackerPanel.setCursorForMarking(false, null);
                    TView[][] tViewArray2 = tViewArray = tFrame.getTViews(trackerPanel);
                    int n2 = tViewArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        TView[] tViewArray3;
                        TView[] tViewArray4 = tViewArray3 = tViewArray2[n3];
                        int n4 = tViewArray3.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            PlotTView plotTView;
                            TrackView trackView;
                            PlotTrackView plotTrackView;
                            TView tView = tViewArray4[n5];
                            if (tView instanceof PlotTView && (plotTrackView = (PlotTrackView)(trackView = (plotTView = (PlotTView)tView).getTrackView(plotTView.getSelectedTrack()))) != null) {
                                TrackPlottingPanel[] trackPlottingPanelArray = plotTrackView.getPlots();
                                int n6 = trackPlottingPanelArray.length;
                                int n7 = 0;
                                while (n7 < n6) {
                                    TrackPlottingPanel trackPlottingPanel = trackPlottingPanelArray[n7];
                                    trackPlottingPanel.plotData();
                                    ++n7;
                                }
                            }
                            ++n5;
                        }
                        ++n3;
                    }
                }
            }
        });
        if (!OSPRuntime.isMac()) {
            jMenu.addSeparator();
            jMenu.add(jCheckBoxMenuItem);
        }
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu(TrackerRes.getString("TMenuBar.Menu.Diagnostics"));
        jMenu.add(jMenu2);
        JMenuItem jMenuItem4 = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.MessageLog"));
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(76, n));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Point point = new Frame().getLocation();
                OSPLog oSPLog = OSPLog.getOSPLog();
                FontSizer.setFonts(oSPLog, FontSizer.getLevel());
                if (oSPLog.getLocation().x == point.x && oSPLog.getLocation().y == point.y) {
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    int n = (dimension.width - oSPLog.getBounds().width) / 2;
                    int n2 = (dimension.height - oSPLog.getBounds().height) / 2;
                    oSPLog.setLocation(n, n2);
                }
                oSPLog.setVisible(true);
            }
        });
        jMenu2.add(jMenuItem4);
        if (Tracker.startLogAction != null) {
            jMenuItem = jMenu2.add(Tracker.startLogAction);
            jMenuItem.setToolTipText(System.getenv("START_LOG"));
        }
        if (Tracker.trackerPrefsAction != null) {
            jMenuItem = jMenu2.add(Tracker.trackerPrefsAction);
            jMenuItem.setToolTipText(XML.forwardSlash(Tracker.prefsPath));
        }
        jMenu2.addSeparator();
        if (Tracker.aboutJavaAction != null) {
            jMenu2.add(Tracker.aboutJavaAction);
        }
        if (Tracker.aboutQTAction != null) {
            jMenu2.add(Tracker.aboutQTAction);
        }
        if (Tracker.aboutXuggleAction != null) {
            jMenu2.add(Tracker.aboutXuggleAction);
        }
        if (Tracker.aboutThreadsAction != null) {
            jMenu2.add(Tracker.aboutThreadsAction);
        }
        jMenu.addSeparator();
        if (Tracker.aboutTrackerAction != null) {
            jMenu.add(Tracker.aboutTrackerAction);
        }
        return jMenu;
    }

    protected JMenu getMenu(TTrack tTrack) {
        JMenuItem jMenuItem;
        int n;
        JMenu jMenu = tTrack.getMenu(this.trackerPanel);
        ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
        if (imageCoordSystem.isLocked() && imageCoordSystem instanceof ReferenceFrame && tTrack == ((ReferenceFrame)imageCoordSystem).getOriginTrack()) {
            n = 0;
            while (n < jMenu.getItemCount()) {
                jMenuItem = jMenu.getItem(n);
                if (jMenuItem != null && jMenuItem.getText().equals(TrackerRes.getString("TMenuBar.MenuItem.CoordsLocked"))) {
                    jMenu.getItem(n).setEnabled(false);
                    break;
                }
                ++n;
            }
        }
        if (tTrack == this.trackerPanel.getAxes()) {
            n = 0;
            while (n < jMenu.getItemCount()) {
                jMenuItem = jMenu.getItem(n);
                if (jMenuItem != null && jMenuItem.getText().equals(TrackerRes.getString("TTrack.MenuItem.Visible"))) {
                    jMenu.remove(n);
                    break;
                }
                ++n;
            }
            this.axesVisibleItem.setSelected(tTrack.isVisible());
            jMenu.insert(this.axesVisibleItem, n);
        }
        FontSizer.setFonts(jMenu, FontSizer.getLevel());
        return jMenu;
    }

    protected void refresh() {
        Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " refresh");
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public synchronized void run() {
                Object object;
                Iterator<TTrack> iterator;
                void var15_31;
                JMenu jMenu;
                JMenuItem jMenuItem;
                Object object2;
                Object object5;
                boolean bl;
                TMenuBar.this.refreshing = true;
                CoordAxes coordAxes = TMenuBar.this.trackerPanel.getAxes();
                TTrack tTrack32 = TMenuBar.this.trackerPanel.getSelectedTrack();
                ArrayList<TTrack> arrayList = TMenuBar.this.trackerPanel.getUserTracks();
                boolean bl2 = !arrayList.isEmpty();
                Video video = TMenuBar.this.trackerPanel.getVideo();
                boolean bl3 = video != null;
                TMenuBar.this.videoMenu.removeAll();
                boolean bl4 = bl = TMenuBar.this.trackerPanel.isEnabled("video.import") || TMenuBar.this.trackerPanel.isEnabled("video.open");
                if (bl && OSPRuntime.applet == null) {
                    if (bl3) {
                        TMenuBar.this.openVideoItem.setText(TrackerRes.getString("TMenuBar.MenuItem.Replace"));
                    } else {
                        TMenuBar.this.openVideoItem.setText(TrackerRes.getString("TActions.Action.ImportVideo"));
                    }
                    TMenuBar.this.videoMenu.add(TMenuBar.this.openVideoItem);
                }
                if (bl3 && TMenuBar.this.trackerPanel.isEnabled("video.close")) {
                    TMenuBar.this.videoMenu.add(TMenuBar.this.closeVideoItem);
                }
                if (TMenuBar.this.videoMenu.getItemCount() > 0) {
                    TMenuBar.this.videoMenu.addSeparator();
                }
                if (bl3 && video instanceof ImageVideo) {
                    TMenuBar.this.editVideoItem.setSelected(((ImageVideo)video).isEditable());
                    TMenuBar.this.videoMenu.add(TMenuBar.this.editVideoItem);
                    TMenuBar.this.videoMenu.addSeparator();
                }
                if (bl) {
                    TMenuBar.this.videoMenu.add(bl3 ? TMenuBar.this.pasteImageMenu : TMenuBar.this.pasteImageItem);
                }
                if (bl3) {
                    Object object6;
                    boolean bl5;
                    boolean bl6 = bl5 = video instanceof ImageVideo && ((ImageVideo)video).isEditable();
                    if (bl5 && bl) {
                        TMenuBar.this.pasteImageMenu.add(TMenuBar.this.pasteImageBeforeItem);
                        TMenuBar.this.pasteImageMenu.add(TMenuBar.this.pasteImageAfterItem);
                        TMenuBar.this.videoMenu.add(TMenuBar.this.importImageMenu);
                        TMenuBar.this.videoMenu.add(TMenuBar.this.removeImageItem);
                        TMenuBar.this.removeImageItem.setEnabled(video.getFrameCount() > 1);
                    } else {
                        TMenuBar.this.pasteImageMenu.remove(TMenuBar.this.pasteImageBeforeItem);
                        TMenuBar.this.pasteImageMenu.remove(TMenuBar.this.pasteImageAfterItem);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("video.visible")) {
                        if (TMenuBar.this.videoMenu.getItemCount() > 0) {
                            TMenuBar.this.videoMenu.addSeparator();
                        }
                        TMenuBar.this.videoMenu.add(TMenuBar.this.videoVisibleItem);
                    }
                    object5 = TMenuBar.this.trackerPanel.getPlayer().getVideoClip();
                    TMenuBar.this.playAllStepsItem.setSelected(((VideoClip)object5).isPlayAllSteps());
                    TMenuBar.this.videoMenu.add(TMenuBar.this.playAllStepsItem);
                    VideoType videoType = (VideoType)video.getProperty("video_type");
                    if (videoType != null && videoType.getClass().getSimpleName().contains("Xuggle")) {
                        object6 = "org.opensourcephysics.media.xuggle.XuggleVideo";
                        try {
                            Class<?> object42 = Class.forName((String)object6);
                            Method method = object42.getMethod("isSmoothPlay", null);
                            object2 = (Boolean)method.invoke((Object)video, null);
                            TMenuBar.this.playXuggleSmoothlyItem.setSelected((Boolean)object2);
                            TMenuBar.this.videoMenu.add(TMenuBar.this.playXuggleSmoothlyItem);
                        }
                        catch (Exception exception) {}
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("video.filters")) {
                        TMenuBar.this.filtersMenu.removeAll();
                        TMenuBar.this.filtersMenu.add(TMenuBar.this.newFilterMenu);
                        TMenuBar.this.newFilterMenu.removeAll();
                        object6 = TMenuBar.this.trackerPanel.getFilters();
                        synchronized (object6) {
                            for (String string : TMenuBar.this.trackerPanel.getFilters().keySet()) {
                                object2 = new String(string);
                                int n = ((String)object2).lastIndexOf(46);
                                if (n > 0 && n < ((String)object2).length() - 1) {
                                    object2 = ((String)object2).substring(n + 1);
                                }
                                if ((n = ((String)object2).indexOf("Filter")) > 0 && n < ((String)object2).length() - 1) {
                                    object2 = ((String)object2).substring(0, n);
                                }
                                object2 = MediaRes.getString("VideoFilter." + (String)object2);
                                jMenuItem = new JMenuItem((String)object2);
                                jMenuItem.setActionCommand(string);
                                jMenuItem.addActionListener(TMenuBar.this.actions.get("videoFilter"));
                                TMenuBar.this.newFilterMenu.add(jMenuItem);
                            }
                        }
                        object6 = video.getFilterStack();
                        ((Filter)object6).removePropertyChangeListener("filter", TMenuBar.this);
                        ((Filter)object6).addPropertyChangeListener("filter", TMenuBar.this);
                        if (!((FilterStack)object6).getFilters().isEmpty()) {
                            TMenuBar.this.filtersMenu.addSeparator();
                            for (Filter filter : ((FilterStack)object6).getFilters()) {
                                jMenu = filter.getMenu(video);
                                TMenuBar.this.filtersMenu.add(jMenu);
                            }
                            TMenuBar.this.filtersMenu.addSeparator();
                            TMenuBar.this.filtersMenu.add(TMenuBar.this.clearFiltersItem);
                        }
                        if (TMenuBar.this.videoMenu.getItemCount() > 0) {
                            TMenuBar.this.videoMenu.addSeparator();
                        }
                        TMenuBar.this.videoMenu.add(TMenuBar.this.filtersMenu);
                    }
                    TMenuBar.this.videoMenu.addSeparator();
                    TMenuBar.this.videoMenu.add(TMenuBar.this.checkDurationsItem);
                    TMenuBar.this.videoMenu.add(TMenuBar.this.aboutVideoItem);
                }
                if (OSPRuntime.applet == null) {
                    TMenuBar.this.saveItem.setEnabled(TMenuBar.this.trackerPanel.getDataFile() != null);
                    String string = TMenuBar.this.trackerPanel.getTitle();
                    string = " \"" + string + "\"";
                    TMenuBar.this.closeItem.setText(String.valueOf(TrackerRes.getString("TActions.Action.Close")) + string);
                    TMenuBar.this.saveItem.setText(String.valueOf(TrackerRes.getString("TActions.Action.Save")) + string);
                }
                TMenuBar.this.trackMenu.removeAll();
                TMenuBar.this.deleteTracksMenu.removeAll();
                TMenuBar.this.deleteTracksMenu.add(TMenuBar.this.deleteSelectedPointItem);
                TMenuBar.this.deleteTracksMenu.addSeparator();
                TMenuBar.this.refFrameMenu.removeAll();
                Enumeration<AbstractButton> enumeration = TMenuBar.this.refFrameGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    TMenuBar.this.refFrameGroup.remove(enumeration.nextElement());
                }
                object5 = TMenuBar.this.trackerPanel.getCoords();
                boolean bl7 = !(object5 instanceof ReferenceFrame);
                TMenuBar.this.lockedCoordsItem.setSelected(((ImageCoordSystem)object5).isLocked());
                TMenuBar.this.fixedOriginItem.setSelected(((ImageCoordSystem)object5).isFixedOrigin());
                TMenuBar.this.fixedAngleItem.setSelected(((ImageCoordSystem)object5).isFixedAngle());
                TMenuBar.this.fixedScaleItem.setSelected(((ImageCoordSystem)object5).isFixedScale());
                TMenuBar.this.fixedOriginItem.setEnabled(bl7 && !((ImageCoordSystem)object5).isLocked());
                TMenuBar.this.fixedAngleItem.setEnabled(bl7 && !((ImageCoordSystem)object5).isLocked());
                boolean bl8 = false;
                ArrayList<TapeMeasure> arrayList2 = TMenuBar.this.trackerPanel.getDrawables(TapeMeasure.class);
                for (TapeMeasure tapeMeasure : arrayList2) {
                    if (!tapeMeasure.isStickMode() || tapeMeasure.attachments == null || tapeMeasure.attachments[0] == null && tapeMeasure.attachments[1] == null) continue;
                    bl8 = true;
                    break;
                }
                TMenuBar.this.fixedScaleItem.setEnabled(bl7 && !((ImageCoordSystem)object5).isLocked() && !bl8);
                TMenuBar.this.refFrameMenu.setEnabled(!((ImageCoordSystem)object5).isLocked());
                TMenuBar.this.refFrameGroup.add(TMenuBar.this.defaultRefFrameItem);
                TMenuBar.this.refFrameMenu.add(TMenuBar.this.defaultRefFrameItem);
                Object var15_29 = null;
                if (object5 instanceof ReferenceFrame) {
                    PointMass pointMass = ((ReferenceFrame)object5).getOriginTrack();
                }
                if (var15_31 == null) {
                    TMenuBar.this.defaultRefFrameItem.setSelected(true);
                }
                TMenuBar.this.fileMenu.removeAll();
                if (OSPRuntime.applet == null) {
                    boolean bl9;
                    if (TMenuBar.this.trackerPanel.isEnabled("file.new")) {
                        TMenuBar.this.fileMenu.add(TMenuBar.this.newTabItem);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("file.open")) {
                        if (TMenuBar.this.fileMenu.getItemCount() > 0) {
                            TMenuBar.this.fileMenu.addSeparator();
                        }
                        TMenuBar.this.fileMenu.add(TMenuBar.this.openItem);
                        TMenuBar.this.fileMenu.add(TMenuBar.this.openURLItem);
                        object2 = TMenuBar.this.trackerPanel.getTFrame();
                        if (object2 != null) {
                            ((TFrame)object2).refreshOpenRecentMenu(TMenuBar.this.openRecentMenu);
                            TMenuBar.this.fileMenu.add(TMenuBar.this.openRecentMenu);
                        }
                    }
                    boolean bl10 = bl9 = TMenuBar.this.trackerPanel.isEnabled("file.open") || TMenuBar.this.trackerPanel.isEnabled("file.export");
                    if (bl9 && TMenuBar.this.trackerPanel.isEnabled("file.library")) {
                        if (TMenuBar.this.fileMenu.getItemCount() > 0) {
                            TMenuBar.this.fileMenu.addSeparator();
                        }
                        if (TMenuBar.this.trackerPanel.isEnabled("file.open")) {
                            TMenuBar.this.fileMenu.add(TMenuBar.this.openBrowserItem);
                        }
                        if (TMenuBar.this.trackerPanel.isEnabled("file.export")) {
                            TMenuBar.this.fileMenu.add(TMenuBar.this.saveZipAsItem);
                        }
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("file.close")) {
                        if (TMenuBar.this.fileMenu.getItemCount() > 0) {
                            TMenuBar.this.fileMenu.addSeparator();
                        }
                        TMenuBar.this.fileMenu.add(TMenuBar.this.closeItem);
                        TMenuBar.this.fileMenu.add(TMenuBar.this.closeAllItem);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("file.save") || TMenuBar.this.trackerPanel.isEnabled("file.saveAs")) {
                        if (TMenuBar.this.fileMenu.getItemCount() > 0) {
                            TMenuBar.this.fileMenu.addSeparator();
                        }
                        if (TMenuBar.this.trackerPanel.isEnabled("file.save")) {
                            TMenuBar.this.fileMenu.add(TMenuBar.this.saveItem);
                        }
                        if (TMenuBar.this.trackerPanel.isEnabled("file.saveAs")) {
                            TMenuBar.this.fileMenu.add(TMenuBar.this.saveAsItem);
                            if (TMenuBar.this.trackerPanel.getVideo() != null) {
                                TMenuBar.this.fileMenu.add(TMenuBar.this.saveVideoAsItem);
                            }
                            TMenuBar.this.fileMenu.add(TMenuBar.this.saveTabsetAsItem);
                        }
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("file.import") || TMenuBar.this.trackerPanel.isEnabled("file.export")) {
                        if (TMenuBar.this.fileMenu.getItemCount() > 0) {
                            TMenuBar.this.fileMenu.addSeparator();
                        }
                        if (TMenuBar.this.trackerPanel.isEnabled("file.import")) {
                            TMenuBar.this.fileMenu.add(TMenuBar.this.importMenu);
                        }
                        if (TMenuBar.this.trackerPanel.isEnabled("file.export")) {
                            TMenuBar.this.fileMenu.add(TMenuBar.this.exportMenu);
                        }
                    }
                }
                if (TMenuBar.this.fileMenu.getItemCount() > 0) {
                    TMenuBar.this.fileMenu.addSeparator();
                }
                TMenuBar.this.fileMenu.add(TMenuBar.this.propertiesItem);
                if (TMenuBar.this.trackerPanel.isEnabled("file.print")) {
                    if (TMenuBar.this.fileMenu.getItemCount() > 0) {
                        TMenuBar.this.fileMenu.addSeparator();
                    }
                    TMenuBar.this.fileMenu.add(TMenuBar.this.printFrameItem);
                }
                if (OSPRuntime.applet == null) {
                    if (TMenuBar.this.fileMenu.getItemCount() > 0) {
                        TMenuBar.this.fileMenu.addSeparator();
                    }
                    TMenuBar.this.fileMenu.add(TMenuBar.this.exitItem);
                }
                TMenuBar.this.editMenu.removeAll();
                if (TMenuBar.this.trackerPanel.isEnabled("edit.undoRedo")) {
                    TMenuBar.this.undoItem.setText(TrackerRes.getString("TMenuBar.MenuItem.Undo"));
                    TMenuBar.this.editMenu.add(TMenuBar.this.undoItem);
                    TMenuBar.this.undoItem.setEnabled(Undo.canUndo(TMenuBar.this.trackerPanel));
                    TMenuBar.this.redoItem.setText(TrackerRes.getString("TMenuBar.MenuItem.Redo"));
                    TMenuBar.this.editMenu.add(TMenuBar.this.redoItem);
                    TMenuBar.this.redoItem.setEnabled(Undo.canRedo(TMenuBar.this.trackerPanel));
                }
                if (TMenuBar.this.trackerPanel.isEnabled("edit.copyData") || TMenuBar.this.trackerPanel.isEnabled("edit.copyImage") || TMenuBar.this.trackerPanel.isEnabled("edit.copyObject")) {
                    if (TMenuBar.this.editMenu.getItemCount() > 0) {
                        TMenuBar.this.editMenu.addSeparator();
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("edit.copyData")) {
                        TMenuBar.this.editMenu.add(TMenuBar.this.copyDataMenu);
                        TreeMap<Integer, TableTrackView> treeMap = TMenuBar.this.getDataViews();
                        TMenuBar.this.copyDataMenu.setEnabled(!treeMap.isEmpty());
                        if (treeMap.isEmpty()) {
                            TMenuBar.this.copyDataMenu.setText(TrackerRes.getString("TableTrackView.Action.CopyData"));
                        } else {
                            Integer n = treeMap.firstKey();
                            iterator = treeMap.get(n);
                            ((TableTrackView)((Object)iterator)).refreshCopyDataMenu(TMenuBar.this.copyDataMenu);
                            object = TMenuBar.this.copyDataMenu.getText();
                            TMenuBar.this.copyDataMenu.setText(String.valueOf(object) + " (" + n + ")");
                        }
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("edit.copyImage")) {
                        TMenuBar.this.editMenu.add(TMenuBar.this.copyImageMenu);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("edit.copyObject")) {
                        TMenuBar.this.editMenu.add(TMenuBar.this.copyObjectMenu);
                        TMenuBar.this.copyObjectMenu.setText(TrackerRes.getString("TMenuBar.Menu.CopyObject"));
                        TMenuBar.this.copyObjectMenu.removeAll();
                        AbstractAction abstractAction = new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                String string = ((JMenuItem)actionEvent.getSource()).getActionCommand();
                                if ("coords".equals(string)) {
                                    TrackerIO.copyXML((this).TMenuBar.this.trackerPanel.getCoords());
                                } else if ("clip".equals(string)) {
                                    TrackerIO.copyXML((this).TMenuBar.this.trackerPanel.getPlayer().getVideoClip());
                                } else {
                                    TTrack tTrack = (this).TMenuBar.this.trackerPanel.getTrack(string);
                                    if (tTrack != null) {
                                        TrackerIO.copyXML(tTrack);
                                    }
                                }
                            }
                        };
                        jMenuItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Coords"));
                        jMenuItem.setActionCommand("coords");
                        jMenuItem.addActionListener(abstractAction);
                        TMenuBar.this.copyObjectMenu.add(jMenuItem);
                        jMenuItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.VideoClip"));
                        jMenuItem.setActionCommand("clip");
                        jMenuItem.addActionListener(abstractAction);
                        TMenuBar.this.copyObjectMenu.add(jMenuItem);
                        for (TTrack tTrack : TMenuBar.this.trackerPanel.getTracks()) {
                            if (tTrack == TMenuBar.this.trackerPanel.getAxes()) continue;
                            jMenuItem = new JMenuItem(tTrack.getName());
                            jMenuItem.setActionCommand(tTrack.getName());
                            jMenuItem.addActionListener(abstractAction);
                            TMenuBar.this.copyObjectMenu.add(jMenuItem);
                        }
                    }
                }
                if (TMenuBar.this.trackerPanel.isEnabled("edit.paste")) {
                    if (TMenuBar.this.editMenu.getItemCount() > 0) {
                        TMenuBar.this.editMenu.addSeparator();
                    }
                    TMenuBar.this.editMenu.add(TMenuBar.this.pasteItem);
                }
                if (TMenuBar.this.trackerPanel.isEnabled("track.delete")) {
                    if (TMenuBar.this.editMenu.getItemCount() > 0) {
                        TMenuBar.this.editMenu.addSeparator();
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("track.delete") || bl2) {
                        TMenuBar.this.editMenu.add(TMenuBar.this.deleteTracksMenu);
                    }
                }
                if (TMenuBar.this.trackerPanel.isEnabled("edit.matSize")) {
                    if (TMenuBar.this.editMenu.getItemCount() > 0) {
                        TMenuBar.this.editMenu.addSeparator();
                    }
                    TMenuBar.this.editMenu.add(TMenuBar.this.matSizeMenu);
                }
                if (TMenuBar.this.editMenu.getItemCount() > 0) {
                    TMenuBar.this.editMenu.addSeparator();
                }
                TMenuBar.this.editMenu.add(TMenuBar.this.fontSizeMenu);
                TMenuBar.this.refreshMatSizes(video);
                int n = 0;
                while (n < Tracker.locales.length) {
                    TMenuBar.this.languageMenu.add(TMenuBar.this.languageItems[n]);
                    ++n;
                }
                if (TMenuBar.this.editMenu.getItemCount() > 0) {
                    TMenuBar.this.editMenu.addSeparator();
                }
                TMenuBar.this.editMenu.add(TMenuBar.this.languageMenu);
                if (TMenuBar.this.editMenu.getItemCount() > 0) {
                    TMenuBar.this.editMenu.addSeparator();
                }
                TMenuBar.this.editMenu.add(TMenuBar.this.configItem);
                TMenuBar.this.createMenu.removeAll();
                if (TMenuBar.this.trackerPanel.isEnabled("new.pointMass") || TMenuBar.this.trackerPanel.isEnabled("new.cm")) {
                    if (TMenuBar.this.trackerPanel.isEnabled("new.pointMass")) {
                        TMenuBar.this.createMenu.add(TMenuBar.this.newPointMassItem);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("new.cm")) {
                        TMenuBar.this.createMenu.add(TMenuBar.this.newCMItem);
                    }
                }
                if (TMenuBar.this.trackerPanel.isEnabled("new.vector") || TMenuBar.this.trackerPanel.isEnabled("new.vectorSum")) {
                    if (TMenuBar.this.createMenu.getItemCount() > 0) {
                        TMenuBar.this.createMenu.addSeparator();
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("new.vector")) {
                        TMenuBar.this.createMenu.add(TMenuBar.this.newVectorItem);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("new.vectorSum")) {
                        TMenuBar.this.createMenu.add(TMenuBar.this.newVectorSumItem);
                    }
                }
                if (TMenuBar.this.trackerPanel.isEnabled("new.lineProfile") || TMenuBar.this.trackerPanel.isEnabled("new.RGBRegion")) {
                    if (TMenuBar.this.createMenu.getItemCount() > 0) {
                        TMenuBar.this.createMenu.addSeparator();
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("new.lineProfile")) {
                        TMenuBar.this.createMenu.add(TMenuBar.this.newLineProfileItem);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("new.RGBRegion")) {
                        TMenuBar.this.createMenu.add(TMenuBar.this.newRGBRegionItem);
                    }
                }
                if (TMenuBar.this.trackerPanel.isEnabled("new.analyticParticle") || TMenuBar.this.trackerPanel.isEnabled("new.dynamicParticle") || TMenuBar.this.trackerPanel.isEnabled("new.dynamicTwoBody")) {
                    if (TMenuBar.this.createMenu.getItemCount() > 0) {
                        TMenuBar.this.createMenu.addSeparator();
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("new.analyticParticle")) {
                        TMenuBar.this.createMenu.add(TMenuBar.this.newAnalyticParticleItem);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("new.dynamicParticle") || TMenuBar.this.trackerPanel.isEnabled("new.dynamicTwoBody")) {
                        TMenuBar.this.createMenu.add(TMenuBar.this.newDynamicParticleMenu);
                        TMenuBar.this.newDynamicParticleMenu.removeAll();
                        if (TMenuBar.this.trackerPanel.isEnabled("new.dynamicParticle")) {
                            TMenuBar.this.newDynamicParticleMenu.add(TMenuBar.this.newDynamicParticleCartesianItem);
                            TMenuBar.this.newDynamicParticleMenu.add(TMenuBar.this.newDynamicParticlePolarItem);
                        }
                        if (TMenuBar.this.trackerPanel.isEnabled("new.dynamicTwoBody")) {
                            TMenuBar.this.newDynamicParticleMenu.add(TMenuBar.this.newDynamicSystemItem);
                        }
                    }
                }
                if (TMenuBar.this.trackerPanel.isEnabled("new.tapeMeasure") || TMenuBar.this.trackerPanel.isEnabled("new.protractor") || TMenuBar.this.trackerPanel.isEnabled("new.circleFitter")) {
                    if (TMenuBar.this.createMenu.getItemCount() > 0) {
                        TMenuBar.this.createMenu.addSeparator();
                    }
                    TMenuBar.this.createMenu.add(TMenuBar.this.measuringToolsMenu);
                    TMenuBar.this.measuringToolsMenu.removeAll();
                    if (TMenuBar.this.trackerPanel.isEnabled("new.tapeMeasure")) {
                        TMenuBar.this.measuringToolsMenu.add(TMenuBar.this.newTapeItem);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("new.protractor")) {
                        TMenuBar.this.measuringToolsMenu.add(TMenuBar.this.newProtractorItem);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("new.circleFitter")) {
                        TMenuBar.this.measuringToolsMenu.add(TMenuBar.this.newCircleFitterItem);
                    }
                }
                if (TMenuBar.this.trackerPanel.isEnabled("calibration.stick") || TMenuBar.this.trackerPanel.isEnabled("calibration.tape") || TMenuBar.this.trackerPanel.isEnabled("calibration.points") || TMenuBar.this.trackerPanel.isEnabled("calibration.offsetOrigin")) {
                    if (TMenuBar.this.createMenu.getItemCount() > 0) {
                        TMenuBar.this.createMenu.addSeparator();
                    }
                    TToolBar tToolBar = TToolBar.getToolbar(TMenuBar.this.trackerPanel);
                    TToolBar.CalibrationButton calibrationButton = tToolBar.calibrationButton;
                    iterator = calibrationButton.getCalibrationToolsMenu();
                    ((AbstractButton)((Object)iterator)).setText(TrackerRes.getString("TMenuBar.Menu.CalibrationTools"));
                    TMenuBar.this.createMenu.add((JMenuItem)((Object)iterator));
                }
                if (TMenuBar.this.trackerPanel.isEnabled("new.dataTrack")) {
                    if (TMenuBar.this.createMenu.getItemCount() > 0) {
                        TMenuBar.this.createMenu.addSeparator();
                    }
                    TMenuBar.this.createMenu.add(TMenuBar.this.newDataTrackItem);
                }
                TMenuBar.this.newTrackItems = TMenuBar.this.createMenu.getMenuComponents();
                TMenuBar.this.coordsMenu.removeAll();
                TMenuBar.this.coordsMenu.add(TMenuBar.this.angleUnitsMenu);
                if (TMenuBar.this.trackerPanel.isEnabled("coords.locked")) {
                    if (TMenuBar.this.coordsMenu.getItemCount() > 0) {
                        TMenuBar.this.coordsMenu.addSeparator();
                    }
                    TMenuBar.this.coordsMenu.add(TMenuBar.this.lockedCoordsItem);
                }
                if (TMenuBar.this.trackerPanel.isEnabled("coords.origin") || TMenuBar.this.trackerPanel.isEnabled("coords.angle") || TMenuBar.this.trackerPanel.isEnabled("coords.scale")) {
                    if (TMenuBar.this.coordsMenu.getItemCount() > 0) {
                        TMenuBar.this.coordsMenu.addSeparator();
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("coords.origin")) {
                        TMenuBar.this.coordsMenu.add(TMenuBar.this.fixedOriginItem);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("coords.angle")) {
                        TMenuBar.this.coordsMenu.add(TMenuBar.this.fixedAngleItem);
                    }
                    if (TMenuBar.this.trackerPanel.isEnabled("coords.scale")) {
                        TMenuBar.this.coordsMenu.add(TMenuBar.this.fixedScaleItem);
                    }
                }
                if (TMenuBar.this.trackerPanel.isEnabled("coords.refFrame")) {
                    if (TMenuBar.this.coordsMenu.getItemCount() > 0) {
                        TMenuBar.this.coordsMenu.addSeparator();
                    }
                    TMenuBar.this.coordsMenu.add(TMenuBar.this.refFrameMenu);
                }
                if (TMenuBar.this.createMenu.getItemCount() > 0) {
                    TMenuBar.this.trackMenu.add(TMenuBar.this.createMenu);
                }
                TMenuBar.this.cloneMenu.removeAll();
                if (bl2 && TMenuBar.this.trackerPanel.isEnabled("new.clone")) {
                    TMenuBar.this.trackMenu.add(TMenuBar.this.cloneMenu);
                }
                TMenuBar.this.clearTracksItem.setEnabled(bl2);
                if (bl2 && TMenuBar.this.trackMenu.getItemCount() > 0) {
                    TMenuBar.this.trackMenu.addSeparator();
                }
                for (TTrack tTrack32 : arrayList) {
                    tTrack32.removePropertyChangeListener("locked", TMenuBar.this);
                    tTrack32.addPropertyChangeListener("locked", TMenuBar.this);
                    String string = tTrack32.getName();
                    jMenuItem = new JMenuItem(string);
                    jMenuItem.addActionListener(TMenuBar.this.actions.get("deleteTrack"));
                    jMenuItem.setEnabled(!tTrack32.isLocked() || tTrack32.isDependent());
                    TMenuBar.this.deleteTracksMenu.add(jMenuItem);
                    jMenuItem = new JMenuItem(string);
                    jMenuItem.setIcon(tTrack32.getFootprint().getIcon(21, 16));
                    jMenuItem.addActionListener(TMenuBar.this.actions.get("cloneTrack"));
                    TMenuBar.this.cloneMenu.add(jMenuItem);
                    jMenu = TMenuBar.this.getMenu(tTrack32);
                    TMenuBar.this.trackMenu.add(jMenu);
                    if (!(tTrack32 instanceof PointMass)) continue;
                    jMenuItem = new JRadioButtonMenuItem(string);
                    jMenuItem.addActionListener(TMenuBar.this.actions.get("refFrame"));
                    TMenuBar.this.refFrameGroup.add(jMenuItem);
                    TMenuBar.this.refFrameMenu.add(jMenuItem);
                    if (tTrack32 != var15_31) continue;
                    jMenuItem.setSelected(true);
                }
                if (TMenuBar.this.trackerPanel.isEnabled("edit.clear")) {
                    if (TMenuBar.this.deleteTracksMenu.getItemCount() > 0) {
                        TMenuBar.this.deleteTracksMenu.addSeparator();
                    }
                    TMenuBar.this.deleteTracksMenu.add(TMenuBar.this.clearTracksItem);
                }
                if (TMenuBar.this.trackerPanel.isEnabled("button.axes") || TMenuBar.this.trackerPanel.isEnabled("calibration.stick") || TMenuBar.this.trackerPanel.isEnabled("calibration.tape") || TMenuBar.this.trackerPanel.isEnabled("calibration.points") || TMenuBar.this.trackerPanel.isEnabled("calibration.offsetOrigin")) {
                    if (TMenuBar.this.trackMenu.getItemCount() > 0) {
                        TMenuBar.this.trackMenu.addSeparator();
                    }
                    if (coordAxes != null && TMenuBar.this.trackerPanel.isEnabled("button.axes")) {
                        tTrack32 = coordAxes;
                        tTrack32.removePropertyChangeListener("locked", TMenuBar.this);
                        tTrack32.addPropertyChangeListener("locked", TMenuBar.this);
                        jMenu = TMenuBar.this.getMenu(tTrack32);
                        TMenuBar.this.trackMenu.add(jMenu);
                    }
                    if (!TMenuBar.this.trackerPanel.calibrationTools.isEmpty()) {
                        for (TTrack tTrack : TMenuBar.this.trackerPanel.getTracks()) {
                            if (!TMenuBar.this.trackerPanel.calibrationTools.contains(tTrack) || tTrack instanceof TapeMeasure && (((TapeMeasure)(object = (TapeMeasure)tTrack)).isStickMode() && !TMenuBar.this.trackerPanel.isEnabled("calibration.stick") || !((TapeMeasure)object).isStickMode() && !TMenuBar.this.trackerPanel.isEnabled("calibration.tape")) || tTrack instanceof Calibration && !TMenuBar.this.trackerPanel.isEnabled("calibration.points") || tTrack instanceof OffsetOrigin && !TMenuBar.this.trackerPanel.isEnabled("calibration.offsetOrigin")) continue;
                            tTrack.removePropertyChangeListener("locked", TMenuBar.this);
                            tTrack.addPropertyChangeListener("locked", TMenuBar.this);
                            jMenu = TMenuBar.this.getMenu(tTrack);
                            TMenuBar.this.trackMenu.add(jMenu);
                        }
                    }
                }
                TMenuBar.this.deleteTracksMenu.setEnabled(bl2);
                if (TMenuBar.this.videoMenu.getItemCount() == 0) {
                    TMenuBar.this.videoMenu.add(TMenuBar.this.emptyVideoItem);
                }
                if (TMenuBar.this.trackMenu.getItemCount() == 0) {
                    TMenuBar.this.trackMenu.add(TMenuBar.this.emptyTracksItem);
                }
                if (TMenuBar.this.coordsMenu.getItemCount() == 0) {
                    TMenuBar.this.coordsMenu.add(TMenuBar.this.emptyCoordsItem);
                }
                FontSizer.setFonts(TMenuBar.this, FontSizer.getLevel());
                TMenuBar.this.refreshing = false;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("selectedtrack")) {
            this.refresh();
        } else if (string.equals("datafile")) {
            this.refresh();
        } else if (string.equals("selectedpoint")) {
            this.refresh();
        } else if (string.equals("video")) {
            this.refresh();
        } else if (string.equals("size")) {
            this.refresh();
        } else if (string.equals("filter")) {
            Filter filter = (Filter)propertyChangeEvent.getOldValue();
            if (filter != null) {
                Undo.postFilterDelete(this.trackerPanel, filter);
            }
            this.refresh();
        } else if (string.equals("track")) {
            if (propertyChangeEvent.getNewValue() == null) {
                this.trackerPanel.setSelectedTrack(null);
            }
            this.refresh();
        } else if (string.equals("locked")) {
            this.refresh();
        }
    }

    protected TreeMap<Integer, TableTrackView> getDataViews() {
        TreeMap<Integer, TableTrackView> treeMap = new TreeMap<Integer, TableTrackView>();
        if (this.trackerPanel.getTFrame() == null) {
            return treeMap;
        }
        Container[] containerArray = this.trackerPanel.getTFrame().getViews(this.trackerPanel);
        int n = 0;
        while (n < containerArray.length) {
            TableTView tableTView;
            TTrack tTrack;
            TViewChooser tViewChooser;
            TView tView;
            if (this.trackerPanel.getTFrame().isViewOpen(n, this.trackerPanel) && containerArray[n] instanceof TViewChooser && (tView = (tViewChooser = (TViewChooser)containerArray[n]).getSelectedView()) instanceof TableTView && (tTrack = (tableTView = (TableTView)tView).getSelectedTrack()) != null) {
                Step[] stepArray = tTrack.getSteps();
                int n2 = stepArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Step step = stepArray[n3];
                    if (step != null) {
                        TableTrackView tableTrackView = (TableTrackView)tableTView.getTrackView(tTrack);
                        treeMap.put(n + 1, tableTrackView);
                    }
                    ++n3;
                }
            }
            ++n;
        }
        return treeMap;
    }

    private TFrame getFrame() {
        if (this.frame == null) {
            this.frame = this.trackerPanel.getTFrame();
        }
        return this.frame;
    }

    protected void refreshMatSizes(Video video) {
        Object object;
        boolean bl = false;
        Object object2 = this.matSizeMenu.getMenuComponents();
        int n = ((Component[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            Component component = object2[n2];
            bl = bl || component == this.videoSizeItem;
            ++n2;
        }
        boolean bl2 = !bl || this.videoSizeItem.isSelected();
        this.matSizeMenu.removeAll();
        n2 = 1;
        n = 1;
        if (video != null) {
            n2 = video.getImage().getWidth();
            n = video.getImage().getHeight();
            object2 = TrackerRes.getString("TMenuBar.Menu.Video");
            String string = " (" + ((String)object2).toLowerCase() + ")";
            this.videoSizeItem.setText(String.valueOf(n2) + "x" + n + string);
            this.videoSizeItem.setActionCommand(String.valueOf(n2) + "x" + n);
            if (bl2 && this.trackerPanel != null && this.trackerPanel.getMat() != null) {
                object = this.trackerPanel.getMat().mat.getSize();
                if (n2 != ((Dimension)object).width || n != ((Dimension)object).height) {
                    this.trackerPanel.setImageSize(n2, n);
                }
            }
        } else {
            this.videoSizeItem.setActionCommand("0x0");
        }
        int n3 = (int)this.trackerPanel.getImageWidth();
        int n4 = (int)this.trackerPanel.getImageHeight();
        object = this.matSizeGroup.getElements();
        while (object.hasMoreElements()) {
            int n5;
            int n6;
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)object.nextElement();
            String string = jRadioButtonMenuItem.getActionCommand();
            int n7 = Integer.parseInt(string.substring(0, n6 = string.indexOf("x")));
            if (n7 >= n2 & (n5 = Integer.parseInt(string.substring(n6 + 1))) >= n) {
                this.matSizeMenu.add(jRadioButtonMenuItem);
                if (jRadioButtonMenuItem != this.videoSizeItem && jRadioButtonMenuItem.getActionCommand().equals(this.videoSizeItem.getActionCommand())) {
                    this.matSizeMenu.remove(jRadioButtonMenuItem);
                }
            }
            if (n7 == n2 && n5 == n) {
                this.videoSizeItem.setSelected(true);
                continue;
            }
            if (n7 != n3 || n5 != n4) continue;
            jRadioButtonMenuItem.setSelected(true);
        }
    }
}

