/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;

public class ShapeIcon
implements Icon {
    private int w;
    private int h;
    private Shape shape;
    private Shape decoration;
    private Color color = Color.black;
    private Color decoColor = Color.black;
    private double offsetX;
    private double offsetY;

    public ShapeIcon(Shape shape, Shape shape2, int n, int n2) {
        Rectangle rectangle;
        this.w = n;
        this.h = n2;
        this.shape = shape;
        this.decoration = shape2;
        Rectangle rectangle2 = rectangle = shape == null ? new Rectangle() : shape.getBounds();
        if (shape2 != null) {
            rectangle = rectangle.union(shape2.getBounds());
        }
        this.offsetX = this.w / 2 - rectangle.width / 2 - rectangle.x;
        this.offsetY = this.h / 2 - rectangle.height / 2 - rectangle.y;
    }

    public ShapeIcon(Shape shape, int n, int n2) {
        this(shape, null, n, n2);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(Color color, Color color2) {
        this.color = color;
        this.decoColor = color2;
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)n + this.offsetX, (double)n2 + this.offsetY);
        Paint paint = graphics2D.getPaint();
        Shape shape = graphics2D.getClip();
        graphics2D.setPaint(this.color);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.clipRect(n, n2, this.w, this.h);
        if (this.shape != null) {
            graphics2D.fill(affineTransform.createTransformedShape(this.shape));
        }
        if (this.decoration != null) {
            graphics2D.setPaint(this.decoColor);
            graphics2D.fill(affineTransform.createTransformedShape(this.decoration));
        }
        graphics2D.setPaint(paint);
        graphics2D.setClip(shape);
    }
}

