/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.media.core.ImageCoordSystem;

public class ReferenceFrame
extends ImageCoordSystem
implements PropertyChangeListener {
    private PointMass originTrack;
    private ImageCoordSystem coords;
    private boolean lockEnabled = false;
    private boolean originLocked;

    public ReferenceFrame(ImageCoordSystem imageCoordSystem, PointMass pointMass) {
        super(imageCoordSystem.getLength());
        this.originTrack = pointMass;
        this.coords = imageCoordSystem;
        this.setFixedOrigin(false);
        this.setFixedAngle(imageCoordSystem.isFixedAngle());
        this.setFixedScale(imageCoordSystem.isFixedScale());
        imageCoordSystem.addPropertyChangeListener("transform", this);
        pointMass.addPropertyChangeListener("step", this);
        pointMass.addPropertyChangeListener("steps", this);
        int n = 0;
        while (n < imageCoordSystem.getLength()) {
            this.setScaleXY(n, imageCoordSystem.getScaleX(n), imageCoordSystem.getScaleY(n));
            this.setCosineSine(n, imageCoordSystem.getCosine(n), imageCoordSystem.getSine(n));
            ++n;
        }
        this.setOrigins();
        this.lockEnabled = true;
    }

    @Override
    public void setFixedOrigin(boolean bl, int n) {
        super.setFixedOrigin(false, n);
    }

    @Override
    public void setLocked(boolean bl) {
        if (bl) {
            this.originLocked = this.originTrack.isLocked();
            this.originTrack.setLocked(true);
        } else {
            this.originTrack.setLocked(this.originLocked);
        }
        this.coords.setLocked(bl);
        super.setLocked(bl);
    }

    @Override
    public boolean isLocked() {
        return this.lockEnabled && this.coords.isLocked();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("step") || string.equals("steps")) {
            this.setOrigins();
        } else if (string.equals("transform")) {
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            if (n != null) {
                int n2 = n;
                this.setScaleXY(n2, this.coords.getScaleX(n2), this.coords.getScaleY(n2));
                this.setCosineSine(n2, this.coords.getCosine(n2), this.coords.getSine(n2));
                if (this.originTrack.isEmpty() && n2 == 0) {
                    this.setOrigins();
                }
            } else {
                int n3 = 0;
                while (n3 < this.coords.getLength()) {
                    this.setScaleXY(n3, this.coords.getScaleX(n3), this.coords.getScaleY(n3));
                    this.setCosineSine(n3, this.coords.getCosine(n3), this.coords.getSine(n3));
                    ++n3;
                }
                if (this.originTrack.isEmpty()) {
                    this.setOrigins();
                }
            }
        }
    }

    public ImageCoordSystem getCoords() {
        this.coords.removePropertyChangeListener("transform", this);
        this.coords.setFixedAngle(this.isFixedAngle());
        this.coords.setFixedScale(this.isFixedScale());
        int n = 0;
        while (n < this.coords.getLength()) {
            this.coords.setScaleXY(n, this.getScaleX(n), this.getScaleY(n));
            this.coords.setCosineSine(n, this.getCosine(n), this.getSine(n));
            ++n;
        }
        this.coords.addPropertyChangeListener("transform", this);
        return this.coords;
    }

    public PointMass getOriginTrack() {
        return this.originTrack;
    }

    protected void setOrigins() {
        PositionStep.Position position;
        Step step;
        this.firePropChange = false;
        double d = this.coords.getOriginX(0);
        double d2 = this.coords.getOriginY(0);
        int n = 0;
        while (n < this.coords.getLength()) {
            step = this.originTrack.getStep(n);
            if (step != null) {
                position = ((PositionStep)step).getPosition();
                d = position.getX();
                d2 = position.getY();
                break;
            }
            ++n;
        }
        n = 0;
        while (n < this.coords.getLength()) {
            step = this.originTrack.getStep(n);
            if (step != null) {
                position = ((PositionStep)step).getPosition();
                d = position.getX();
                d2 = position.getY();
            }
            this.setOriginXY(n, d, d2);
            ++n;
        }
        this.firePropChange = true;
        this.support.firePropertyChange("transform", null, null);
    }
}

