/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.RGBRegion;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class RGBStep
extends Step {
    protected static GeneralPath crosshair = new GeneralPath();
    protected Position position;
    protected RGBRegion rgbRegion;
    protected int radius;
    protected Map<TrackerPanel, Shape> hitShapes = new HashMap<TrackerPanel, Shape>();
    protected double[] rgbData = new double[5];
    protected boolean dataValid = false;
    protected BasicStroke stroke;

    static {
        crosshair.moveTo(0.0f, -3.0f);
        crosshair.lineTo(0.0f, 3.0f);
        crosshair.moveTo(-3.0f, 0.0f);
        crosshair.lineTo(3.0f, 0.0f);
    }

    public RGBStep(RGBRegion rGBRegion, int n, double d, double d2, int n2) {
        super(rGBRegion, n);
        this.radius = n2;
        this.rgbRegion = rGBRegion;
        this.position = new Position(d, d2);
        this.position.setStepEditTrigger(true);
        this.points = new TPoint[]{this.position};
        this.screenPoints = new Point[RGBStep.getLength()];
    }

    public TPoint getPosition() {
        return this.position;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        this.setHitRectCenter(n, n2);
        Shape shape = this.hitShapes.get(trackerPanel);
        if (shape != null && shape.intersects(hitRect)) {
            return this.position;
        }
        return null;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Mark mark = this.getMark(trackerPanel);
        if (mark != null) {
            mark.draw(graphics2D, false);
        }
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark;
        BasicStroke basicStroke = this.footprint.getStroke();
        int n = FontSizer.getIntegerFactor();
        float f = Math.min((float)n * basicStroke.getLineWidth(), (float)(this.radius / 3));
        f = Math.max(f, basicStroke.getLineWidth());
        if (this.stroke == null || this.stroke.getLineWidth() != f) {
            this.stroke = new BasicStroke(f);
        }
        if ((mark = (Mark)this.marks.get(trackerPanel)) == null) {
            transform = trackerPanel.getPixelTransform();
            if (!trackerPanel.isDrawingInImageSpace()) {
                transform.concatenate(trackerPanel.getCoords().getToWorldTransform(this.n));
            }
            Ellipse2D.Double double_ = new Ellipse2D.Double(this.position.getX() - (double)this.radius, this.position.getY() - (double)this.radius, 2 * this.radius, 2 * this.radius);
            final Shape shape = transform.createTransformedShape(double_);
            Point point = this.position.getScreenPosition(trackerPanel);
            transform.setToTranslation(point.x, point.y);
            final Shape shape2 = transform.createTransformedShape(crosshair);
            if (n > 1) {
                transform.scale(n, n);
            }
            final Shape shape3 = this.position == trackerPanel.getSelectedPoint() ? transform.createTransformedShape(selectionShape) : null;
            mark = new Mark(){

                @Override
                public void draw(Graphics2D graphics2D, boolean bl) {
                    Paint paint = graphics2D.getPaint();
                    graphics2D.setPaint(RGBStep.this.footprint.getColor());
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setStroke(RGBStep.this.stroke);
                    if (shape3 != null) {
                        graphics2D.fill(shape3);
                    } else {
                        graphics2D.draw(shape2);
                    }
                    graphics2D.draw(shape);
                    graphics2D.setPaint(paint);
                }

                @Override
                public Rectangle getBounds(boolean bl) {
                    return shape.getBounds();
                }
            };
            this.marks.put(trackerPanel, mark);
            this.hitShapes.put(trackerPanel, shape2);
        }
        return mark;
    }

    @Override
    public Rectangle getBounds(TrackerPanel trackerPanel) {
        Rectangle rectangle = this.getMark(trackerPanel).getBounds(false);
        return rectangle;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    @Override
    public Object clone() {
        RGBStep rGBStep = (RGBStep)super.clone();
        if (rGBStep != null) {
            rGBStep.hitShapes = new HashMap<TrackerPanel, Shape>();
            TPoint[] tPointArray = rGBStep.points;
            RGBStep rGBStep2 = rGBStep;
            rGBStep2.getClass();
            rGBStep.position = rGBStep2.new Position(this.position.getX(), this.position.getY());
            tPointArray[0] = rGBStep.position;
            rGBStep.position.setStepEditTrigger(true);
            rGBStep.rgbData = new double[5];
            rGBStep.dataValid = false;
        }
        return rGBStep;
    }

    @Override
    public String toString() {
        return "RGBStep " + this.n + " [" + format.format(this.position.x) + ", " + format.format(this.position.y) + "]";
    }

    public double[] getRGBData(TrackerPanel trackerPanel) {
        BufferedImage bufferedImage;
        Video video = trackerPanel.getVideo();
        if (video == null || !video.isVisible()) {
            return null;
        }
        if (!this.dataValid && trackerPanel.getFrameNumber() == this.n && (bufferedImage = video.getImage()) != null && bufferedImage.getType() == 1) {
            int n;
            int n2;
            int n3;
            int n4;
            block8: {
                int n5;
                RGBStep rGBStep = this.rgbRegion.isFixedPosition() ? (RGBStep)this.rgbRegion.getStep(0) : this;
                TPoint tPoint = rGBStep.getPosition();
                Ellipse2D.Double double_ = new Ellipse2D.Double(tPoint.getX() - (double)this.radius, tPoint.getY() - (double)this.radius, 2 * this.radius, 2 * this.radius);
                int n6 = n5 = 2 * this.radius + 1;
                int n7 = (int)tPoint.getX() - this.radius;
                int n8 = (int)tPoint.getY() - this.radius;
                Point2D.Double double_2 = new Point2D.Double();
                try {
                    int[] nArray = new int[n5 * n6];
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                    n = 0;
                    bufferedImage.getRaster().getDataElements(n7, n8, n6, n5, nArray);
                    int n9 = 0;
                    while (n9 < n6) {
                        int n10 = 0;
                        while (n10 < n5) {
                            ((Point2D)double_2).setLocation((double)(n7 + n9) + 0.5, (double)(n8 + n10) + 0.5);
                            if (double_.contains(double_2)) {
                                int n11 = nArray[n9 + n10 * n6];
                                ++n4;
                                n3 += n11 >> 16 & 0xFF;
                                n2 += n11 >> 8 & 0xFF;
                                n += n11 & 0xFF;
                            }
                            ++n10;
                        }
                        ++n9;
                    }
                    if (n4 != 0) break block8;
                    return null;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return null;
                }
            }
            double d = 1.0 * (double)n3 / (double)n4;
            double d2 = 1.0 * (double)n2 / (double)n4;
            double d3 = 1.0 * (double)n / (double)n4;
            this.rgbData[0] = d;
            this.rgbData[1] = d2;
            this.rgbData[2] = d3;
            this.rgbData[3] = RGBRegion.getLuma(d, d2, d3);
            this.rgbData[4] = n4;
            this.dataValid = true;
        }
        this.dataVisible = true;
        return this.rgbData;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            RGBStep rGBStep = (RGBStep)object;
            xMLControl.setValue("x", rGBStep.position.x);
            xMLControl.setValue("y", rGBStep.position.y);
            xMLControl.setValue("radius", rGBStep.radius);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            RGBStep rGBStep = (RGBStep)object;
            rGBStep.setRadius(xMLControl.getInt("radius"));
            double d = xMLControl.getDouble("x");
            double d2 = xMLControl.getDouble("y");
            rGBStep.position.setXY(d, d2);
            return object;
        }
    }

    protected class Position
    extends TPoint {
        public Position(double d, double d2) {
            super(d, d2);
        }

        @Override
        public void setXY(double d, double d2) {
            if (RGBStep.this.track.isLocked()) {
                return;
            }
            if (RGBStep.this.rgbRegion.isFixedPosition()) {
                RGBStep rGBStep = (RGBStep)RGBStep.this.rgbRegion.steps.getStep(0);
                rGBStep.getPosition().setLocation(d, d2);
                rGBStep.erase();
                RGBStep.this.rgbRegion.refreshStep(RGBStep.this);
                RGBStep.this.rgbRegion.clearData();
            } else {
                this.setLocation(d, d2);
                RGBStep.this.rgbRegion.keyFrames.add(RGBStep.this.n);
                RGBStep.this.dataValid = false;
            }
            RGBStep.this.repaint();
            RGBStep.this.track.support.firePropertyChange("step", null, new Integer(RGBStep.this.n));
        }

        @Override
        public void showCoordinates(VideoPanel videoPanel) {
            Point2D point2D = this.getWorldPosition(videoPanel);
            RGBStep.this.track.xField.setValue(point2D.getX());
            RGBStep.this.track.yField.setValue(point2D.getY());
            super.showCoordinates(videoPanel);
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return RGBStep.this.n;
        }
    }
}

