/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class ProtractorFootprint
implements Footprint,
Cloneable {
    public static final float[] DOTTED_LINE = new float[]{2.0f, 2.0f};
    private static final ProtractorFootprint CIRCLE_3;
    private static final ProtractorFootprint CIRCLE_5;
    private static final ProtractorFootprint CIRCLE_3_BOLD;
    private static final ProtractorFootprint CIRCLE_5_BOLD;
    protected static int arcRadius;
    private static Collection<ProtractorFootprint> footprints;
    private static Shape hitShape;
    private static Shape arrowhead;
    private static Line2D line1;
    private static Line2D line2;
    private static Point p;
    private static AffineTransform transform;
    private static Arc2D arc;
    protected String name;
    protected BasicStroke baseStroke;
    protected BasicStroke stroke;
    protected Color color = Color.black;
    protected Shape[] hitShapes = new Shape[6];
    protected Shape circle;
    protected int radius;
    private Stroke arcStroke;
    private Stroke arcAdjustStroke;

    static {
        arcRadius = 24;
        footprints = new HashSet<ProtractorFootprint>();
        hitShape = new Ellipse2D.Double(-6.0, -6.0, 12.0, 12.0);
        line1 = new Line2D.Double();
        line2 = new Line2D.Double();
        p = new Point();
        transform = new AffineTransform();
        arc = new Arc2D.Double(-arcRadius, -arcRadius, 2 * arcRadius, 2 * arcRadius, 0.0, 0.0, 0);
        BasicStroke basicStroke = new BasicStroke(1.0f);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-6.0f, 2.0f);
        generalPath.lineTo(0.0f, 0.0f);
        generalPath.lineTo(-6.0f, -3.0f);
        arrowhead = basicStroke.createStrokedShape(generalPath);
        CIRCLE_3 = new ProtractorFootprint("ProtractorFootprint.Circle3", 3);
        CIRCLE_3.setStroke(basicStroke);
        footprints.add(CIRCLE_3);
        CIRCLE_5 = new ProtractorFootprint("ProtractorFootprint.Circle5", 5);
        CIRCLE_5.setStroke(basicStroke);
        footprints.add(CIRCLE_5);
        basicStroke = new BasicStroke(2.0f);
        CIRCLE_3_BOLD = new ProtractorFootprint("ProtractorFootprint.Circle3Bold", 3);
        CIRCLE_3_BOLD.setStroke(basicStroke);
        footprints.add(CIRCLE_3_BOLD);
        CIRCLE_5_BOLD = new ProtractorFootprint("ProtractorFootprint.Circle5Bold", 5);
        CIRCLE_5_BOLD.setStroke(basicStroke);
        footprints.add(CIRCLE_5_BOLD);
    }

    public ProtractorFootprint(String string, int n) {
        this.name = string;
        this.radius = n;
        this.circle = new Ellipse2D.Double(-n, -n, 2 * n, 2 * n);
        this.setStroke(new BasicStroke());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return TrackerRes.getString(this.name);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public Icon getIcon(int n, int n2) {
        int n3 = FontSizer.getIntegerFactor();
        n *= n3;
        n2 *= n3;
        transform.setToScale(n3, n3);
        Shape shape = transform.createTransformedShape(this.circle);
        if (this.stroke == null || this.stroke.getLineWidth() != (float)n3 * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)n3 * this.baseStroke.getLineWidth());
            this.arcStroke = new BasicStroke(n3);
            this.arcAdjustStroke = new BasicStroke(this.stroke.getLineWidth(), 0, 0, 8.0f, DOTTED_LINE, this.stroke.getDashPhase());
        }
        shape = this.stroke.createStrokedShape(shape);
        Area area = new Area(shape);
        double d = n3 * (this.radius + 2) - n;
        double d2 = n2 - n3 * (this.radius + 2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d * (double)n3 * (double)this.radius / d3;
        double d5 = d2 * (double)n3 * (double)this.radius / d3;
        Line2D.Double double_ = new Line2D.Double(d, d2, d4, d5);
        area.add(new Area(this.stroke.createStrokedShape(double_)));
        ((Line2D)double_).setLine(d, d2, this.radius - 2, d2);
        area.add(new Area(this.stroke.createStrokedShape(double_)));
        ShapeIcon shapeIcon = new ShapeIcon(area, n, n2);
        shapeIcon.setColor(this.color);
        return shapeIcon;
    }

    @Override
    public Mark getMark(Point[] pointArray) {
        final Shape shape = this.getShape(pointArray);
        final Color color = this.color;
        return new Mark(){

            @Override
            public void draw(Graphics2D graphics2D, boolean bl) {
                Color color2 = graphics2D.getColor();
                graphics2D.setColor(color);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.fill(shape);
                graphics2D.setColor(color2);
            }

            @Override
            public Rectangle getBounds(boolean bl) {
                return shape.getBounds();
            }
        };
    }

    @Override
    public Shape[] getHitShapes() {
        return this.hitShapes;
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        if (basicStroke == null) {
            return;
        }
        this.baseStroke = new BasicStroke(basicStroke.getLineWidth(), 0, 0, 8.0f, basicStroke.getDashArray(), basicStroke.getDashPhase());
        this.arcAdjustStroke = new BasicStroke(basicStroke.getLineWidth(), 0, 0, 8.0f, DOTTED_LINE, basicStroke.getDashPhase());
    }

    @Override
    public BasicStroke getStroke() {
        return this.baseStroke;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public Shape getCircleShape(Point point) {
        transform.setToTranslation(point.x, point.y);
        int n = FontSizer.getIntegerFactor();
        if (n > 1) {
            transform.scale(n, n);
        }
        Shape shape = transform.createTransformedShape(this.circle);
        shape = this.stroke.createStrokedShape(shape);
        return shape;
    }

    public Shape getArcAdjustShape(Point point, Point point2) {
        double d = Math.toRadians(arc.getAngleStart() + arc.getAngleExtent() / 2.0);
        int n = FontSizer.getIntegerFactor();
        ProtractorFootprint.p.x = (int)Math.round((double)point.x + (double)(n * arcRadius) * Math.cos(d));
        ProtractorFootprint.p.y = (int)Math.round((double)point.y - (double)(n * arcRadius) * Math.sin(d));
        Shape shape = this.getCircleShape(p);
        Area area = new Area(shape);
        if (point2 != null) {
            int n2 = shape.getBounds().width / 2;
            double d2 = p.distance(point2);
            line1.setLine(p.getX(), p.getY(), point2.getX(), point2.getY());
            if (d2 > 1.0) {
                ProtractorFootprint.adjustLineLength(line1, (d2 - (double)n2) / d2, (d2 - 6.0) / d2);
            }
            area.add(new Area(this.arcAdjustStroke.createStrokedShape(line1)));
        }
        return area;
    }

    @Override
    public Shape getShape(Point[] pointArray) {
        Point point = pointArray[0];
        Point point2 = pointArray[1];
        Point point3 = pointArray[2];
        int n = FontSizer.getIntegerFactor();
        int n2 = n * this.circle.getBounds().width / 2;
        line1.setLine(point, point2);
        double d = point.distance(point2);
        if (d > 1.0) {
            ProtractorFootprint.adjustLineLength(line1, 1.0, (d - (double)n2) / d);
        }
        line2.setLine(point, point3);
        double d2 = point.distance(point3);
        if (d2 > 1.0) {
            ProtractorFootprint.adjustLineLength(line2, 1.0, (d2 - (double)n2) / d2);
        }
        if (this.stroke == null || this.stroke.getLineWidth() != (float)n * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)n * this.baseStroke.getLineWidth());
            this.arcStroke = new BasicStroke(n);
            this.arcAdjustStroke = new BasicStroke(this.stroke.getLineWidth(), 0, 0, 8.0f, DOTTED_LINE, this.stroke.getDashPhase());
        }
        transform.setToTranslation(point2.x, point2.y);
        if (n > 1) {
            transform.scale(n, n);
        }
        Shape shape = transform.createTransformedShape(this.circle);
        shape = this.stroke.createStrokedShape(shape);
        transform.setToTranslation(point3.x, point3.y);
        if (n > 1) {
            transform.scale(n, n);
        }
        Shape shape2 = transform.createTransformedShape(this.circle);
        shape2 = this.stroke.createStrokedShape(shape2);
        double d3 = -Math.atan2(point2.y - point.y, point2.x - point.x);
        double d4 = -Math.atan2(point3.y - point.y, point3.x - point.x);
        arc.setAngleStart(Math.toDegrees(d3));
        double d5 = Math.toDegrees(d4 - d3);
        if (d5 > 180.0) {
            d5 -= 360.0;
        }
        if (d5 < -180.0) {
            d5 += 360.0;
        }
        arc.setAngleExtent(d5);
        transform.setToTranslation(point.x, point.y);
        if (n > 1) {
            transform.scale(n, n);
        }
        Shape shape3 = transform.createTransformedShape(arc);
        Shape shape4 = null;
        if (Math.abs(d5) > 10.0) {
            double d6 = point.getX() + (double)(n * arcRadius) * (point3.getX() - point.getX()) / d2;
            double d7 = point.getY() + (double)(n * arcRadius) * (point3.getY() - point.getY()) / d2;
            double d8 = -d4 - 1.5707963267948966;
            if (d5 < 0.0) {
                d8 += Math.PI;
            }
            transform.setToRotation(d8, d6, d7);
            transform.translate(d6, d7);
            if (n > 1) {
                transform.scale(n, n);
            }
            shape4 = transform.createTransformedShape(arrowhead);
        }
        Area area = new Area(this.stroke.createStrokedShape(line1));
        area.add(new Area(this.stroke.createStrokedShape(line2)));
        area.add(new Area(shape));
        area.add(new Area(shape2));
        area.add(new Area(this.arcStroke.createStrokedShape(shape3)));
        if (shape4 != null) {
            area.add(new Area(shape4));
        }
        transform.setToTranslation(point.x, point.y);
        if (n > 1) {
            transform.scale(n, n);
        }
        this.hitShapes[0] = transform.createTransformedShape(hitShape);
        transform.setToTranslation(point2.x, point2.y);
        if (n > 1) {
            transform.scale(n, n);
        }
        this.hitShapes[1] = transform.createTransformedShape(hitShape);
        transform.setToTranslation(point3.x, point3.y);
        if (n > 1) {
            transform.scale(n, n);
        }
        this.hitShapes[2] = transform.createTransformedShape(hitShape);
        if (d > 1.0) {
            ProtractorFootprint.adjustLineLength(line1, (d - (double)(n * arcRadius) - 8.0) / d, (d - 8.0) / d);
        }
        if (d2 > 1.0) {
            ProtractorFootprint.adjustLineLength(line2, (d2 - (double)(n * arcRadius) - 8.0) / d2, (d2 - 8.0) / d2);
        }
        this.hitShapes[3] = this.baseStroke.createStrokedShape(line1);
        this.hitShapes[4] = this.baseStroke.createStrokedShape(line2);
        this.hitShapes[5] = this.baseStroke.createStrokedShape(shape3);
        return area;
    }

    private static void adjustLineLength(Line2D line2D, double d, double d2) {
        double d3 = line2D.getX2() + (line2D.getX1() - line2D.getX2()) * d;
        double d4 = line2D.getY2() + (line2D.getY1() - line2D.getY2()) * d;
        double d5 = line2D.getX1() + (line2D.getX2() - line2D.getX1()) * d2;
        double d6 = line2D.getY1() + (line2D.getY2() - line2D.getY1()) * d2;
        line2D.setLine(d3, d4, d5, d6);
    }

    public static Footprint getFootprint(String string) {
        for (ProtractorFootprint protractorFootprint : footprints) {
            if (string != protractorFootprint.getName()) continue;
            try {
                return (ProtractorFootprint)protractorFootprint.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return null;
    }
}

