/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class PointShapeFootprint
implements Footprint,
Cloneable {
    protected String name;
    protected Shape shape;
    protected Shape highlight;
    protected AffineTransform transform = new AffineTransform();
    protected BasicStroke baseStroke = new BasicStroke();
    protected BasicStroke stroke;
    protected Color color = Color.black;
    protected Shape[] hitShapes = new Shape[1];
    protected double defaultWidth = 1.0;
    protected static Collection<PointShapeFootprint> footprints = new HashSet<PointShapeFootprint>();
    private static final Shape HIGHLIGHT;
    private static final PointShapeFootprint DIAMOND;
    private static final PointShapeFootprint BOLD_DIAMOND;
    private static final PointShapeFootprint SOLID_DIAMOND;
    private static final PointShapeFootprint TRIANGLE;
    private static final PointShapeFootprint BOLD_TRIANGLE;
    private static final PointShapeFootprint SOLID_TRIANGLE;
    private static final PointShapeFootprint CIRCLE;
    private static final PointShapeFootprint BOLD_CIRCLE;
    private static final PointShapeFootprint SOLID_CIRCLE;
    private static final PointShapeFootprint VERT_LINE;
    private static final PointShapeFootprint BOLD_VERT_LINE;
    private static final PointShapeFootprint HORZ_LINE;
    private static final PointShapeFootprint BOLD_HORZ_LINE;
    private static final PointShapeFootprint CROSSHAIR;
    private static final PointShapeFootprint BOLD_CROSSHAIR;
    private static final PointShapeFootprint SIMPLE_AXES;
    private static final PointShapeFootprint BOLD_SIMPLE_AXES;
    private static final PointShapeFootprint SMALL_SPOT;
    private static final PointShapeFootprint SMALL_CIRCLE;
    private static final PointShapeFootprint SOLID_SQUARE;

    static {
        float f = 3000.0f;
        Ellipse2D.Double double_ = new Ellipse2D.Double();
        ((RectangularShape)double_).setFrame(-6.0, -6.0, 12.0, 12.0);
        BasicStroke basicStroke = new BasicStroke(2.0f);
        HIGHLIGHT = basicStroke.createStrokedShape(double_);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-5.0f, 0.0f);
        generalPath.lineTo(0.0f, 5.0f);
        generalPath.lineTo(5.01f, 0.0f);
        generalPath.lineTo(0.0f, -5.0f);
        generalPath.closePath();
        DIAMOND = new PointShapeFootprint("Footprint.Diamond", generalPath);
        footprints.add(DIAMOND);
        BOLD_DIAMOND = new PointShapeFootprint("Footprint.BoldDiamond", generalPath);
        BOLD_DIAMOND.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_DIAMOND);
        SOLID_DIAMOND = new PointShapeFootprint("Footprint.SolidDiamond", generalPath);
        SOLID_DIAMOND.setStroke(null);
        footprints.add(SOLID_DIAMOND);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(0.0f, -5.0f);
        generalPath2.lineTo(4.0f, 3.0f);
        generalPath2.lineTo(-4.0f, 3.0f);
        generalPath2.closePath();
        TRIANGLE = new PointShapeFootprint("Footprint.Triangle", generalPath2);
        footprints.add(TRIANGLE);
        BOLD_TRIANGLE = new PointShapeFootprint("Footprint.BoldTriangle", generalPath2);
        BOLD_TRIANGLE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_TRIANGLE);
        SOLID_TRIANGLE = new PointShapeFootprint("Footprint.SolidTriangle", generalPath2);
        SOLID_TRIANGLE.setStroke(null);
        footprints.add(SOLID_TRIANGLE);
        ((RectangularShape)double_).setFrame(-5.0, -5.0, 10.0, 10.0);
        CIRCLE = new PointShapeFootprint("Footprint.Circle", double_);
        footprints.add(CIRCLE);
        BOLD_CIRCLE = new PointShapeFootprint("Footprint.BoldCircle", double_);
        BOLD_CIRCLE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_CIRCLE);
        SOLID_CIRCLE = new PointShapeFootprint("Footprint.SolidCircle", double_);
        SOLID_CIRCLE.setStroke(null);
        footprints.add(SOLID_CIRCLE);
        ((RectangularShape)double_).setFrame(-3.0, -3.0, 6.0, 6.0);
        SMALL_CIRCLE = new PointShapeFootprint("Footprint.SmallCircle", double_);
        footprints.add(SMALL_CIRCLE);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0);
        SMALL_SPOT = new PointShapeFootprint("Footprint.Spot", double_2);
        SMALL_SPOT.setStroke(null);
        footprints.add(SMALL_SPOT);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo(0.0f, -f);
        generalPath3.lineTo(0.0f, f);
        generalPath3.moveTo(-3.0f, 0.0f);
        generalPath3.lineTo(3.0f, 0.0f);
        VERT_LINE = new PointShapeFootprint("Footprint.VerticalLine", generalPath3);
        footprints.add(VERT_LINE);
        BOLD_VERT_LINE = new PointShapeFootprint("Footprint.BoldVerticalLine", generalPath3);
        BOLD_VERT_LINE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_VERT_LINE);
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.moveTo(0.0f, -3.0f);
        generalPath4.lineTo(0.0f, 3.0f);
        generalPath4.moveTo(-f, 0.0f);
        generalPath4.lineTo(f, 0.0f);
        HORZ_LINE = new PointShapeFootprint("Footprint.HorizontalLine", generalPath4);
        footprints.add(HORZ_LINE);
        BOLD_HORZ_LINE = new PointShapeFootprint("Footprint.BoldHorizontalLine", generalPath4);
        BOLD_HORZ_LINE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_HORZ_LINE);
        GeneralPath generalPath5 = new GeneralPath();
        generalPath5.moveTo(0.0f, -4.0f);
        generalPath5.lineTo(0.0f, 4.0f);
        generalPath5.moveTo(-4.0f, 0.0f);
        generalPath5.lineTo(4.0f, 0.0f);
        CROSSHAIR = new PointShapeFootprint("Footprint.Crosshair", generalPath5);
        footprints.add(CROSSHAIR);
        BOLD_CROSSHAIR = new PointShapeFootprint("Footprint.BoldCrosshair", generalPath5);
        BOLD_CROSSHAIR.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_CROSSHAIR);
        GeneralPath generalPath6 = new GeneralPath();
        generalPath6.reset();
        generalPath6.moveTo(f, 0.0f);
        generalPath6.lineTo(-f, 0.0f);
        generalPath6.moveTo(0.0f, f);
        generalPath6.lineTo(0.0f, -f);
        generalPath6.moveTo(15.0f, 5.0f);
        generalPath6.lineTo(15.0f, -5.0f);
        SIMPLE_AXES = new PointShapeFootprint("Footprint.SimpleAxes", generalPath6);
        footprints.add(SIMPLE_AXES);
        BOLD_SIMPLE_AXES = new PointShapeFootprint("Footprint.BoldSimpleAxes", generalPath6);
        BOLD_SIMPLE_AXES.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_SIMPLE_AXES);
        Rectangle rectangle = new Rectangle(-3, -3, 6, 6);
        SOLID_SQUARE = new PointShapeFootprint("Footprint.SolidSquare", rectangle);
        SOLID_SQUARE.setStroke(null);
        footprints.add(SOLID_SQUARE);
    }

    public PointShapeFootprint(String string, Shape shape) {
        this.name = string;
        this.shape = shape;
    }

    public static PointShapeFootprint getFootprint(String string) {
        for (PointShapeFootprint pointShapeFootprint : footprints) {
            if (string != pointShapeFootprint.getName()) continue;
            try {
                return (PointShapeFootprint)pointShapeFootprint.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return TrackerRes.getString(this.name);
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Icon getIcon(int n, int n2) {
        int n3 = FontSizer.getIntegerFactor();
        Shape shape = this.getShape(new Point[]{new Point()});
        ShapeIcon shapeIcon = new ShapeIcon(shape, n *= n3, n2 *= n3);
        shapeIcon.setColor(this.color);
        return shapeIcon;
    }

    @Override
    public Mark getMark(Point[] pointArray) {
        final Shape shape = this.getShape(pointArray);
        final Shape shape2 = this.highlight;
        return new Mark(){

            @Override
            public void draw(Graphics2D graphics2D, boolean bl) {
                Paint paint = graphics2D.getPaint();
                graphics2D.setPaint(PointShapeFootprint.this.color);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.fill(shape);
                if (bl) {
                    graphics2D.fill(shape2);
                }
                graphics2D.setPaint(paint);
            }

            @Override
            public Rectangle getBounds(boolean bl) {
                Rectangle rectangle = shape.getBounds();
                if (bl) {
                    rectangle.add(shape2.getBounds());
                }
                return rectangle;
            }
        };
    }

    @Override
    public Shape[] getHitShapes() {
        return this.hitShapes;
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        this.baseStroke = basicStroke;
        if (basicStroke != null) {
            this.defaultWidth = basicStroke.getLineWidth();
        }
    }

    @Override
    public BasicStroke getStroke() {
        return this.baseStroke;
    }

    public void setLineWidth(double d) {
        if (this.baseStroke == null) {
            return;
        }
        this.baseStroke = new BasicStroke((float)d, 0, 0, 8.0f, this.baseStroke.getDashArray(), this.baseStroke.getDashPhase());
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Shape getShape(Point[] pointArray) {
        Point point = pointArray[0];
        this.transform.setToTranslation(point.x, point.y);
        int n = FontSizer.getIntegerFactor();
        if (n > 1) {
            this.transform.scale(n, n);
        }
        Shape shape = this.transform.createTransformedShape(this.shape);
        this.highlight = this.transform.createTransformedShape(HIGHLIGHT);
        if (this.baseStroke != null) {
            if (this.stroke == null || this.stroke.getLineWidth() != (float)n * this.baseStroke.getLineWidth()) {
                this.stroke = new BasicStroke((float)n * this.baseStroke.getLineWidth());
            }
            shape = this.stroke.createStrokedShape(shape);
        }
        this.hitShapes[0] = shape;
        return shape;
    }
}

