/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.BounceDerivatives;
import org.opensourcephysics.cabrillo.tracker.CenterOfMass;
import org.opensourcephysics.cabrillo.tracker.CircleFootprint;
import org.opensourcephysics.cabrillo.tracker.Derivative;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.FirstDerivative;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.PositionVectorFootprint;
import org.opensourcephysics.cabrillo.tracker.SecondDerivative;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class PointMass
extends TTrack {
    protected static final int FINITE_DIFF = 0;
    protected static final int BOUNCE_DETECT = 1;
    protected static final double MINIMUM_MASS = 1.0E-30;
    protected static Derivative vDeriv = new FirstDerivative();
    protected static Derivative aDeriv = new SecondDerivative();
    protected static BounceDerivatives bounceDerivs = new BounceDerivatives();
    protected double mass;
    protected Footprint[] vFootprints;
    protected Footprint vFootprint = LineFootprint.getFootprint("Footprint.Arrow");
    protected Footprint[] aFootprints;
    protected Footprint aFootprint = LineFootprint.getFootprint("Footprint.Arrow");
    protected Map<TrackerPanel, TTrack.StepArray> vMap = new HashMap<TrackerPanel, TTrack.StepArray>();
    protected Map<TrackerPanel, TTrack.StepArray> aMap = new HashMap<TrackerPanel, TTrack.StepArray>();
    protected Map<TrackerPanel, Boolean> xVisMap = new HashMap<TrackerPanel, Boolean>();
    protected Map<TrackerPanel, Boolean> vVisMap = new HashMap<TrackerPanel, Boolean>();
    protected Map<TrackerPanel, Boolean> aVisMap = new HashMap<TrackerPanel, Boolean>();
    protected boolean xVisibleOnAll = false;
    protected boolean vVisibleOnAll = false;
    protected boolean aVisibleOnAll = false;
    protected int algorithm = 0;
    protected int vDerivSpill = 1;
    protected int aDerivSpill = 2;
    protected int bounceDerivsSpill = 3;
    protected int[] params = new int[4];
    protected double[] xData = new double[5];
    protected double[] yData = new double[5];
    protected boolean[] validData = new boolean[5];
    protected Object[] derivData = new Object[]{this.params, this.xData, this.yData, this.validData};
    protected JLabel massLabel;
    protected NumberField massField;
    protected Component mSeparator;
    protected JMenu velocityMenu;
    protected JMenu accelerationMenu;
    protected JMenuItem vColorItem;
    protected JMenuItem aColorItem;
    protected JMenu vFootprintMenu;
    protected JMenu aFootprintMenu;
    protected JMenuItem vTailsToOriginItem;
    protected JMenuItem vTailsToPositionItem;
    protected JMenuItem aTailsToOriginItem;
    protected JMenuItem aTailsToPositionItem;
    protected JMenuItem autotrackItem;
    protected JCheckBoxMenuItem vVisibleItem;
    protected JCheckBoxMenuItem aVisibleItem;
    protected boolean vAtOrigin;
    protected boolean aAtOrigin;
    protected boolean traceVisible = false;
    protected GeneralPath trace = new GeneralPath();
    protected Stroke traceStroke = new BasicStroke(1.0f);

    public PointMass() {
        this(1.0);
    }

    public PointMass(double d) {
        this.defaultColors = new Color[]{Color.red, Color.cyan, Color.magenta, new Color(153, 153, 255)};
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.Diamond"), PointShapeFootprint.getFootprint("Footprint.Triangle"), CircleFootprint.getFootprint("CircleFootprint.Circle"), PointShapeFootprint.getFootprint("Footprint.VerticalLine"), PointShapeFootprint.getFootprint("Footprint.HorizontalLine"), new PositionVectorFootprint(this, "Footprint.PositionVector", 1), PointShapeFootprint.getFootprint("Footprint.Spot"), PointShapeFootprint.getFootprint("Footprint.BoldDiamond"), PointShapeFootprint.getFootprint("Footprint.BoldTriangle"), PointShapeFootprint.getFootprint("Footprint.BoldVerticalLine"), PointShapeFootprint.getFootprint("Footprint.BoldHorizontalLine"), new PositionVectorFootprint(this, "Footprint.BoldPositionVector", 2)});
        this.defaultFootprint = this.getFootprint();
        this.setVelocityFootprints(new Footprint[]{LineFootprint.getFootprint("Footprint.Arrow"), LineFootprint.getFootprint("Footprint.BoldArrow"), LineFootprint.getFootprint("Footprint.BigArrow")});
        this.setAccelerationFootprints(new Footprint[]{LineFootprint.getFootprint("Footprint.Arrow"), LineFootprint.getFootprint("Footprint.BoldArrow"), LineFootprint.getFootprint("Footprint.BigArrow")});
        this.setName(TrackerRes.getString("PointMass.New.Name"));
        this.setProperty("xVarPlot0", "t");
        this.setProperty("yVarPlot0", "x");
        this.setProperty("xVarPlot1", "t");
        this.setProperty("yVarPlot1", "y");
        this.mass = Math.abs(d);
        this.setTrailVisible(true);
        this.setAutoAdvance(true);
        this.hint = String.valueOf(TrackerRes.getString("PointMass.Hint")) + TrackerRes.getString("PointMass.Unmarked.Hint");
        this.createGUI();
    }

    @Override
    public void setColor(Color color) {
        this.setVelocityColor(color);
        this.setAccelerationColor(color);
        super.setColor(color);
    }

    public void setVelocityColor(Color color) {
        int n = 0;
        while (n < this.vFootprints.length) {
            this.vFootprints[n].setColor(color);
            ++n;
        }
    }

    public void setAccelerationColor(Color color) {
        int n = 0;
        while (n < this.aFootprints.length) {
            this.aFootprints[n].setColor(color);
            ++n;
        }
    }

    @Override
    public Step createStep(int n, double d, double d2) {
        JDialog jDialog;
        Step step;
        int n2;
        Object object;
        PositionStep positionStep;
        if (this.isLocked()) {
            return null;
        }
        boolean bl = this.steps.isEmpty();
        if (bl && this.trackerPanel != null) {
            this.stepSizeWhenFirstMarked = this.trackerPanel.getPlayer().getVideoClip().getStepSize();
        }
        if ((positionStep = (PositionStep)this.getStep(n)) == null) {
            positionStep = new PositionStep(this, n, d, d2);
            this.steps.setStep(n, positionStep);
            positionStep.setFootprint(this.getFootprint());
        } else if (d != positionStep.getPosition().x || d2 != positionStep.getPosition().y) {
            object = new XMLControlElement(positionStep);
            positionStep.getPosition().setLocation(d, d2);
            Undo.postStepEdit(positionStep, (XMLControl)object);
            positionStep.erase();
        }
        if (!this.autoTrackerMarking) {
            this.updateDerivatives(n);
        }
        this.support.firePropertyChange("step", null, new Integer(n));
        if (skippedStepWarningOn && this.steps.isPreceded(n) && this.trackerPanel != null && !this.isDependent() && (n2 = ((VideoClip)(object = this.trackerPanel.getPlayer().getVideoClip())).frameToStep(n)) > 0 && (step = this.getStep(((VideoClip)object).stepToFrame(n2 - 1))) == null && (jDialog = this.getSkippedStepWarningDialog()) != null) {
            jDialog.setVisible(true);
        }
        return positionStep;
    }

    @Override
    public Step deleteStep(int n) {
        AutoTracker autoTracker;
        Step step = super.deleteStep(n);
        if (step != null) {
            this.updateDerivatives(n);
        }
        if ((autoTracker = this.trackerPanel.getAutoTracker()).getTrack() == this) {
            autoTracker.delete(n);
        }
        return step;
    }

    @Override
    public Step getStep(TPoint tPoint, TrackerPanel trackerPanel) {
        if (tPoint == null) {
            return null;
        }
        Step[] stepArray = null;
        int n = 0;
        while (n < 3) {
            switch (n) {
                case 0: {
                    stepArray = this.steps.array;
                    break;
                }
                case 1: {
                    stepArray = this.getVelocities(trackerPanel);
                    break;
                }
                case 2: {
                    stepArray = this.getAccelerations(trackerPanel);
                }
            }
            int n2 = 0;
            while (n2 < stepArray.length) {
                if (stepArray[n2] != null) {
                    TPoint[] tPointArray = stepArray[n2].getPoints();
                    int n3 = 0;
                    while (n3 < tPointArray.length) {
                        if (tPointArray[n3] == tPoint) {
                            return stepArray[n2];
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    @Override
    public Step getNextVisibleStep(Step step, TrackerPanel trackerPanel) {
        Step[] stepArray = this.getSteps();
        if (this.isVelocity(step)) {
            stepArray = this.getVelocities(trackerPanel);
        }
        if (this.isAcceleration(step)) {
            stepArray = this.getAccelerations(trackerPanel);
        }
        boolean bl = false;
        int n = 0;
        while (n < stepArray.length) {
            if (bl && stepArray[n] != null && this.isStepVisible(stepArray[n], trackerPanel)) {
                return stepArray[n];
            }
            if (stepArray[n] == step) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            n = 0;
            while (n < stepArray.length) {
                if (stepArray[n] != null && stepArray[n] != step && this.isStepVisible(stepArray[n], trackerPanel)) {
                    return stepArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    @Override
    public Step getPreviousVisibleStep(Step step, TrackerPanel trackerPanel) {
        Step[] stepArray = this.getSteps();
        if (this.isVelocity(step)) {
            stepArray = this.getVelocities(trackerPanel);
        }
        if (this.isAcceleration(step)) {
            stepArray = this.getAccelerations(trackerPanel);
        }
        boolean bl = false;
        int n = stepArray.length - 1;
        while (n > -1) {
            if (bl && stepArray[n] != null && this.isStepVisible(stepArray[n], trackerPanel)) {
                return stepArray[n];
            }
            if (stepArray[n] == step) {
                bl = true;
            }
            --n;
        }
        if (bl) {
            n = stepArray.length - 1;
            while (n > -1) {
                if (stepArray[n] != null && stepArray[n] != step && this.isStepVisible(stepArray[n], trackerPanel)) {
                    return stepArray[n];
                }
                --n;
            }
        }
        return null;
    }

    @Override
    public int getStepLength() {
        return PositionStep.getLength();
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    public Footprint[] getVelocityFootprints() {
        return this.vFootprints;
    }

    public void setVelocityFootprints(Footprint[] footprintArray) {
        ArrayList<Footprint> arrayList = new ArrayList<Footprint>();
        int n = 0;
        while (n < footprintArray.length) {
            if (footprintArray[n] != null && footprintArray[n].getLength() == this.vFootprint.getLength()) {
                footprintArray[n].setColor(this.vFootprint.getColor());
                arrayList.add(footprintArray[n]);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.vFootprints = arrayList.toArray(new Footprint[0]);
            this.setVelocityFootprint(this.vFootprints[0].getName());
        }
    }

    public Footprint getVelocityFootprint() {
        return this.vFootprint;
    }

    public void setVelocityFootprint(String string) {
        int n = 0;
        while (n < this.vFootprints.length) {
            if (string.equals(this.vFootprints[n].getName())) {
                this.vFootprint = this.vFootprints[n];
                for (TrackerPanel trackerPanel : this.panels) {
                    Step[] stepArray = this.getVArray((TrackerPanel)trackerPanel).array;
                    int n2 = 0;
                    while (n2 < stepArray.length) {
                        if (stepArray[n2] != null) {
                            stepArray[n2].setFootprint(this.vFootprint);
                        }
                        ++n2;
                    }
                }
                this.support.firePropertyChange("footprint", null, this.vFootprint);
                this.repaint();
                return;
            }
            ++n;
        }
    }

    public Footprint[] getAccelerationFootprints() {
        return this.aFootprints;
    }

    public void setAccelerationFootprints(Footprint[] footprintArray) {
        ArrayList<Footprint> arrayList = new ArrayList<Footprint>();
        int n = 0;
        while (n < footprintArray.length) {
            if (footprintArray[n] != null && footprintArray[n].getLength() == this.aFootprint.getLength()) {
                footprintArray[n].setColor(this.aFootprint.getColor());
                arrayList.add(footprintArray[n]);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.aFootprints = arrayList.toArray(new Footprint[0]);
            this.setAccelerationFootprint(this.aFootprints[0].getName());
        }
    }

    public Footprint getAccelerationFootprint() {
        return this.aFootprint;
    }

    public void setAccelerationFootprint(String string) {
        int n = 0;
        while (n < this.aFootprints.length) {
            if (string.equals(this.aFootprints[n].getName())) {
                this.aFootprint = this.aFootprints[n];
                for (TrackerPanel trackerPanel : this.panels) {
                    Step[] stepArray = this.getAArray((TrackerPanel)trackerPanel).array;
                    int n2 = 0;
                    while (n2 < stepArray.length) {
                        if (stepArray[n2] != null) {
                            stepArray[n2].setFootprint(this.aFootprint);
                        }
                        ++n2;
                    }
                }
                this.repaint();
                this.support.firePropertyChange("footprint", null, this.aFootprint);
                return;
            }
            ++n;
        }
    }

    @Override
    public Footprint[] getFootprints(Step step) {
        if (step == null) {
            return this.getFootprints();
        }
        if (this.isVelocity(step)) {
            return this.getVelocityFootprints();
        }
        if (this.isAcceleration(step)) {
            return this.getAccelerationFootprints();
        }
        return this.getFootprints();
    }

    @Override
    public void setFootprint(String string, Step step) {
        if (step == null) {
            this.setFootprint(string);
        } else if (this.isVelocity(step)) {
            this.setVelocityFootprint(string);
        } else if (this.isAcceleration(step)) {
            this.setAccelerationFootprint(string);
        } else {
            this.setFootprint(string);
        }
    }

    @Override
    public Footprint getFootprint(Step step) {
        if (step != null) {
            return step.footprint;
        }
        return this.getFootprint();
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double d) {
        if (d == this.mass) {
            return;
        }
        d = Math.abs(d);
        this.mass = d = Math.max(d, 1.0E-30);
        this.dataValid = false;
        this.firePropertyChange("mass", null, new Double(d));
        this.firePropertyChange("data", null, this);
        if (this.data != null) {
            Double d2 = this.getMass();
            String string = TrackerRes.getString("ParticleModel.Parameter.Mass.Description");
            this.data.setConstant("m", d2, d2.toString(), string);
        }
    }

    @Override
    public void setFontLevel(int n) {
        super.setFontLevel(n);
        Object[] objectArray = new Object[]{this.massLabel, this.massField};
        FontSizer.setFonts(objectArray, n);
    }

    public Point2D getWorldPosition(int n, TrackerPanel trackerPanel) {
        PositionStep positionStep = (PositionStep)this.getStep(n);
        if (positionStep != null) {
            return positionStep.getPosition().getWorldPosition(trackerPanel);
        }
        return null;
    }

    public Point2D getWorldVelocity(int n, TrackerPanel trackerPanel) {
        ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
        double d = trackerPanel.getPlayer().getMeanStepDuration() / 1000.0;
        VectorStep vectorStep = this.getVelocity(n, trackerPanel);
        if (vectorStep != null) {
            double d2 = vectorStep.getXComponent();
            double d3 = vectorStep.getYComponent();
            double d4 = imageCoordSystem.imageToWorldXComponent(n, d2, d3) / d;
            double d5 = imageCoordSystem.imageToWorldYComponent(n, d2, d3) / d;
            return new Point2D.Double(d4, d5);
        }
        return null;
    }

    public Point2D getWorldAcceleration(int n, TrackerPanel trackerPanel) {
        ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
        double d = trackerPanel.getPlayer().getMeanStepDuration() / 1000.0;
        VectorStep vectorStep = this.getAcceleration(n, trackerPanel);
        if (vectorStep != null) {
            double d2 = vectorStep.getXComponent();
            double d3 = vectorStep.getYComponent();
            double d4 = imageCoordSystem.imageToWorldXComponent(n, d2, d3) / (d * d);
            double d5 = imageCoordSystem.imageToWorldYComponent(n, d2, d3) / (d * d);
            return new Point2D.Double(d4, d5);
        }
        return null;
    }

    public void setAlgorithm(int n) {
        if (n == this.algorithm) {
            return;
        }
        if (n == 0 || n == 1) {
            this.algorithm = n;
            this.refreshDataLater = false;
            this.updateDerivatives();
            this.support.firePropertyChange("steps", null, null);
        }
    }

    @Override
    protected String getTargetDescription(int n) {
        return TrackerRes.getString("PointMass.Position.Name");
    }

    @Override
    protected void refreshData(DatasetManager datasetManager, TrackerPanel trackerPanel) {
        int n;
        if (this.refreshDataLater) {
            return;
        }
        int n2 = n = 23;
        if (!this.getClass().equals(CenterOfMass.class) && !this.getClass().equals(DynamicSystem.class)) {
            ++n2;
        }
        if (datasetManager.getDataset(0).getColumnName(0).equals("x")) {
            String string = "t";
            datasetManager.getDataset(0).setXYColumnNames(string, "x");
            datasetManager.getDataset(1).setXYColumnNames(string, "y");
            datasetManager.getDataset(2).setXYColumnNames(string, "r");
            datasetManager.getDataset(3).setXYColumnNames(string, "$\\theta$_{r}");
            datasetManager.getDataset(4).setXYColumnNames(string, "v_{x}");
            datasetManager.getDataset(5).setXYColumnNames(string, "v_{y}");
            datasetManager.getDataset(6).setXYColumnNames(string, "v");
            datasetManager.getDataset(7).setXYColumnNames(string, "$\\theta$_{v}");
            datasetManager.getDataset(8).setXYColumnNames(string, "a_{x}");
            datasetManager.getDataset(9).setXYColumnNames(string, "a_{y}");
            datasetManager.getDataset(10).setXYColumnNames(string, "a");
            datasetManager.getDataset(11).setXYColumnNames(string, "$\\theta$_{a}");
            datasetManager.getDataset(12).setXYColumnNames(string, "$\\theta$");
            datasetManager.getDataset(13).setXYColumnNames(string, "$\\omega$");
            datasetManager.getDataset(14).setXYColumnNames(string, "$\\alpha$");
            datasetManager.getDataset(15).setXYColumnNames(string, "step");
            datasetManager.getDataset(16).setXYColumnNames(string, "frame");
            datasetManager.getDataset(17).setXYColumnNames(string, "p_{x}");
            datasetManager.getDataset(18).setXYColumnNames(string, "p_{y}");
            datasetManager.getDataset(19).setXYColumnNames(string, "p");
            datasetManager.getDataset(20).setXYColumnNames(string, "$\\theta$_{p}");
            datasetManager.getDataset(21).setXYColumnNames(string, "pixel_{x}");
            datasetManager.getDataset(22).setXYColumnNames(string, "pixel_{y}");
            if (n2 > n) {
                datasetManager.getDataset(n).setXYColumnNames(string, "K");
            }
        }
        if (n2 == n) {
            int[] nArray = new int[19];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            nArray[5] = 5;
            nArray[6] = 6;
            nArray[7] = 7;
            nArray[8] = 8;
            nArray[9] = 9;
            nArray[10] = 10;
            nArray[11] = 11;
            nArray[12] = 17;
            nArray[13] = 18;
            nArray[14] = 19;
            nArray[15] = 20;
            nArray[16] = 12;
            nArray[17] = 13;
            nArray[18] = 14;
            this.preferredColumnOrder = nArray;
        } else {
            int[] nArray = new int[20];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            nArray[5] = 5;
            nArray[6] = 6;
            nArray[7] = 7;
            nArray[8] = 8;
            nArray[9] = 9;
            nArray[10] = 10;
            nArray[11] = 11;
            nArray[12] = 17;
            nArray[13] = 18;
            nArray[14] = 19;
            nArray[15] = 20;
            nArray[16] = 12;
            nArray[17] = 13;
            nArray[18] = 14;
            nArray[19] = n;
            this.preferredColumnOrder = nArray;
        }
        this.dataDescriptions = new String[n2 + 1];
        int n3 = 0;
        while (n3 < this.dataDescriptions.length) {
            this.dataDescriptions[n3] = n3 < 22 ? TrackerRes.getString("PointMass.Data.Description." + n3) : (n3 == 22 ? TrackerRes.getString("PointMass.Data.Description.PixelX") : (n3 == 23 ? TrackerRes.getString("PointMass.Data.Description.PixelY") : TrackerRes.getString("PointMass.Data.Description.22")));
            ++n3;
        }
        Object[] objectArray = this.getRotationData();
        double[] dArray = (double[])objectArray[0];
        double[] dArray2 = (double[])objectArray[1];
        double[] dArray3 = (double[])objectArray[2];
        this.dataFrames.clear();
        int n4 = 0;
        while (n4 < n2) {
            datasetManager.getDataset(n4).clear();
            ++n4;
        }
        VideoPlayer videoPlayer = trackerPanel.getPlayer();
        VideoClip videoClip = videoPlayer.getVideoClip();
        ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
        Step[] stepArray = this.getSteps();
        int n5 = 0;
        while (n5 < stepArray.length) {
            if (stepArray[n5] != null && videoClip.includesFrame(n5)) {
                VectorStep vectorStep;
                VectorStep vectorStep2;
                int n6 = videoClip.frameToStep(n5);
                double d = videoPlayer.getStepTime(n6) / 1000.0;
                double d2 = videoPlayer.getStepTime(n6 + this.vDerivSpill) / 1000.0;
                double d3 = videoPlayer.getStepTime(n6 - this.vDerivSpill) / 1000.0;
                double d4 = (d2 - d3) / (double)(2 * this.vDerivSpill);
                d2 = videoPlayer.getStepTime(n6 + this.aDerivSpill) / 1000.0;
                d3 = videoPlayer.getStepTime(n6 - this.aDerivSpill) / 1000.0;
                double d5 = (d2 - d3) * (d2 - d3) / (double)(4 * this.aDerivSpill * this.aDerivSpill);
                double[] dArray4 = new double[n2];
                PositionStep.Position position = ((PositionStep)stepArray[n5]).getPosition();
                Point2D point2D = position.getWorldPosition(trackerPanel);
                dArray4[0] = point2D.getX();
                dArray4[1] = point2D.getY();
                dArray4[2] = point2D.distance(0.0, 0.0);
                dArray4[3] = Math.atan2(point2D.getY(), point2D.getX());
                dArray4[4] = Double.NaN;
                dArray4[5] = Double.NaN;
                dArray4[6] = Double.NaN;
                dArray4[7] = Double.NaN;
                dArray4[8] = Double.NaN;
                dArray4[9] = Double.NaN;
                dArray4[10] = Double.NaN;
                dArray4[11] = Double.NaN;
                dArray4[12] = dArray[n5];
                dArray4[13] = dArray2[n5] / d4;
                dArray4[14] = dArray3[n5] / d5;
                dArray4[15] = n6;
                dArray4[16] = n5;
                dArray4[17] = Double.NaN;
                dArray4[18] = Double.NaN;
                dArray4[19] = Double.NaN;
                dArray4[20] = Double.NaN;
                dArray4[21] = position.x;
                dArray4[22] = position.y;
                if (n2 > n) {
                    dArray4[n] = Double.NaN;
                }
                if ((vectorStep2 = this.getVelocity(n5, trackerPanel)) != null) {
                    double d6 = vectorStep2.getXComponent();
                    double d7 = vectorStep2.getYComponent();
                    dArray4[4] = imageCoordSystem.imageToWorldXComponent(n5, d6, d7) / d4;
                    dArray4[5] = imageCoordSystem.imageToWorldYComponent(n5, d6, d7) / d4;
                    double d8 = dArray4[4] * dArray4[4] + dArray4[5] * dArray4[5];
                    dArray4[6] = Math.sqrt(d8);
                    dArray4[7] = Math.atan2(dArray4[5], dArray4[4]);
                    double d9 = this.getMass();
                    dArray4[17] = d9 * dArray4[4];
                    dArray4[18] = d9 * dArray4[5];
                    dArray4[19] = d9 * dArray4[6];
                    dArray4[20] = d9 * dArray4[7];
                    if (n2 > n) {
                        dArray4[n] = 0.5 * d9 * d8;
                    }
                }
                if ((vectorStep = this.getAcceleration(n5, trackerPanel)) != null) {
                    double d10 = vectorStep.getXComponent();
                    double d11 = vectorStep.getYComponent();
                    dArray4[8] = imageCoordSystem.imageToWorldXComponent(n5, d10, d11) / d5;
                    dArray4[9] = imageCoordSystem.imageToWorldYComponent(n5, d10, d11) / d5;
                    dArray4[10] = Math.sqrt(dArray4[8] * dArray4[8] + dArray4[9] * dArray4[9]);
                    dArray4[11] = Math.atan2(dArray4[9], dArray4[8]);
                }
                int n7 = 0;
                while (n7 < n2) {
                    datasetManager.getDataset(n7).append(d, dArray4[n7]);
                    ++n7;
                }
                this.dataFrames.add(new Integer(n5));
            }
            ++n5;
        }
        Double d = this.getMass();
        String string = TrackerRes.getString("ParticleModel.Parameter.Mass.Description");
        datasetManager.setConstant("m", d, d.toString(), string);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Object object;
        if (!(drawingPanel instanceof TrackerPanel) || !this.visible) {
            return;
        }
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.panels.add(trackerPanel);
        VideoClip videoClip = trackerPanel.getPlayer().getVideoClip();
        int n = trackerPanel.getFrameNumber();
        int n2 = videoClip.getStepSize();
        if (this.trailVisible) {
            boolean bl = this.getTrailLength() > 0;
            object = this.steps.array;
            int n3 = 0;
            while (n3 < ((Step[])object).length) {
                if ((!bl || n - n3 <= (this.getTrailLength() - 1) * n2 && n3 <= n) && object[n3] != null) {
                    VectorStep vectorStep;
                    VectorStep vectorStep2;
                    if (this.isStepVisible(object[n3], trackerPanel)) {
                        ((Step)object[n3]).draw(trackerPanel, graphics2D);
                    }
                    if ((vectorStep2 = this.getVelocity(n3, trackerPanel)) != null && this.isStepVisible(vectorStep2, trackerPanel)) {
                        ((Step)vectorStep2).draw(trackerPanel, graphics2D);
                    }
                    if ((vectorStep = this.getAcceleration(n3, trackerPanel)) != null && this.isStepVisible(vectorStep, trackerPanel)) {
                        ((Step)vectorStep).draw(trackerPanel, graphics2D);
                    }
                }
                ++n3;
            }
        } else {
            Step step = this.getStep(n);
            if (step != null) {
                VectorStep vectorStep;
                if (this.isStepVisible(step, trackerPanel)) {
                    step.draw(trackerPanel, graphics2D);
                }
                if ((object = this.getVelocity(n, trackerPanel)) != null && this.isStepVisible((Step)object, trackerPanel)) {
                    ((Step)object).draw(trackerPanel, graphics2D);
                }
                if ((vectorStep = this.getAcceleration(n, trackerPanel)) != null && this.isStepVisible(vectorStep, trackerPanel)) {
                    ((Step)vectorStep).draw(trackerPanel, graphics2D);
                }
            }
        }
        if (this.isTraceVisible() && !(this instanceof ParticleModel)) {
            Color color = graphics2D.getColor();
            object = graphics2D.getStroke();
            graphics2D.setColor(this.getColor());
            graphics2D.setStroke(this.traceStroke);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.trace.reset();
            int n4 = videoClip.getStartFrameNumber();
            int n5 = videoClip.getEndFrameNumber();
            boolean bl = true;
            int n6 = n4;
            while (n6 <= n5) {
                PositionStep positionStep = (PositionStep)this.getStep(n6);
                if (positionStep == null) {
                    graphics2D.draw(this.trace);
                    bl = true;
                } else {
                    Point point = positionStep.getPosition().getScreenPosition(trackerPanel);
                    if (bl) {
                        this.trace.reset();
                        this.trace.moveTo((float)point.getX(), (float)point.getY());
                        bl = false;
                    } else {
                        this.trace.lineTo((float)point.getX(), (float)point.getY());
                    }
                }
                n6 += n2;
            }
            graphics2D.draw(this.trace);
            graphics2D.setColor(color);
            graphics2D.setStroke((Stroke)object);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof TrackerPanel) || !this.visible) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Interactive interactive = null;
        int n3 = trackerPanel.getFrameNumber();
        int n4 = trackerPanel.getPlayer().getVideoClip().getStepSize();
        if (this.trailVisible) {
            boolean bl = this.getTrailLength() > 0;
            Step[] stepArray = this.steps.array;
            int n5 = 0;
            while (n5 < stepArray.length) {
                if ((!bl || n3 - n5 <= (this.getTrailLength() - 1) * n4 && n5 <= n3) && stepArray[n5] != null) {
                    if (this.isStepVisible(stepArray[n5], trackerPanel) && (interactive = stepArray[n5].findInteractive(trackerPanel, n, n2)) != null) {
                        this.partName = TrackerRes.getString("PointMass.Position.Name");
                        this.hint = TrackerRes.getString("PointMass.Position.Hint");
                        return interactive;
                    }
                    VectorStep vectorStep = this.getVelocity(n5, trackerPanel);
                    if (vectorStep != null && this.isStepVisible(vectorStep, trackerPanel) && (interactive = ((Step)vectorStep).findInteractive(trackerPanel, n, n2)) != null) {
                        this.partName = TrackerRes.getString("PointMass.Velocity.Name");
                        this.hint = TrackerRes.getString("PointMass.Vector.Hint");
                        return interactive;
                    }
                    VectorStep vectorStep2 = this.getAcceleration(n5, trackerPanel);
                    if (vectorStep2 != null && this.isStepVisible(vectorStep2, trackerPanel) && (interactive = ((Step)vectorStep2).findInteractive(trackerPanel, n, n2)) != null) {
                        this.partName = TrackerRes.getString("PointMass.Acceleration.Name");
                        this.hint = TrackerRes.getString("PointMass.Vector.Hint");
                        return interactive;
                    }
                }
                ++n5;
            }
        } else {
            Step step = this.getStep(n3);
            if (step != null) {
                if (this.isStepVisible(step, trackerPanel) && (interactive = step.findInteractive(trackerPanel, n, n2)) != null) {
                    this.partName = TrackerRes.getString("PointMass.Position.Name");
                    this.hint = TrackerRes.getString("PointMass.Position.Hint");
                    return interactive;
                }
                VectorStep vectorStep = this.getVelocity(n3, trackerPanel);
                if (vectorStep != null && this.isStepVisible(vectorStep, trackerPanel) && (interactive = ((Step)vectorStep).findInteractive(trackerPanel, n, n2)) != null) {
                    this.partName = TrackerRes.getString("PointMass.Velocity.Name");
                    this.hint = TrackerRes.getString("PointMass.Vector.Hint");
                    return interactive;
                }
                VectorStep vectorStep3 = this.getAcceleration(n3, trackerPanel);
                if (vectorStep3 != null && this.isStepVisible(vectorStep3, trackerPanel) && (interactive = ((Step)vectorStep3).findInteractive(trackerPanel, n, n2)) != null) {
                    this.partName = TrackerRes.getString("PointMass.Acceleration.Name");
                    this.hint = TrackerRes.getString("PointMass.Vector.Hint");
                    return interactive;
                }
            }
        }
        Step step = trackerPanel.getSelectedStep();
        if (step != null) {
            if (step instanceof PositionStep) {
                this.partName = TrackerRes.getString("PointMass.Position.Name");
                this.partName = String.valueOf(this.partName) + " " + TrackerRes.getString("TTrack.Selected.Hint");
                this.hint = TrackerRes.getString("PointMass.PositionSelected.Hint");
            } else if (step instanceof VectorStep) {
                this.partName = this.isVelocity(step) ? TrackerRes.getString("PointMass.Velocity.Name") : TrackerRes.getString("PointMass.Acceleration.Name");
                this.partName = String.valueOf(this.partName) + " " + TrackerRes.getString("TTrack.Selected.Hint");
                this.hint = TrackerRes.getString("PointMass.VectorSelected.Hint");
            }
        } else {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = TrackerRes.getString("PointMass.Hint");
            this.hint = this.getStep(trackerPanel.getFrameNumber()) == null ? String.valueOf(this.hint) + TrackerRes.getString("PointMass.Unmarked.Hint") : String.valueOf(this.hint) + TrackerRes.getString("PointMass.Remark.Hint");
        }
        return null;
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            Step[] stepArray = this.getSteps();
            int n = stepArray.length;
            int n2 = 0;
            while (n2 < n) {
                Step step = stepArray[n2];
                if (step != null && this.trackerPanel != null) {
                    this.trackerPanel.selectedSteps.remove(step);
                }
                ++n2;
            }
        }
        super.setVisible(bl);
    }

    @Override
    public boolean isStepVisible(Step step, TrackerPanel trackerPanel) {
        if (!this.isVisible()) {
            return false;
        }
        int n = step.getFrameNumber();
        if (!trackerPanel.getPlayer().getVideoClip().includesFrame(n)) {
            return false;
        }
        if (this.isPosition(step) && !this.isPositionVisible(trackerPanel)) {
            return false;
        }
        if (this.isVelocity(step) && !this.isVVisible(trackerPanel)) {
            return false;
        }
        if (this.isAcceleration(step) && !this.isAVisible(trackerPanel)) {
            return false;
        }
        return this.trailVisible || trackerPanel.getFrameNumber() == n;
    }

    public void setVVisibleOnAll(boolean bl) {
        this.vVisibleOnAll = bl;
    }

    public void setVVisible(TrackerPanel trackerPanel, boolean bl) {
        Step step;
        if (bl == this.isVVisible(trackerPanel)) {
            return;
        }
        this.vVisMap.put(trackerPanel, new Boolean(bl));
        if (!bl && (step = trackerPanel.getSelectedStep()) != null && this.isVelocity(step)) {
            trackerPanel.setSelectedPoint(null);
        }
    }

    public boolean isVVisible(TrackerPanel trackerPanel) {
        Boolean bl;
        if (this.vVisibleOnAll) {
            return true;
        }
        if (trackerPanel instanceof WorldTView) {
            trackerPanel = ((WorldTView)trackerPanel).getTrackerPanel();
        }
        if ((bl = this.vVisMap.get(trackerPanel)) == null) {
            bl = new Boolean(false);
            this.vVisMap.put(trackerPanel, bl);
        }
        return bl;
    }

    public void setPositionVisibleOnAll(boolean bl) {
        this.xVisibleOnAll = bl;
    }

    public void setTraceVisible(boolean bl) {
        this.traceVisible = bl;
    }

    public boolean isTraceVisible() {
        return this.traceVisible;
    }

    public boolean isPosition(Step step) {
        return step instanceof PositionStep;
    }

    public void setPositionVisible(TrackerPanel trackerPanel, boolean bl) {
        Boolean bl2 = this.xVisMap.get(trackerPanel);
        if (bl2 != null && bl2 == bl) {
            return;
        }
        this.xVisMap.put(trackerPanel, new Boolean(bl));
        if (!bl) {
            Step step = trackerPanel.getSelectedStep();
            if (step != null && step == this.getStep(step.getFrameNumber())) {
                trackerPanel.setSelectedPoint(null);
            }
            trackerPanel.selectedSteps.clear();
        }
    }

    public boolean isPositionVisible(TrackerPanel trackerPanel) {
        Boolean bl;
        if (this.xVisibleOnAll) {
            return true;
        }
        if (trackerPanel instanceof WorldTView) {
            trackerPanel = ((WorldTView)trackerPanel).getTrackerPanel();
        }
        if ((bl = this.xVisMap.get(trackerPanel)) == null) {
            bl = new Boolean(true);
            this.xVisMap.put(trackerPanel, bl);
        }
        return bl;
    }

    public VectorStep getVelocity(int n, TrackerPanel trackerPanel) {
        return (VectorStep)this.getVArray(trackerPanel).getStep(n);
    }

    public Step[] getVelocities(TrackerPanel trackerPanel) {
        return this.getVArray((TrackerPanel)trackerPanel).array;
    }

    public boolean isVelocity(Step step) {
        for (TrackerPanel trackerPanel : this.panels) {
            boolean bl = this.getVArray(trackerPanel).contains(step);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public void setAVisibleOnAll(boolean bl) {
        this.aVisibleOnAll = bl;
    }

    public void setAVisible(TrackerPanel trackerPanel, boolean bl) {
        Step step;
        if (bl == this.isAVisible(trackerPanel)) {
            return;
        }
        this.aVisMap.put(trackerPanel, new Boolean(bl));
        if (!bl && (step = trackerPanel.getSelectedStep()) != null && this.isAcceleration(step)) {
            trackerPanel.setSelectedPoint(null);
        }
    }

    public boolean isAVisible(TrackerPanel trackerPanel) {
        Boolean bl;
        if (this.aVisibleOnAll) {
            return true;
        }
        if (trackerPanel instanceof WorldTView) {
            trackerPanel = ((WorldTView)trackerPanel).getTrackerPanel();
        }
        if ((bl = this.aVisMap.get(trackerPanel)) == null) {
            bl = new Boolean(false);
            this.aVisMap.put(trackerPanel, bl);
        }
        return bl;
    }

    public VectorStep getAcceleration(int n, TrackerPanel trackerPanel) {
        return (VectorStep)this.getAArray(trackerPanel).getStep(n);
    }

    public Step[] getAccelerations(TrackerPanel trackerPanel) {
        return this.getAArray((TrackerPanel)trackerPanel).array;
    }

    public boolean isAcceleration(Step step) {
        for (TrackerPanel trackerPanel : this.panels) {
            boolean bl = this.getAArray(trackerPanel).contains(step);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public void setLabelsVisible(TrackerPanel trackerPanel, boolean bl) {
        Object object2;
        Step[] stepArray = this.getSteps();
        int n = 0;
        while (n < stepArray.length) {
            object2 = (PositionStep)stepArray[n];
            if (object2 != null) {
                ((PositionStep)object2).setLabelVisible(bl);
                ((PositionStep)object2).setRolloverVisible(!bl);
            }
            ++n;
        }
        stepArray = this.getVelocities(trackerPanel);
        n = 0;
        while (n < stepArray.length) {
            object2 = (VectorStep)stepArray[n];
            if (object2 != null) {
                ((VectorStep)object2).setLabelVisible(bl);
                ((VectorStep)object2).setRolloverVisible(!bl);
            }
            ++n;
        }
        stepArray = this.getAccelerations(trackerPanel);
        n = 0;
        while (n < stepArray.length) {
            object2 = (VectorStep)stepArray[n];
            if (object2 != null) {
                ((VectorStep)object2).setLabelVisible(bl);
                ((VectorStep)object2).setRolloverVisible(!bl);
            }
            ++n;
        }
        for (Object object2 : this.panels) {
            WorldTView worldTView;
            if (!(object2 instanceof WorldTView) || (worldTView = (WorldTView)object2).getTrackerPanel() != trackerPanel) continue;
            this.setLabelsVisible(worldTView, bl);
        }
    }

    public boolean isLabelsVisible(TrackerPanel trackerPanel) {
        Step[] stepArray = this.getSteps();
        int n = 0;
        while (n < stepArray.length) {
            PositionStep positionStep = (PositionStep)stepArray[n];
            if (positionStep != null) {
                return positionStep.isLabelVisible();
            }
            ++n;
        }
        return false;
    }

    protected void updateDerivatives() {
        if (this.isEmpty() || this.refreshDataLater) {
            return;
        }
        for (TrackerPanel trackerPanel : this.vMap.keySet()) {
            this.updateDerivatives(trackerPanel);
        }
    }

    protected void updateDerivatives(int n, int n2) {
        if (this.isEmpty() || this.refreshDataLater) {
            return;
        }
        Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " update derivatives " + n + " steps " + n2);
        for (TrackerPanel trackerPanel : this.vMap.keySet()) {
            this.updateDerivatives(trackerPanel, n, n2);
        }
    }

    protected void updateDerivatives(int n) {
        if (this.isEmpty() || this.refreshDataLater) {
            return;
        }
        for (TrackerPanel trackerPanel : this.vMap.keySet()) {
            this.updateDerivatives(trackerPanel, n);
        }
    }

    protected void updateDerivatives(TrackerPanel trackerPanel, int n) {
        VideoClip videoClip = trackerPanel.getPlayer().getVideoClip();
        int n2 = Math.max(n - 2 * videoClip.getStepSize(), videoClip.getStartFrameNumber());
        this.updateDerivatives(trackerPanel, n2, 5);
    }

    protected void updateDerivatives(TrackerPanel trackerPanel) {
        if (this.refreshDataLater) {
            return;
        }
        VideoClip videoClip = trackerPanel.getPlayer().getVideoClip();
        this.updateDerivatives(trackerPanel, videoClip.getStartFrameNumber(), videoClip.getStepCount());
    }

    protected void updateDerivatives(TrackerPanel trackerPanel, int n, int n2) {
        PositionStep.Position position;
        double d;
        double d2;
        VectorStep vectorStep;
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        Object object;
        Object object2;
        if (trackerPanel instanceof WorldTView && !((WorldTView)trackerPanel).isSelectedView()) {
            return;
        }
        VideoClip videoClip = trackerPanel.getPlayer().getVideoClip();
        if (this.xData.length < this.steps.length) {
            this.xData = new double[this.steps.length + 5];
            this.derivData[1] = this.xData;
            this.yData = new double[this.steps.length + 5];
            this.derivData[2] = this.yData;
            this.validData = new boolean[this.steps.length + 5];
            this.derivData[3] = this.validData;
        }
        this.params[1] = n;
        this.params[2] = videoClip.getStepSize();
        this.params[3] = n2;
        int n3 = 0;
        while (n3 < this.validData.length) {
            this.validData[n3] = false;
            ++n3;
        }
        Step[] stepArray = this.steps.array;
        int n4 = 0;
        while (n4 < stepArray.length) {
            if (stepArray[n4] != null && videoClip.includesFrame(n4)) {
                PositionStep positionStep = (PositionStep)stepArray[n4];
                object2 = positionStep.getPosition().getWorldPosition(trackerPanel);
                this.xData[n4] = ((Point2D)object2).getX();
                this.yData[n4] = ((Point2D)object2).getY();
                this.validData[n4] = true;
            }
            ++n4;
        }
        n4 = this.locked ? 1 : 0;
        this.locked = false;
        boolean bl = this.isLabelsVisible(trackerPanel);
        if (this.algorithm == 1) {
            this.params[0] = this.bounceDerivsSpill;
            object = bounceDerivs.evaluate(this.derivData);
            object2 = (double[])object[0];
            dArray3 = (double[])object[1];
            dArray2 = (double[])object[2];
            dArray = (double[])object[3];
        } else {
            this.params[0] = this.vDerivSpill;
            object = vDeriv.evaluate(this.derivData);
            object2 = (double[])object[0];
            dArray3 = (double[])object[1];
            this.params[0] = this.aDerivSpill;
            object = aDeriv.evaluate(this.derivData);
            dArray2 = (double[])object[2];
            dArray = (double[])object[3];
        }
        object = this.vMap.get(trackerPanel);
        int n5 = n + (n2 - 1) * videoClip.getStepSize();
        int n6 = Math.min(n5, ((Object)object2).length - 1);
        int n7 = n;
        while (n7 <= n6) {
            vectorStep = (VectorStep)((TTrack.StepArray)object).getStep(n7);
            if (!Double.isNaN((double)object2[n7]) && this.validData[n7] || vectorStep != null) {
                if (!Double.isNaN((double)object2[n7]) && this.validData[n7]) {
                    d2 = trackerPanel.getCoords().worldToImageXComponent(n7, (double)object2[n7], dArray3[n7]);
                    d = trackerPanel.getCoords().worldToImageYComponent(n7, (double)object2[n7], dArray3[n7]);
                    if (vectorStep == null) {
                        position = ((PositionStep)this.getStep(n7)).getPosition();
                        vectorStep = new VectorStep(this, n7, position.getX(), position.getY(), d2, d);
                        vectorStep.setTipEnabled(false);
                        vectorStep.getHandle().setStepEditTrigger(true);
                        vectorStep.setDefaultPointIndex(2);
                        vectorStep.setFootprint(this.vFootprint);
                        vectorStep.setLabelVisible(bl);
                        vectorStep.setRolloverVisible(!bl);
                        vectorStep.attach(position);
                        ((TTrack.StepArray)object).setStep(n7, vectorStep);
                        trackerPanel.addDirtyRegion(vectorStep.getBounds(trackerPanel));
                    } else if ((int)(100.0 * vectorStep.getXComponent()) != (int)(100.0 * d2) || (int)(100.0 * vectorStep.getYComponent()) != (int)(100.0 * d)) {
                        trackerPanel.addDirtyRegion(vectorStep.getBounds(trackerPanel));
                        vectorStep.attach(vectorStep.getAttachmentPoint());
                        vectorStep.setXYComponents(d2, d);
                        trackerPanel.addDirtyRegion(vectorStep.getBounds(trackerPanel));
                    } else {
                        vectorStep.attach(vectorStep.getAttachmentPoint());
                    }
                } else {
                    ((TTrack.StepArray)object).setStep(n7, null);
                    trackerPanel.addDirtyRegion(vectorStep.getBounds(trackerPanel));
                }
            }
            ++n7;
        }
        object = this.aMap.get(trackerPanel);
        n6 = Math.min(n5, dArray2.length - 1);
        n7 = n;
        while (n7 <= n6) {
            vectorStep = (VectorStep)((TTrack.StepArray)object).getStep(n7);
            if (!Double.isNaN(dArray2[n7]) && this.validData[n7] || vectorStep != null) {
                if (!Double.isNaN(dArray2[n7]) && this.validData[n7]) {
                    d2 = trackerPanel.getCoords().worldToImageXComponent(n7, dArray2[n7], dArray[n7]);
                    d = trackerPanel.getCoords().worldToImageYComponent(n7, dArray2[n7], dArray[n7]);
                    if (vectorStep == null) {
                        position = ((PositionStep)this.getStep(n7)).getPosition();
                        vectorStep = new VectorStep(this, n7, position.getX(), position.getY(), d2, d);
                        vectorStep.getHandle().setStepEditTrigger(true);
                        vectorStep.setTipEnabled(false);
                        vectorStep.setDefaultPointIndex(2);
                        vectorStep.setFootprint(this.aFootprint);
                        vectorStep.setLabelVisible(bl);
                        vectorStep.setRolloverVisible(!bl);
                        vectorStep.attach(position);
                        ((TTrack.StepArray)object).setStep(n7, vectorStep);
                        trackerPanel.addDirtyRegion(vectorStep.getBounds(trackerPanel));
                    } else if ((int)(100.0 * vectorStep.getXComponent()) != (int)(100.0 * d2) || (int)(100.0 * vectorStep.getYComponent()) != (int)(100.0 * d)) {
                        trackerPanel.addDirtyRegion(vectorStep.getBounds(trackerPanel));
                        vectorStep.attach(vectorStep.getAttachmentPoint());
                        vectorStep.setXYComponents(d2, d);
                        trackerPanel.addDirtyRegion(vectorStep.getBounds(trackerPanel));
                    } else {
                        vectorStep.attach(vectorStep.getAttachmentPoint());
                    }
                } else {
                    ((TTrack.StepArray)object).setStep(n7, null);
                    trackerPanel.addDirtyRegion(vectorStep.getBounds(trackerPanel));
                }
            }
            ++n7;
        }
        this.locked = n4;
        trackerPanel.repaintDirtyRegion();
    }

    protected Object[] getRotationData() {
        Object object;
        Object[] objectArray;
        if (this.xData.length < this.steps.length) {
            this.xData = new double[this.steps.length + 5];
            this.derivData[1] = this.xData;
            this.yData = new double[this.steps.length + 5];
            this.derivData[2] = this.yData;
            this.validData = new boolean[this.steps.length + 5];
            this.derivData[3] = this.validData;
        }
        int n = 0;
        while (n < this.steps.length) {
            this.validData[n] = false;
            ++n;
        }
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        this.params[1] = videoClip.getStartFrameNumber();
        this.params[2] = videoClip.getStepSize();
        this.params[3] = videoClip.getStepCount();
        Step[] stepArray = this.steps.array;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < stepArray.length) {
            if (stepArray[n2] != null && videoClip.includesFrame(n2)) {
                objectArray = (Object[])stepArray[n2];
                object = objectArray.getPosition().getWorldPosition(this.trackerPanel);
                double d3 = Math.atan2(((Point2D)object).getY(), ((Point2D)object).getX());
                double d4 = d3 - d2;
                if (d4 < -Math.PI) {
                    d4 += Math.PI * 2;
                } else if (d4 > Math.PI) {
                    d4 -= Math.PI * 2;
                }
                d2 = d3;
                this.xData[n2] = d += d4;
                this.yData[n2] = 0.0;
                this.validData[n2] = true;
            } else {
                this.xData[n2] = Double.NaN;
            }
            ++n2;
        }
        n2 = this.locked ? 1 : 0;
        this.locked = false;
        this.params[0] = this.vDerivSpill;
        objectArray = vDeriv.evaluate(this.derivData);
        object = (double[])objectArray[0];
        this.params[0] = this.aDerivSpill;
        objectArray = aDeriv.evaluate(this.derivData);
        double[] dArray = (double[])objectArray[2];
        this.locked = n2;
        return new Object[]{this.xData, object, dArray};
    }

    protected Object[] getRotationData(int n, int n2) {
        Object object;
        Object[] objectArray;
        if (this.xData.length < this.steps.length) {
            this.xData = new double[this.steps.length + 5];
            this.derivData[1] = this.xData;
            this.yData = new double[this.steps.length + 5];
            this.derivData[2] = this.yData;
            this.validData = new boolean[this.steps.length + 5];
            this.derivData[3] = this.validData;
        }
        int n3 = 0;
        while (n3 < this.steps.length) {
            this.validData[n3] = false;
            ++n3;
        }
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        this.params[1] = n;
        this.params[2] = videoClip.getStepSize();
        this.params[3] = n2;
        Step[] stepArray = this.steps.array;
        double d = 0.0;
        double d2 = 0.0;
        int n4 = 0;
        while (n4 < stepArray.length) {
            if (stepArray[n4] != null && videoClip.includesFrame(n4)) {
                objectArray = (Object[])stepArray[n4];
                object = objectArray.getPosition().getWorldPosition(this.trackerPanel);
                double d3 = Math.atan2(((Point2D)object).getY(), ((Point2D)object).getX());
                double d4 = d3 - d2;
                if (d4 < -Math.PI) {
                    d4 += Math.PI * 2;
                } else if (d4 > Math.PI) {
                    d4 -= Math.PI * 2;
                }
                d2 = d3;
                this.xData[n4] = d += d4;
                this.yData[n4] = 0.0;
                this.validData[n4] = true;
            } else {
                this.xData[n4] = Double.NaN;
            }
            ++n4;
        }
        n4 = this.locked ? 1 : 0;
        this.locked = false;
        this.params[0] = this.vDerivSpill;
        objectArray = vDeriv.evaluate(this.derivData);
        object = (double[])objectArray[0];
        boolean[] blArray = (boolean[])objectArray[2];
        int n5 = 0;
        while (n5 < ((Object)object).length) {
            if (!blArray[n5]) {
                object[n5] = Double.NaN;
            }
            ++n5;
        }
        this.params[0] = this.aDerivSpill;
        objectArray = aDeriv.evaluate(this.derivData);
        double[] dArray = (double[])objectArray[2];
        this.locked = n4;
        return new Object[]{this.xData, object, dArray};
    }

    @Override
    public void erase() {
        super.erase();
        for (TrackerPanel trackerPanel : this.panels) {
            if (this.vMap.get(trackerPanel) == null) continue;
            Step[] stepArray = this.getVelocities(trackerPanel);
            int n = 0;
            while (n < stepArray.length) {
                if (stepArray[n] != null) {
                    stepArray[n].erase(trackerPanel);
                }
                ++n;
            }
            stepArray = this.getAccelerations(trackerPanel);
            n = 0;
            while (n < stepArray.length) {
                if (stepArray[n] != null) {
                    stepArray[n].erase(trackerPanel);
                }
                ++n;
            }
        }
    }

    @Override
    public void remark() {
        super.remark();
        for (TrackerPanel trackerPanel : this.panels) {
            Step[] stepArray = this.getVelocities(trackerPanel);
            int n = 0;
            while (n < stepArray.length) {
                if (stepArray[n] != null) {
                    stepArray[n].remark(trackerPanel);
                }
                ++n;
            }
            stepArray = this.getAccelerations(trackerPanel);
            n = 0;
            while (n < stepArray.length) {
                if (stepArray[n] != null) {
                    stepArray[n].remark(trackerPanel);
                }
                ++n;
            }
        }
    }

    @Override
    public void erase(TrackerPanel trackerPanel) {
        super.erase(trackerPanel);
        Step[] stepArray = this.getVelocities(trackerPanel);
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                stepArray[n].erase(trackerPanel);
            }
            ++n;
        }
        stepArray = this.getAccelerations(trackerPanel);
        n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                stepArray[n].erase(trackerPanel);
            }
            ++n;
        }
    }

    @Override
    public void remark(TrackerPanel trackerPanel) {
        super.remark(trackerPanel);
        Step[] stepArray = this.getVelocities(trackerPanel);
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                stepArray[n].remark(trackerPanel);
            }
            ++n;
        }
        stepArray = this.getAccelerations(trackerPanel);
        n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                stepArray[n].remark(trackerPanel);
            }
            ++n;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof TrackerPanel) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("transform")) {
                this.dataValid = false;
                this.updateDerivatives();
                this.support.firePropertyChange("data", null, null);
            } else if (string.equals("stepsize")) {
                JDialog jDialog;
                this.dataValid = false;
                this.updateDerivatives();
                this.support.firePropertyChange("data", null, null);
                int n = this.trackerPanel.getPlayer().getVideoClip().getStepSize();
                if (skippedStepWarningOn && this.stepSizeWhenFirstMarked > 1 && n != this.stepSizeWhenFirstMarked && (jDialog = this.getStepSizeWarningDialog()) != null) {
                    jDialog.setVisible(true);
                }
            } else if (string.equals("adjusting")) {
                this.refreshDataLater = (Boolean)propertyChangeEvent.getNewValue();
                if (!this.refreshDataLater) {
                    this.updateDerivatives();
                    this.support.firePropertyChange("data", null, null);
                }
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        JMenuItem jMenuItem;
        Object object;
        JMenu jMenu = super.getMenu(trackerPanel);
        if (jMenu.getItemCount() > 0 && (object = jMenu.getItem(jMenu.getItemCount() - 1)) == this.deleteTrackItem) {
            jMenu.remove(this.deleteTrackItem);
            if (jMenu.getItemCount() > 0) {
                jMenu.remove(jMenu.getItemCount() - 1);
            }
        }
        this.vFootprintMenu.setText(TrackerRes.getString("TTrack.MenuItem.Footprint"));
        this.aFootprintMenu.setText(TrackerRes.getString("TTrack.MenuItem.Footprint"));
        this.vFootprintMenu.removeAll();
        object = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (PointMass.this.getVelocityFootprint().getName().equals(string)) {
                    return;
                }
                XMLControlElement xMLControlElement = new XMLControlElement(PointMass.this);
                PointMass.this.setVelocityFootprint(string);
                Undo.postTrackEdit(PointMass.this, xMLControlElement);
            }
        };
        Footprint[] footprintArray = this.getVelocityFootprints();
        int n = 0;
        while (n < footprintArray.length) {
            BasicStroke basicStroke = footprintArray[n].getStroke();
            footprintArray[n].setStroke(new BasicStroke(basicStroke.getLineWidth(), 0, 0, 8.0f, null, 0.0f));
            jMenuItem = new JMenuItem(footprintArray[n].getDisplayName(), footprintArray[n].getIcon(21, 16));
            if (footprintArray[n] == this.vFootprint) {
                jMenuItem.setBorder(BorderFactory.createLineBorder(jMenuItem.getBackground().darker()));
            }
            jMenuItem.setActionCommand(footprintArray[n].getName());
            jMenuItem.addActionListener((ActionListener)object);
            this.vFootprintMenu.add(jMenuItem);
            footprintArray[n].setStroke(basicStroke);
            ++n;
        }
        this.aFootprintMenu.removeAll();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (PointMass.this.getAccelerationFootprint().getName().equals(string)) {
                    return;
                }
                XMLControlElement xMLControlElement = new XMLControlElement(PointMass.this);
                PointMass.this.setAccelerationFootprint(string);
                Undo.postTrackEdit(PointMass.this, xMLControlElement);
            }
        };
        footprintArray = this.getAccelerationFootprints();
        int n2 = 0;
        while (n2 < footprintArray.length) {
            BasicStroke basicStroke = footprintArray[n2].getStroke();
            footprintArray[n2].setStroke(new BasicStroke(basicStroke.getLineWidth(), 0, 0, 8.0f, null, 0.0f));
            jMenuItem = new JMenuItem(footprintArray[n2].getDisplayName(), footprintArray[n2].getIcon(21, 16));
            if (footprintArray[n2] == this.aFootprint) {
                jMenuItem.setBorder(BorderFactory.createLineBorder(jMenuItem.getBackground().darker()));
            }
            jMenuItem.setActionCommand(footprintArray[n2].getName());
            jMenuItem.addActionListener(actionListener);
            this.aFootprintMenu.add(jMenuItem);
            footprintArray[n2].setStroke(basicStroke);
            ++n2;
        }
        if (trackerPanel.isEnabled("track.autotrack")) {
            this.autotrackItem.setText(TrackerRes.getString("PointMass.MenuItem.Autotrack"));
            this.autotrackItem.setEnabled(trackerPanel.getVideo() != null);
            n2 = 0;
            int n3 = 0;
            while (n3 < jMenu.getItemCount()) {
                JMenuItem jMenuItem2 = jMenu.getItem(n3);
                if (jMenuItem2 == this.dataBuilderItem) {
                    jMenu.insert(this.autotrackItem, n3);
                    n2 = 1;
                }
                ++n3;
            }
            if (n2 == 0) {
                jMenu.add(this.autotrackItem);
            }
        }
        if (trackerPanel.isEnabled("track.autoAdvance") || trackerPanel.isEnabled("track.markByDefault")) {
            if (jMenu.getItemCount() > 0 && jMenu.getItem(jMenu.getItemCount() - 1) != null) {
                jMenu.addSeparator();
            }
            if (trackerPanel.isEnabled("track.autoAdvance")) {
                jMenu.add(this.autoAdvanceItem);
            }
            if (trackerPanel.isEnabled("track.markByDefault")) {
                jMenu.add(this.markByDefaultItem);
            }
        }
        if (jMenu.getItemCount() > 0 && jMenu.getItem(jMenu.getItemCount() - 1) != null) {
            jMenu.addSeparator();
        }
        this.velocityMenu.setText(TrackerRes.getString("PointMass.MenuItem.Velocity"));
        this.accelerationMenu.setText(TrackerRes.getString("PointMass.MenuItem.Acceleration"));
        this.vColorItem.setText(TrackerRes.getString("TTrack.MenuItem.Color"));
        this.aColorItem.setText(TrackerRes.getString("TTrack.MenuItem.Color"));
        this.vTailsToOriginItem.setText(TrackerRes.getString("Vector.MenuItem.ToOrigin"));
        this.aTailsToOriginItem.setText(TrackerRes.getString("Vector.MenuItem.ToOrigin"));
        this.vTailsToPositionItem.setText(TrackerRes.getString("PointMass.MenuItem.VectorsToPosition"));
        this.aTailsToPositionItem.setText(TrackerRes.getString("PointMass.MenuItem.VectorsToPosition"));
        this.vVisibleItem.setText(TrackerRes.getString("TTrack.MenuItem.Visible"));
        this.aVisibleItem.setText(TrackerRes.getString("TTrack.MenuItem.Visible"));
        jMenu.add(this.velocityMenu);
        jMenu.add(this.accelerationMenu);
        if (trackerPanel.isEnabled("track.delete")) {
            if (jMenu.getItemCount() > 0 && jMenu.getItem(jMenu.getItemCount() - 1) != null) {
                jMenu.addSeparator();
            }
            jMenu.add(this.deleteStepItem);
            jMenu.add(this.clearStepsItem);
            jMenu.add(this.deleteTrackItem);
        }
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        arrayList.add(this.massLabel);
        if (this.getClass() == PointMass.class) {
            this.massField.setEnabled(!this.isLocked());
        }
        this.massField.setValue(this.getMass());
        arrayList.add(this.massField);
        arrayList.add(this.mSeparator);
        return arrayList;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint tPoint) {
        Step step = this.getStep(tPoint, trackerPanel);
        ArrayList<Component> arrayList = super.getToolbarPointComponents(trackerPanel, tPoint);
        if (step == null) {
            return arrayList;
        }
        int n = step.getFrameNumber();
        n = trackerPanel.getPlayer().getVideoClip().frameToStep(n);
        if (step instanceof VectorStep) {
            boolean bl = TToolBar.getToolbar((TrackerPanel)trackerPanel).xMassButton.isSelected();
            if (this.isVelocity(step)) {
                if (bl) {
                    this.xLabel.setText("px");
                    this.yLabel.setText("py");
                    this.magLabel.setText("p");
                } else {
                    this.xLabel.setText("vx");
                    this.yLabel.setText("vy");
                    this.magLabel.setText("v");
                }
            } else if (this.isAcceleration(step)) {
                if (bl) {
                    this.xLabel.setText("Fx");
                    this.yLabel.setText("Fy");
                    this.magLabel.setText("F");
                } else {
                    this.xLabel.setText("ax");
                    this.yLabel.setText("ay");
                    this.magLabel.setText("a");
                }
            }
            this.xField.setEnabled(false);
            this.yField.setEnabled(false);
            this.magField.setEnabled(false);
            this.angleField.setEnabled(false);
        } else {
            this.xLabel.setText("x");
            this.yLabel.setText("y");
            this.magLabel.setText("r");
            this.xField.setEnabled(!this.isLocked());
            this.yField.setEnabled(!this.isLocked());
            this.magField.setEnabled(!this.isLocked());
            this.angleField.setEnabled(!this.isLocked());
        }
        arrayList.add(this.stepLabel);
        arrayList.add(this.stepValueLabel);
        arrayList.add(this.tSeparator);
        arrayList.add(this.xLabel);
        arrayList.add(this.xField);
        arrayList.add(this.xSeparator);
        arrayList.add(this.yLabel);
        arrayList.add(this.yField);
        arrayList.add(this.ySeparator);
        arrayList.add(this.magLabel);
        arrayList.add(this.magField);
        arrayList.add(this.magSeparator);
        arrayList.add(this.angleLabel);
        arrayList.add(this.angleField);
        arrayList.add(this.angleSeparator);
        return arrayList;
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    protected void createGUI() {
        this.massLabel = new JLabel("m");
        this.massLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.massField = new NumberField(5);
        this.massField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PointMass.this.setMass(PointMass.this.massField.getValue());
                PointMass.this.massField.setValue(PointMass.this.getMass());
                PointMass.this.massField.requestFocusInWindow();
            }
        });
        this.massField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PointMass.this.setMass(PointMass.this.massField.getValue());
                PointMass.this.massField.setValue(PointMass.this.getMass());
            }
        });
        this.massField.setMinValue(1.0E-30);
        this.massField.setBorder(this.xField.getBorder());
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PointMass.this.setXY();
            }
        };
        this.xSpinner.addChangeListener(changeListener);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PointMass.this.setXY();
                ((NumberField)actionEvent.getSource()).requestFocusInWindow();
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PointMass.this.setXY();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PointMass.this.setMagAngle();
                ((NumberField)actionEvent.getSource()).requestFocusInWindow();
            }
        };
        FocusAdapter focusAdapter2 = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PointMass.this.setMagAngle();
            }
        };
        this.xField.addActionListener(abstractAction);
        this.yField.addActionListener(abstractAction);
        this.xField.addFocusListener(focusAdapter);
        this.yField.addFocusListener(focusAdapter);
        this.magField.addActionListener(abstractAction2);
        this.angleField.addActionListener(abstractAction2);
        this.magField.addFocusListener(focusAdapter2);
        this.angleField.addFocusListener(focusAdapter2);
        this.mSeparator = Box.createRigidArea(new Dimension(4, 4));
        this.autotrackItem = new JMenuItem(TrackerRes.getString("PointMass.MenuItem.Autotrack"));
        this.autotrackItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoTracker autoTracker = PointMass.this.trackerPanel.getAutoTracker();
                autoTracker.setTrack(PointMass.this);
                autoTracker.getWizard().setVisible(true);
                PointMass.this.trackerPanel.repaint();
            }
        });
        this.vFootprintMenu = new JMenu();
        this.aFootprintMenu = new JMenu();
        this.velocityMenu = new JMenu();
        this.accelerationMenu = new JMenu();
        this.vColorItem = new JMenuItem();
        this.vColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = PointMass.this.getVelocityFootprint().getColor();
                Color color2 = PointMass.this.chooseColor(color, TrackerRes.getString("Velocity.Dialog.Color.Title"));
                if (color2 != null) {
                    XMLControlElement xMLControlElement = new XMLControlElement(PointMass.this);
                    Footprint[] footprintArray = PointMass.this.getVelocityFootprints();
                    int n = footprintArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Footprint footprint = footprintArray[n2];
                        footprint.setColor(color2);
                        ++n2;
                    }
                    Undo.postTrackEdit(PointMass.this, xMLControlElement);
                    PointMass.this.repaint();
                }
            }
        });
        this.aColorItem = new JMenuItem();
        this.aColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = PointMass.this.getAccelerationFootprint().getColor();
                Color color2 = PointMass.this.chooseColor(color, TrackerRes.getString("Acceleration.Dialog.Color.Title"));
                if (color2 != null) {
                    XMLControlElement xMLControlElement = new XMLControlElement(PointMass.this);
                    Footprint[] footprintArray = PointMass.this.getAccelerationFootprints();
                    int n = footprintArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Footprint footprint = footprintArray[n2];
                        footprint.setColor(color2);
                        ++n2;
                    }
                    Undo.postTrackEdit(PointMass.this, xMLControlElement);
                    PointMass.this.repaint();
                }
            }
        });
        this.vTailsToOriginItem = new JMenuItem();
        this.aTailsToOriginItem = new JMenuItem();
        this.vTailsToPositionItem = new JMenuItem();
        this.aTailsToPositionItem = new JMenuItem();
        this.vVisibleItem = new JCheckBoxMenuItem();
        this.aVisibleItem = new JCheckBoxMenuItem();
        this.velocityMenu.add(this.vColorItem);
        this.velocityMenu.add(this.vFootprintMenu);
        this.velocityMenu.addSeparator();
        this.velocityMenu.add(this.vTailsToOriginItem);
        this.velocityMenu.add(this.vTailsToPositionItem);
        this.accelerationMenu.add(this.aColorItem);
        this.accelerationMenu.add(this.aFootprintMenu);
        this.accelerationMenu.addSeparator();
        this.accelerationMenu.add(this.aTailsToOriginItem);
        this.accelerationMenu.add(this.aTailsToPositionItem);
        this.vVisibleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                for (TrackerPanel trackerPanel : PointMass.this.panels) {
                    PointMass.this.setVVisible(trackerPanel, PointMass.this.vVisibleItem.isSelected());
                    trackerPanel.repaint();
                }
            }
        });
        this.aVisibleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                for (TrackerPanel trackerPanel : PointMass.this.panels) {
                    PointMass.this.setAVisible(trackerPanel, PointMass.this.aVisibleItem.isSelected());
                    trackerPanel.repaint();
                }
            }
        });
        this.vTailsToOriginItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PointMass.this.snapToOrigin("v");
            }
        });
        this.aTailsToOriginItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PointMass.this.snapToOrigin("a");
            }
        });
        this.vTailsToPositionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PointMass.this.snapToPosition("v");
            }
        });
        this.aTailsToPositionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PointMass.this.snapToPosition("a");
            }
        });
    }

    protected TTrack.StepArray getVArray(TrackerPanel trackerPanel) {
        TTrack.StepArray stepArray = this.vMap.get(trackerPanel);
        if (stepArray == null) {
            stepArray = new TTrack.StepArray(this);
            this.vMap.put(trackerPanel, stepArray);
            TTrack.StepArray stepArray2 = new TTrack.StepArray(this);
            this.aMap.put(trackerPanel, stepArray2);
            this.updateDerivatives(trackerPanel);
        }
        return stepArray;
    }

    protected TTrack.StepArray getAArray(TrackerPanel trackerPanel) {
        TTrack.StepArray stepArray = this.aMap.get(trackerPanel);
        if (stepArray == null) {
            TTrack.StepArray stepArray2 = new TTrack.StepArray(this);
            this.vMap.put(trackerPanel, stepArray2);
            stepArray = new TTrack.StepArray(this);
            this.aMap.put(trackerPanel, stepArray);
        }
        return stepArray;
    }

    @Override
    protected void cleanup() {
        super.cleanup();
    }

    private void setXY() {
        double d = this.xField.getValue();
        double d2 = this.yField.getValue();
        for (TrackerPanel trackerPanel : this.panels) {
            TPoint tPoint = trackerPanel.getSelectedPoint();
            Step step = this.getStep(tPoint, trackerPanel);
            if (step == null) continue;
            ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
            double d3 = imageCoordSystem.worldToImageX(trackerPanel.getFrameNumber(), d, d2);
            double d4 = imageCoordSystem.worldToImageY(trackerPanel.getFrameNumber(), d, d2);
            tPoint.setXY(d3, d4);
            Point2D point2D = tPoint.getWorldPosition(trackerPanel);
            this.xField.setValue(point2D.getX());
            this.yField.setValue(point2D.getY());
            this.magField.setValue(point2D.distance(0.0, 0.0));
            double d5 = Math.atan2(point2D.getY(), point2D.getX());
            this.angleField.setValue(d5);
            tPoint.showCoordinates(trackerPanel);
        }
    }

    private void setMagAngle() {
        double d = this.angleField.getValue();
        double d2 = this.magField.getValue() * Math.cos(d);
        double d3 = this.magField.getValue() * Math.sin(d);
        for (TrackerPanel trackerPanel : this.panels) {
            TPoint tPoint = trackerPanel.getSelectedPoint();
            Step step = this.getStep(tPoint, trackerPanel);
            if (step == null) continue;
            ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
            double d4 = imageCoordSystem.worldToImageX(trackerPanel.getFrameNumber(), d2, d3);
            double d5 = imageCoordSystem.worldToImageY(trackerPanel.getFrameNumber(), d2, d3);
            tPoint.setXY(d4, d5);
            Point2D point2D = tPoint.getWorldPosition(trackerPanel);
            this.xField.setValue(point2D.getX());
            this.yField.setValue(point2D.getY());
            this.magField.setValue(point2D.distance(0.0, 0.0));
            d = Math.atan2(point2D.getY(), point2D.getX());
            this.angleField.setValue(d);
            tPoint.showCoordinates(trackerPanel);
        }
    }

    private void snapToOrigin(String string) {
        for (TrackerPanel trackerPanel : this.panels) {
            TPoint tPoint = trackerPanel.getSnapPoint();
            Step[] stepArray = null;
            stepArray = string.equals("v") ? this.getVelocities(trackerPanel) : this.getAccelerations(trackerPanel);
            int n = 0;
            while (n < stepArray.length) {
                if (stepArray[n] != null) {
                    VectorStep vectorStep = (VectorStep)stepArray[n];
                    if (vectorStep.chain != null) {
                        vectorStep.chain.clear();
                    }
                    vectorStep.attach(null);
                    vectorStep.attach(tPoint);
                }
                ++n;
            }
            trackerPanel.repaint();
        }
        if (string.equals("v")) {
            this.vAtOrigin = true;
        } else {
            this.aAtOrigin = true;
        }
    }

    private void snapToPosition(String string) {
        for (TrackerPanel trackerPanel : this.panels) {
            Step[] stepArray = null;
            stepArray = string.equals("v") ? this.getVelocities(trackerPanel) : this.getAccelerations(trackerPanel);
            int n = 0;
            while (n < stepArray.length) {
                if (stepArray[n] != null) {
                    VectorStep vectorStep = (VectorStep)stepArray[n];
                    PositionStep positionStep = (PositionStep)this.getStep(vectorStep.n);
                    if (vectorStep.chain != null) {
                        vectorStep.chain.clear();
                    }
                    vectorStep.attach(null);
                    vectorStep.attach(positionStep.getPosition());
                }
                ++n;
            }
            trackerPanel.repaint();
        }
        if (string.equals("v")) {
            this.vAtOrigin = false;
        } else {
            this.aAtOrigin = false;
        }
    }

    public static class FrameData {
        double x;
        double y;

        FrameData() {
        }

        FrameData(PositionStep positionStep) {
            this.x = positionStep.getPosition().getX();
            this.y = positionStep.getPosition().getY();
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            xMLControl.setValue("x", frameData.x);
            xMLControl.setValue("y", frameData.y);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new FrameData();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            frameData.x = xMLControl.getDouble("x");
            frameData.y = xMLControl.getDouble("y");
            return object;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            PointMass pointMass = (PointMass)object;
            xMLControl.setValue("mass", pointMass.getMass());
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            Footprint footprint = pointMass.getVelocityFootprint();
            if (!footprint.getColor().equals(pointMass.getColor())) {
                xMLControl.setValue("velocity_color", footprint.getColor());
            }
            if (!footprint.getName().equals(pointMass.getVelocityFootprints()[0].getName())) {
                xMLControl.setValue("velocity_footprint", footprint.getName());
            }
            if (!(footprint = pointMass.getAccelerationFootprint()).getColor().equals(pointMass.getColor())) {
                xMLControl.setValue("acceleration_color", footprint.getColor());
            }
            if (!footprint.getName().equals(pointMass.getAccelerationFootprints()[0].getName())) {
                xMLControl.setValue("acceleration_footprint", footprint.getName());
            }
            if (!pointMass.isDependent()) {
                Step[] stepArray = pointMass.getSteps();
                FrameData[] frameDataArray = new FrameData[stepArray.length];
                int n = 0;
                while (n < stepArray.length) {
                    if (stepArray[n] != null) {
                        frameDataArray[n] = new FrameData((PositionStep)stepArray[n]);
                    }
                    ++n;
                }
                xMLControl.setValue("framedata", frameDataArray);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new PointMass();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Color color;
            PointMass pointMass = (PointMass)object;
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            boolean bl = pointMass.isLocked();
            pointMass.setLocked(false);
            double d = xMLControl.getDouble("mass");
            if (d != Double.NaN) {
                pointMass.setMass(d);
            }
            if ((color = (Color)xMLControl.getObject("velocity_color")) != null) {
                pointMass.setVelocityColor(color);
            } else {
                pointMass.setVelocityColor(pointMass.getColor());
            }
            String string = xMLControl.getString("velocity_footprint");
            if (string != null) {
                pointMass.setVelocityFootprint(string);
            } else {
                pointMass.setVelocityFootprint(pointMass.getVelocityFootprints()[0].getName());
            }
            color = (Color)xMLControl.getObject("acceleration_color");
            if (color != null) {
                pointMass.setAccelerationColor(color);
            } else {
                pointMass.setAccelerationColor(pointMass.getColor());
            }
            string = xMLControl.getString("acceleration_footprint");
            if (string != null) {
                pointMass.setAccelerationFootprint(string);
            } else {
                pointMass.setAccelerationFootprint(pointMass.getAccelerationFootprints()[0].getName());
            }
            FrameData[] frameDataArray = (FrameData[])xMLControl.getObject("framedata");
            if (frameDataArray != null) {
                int n = 0;
                while (n < frameDataArray.length) {
                    if (frameDataArray[n] == null) {
                        pointMass.steps.setStep(n, null);
                    } else {
                        PositionStep positionStep = (PositionStep)pointMass.getStep(n);
                        if (positionStep != null) {
                            positionStep.getPosition().setLocation(frameDataArray[n].x, frameDataArray[n].y);
                            positionStep.erase();
                        } else {
                            pointMass.createStep(n, frameDataArray[n].x, frameDataArray[n].y);
                        }
                    }
                    ++n;
                }
                pointMass.updateDerivatives();
                pointMass.support.firePropertyChange("data", null, null);
            }
            pointMass.setLocked(bl);
            return object;
        }
    }
}

