/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JMenu;
import org.opensourcephysics.cabrillo.tracker.CircleFootprint;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.PerspectiveStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.PerspectiveFilter;
import org.opensourcephysics.media.core.TPoint;

public class PerspectiveTrack
extends TTrack {
    PerspectiveFilter filter;

    public PerspectiveTrack(PerspectiveFilter perspectiveFilter) {
        this.filter = perspectiveFilter;
        this.viewable = false;
        CircleFootprint circleFootprint = (CircleFootprint)CircleFootprint.getFootprint("CircleFootprint.Circle");
        circleFootprint.setColor(perspectiveFilter.getColor());
        circleFootprint.setSpotShown(false);
        circleFootprint.setAlpha(0);
        this.setFootprints(new Footprint[]{circleFootprint});
        this.setName(MediaRes.getString("Filter.Perspective.Title").toLowerCase());
        PerspectiveStep perspectiveStep = new PerspectiveStep(this, 0, 0.0, 0.0);
        perspectiveStep.setFootprint(this.getFootprint());
        this.steps = new TTrack.StepArray(this, perspectiveStep);
        perspectiveFilter.addPropertyChangeListener("color", this);
        perspectiveFilter.addPropertyChangeListener("visible", this);
        perspectiveFilter.addPropertyChangeListener("enabled", this);
        perspectiveFilter.addPropertyChangeListener("tab", this);
        perspectiveFilter.addPropertyChangeListener("cornerlocation", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() == this.filter) {
            if (string.equals("color")) {
                this.setColor((Color)propertyChangeEvent.getNewValue());
            } else if (string.equals("enabled") || string.equals("tab") || string.equals("visible")) {
                boolean bl;
                boolean bl2 = this.filter.hasInspector() && this.filter.getInspector().isVisible();
                boolean bl3 = this.filter.isInputEnabled();
                boolean bl4 = this.filter.isActive();
                boolean bl5 = bl = this.trackerPanel.getSelectedPoint() == null;
                if (bl2 && bl4 && bl3 && bl) {
                    this.trackerPanel.setSelectedTrack(this);
                } else if (this.trackerPanel.getSelectedTrack() == this) {
                    this.trackerPanel.setSelectedTrack(null);
                    this.trackerPanel.setSelectedPoint(null);
                }
            } else if (string.equals("cornerlocation") && this.filter.isInputEnabled()) {
                PerspectiveFilter.Corner corner = (PerspectiveFilter.Corner)propertyChangeEvent.getNewValue();
                int n = this.filter.getCornerIndex(corner);
                int n2 = this.trackerPanel.getFrameNumber();
                this.getStep((int)n2).points[n].setXY(corner.getX(), corner.getY());
            }
        }
        if (string.equals("selectedtrack") && propertyChangeEvent.getNewValue() == this) {
            if (!this.filter.isEnabled()) {
                this.filter.setEnabled(true);
            }
            if (!this.filter.isInputEnabled()) {
                this.filter.setInputEnabled(true);
            }
            if (this.filter.hasInspector() && !this.filter.getInspector().isVisible()) {
                this.filter.getInspector().setVisible(true);
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        return null;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        this.menu = new JMenu(this.getName());
        this.menu.setIcon(this.getFootprint().getIcon(21, 16));
        return this.menu;
    }

    @Override
    public Step getStep(TPoint tPoint, TrackerPanel trackerPanel) {
        PerspectiveFilter.Corner corner;
        int n;
        if (this.filter.isEnabled()) {
            return null;
        }
        if (tPoint instanceof PerspectiveFilter.Corner && (n = this.filter.getCornerIndex(corner = (PerspectiveFilter.Corner)tPoint)) > -1) {
            return this.getStep(trackerPanel.getFrameNumber());
        }
        return super.getStep(tPoint, trackerPanel);
    }

    @Override
    public Step deleteStep(int n) {
        Object object;
        if (this.locked) {
            return null;
        }
        TPoint tPoint = this.trackerPanel.getSelectedPoint();
        if (tPoint instanceof PerspectiveFilter.Corner) {
            object = new XMLControlElement(this.filter);
            PerspectiveFilter.Corner corner = (PerspectiveFilter.Corner)tPoint;
            this.filter.deleteKeyFrame(n, corner);
            Undo.postFilterEdit(this.trackerPanel, this.filter, (XMLControl)object);
            this.trackerPanel.repaint();
        }
        object = this.getStep(n);
        return object;
    }

    @Override
    public TPoint autoMarkAt(int n, double d, double d2) {
        int n2 = this.getTargetIndex();
        PerspectiveStep perspectiveStep = (PerspectiveStep)this.getStep(n);
        perspectiveStep.points[n2].setXY(d, d2);
        this.filter.setCornerLocation(n, n2, d, d2);
        return this.getMarkedPoint(n, n2);
    }

    @Override
    public TPoint getMarkedPoint(int n, int n2) {
        Step step = this.getStep(n);
        return step.points[n2];
    }

    @Override
    protected void setTargetIndex(TPoint tPoint) {
        Step step = this.getStep(tPoint, this.trackerPanel);
        if (step != null) {
            this.setTargetIndex(step.getPointIndex(tPoint));
        }
    }

    @Override
    protected String getTargetDescription(int n) {
        return String.valueOf(TrackerRes.getString("PerspectiveTrack.Corner")) + " " + n;
    }

    @Override
    protected boolean isAutoTrackable(int n) {
        return n < 4;
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
    }

    @Override
    public int getStepLength() {
        return 4;
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    @Override
    public Step createStep(int n, double d, double d2) {
        this.autoMarkAt(n, d, d2);
        return this.getStep(n);
    }

    @Override
    public void remark(TrackerPanel trackerPanel) {
    }
}

