/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.FontSizer;

class MonitorDialog
extends JDialog {
    JProgressBar monitor;
    Timer timer;
    int frameCount = Integer.MIN_VALUE;

    MonitorDialog(TFrame tFrame, String string) {
        super((Frame)tFrame, false);
        this.setName(string);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        this.monitor = new JProgressBar(0, 100);
        this.monitor.setValue(0);
        this.monitor.setStringPainted(true);
        this.timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MonitorDialog.this.isVisible()) {
                    return;
                }
                int n = MonitorDialog.this.monitor.getValue() + 1;
                if (n <= 20) {
                    MonitorDialog.this.monitor.setValue(n);
                }
            }
        });
        this.timer.setRepeats(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                VideoIO.setCanceled(true);
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 30, 8, 30));
        jPanel2.add((Component)this.monitor, "Center");
        jPanel2.setOpaque(false);
        JLabel jLabel = new JLabel(String.valueOf(TrackerRes.getString("Tracker.Splash.Loading")) + " \"" + XML.getName(string) + "\"");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jLabel);
        JButton jButton = new JButton(TrackerRes.getString("Dialog.Button.Cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoIO.setCanceled(true);
                MonitorDialog.this.close();
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        FontSizer.setFonts(jPanel, FontSizer.getLevel());
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n, n2);
        this.timer.start();
    }

    void stop() {
        this.timer.stop();
    }

    void restart() {
        this.monitor.setValue(0);
        this.frameCount = Integer.MIN_VALUE;
        this.timer.start();
    }

    void setProgress(int n) {
        this.monitor.setValue(n);
    }

    void setFrameCount(int n) {
        this.frameCount = n;
    }

    int getFrameCount() {
        return this.frameCount;
    }

    void close() {
        this.timer.stop();
        this.setVisible(false);
        TrackerIO.monitors.remove(this);
        this.dispose();
    }
}

