/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineProfile;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.OutlineFootprint;
import org.opensourcephysics.cabrillo.tracker.RGBRegion;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class LineProfileStep
extends Step {
    static TPoint center = new TPoint();
    protected TPoint lineEnd0;
    protected TPoint lineEnd1;
    protected Handle handle;
    protected boolean endsEnabled = true;
    protected Map<TrackerPanel, Shape> end0Shapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, Shape> end1Shapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, Shape> shaftShapes = new HashMap<TrackerPanel, Shape>();
    protected LineProfile line;
    protected Corner[][] corners;
    protected GridIntersection[] endX;
    protected GridIntersection[] endY;
    protected GridIntersection[][] sweepX;
    protected GridIntersection[][] sweepY;
    protected TreeSet<Intersection> sorter = new TreeSet();
    protected ArrayList<GridVertex> vertices = new ArrayList();
    private double sin;
    private double cos;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private TreeSet<GridSegment> xSegments = new TreeSet();
    private TreeSet<GridSegment> ySegments = new TreeSet();
    private int leadingIndex;
    private Intersection[] polygon = new Intersection[8];
    private Point polyLoc = new Point();
    private double[] quadAreas = new double[4];

    public LineProfileStep(LineProfile lineProfile, int n, double d, double d2, double d3, double d4) {
        super(lineProfile, n);
        this.line = lineProfile;
        this.lineEnd0 = new LineEnd(d, d2);
        this.lineEnd0.setTrackEditTrigger(false);
        this.lineEnd1 = new LineEnd(d3, d4);
        this.handle = new Handle((d + d3) / 2.0, (d2 + d4) / 2.0);
        this.points = new TPoint[]{this.lineEnd0, this.lineEnd1, this.handle};
        this.screenPoints = new Point[LineProfileStep.getLength()];
        this.xSegments = new TreeSet();
        this.ySegments = new TreeSet();
        this.corners = new Corner[2][2];
        this.endX = new GridIntersection[2];
        this.endY = new GridIntersection[2];
        int n2 = 0;
        while (n2 < 2) {
            this.corners[0][n2] = new Corner();
            this.corners[1][n2] = new Corner();
            this.endX[n2] = new GridIntersection(0.0, 0.0, true);
            this.endY[n2] = new GridIntersection(0.0, 0.0, false);
            ++n2;
        }
    }

    public TPoint getLineEnd0() {
        return this.lineEnd0;
    }

    public TPoint getLineEnd1() {
        return this.lineEnd1;
    }

    public TPoint getHandle() {
        return this.handle;
    }

    public void setEndsEnabled(boolean bl) {
        this.endsEnabled = bl;
    }

    public boolean isEndsEnabled() {
        return this.endsEnabled;
    }

    @Override
    public void setFootprint(Footprint footprint) {
        if (footprint.getLength() >= 2) {
            super.setFootprint(footprint);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Shape shape;
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        this.setHitRectCenter(n, n2);
        if (this.endsEnabled) {
            shape = this.end0Shapes.get(trackerPanel);
            if (shape != null && shape.intersects(hitRect)) {
                return this.lineEnd0;
            }
            shape = this.end1Shapes.get(trackerPanel);
            if (shape != null && shape.intersects(hitRect)) {
                return this.lineEnd1;
            }
        }
        if ((shape = this.shaftShapes.get(trackerPanel)) != null && shape.intersects(hitRect)) {
            return this.handle;
        }
        return null;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.getMark(trackerPanel).draw(graphics2D, false);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.marks.get(trackerPanel);
        TPoint tPoint = null;
        if (mark == null) {
            Object object;
            if (this.footprint instanceof OutlineFootprint) {
                int n;
                OutlineFootprint outlineFootprint = (OutlineFootprint)this.footprint;
                object = (LineProfile)this.track;
                int n2 = ((LineProfile)object).getSpread();
                double d = trackerPanel.getXPixPerUnit();
                if (!trackerPanel.isDrawingInImageSpace()) {
                    n = trackerPanel.getFrameNumber();
                    d /= trackerPanel.getCoords().getScaleX(n);
                }
                n = (int)(d * (0.5 + (double)n2));
                outlineFootprint.setSpread(n);
            }
            tPoint = trackerPanel.getSelectedPoint();
            int n = 0;
            object = null;
            Shape shape = null;
            int n3 = 0;
            while (n3 < this.points.length) {
                this.screenPoints[n3] = this.points[n3].getScreenPosition(trackerPanel);
                if (tPoint == this.points[n3]) {
                    object = this.screenPoints[n3];
                    n = n3;
                }
                ++n3;
            }
            mark = this.footprint.getMark(this.screenPoints);
            if (object != null) {
                transform.setToTranslation(((Point)object).x, ((Point)object).y);
                n3 = FontSizer.getIntegerFactor();
                if (n3 > 1) {
                    transform.scale(n3, n3);
                }
                shape = transform.createTransformedShape(selectionShape);
                final Color color = this.footprint.getColor();
                final Mark mark2 = mark;
                final Shape shape2 = shape;
                mark = new Mark(){

                    @Override
                    public void draw(Graphics2D graphics2D, boolean bl) {
                        mark2.draw(graphics2D, false);
                        Paint paint = graphics2D.getPaint();
                        graphics2D.setPaint(color);
                        graphics2D.fill(shape2);
                        graphics2D.setPaint(paint);
                    }

                    @Override
                    public Rectangle getBounds(boolean bl) {
                        Rectangle rectangle = shape2.getBounds();
                        rectangle.add(mark2.getBounds(false));
                        return rectangle;
                    }
                };
            }
            this.marks.put(trackerPanel, mark);
            Shape[] shapeArray = this.footprint.getHitShapes();
            this.end0Shapes.put(trackerPanel, shapeArray[0]);
            this.end1Shapes.put(trackerPanel, shapeArray[1]);
            if (shape != null && n == 2) {
                this.shaftShapes.put(trackerPanel, shape);
            } else {
                this.shaftShapes.put(trackerPanel, shapeArray[2]);
            }
        }
        return mark;
    }

    @Override
    public Rectangle getBounds(TrackerPanel trackerPanel) {
        Rectangle rectangle = this.getMark(trackerPanel).getBounds(false);
        return rectangle;
    }

    @Override
    public Object clone() {
        LineProfileStep lineProfileStep = (LineProfileStep)super.clone();
        if (lineProfileStep != null) {
            TPoint[] tPointArray = lineProfileStep.points;
            LineProfileStep lineProfileStep2 = lineProfileStep;
            lineProfileStep2.getClass();
            tPointArray[0] = lineProfileStep.lineEnd0 = lineProfileStep2.new LineEnd(this.lineEnd0.getX(), this.lineEnd0.getY());
            TPoint[] tPointArray2 = lineProfileStep.points;
            LineProfileStep lineProfileStep3 = lineProfileStep;
            lineProfileStep3.getClass();
            tPointArray2[1] = lineProfileStep.lineEnd1 = lineProfileStep3.new LineEnd(this.lineEnd1.getX(), this.lineEnd1.getY());
            TPoint[] tPointArray3 = lineProfileStep.points;
            LineProfileStep lineProfileStep4 = lineProfileStep;
            lineProfileStep4.getClass();
            lineProfileStep.handle = lineProfileStep4.new Handle(this.handle.getX(), this.handle.getY());
            tPointArray3[2] = lineProfileStep.handle;
            lineProfileStep.end0Shapes = new HashMap<TrackerPanel, Shape>();
            lineProfileStep.end1Shapes = new HashMap<TrackerPanel, Shape>();
            lineProfileStep.shaftShapes = new HashMap<TrackerPanel, Shape>();
            lineProfileStep.endX = new GridIntersection[2];
            lineProfileStep.endY = new GridIntersection[2];
            int n = 0;
            while (n < 2) {
                lineProfileStep.endX[n] = new GridIntersection(0.0, 0.0, true);
                lineProfileStep.endY[n] = new GridIntersection(0.0, 0.0, false);
                ++n;
            }
        }
        return lineProfileStep;
    }

    @Override
    public String toString() {
        return "LineProfileStep " + this.n + " [" + format.format(this.lineEnd0.x) + ", " + format.format(this.lineEnd0.y) + ", " + format.format(this.lineEnd1.x) + ", " + format.format(this.lineEnd1.y) + "]";
    }

    public double[][] getProfileData(TrackerPanel trackerPanel) {
        if (trackerPanel.getVideo() == null) {
            return null;
        }
        LineProfile lineProfile = (LineProfile)this.getTrack();
        int n = trackerPanel.getFrameNumber();
        double d = trackerPanel.getCoords().getAngle(n);
        if (lineProfile.isHorizontal || Math.abs(Math.sin(d)) < 1.0E-5) {
            return this.getHorizontalProfileData(trackerPanel);
        }
        return this.getTiltedProfileData(trackerPanel);
    }

    protected void rotate() {
        double d;
        double d2;
        if (this.line.trackerPanel == null) {
            return;
        }
        double d3 = this.line.trackerPanel.getCoords().getAngle(this.n);
        if (this.line.isHorizontal) {
            d3 = 0.0;
        }
        if ((d2 = this.lineEnd0.angle(this.lineEnd1)) > 1.5707963267948966 || d2 < -1.5707963267948966) {
            d2 = this.lineEnd1.angle(this.lineEnd0);
        }
        if (Math.abs(d = d3 + d2) > 1.0E-7) {
            center.center(this.lineEnd0, this.lineEnd1);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(-d, LineProfileStep.center.x, LineProfileStep.center.y);
            affineTransform.transform(this.lineEnd0, this.lineEnd0);
            affineTransform.transform(this.lineEnd1, this.lineEnd1);
            this.erase();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private double[][] getTiltedProfileData(TrackerPanel trackerPanel) {
        double d = this.lineEnd0.distance(this.lineEnd1);
        if (d < 1.0) {
            return null;
        }
        BufferedImage bufferedImage = trackerPanel.getVideo().getImage();
        if (bufferedImage != null && bufferedImage.getType() == 1) {
            int n;
            Rectangle rectangle = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
            int n2 = 1 + 2 * this.line.getSpread();
            int n3 = (int)Math.floor(d);
            double d2 = this.lineEnd0.angle(this.lineEnd1);
            this.cos = Math.cos(d2);
            this.sin = Math.sin(d2);
            double d3 = (double)n2 * this.sin / 2.0;
            double d4 = (double)n2 * this.cos / 2.0;
            this.corners[0][0].x = this.lineEnd0.x - d3;
            this.corners[0][0].y = this.lineEnd0.y + d4;
            this.corners[0][1].x = this.lineEnd0.x + d3;
            this.corners[0][1].y = this.lineEnd0.y - d4;
            while (!(n3 <= 0 || rectangle.contains(this.corners[0][0]) && rectangle.contains(this.corners[0][1]))) {
                --n3;
                this.corners[0][0].x += this.cos;
                this.corners[0][0].y += this.sin;
                this.corners[0][1].x += this.cos;
                this.corners[0][1].y += this.sin;
            }
            this.corners[1][0].x = this.lineEnd1.x - d3;
            this.corners[1][0].y = this.lineEnd1.y + d4;
            this.corners[1][1].x = this.lineEnd1.x + d3;
            this.corners[1][1].y = this.lineEnd1.y - d4;
            while (!(n3 <= 0 || rectangle.contains(this.corners[1][0]) && rectangle.contains(this.corners[1][1]))) {
                --n3;
                this.corners[1][0].x -= this.cos;
                this.corners[1][0].y -= this.sin;
                this.corners[1][1].x -= this.cos;
                this.corners[1][1].y -= this.sin;
            }
            if (n3 < 1) {
                return null;
            }
            this.xMin = this.xMax = this.corners[0][0].x;
            this.yMin = this.yMax = this.corners[0][0].y;
            int n4 = 0;
            while (n4 < 2) {
                n = 0;
                while (n < 2) {
                    this.xMin = Math.min(this.xMin, this.corners[n4][n].x);
                    this.yMin = Math.min(this.yMin, this.corners[n4][n].y);
                    this.xMax = Math.max(this.xMax, this.corners[n4][n].x);
                    this.yMax = Math.max(this.yMax, this.corners[n4][n].y);
                    ++n;
                }
                ++n4;
            }
            double[][] dArray = new double[7][n3];
            n = (int)Math.floor(this.xMin);
            int n5 = (int)Math.floor(this.yMin);
            int n6 = (int)Math.ceil(this.xMax);
            int n7 = (int)Math.ceil(this.yMax);
            int n8 = n6 - n;
            int n9 = n7 - n5;
            int[] nArray = new int[n8 * n9];
            if (this.sweepX == null || this.sweepX[0].length < n2) {
                this.sweepX = new GridIntersection[2][n2];
                this.sweepY = new GridIntersection[2][n2];
                int n10 = 0;
                while (n10 < n2) {
                    this.sweepX[0][n10] = new GridIntersection(0.0, 0.0, true);
                    this.sweepX[1][n10] = new GridIntersection(0.0, 0.0, true);
                    this.sweepY[0][n10] = new GridIntersection(0.0, 0.0, false);
                    this.sweepY[1][n10] = new GridIntersection(0.0, 0.0, false);
                    ++n10;
                }
            }
            this.leadingIndex = 0;
            this.findLeadingIntersections();
            Point2D.Double double_ = new Point2D.Double();
            Point2D.Double double_2 = new Point2D.Double();
            try {
                int n11 = trackerPanel.getFrameNumber();
                AffineTransform affineTransform = trackerPanel.getCoords().getToWorldTransform(n11);
                bufferedImage.getRaster().getDataElements(n, n5, n8, n9, nArray);
                int n12 = 0;
                while (n12 < n3) {
                    double d5;
                    int n13;
                    int n14;
                    int n15;
                    Corner corner = this.corners[this.leadingIndex][0];
                    Corner corner2 = this.corners[this.leadingIndex][1];
                    this.leadingIndex = this.leadingIndex == 0 ? 1 : 0;
                    this.corners[this.leadingIndex][0].x = corner.x + this.cos;
                    this.corners[this.leadingIndex][0].y = corner.y + this.sin;
                    this.corners[this.leadingIndex][1].x = corner2.x + this.cos;
                    this.corners[this.leadingIndex][1].y = corner2.y + this.sin;
                    this.xMin = this.xMax = this.corners[0][0].x;
                    this.yMin = this.yMax = this.corners[0][0].y;
                    int n16 = 0;
                    while (n16 < 2) {
                        n15 = 0;
                        while (n15 < 2) {
                            this.xMin = Math.min(this.xMin, this.corners[n16][n15].x);
                            this.yMin = Math.min(this.yMin, this.corners[n16][n15].y);
                            this.xMax = Math.max(this.xMax, this.corners[n16][n15].x);
                            this.yMax = Math.max(this.yMax, this.corners[n16][n15].y);
                            ++n15;
                        }
                        ++n16;
                    }
                    ((Point2D)double_).setLocation((this.xMax + this.xMin) / 2.0, (this.yMax + this.yMin) / 2.0);
                    affineTransform.transform(double_, double_2);
                    dArray[0][n12] = ((Point2D)double_2).getX();
                    dArray[1][n12] = ((Point2D)double_2).getY();
                    n16 = (int)Math.floor(this.xMin);
                    n15 = (int)Math.floor(this.yMin);
                    int n17 = (int)Math.ceil(this.xMax) - n16;
                    int n18 = (int)Math.ceil(this.yMax) - n15;
                    double[][] dArray2 = new double[n17][n18];
                    this.findLeadingIntersections();
                    this.findEndIntersections();
                    this.findGridSegments();
                    this.findGridVertices();
                    double d6 = 0.0;
                    double d7 = 0.0;
                    double d8 = 0.0;
                    double d9 = 0.0;
                    if (!this.vertices.isEmpty()) {
                        for (GridVertex gridVertex : this.vertices) {
                            n14 = (int)gridVertex.x - n16;
                            n13 = (int)gridVertex.y - n15;
                            this.quadAreas[0] = dArray2[n14][n13];
                            this.quadAreas[1] = n14 > 0 ? dArray2[n14 - 1][n13] : 1.0;
                            this.quadAreas[2] = n13 > 0 && n14 > 0 ? dArray2[n14 - 1][n13 - 1] : 1.0;
                            this.quadAreas[3] = n13 > 0 ? dArray2[n14][n13 - 1] : 1.0;
                            this.getAreas(gridVertex, this.quadAreas);
                            dArray2[n14][n13] = this.quadAreas[0];
                            if (n14 > 0) {
                                dArray2[n14 - 1][n13] = this.quadAreas[1];
                            }
                            if (n13 <= 0) continue;
                            dArray2[n14][n13 - 1] = this.quadAreas[3];
                            if (n14 <= 0) continue;
                            dArray2[n14 - 1][n13 - 1] = this.quadAreas[2];
                        }
                    } else {
                        GridSegment gridSegment = this.xSegments.iterator().next();
                        d5 = this.getArea(gridSegment.lower, gridSegment.higher);
                        n14 = this.polyLoc.x - n16;
                        n13 = this.polyLoc.y - n15;
                        if (d5 > 0.0) {
                            dArray2[n14][n13] = d5;
                        }
                        d5 = this.getArea(gridSegment.higher, gridSegment.lower);
                        n14 = this.polyLoc.x - n16;
                        n13 = this.polyLoc.y - n15;
                        if (d5 > 0.0) {
                            dArray2[n14][n13] = d5;
                        }
                    }
                    int n19 = 0;
                    while (n19 < 2) {
                        int n20 = 0;
                        while (n20 < 2) {
                            d5 = this.getArea(this.corners[n19][n20]);
                            n14 = this.polyLoc.x - n16;
                            n13 = this.polyLoc.y - n15;
                            if (d5 > 0.0) {
                                dArray2[n14][n13] = d5;
                            }
                            ++n20;
                        }
                        ++n19;
                    }
                    n19 = 0;
                    while (n19 < dArray2[0].length) {
                        int n21 = 0;
                        while (n21 < dArray2.length) {
                            int n22 = n21 + n16 - n;
                            int n23 = n19 + n15 - n5;
                            int n24 = n22 + n23 * n8;
                            int n25 = nArray[n24];
                            int n26 = n25 >> 16 & 0xFF;
                            int n27 = n25 >> 8 & 0xFF;
                            int n28 = n25 & 0xFF;
                            d5 = dArray2[n21][n19];
                            d7 += d5 * (double)n26;
                            d8 += d5 * (double)n27;
                            d9 += d5 * (double)n28;
                            d6 += d5;
                            ++n21;
                        }
                        ++n19;
                    }
                    if (d6 == 0.0) {
                        return null;
                    }
                    dArray[2][n12] = d7 /= d6;
                    dArray[3][n12] = d8 /= d6;
                    dArray[4][n12] = d9 /= d6;
                    dArray[5][n12] = RGBRegion.getLuma(d7, d8, d9);
                    dArray[6][n12] = n2;
                    ++n12;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
                return null;
            }
            return dArray;
        }
        return null;
    }

    private void findLeadingIntersections() {
        this.sorter.clear();
        this.sorter.add(this.corners[this.leadingIndex][0]);
        this.sorter.add(this.corners[this.leadingIndex][1]);
        Iterator<Intersection> iterator = this.sorter.iterator();
        Corner corner = (Corner)iterator.next();
        Corner corner2 = (Corner)iterator.next();
        corner.lowerX = null;
        corner2.higherX = null;
        double d = -this.cos / this.sin;
        double d2 = this.corners[this.leadingIndex][0].y - d * this.corners[this.leadingIndex][0].x;
        int n = 0;
        int n2 = (int)Math.ceil(corner.x);
        while (n2 <= (int)Math.floor(corner2.x)) {
            double d3 = d * (double)n2 + d2;
            this.sweepX[this.leadingIndex][n].setLocation(n2, d3);
            this.sorter.add(this.sweepX[this.leadingIndex][n]);
            ++n;
            ++n2;
        }
        while (n < this.sweepX[this.leadingIndex].length) {
            this.sweepX[this.leadingIndex][n].setLocation(Double.NaN, Double.NaN);
            ++n;
        }
        double d4 = Math.min(corner.y, corner2.y);
        double d5 = Math.max(corner.y, corner2.y);
        n = 0;
        int n3 = (int)Math.ceil(d4);
        while (n3 <= (int)Math.floor(d5)) {
            double d6 = ((double)n3 - d2) / d;
            this.sweepY[this.leadingIndex][n].setLocation(d6, n3);
            this.sorter.add(this.sweepY[this.leadingIndex][n]);
            ++n;
            ++n3;
        }
        while (n < this.sweepY[this.leadingIndex].length) {
            this.sweepY[this.leadingIndex][n].setLocation(Double.NaN, Double.NaN);
            ++n;
        }
        iterator = this.sorter.iterator();
        Intersection intersection = null;
        while (iterator.hasNext()) {
            Intersection intersection2 = iterator.next();
            if (intersection != null) {
                intersection.higherX = intersection2;
                intersection2.lowerX = intersection;
            }
            intersection = intersection2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findGridSegments() {
        double d;
        this.xSegments.clear();
        this.sorter.clear();
        int n = 0;
        while (n < 2) {
            if (!Double.isNaN(this.endX[n].x)) {
                this.sorter.add(this.endX[n]);
            }
            ++n;
        }
        n = 0;
        while (n < this.sweepX[0].length) {
            int n2 = 0;
            while (n2 < 2) {
                if (!Double.isNaN(this.sweepX[n2][n].x)) {
                    this.sorter.add(this.sweepX[n2][n]);
                }
                ++n2;
            }
            ++n;
        }
        GridIntersection gridIntersection = null;
        for (GridIntersection gridIntersection2 : this.sorter) {
            if (gridIntersection == null) {
                gridIntersection = gridIntersection2;
                continue;
            }
            this.xSegments.add(new GridSegment(gridIntersection2, gridIntersection));
            gridIntersection = null;
        }
        this.ySegments.clear();
        this.sorter.clear();
        int n3 = 0;
        while (n3 < 2) {
            if (!Double.isNaN(this.endY[n3].y)) {
                double d2 = this.endY[n3].y;
                this.endY[n3].setLocation(d2, this.endY[n3].x);
                this.sorter.add(this.endY[n3]);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.sweepY[0].length) {
            void var3_10;
            boolean n4 = false;
            while (var3_10 < 2) {
                if (!Double.isNaN(this.sweepY[var3_10][n3].y)) {
                    d = this.sweepY[var3_10][n3].y;
                    this.sweepY[var3_10][n3].setLocation(d, this.sweepY[var3_10][n3].x);
                    this.sorter.add(this.sweepY[var3_10][n3]);
                }
                ++var3_10;
            }
            ++n3;
        }
        gridIntersection = null;
        for (GridIntersection gridIntersection2 : this.sorter) {
            d = gridIntersection2.y;
            gridIntersection2.setLocation(d, gridIntersection2.x);
            if (gridIntersection == null) {
                gridIntersection = gridIntersection2;
                continue;
            }
            this.ySegments.add(new GridSegment(gridIntersection2, gridIntersection));
            gridIntersection = null;
        }
    }

    private void findGridVertices() {
        this.vertices.clear();
        block0: for (GridSegment object2 : this.xSegments) {
            for (GridSegment gridSegment : this.ySegments) {
                if (gridSegment.higher.x < object2.value) continue;
                if (gridSegment.lower.x > object2.value) continue block0;
                if (!(object2.lower.y < gridSegment.value) || !(object2.higher.y > gridSegment.value)) continue;
                this.vertices.add(new GridVertex(object2, gridSegment));
            }
        }
        Collections.sort(this.vertices);
        Iterator<GridVertex> iterator = this.vertices.iterator();
        Object object = null;
        while (iterator.hasNext()) {
            GridVertex gridVertex = iterator.next();
            if (object != null && ((Point2D)object).distance(gridVertex) == 1.0) {
                GridSegment gridSegment;
                if (((GridVertex)object).x == gridVertex.x) {
                    gridVertex.isVertical = true;
                    ((GridVertex)object).isVertical = true;
                    if (gridVertex.y - ((GridVertex)object).y > 0.0) {
                        gridSegment = new GridSegment(((GridVertex)object).vert.lower, gridVertex);
                        ((GridVertex)object).setVerticalSegment(gridSegment);
                        gridSegment = new GridSegment(gridVertex.vert.higher, (GridIntersection)object);
                        gridVertex.setVerticalSegment(gridSegment);
                    } else {
                        gridSegment = new GridSegment(((GridVertex)object).vert.higher, gridVertex);
                        ((GridVertex)object).setVerticalSegment(gridSegment);
                        gridSegment = new GridSegment(gridVertex.vert.lower, (GridIntersection)object);
                        gridVertex.setVerticalSegment(gridSegment);
                    }
                } else {
                    gridVertex.isVertical = false;
                    ((GridVertex)object).isVertical = false;
                    gridSegment = new GridSegment(((GridVertex)object).horz.lower, gridVertex);
                    ((GridVertex)object).setHorizontalSegment(gridSegment);
                    gridSegment = new GridSegment(gridVertex.horz.higher, (GridIntersection)object);
                    gridVertex.setHorizontalSegment(gridSegment);
                }
            }
            object = gridVertex;
        }
    }

    private void findEndIntersections() {
        int n = this.leadingIndex == 0 ? 1 : 0;
        int n2 = 0;
        while (n2 < 2) {
            double d;
            double d2;
            this.sorter.clear();
            this.sorter.add(this.corners[0][n2]);
            this.sorter.add(this.corners[1][n2]);
            double d3 = this.corners[n][n2].y - this.sin * this.corners[n][n2].x / this.cos;
            double d4 = this.cos > 0.0 ? Math.ceil(this.corners[n][n2].x) : Math.ceil(this.corners[this.leadingIndex][n2].x);
            double d5 = d2 = this.cos > 0.0 ? this.corners[this.leadingIndex][n2].x : this.corners[n][n2].x;
            if (d4 < d2) {
                d = this.sin * d4 / this.cos + d3;
                this.endX[n2].setLocation(d4, d);
                this.sorter.add(this.endX[n2]);
            } else {
                this.endX[n2].setLocation(Double.NaN, Double.NaN);
            }
            d4 = this.sin > 0.0 ? Math.ceil(this.corners[n][n2].y) : Math.ceil(this.corners[this.leadingIndex][n2].y);
            double d6 = d2 = this.sin > 0.0 ? this.corners[this.leadingIndex][n2].y : this.corners[n][n2].y;
            if (d4 < d2) {
                d = (d4 - d3) * this.cos / this.sin;
                this.endY[n2].setLocation(d, d4);
                this.sorter.add(this.endY[n2]);
            } else {
                this.endY[n2].setLocation(Double.NaN, Double.NaN);
            }
            Iterator<Intersection> iterator = this.sorter.iterator();
            Intersection intersection = null;
            while (iterator.hasNext()) {
                Intersection intersection2 = iterator.next();
                if (intersection != null) {
                    Corner corner;
                    if (intersection instanceof Corner) {
                        corner = (Corner)intersection;
                        corner.end = intersection2;
                        if (corner.higherX == null || Double.isNaN(corner.higherX.x)) {
                            corner.higherX = intersection2;
                        }
                    } else {
                        intersection.higherX = intersection2;
                    }
                    if (intersection2 instanceof Corner) {
                        corner = (Corner)intersection2;
                        corner.end = intersection;
                        if (corner.lowerX == null || Double.isNaN(corner.lowerX.x)) {
                            corner.lowerX = intersection;
                        }
                    } else {
                        intersection2.lowerX = intersection;
                    }
                }
                intersection = intersection2;
            }
            ++n2;
        }
    }

    private Intersection getNext(Intersection intersection, Intersection intersection2) {
        Intersection intersection3;
        Intersection intersection4 = null;
        if (intersection instanceof GridVertex) {
            intersection3 = (GridVertex)intersection;
            if (intersection2 == intersection3.horz.lower) {
                return intersection3.vert.higher;
            }
            if (intersection2 == intersection3.horz.higher) {
                return intersection3.vert.lower;
            }
            if (intersection2 == intersection3.vert.lower) {
                return intersection3.horz.lower;
            }
            intersection4 = intersection3.horz.higher;
        }
        if (intersection instanceof Corner) {
            intersection3 = (Corner)intersection;
            if (intersection2.compareTo(((Corner)intersection3).end) == 0) {
                if (((Corner)intersection3).higherX != null && !Double.isNaN(((Corner)intersection3).higherX.x) && ((Corner)intersection3).higherX.compareTo(intersection3) > 0) {
                    intersection4 = ((Corner)intersection3).higherX;
                } else if (((Corner)intersection3).lowerX != null && !Double.isNaN(((Corner)intersection3).lowerX.x) && ((Corner)intersection3).lowerX.compareTo(intersection3) < 0) {
                    intersection4 = ((Corner)intersection3).lowerX;
                }
            } else {
                intersection4 = ((Corner)intersection3).end;
            }
        }
        if (intersection4 == null && intersection instanceof GridIntersection) {
            intersection3 = (GridIntersection)intersection;
            if (intersection2 == intersection3.segment.vertex) {
                GridVertex gridVertex = (GridVertex)intersection2;
                intersection4 = intersection3 == gridVertex.vert.higher ? intersection3.lowerX : (intersection3 == gridVertex.vert.lower ? intersection3.higherX : (intersection3 == gridVertex.horz.higher ? (intersection3.higherX.y > intersection3.y ? intersection3.higherX : intersection3.lowerX) : (intersection3.higherX.y < intersection3.y ? intersection3.higherX : intersection3.lowerX)));
            } else {
                intersection4 = intersection3.segment.vertex == null ? (intersection2 == intersection3.segment.lower ? (intersection3.isVertical ? intersection3.lowerX : (intersection3.higherX.y > intersection3.y ? intersection3.higherX : intersection3.lowerX)) : (intersection2 == intersection3.segment.higher ? (intersection3.isVertical ? intersection3.higherX : (intersection3.higherX.y < intersection3.y ? intersection3.higherX : intersection3.lowerX)) : (intersection3 == intersection3.segment.higher ? intersection3.segment.lower : intersection3.segment.higher))) : intersection3.segment.vertex;
            }
        }
        if (intersection4 == null) {
            return null;
        }
        double d = Math.atan2(intersection.getY() - intersection2.getY(), intersection.getX() - intersection2.getX());
        double d2 = Math.atan2(intersection4.getY() - intersection.getY(), intersection4.getX() - intersection.getX());
        double d3 = d2 - d;
        if (d3 > 0.0 && d3 < Math.PI || d3 < -Math.PI) {
            return intersection4;
        }
        return null;
    }

    private double[] getAreas(GridVertex gridVertex, double[] dArray) {
        int n = 0;
        while (n < 4) {
            double d = dArray[n];
            if (d == 0.0) {
                dArray[n] = this.getArea(gridVertex, n);
            }
            ++n;
        }
        return dArray;
    }

    private double getArea(GridVertex gridVertex, int n) {
        GridIntersection gridIntersection = gridVertex.horz.higher;
        switch (n) {
            case 1: {
                gridIntersection = gridVertex.vert.higher;
                break;
            }
            case 2: {
                gridIntersection = gridVertex.horz.lower;
                break;
            }
            case 3: {
                gridIntersection = gridVertex.vert.lower;
            }
        }
        return this.getArea((Intersection)gridVertex, gridIntersection);
    }

    private double getArea(Corner corner) {
        double d = this.getArea(corner, corner.end);
        if (d == 0.0) {
            this.getArea(corner.end, corner);
        }
        return d > 0.0 ? d : this.getArea(corner.end, corner);
    }

    private double getArea(Intersection intersection, Intersection intersection2) {
        this.polygon[0] = intersection;
        Intersection intersection3 = intersection;
        int n = 1;
        while (intersection2 != null && intersection2 != intersection) {
            this.polygon[n++] = intersection2;
            Intersection intersection4 = this.getNext(intersection2, intersection3);
            intersection3 = intersection2;
            intersection2 = intersection4;
        }
        double d = 0.0;
        int n2 = (int)this.polygon[0].x;
        int n3 = (int)this.polygon[0].y;
        boolean bl = true;
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4 - 1 < 0 ? n - 1 : n4 - 1;
            int n6 = n4 + 1 > n - 1 ? 0 : n4 + 1;
            d += this.polygon[n4].x * (this.polygon[n6].y - this.polygon[n5].y);
            if (this.polygon[n4] instanceof Corner) {
                Corner corner = (Corner)this.polygon[n4];
                n2 = (int)corner.x;
                n3 = (int)corner.y;
                bl = false;
            }
            if (bl) {
                n2 = Math.min(n2, (int)this.polygon[n4].x);
                n3 = Math.min(n3, (int)this.polygon[n4].y);
            }
            ++n4;
        }
        this.polyLoc.setLocation(n2, n3);
        return d /= 2.0;
    }

    private double[][] getHorizontalProfileData(TrackerPanel trackerPanel) {
        if (trackerPanel.getVideo() == null) {
            return null;
        }
        int n = this.line.getSpread();
        int n2 = Math.min((int)this.lineEnd0.getX(), (int)this.lineEnd1.getX());
        n2 = Math.max(n2, 0);
        int n3 = Math.max((int)this.lineEnd0.getX(), (int)this.lineEnd1.getX());
        int n4 = (n3 = Math.min(n3, (int)trackerPanel.getImageWidth())) - n2;
        if (n4 <= 0) {
            return null;
        }
        int n5 = 1 + 2 * n;
        int[] nArray = new int[n4 * n5];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n5];
        double[][] dArray = new double[10][n4];
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        BufferedImage bufferedImage = trackerPanel.getVideo().getImage();
        if (bufferedImage != null && bufferedImage.getType() == 1) {
            try {
                int n6 = (int)this.lineEnd0.getY();
                int n7 = n6 - n;
                int n8 = trackerPanel.getFrameNumber();
                AffineTransform affineTransform = trackerPanel.getCoords().getToWorldTransform(n8);
                bufferedImage.getRaster().getDataElements(n2, n7, n4, n5, nArray);
                int n9 = 0;
                while (n9 < n4) {
                    int n10 = 0;
                    while (n10 < n5) {
                        if (n10 == n) {
                            ((Point2D)double_).setLocation((double)(n2 + n9) + 0.5, (double)n6 + 0.5);
                            affineTransform.transform(double_, double_2);
                            dArray[0][n9] = ((Point2D)double_2).getX();
                            dArray[1][n9] = ((Point2D)double_2).getY();
                        }
                        int n11 = nArray[n9 + n10 * n4];
                        nArray2[n10] = n11 >> 16 & 0xFF;
                        nArray3[n10] = n11 >> 8 & 0xFF;
                        nArray4[n10] = n11 & 0xFF;
                        ++n10;
                    }
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    int n12 = 0;
                    while (n12 < nArray2.length) {
                        d += (double)nArray2[n12];
                        d2 += (double)nArray3[n12];
                        d3 += (double)nArray4[n12];
                        d4 += 1.0;
                        ++n12;
                    }
                    dArray[2][n9] = d /= d4;
                    dArray[3][n9] = d2 /= d4;
                    dArray[4][n9] = d3 /= d4;
                    dArray[5][n9] = RGBRegion.getLuma(d, d2, d3);
                    dArray[6][n9] = d4;
                    ++n9;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        return dArray;
    }

    public static int getLength() {
        return 3;
    }

    class Corner
    extends Intersection {
        Intersection end;

        Corner() {
            super(0.0, 0.0);
        }
    }

    class GridIntersection
    extends Intersection {
        boolean isVertical;
        GridSegment segment;

        GridIntersection(double d, double d2, boolean bl) {
            super(d, d2);
            this.isVertical = bl;
        }
    }

    class GridSegment
    implements Comparable<GridSegment> {
        double value;
        GridIntersection lower;
        GridIntersection higher;
        GridVertex vertex;

        GridSegment(GridIntersection gridIntersection, GridIntersection gridIntersection2) {
            boolean bl = gridIntersection.isVertical;
            if (bl) {
                this.value = gridIntersection.x;
                boolean bl2 = gridIntersection.y < gridIntersection2.y;
                this.lower = bl2 ? gridIntersection : gridIntersection2;
                this.higher = bl2 ? gridIntersection2 : gridIntersection;
            } else {
                this.value = gridIntersection.y;
                boolean bl3 = gridIntersection.x < gridIntersection2.x;
                this.lower = bl3 ? gridIntersection : gridIntersection2;
                this.higher = bl3 ? gridIntersection2 : gridIntersection;
            }
            this.lower.segment = this;
            this.higher.segment = this;
        }

        @Override
        public int compareTo(GridSegment gridSegment) {
            if (this.lower.isVertical) {
                return (int)(this.value - gridSegment.value);
            }
            double d = this.lower.x - gridSegment.lower.x;
            return d == 0.0 ? 0 : (d > 0.0 ? 1 : -1);
        }
    }

    class GridVertex
    extends GridIntersection {
        GridSegment vert;
        GridSegment horz;

        GridVertex(GridSegment gridSegment, GridSegment gridSegment2) {
            super(gridSegment.value, gridSegment2.value, true);
            this.setVerticalSegment(gridSegment);
            this.setHorizontalSegment(gridSegment2);
        }

        void setVerticalSegment(GridSegment gridSegment) {
            this.vert = gridSegment;
            this.vert.vertex = this;
        }

        void setHorizontalSegment(GridSegment gridSegment) {
            this.horz = gridSegment;
            this.horz.vertex = this;
        }
    }

    class Handle
    extends Step.Handle {
        public Handle(double d, double d2) {
            super(LineProfileStep.this, d, d2);
            this.setTrackEditTrigger(true);
        }

        @Override
        public void setXY(double d, double d2) {
            if (LineProfileStep.this.track.isLocked()) {
                return;
            }
            if (!LineProfileStep.this.line.isFixed()) {
                LineProfileStep.this.line.keyFrames.add(LineProfileStep.this.n);
            }
            double d3 = d - this.getX();
            double d4 = d2 - this.getY();
            if (LineProfileStep.this.line.isFixed()) {
                LineProfileStep lineProfileStep = (LineProfileStep)LineProfileStep.this.line.steps.getStep(0);
                lineProfileStep.lineEnd0.setLocation(LineProfileStep.this.lineEnd0.getX() + d3, LineProfileStep.this.lineEnd0.getY() + d4);
                lineProfileStep.lineEnd1.setLocation(LineProfileStep.this.lineEnd1.getX() + d3, LineProfileStep.this.lineEnd1.getY() + d4);
                lineProfileStep.handle.setLocation(d, d2);
                lineProfileStep.erase();
                LineProfileStep.this.line.refreshStep(LineProfileStep.this);
            } else {
                LineProfileStep.this.lineEnd0.setLocation(LineProfileStep.this.lineEnd0.getX() + d3, LineProfileStep.this.lineEnd0.getY() + d4);
                LineProfileStep.this.lineEnd1.setLocation(LineProfileStep.this.lineEnd1.getX() + d3, LineProfileStep.this.lineEnd1.getY() + d4);
                this.setLocation(d, d2);
                LineProfileStep.this.line.keyFrames.add(LineProfileStep.this.n);
            }
            LineProfileStep.this.repaint();
            LineProfileStep.this.track.support.firePropertyChange("step", null, new Integer(LineProfileStep.this.n));
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return LineProfileStep.this.n;
        }

        @Override
        public void setPositionOnLine(int n, int n2, TrackerPanel trackerPanel) {
            this.setPositionOnLine(n, n2, trackerPanel, LineProfileStep.this.lineEnd0, LineProfileStep.this.lineEnd1);
            LineProfileStep.this.repaint();
        }
    }

    class Intersection
    extends Point2D.Double
    implements Comparable<Intersection> {
        Intersection lowerX;
        Intersection higherX;

        Intersection(double d, double d2) {
            super(d, d2);
        }

        @Override
        public int compareTo(Intersection intersection) {
            double d = this.x - intersection.x;
            if (d == 0.0) {
                double d2 = this.y - intersection.y;
                if (LineProfileStep.this.cos / LineProfileStep.this.sin < 0.0) {
                    return d2 == 0.0 ? 0 : (d2 > 0.0 ? 1 : -1);
                }
                return d2 == 0.0 ? 0 : (d2 < 0.0 ? 1 : -1);
            }
            return d > 0.0 ? 1 : -1;
        }
    }

    class LineEnd
    extends TPoint {
        public LineEnd(double d, double d2) {
            super(d, d2);
            this.setTrackEditTrigger(true);
        }

        @Override
        public void setXY(double d, double d2) {
            if (LineProfileStep.this.track.isLocked()) {
                return;
            }
            if (LineProfileStep.this.track.trackerPanel == null) {
                super.setXY(d, d2);
                return;
            }
            double d3 = d - this.getX();
            double d4 = d2 - this.getY();
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            double d6 = -LineProfileStep.this.track.trackerPanel.getCoords().getAngle(LineProfileStep.this.n);
            LineProfile lineProfile = (LineProfile)LineProfileStep.this.getTrack();
            if (lineProfile.isHorizontal) {
                d6 = 0.0;
            }
            double d7 = Math.atan2(d4, d3);
            double d8 = d6 - d7;
            double d9 = d5 * Math.cos(d8);
            d3 = d9 * Math.cos(d6);
            d4 = d9 * Math.sin(d6);
            if (LineProfileStep.this.line.isFixed()) {
                LineProfileStep lineProfileStep = (LineProfileStep)LineProfileStep.this.line.steps.getStep(0);
                TPoint tPoint = this == LineProfileStep.this.lineEnd0 ? lineProfileStep.lineEnd0 : lineProfileStep.lineEnd1;
                tPoint.setLocation(this.getX() + d3, this.getY() + d4);
                lineProfileStep.erase();
                LineProfileStep.this.line.refreshStep(LineProfileStep.this);
            } else {
                this.setLocation(this.getX() + d3, this.getY() + d4);
                LineProfileStep.this.line.keyFrames.add(LineProfileStep.this.n);
            }
            LineProfileStep.this.repaint();
            LineProfileStep.this.track.support.firePropertyChange("step", null, new Integer(LineProfileStep.this.n));
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return LineProfileStep.this.n;
        }
    }
}

