/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.LineProfileStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.tools.FontSizer;

public class LineProfile
extends TTrack {
    public static final int MAX_SPREAD = 100;
    protected boolean fixedLine = true;
    protected JCheckBoxMenuItem fixedLineItem;
    protected JMenu orientationMenu;
    protected JMenuItem horizOrientationItem;
    protected JMenuItem xaxisOrientationItem;
    protected int spread = 0;
    protected JLabel spreadLabel;
    protected IntegerField spreadField;
    protected boolean isHorizontal = true;
    protected boolean loading;

    public LineProfile() {
        this.defaultColors = new Color[]{Color.magenta};
        this.setName(TrackerRes.getString("LineProfile.New.Name"));
        this.setProperty("highlights", "false");
        this.setProperty("xVarPlot0", "x");
        this.setProperty("yVarPlot0", "luma");
        this.setProperty("pointsPlot0", "false");
        this.setProperty("yMinPlot0", new Double(0.0));
        this.setProperty("yMaxPlot0", new Double(255.0));
        this.setProperty("tableVar0", "0");
        this.setProperty("tableVar1", "1");
        this.setProperty("tableVar2", "5");
        this.setFootprints(new Footprint[]{LineFootprint.getFootprint("Footprint.Outline"), LineFootprint.getFootprint("Footprint.BoldOutline")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("LineProfile.Unmarked.Hint");
        this.spreadLabel = new JLabel();
        this.spreadField = new IntegerField(3);
        this.spreadField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LineProfile.this.setSpread(LineProfile.this.spreadField.getIntValue());
                LineProfile.this.spreadField.setIntValue(LineProfile.this.getSpread());
                LineProfile.this.spreadField.selectAll();
                LineProfile.this.spreadField.requestFocusInWindow();
                LineProfile.this.firePropertyChange("data", null, LineProfile.this);
            }
        });
        this.spreadField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                LineProfile.this.spreadField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                LineProfile.this.setSpread(LineProfile.this.spreadField.getIntValue());
                LineProfile.this.spreadField.setIntValue(LineProfile.this.getSpread());
                LineProfile.this.firePropertyChange("data", null, LineProfile.this);
            }
        });
        this.spreadField.setBorder(this.fieldBorder);
        this.fixedLineItem = new JCheckBoxMenuItem(TrackerRes.getString("LineProfile.MenuItem.Fixed"));
        this.fixedLineItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                LineProfile.this.setFixed(LineProfile.this.fixedLineItem.isSelected());
            }
        });
        this.orientationMenu = new JMenu(TrackerRes.getString("LineProfile.Menu.Orientation"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.horizOrientationItem = new JRadioButtonMenuItem(TrackerRes.getString("LineProfile.MenuItem.Horizontal"));
        this.horizOrientationItem.setSelected(true);
        this.horizOrientationItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (LineProfile.this.trackerPanel == null) {
                    return;
                }
                XMLControlElement xMLControlElement = new XMLControlElement(LineProfile.this);
                LineProfile.this.isHorizontal = LineProfile.this.horizOrientationItem.isSelected();
                if (!LineProfile.this.steps.isEmpty()) {
                    int n = LineProfile.this.trackerPanel.getFrameNumber();
                    LineProfileStep lineProfileStep = (LineProfileStep)LineProfile.this.steps.getStep(n);
                    LineProfile.this.refreshStep(lineProfileStep);
                    LineProfile.this.trackerPanel.repaint();
                    if (!LineProfile.this.loading) {
                        Undo.postTrackEdit(LineProfile.this, xMLControlElement);
                    }
                }
                LineProfile.this.trackerPanel.getTFrame().getToolBar(LineProfile.this.trackerPanel).refresh(false);
                LineProfile.this.dataValid = false;
                LineProfile.this.support.firePropertyChange("data", null, null);
            }
        });
        this.orientationMenu.add(this.horizOrientationItem);
        buttonGroup.add(this.horizOrientationItem);
        this.xaxisOrientationItem = new JRadioButtonMenuItem(TrackerRes.getString("LineProfile.MenuItem.XAxis"));
        this.orientationMenu.add(this.xaxisOrientationItem);
        buttonGroup.add(this.xaxisOrientationItem);
    }

    public void setFixed(boolean bl) {
        if (bl == this.fixedLine) {
            return;
        }
        if (this.steps.isEmpty()) {
            this.fixedLine = bl;
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        this.fixedLine = bl;
        if (this.trackerPanel != null) {
            this.trackerPanel.changed = true;
            int n = this.trackerPanel.getFrameNumber();
            Step step = this.getStep(n);
            if (step != null) {
                this.steps = new TTrack.StepArray(this, this.getStep(n));
                this.trackerPanel.repaint();
            }
        }
        if (bl) {
            this.keyFrames.clear();
            this.keyFrames.add(0);
        }
        if (!this.loading) {
            Undo.postTrackEdit(this, xMLControlElement);
        }
        this.repaint();
    }

    public boolean isFixed() {
        return this.fixedLine;
    }

    public void setSpread(int n) {
        if (this.isLocked() || this.spread == n) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        n = Math.max(n, 0);
        this.spread = Math.min(n, 100);
        if (!this.loading) {
            Undo.postTrackEdit(this, xMLControlElement);
        }
        this.repaint();
        this.dataValid = false;
    }

    public int getSpread() {
        return this.spread;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        super.draw(drawingPanel, graphics);
    }

    @Override
    public void setTrailVisible(boolean bl) {
    }

    @Override
    public Step createStep(int n, double d, double d2) {
        return this.createStep(n, d, d2, d, d2);
    }

    public Step createStep(int n, double d, double d2, double d3, double d4) {
        if (this.isLocked()) {
            return null;
        }
        int n2 = this.isFixed() ? 0 : n;
        LineProfileStep lineProfileStep = (LineProfileStep)this.steps.getStep(n2);
        if (lineProfileStep == null) {
            this.keyFrames.add(0);
            double d5 = d3;
            double d6 = d4;
            if (d == d3 && d2 == d4) {
                if (this.trackerPanel != null) {
                    double d7 = -this.trackerPanel.getCoords().getAngle(n);
                    if (this.isHorizontal) {
                        d7 = 0.0;
                    }
                    d5 = d + 50.0 * Math.cos(d7);
                    d6 = d2 + 50.0 * Math.sin(d7);
                } else {
                    d5 = d + 50.0;
                }
            }
            lineProfileStep = new LineProfileStep(this, 0, d, d2, d5, d6);
            lineProfileStep.setFootprint(this.getFootprint());
            this.steps = new TTrack.StepArray(this, lineProfileStep);
            if (d == d3 && d2 == d4) {
                lineProfileStep = (LineProfileStep)this.getStep(n2);
                lineProfileStep.getLineEnd1().setLocation(d3, d4);
                if (this.trackerPanel != null) {
                    lineProfileStep = (LineProfileStep)this.getStep(n);
                    lineProfileStep.getLineEnd0().setTrackEditTrigger(false);
                    this.trackerPanel.setSelectedPoint(lineProfileStep.getDefaultPoint());
                }
            }
        } else {
            this.keyFrames.add(n2);
            lineProfileStep.getLineEnd0().setLocation(d, d2);
            lineProfileStep.getLineEnd1().setLocation(d3, d4);
        }
        return this.getStep(n);
    }

    @Override
    public Step deleteStep(int n) {
        return null;
    }

    @Override
    public Step getStep(int n) {
        LineProfileStep lineProfileStep = (LineProfileStep)this.steps.getStep(n);
        this.refreshStep(lineProfileStep);
        return lineProfileStep;
    }

    @Override
    public boolean isStepComplete(int n) {
        return this.getStep(n) != null;
    }

    @Override
    public int getStepLength() {
        return LineProfileStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 2;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof TrackerPanel) || !this.isVisible() || this.isLocked()) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Interactive interactive = null;
        int n3 = trackerPanel.getFrameNumber();
        Step step = this.getStep(n3);
        if (step != null && trackerPanel.getPlayer().getVideoClip().includesFrame(n3)) {
            interactive = step.findInteractive(trackerPanel, n, n2);
        }
        if (interactive == null) {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = step == null ? TrackerRes.getString("LineProfile.Unmarked.Hint") : TrackerRes.getString("LineProfile.Hint");
            if (trackerPanel.getVideo() == null) {
                this.hint = String.valueOf(this.hint) + ", " + TrackerRes.getString("TTrack.ImportVideo.Hint");
            }
            return null;
        }
        if (interactive instanceof LineProfileStep.LineEnd) {
            this.partName = TrackerRes.getString("LineProfile.End.Name");
            this.hint = TrackerRes.getString("LineProfile.End.Hint");
        } else if (interactive instanceof LineProfileStep.Handle) {
            this.partName = TrackerRes.getString("LineProfile.Handle.Name");
            this.hint = TrackerRes.getString("LineProfile.Handle.Hint");
        }
        return interactive;
    }

    @Override
    protected void refreshData(DatasetManager datasetManager, TrackerPanel trackerPanel) {
        double[][] dArray;
        LineProfileStep lineProfileStep;
        int n;
        int n2 = 0;
        Dataset dataset = datasetManager.getDataset(n2++);
        Dataset dataset2 = datasetManager.getDataset(n2++);
        Dataset dataset3 = datasetManager.getDataset(n2++);
        Dataset dataset4 = datasetManager.getDataset(n2++);
        Dataset dataset5 = datasetManager.getDataset(n2++);
        Dataset dataset6 = datasetManager.getDataset(n2++);
        Dataset dataset7 = datasetManager.getDataset(n2++);
        String string = "n";
        if (!dataset.getColumnName(0).equals(string)) {
            dataset.setXYColumnNames(string, "x");
            dataset2.setXYColumnNames(string, "y");
            dataset3.setXYColumnNames(string, "R");
            dataset4.setXYColumnNames(string, "G");
            dataset5.setXYColumnNames(string, "B");
            dataset6.setXYColumnNames(string, "luma");
            dataset7.setXYColumnNames(string, "pixels");
        } else {
            n = 0;
            while (n < n2) {
                datasetManager.getDataset(n).clear();
                ++n;
            }
        }
        this.dataDescriptions = new String[n2 + 1];
        n = 0;
        while (n < this.dataDescriptions.length) {
            this.dataDescriptions[n] = TrackerRes.getString("LineProfile.Data.Description." + n);
            ++n;
        }
        if (trackerPanel.getVideo() != null && trackerPanel.getVideo().isVisible() && (lineProfileStep = (LineProfileStep)this.getStep(n = trackerPanel.getPlayer().getFrameNumber())) != null && (dArray = lineProfileStep.getProfileData(trackerPanel)) != null) {
            int n3 = 0;
            while (n3 < dArray[0].length) {
                dataset.append(n3, dArray[0][n3]);
                dataset2.append(n3, dArray[1][n3]);
                dataset3.append(n3, dArray[2][n3]);
                dataset4.append(n3, dArray[3][n3]);
                dataset5.append(n3, dArray[4][n3]);
                dataset6.append(n3, dArray[5][n3]);
                dataset7.append(n3, dArray[6][n3]);
                ++n3;
            }
        }
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        JMenu jMenu = super.getMenu(trackerPanel);
        this.fixedLineItem.setText(TrackerRes.getString("LineProfile.MenuItem.Fixed"));
        this.fixedLineItem.setSelected(this.isFixed());
        jMenu.remove(this.deleteTrackItem);
        if (jMenu.getItemCount() > 0 && jMenu.getItem(jMenu.getItemCount() - 1) != null) {
            jMenu.addSeparator();
        }
        jMenu.add(this.orientationMenu);
        jMenu.addSeparator();
        jMenu.add(this.fixedLineItem);
        if (trackerPanel.isEnabled("track.delete")) {
            if (jMenu.getItemCount() > 0 && jMenu.getItem(jMenu.getItemCount() - 1) != null) {
                jMenu.addSeparator();
            }
            jMenu.add(this.deleteTrackItem);
        }
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        this.spreadLabel.setText(TrackerRes.getString("LineProfile.Label.Spread"));
        Border border = BorderFactory.createEmptyBorder(0, 4, 0, 2);
        this.spreadLabel.setBorder(border);
        arrayList.add(this.spreadLabel);
        this.spreadField.setIntValue(this.getSpread());
        this.spreadField.setEnabled(!this.isLocked());
        arrayList.add(this.spreadField);
        return arrayList;
    }

    @Override
    public void setFontLevel(int n) {
        super.setFontLevel(n);
        Object[] objectArray = new Object[]{this.spreadLabel};
        FontSizer.setFonts(objectArray, n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.trackerPanel != null) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("stepnumber")) {
                this.dataValid = false;
                this.support.firePropertyChange(propertyChangeEvent);
            } else if (string.equals("image")) {
                this.dataValid = false;
                this.support.firePropertyChange(propertyChangeEvent);
            } else if (string.equals("transform") && !this.steps.isEmpty()) {
                int n = this.trackerPanel.getFrameNumber();
                LineProfileStep lineProfileStep = (LineProfileStep)this.steps.getStep(n);
                this.refreshStep(lineProfileStep);
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    @Override
    public String toString() {
        return TrackerRes.getString("LineProfile.Name");
    }

    protected void refreshStep(LineProfileStep lineProfileStep) {
        boolean bl;
        if (lineProfileStep == null) {
            return;
        }
        int n = 0;
        Iterator iterator = this.keyFrames.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n2 > lineProfileStep.n) continue;
            n = n2;
        }
        LineProfileStep lineProfileStep2 = (LineProfileStep)this.steps.getStep(n);
        boolean bl2 = bl = lineProfileStep2.getLineEnd0().getX() != lineProfileStep.getLineEnd0().getX() || lineProfileStep2.getLineEnd0().getY() != lineProfileStep.getLineEnd0().getY() || lineProfileStep2.getLineEnd1().getX() != lineProfileStep.getLineEnd1().getX() || lineProfileStep2.getLineEnd1().getY() != lineProfileStep.getLineEnd1().getY();
        if (bl) {
            lineProfileStep.getLineEnd0().setLocation(lineProfileStep2.getLineEnd0());
            lineProfileStep.getLineEnd1().setLocation(lineProfileStep2.getLineEnd1());
            lineProfileStep.getHandle().setLocation(lineProfileStep2.getHandle());
            lineProfileStep.erase();
        }
        lineProfileStep.getLineEnd0().setTrackEditTrigger(true);
        lineProfileStep.rotate();
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    private static class FrameData {
        double[] data = new double[4];

        FrameData() {
        }

        FrameData(LineProfileStep lineProfileStep) {
            this.data[0] = lineProfileStep.getLineEnd0().x;
            this.data[1] = lineProfileStep.getLineEnd0().y;
            this.data[2] = lineProfileStep.getLineEnd1().x;
            this.data[3] = lineProfileStep.getLineEnd1().y;
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            xMLControl.setValue("x1", frameData.data[0]);
            xMLControl.setValue("y1", frameData.data[1]);
            xMLControl.setValue("x2", frameData.data[2]);
            xMLControl.setValue("y2", frameData.data[3]);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new FrameData();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            if (xMLControl.getPropertyNames().contains("x1")) {
                frameData.data[0] = xMLControl.getDouble("x1");
                frameData.data[1] = xMLControl.getDouble("y1");
                frameData.data[2] = xMLControl.getDouble("x2");
                frameData.data[3] = xMLControl.getDouble("y2");
            }
            return object;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            LineProfile lineProfile = (LineProfile)object;
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            xMLControl.setValue("spread", lineProfile.getSpread());
            xMLControl.setValue("fixed", lineProfile.isFixed());
            Step[] stepArray = lineProfile.getSteps();
            int n = stepArray.length;
            if (lineProfile.isFixed()) {
                n = 1;
            }
            FrameData[] frameDataArray = new FrameData[n];
            int n2 = 0;
            while (n2 < n) {
                if (stepArray[n2] != null && lineProfile.keyFrames.contains(n2)) {
                    frameDataArray[n2] = new FrameData((LineProfileStep)stepArray[n2]);
                }
                ++n2;
            }
            xMLControl.setValue("framedata", frameDataArray);
            xMLControl.setValue("horizontal", lineProfile.isHorizontal);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            LineProfile lineProfile = new LineProfile();
            return lineProfile;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            LineProfile lineProfile = (LineProfile)object;
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            boolean bl = lineProfile.isLocked();
            lineProfile.setLocked(false);
            lineProfile.loading = true;
            if (xMLControl.getPropertyNames().contains("horizontal")) {
                lineProfile.isHorizontal = xMLControl.getBoolean("horizontal");
            } else {
                boolean bl2 = lineProfile.isHorizontal = !xMLControl.getBoolean("rotates");
            }
            if (lineProfile.isHorizontal) {
                lineProfile.horizOrientationItem.setSelected(true);
            } else {
                lineProfile.xaxisOrientationItem.setSelected(true);
            }
            int n = xMLControl.getInt("spread");
            if (n != Integer.MIN_VALUE) {
                lineProfile.setSpread(n);
            }
            if (xMLControl.getPropertyNames().contains("fixed")) {
                lineProfile.fixedLine = xMLControl.getBoolean("fixed");
            }
            lineProfile.keyFrames.clear();
            FrameData[] frameDataArray = (FrameData[])xMLControl.getObject("framedata");
            if (frameDataArray != null) {
                int n2 = 0;
                while (n2 < frameDataArray.length) {
                    if (frameDataArray[n2] != null) {
                        lineProfile.createStep(n2, frameDataArray[n2].data[0], frameDataArray[n2].data[1], frameDataArray[n2].data[2], frameDataArray[n2].data[3]);
                    }
                    ++n2;
                }
            }
            lineProfile.spreadField.setIntValue(lineProfile.getSpread());
            lineProfile.setLocked(bl);
            lineProfile.loading = false;
            lineProfile.repaint();
            return object;
        }
    }
}

