/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.ArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.DoubleArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.DoubleCrosshairFootprint;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.OutlineFootprint;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class LineFootprint
implements Footprint,
Cloneable {
    protected String name;
    protected Shape highlight;
    protected AffineTransform transform = new AffineTransform();
    protected BasicStroke baseStroke = new BasicStroke();
    protected BasicStroke stroke;
    protected Color color = Color.black;
    protected GeneralPath path = new GeneralPath();
    protected Line2D line = new Line2D.Double();
    protected Shape[] hitShapes = new Shape[3];
    private static Collection<LineFootprint> footprints = new HashSet<LineFootprint>();
    public static final float[] DASHED_LINE = new float[]{10.0f, 4.0f};
    public static final float[] DOTTED_LINE = new float[]{2.0f, 1.0f};
    protected static final Shape HIGHLIGHT;
    private static final LineFootprint LINE;
    private static final LineFootprint BOLD_LINE;
    private static final LineFootprint OUTLINE;
    private static final LineFootprint BOLD_OUTLINE;
    private static final LineFootprint DOUBLE_ARROW;
    private static final LineFootprint BOLD_DOUBLE_ARROW;
    private static final ArrowFootprint ARROW;
    private static final ArrowFootprint BOLD_ARROW;
    private static final ArrowFootprint BIG_ARROW;
    private static final ArrowFootprint DASH_ARROW;
    private static final ArrowFootprint BOLD_DASH_ARROW;
    private static final ArrowFootprint BIG_DASH_ARROW;
    private static final DoubleCrosshairFootprint DOUBLE_TARGET;
    private static final DoubleCrosshairFootprint BOLD_DOUBLE_TARGET;

    static {
        Ellipse2D.Double double_ = new Ellipse2D.Double();
        ((RectangularShape)double_).setFrame(-3.0, -3.0, 6.0, 6.0);
        BasicStroke basicStroke = new BasicStroke(2.0f);
        HIGHLIGHT = basicStroke.createStrokedShape(double_);
        LINE = new LineFootprint("Footprint.Line");
        footprints.add(LINE);
        BOLD_LINE = new LineFootprint("Footprint.BoldLine");
        BOLD_LINE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_LINE);
        OUTLINE = new OutlineFootprint("Footprint.Outline");
        footprints.add(OUTLINE);
        BOLD_OUTLINE = new OutlineFootprint("Footprint.BoldOutline");
        BOLD_OUTLINE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_OUTLINE);
        DOUBLE_ARROW = new DoubleArrowFootprint("Footprint.DoubleArrow");
        footprints.add(DOUBLE_ARROW);
        BOLD_DOUBLE_ARROW = new DoubleArrowFootprint("Footprint.BoldDoubleArrow");
        BOLD_DOUBLE_ARROW.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_DOUBLE_ARROW);
        ARROW = new ArrowFootprint("Footprint.Arrow");
        footprints.add(ARROW);
        BOLD_ARROW = new ArrowFootprint("Footprint.BoldArrow");
        BOLD_ARROW.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_ARROW);
        BIG_ARROW = new ArrowFootprint("Footprint.BigArrow");
        BIG_ARROW.setStroke(new BasicStroke(4.0f));
        BIG_ARROW.setTipLength(32);
        footprints.add(BIG_ARROW);
        DASH_ARROW = new ArrowFootprint("Footprint.DashArrow");
        DASH_ARROW.setDashArray(DASHED_LINE);
        footprints.add(DASH_ARROW);
        BOLD_DASH_ARROW = new ArrowFootprint("Footprint.BoldDashArrow");
        BOLD_DASH_ARROW.setStroke(new BasicStroke(2.0f));
        BOLD_DASH_ARROW.setDashArray(DASHED_LINE);
        footprints.add(BOLD_DASH_ARROW);
        BIG_DASH_ARROW = new ArrowFootprint("Footprint.BigDashArrow");
        BIG_DASH_ARROW.setStroke(new BasicStroke(4.0f));
        BIG_DASH_ARROW.setDashArray(DASHED_LINE);
        BIG_DASH_ARROW.setTipLength(32);
        footprints.add(BIG_DASH_ARROW);
        DOUBLE_TARGET = new DoubleCrosshairFootprint("Footprint.DoubleTarget");
        footprints.add(DOUBLE_TARGET);
        BOLD_DOUBLE_TARGET = new DoubleCrosshairFootprint("Footprint.BoldDoubleTarget");
        BOLD_DOUBLE_TARGET.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_DOUBLE_TARGET);
    }

    public LineFootprint(String string) {
        this.name = string;
    }

    public static Footprint getFootprint(String string) {
        for (LineFootprint lineFootprint : footprints) {
            if (string != lineFootprint.getName()) continue;
            try {
                return (LineFootprint)lineFootprint.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return TrackerRes.getString(this.name);
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public Icon getIcon(int n, int n2) {
        int n3 = FontSizer.getIntegerFactor();
        Point[] pointArray = new Point[]{new Point(), new Point((n *= n3) - 2, 2 - (n2 *= n3))};
        Shape shape = this.getShape(pointArray);
        ShapeIcon shapeIcon = new ShapeIcon(shape, n, n2);
        shapeIcon.setColor(this.color);
        return shapeIcon;
    }

    @Override
    public Mark getMark(Point[] pointArray) {
        final Shape shape = this.getShape(pointArray);
        final Shape shape2 = this.highlight;
        final Color color = this.color;
        return new Mark(){

            @Override
            public void draw(Graphics2D graphics2D, boolean bl) {
                Color color2 = graphics2D.getColor();
                graphics2D.setColor(color);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.fill(shape);
                if (bl && shape2 != null) {
                    graphics2D.fill(shape2);
                }
                graphics2D.setColor(color2);
            }

            @Override
            public Rectangle getBounds(boolean bl) {
                return shape.getBounds();
            }
        };
    }

    @Override
    public Shape[] getHitShapes() {
        return this.hitShapes;
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        if (basicStroke == null) {
            return;
        }
        this.baseStroke = new BasicStroke(basicStroke.getLineWidth(), 0, 0, 8.0f, basicStroke.getDashArray(), basicStroke.getDashPhase());
    }

    @Override
    public BasicStroke getStroke() {
        return this.baseStroke;
    }

    public void setDashArray(float[] fArray) {
        this.setStroke(new BasicStroke(this.baseStroke.getLineWidth(), 0, 0, 8.0f, fArray, this.baseStroke.getDashPhase()));
    }

    public void setLineWidth(double d) {
        this.baseStroke = new BasicStroke((float)d, 0, 0, 8.0f, this.baseStroke.getDashArray(), this.baseStroke.getDashPhase());
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Shape getShape(Point[] pointArray) {
        Point point = pointArray[0];
        Point point2 = pointArray[1];
        this.line.setLine(point, point2);
        this.hitShapes[0] = new Rectangle(point.x - 1, point.y - 1, 2, 2);
        this.hitShapes[1] = new Rectangle(point2.x - 1, point2.y - 1, 2, 2);
        this.hitShapes[2] = (Line2D.Double)this.line.clone();
        int n = FontSizer.getIntegerFactor();
        if (this.stroke == null || this.stroke.getLineWidth() != (float)n * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)n * this.baseStroke.getLineWidth());
        }
        return this.stroke.createStrokedShape(this.line);
    }
}

