/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.ExportVideoDialog;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.ThumbnailDialog;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.JarTool;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ExportZipDialog
extends JDialog {
    protected static final String DEFAULT_VIDEO_EXTENSION = "jpg";
    protected static ExportZipDialog zipExporter;
    protected static String videoSubdirectory;
    protected static String htmlSubdirectory;
    protected static String imageSubdirectory;
    protected static Color labelColor;
    protected static String preferredExtension;
    protected ExportVideoDialog videoExporter;
    protected TrackerPanel trackerPanel;
    protected AddedFilesDialog addedFilesDialog;
    protected Icon openIcon;
    protected JPanel videoPanel;
    protected JPanel thumbnailPanel;
    protected JPanel centerPanel;
    protected JPanel imagePanel;
    protected Box metadataBox;
    protected TitledBorder videoBorder;
    protected TitledBorder thumbnailBorder;
    protected TitledBorder metadataBorder;
    protected JButton saveButton;
    protected JButton closeButton;
    protected JButton addFilesButton;
    protected JButton thumbnailButton;
    protected JButton loadHTMLButton;
    protected JButton helpButton;
    protected JComboBox formatDropdown;
    protected JLabel formatLabel;
    protected JLabel authorLabel;
    protected JLabel contactLabel;
    protected JLabel descriptionLabel;
    protected JLabel keywordsLabel;
    protected JLabel thumbnailDisplay;
    protected JLabel urlLabel;
    protected JLabel titleLabel;
    protected JLabel htmlLabel;
    protected JCheckBox clipCheckbox;
    protected JCheckBox showThumbnailCheckbox;
    protected ArrayList<JLabel> labels = new ArrayList();
    protected EntryField authorField;
    protected EntryField contactField;
    protected EntryField keywordsField;
    protected EntryField urlField;
    protected EntryField titleField;
    protected EntryField htmlField;
    protected String targetName;
    protected String targetDirectory;
    protected String targetVideo;
    protected String targetExtension;
    protected JTextArea filelistPane;
    protected JTextArea descriptionPane;
    protected VideoListener videoExportListener;
    protected XMLControl control;
    protected boolean addThumbnail = true;
    protected ArrayList<ParticleModel> badModels;
    protected String videoIOPreferredExtension;

    static {
        videoSubdirectory = "videos";
        htmlSubdirectory = "html";
        imageSubdirectory = "images";
        labelColor = new Color(0, 0, 102);
        preferredExtension = DEFAULT_VIDEO_EXTENSION;
    }

    public static ExportZipDialog getDialog(TrackerPanel trackerPanel) {
        boolean bl = false;
        if (zipExporter == null) {
            zipExporter = new ExportZipDialog(trackerPanel);
            bl = true;
        }
        boolean bl2 = bl = bl || ExportZipDialog.zipExporter.trackerPanel != trackerPanel;
        if (bl) {
            ExportZipDialog.zipExporter.trackerPanel = trackerPanel;
            ExportZipDialog.zipExporter.control = new XMLControlElement(trackerPanel);
            ExportZipDialog.zipExporter.videoExporter = ExportVideoDialog.getDialog(trackerPanel);
            ExportZipDialog.zipExporter.addThumbnail = true;
            ExportZipDialog.zipExporter.addedFilesDialog.addedFiles.clear();
            ExportZipDialog.zipExporter.htmlField.setText(ExportZipDialog.zipExporter.htmlField.getDefaultText());
            ExportZipDialog.zipExporter.htmlField.setForeground(ExportZipDialog.zipExporter.htmlField.getEmptyForeground());
            ExportZipDialog.zipExporter.htmlField.setBackground(Color.white);
            ExportZipDialog.zipExporter.clipCheckbox.setSelected(trackerPanel.getVideo() != null);
            ExportZipDialog.zipExporter.titleField.requestFocusInWindow();
        }
        zipExporter.refreshFormatDropdown();
        zipExporter.refreshThumbnail();
        zipExporter.refreshGUI();
        return zipExporter;
    }

    private ExportZipDialog(TrackerPanel trackerPanel) {
        super((Frame)trackerPanel.getTFrame(), false);
        this.trackerPanel = trackerPanel;
        this.videoExporter = ExportVideoDialog.getDialog(trackerPanel);
        this.createGUI();
        this.refreshGUI();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n, n2);
    }

    public void setFontLevel(int n) {
        Serializable serializable2;
        FontSizer.setFonts(this, n);
        int n2 = this.formatDropdown.getSelectedIndex();
        Object[] objectArray = new Object[this.formatDropdown.getItemCount()];
        int n3 = 0;
        while (n3 < objectArray.length) {
            objectArray[n3] = this.formatDropdown.getItemAt(n3);
            ++n3;
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        this.formatDropdown.setModel(defaultComboBoxModel);
        this.formatDropdown.setSelectedItem(n2);
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Font font = this.titleLabel.getFont();
        int n4 = 0;
        for (Serializable serializable2 : this.labels) {
            Rectangle2D rectangle2D = font.getStringBounds(String.valueOf(serializable2.getText()) + " ", fontRenderContext);
            n4 = Math.max(n4, (int)rectangle2D.getWidth() + 1);
        }
        int n5 = this.titleField.getMinimumSize().height;
        serializable2 = new Dimension(n4, n5);
        for (JLabel jLabel : this.labels) {
            jLabel.setPreferredSize((Dimension)serializable2);
        }
        this.pack();
        FontSizer.setFonts(this.addedFilesDialog, n);
        this.addedFilesDialog.pack();
    }

    private void createGUI() {
        String string = "/org/opensourcephysics/cabrillo/tracker/resources/images/open.gif";
        this.openIcon = new ImageIcon(this.getClass().getResource(string));
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color != null) {
            UIManager.put("ComboBox.disabledForeground", color);
        }
        this.videoExportListener = new VideoListener();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        this.videoPanel = new JPanel();
        this.clipCheckbox = new JCheckBox();
        this.clipCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportZipDialog.this.refreshGUI();
            }
        });
        this.formatLabel = new JLabel();
        this.formatLabel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        this.formatDropdown = new JComboBox<Object>(this.videoExporter.getFormats());
        this.videoPanel.add(this.clipCheckbox);
        this.videoPanel.add(this.formatLabel);
        this.videoPanel.add(this.formatDropdown);
        JPanel jPanel2 = new JPanel();
        this.helpButton = new JButton();
        this.helpButton.setForeground(new Color(0, 0, 102));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportZipDialog.this.trackerPanel.getTFrame().showHelp("zip", 0);
            }
        });
        this.addFilesButton = new JButton();
        this.addFilesButton.setForeground(labelColor);
        this.addFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportZipDialog.this.addedFilesDialog.refreshGUI();
                ExportZipDialog.this.addedFilesDialog.refreshFileList();
                ExportZipDialog.this.addedFilesDialog.setVisible(true);
            }
        });
        this.saveButton = new JButton();
        this.saveButton.setForeground(labelColor);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                String string;
                Serializable serializable;
                String string2 = ExportZipDialog.this.descriptionPane.getText().trim();
                if (!"".equals(string2) && "".equals(ExportZipDialog.this.trackerPanel.getDescription())) {
                    ExportZipDialog.this.trackerPanel.setDescription(string2);
                    ExportZipDialog.this.trackerPanel.hideDescriptionWhenLoaded = true;
                }
                if (ExportZipDialog.this.clipCheckbox.isSelected()) {
                    ExportZipDialog.this.badModels = ExportZipDialog.this.getModelsNotInClip();
                    if (!ExportZipDialog.this.badModels.isEmpty()) {
                        serializable = ExportZipDialog.this.trackerPanel.getTFrame();
                        string = "";
                        for (ParticleModel particleModel : ExportZipDialog.this.badModels) {
                            if (!"".equals(string)) {
                                string = String.valueOf(string) + ", ";
                            }
                            string = String.valueOf(string) + "'" + particleModel.getName() + "'";
                        }
                        int n = JOptionPane.showConfirmDialog(serializable, String.valueOf(TrackerRes.getString("ZipResourceDialog.BadModels.Message1")) + "\n" + TrackerRes.getString("ZipResourceDialog.BadModels.Message2") + "\n" + TrackerRes.getString("ZipResourceDialog.BadModels.Message3") + "\n\n" + string + "\n\n" + TrackerRes.getString("ZipResourceDialog.BadModels.Question"), TrackerRes.getString("ZipResourceDialog.BadModels.Title"), 1, 2);
                        if (n != 0) {
                            return;
                        }
                    }
                }
                if ((serializable = ExportZipDialog.this.defineTarget()) == null) {
                    return;
                }
                ExportZipDialog.this.setVisible(false);
                string = ExportZipDialog.this.addThumbnail(serializable);
                ExportZipDialog.this.addHTMLInfo(string, serializable);
                if (ExportZipDialog.this.clipCheckbox.isSelected()) {
                    VideoType videoType = ExportVideoDialog.formats.get(ExportZipDialog.this.formatDropdown.getSelectedItem());
                    ExportZipDialog.this.videoExporter.setFormat(ExportZipDialog.this.formatDropdown.getSelectedItem());
                    ExportZipDialog.this.videoExportListener.setTargetList((ArrayList<File>)serializable);
                    ExportZipDialog.this.videoExportListener.setDialog(ExportZipDialog.this.videoExporter);
                    ExportZipDialog.this.videoExporter.addPropertyChangeListener("video_saved", ExportZipDialog.this.videoExportListener);
                    ExportZipDialog.this.videoExporter.addPropertyChangeListener("video_cancelled", ExportZipDialog.this.videoExportListener);
                    object = videoType.getDefaultExtension();
                    ExportZipDialog.this.targetVideo = ExportZipDialog.this.getVideoTarget((String)object);
                    ExportZipDialog.this.videoIOPreferredExtension = VideoIO.getPreferredExportExtension();
                    ExportZipDialog.this.videoExporter.exportFullSizeVideo(ExportZipDialog.this.targetVideo);
                } else {
                    Video video = ExportZipDialog.this.trackerPanel.getVideo();
                    if (video != null && video.getProperty("absolutePath") != null) {
                        ImageVideo imageVideo;
                        String[] stringArray;
                        int n;
                        object = (String)video.getProperty("absolutePath");
                        String string3 = String.valueOf(ExportZipDialog.this.getTempDirectory()) + videoSubdirectory;
                        ExportZipDialog.this.targetVideo = String.valueOf(string3) + "/" + XML.getName((String)object);
                        new File(string3).mkdirs();
                        if (!ExportZipDialog.this.copyOrExtractFile((String)object, new File(ExportZipDialog.this.targetVideo))) {
                            JOptionPane.showMessageDialog(ExportZipDialog.this, TrackerRes.getString("ZipResourceDialog.Dialog.ExportFailed.Message"), TrackerRes.getString("ZipResourceDialog.Dialog.ExportFailed.Title"), 0);
                            return;
                        }
                        if (video instanceof ImageVideo && (n = ((String)object).indexOf(XML.getName((stringArray = (imageVideo = (ImageVideo)video).getValidPaths())[0]))) > 0) {
                            String string4 = ((String)object).substring(0, n);
                            String[] stringArray2 = stringArray;
                            int n2 = stringArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                File file;
                                String string5 = stringArray2[n3];
                                String string6 = XML.getName(string5);
                                string5 = String.valueOf(string4) + string6;
                                if (!string5.equals(object) && !ExportZipDialog.this.copyOrExtractFile(string5, file = new File(String.valueOf(string3) + "/" + string6))) {
                                    JOptionPane.showMessageDialog(ExportZipDialog.this, TrackerRes.getString("ZipResourceDialog.Dialog.ExportFailed.Message"), TrackerRes.getString("ZipResourceDialog.Dialog.ExportFailed.Title"), 0);
                                    return;
                                }
                                ++n3;
                            }
                        }
                    }
                    ExportZipDialog.this.saveZip(serializable);
                }
            }
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(labelColor);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportZipDialog.this.setVisible(false);
            }
        });
        jPanel2.add(this.helpButton);
        jPanel2.add(this.addFilesButton);
        jPanel2.add(this.saveButton);
        jPanel2.add(this.closeButton);
        Border border = BorderFactory.createEmptyBorder(6, 4, 2, 4);
        this.metadataBox = Box.createVerticalBox();
        this.htmlLabel = new JLabel();
        this.htmlField = new EntryField(30){

            @Override
            protected String getDefaultText() {
                return TrackerRes.getString("ZipResourceDialog.HTMLField.DefaultText");
            }
        };
        this.htmlField.setAlignmentY(0.0f);
        this.htmlField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportZipDialog.this.refreshGUI();
            }
        });
        this.loadHTMLButton = new JButton(this.openIcon);
        this.loadHTMLButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 2));
        this.loadHTMLButton.setAlignmentY(0.0f);
        this.loadHTMLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = TrackerIO.getChooser();
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setDialogTitle(TrackerRes.getString("ZipResourceDialog.FileChooser.OpenHTML.Title"));
                jFileChooser.setFileFilter(LaunchBuilder.getHTMLFilter());
                File[] fileArray = TrackerIO.getChooserFiles("open any");
                jFileChooser.removeChoosableFileFilter(LaunchBuilder.getHTMLFilter());
                if (fileArray == null) {
                    return;
                }
                ExportZipDialog.this.htmlField.setText(XML.getRelativePath(fileArray[0].getPath()));
                ExportZipDialog.this.refreshFieldsFromHTML(fileArray[0]);
                ExportZipDialog.this.refreshGUI();
            }
        });
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(border);
        jToolBar.setFloatable(false);
        jToolBar.setOpaque(false);
        jToolBar.add(this.htmlLabel);
        jToolBar.add(this.htmlField);
        jToolBar.add(this.loadHTMLButton);
        this.titleLabel = new JLabel();
        this.titleField = new EntryField(30);
        this.titleField.setAlignmentY(0.0f);
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setBorder(border);
        jToolBar2.setFloatable(false);
        jToolBar2.setOpaque(false);
        jToolBar2.add(this.titleLabel);
        jToolBar2.add(this.titleField);
        this.descriptionLabel = new JLabel();
        this.descriptionPane = new JTextArea();
        this.descriptionPane.setLineWrap(true);
        this.descriptionPane.setWrapStyleWord(true);
        this.descriptionPane.getDocument().putProperty("parent", this.descriptionPane);
        this.descriptionPane.getDocument().addDocumentListener(EntryField.documentListener);
        this.descriptionPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ExportZipDialog.this.descriptionPane.setBackground(Color.white);
            }
        });
        JToolBar jToolBar3 = new JToolBar();
        jToolBar3.setBorder(border);
        jToolBar3.setFloatable(false);
        jToolBar3.setOpaque(false);
        jToolBar3.add(this.descriptionLabel);
        JScrollPane jScrollPane = new JScrollPane(this.descriptionPane){

            @Override
            public Dimension getPreferredSize() {
                int n = ExportZipDialog.this.titleField.getPreferredSize().width;
                return new Dimension(n, 60);
            }
        };
        jScrollPane.setAlignmentY(0.0f);
        jToolBar3.add(jScrollPane);
        this.authorLabel = new JLabel();
        this.authorField = new EntryField(30);
        this.authorField.setText(this.trackerPanel.author);
        this.authorField.setBackground(Color.white);
        this.authorField.setAlignmentY(0.0f);
        JToolBar jToolBar4 = new JToolBar();
        jToolBar4.setBorder(border);
        jToolBar4.setFloatable(false);
        jToolBar4.setOpaque(false);
        jToolBar4.add(this.authorLabel);
        jToolBar4.add(this.authorField);
        this.contactLabel = new JLabel();
        this.contactField = new EntryField(30);
        this.contactField.setText(this.trackerPanel.contact);
        this.contactField.setBackground(Color.white);
        this.contactField.setAlignmentY(0.0f);
        JToolBar jToolBar5 = new JToolBar();
        jToolBar5.setBorder(border);
        jToolBar5.setFloatable(false);
        jToolBar5.setOpaque(false);
        jToolBar5.add(this.contactLabel);
        jToolBar5.add(this.contactField);
        this.keywordsLabel = new JLabel();
        this.keywordsField = new EntryField(30);
        this.keywordsField.setAlignmentY(0.0f);
        JToolBar jToolBar6 = new JToolBar();
        jToolBar6.setBorder(border);
        jToolBar6.setFloatable(false);
        jToolBar6.setOpaque(false);
        jToolBar6.add(this.keywordsLabel);
        jToolBar6.add(this.keywordsField);
        this.urlLabel = new JLabel();
        this.urlField = new EntryField(30);
        this.urlField.setAlignmentY(0.0f);
        this.urlField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportZipDialog.this.refreshGUI();
            }
        });
        JToolBar jToolBar7 = new JToolBar();
        jToolBar7.setBorder(border);
        jToolBar7.setFloatable(false);
        jToolBar7.setOpaque(false);
        jToolBar7.add(this.urlLabel);
        jToolBar7.add(this.urlField);
        this.metadataBox.add(jToolBar);
        this.metadataBox.add(jToolBar2);
        this.metadataBox.add(jToolBar3);
        this.metadataBox.add(jToolBar4);
        this.metadataBox.add(jToolBar5);
        this.metadataBox.add(jToolBar6);
        this.metadataBox.add(jToolBar7);
        this.thumbnailDisplay = new JLabel();
        Border border2 = BorderFactory.createLineBorder(Color.black);
        Border border3 = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        this.thumbnailDisplay.setBorder(BorderFactory.createCompoundBorder(border3, border2));
        this.thumbnailButton = new JButton();
        this.thumbnailButton.setForeground(labelColor);
        this.thumbnailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThumbnailDialog.getDialog(ExportZipDialog.this.trackerPanel, false).setVisible(true);
            }
        });
        this.showThumbnailCheckbox = new JCheckBox();
        this.showThumbnailCheckbox.setSelected(true);
        this.showThumbnailCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExportZipDialog.this.showThumbnailCheckbox.isSelected()) {
                    ExportZipDialog.this.thumbnailPanel.add((Component)ExportZipDialog.this.imagePanel, "Center");
                } else {
                    ExportZipDialog.this.thumbnailPanel.remove(ExportZipDialog.this.imagePanel);
                }
                ExportZipDialog.this.pack();
                ExportZipDialog.this.repaint();
            }
        });
        this.thumbnailPanel = new JPanel(new BorderLayout());
        this.imagePanel = new JPanel();
        this.imagePanel.add(this.thumbnailDisplay);
        this.thumbnailPanel.add((Component)this.imagePanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.thumbnailButton);
        jPanel3.add(this.showThumbnailCheckbox);
        this.thumbnailPanel.add((Component)jPanel3, "North");
        ThumbnailDialog thumbnailDialog = ThumbnailDialog.getDialog(this.trackerPanel, false);
        thumbnailDialog.addPropertyChangeListener("accepted", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ExportZipDialog.this.refreshThumbnail();
            }
        });
        this.refreshThumbnail();
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.add((Component)this.videoPanel, "North");
        this.centerPanel.add((Component)this.thumbnailPanel, "South");
        jPanel.add((Component)this.metadataBox, "North");
        jPanel.add((Component)this.centerPanel, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.labels.add(this.authorLabel);
        this.labels.add(this.contactLabel);
        this.labels.add(this.descriptionLabel);
        this.labels.add(this.keywordsLabel);
        this.labels.add(this.urlLabel);
        this.labels.add(this.titleLabel);
        this.labels.add(this.htmlLabel);
        this.videoBorder = BorderFactory.createTitledBorder("");
        this.videoPanel.setBorder(this.videoBorder);
        this.videoBorder.setTitleColor(labelColor);
        this.thumbnailBorder = BorderFactory.createTitledBorder("");
        this.thumbnailBorder.setTitleColor(labelColor);
        this.thumbnailPanel.setBorder(this.thumbnailBorder);
        this.metadataBorder = BorderFactory.createTitledBorder("");
        this.metadataBorder.setTitleColor(labelColor);
        this.metadataBox.setBorder(this.metadataBorder);
        this.addedFilesDialog = new AddedFilesDialog();
        this.addedFilesDialog.setLocationRelativeTo(this);
    }

    private void refreshThumbnail() {
        ThumbnailDialog thumbnailDialog = ThumbnailDialog.getDialog(this.trackerPanel, false);
        BufferedImage bufferedImage = thumbnailDialog.getThumbnail();
        this.thumbnailDisplay.setIcon(new ImageIcon(bufferedImage));
        this.pack();
    }

    private void refreshGUI() {
        Serializable serializable22;
        String string = TrackerRes.getString("ZipResourceDialog.Title");
        this.setTitle(string);
        this.metadataBorder.setTitle(TrackerRes.getString("ZipResourceDialog.Border.Title.Documentation"));
        this.videoBorder.setTitle(TrackerRes.getString("ZipResourceDialog.Border.Title.Video"));
        this.thumbnailBorder.setTitle(TrackerRes.getString("ZipResourceDialog.Border.Title.Thumbnail"));
        this.clipCheckbox.setText(TrackerRes.getString("ZipResourceDialog.Checkbox.TrimVideo"));
        this.helpButton.setText(TrackerRes.getString("Dialog.Button.Help"));
        this.addFilesButton.setText(String.valueOf(TrackerRes.getString("ZipResourceDialog.Button.AddFiles")) + "...");
        this.saveButton.setText(TrackerRes.getString("ExportVideoDialog.Button.SaveAs"));
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.Cancel"));
        this.thumbnailButton.setText(String.valueOf(TrackerRes.getString("ZipResourceDialog.Button.ThumbnailSettings")) + "...");
        this.showThumbnailCheckbox.setText(TrackerRes.getString("ZipResourceDialog.Checkbox.PreviewThumbnail"));
        this.formatLabel.setText(String.valueOf(TrackerRes.getString("ZipResourceDialog.Label.Format")) + ": ");
        this.htmlLabel.setText(TrackerRes.getString("ZipResourceDialog.Label.HTML"));
        this.titleLabel.setText(TrackerRes.getString("ZipResourceDialog.Label.Title"));
        this.descriptionLabel.setText(TrackerRes.getString("ZipResourceDialog.Label.Description"));
        this.authorLabel.setText(TrackerRes.getString("PropertiesDialog.Label.Author"));
        this.contactLabel.setText(TrackerRes.getString("PropertiesDialog.Label.Contact"));
        this.keywordsLabel.setText(TrackerRes.getString("ZipResourceDialog.Label.Keywords"));
        this.urlLabel.setText(TrackerRes.getString("ZipResourceDialog.Label.Link"));
        this.htmlLabel.setToolTipText(String.valueOf(TrackerRes.getString("ZipResourceDialog.Tooltip.HTML")) + ": ");
        this.htmlField.setToolTipText(String.valueOf(TrackerRes.getString("ZipResourceDialog.Tooltip.HTML")) + ": ");
        this.titleLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Title"));
        this.titleField.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Title"));
        this.descriptionLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Description"));
        this.descriptionPane.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Description"));
        this.authorLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Author"));
        this.authorField.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Author"));
        this.contactLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Contact"));
        this.contactField.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Contact"));
        this.keywordsLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Keywords"));
        this.keywordsField.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Keywords"));
        this.urlLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Link"));
        this.urlField.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Link"));
        this.clipCheckbox.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.TrimVideo"));
        this.addFilesButton.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.AddFiles"));
        this.thumbnailButton.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.ThumbnailSettings"));
        this.loadHTMLButton.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.LoadHTML"));
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Font font = this.titleLabel.getFont();
        int n = 0;
        for (Serializable serializable22 : this.labels) {
            Rectangle2D rectangle2D = font.getStringBounds(String.valueOf(serializable22.getText()) + " ", fontRenderContext);
            n = Math.max(n, (int)rectangle2D.getWidth() + 1);
        }
        int n2 = this.titleField.getMinimumSize().height;
        serializable22 = new Dimension(n, n2);
        for (JLabel object2 : this.labels) {
            object2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            object2.setPreferredSize((Dimension)serializable22);
            object2.setHorizontalAlignment(11);
            object2.setAlignmentY(0.0f);
        }
        boolean bl = this.trackerPanel.getVideo() != null;
        this.clipCheckbox.setEnabled(bl);
        if (!bl) {
            this.clipCheckbox.setSelected(false);
        }
        this.formatDropdown.setEnabled(this.clipCheckbox.isSelected());
        this.formatLabel.setEnabled(this.clipCheckbox.isSelected());
        String string2 = this.htmlField.getText().trim();
        Resource resource = null;
        if (!string2.equals(this.htmlField.getDefaultText()) && !string2.equals("")) {
            resource = ResourceLoader.getResource(string2);
            this.htmlField.setForeground(resource == null ? Color.red : EntryField.defaultForeground);
        }
        this.htmlField.setBackground(Color.white);
        String string3 = this.urlField.getText().trim();
        if (!string3.equals("")) {
            try {
                new URL(string3);
                this.urlField.setForeground(EntryField.defaultForeground);
            }
            catch (MalformedURLException malformedURLException) {
                this.urlField.setForeground(Color.red);
            }
        }
        this.urlField.setEnabled(resource == null);
        this.urlLabel.setEnabled(resource == null);
        this.descriptionPane.setEnabled(resource == null);
        this.descriptionLabel.setEnabled(resource == null);
        this.pack();
    }

    private void refreshFormatDropdown() {
        ExportVideoDialog.refreshFormats();
        this.videoExporter.refreshFormatDropdown(preferredExtension);
        this.formatDropdown.removeAllItems();
        Object[] objectArray = this.videoExporter.getFormats();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.formatDropdown.addItem(object);
            ++n2;
        }
        this.formatDropdown.setSelectedItem(this.videoExporter.getFormat());
    }

    private void refreshFieldsFromHTML(File file) {
        String string = ResourceLoader.getString(file.getAbsolutePath());
        if (string == null) {
            return;
        }
        String string2 = ResourceLoader.getTitleFromHTMLCode(string);
        if (string2 != null) {
            this.titleField.setText(string2);
            this.titleField.setBackground(Color.white);
        }
        ArrayList<String[]> arrayList = ExportZipDialog.getMetadataFromHTML(string);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            String[] stringArray = arrayList.get(n);
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            if ("Author".toLowerCase().contains(string3.toLowerCase())) {
                this.authorField.setText(string4);
                this.authorField.setBackground(Color.white);
            } else if ("Contact".toLowerCase().contains(string3.toLowerCase())) {
                this.contactField.setText(string4);
                this.contactField.setBackground(Color.white);
            } else if ("Keywords".toLowerCase().contains(string3.toLowerCase())) {
                this.keywordsField.setText(string4);
                this.keywordsField.setBackground(Color.white);
            }
            --n;
        }
    }

    private void saveZip(ArrayList<File> arrayList) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        File file = null;
        if (this.targetVideo != null) {
            file = new File(this.targetVideo);
            if (!"".equals(videoSubdirectory)) {
                file = file.getParentFile();
                object4 = null;
                object3 = file.listFiles();
                int n = ((File[])object3).length;
                int n2 = 0;
                while (n2 < n) {
                    object2 = object3[n2];
                    if (((File)object2).getName().endsWith(".xml")) {
                        object4 = object2;
                        break;
                    }
                    ++n2;
                }
                if (object4 != null) {
                    ((File)object4).delete();
                }
            }
            arrayList.add(file);
        }
        object4 = new XMLControlElement(this.trackerPanel);
        if (this.clipCheckbox.isSelected()) {
            this.modifyControlForClip((XMLControl)object4, this.targetVideo);
        } else if (this.trackerPanel.getVideo() != null && (object2 = object4.getChildControl("videoclip").getChildControl("video")) != null) {
            object2.setValue("path", XML.getPathRelativeTo(this.targetVideo, this.getTempDirectory()));
        }
        object2 = this.getHTMLPaths((XMLControl)object4);
        if (!((ArrayList)object2).isEmpty()) {
            String string = object4.toXML();
            object3 = ((ArrayList)object2).iterator();
            while (object3.hasNext()) {
                String string2 = (String)object3.next();
                object = this.copyAndAddHTMLPage(string2, arrayList);
                if (object == null) continue;
                string = this.substitutePathInText(string, string2, (String)object, ">", "<");
            }
            object4 = new XMLControlElement(string);
        }
        for (File file2 : this.addedFilesDialog.addedFiles) {
            object3 = file2.getAbsolutePath();
            boolean bl = XML.getExtension((String)object3).startsWith("htm");
            if (bl) {
                this.copyAndAddHTMLPage((String)object3, arrayList);
                continue;
            }
            String string = this.getTempDirectory();
            File file3 = new File(string, XML.getName((String)object3));
            VideoIO.copyFile(file2, file3);
            arrayList.add(file3);
        }
        String string = object4.write(this.getTRKTarget());
        File file4 = new File(string);
        arrayList.add(0, file4);
        object3 = new File(this.getZIPTarget());
        if (JarTool.compress(arrayList, (File)object3, null)) {
            object = new File(this.getTempDirectory());
            ResourceLoader.deleteFile((File)object);
            this.openZip(((File)object3).getAbsolutePath());
        }
    }

    private File writeHTMLInfo(String string, String string2) {
        File file = new File(this.getHTMLDirectory());
        file.mkdirs();
        file = new File(file, String.valueOf(this.targetName) + "_info.html");
        string = XML.getPathRelativeTo(string, this.getHTMLDirectory());
        String string3 = this.titleField.getText().trim();
        String string4 = this.descriptionPane.getText().trim();
        String string5 = this.authorField.getText().trim();
        String string6 = this.contactField.getText().trim();
        String string7 = this.keywordsField.getText().trim();
        String string8 = this.urlField.getText().trim();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (!"".equals(string5)) {
            treeMap.put("author", string5);
        }
        if (!"".equals(string6)) {
            treeMap.put("contact", string6);
        }
        if (!"".equals(string7)) {
            treeMap.put("keywords", string7);
        }
        String string9 = LibraryResource.getHTMLCode(string3, "Tracker", string, string4, string5, string6, string8, null, treeMap);
        if (string2 != null) {
            String string10 = "\n<!--redirect: " + string2 + "-->";
            int n = string9.indexOf("<html>");
            string9 = String.valueOf(string9.substring(0, n + 6)) + string10 + string9.substring(n + 6);
        }
        return this.writeFile(string9, file);
    }

    private File writeFile(String string, File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String addThumbnail(ArrayList<File> arrayList) {
        ThumbnailDialog thumbnailDialog = ThumbnailDialog.getDialog(this.trackerPanel, false);
        String string = thumbnailDialog.getFormat();
        String string2 = String.valueOf(this.getTempDirectory()) + this.targetName + "_thumbnail." + string;
        File file = thumbnailDialog.saveThumbnail(string2);
        if (file == null) {
            return null;
        }
        arrayList.add(file);
        return string2;
    }

    private boolean copyOrExtractFile(String string, File file) {
        String string2 = string.toLowerCase();
        if (string.startsWith("http")) {
            file = ResourceLoader.download(string, file, false);
        } else if (string2.contains("trz!") || string2.contains("jar!") || string2.contains("zip!")) {
            file = JarTool.extract(string, file);
        } else {
            VideoIO.copyFile(new File(string), file);
        }
        return file.exists();
    }

    private boolean addHTMLInfo(String string, ArrayList<File> arrayList) {
        File file;
        File file2;
        Object object;
        Resource resource = ResourceLoader.getResource(this.htmlField.getText().trim());
        if (resource == null) {
            object = new File(this.targetDirectory).listFiles();
            boolean bl = false;
            File[] fileArray = object;
            int n = ((File[])object).length;
            int n2 = 0;
            while (n2 < n) {
                file2 = fileArray[n2];
                String string2 = XML.stripExtension(file2.getName());
                String string3 = XML.getExtension(file2.getName());
                if (("html".equals(string3) || "htm".equals(string3)) && (string2.equals(this.targetName) || string2.equals(String.valueOf(this.targetName) + "_info"))) {
                    TFrame tFrame;
                    int n3;
                    for (File file3 : this.addedFilesDialog.addedFiles) {
                        boolean bl2 = bl = bl || file3.getName().equals(file2.getName());
                    }
                    if (!bl && (n3 = JOptionPane.showConfirmDialog(tFrame = this.trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("ZipResourceDialog.AddHTMLInfo.Message1")) + " \"" + file2.getName() + "\"\n" + TrackerRes.getString("ZipResourceDialog.AddHTMLInfo.Message2"), TrackerRes.getString("ZipResourceDialog.AddHTMLInfo.Title"), 0, 3)) == 0) {
                        resource = ResourceLoader.getResource(file2.getAbsolutePath());
                    }
                }
                ++n2;
            }
        }
        object = null;
        if (resource != null) {
            if (resource.getFile() != null) {
                String string4 = resource.getString();
                if (string4 != null && string4.trim().startsWith("<!DOCTYPE html") && (file2 = this.writeTempHTMLTarget(string4, resource)) != null) {
                    String string5 = this.copyAndAddHTMLPage(file2.getAbsolutePath(), arrayList);
                    if (!file2.equals(resource.getFile())) {
                        file2.delete();
                    }
                    return string5 != null;
                }
            } else {
                object = resource.getAbsolutePath();
            }
        }
        if ((file = this.writeHTMLInfo(string, (String)object)) == null) {
            return false;
        }
        if (!"".equals(htmlSubdirectory)) {
            file = file.getParentFile();
        }
        if (!arrayList.contains(file)) {
            arrayList.add(file);
        }
        return true;
    }

    private void modifyControlForClip(XMLControl xMLControl, String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string2 = this.getTRKTarget();
        VideoPlayer videoPlayer = this.trackerPanel.getPlayer();
        XMLControl xMLControl2 = xMLControl.getChildControl("videoclip");
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        xMLControl2.setValue("video_framecount", xMLControl2.getInt("stepcount"));
        xMLControl2.setValue("startframe", 0);
        xMLControl2.setValue("stepsize", 1);
        xMLControl2.setValue("frameshift", 0);
        if (string != null) {
            object4 = ExportVideoDialog.formats.get(this.formatDropdown.getSelectedItem());
            object3 = object4.getVideo(string);
            xMLControl2.setValue("video", object3);
            object2 = xMLControl2.getChildControl("video");
            if (object2 != null) {
                object2.setValue("path", XML.getPathRelativeTo(string, XML.getDirectoryPath(string2)));
                object2.setValue("filters", null);
                if (object4 instanceof ImageVideoType) {
                    object2.setValue("paths", null);
                    object2.setValue("delta_t", videoPlayer.getMeanStepDuration());
                }
            }
        }
        object4 = xMLControl.getChildControl("clipcontrol");
        object4.setValue("delta_t", videoPlayer.getMeanStepDuration());
        object4.setValue("frame", 0);
        object3 = xMLControl.getChildControl("coords");
        object2 = object3.getObject("framedata");
        ImageCoordSystem.FrameData[] frameDataArray = (ImageCoordSystem.FrameData[])object2;
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = 0;
        int n2 = 0;
        while (n2 < frameDataArray.length) {
            if (frameDataArray[n2] != null) {
                if (n2 >= videoClip.getEndFrameNumber()) break;
                n = Math.max(videoClip.frameToStep(n2), 0);
                if (n2 > videoClip.getStartFrameNumber() && !videoClip.includesFrame(n2)) {
                    ++n;
                }
                treeMap.put(n, n2);
            }
            ++n2;
        }
        ImageCoordSystem.FrameData[] frameDataArray2 = new ImageCoordSystem.FrameData[n + 1];
        for (Object object5 : treeMap.keySet()) {
            frameDataArray2[((Integer)object5).intValue()] = frameDataArray[(Integer)treeMap.get(object5)];
        }
        object3.setValue("framedata", frameDataArray2);
        if (!this.badModels.isEmpty()) {
            Object object5;
            object5 = (ArrayList)ArrayList.class.cast(xMLControl.getObject("tracks"));
            Iterator<Object> iterator = ((ArrayList)object5).iterator();
            while (iterator.hasNext()) {
                object = (TTrack)iterator.next();
                if (!this.badModels.contains(object)) continue;
                iterator.remove();
            }
            xMLControl.setValue("tracks", object5);
        }
        for (Object object5 : xMLControl.getPropertyContent()) {
            if (!(object5 instanceof XMLProperty) || !(object = (XMLProperty)object5).getPropertyName().equals("tracks")) continue;
            for (Object object6 : object.getPropertyContent()) {
                XMLProperty xMLProperty = (XMLProperty)object6;
                XMLControl xMLControl3 = (XMLControl)xMLProperty.getPropertyContent().get(0);
                Class<?> clazz = xMLControl3.getObjectClass();
                if (PointMass.class.equals(clazz)) {
                    object2 = xMLControl3.getObject("framedata");
                    PointMass.FrameData[] frameDataArray3 = (PointMass.FrameData[])object2;
                    treeMap.clear();
                    n = 0;
                    int n3 = 0;
                    while (n3 < frameDataArray3.length) {
                        if (frameDataArray3[n3] != null && videoClip.includesFrame(n3)) {
                            n = videoClip.frameToStep(n3);
                            treeMap.put(n, n3);
                        }
                        ++n3;
                    }
                    PointMass.FrameData[] frameDataArray4 = new PointMass.FrameData[n + 1];
                    for (Integer n4 : treeMap.keySet()) {
                        frameDataArray4[n4.intValue()] = frameDataArray3[(Integer)treeMap.get(n4)];
                    }
                    xMLControl3.setValue("framedata", frameDataArray4);
                    continue;
                }
                if (Vector.class.isAssignableFrom(clazz)) {
                    object2 = xMLControl3.getObject("framedata");
                    Vector.FrameData[] frameDataArray5 = (Vector.FrameData[])object2;
                    treeMap.clear();
                    n = 0;
                    int n5 = 0;
                    while (n5 < frameDataArray5.length) {
                        if (frameDataArray5[n5] != null && videoClip.includesFrame(n5)) {
                            n = videoClip.frameToStep(n5);
                            treeMap.put(n, n5);
                        }
                        ++n5;
                    }
                    Vector.FrameData[] frameDataArray6 = new Vector.FrameData[n + 1];
                    for (Integer n4 : treeMap.keySet()) {
                        frameDataArray6[n4.intValue()] = frameDataArray5[(Integer)treeMap.get(n4)];
                        boolean bl = frameDataArray6[n4.intValue()].independent = frameDataArray6[n4.intValue()].xc != 0.0 || frameDataArray6[n4.intValue()].yc != 0.0;
                    }
                    xMLControl3.setValue("framedata", frameDataArray6);
                    continue;
                }
                if (ParticleModel.class.isAssignableFrom(clazz)) {
                    int n6 = xMLControl3.getInt("start_frame");
                    if (n6 > 0) {
                        int n7 = videoClip.frameToStep(n6);
                        if (n6 > videoClip.getStartFrameNumber() && !videoClip.includesFrame(n6)) {
                            ++n7;
                        }
                        xMLControl3.setValue("start_frame", n7);
                    }
                    if ((n6 = xMLControl3.getInt("end_frame")) <= 0) continue;
                    int n8 = videoClip.frameToStep(n6);
                    xMLControl3.setValue("end_frame", n8);
                    continue;
                }
                if (!Calibration.class.equals(clazz) && !OffsetOrigin.class.equals(clazz)) continue;
                object2 = xMLControl3.getObject("world_coordinates");
                double[][] dArray = (double[][])object2;
                treeMap.clear();
                n = 0;
                int n9 = 0;
                while (n9 < dArray.length) {
                    if (dArray[n9] != null) {
                        n = videoClip.frameToStep(n9);
                        treeMap.put(n, n9);
                    }
                    ++n9;
                }
                double[][] dArrayArray = new double[n + 1][];
                for (Integer n4 : treeMap.keySet()) {
                    dArrayArray[n4.intValue()] = dArray[(Integer)treeMap.get(n4)];
                }
                xMLControl3.setValue("world_coordinates", dArrayArray);
            }
        }
    }

    private ArrayList<ParticleModel> getModelsNotInClip() {
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        ArrayList<ParticleModel> arrayList = this.trackerPanel.getDrawables(ParticleModel.class);
        Iterator<ParticleModel> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ParticleModel particleModel = iterator.next();
            if (!videoClip.includesFrame(particleModel.getStartFrame())) continue;
            iterator.remove();
        }
        return arrayList;
    }

    private ArrayList<String> getHTMLPaths(XMLControl xMLControl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = xMLControl.toXML();
        int n = string.indexOf("PageTView$TabView");
        while (n > -1) {
            String string2;
            Resource resource;
            String string3;
            if ((n = (string = string.substring(n + 17)).indexOf(string3 = "<property name=\"text\" type=\"string\">")) > -1 && (resource = ResourceLoader.getResource(string2 = (string = string.substring(n + string3.length())).substring(0, n = string.indexOf("</property>")))) != null && resource.getFile() != null) {
                arrayList.add(string2);
            }
            n = string.indexOf("PageTView$TabView");
        }
        return arrayList;
    }

    private ArrayList<String> getImagePaths(String string, String string2, String string3, String string4) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf(string3);
        while (n > -1) {
            String string5;
            String string6;
            Resource resource;
            if ((n = (string = string.substring(n + string3.length())).indexOf(string4)) > -1 && (resource = ResourceLoader.getResource(string6 = XML.getResolvedPath(string5 = string.substring(0, n), string2))) != null && resource.getFile() != null) {
                arrayList.add(string5);
            }
            n = string.indexOf(string3);
        }
        return arrayList;
    }

    private String copyAndAddHTMLPage(String string, ArrayList<File> arrayList) {
        String string2 = null;
        Resource resource = ResourceLoader.getResource(string);
        if (resource != null) {
            string2 = resource.getString();
        }
        if (string2 != null) {
            Object object;
            Object object3;
            String string3 = XML.getDirectoryPath(string);
            File file = new File(this.getHTMLDirectory());
            file.mkdirs();
            String string4 = "<img src=\"";
            String string5 = "\"";
            ArrayList<String> arrayList2 = this.getImagePaths(string2, string3, string4, string5);
            if (!arrayList2.isEmpty()) {
                object3 = new File(this.getImageDirectory());
                ((File)object3).mkdirs();
                for (String object22 : arrayList2) {
                    String string6 = XML.getResolvedPath(object22, string3);
                    resource = ResourceLoader.getResource(string6);
                    File file2 = new File((File)object3, XML.getName(object22));
                    if (resource.getFile() != null) {
                        VideoIO.copyFile(resource.getFile(), file2);
                    }
                    string6 = XML.getPathRelativeTo(file2.getAbsolutePath(), this.getHTMLDirectory());
                    string2 = this.substitutePathInText(string2, object22, string6, string4, string5);
                }
                if (!arrayList.contains(object3)) {
                    arrayList.add((File)object3);
                }
            }
            if ((object3 = ResourceLoader.getStyleSheetFromHTMLCode(string2)) != null && !((String)object3).startsWith("http:") && (resource = ResourceLoader.getResource(XML.getResolvedPath((String)object3, string3))) != null) {
                String exception = XML.getName((String)object3);
                object = new File(file, XML.getName(exception));
                VideoIO.copyFile(resource.getFile(), (File)object);
                string2 = this.substitutePathInText(string2, (String)object3, exception, "\"", "\"");
            }
            file = new File(file, XML.getName(string));
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(string2);
                fileWriter.close();
                object = XML.getPathRelativeTo(file.getAbsolutePath(), this.getTempDirectory());
                if (!"".equals(htmlSubdirectory)) {
                    file = file.getParentFile();
                }
                if (!arrayList.contains(file)) {
                    arrayList.add(file);
                }
                return object;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private String substitutePathInText(String string, String string2, String string3, String string4, String string5) {
        if (string2.equals(string3)) {
            return string;
        }
        int n = string.indexOf(String.valueOf(string4) + string2 + string5);
        while (n > 0) {
            string = String.valueOf(string.substring(0, n + string4.length())) + string3 + string.substring(n + string4.length() + string2.length());
            n = string.indexOf(String.valueOf(string4) + string2 + string5);
        }
        return string;
    }

    private void openZip(String string) {
        final TFrame tFrame = this.trackerPanel.getTFrame();
        int n = JOptionPane.showConfirmDialog(tFrame, String.valueOf(TrackerRes.getString("ZipResourceDialog.Complete.Message1")) + " \"" + XML.getName(string) + "\".\n" + TrackerRes.getString("ZipResourceDialog.Complete.Message2"), TrackerRes.getString("ZipResourceDialog.Complete.Title"), 0, 3);
        if (n == 0) {
            tFrame.loadedFiles.remove(string);
            final File file = new File(string);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TrackerIO.open(file, tFrame);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected ArrayList<File> defineTarget() {
        File file;
        String string;
        String[] stringArray;
        JFileChooser jFileChooser = TrackerIO.getChooser();
        jFileChooser.setDialogTitle(TrackerRes.getString("ZipResourceDialog.FileChooser.SaveZip.Title"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(TrackerIO.trzFileFilter);
        jFileChooser.setFileFilter(TrackerIO.trzFileFilter);
        File[] fileArray = TrackerIO.getChooserFiles("save");
        jFileChooser.resetChoosableFileFilters();
        if (fileArray == null) {
            return null;
        }
        this.targetName = XML.stripExtension(fileArray[0].getName());
        String[] stringArray2 = stringArray = new String[]{"/", "\\", "?", "<", ">", "\"", "|", ":", "*", "%"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray2[n2];
            if (this.targetName.indexOf(string) > -1) {
                TFrame tFrame = this.trackerPanel.getTFrame();
                String string2 = "";
                int n3 = 1;
                while (n3 < stringArray.length) {
                    string2 = String.valueOf(string2) + "    " + stringArray[n3];
                    ++n3;
                }
                JOptionPane.showMessageDialog(tFrame, String.valueOf(TrackerRes.getString("ZipResourceDialog.Dialog.BadFileName.Message")) + "\n" + string2, TrackerRes.getString("ZipResourceDialog.Dialog.BadFileName.Title"), 2);
                return null;
            }
            ++n2;
        }
        this.targetDirectory = String.valueOf(fileArray[0].getParent()) + "/";
        this.targetExtension = "trz";
        string = XML.getExtension(fileArray[0].getName());
        if (!this.targetExtension.equals(string) && !TrackerIO.canWrite(file = new File(String.valueOf(XML.stripExtension(fileArray[0].getAbsolutePath())) + "." + this.targetExtension))) {
            return null;
        }
        this.targetVideo = null;
        return new ArrayList<File>();
    }

    private String getTRKTarget() {
        return String.valueOf(this.getTempDirectory()) + this.targetName + ".trk";
    }

    private String getVideoTarget(String string) {
        String string2 = String.valueOf(this.getTempDirectory()) + videoSubdirectory;
        new File(string2).mkdirs();
        return String.valueOf(string2) + "/" + this.targetName + "." + string;
    }

    private String getZIPTarget() {
        return String.valueOf(this.targetDirectory) + this.targetName + "." + this.targetExtension;
    }

    private String getHTMLDirectory() {
        return String.valueOf(this.getTempDirectory()) + htmlSubdirectory + "/";
    }

    private String getImageDirectory() {
        return String.valueOf(this.getTempDirectory()) + imageSubdirectory + "/";
    }

    private String getTempDirectory() {
        return String.valueOf(this.targetDirectory) + this.targetName + "_temp/";
    }

    public static ArrayList<String[]> getMetadataFromHTML(String string) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (string == null) {
            return arrayList;
        }
        String[] stringArray = string.split("<meta name=\"");
        int n = 1;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf("\">");
            if (n2 > -1) {
                stringArray[n] = stringArray[n].substring(0, n2);
                String string2 = "\" content=\"";
                String[] stringArray2 = stringArray[n].split(string2);
                if (stringArray2.length > 1) {
                    String string3 = stringArray2[0];
                    String string4 = stringArray2[1];
                    arrayList.add(new String[]{string3, string4});
                }
            }
            ++n;
        }
        return arrayList;
    }

    private File writeTempHTMLTarget(String string, Resource resource) {
        Object object;
        if (resource.getFile() == null) {
            return null;
        }
        String string2 = ResourceLoader.getTitleFromHTMLCode(string);
        String string3 = this.titleField.getText().trim();
        if (!"".equals(string3) && !string3.equals(string2)) {
            string2 = "<title>" + string2 + "</title>";
            string3 = "<title>" + string3 + "</title>";
            string = string.replace(string2, string3);
        }
        ArrayList<String[]> arrayList = ExportZipDialog.getMetadataFromHTML(string);
        String[] stringArray = LibraryResource.META_TYPES;
        int n = LibraryResource.META_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            String string4 = ((String)object).equals("Author") ? this.authorField.getText().trim() : (((String)object).equals("Contact") ? this.contactField.getText().trim() : (((String)object).equals("Keywords") ? this.keywordsField.getText().trim() : null));
            String string5 = null;
            String string6 = null;
            boolean bl = false;
            for (String[] stringArray2 : arrayList) {
                if (bl) break;
                string6 = stringArray2[0];
                if (!((String)object).toLowerCase().contains(string6.toLowerCase())) continue;
                bl = true;
                string5 = stringArray2[1];
            }
            if (!bl) {
                string6 = ((String)object).toLowerCase();
            }
            string = this.replaceMetadataInHTML(string, string6, string5, string4);
            ++n2;
        }
        object = resource.getFile().getParentFile();
        object = new File((File)object, String.valueOf(this.targetName) + "_info.html");
        object = this.writeFile(string, (File)object);
        return object;
    }

    private String replaceMetadataInHTML(String string, String string2, String string3, String string4) {
        if (string4 == null || string4.trim().equals("")) {
            return string;
        }
        if (string3 == null) {
            int n = string.indexOf("<meta name=");
            if (n < 0) {
                n = string.indexOf("</head");
            }
            if (n > -1) {
                String string5 = "<meta name=\"" + string2 + "\" content=\"" + string4 + "\">\n";
                string = String.valueOf(string.substring(0, n)) + string5 + string.substring(n, string.length());
            }
        } else if (!"".equals(string4) && !string4.equals(string3)) {
            string3 = "meta name=\"" + string2 + "\" content=\"" + string3 + "\"";
            string4 = "meta name=\"" + string2 + "\" content=\"" + string4 + "\"";
            string = string.replace(string3, string4);
        }
        return string;
    }

    protected class AddedFilesDialog
    extends JDialog {
        HashSet<File> addedFiles;
        TreeSet<String> fileNames;
        JButton okButton;
        JButton addButton;
        JButton removeButton;
        JList fileList;
        DefaultListModel fileListModel;

        AddedFilesDialog() {
            super((Dialog)ExportZipDialog.this, true);
            this.addedFiles = new HashSet();
            this.fileNames = new TreeSet();
            this.createGUI();
        }

        void createGUI() {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.setContentPane(jPanel);
            this.fileListModel = new DefaultListModel();
            this.fileList = new JList(this.fileListModel);
            this.fileList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    AddedFilesDialog.this.removeButton.setEnabled(AddedFilesDialog.this.fileList.getSelectedValue() != null);
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.fileList);
            jScrollPane.setPreferredSize(new Dimension(300, 150));
            jPanel.add((Component)jScrollPane, "Center");
            JPanel jPanel2 = new JPanel();
            this.addButton = new JButton();
            this.addButton.setForeground(labelColor);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = TrackerIO.getChooser();
                    jFileChooser.setDialogTitle(TrackerRes.getString("ZipResourceDialog.FileChooser.AddFile.Title"));
                    jFileChooser.addChoosableFileFilter(LaunchBuilder.getPDFFilter());
                    jFileChooser.setFileFilter(LaunchBuilder.getHTMLFilter());
                    File[] fileArray = TrackerIO.getChooserFiles("open any");
                    jFileChooser.removeChoosableFileFilter(LaunchBuilder.getHTMLFilter());
                    jFileChooser.removeChoosableFileFilter(LaunchBuilder.getPDFFilter());
                    if (fileArray == null) {
                        return;
                    }
                    AddedFilesDialog.this.addedFiles.add(fileArray[0]);
                    AddedFilesDialog.this.refreshFileList();
                }
            });
            this.removeButton = new JButton();
            this.removeButton.setForeground(labelColor);
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)AddedFilesDialog.this.fileList.getSelectedValue();
                    if (string != null) {
                        Iterator<File> iterator = AddedFilesDialog.this.addedFiles.iterator();
                        while (iterator.hasNext()) {
                            File file = iterator.next();
                            if (!string.equals(file.getName())) continue;
                            iterator.remove();
                            break;
                        }
                        AddedFilesDialog.this.refreshFileList();
                    }
                }
            });
            this.okButton = new JButton();
            this.okButton.setForeground(labelColor);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddedFilesDialog.this.setVisible(false);
                }
            });
            jPanel2.add(this.addButton);
            jPanel2.add(this.removeButton);
            jPanel2.add(this.okButton);
            jPanel.add((Component)jPanel2, "South");
            this.pack();
        }

        void refreshGUI() {
            this.setTitle(TrackerRes.getString("ZipResourceDialog.Dialog.AddFiles.Title"));
            this.okButton.setText(TrackerRes.getString("Dialog.Button.OK"));
            this.addButton.setText(String.valueOf(TrackerRes.getString("Dialog.Button.Add")) + "...");
            this.removeButton.setText(TrackerRes.getString("Dialog.Button.Remove"));
            this.removeButton.setEnabled(this.fileList.getSelectedValue() != null);
        }

        void refreshFileList() {
            this.fileListModel.clear();
            this.fileNames.clear();
            for (File object : this.addedFiles) {
                this.fileNames.add(object.getName());
            }
            for (String string : this.fileNames) {
                this.fileListModel.addElement(string);
            }
        }
    }

    protected static class EntryField
    extends JTextField {
        static Color defaultForeground = new JTextField().getForeground();
        static DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                JTextComponent jTextComponent = (JTextComponent)documentEvent.getDocument().getProperty("parent");
                jTextComponent.setBackground(Color.yellow);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                JTextComponent jTextComponent = (JTextComponent)documentEvent.getDocument().getProperty("parent");
                jTextComponent.setBackground(Color.yellow);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        static FocusListener focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                EntryField entryField = (EntryField)focusEvent.getSource();
                if (entryField.getDefaultText() != null && entryField.getText().equals(entryField.getDefaultText())) {
                    entryField.setText(null);
                    entryField.setForeground(defaultForeground);
                }
                entryField.selectAll();
                entryField.setBackground(Color.white);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                EntryField entryField = (EntryField)focusEvent.getSource();
                boolean bl2 = bl = entryField.getBackground() == Color.yellow;
                if (entryField.getDefaultText() != null && "".equals(entryField.getText())) {
                    entryField.setText(entryField.getDefaultText());
                    entryField.setForeground(entryField.getEmptyForeground());
                }
                entryField.setBackground(Color.white);
                if (bl) {
                    entryField.fireActionPerformed();
                }
            }
        };
        static ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntryField entryField = (EntryField)actionEvent.getSource();
                entryField.setBackground(Color.white);
            }
        };

        EntryField() {
            this.getDocument().putProperty("parent", this);
            this.addFocusListener(focusListener);
            this.addActionListener(actionListener);
            this.getDocument().addDocumentListener(documentListener);
        }

        EntryField(int n) {
            super(n);
            this.getDocument().putProperty("parent", this);
            this.addFocusListener(focusListener);
            this.addActionListener(actionListener);
            this.getDocument().addDocumentListener(documentListener);
        }

        protected String getDefaultText() {
            return null;
        }

        protected Color getEmptyForeground() {
            return Color.gray;
        }
    }

    protected class VideoListener
    implements PropertyChangeListener {
        ArrayList<File> target;
        ExportVideoDialog dialog;

        protected VideoListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("video_saved") && this.target != null) {
                ExportZipDialog.this.targetVideo = propertyChangeEvent.getNewValue().toString();
                preferredExtension = XML.getExtension(ExportZipDialog.this.targetVideo);
                VideoIO.setPreferredExportExtension(ExportZipDialog.this.videoIOPreferredExtension);
                ExportZipDialog.this.saveZip(this.target);
            }
            if (this.dialog != null) {
                this.dialog.removePropertyChangeListener("video_saved", ExportZipDialog.this.videoExportListener);
                this.dialog.removePropertyChangeListener("video_cancelled", ExportZipDialog.this.videoExportListener);
            }
        }

        void setTargetList(ArrayList<File> arrayList) {
            this.target = arrayList;
        }

        void setDialog(ExportVideoDialog exportVideoDialog) {
            this.dialog = exportVideoDialog;
        }
    }
}

