/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TableTrackView;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.DataTable;

public class ExportDataDialog
extends JDialog {
    protected static ExportDataDialog dataExporter;
    protected TrackerPanel trackerPanel;
    protected JButton saveAsButton;
    protected JButton closeButton;
    protected JComponent tablePanel;
    protected JComponent delimiterPanel;
    protected JComponent contentPanel;
    protected JComponent formatPanel;
    protected JComboBox formatDropdown;
    protected JComboBox delimiterDropdown;
    protected JComboBox tableDropdown;
    protected JComboBox contentDropdown;
    protected HashMap<Object, DataTable> tables;
    protected HashMap<DataTable, String> trackNames;
    protected boolean refreshing;

    public static ExportDataDialog getDialog(TrackerPanel trackerPanel) {
        if (dataExporter == null) {
            dataExporter = new ExportDataDialog(trackerPanel);
        }
        ExportDataDialog.dataExporter.trackerPanel = trackerPanel;
        dataExporter.refreshGUI();
        return dataExporter;
    }

    private ExportDataDialog(TrackerPanel trackerPanel) {
        super(JOptionPane.getFrameForComponent(trackerPanel), true);
        this.trackerPanel = trackerPanel;
        this.setResizable(false);
        this.createGUI();
        this.refreshGUI();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n, n2);
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        Box box = Box.createVerticalBox();
        jPanel.add((Component)box, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        this.tables = new HashMap();
        this.trackNames = new HashMap();
        this.tablePanel = Box.createVerticalBox();
        this.tableDropdown = new JComboBox();
        this.tablePanel.add(this.tableDropdown);
        this.delimiterPanel = new JPanel(new GridLayout(0, 1));
        this.delimiterDropdown = new JComboBox();
        this.delimiterPanel.add(this.delimiterDropdown);
        this.delimiterDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (ExportDataDialog.this.refreshing) {
                    return;
                }
                if (itemEvent.getStateChange() == 1) {
                    Object object = ExportDataDialog.this.delimiterDropdown.getSelectedItem();
                    boolean bl = object.equals(TrackerRes.getString("ExportDataDialog.Delimiter.Add"));
                    boolean bl2 = object.equals(TrackerRes.getString("ExportDataDialog.Delimiter.Remove"));
                    String string = TrackerIO.getDelimiter();
                    if (bl) {
                        Object object2 = JOptionPane.showInputDialog(ExportDataDialog.this, TrackerRes.getString("TableTrackView.Dialog.CustomDelimiter.Message"), TrackerRes.getString("TableTrackView.Dialog.CustomDelimiter.Title"), -1, null, null, string);
                        if (object2 != null && !"".equals(object2.toString())) {
                            String string2 = object2.toString();
                            TrackerIO.setDelimiter(string2);
                            TrackerIO.addCustomDelimiter(string2);
                        }
                        ExportDataDialog.this.refreshGUI();
                    } else if (bl2) {
                        Object[] objectArray = TrackerIO.customDelimiters.values().toArray(new String[1]);
                        Object object3 = JOptionPane.showInputDialog(ExportDataDialog.this, TrackerRes.getString("TableTrackView.Dialog.RemoveDelimiter.Message"), TrackerRes.getString("TableTrackView.Dialog.RemoveDelimiter.Title"), -1, null, objectArray, null);
                        if (object3 != null) {
                            String string3 = object3.toString();
                            TrackerIO.removeCustomDelimiter(string3);
                        }
                        ExportDataDialog.this.refreshGUI();
                    } else if (TrackerIO.delimiters.keySet().contains(object)) {
                        TrackerIO.setDelimiter(TrackerIO.delimiters.get(object));
                    } else if (TrackerIO.customDelimiters.keySet().contains(object)) {
                        TrackerIO.setDelimiter(TrackerIO.customDelimiters.get(object));
                    }
                }
            }
        });
        ListCellRenderer listCellRenderer = this.delimiterDropdown.getRenderer();
        this.delimiterDropdown.setRenderer(new SeparatorRenderer(listCellRenderer));
        this.contentPanel = new JPanel(new GridLayout(0, 1));
        this.contentDropdown = new JComboBox();
        this.contentPanel.add(this.contentDropdown);
        this.formatPanel = new JPanel(new GridLayout(0, 1));
        this.formatDropdown = new JComboBox();
        this.formatPanel.add(this.formatDropdown);
        box.add(jPanel2);
        box.add(jPanel3);
        jPanel2.add(this.tablePanel);
        jPanel2.add(this.contentPanel);
        jPanel3.add(this.formatPanel);
        jPanel3.add(this.delimiterPanel);
        this.saveAsButton = new JButton();
        this.saveAsButton.setForeground(new Color(0, 0, 102));
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = TrackerIO.getChooser();
                jFileChooser.setAcceptAllFileFilterUsed(true);
                jFileChooser.setDialogTitle(TrackerRes.getString("ExportDataDialog.Chooser.SaveData.Title"));
                jFileChooser.setSelectedFile(new File(""));
                File[] fileArray = TrackerIO.getChooserFiles("save");
                if (fileArray == null || fileArray.length == 0) {
                    return;
                }
                DataTable dataTable = ExportDataDialog.this.tables.get(ExportDataDialog.this.tableDropdown.getSelectedItem());
                boolean bl = ExportDataDialog.this.formatDropdown.getSelectedItem().equals(TrackerRes.getString("TableTrackView.MenuItem.Formatted"));
                boolean bl2 = ExportDataDialog.this.contentDropdown.getSelectedItem().equals(TrackerRes.getString("ExportDataDialog.Content.AllCells"));
                String string = String.valueOf(ExportDataDialog.this.trackNames.get(dataTable)) + XML.NEW_LINE;
                string = string.replace(' ', '_');
                if (bl2) {
                    int n;
                    int[] nArray = dataTable.getSelectedRows();
                    int[] nArray2 = dataTable.getSelectedColumns();
                    dataTable.selectAll();
                    StringBuffer stringBuffer = TrackerIO.getData(dataTable, bl);
                    ExportDataDialog.this.write(fileArray[0], String.valueOf(string) + stringBuffer.toString());
                    dataTable.clearSelection();
                    int[] nArray3 = nArray;
                    int n2 = nArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        n = nArray3[n3];
                        dataTable.addRowSelectionInterval(n, n);
                        ++n3;
                    }
                    nArray3 = nArray2;
                    n2 = nArray2.length;
                    n3 = 0;
                    while (n3 < n2) {
                        n = nArray3[n3];
                        dataTable.addColumnSelectionInterval(n, n);
                        ++n3;
                    }
                } else {
                    StringBuffer stringBuffer = TrackerIO.getData(dataTable, bl);
                    ExportDataDialog.this.write(fileArray[0], String.valueOf(string) + stringBuffer.toString());
                }
            }
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(new Color(0, 0, 102));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportDataDialog.this.setVisible(false);
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel.add((Component)jPanel4, "South");
        jPanel4.add(this.saveAsButton);
        jPanel4.add(this.closeButton);
    }

    private void refreshGUI() {
        boolean bl;
        this.refreshing = true;
        String string = TrackerRes.getString("ExportDataDialog.Title");
        this.setTitle(string);
        string = TrackerRes.getString("ExportDataDialog.Subtitle.Table");
        Border border = BorderFactory.createEmptyBorder(0, 4, 6, 4);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        this.tablePanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        string = TrackerRes.getString("ExportDataDialog.Subtitle.Delimiter");
        titledBorder = BorderFactory.createTitledBorder(string);
        this.delimiterPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        string = TrackerRes.getString("ExportDataDialog.Subtitle.Content");
        titledBorder = BorderFactory.createTitledBorder(string);
        this.contentPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        string = TrackerRes.getString("ExportDataDialog.Subtitle.Format");
        titledBorder = BorderFactory.createTitledBorder(string);
        this.formatPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        this.saveAsButton.setText(TrackerRes.getString("ExportVideoDialog.Button.SaveAs"));
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        Object object2 = null;
        String string2 = TrackerIO.getDelimiter();
        this.delimiterDropdown.removeAllItems();
        for (String string3 : TrackerIO.delimiters.keySet()) {
            this.delimiterDropdown.addItem(string3);
            if (!string2.equals(TrackerIO.delimiters.get(string3))) continue;
            object2 = string3;
        }
        boolean bl2 = bl = !TrackerIO.customDelimiters.isEmpty();
        if (bl) {
            this.delimiterDropdown.addItem(new JSeparator(0));
            for (String string4 : TrackerIO.customDelimiters.keySet()) {
                this.delimiterDropdown.addItem(string4);
                if (!string2.equals(TrackerIO.customDelimiters.get(string4))) continue;
                object2 = string4;
            }
        }
        this.delimiterDropdown.addItem(new JSeparator(0));
        String string5 = TrackerRes.getString("ExportDataDialog.Delimiter.Add");
        this.delimiterDropdown.addItem(string5);
        if (bl) {
            String string6 = TrackerRes.getString("ExportDataDialog.Delimiter.Remove");
            this.delimiterDropdown.addItem(string6);
        }
        this.delimiterDropdown.setSelectedItem(object2);
        object2 = this.tableDropdown.getSelectedItem();
        this.tableDropdown.removeAllItems();
        Container[] containerArray = this.trackerPanel.getTFrame().getViews(this.trackerPanel);
        boolean bl3 = false;
        int n = 0;
        while (n < containerArray.length) {
            if (this.trackerPanel.getTFrame().isViewOpen(n, this.trackerPanel)) {
                TableTView tableTView;
                TTrack tTrack;
                TViewChooser tViewChooser;
                TView tView;
                String string7 = " (" + (n + 1) + ")";
                if (containerArray[n] instanceof TViewChooser && (tView = (tViewChooser = (TViewChooser)containerArray[n]).getSelectedView()) instanceof TableTView && (tTrack = (tableTView = (TableTView)tView).getSelectedTrack()) != null) {
                    String string8 = String.valueOf(tTrack.getName()) + string7;
                    TableTrackView tableTrackView = (TableTrackView)tableTView.getTrackView(tTrack);
                    this.trackNames.put(tableTrackView.dataTable, tTrack.getName());
                    this.tables.put(string8, tableTrackView.dataTable);
                    this.tableDropdown.addItem(string8);
                    int[] nArray = tableTrackView.dataTable.getSelectedRows();
                    if (nArray.length > 0) {
                        bl3 = true;
                    }
                }
            }
            ++n;
        }
        if (object2 != null) {
            this.tableDropdown.setSelectedItem(object2);
        }
        object2 = this.formatDropdown.getSelectedItem();
        this.formatDropdown.removeAllItems();
        this.formatDropdown.addItem(TrackerRes.getString("TableTrackView.MenuItem.Unformatted"));
        this.formatDropdown.addItem(TrackerRes.getString("TableTrackView.MenuItem.Formatted"));
        if (object2 != null) {
            this.formatDropdown.setSelectedItem(object2);
        }
        this.contentDropdown.removeAllItems();
        this.contentDropdown.addItem(TrackerRes.getString("ExportDataDialog.Content.AllCells"));
        if (bl3) {
            String string9 = TrackerRes.getString("ExportDataDialog.Content.SelectedCells");
            this.contentDropdown.insertItemAt(string9, 0);
            this.contentDropdown.setSelectedItem(string9);
        }
        this.pack();
        this.refreshing = false;
    }

    public String write(File file, String string) {
        if (file.exists() && !file.canWrite()) {
            JOptionPane.showMessageDialog(this.trackerPanel, ControlsRes.getString("Dialog.ReadOnly.Message"), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
            return null;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Charset charset = Charset.forName("UTF-8");
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, charset));
            bufferedWriter.write(string);
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
            if (file.exists()) {
                return XML.getAbsolutePath(file);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    class SeparatorRenderer
    extends JLabel
    implements ListCellRenderer {
        ListCellRenderer renderer;

        SeparatorRenderer(ListCellRenderer listCellRenderer) {
            this.renderer = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof JSeparator) {
                return (JSeparator)object;
            }
            return this.renderer.getListCellRendererComponent(jList, object, n, bl, bl2);
        }
    }
}

