/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.opensourcephysics.cabrillo.tracker.DynamicFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolver;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DynamicParticle
extends ParticleModel
implements ODE {
    protected boolean inSystem;
    protected String boosterName;
    protected double[] state = new double[5];
    protected double[] initialState = new double[5];
    protected ODESolver solver = new RK4(this);
    protected int iterationsPerStep = 100;
    protected DynamicSystem system;
    protected Point2D[] points;
    protected HashMap<Integer, double[]> frameStates = new HashMap();
    protected ModelBooster modelBooster = new ModelBooster();

    public DynamicParticle() {
        this.initializeInitEditor();
        this.points = new Point2D[]{this.point};
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.boosterName != null && drawingPanel instanceof TrackerPanel) {
            for (PointMass pointMass : ((TrackerPanel)drawingPanel).getDrawables(PointMass.class)) {
                if (!pointMass.getName().equals(this.boosterName)) continue;
                this.setBooster(pointMass);
                this.boosterName = null;
                break;
            }
        }
        if (this.system == null && !this.inSystem) {
            super.draw(drawingPanel, graphics);
        }
    }

    @Override
    public String getDisplayName() {
        String string = this.getName();
        if (this.system == null) {
            return string;
        }
        String string2 = TrackerRes.getString("DynamicParticle.System.In");
        return String.valueOf(string) + " (" + string2 + " " + this.system.getName() + ")";
    }

    @Override
    public void delete() {
        if (this.system != null) {
            String string = TrackerRes.getString("DynamicParticle.Dialog.Delete.Message");
            int n = JOptionPane.showConfirmDialog(this.trackerPanel.getTFrame(), string, TrackerRes.getString("DynamicParticle.Dialog.Delete.Title"), 2, 2);
            if (n == 0) {
                this.system.removeParticle(this);
            } else {
                return;
            }
        }
        super.delete();
    }

    @Override
    protected void refreshSteps() {
        if (this.system == null) {
            super.refreshSteps();
        }
    }

    @Override
    public void reset() {
        if (this.system != null) {
            return;
        }
        super.reset();
        this.resetState();
        double[] dArray = this.getState();
        this.t0 = dArray[dArray.length - 1];
        this.setTracePositions(dArray);
        if (this.trackerPanel != null) {
            this.erase();
            this.dt = this.trackerPanel.getPlayer().getMeanStepDuration() / (double)(1000 * tracePtsPerStep);
            this.dt /= (double)this.iterationsPerStep;
            this.solver.initialize(this.dt);
            ParticleModel[] particleModelArray = this.getModels();
            VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
            int n = Math.min(this.getEndFrame(), videoClip.getFrameCount() - 1);
            while (n > this.getStartFrame() && !videoClip.includesFrame(n)) {
                --n;
            }
            boolean bl = false;
            if (this instanceof DynamicSystem) {
                DynamicSystem dynamicSystem = (DynamicSystem)this;
                boolean bl2 = bl = dynamicSystem.particles.length == 0;
            }
            if (bl || n == this.getStartFrame() && !videoClip.includesFrame(this.getStartFrame())) {
                int n2 = 0;
                while (n2 < particleModelArray.length) {
                    particleModelArray[n2].steps.setLength(1);
                    particleModelArray[n2].steps.setStep(0, null);
                    for (TrackerPanel trackerPanel : this.panels) {
                        particleModelArray[n2].getVArray(trackerPanel).setLength(0);
                        particleModelArray[n2].getAArray(trackerPanel).setLength(0);
                    }
                    particleModelArray[n2].traceX = new double[0];
                    particleModelArray[n2].traceY = new double[0];
                    particleModelArray[n2].support.firePropertyChange("steps", null, null);
                    ++n2;
                }
                return;
            }
            int n3 = this.getStartFrame();
            while (n3 < n && !videoClip.includesFrame(n3)) {
                ++n3;
            }
            ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
            boolean bl3 = this.isUseDefaultReferenceFrame();
            while (bl3 && imageCoordSystem instanceof ReferenceFrame) {
                imageCoordSystem = ((ReferenceFrame)imageCoordSystem).getCoords();
            }
            int n4 = (n3 - this.getStartFrame()) * tracePtsPerStep * this.iterationsPerStep / videoClip.getStepSize();
            int n5 = 0;
            while (n5 < n4) {
                this.solver.step();
                ++n5;
            }
            this.setTracePositions(this.getState());
            AffineTransform affineTransform = imageCoordSystem.getToImageTransform(n3);
            int n6 = 0;
            while (n6 < particleModelArray.length) {
                particleModelArray[n6].lastValidFrame = n3;
                particleModelArray[n6].steps.setLength(n3 + 1);
                PositionStep positionStep = (PositionStep)particleModelArray[n6].getStep(n3);
                int n7 = 0;
                while (n7 < particleModelArray[n6].steps.length) {
                    if (n7 < n3) {
                        particleModelArray[n6].steps.setStep(n7, null);
                    } else if (positionStep == null) {
                        positionStep = new PositionStep(particleModelArray[n6], n3, 0.0, 0.0);
                        positionStep.setFootprint(particleModelArray[n6].getFootprint());
                        particleModelArray[n6].steps.setStep(n3, positionStep);
                    }
                    ++n7;
                }
                for (TrackerPanel trackerPanel : this.panels) {
                    particleModelArray[n6].getVArray(trackerPanel).setLength(0);
                    particleModelArray[n6].getAArray(trackerPanel).setLength(0);
                }
                affineTransform.transform(this.points[n6], this.points[n6]);
                particleModelArray[n6].traceX = new double[]{this.points[n6].getX()};
                particleModelArray[n6].traceY = new double[]{this.points[n6].getY()};
                positionStep.getPosition().setPosition(this.points[n6]);
                particleModelArray[n6].support.firePropertyChange("step", null, (Object)n3);
                ++n6;
            }
        }
    }

    @Override
    public double[] getState() {
        if (this.system != null) {
            return this.system.getState(this);
        }
        return this.state;
    }

    @Override
    protected void saveState(int n) {
        this.frameStates.put(n, (double[])this.getState().clone());
    }

    @Override
    protected boolean restoreState(int n) {
        double[] dArray = this.frameStates.get(n);
        if (dArray != null) {
            System.arraycopy(dArray, 0, this.state, 0, this.state.length);
            return true;
        }
        return false;
    }

    @Override
    public void getRate(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.getXYForces(dArray);
        dArray2[0] = dArray[1];
        dArray2[1] = dArray3[0] / this.getMass();
        dArray2[2] = dArray[3];
        dArray2[3] = dArray3[1] / this.getMass();
        dArray2[4] = 1.0;
    }

    public void setSolver(Class<?> clazz) {
        Class[] classArray = new Class[]{ODE.class};
        Object[] objectArray = new Object[]{this};
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            this.solver = (ODESolver)constructor.newInstance(objectArray);
            this.reset();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double[] getInitialState() {
        double[] dArray = this.getInitialValues();
        this.initialState[0] = dArray[1];
        this.initialState[1] = dArray[3];
        this.initialState[2] = dArray[2];
        this.initialState[3] = dArray[4];
        this.initialState[4] = dArray[0];
        return this.initialState;
    }

    @Override
    public int getStartFrame() {
        if (this.system != null) {
            return this.system.getStartFrame();
        }
        return this.startFrame;
    }

    @Override
    public void setStartFrame(int n) {
        if (this.system != null) {
            this.system.setStartFrame(n);
            this.system.refreshSystemParameters();
        } else {
            super.setStartFrame(n);
            if (this.modelBooster != null) {
                this.modelBooster.setBooster(this.modelBooster.booster);
            }
        }
    }

    @Override
    public int getEndFrame() {
        if (this.system != null) {
            return this.system.getEndFrame();
        }
        return this.endFrame;
    }

    @Override
    public void setEndFrame(int n) {
        if (this.system != null) {
            this.system.setEndFrame(n);
        } else {
            super.setEndFrame(n);
        }
    }

    protected double[] getXYForces(double[] dArray) {
        UserFunction[] userFunctionArray = this.getFunctionEditor().getMainFunctions();
        double d = userFunctionArray[0].evaluate(dArray);
        double d2 = userFunctionArray[1].evaluate(dArray);
        return new double[]{d, d2};
    }

    protected void resetState() {
        if (this.system != null) {
            this.system.resetState();
        } else {
            System.arraycopy(this.getInitialState(), 0, this.state, 0, this.state.length);
        }
    }

    protected void initializeInitEditor() {
        Parameter parameter = (Parameter)this.getInitEditor().getObject("t");
        Parameter parameter2 = new Parameter("x", "0.0");
        parameter2.setNameEditable(false);
        parameter2.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialX.Description"));
        Parameter parameter3 = new Parameter("y", "0.0");
        parameter3.setNameEditable(false);
        parameter3.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialY.Description"));
        Parameter parameter4 = new Parameter("vx", "0.0");
        parameter4.setNameEditable(false);
        parameter4.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialVelocityX.Description"));
        Parameter parameter5 = new Parameter("vy", "0.0");
        parameter5.setNameEditable(false);
        parameter5.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialVelocityY.Description"));
        this.getInitEditor().setParameters(new Parameter[]{parameter, parameter2, parameter3, parameter4, parameter5});
    }

    @Override
    protected void initializeFunctionPanel() {
        this.functionEditor = new UserFunctionEditor();
        this.functionPanel = new DynamicFunctionPanel(this.functionEditor, this);
        String[] stringArray = new String[]{"x", "vx", "y", "vy", "t"};
        UserFunction[] userFunctionArray = new UserFunction[2];
        userFunctionArray[0] = new UserFunction("fx");
        userFunctionArray[0].setNameEditable(false);
        userFunctionArray[0].setExpression("0", stringArray);
        userFunctionArray[0].setDescription(TrackerRes.getString("DynamicParticle.ForceFunction.X.Description"));
        userFunctionArray[1] = new UserFunction("fy");
        userFunctionArray[1].setNameEditable(false);
        userFunctionArray[1].setExpression("0", stringArray);
        userFunctionArray[1].setDescription(TrackerRes.getString("DynamicParticle.ForceFunction.Y.Description"));
        this.functionEditor.setMainFunctions(userFunctionArray);
        this.createMassAndTimeParameters();
    }

    @Override
    protected Point2D[] getNextTracePositions() {
        int n = 0;
        while (n < this.iterationsPerStep) {
            this.solver.step();
            ++n;
        }
        this.setTracePositions(this.getState());
        return this.points;
    }

    protected void setTracePositions(double[] dArray) {
        this.points[0].setLocation(dArray[0], dArray[2]);
    }

    protected double[] getCartesianState(PointMass pointMass, int n) {
        DatasetManager datasetManager = pointMass.getData(this.trackerPanel);
        Dataset dataset = datasetManager.getDataset(datasetManager.getDatasetIndex("frame"));
        int n2 = -1;
        double[] dArray = dataset.getYPoints();
        int n3 = 0;
        while (n3 < dArray.length) {
            if (dArray[n3] == (double)n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            return null;
        }
        double[] dArray2 = new double[5];
        dataset = datasetManager.getDataset(datasetManager.getDatasetIndex("x"));
        Object object = dataset.getValueAt(n2, 1);
        dArray2[0] = object == null ? Double.NaN : (Double)object;
        dataset = datasetManager.getDataset(datasetManager.getDatasetIndex("v_{x}"));
        object = dataset.getValueAt(n2, 1);
        dArray2[1] = object == null ? Double.NaN : (Double)object;
        dataset = datasetManager.getDataset(datasetManager.getDatasetIndex("y"));
        object = dataset.getValueAt(n2, 1);
        dArray2[2] = object == null ? Double.NaN : (Double)object;
        dataset = datasetManager.getDataset(datasetManager.getDatasetIndex("v_{y}"));
        object = dataset.getValueAt(n2, 1);
        dArray2[3] = object == null ? Double.NaN : (Double)object;
        object = dataset.getValueAt(n2, 0);
        dArray2[4] = object == null ? Double.NaN : (Double)object;
        return dArray2;
    }

    protected PointMass getBooster() {
        return this.modelBooster.booster;
    }

    protected void setBooster(PointMass pointMass) {
        this.modelBooster.setBooster(pointMass);
    }

    protected boolean isBoostedBy(PointMass pointMass) {
        if (this.modelBooster == null || this.modelBooster.booster == null) {
            return false;
        }
        if (this.modelBooster.booster == pointMass) {
            return true;
        }
        if (this.modelBooster.booster instanceof DynamicParticle) {
            DynamicParticle dynamicParticle = (DynamicParticle)this.modelBooster.booster;
            return dynamicParticle.isBoostedBy(pointMass);
        }
        return false;
    }

    protected void boost() {
        if (this.modelBooster == null || this.modelBooster.booster == null) {
            return;
        }
        int n = this.getStartFrame();
        double[] dArray = this.getCartesianState(this.modelBooster.booster, n);
        if (dArray == null) {
            return;
        }
        Parameter[] parameterArray = this.getInitEditor().getParameters();
        int n2 = 0;
        while (n2 < parameterArray.length) {
            Parameter parameter = parameterArray[n2];
            String string = parameter.getName();
            double d = Double.NaN;
            if (string.equals("x")) {
                d = dArray[0];
            } else if (string.equals("vx")) {
                d = dArray[1];
            } else if (string.equals("y")) {
                d = dArray[2];
            } else if (string.equals("vy")) {
                d = dArray[3];
            }
            if (!Double.isNaN(d)) {
                Parameter parameter2 = new Parameter(string, String.valueOf(d));
                parameter2.setDescription(parameter.getDescription());
                parameter2.setNameEditable(false);
                parameterArray[n2] = parameter2;
            }
            ++n2;
        }
        this.getInitEditor().setParameters(parameterArray);
        if (this.system != null) {
            this.system.refreshSystemParameters();
            this.system.lastValidFrame = -1;
            this.system.refreshSteps();
        } else {
            this.reset();
        }
        this.repaint();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            DynamicParticle dynamicParticle = (DynamicParticle)object;
            XML.getLoader(ParticleModel.class).saveObject(xMLControl, object);
            if (dynamicParticle.system != null) {
                xMLControl.setValue("in_system", true);
            }
            if (dynamicParticle.modelBooster != null && dynamicParticle.modelBooster.booster != null) {
                xMLControl.setValue("booster", dynamicParticle.modelBooster.booster.getName());
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new DynamicParticle();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            DynamicParticle dynamicParticle = (DynamicParticle)object;
            try {
                XML.getLoader(ParticleModel.class).loadObject(xMLControl, object);
                dynamicParticle.inSystem = xMLControl.getBoolean("in_system");
                dynamicParticle.boosterName = xMLControl.getString("booster");
            }
            catch (Exception exception) {
                Object object2;
                String string = xMLControl.getString("solver");
                if (string != null) {
                    try {
                        object2 = Class.forName(string);
                        dynamicParticle.setSolver((Class<?>)object2);
                    }
                    catch (Exception exception2) {}
                }
                object2 = xMLControl.getString("t0");
                dynamicParticle.getInitEditor().setExpression("t", (String)object2, false);
                String string2 = xMLControl.getString("x");
                dynamicParticle.getInitEditor().setExpression("x", string2, false);
                String string3 = xMLControl.getString("y");
                dynamicParticle.getInitEditor().setExpression("y", string3, false);
                String string4 = xMLControl.getString("vx");
                dynamicParticle.getInitEditor().setExpression("vx", string4, false);
                String string5 = xMLControl.getString("vy");
                dynamicParticle.getInitEditor().setExpression("vy", string5, false);
                String string6 = xMLControl.getString("force x");
                dynamicParticle.getFunctionEditor().setExpression("fx", string6, false);
                String string7 = xMLControl.getString("force y");
                dynamicParticle.getFunctionEditor().setExpression("fy", string7, false);
                dynamicParticle.reset();
            }
            return object;
        }
    }

    class ModelBooster
    implements PropertyChangeListener {
        PointMass booster;
        boolean adjusting = false;

        ModelBooster() {
        }

        public void setBooster(PointMass pointMass) {
            if (this.booster != null) {
                this.booster.removePropertyChangeListener(this);
            }
            this.booster = pointMass;
            if (this.booster != null) {
                DynamicParticle.this.boost();
                this.booster.addPropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.booster == null) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("adjusting")) {
                this.adjusting = (Boolean)propertyChangeEvent.getNewValue();
                string = "steps";
            }
            if (this.adjusting) {
                return;
            }
            if (!string.contains("step") && !string.equals("data")) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("steps") && this.booster instanceof ParticleModel) {
                DatasetManager datasetManager = this.booster.getData(DynamicParticle.this.trackerPanel);
                this.booster.refreshData(datasetManager, DynamicParticle.this.trackerPanel);
            }
            DynamicParticle.this.boost();
        }
    }
}

