/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.CircleFitterFootprint;
import org.opensourcephysics.cabrillo.tracker.CircleFitterStep;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TrackRenderer;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class CircleFitter
extends TTrack {
    protected boolean fixedPosition = true;
    protected boolean radialLineVisible = false;
    protected boolean radialLineEnabled = false;
    protected JCheckBoxMenuItem fixedItem;
    protected JCheckBox radialLineCheckbox;
    protected JLabel clickToMarkLabel;
    protected JLabel xDataPointLabel;
    protected JLabel yDataPointLabel;
    protected NumberField xDataField;
    protected NumberField yDataField;
    protected Component xDataPointSeparator;
    protected Component yDataPointSeparator;
    protected Component checkboxSeparator;
    protected JMenuItem inspectorItem;
    protected JMenuItem originToCenterItem;
    protected JMenuItem clearPointsItem;
    protected PointMass sourceTrack;
    protected int sourceStartStep = 0;
    protected int sourceEndStep = 100000;
    protected CircleFitterInspector inspector;
    protected boolean inspectorVisible;

    public CircleFitter() {
        this.defaultColors = new Color[]{new Color(0, 140, 40)};
        this.setName(TrackerRes.getString("CircleFitter.New.Name"));
        this.setFootprints(new Footprint[]{CircleFitterFootprint.getFootprint("CircleFitterFootprint.Circle4"), CircleFitterFootprint.getFootprint("CircleFitterFootprint.Circle7"), CircleFitterFootprint.getFootprint("CircleFitterFootprint.Circle4Bold"), CircleFitterFootprint.getFootprint("CircleFitterFootprint.Circle7Bold")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.setProperty("tableVar0", "0");
        this.setProperty("tableVar1", "1");
        this.setProperty("tableVar2", "2");
        String string = TrackerRes.getString("CircleFitter.Data.Center");
        this.setProperty("xVarPlot0", "t");
        this.setProperty("yVarPlot0", "x" + string);
        this.setProperty("xVarPlot1", "t");
        this.setProperty("yVarPlot1", "y" + string);
        this.setProperty("xVarPlot2", "t");
        this.setProperty("yVarPlot2", "r");
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("CircleFitter.Hint.Mark3");
        CircleFitterStep circleFitterStep = new CircleFitterStep(this, 0);
        circleFitterStep.setFootprint(this.getFootprint());
        this.steps = new TTrack.StepArray(this, circleFitterStep);
        this.keyFrames.add(0);
        this.fixedItem = new JCheckBoxMenuItem(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CircleFitter.this.setFixed(CircleFitter.this.fixedItem.isSelected());
            }
        });
        this.clickToMarkLabel = new JLabel();
        this.clickToMarkLabel.setForeground(Color.red.darker());
        if (this.radialLineEnabled) {
            this.radialLineCheckbox = new JCheckBox();
            this.radialLineCheckbox.setOpaque(false);
            this.radialLineCheckbox.setBorder(BorderFactory.createEmptyBorder());
            this.radialLineCheckbox.setSelected(this.isRadialLineVisible());
            this.radialLineCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CircleFitter.this.setRadialLineVisible(CircleFitter.this.radialLineCheckbox.isSelected());
                    CircleFitter.this.repaint();
                    CircleFitter.this.dataValid = false;
                    CircleFitter.this.firePropertyChange("data", null, null);
                }
            });
            this.checkboxSeparator = Box.createRigidArea(new Dimension(6, 4));
        }
        final AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CircleFitter.this.trackerPanel == null) {
                    return;
                }
                if (actionEvent != null && actionEvent.getSource() == CircleFitter.this.xDataField && CircleFitter.this.xDataField.getBackground() != Color.yellow) {
                    return;
                }
                if (actionEvent != null && actionEvent.getSource() == CircleFitter.this.yDataField && CircleFitter.this.yDataField.getBackground() != Color.yellow) {
                    return;
                }
                TPoint tPoint = CircleFitter.this.trackerPanel.getSelectedPoint();
                if (!(tPoint instanceof CircleFitterStep.DataPoint)) {
                    return;
                }
                double d = CircleFitter.this.xDataField.getValue();
                double d2 = CircleFitter.this.yDataField.getValue();
                int n = CircleFitter.this.trackerPanel.getFrameNumber();
                ImageCoordSystem imageCoordSystem = CircleFitter.this.trackerPanel.getCoords();
                double d3 = imageCoordSystem.worldToImageX(n, d, d2);
                double d4 = imageCoordSystem.worldToImageY(n, d, d2);
                tPoint.setXY(d3, d4);
                tPoint.showCoordinates(CircleFitter.this.trackerPanel);
                if (actionEvent != null && actionEvent.getSource() instanceof NumberField) {
                    ((NumberField)actionEvent.getSource()).requestFocusInWindow();
                }
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getSource() == CircleFitter.this.xDataField && CircleFitter.this.xDataField.getBackground() != Color.yellow) {
                    return;
                }
                if (focusEvent.getSource() == CircleFitter.this.yDataField && CircleFitter.this.yDataField.getBackground() != Color.yellow) {
                    return;
                }
                abstractAction.actionPerformed(null);
            }
        };
        this.xDataPointLabel = new JLabel("selected x");
        this.xDataPointLabel.setBorder(this.xLabel.getBorder());
        this.xDataField = new NumberField(5);
        this.xDataField.setBorder(this.fieldBorder);
        this.xDataField.addActionListener(abstractAction);
        this.xDataField.addFocusListener(focusAdapter);
        this.yDataPointLabel = new JLabel("y");
        this.yDataPointLabel.setBorder(this.xLabel.getBorder());
        this.yDataField = new NumberField(5);
        this.yDataField.setBorder(this.fieldBorder);
        this.yDataField.addActionListener(abstractAction);
        this.yDataField.addFocusListener(focusAdapter);
        this.xDataPointSeparator = Box.createRigidArea(new Dimension(6, 4));
        this.yDataPointSeparator = Box.createRigidArea(new Dimension(6, 4));
        this.xLabel.setText("center x");
        this.xField.setPatterns(new String[]{"0.000E0", "0.000", "0.00", "0.0", "0.000E0"});
        this.xField.setEnabled(false);
        this.yField.setPatterns(new String[]{"0.000E0", "0.000", "0.00", "0.0", "0.000E0"});
        this.yField.setEnabled(false);
        this.magField.setPatterns(new String[]{"0.000E0", "0.000", "0.00", "0.0", "0.000E0"});
        this.magField.setEnabled(false);
        this.xDataField.setPatterns(new String[]{"0.000E0", "0.000", "0.00", "0.0", "0.000E0"});
        this.yDataField.setPatterns(new String[]{"0.000E0", "0.000", "0.00", "0.0", "0.000E0"});
        final AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CircleFitter.this.angleField.getBackground() != Color.yellow) {
                    return;
                }
                double d = CircleFitter.this.angleField.getValue();
                int n = CircleFitter.this.trackerPanel.getFrameNumber();
                CircleFitterStep circleFitterStep = (CircleFitterStep)CircleFitter.this.getStep(n);
                circleFitterStep.setSliderAngle(d);
            }
        };
        this.angleField.addActionListener(abstractAction2);
        FocusAdapter focusAdapter2 = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                abstractAction2.actionPerformed(null);
            }
        };
        this.angleField.addFocusListener(focusAdapter2);
        this.inspectorItem = new JMenuItem();
        this.inspectorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CircleFitter.this.getInspector().setVisible(true);
            }
        });
        this.originToCenterItem = new JMenuItem();
        this.originToCenterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CircleFitter.this.setCoordsOriginToCenter();
            }
        });
        this.clearPointsItem = new JMenuItem();
        this.clearPointsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XMLControlElement xMLControlElement = new XMLControlElement(CircleFitter.this);
                boolean bl = false;
                Step[] stepArray = CircleFitter.this.getSteps();
                int n = stepArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Step step = stepArray[n2];
                    CircleFitterStep circleFitterStep = (CircleFitterStep)step;
                    if (!circleFitterStep.dataPoints.isEmpty()) {
                        bl = true;
                        circleFitterStep.dataPoints.clear();
                        circleFitterStep.refreshCircle();
                    }
                    ++n2;
                }
                if (bl) {
                    CircleFitter.this.repaint();
                    CircleFitter.this.dataValid = false;
                    CircleFitter.this.firePropertyChange("data", null, this);
                    if (CircleFitter.this.trackerPanel != null) {
                        CircleFitter.this.trackerPanel.changed = true;
                    }
                    TTrackBar.getTrackbar(CircleFitter.this.trackerPanel).refresh();
                    Undo.postTrackEdit(CircleFitter.this, xMLControlElement);
                }
            }
        });
    }

    public void setFixed(boolean bl) {
        if (this.fixedPosition == bl) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (this.trackerPanel != null) {
            this.trackerPanel.changed = true;
            int n = this.trackerPanel.getFrameNumber();
            CircleFitterStep circleFitterStep = (CircleFitterStep)this.getStep(n);
            CircleFitterStep circleFitterStep2 = (CircleFitterStep)this.getStep(0);
            circleFitterStep2.copy(circleFitterStep);
            this.trackerPanel.repaint();
        }
        this.fixedPosition = bl;
        if (bl) {
            this.keyFrames.clear();
            this.keyFrames.add(0);
            this.dataValid = false;
            this.support.firePropertyChange("data", null, null);
            Undo.postTrackEdit(this, xMLControlElement);
        }
    }

    public boolean isFixed() {
        return this.fixedPosition;
    }

    public void setRadialLineVisible(boolean bl) {
        boolean bl2 = bl ^ this.radialLineVisible;
        this.radialLineVisible = bl;
        if (this.trackerPanel != null) {
            int n = this.trackerPanel.getFrameNumber();
            this.steps.getStep(n).repaint();
            if (bl2) {
                this.trackerPanel.changed = true;
            }
        }
    }

    public void copySourceStepPositions(PointMass pointMass) {
        Object object;
        if (this.sourceTrack == null && pointMass == null) {
            return;
        }
        this.sourceTrack = pointMass;
        this.trackerPanel.setSelectedPoint(null);
        boolean bl = false;
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        CircleFitterStep circleFitterStep = null;
        if (this.isFixed()) {
            circleFitterStep = (CircleFitterStep)this.getStep(0);
        } else {
            int n = this.trackerPanel.getFrameNumber();
            circleFitterStep = (CircleFitterStep)this.getStep(n);
        }
        if (this.sourceTrack != null) {
            Object object2;
            VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
            ArrayList<CircleFitterStep.DataPoint> arrayList = new ArrayList<CircleFitterStep.DataPoint>();
            arrayList.addAll(circleFitterStep.dataPoints);
            circleFitterStep.dataPoints.clear();
            object = this.sourceTrack.getSteps();
            int n = 0;
            while (n < ((Object)object).length) {
                if (videoClip.includesFrame(n)) {
                    int n2 = videoClip.frameToStep(n);
                    if (object[n] != null && n2 >= this.sourceStartStep && n2 <= this.sourceEndStep) {
                        object2 = (PositionStep)object[n];
                        circleFitterStep.addDataPoint(((PositionStep)object2).getPosition().x, ((PositionStep)object2).getPosition().y, false);
                    }
                }
                ++n;
            }
            boolean bl2 = bl = circleFitterStep.dataPoints.size() != arrayList.size();
            if (!bl) {
                block1: for (CircleFitterStep.DataPoint dataPoint : circleFitterStep.dataPoints) {
                    object2 = arrayList.iterator();
                    while (object2.hasNext()) {
                        CircleFitterStep.DataPoint dataPoint2 = (CircleFitterStep.DataPoint)object2.next();
                        if (dataPoint.x != dataPoint2.x || dataPoint.y != dataPoint2.y) continue;
                        object2.remove();
                        continue block1;
                    }
                }
                bl = !arrayList.isEmpty();
            }
        }
        Step[] stepArray = this.getSteps();
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null && (this.isFixed() || n >= circleFitterStep.n)) {
                object = (CircleFitterStep)stepArray[n];
                ((CircleFitterStep)object).copy(circleFitterStep);
                ((CircleFitterStep)object).refreshCircle();
            }
            ++n;
        }
        this.repaint();
        this.dataValid = false;
        this.firePropertyChange("data", null, this);
        if (this.trackerPanel != null) {
            this.trackerPanel.changed = true;
        }
        TTrackBar.getTrackbar(this.trackerPanel).refresh();
        if (bl) {
            Undo.postTrackEdit(this, xMLControlElement);
        }
    }

    public void setSourceStartStep(int n) {
        n = Math.max(n, 0);
        this.sourceStartStep = Math.min(n, this.sourceEndStep);
        if (this.inspector != null) {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.sourceStartStep, 0, this.sourceEndStep, 1);
            this.inspector.startStepSpinner.setModel(spinnerNumberModel);
        }
    }

    public void setSourceEndStep(int n) {
        int n2 = this.trackerPanel.getPlayer().getVideoClip().getStepCount() - 1;
        n = Math.min(n, n2);
        this.sourceEndStep = Math.max(n, this.sourceStartStep);
        if (this.inspector != null) {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.sourceEndStep, this.sourceStartStep, n2, 1);
            this.inspector.endStepSpinner.setModel(spinnerNumberModel);
        }
    }

    public boolean isRadialLineVisible() {
        return this.radialLineEnabled && this.radialLineVisible;
    }

    @Override
    public void setLocked(boolean bl) {
        super.setLocked(bl);
        if (this.inspector != null) {
            this.inspector.refreshDisplay();
        }
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        super.draw(drawingPanel, graphics);
        if (this.inspector == null) {
            this.getInspector();
            if (this.trackerPanel.getTFrame() != null) {
                this.trackerPanel.getTFrame().addPropertyChangeListener("tab", this);
            }
        }
    }

    @Override
    public void delete() {
        if (this.inspector != null) {
            this.inspector.setVisible(false);
            this.inspector.dispose();
            this.inspector = null;
        }
        super.delete();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("track") && this.inspector != null) {
            this.inspector.refreshDisplay();
        } else if (string.equals("tab") && this.inspector != null) {
            if (this.trackerPanel != null && propertyChangeEvent.getNewValue() == this.trackerPanel && this.inspectorVisible) {
                this.inspector.setVisible(true);
            } else if (this.inspector.isVisible()) {
                this.inspector.setVisible(false);
                this.inspectorVisible = true;
            }
        }
        if (this.trackerPanel.getSelectedTrack() == this) {
            if (string.equals("stepnumber")) {
                this.refreshFields(this.trackerPanel.getFrameNumber());
            } else if (string.equals("transform")) {
                this.refreshFields(this.trackerPanel.getFrameNumber());
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    @Override
    public void setTrailVisible(boolean bl) {
    }

    @Override
    public Step createStep(int n, double d, double d2) {
        if (!this.isFixed()) {
            this.keyFrames.add(n);
            CircleFitterStep circleFitterStep = (CircleFitterStep)this.steps.getStep(n);
            circleFitterStep.addDataPoint(d, d2, true);
            return circleFitterStep;
        }
        this.keyFrames.add(0);
        CircleFitterStep circleFitterStep = (CircleFitterStep)this.steps.getStep(0);
        circleFitterStep.addDataPoint(d, d2, true);
        return this.getStep(n);
    }

    @Override
    public Step deleteStep(int n) {
        if (this.isLocked()) {
            return null;
        }
        TPoint tPoint = this.trackerPanel.getSelectedPoint();
        CircleFitterStep circleFitterStep = (CircleFitterStep)this.steps.getStep(n);
        if (!this.isFixed()) {
            circleFitterStep.removeDataPoint(tPoint, true);
        } else {
            int n2 = -1;
            int n3 = 0;
            while (n3 < circleFitterStep.dataPoints.size()) {
                if (circleFitterStep.dataPoints.get(n3) == tPoint) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            if (n2 > -1) {
                circleFitterStep = (CircleFitterStep)this.steps.getStep(0);
                tPoint = circleFitterStep.dataPoints.get(n2);
                circleFitterStep.removeDataPoint(tPoint, true);
            }
        }
        return null;
    }

    @Override
    public Step getStep(int n) {
        CircleFitterStep circleFitterStep = (CircleFitterStep)this.steps.getStep(n);
        this.refreshStep(circleFitterStep);
        return circleFitterStep;
    }

    @Override
    public Step getStep(TPoint tPoint, TrackerPanel trackerPanel) {
        Step[] stepArray;
        if (tPoint == null) {
            return null;
        }
        Step[] stepArray2 = stepArray = this.steps.array;
        int n = stepArray.length;
        int n2 = 0;
        while (n2 < n) {
            Step step = stepArray2[n2];
            if (step != null) {
                TPoint[] tPointArray = step.getPoints();
                int n3 = 0;
                while (n3 < tPointArray.length) {
                    if (tPointArray[n3] == tPoint) {
                        return step;
                    }
                    ++n3;
                }
                CircleFitterStep circleFitterStep = (CircleFitterStep)step;
                for (TPoint tPoint2 : circleFitterStep.dataPoints) {
                    if (tPoint2 != tPoint) continue;
                    return step;
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public int getStepLength() {
        return CircleFitterStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 3;
    }

    @Override
    public void setFontLevel(int n) {
        super.setFontLevel(n);
        Object[] objectArray = new Object[]{this.clickToMarkLabel, this.xDataPointLabel, this.yDataPointLabel, this.xDataField, this.yDataField};
        FontSizer.setFonts(objectArray, n);
        if (this.radialLineEnabled) {
            FontSizer.setFonts(this.radialLineCheckbox, n);
        }
        if (this.inspector != null) {
            this.inspector.refreshDisplay();
        }
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        JMenu jMenu = super.getMenu(trackerPanel);
        this.inspectorItem.setText(TrackerRes.getString("CircleFitter.MenuItem.Inspector"));
        this.originToCenterItem.setText(TrackerRes.getString("CircleFitter.MenuItem.OriginToCenter"));
        this.originToCenterItem.setEnabled(!trackerPanel.getCoords().isLocked());
        this.deleteStepItem.setText(TrackerRes.getString("CircleFitter.MenuItem.DeletePoint"));
        this.clearPointsItem.setText(TrackerRes.getString("CircleFitter.MenuItem.ClearPoints"));
        this.clearPointsItem.setEnabled(!this.isLocked());
        this.fixedItem.setText(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedItem.setSelected(this.isFixed());
        this.fixedItem.setEnabled(this.attachments == null || this.attachments[0] == null && this.attachments[1] == null && this.attachments[2] == null);
        jMenu.insert(this.inspectorItem, 0);
        jMenu.insertSeparator(1);
        jMenu.insert(this.originToCenterItem, 2);
        jMenu.insertSeparator(3);
        jMenu.remove(this.deleteTrackItem);
        jMenu.remove(jMenu.getMenuComponent(jMenu.getMenuComponentCount() - 1));
        jMenu.add(this.fixedItem);
        jMenu.addSeparator();
        jMenu.add(this.deleteStepItem);
        jMenu.add(this.clearPointsItem);
        jMenu.add(this.deleteTrackItem);
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        int n = trackerPanel.getFrameNumber();
        this.refreshFields(n);
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        arrayList.add(this.stepSeparator);
        CircleFitterStep circleFitterStep = (CircleFitterStep)this.getStep(n);
        if (circleFitterStep.dataPoints.size() > 2) {
            if (this.radialLineEnabled) {
                this.radialLineCheckbox.setText(TrackerRes.getString("CircleFitter.Checkbox.RadialLine"));
                this.radialLineCheckbox.setToolTipText(TrackerRes.getString("CircleFitter.Checkbox.RadialLine.Tooltip"));
                arrayList.add(this.radialLineCheckbox);
                arrayList.add(this.checkboxSeparator);
            }
            this.xField.setToolTipText(TrackerRes.getString("CircleFitter.Field.CenterX.Tooltip"));
            this.yField.setToolTipText(TrackerRes.getString("CircleFitter.Field.CenterY.Tooltip"));
            this.magLabel.setText(TrackerRes.getString("CircleFitter.Label.Radius"));
            this.magField.setToolTipText(TrackerRes.getString("CircleFitter.Field.Radius.Tooltip"));
            arrayList.add(this.magLabel);
            arrayList.add(this.magField);
            arrayList.add(this.magSeparator);
            arrayList.add(this.xLabel);
            arrayList.add(this.xField);
            arrayList.add(this.xSeparator);
            arrayList.add(this.yLabel);
            arrayList.add(this.yField);
            arrayList.add(this.ySeparator);
        } else if (trackerPanel.getSelectedPoint() == null) {
            this.clickToMarkLabel.setText(TrackerRes.getString("CircleFitter.Label.MarkPoint"));
            arrayList.add(this.clickToMarkLabel);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint tPoint) {
        ArrayList<Component> arrayList = super.getToolbarPointComponents(trackerPanel, tPoint);
        int n = trackerPanel.getFrameNumber();
        this.refreshFields(n);
        CircleFitterStep circleFitterStep = (CircleFitterStep)this.getStep(n);
        if (tPoint == circleFitterStep.slider) {
            arrayList.add(this.angleLabel);
            arrayList.add(this.angleField);
            arrayList.add(this.angleSeparator);
        } else {
            arrayList.add(this.xDataPointLabel);
            arrayList.add(this.xDataField);
            arrayList.add(this.xDataPointSeparator);
            arrayList.add(this.yDataPointLabel);
            arrayList.add(this.yDataField);
            arrayList.add(this.yDataPointSeparator);
        }
        if (circleFitterStep.dataPoints.size() < 3) {
            this.clickToMarkLabel.setText(TrackerRes.getString("CircleFitter.Label.MarkPoint"));
            arrayList.add(this.clickToMarkLabel);
        }
        return arrayList;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof TrackerPanel) || !this.isVisible()) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        int n3 = trackerPanel.getFrameNumber();
        CircleFitterStep circleFitterStep = (CircleFitterStep)this.getStep(n3);
        if (trackerPanel.getPlayer().getVideoClip().includesFrame(n3)) {
            Interactive interactive = circleFitterStep.findInteractive(trackerPanel, n, n2);
            if (interactive == null) {
                this.partName = TrackerRes.getString("TTrack.Selected.Hint");
                this.hint = circleFitterStep.dataPoints.size() < 3 ? TrackerRes.getString("CircleFitter.Hint.Mark3") : TrackerRes.getString("CircleFitter.Hint.MarkMore");
                return null;
            }
            if (interactive instanceof CircleFitterStep.DataPoint) {
                this.partName = TrackerRes.getString("CircleFitter.DataPoint.Name");
                this.hint = TrackerRes.getString("CircleFitter.DataPoint.Hint");
            } else if (interactive instanceof CircleFitterStep.Slider) {
                this.partName = TrackerRes.getString("CircleFitter.Slider.Name");
                this.hint = TrackerRes.getString("CircleFitter.Slider.Hint");
            }
            return interactive;
        }
        return null;
    }

    @Override
    public String toString() {
        return TrackerRes.getString("CircleFitter.Name");
    }

    @Override
    protected void setTrackerPanel(TrackerPanel trackerPanel) {
        if (this.trackerPanel != null) {
            this.trackerPanel.removePropertyChangeListener("stepnumber", this);
            if (this.trackerPanel.getTFrame() != null) {
                this.trackerPanel.getTFrame().removePropertyChangeListener("tab", this);
            }
        }
        super.setTrackerPanel(trackerPanel);
        if (this.trackerPanel != null) {
            this.trackerPanel.addPropertyChangeListener("stepnumber", this);
        }
        this.setFixed(this.isFixed());
    }

    @Override
    protected void setAnglesInRadians(boolean bl) {
        super.setAnglesInRadians(bl);
        CircleFitterStep circleFitterStep = (CircleFitterStep)this.getStep(this.trackerPanel.getFrameNumber());
        circleFitterStep.repaint();
    }

    @Override
    protected String getTargetDescription(int n) {
        if (n == 0) {
            return TrackerRes.getString("Protractor.Vertex.Name");
        }
        String string = TrackerRes.getString("Protractor.End.Name");
        return String.valueOf(string) + " " + n;
    }

    @Override
    protected void refreshData(DatasetManager datasetManager, TrackerPanel trackerPanel) {
        if (this.refreshDataLater || trackerPanel == null || datasetManager == null) {
            return;
        }
        this.dataFrames.clear();
        int n = 0;
        Dataset dataset = null;
        Dataset dataset2 = datasetManager.getDataset(n++);
        Dataset dataset3 = datasetManager.getDataset(n++);
        Dataset dataset4 = datasetManager.getDataset(n++);
        Dataset dataset5 = datasetManager.getDataset(n++);
        Dataset dataset6 = datasetManager.getDataset(n++);
        if (this.radialLineEnabled) {
            dataset = datasetManager.getDataset(n++);
        }
        String string = "t";
        if (!dataset2.getColumnName(0).equals(string)) {
            String string2 = TrackerRes.getString("CircleFitter.Data.Center");
            dataset2.setXYColumnNames(string, "x_" + string2);
            dataset3.setXYColumnNames(string, "y_" + string2);
            dataset4.setXYColumnNames(string, "r");
            dataset5.setXYColumnNames(string, "step");
            dataset6.setXYColumnNames(string, "frame");
            if (this.radialLineEnabled) {
                dataset.setXYColumnNames(string, "$\\theta$");
            }
        } else {
            int n2 = 0;
            while (n2 < n) {
                datasetManager.getDataset(n2).clear();
                ++n2;
            }
        }
        this.dataDescriptions = new String[n + 1];
        int n3 = 0;
        while (n3 < this.dataDescriptions.length) {
            this.dataDescriptions[n3] = TrackerRes.getString("CircleFitter.Data.Description." + n3);
            ++n3;
        }
        VideoPlayer videoPlayer = trackerPanel.getPlayer();
        VideoClip videoClip = videoPlayer.getVideoClip();
        int n4 = videoClip.getStepCount();
        double[][] dArray = new double[datasetManager.getDatasets().size() + 1][n4];
        int n5 = 0;
        while (n5 < n4) {
            double d;
            double d2;
            int n6 = videoClip.stepToFrame(n5);
            CircleFitterStep circleFitterStep = (CircleFitterStep)this.getStep(n6);
            circleFitterStep.dataVisible = true;
            dArray[0][n5] = d2 = videoPlayer.getStepTime(n5) / 1000.0;
            Point2D point2D = circleFitterStep.getWorldCenter();
            dArray[1][n5] = point2D == null ? Double.NaN : point2D.getX();
            dArray[2][n5] = point2D == null ? Double.NaN : point2D.getY();
            double d3 = circleFitterStep.getSliderAngle();
            dArray[3][n5] = d = circleFitterStep.getWorldRadius();
            dArray[4][n5] = n5;
            dArray[5][n5] = n6;
            this.dataFrames.add(n6);
            if (this.radialLineEnabled) {
                dArray[6][n5] = this.isRadialLineVisible() ? d3 : Double.NaN;
            }
            ++n5;
        }
        dataset2.append(dArray[0], dArray[1]);
        dataset3.append(dArray[0], dArray[2]);
        dataset4.append(dArray[0], dArray[3]);
        dataset5.append(dArray[0], dArray[4]);
        dataset6.append(dArray[0], dArray[5]);
        if (this.radialLineEnabled) {
            dataset.append(dArray[0], dArray[6]);
        }
    }

    protected void refreshStep(CircleFitterStep circleFitterStep) {
        boolean bl;
        CircleFitterStep circleFitterStep2 = this.getKeyStep(circleFitterStep);
        if (circleFitterStep2 == circleFitterStep) {
            return;
        }
        boolean bl2 = bl = circleFitterStep2.dataPoints.size() != circleFitterStep.dataPoints.size();
        if (!bl) {
            int n = 0;
            while (n < circleFitterStep2.dataPoints.size()) {
                TPoint tPoint = circleFitterStep2.dataPoints.get(n);
                TPoint tPoint2 = circleFitterStep.dataPoints.get(n);
                bl = bl || tPoint.x != tPoint2.x || tPoint.y != tPoint2.y;
                ++n;
            }
        }
        if (bl) {
            circleFitterStep.copy(circleFitterStep2);
        }
        if (circleFitterStep.slider.x != circleFitterStep2.slider.x || circleFitterStep.slider.y != circleFitterStep2.slider.y) {
            circleFitterStep.slider.setLocation(circleFitterStep2.slider);
            this.repaint();
        }
    }

    protected void refreshFields(int n) {
        CircleFitterStep circleFitterStep = (CircleFitterStep)this.getStep(n);
        this.magField.setValue(circleFitterStep.getWorldRadius());
        Point2D point2D = circleFitterStep.getWorldCenter();
        this.xField.setValue(point2D == null ? Double.NaN : point2D.getX());
        this.yField.setValue(point2D == null ? Double.NaN : point2D.getY());
        TPoint tPoint = this.trackerPanel.getSelectedPoint();
        if (tPoint instanceof CircleFitterStep.DataPoint) {
            point2D = tPoint.getWorldPosition(this.trackerPanel);
            this.xDataField.setValue(point2D.getX());
            this.yDataField.setValue(point2D.getY());
        } else if (tPoint == circleFitterStep.slider) {
            this.angleField.setValue(circleFitterStep.getSliderAngle());
        }
    }

    protected CircleFitterStep getKeyStep(CircleFitterStep circleFitterStep) {
        int n = 0;
        if (!this.isFixed()) {
            Iterator iterator = this.keyFrames.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (n2 > circleFitterStep.n) continue;
                n = n2;
            }
        }
        return (CircleFitterStep)this.steps.getStep(n);
    }

    protected void setCoordsOriginToCenter() {
        if (this.trackerPanel.getCoords().isLocked()) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this.trackerPanel.getCoords());
        boolean bl = false;
        if (this.isFixed()) {
            CircleFitterStep circleFitterStep = (CircleFitterStep)this.getStep(0);
            if (!circleFitterStep.isValidCircle()) {
                return;
            }
            TPoint tPoint = circleFitterStep.center;
            int n = this.trackerPanel.getCoords().getLength();
            if (this.trackerPanel.getCoords().isFixedOrigin()) {
                this.trackerPanel.getCoords().setOriginXY(0, tPoint.x, tPoint.y);
            } else {
                int n2 = 0;
                while (n2 < n) {
                    if (n2 <= 0 || this.trackerPanel.getCoords().getKeyFrames().contains(n2)) {
                        this.trackerPanel.getCoords().setOriginXY(n2, tPoint.x, tPoint.y);
                    }
                    ++n2;
                }
            }
        } else {
            CircleFitterStep circleFitterStep;
            Step step;
            Step[] stepArray;
            Step[] stepArray2 = stepArray = this.steps.array;
            int n = stepArray.length;
            int n3 = 0;
            while (n3 < n) {
                step = stepArray2[n3];
                if (step != null && (circleFitterStep = (CircleFitterStep)step).isValidCircle()) {
                    bl = true;
                }
                ++n3;
            }
            if (!bl) {
                return;
            }
            this.trackerPanel.getCoords().setFixedOrigin(false);
            stepArray2 = stepArray;
            n = stepArray.length;
            n3 = 0;
            while (n3 < n) {
                step = stepArray2[n3];
                if (step != null) {
                    circleFitterStep = (CircleFitterStep)step;
                    this.trackerPanel.getCoords().setOriginXY(step.n, circleFitterStep.center.x, circleFitterStep.center.y);
                }
                ++n3;
            }
        }
        this.trackerPanel.getAxes().setVisible(true);
        Undo.postCoordsEdit(this.trackerPanel, xMLControlElement);
    }

    protected CircleFitterInspector getInspector() {
        if (this.inspector == null) {
            this.inspector = new CircleFitterInspector();
        }
        this.inspector.refreshDisplay();
        return this.inspector;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected class CircleFitterInspector
    extends JDialog {
        private JTextArea textPane;
        private JComboBox trackDropdown;
        private JSpinner startStepSpinner;
        private JSpinner endStepSpinner;
        private JLabel dropdownLabel;
        private JLabel startLabel;
        private JLabel endLabel;
        private JButton copyButton;
        private JButton closeButton;
        private boolean refreshing;

        public CircleFitterInspector() {
            super((Frame)CircleFitter.this.trackerPanel.getTFrame(), false);
            this.createGUI();
            this.refreshDisplay();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            this.setLocation(n, n2);
        }

        void createGUI() {
            CircleFitter.this.setSourceStartStep(0);
            CircleFitter.this.setSourceEndStep(CircleFitter.this.trackerPanel.getPlayer().getVideoClip().getStepCount() - 1);
            this.textPane = new JTextArea(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    int n = (int)(250.0 * FontSizer.getFactor());
                    dimension.width = Math.max(n, dimension.width);
                    return dimension;
                }
            };
            this.textPane.setEditable(false);
            this.textPane.setLineWrap(true);
            this.textPane.setWrapStyleWord(true);
            Border border = BorderFactory.createEtchedBorder();
            Border border2 = BorderFactory.createEmptyBorder(2, 4, 2, 4);
            this.textPane.setBorder(BorderFactory.createCompoundBorder(border, border2));
            this.textPane.setForeground(Color.blue);
            this.trackDropdown = new JComboBox(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    --dimension.height;
                    return dimension;
                }
            };
            this.trackDropdown.setRenderer(new TrackRenderer());
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(CircleFitter.this.sourceStartStep, 0, CircleFitter.this.sourceEndStep, 1);
            this.startStepSpinner = new JSpinner(spinnerNumberModel);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (CircleFitterInspector.this.refreshing) {
                        return;
                    }
                    int n = (Integer)CircleFitterInspector.this.startStepSpinner.getValue();
                    if (n == ((CircleFitterInspector)CircleFitterInspector.this).CircleFitter.this.sourceStartStep) {
                        return;
                    }
                    CircleFitter.this.setSourceStartStep(n);
                }
            };
            this.startStepSpinner.addChangeListener(changeListener);
            int n = CircleFitter.this.trackerPanel.getPlayer().getVideoClip().getStepCount() - 1;
            spinnerNumberModel = new SpinnerNumberModel(CircleFitter.this.sourceEndStep, CircleFitter.this.sourceStartStep, n, 1);
            this.endStepSpinner = new JSpinner(spinnerNumberModel);
            changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (CircleFitterInspector.this.refreshing) {
                        return;
                    }
                    int n = (Integer)CircleFitterInspector.this.endStepSpinner.getValue();
                    if (n == ((CircleFitterInspector)CircleFitterInspector.this).CircleFitter.this.sourceEndStep) {
                        return;
                    }
                    CircleFitter.this.setSourceEndStep(n);
                }
            };
            this.endStepSpinner.addChangeListener(changeListener);
            this.dropdownLabel = new JLabel();
            this.dropdownLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.startLabel = new JLabel();
            this.startLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.endLabel = new JLabel();
            this.endLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.copyButton = new JButton();
            this.copyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = (Object[])CircleFitterInspector.this.trackDropdown.getSelectedItem();
                    if (objectArray != null) {
                        for (PointMass pointMass : ((CircleFitterInspector)CircleFitterInspector.this).CircleFitter.this.trackerPanel.getDrawables(PointMass.class)) {
                            if (!objectArray[1].equals(pointMass.getName())) continue;
                            CircleFitter.this.copySourceStepPositions(pointMass);
                            CircleFitterInspector.this.refreshGUI();
                        }
                    }
                }
            });
            this.closeButton = new JButton();
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((CircleFitterInspector)CircleFitterInspector.this).CircleFitter.this.inspector.setVisible(false);
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            this.setContentPane(jPanel);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel.add((Component)jPanel2, "Center");
            jPanel2.add((Component)this.textPane, "North");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel3, "Center");
            JPanel jPanel4 = new JPanel();
            jPanel4.setBorder(BorderFactory.createEmptyBorder(8, 4, 4, 4));
            jPanel4.add(this.dropdownLabel);
            jPanel4.add(this.trackDropdown);
            jPanel3.add((Component)jPanel4, "North");
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 8, 4));
            jPanel5.add(this.startLabel);
            jPanel5.add(this.startStepSpinner);
            jPanel5.add(this.endLabel);
            jPanel5.add(this.endStepSpinner);
            jPanel3.add((Component)jPanel5, "South");
            JPanel jPanel6 = new JPanel();
            jPanel6.setBorder(border);
            jPanel6.add(this.copyButton);
            jPanel6.add(this.closeButton);
            jPanel.add((Component)jPanel6, "South");
            this.refreshGUI();
        }

        public void refreshGUI() {
            this.setTitle(String.valueOf(TrackerRes.getString("CircleFitter.Name")) + " \"" + CircleFitter.this.getName() + "\"");
            this.dropdownLabel.setText(TrackerRes.getString("CircleFitter.Inspector.Label.SourceTrack"));
            this.startLabel.setText(TrackerRes.getString("CircleFitter.Inspector.Label.From"));
            this.endLabel.setText(TrackerRes.getString("CircleFitter.Inspector.Label.To"));
            String string = String.valueOf(TrackerRes.getString("CircleFitter.Inspector.Instructions1")) + "  " + TrackerRes.getString("CircleFitter.Inspector.Instructions2");
            this.textPane.setText(string);
            this.copyButton.setText(TrackerRes.getString("CircleFitter.Inspector.Button.Apply"));
            this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
            this.pack();
        }

        void refreshDisplay() {
            ArrayList<PointMass> arrayList = CircleFitter.this.trackerPanel.getDrawables(PointMass.class);
            this.copyButton.setEnabled(!arrayList.isEmpty() && !CircleFitter.this.isLocked());
            Object[] objectArray = null;
            this.refreshing = true;
            this.trackDropdown.removeAllItems();
            if (arrayList.isEmpty()) {
                Object[] objectArray2 = new Object[2];
                objectArray2[1] = TrackerRes.getString("CircleFitter.Inspector.Dropdown.None");
                Object[] objectArray3 = objectArray2;
                this.trackDropdown.addItem(objectArray3);
                objectArray = objectArray3;
            } else {
                for (PointMass pointMass : arrayList) {
                    Icon icon = pointMass.getFootprint().getIcon(21, 16);
                    Object[] objectArray4 = new Object[]{icon, pointMass.getName()};
                    this.trackDropdown.addItem(objectArray4);
                    if (pointMass != CircleFitter.this.sourceTrack) continue;
                    objectArray = objectArray4;
                }
            }
            if (objectArray != null) {
                this.trackDropdown.setSelectedItem(objectArray);
            } else {
                this.trackDropdown.setSelectedIndex(0);
            }
            this.refreshing = false;
            FontSizer.setFonts(this, FontSizer.getLevel());
            this.pack();
        }

        @Override
        public void setVisible(boolean bl) {
            super.setVisible(bl);
            CircleFitter.this.inspectorVisible = bl;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            CircleFitter circleFitter = (CircleFitter)object;
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            xMLControl.setValue("fixed", circleFitter.isFixed());
            Step[] stepArray = circleFitter.getSteps();
            int n = stepArray.length;
            if (circleFitter.isFixed()) {
                n = 1;
            }
            double[][] dArrayArray = new double[n][];
            int n2 = 0;
            while (n2 < n) {
                if (stepArray[n2] != null && circleFitter.keyFrames.contains(n2)) {
                    CircleFitterStep circleFitterStep = (CircleFitterStep)stepArray[n2];
                    int n3 = circleFitterStep.dataPoints.size();
                    if (n3 == 0) {
                        dArrayArray[n2] = new double[]{n2};
                    } else {
                        double[] dArray = new double[2 * n3 + 3];
                        dArray[0] = n2;
                        int n4 = 0;
                        while (n4 < n3) {
                            CircleFitterStep.DataPoint dataPoint = circleFitterStep.dataPoints.get(n4);
                            dArray[2 * n4 + 1] = dataPoint.x;
                            dArray[2 * n4 + 2] = dataPoint.y;
                            ++n4;
                        }
                        dArray[dArray.length - 2] = circleFitterStep.slider.x;
                        dArray[dArray.length - 1] = circleFitterStep.slider.y;
                        dArrayArray[n2] = dArray;
                    }
                }
                ++n2;
            }
            xMLControl.setValue("framedata", dArrayArray);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new CircleFitter();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            CircleFitter circleFitter = (CircleFitter)object;
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            boolean bl = circleFitter.isLocked();
            circleFitter.setLocked(false);
            circleFitter.fixedPosition = xMLControl.getBoolean("fixed");
            circleFitter.keyFrames.clear();
            circleFitter.keyFrames.add(0);
            double[][] dArray = (double[][])xMLControl.getObject("framedata");
            int n = 0;
            while (n < dArray.length) {
                if (dArray[n] != null && dArray[n].length >= 1) {
                    int n2 = (int)dArray[n][0];
                    CircleFitterStep circleFitterStep = (CircleFitterStep)circleFitter.getStep(n2);
                    circleFitterStep.dataPoints.clear();
                    if (dArray[n].length == 1) {
                        circleFitterStep.refreshCircle();
                    } else {
                        int n3 = (dArray[n].length - 3) / 2;
                        int n4 = 0;
                        while (n4 < n3) {
                            circleFitterStep.addDataPoint(dArray[n][2 * n4 + 1], dArray[n][2 * n4 + 2], false);
                            ++n4;
                        }
                        circleFitterStep.refreshCircle();
                        n4 = dArray[n].length - 1;
                        circleFitterStep.slider.setLocation(dArray[n][n4 - 1], dArray[n][n4]);
                    }
                }
                ++n;
            }
            circleFitter.setLocked(bl);
            circleFitter.dataValid = false;
            circleFitter.firePropertyChange("data", null, circleFitter);
            return object;
        }
    }
}

