/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.CenterOfMass;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class CenterOfMassInspector
extends JDialog
implements PropertyChangeListener {
    protected CenterOfMass cm;
    protected TrackerPanel trackerPanel;
    protected JButton okButton;
    protected JPanel checkboxPanel;
    protected ActionListener listener;
    protected boolean isVisible;

    public CenterOfMassInspector(CenterOfMass centerOfMass) {
        super(JOptionPane.getFrameForComponent(centerOfMass.trackerPanel), false);
        this.cm = centerOfMass;
        this.trackerPanel = this.cm.trackerPanel;
        if (this.trackerPanel != null) {
            this.trackerPanel.addPropertyChangeListener("track", this);
            TFrame tFrame = this.trackerPanel.getTFrame();
            if (tFrame != null) {
                tFrame.addPropertyChangeListener("tab", this);
            }
        }
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CenterOfMassInspector.this.updateCM();
            }
        };
        this.setResizable(false);
        this.createGUI();
        this.initialize();
        this.pack();
    }

    public void initialize() {
        this.updateDisplay();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("tab")) {
            if (this.trackerPanel != null && propertyChangeEvent.getNewValue() == this.trackerPanel) {
                this.setVisible(this.isVisible);
            } else {
                boolean bl = this.isVisible;
                this.setVisible(false);
                this.isVisible = bl;
            }
        } else {
            this.updateDisplay();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            FontSizer.setFonts(this, FontSizer.getLevel());
            this.pack();
        }
        super.setVisible(bl);
        this.isVisible = bl;
    }

    @Override
    public void dispose() {
        this.checkboxPanel.removeAll();
        if (this.trackerPanel != null) {
            this.trackerPanel.removePropertyChangeListener("track", this);
            for (PointMass propertyChangeListener2 : this.trackerPanel.getDrawables(PointMass.class)) {
                propertyChangeListener2.removePropertyChangeListener("name", this);
                propertyChangeListener2.removePropertyChangeListener("color", this);
                propertyChangeListener2.removePropertyChangeListener("footprint", this);
            }
            TFrame tFrame = this.trackerPanel.getTFrame();
            if (tFrame != null) {
                tFrame.removePropertyChangeListener("tab", this);
            }
        }
        super.dispose();
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        this.checkboxPanel = new JPanel(new GridLayout(0, 1));
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, TrackerRes.getString("CenterOfMassInspector.Border.Title"));
        this.checkboxPanel.setBorder(titledBorder);
        jPanel.add((Component)this.checkboxPanel, "Center");
        this.okButton = new JButton(TrackerRes.getString("Dialog.Button.OK"));
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CenterOfMassInspector.this.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        jPanel.add((Component)jPanel2, "South");
        Box box = Box.createHorizontalBox();
        jPanel2.add(box);
        jPanel2.add(this.okButton);
        box = Box.createHorizontalBox();
        jPanel2.add(box);
    }

    private void updateCM() {
        Component[] componentArray = this.checkboxPanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)componentArray[n];
            PointMass pointMass = this.getPointMass(jCheckBoxMenuItem.getActionCommand());
            if (jCheckBoxMenuItem.isSelected() && !this.cm.containsMass(pointMass)) {
                this.cm.addMass(pointMass);
            }
            if (!jCheckBoxMenuItem.isSelected() && this.cm.containsMass(pointMass)) {
                this.cm.removeMass(pointMass);
            }
            ++n;
        }
        this.cm.trackerPanel.repaint();
    }

    private PointMass getPointMass(String string) {
        ArrayList<PointMass> arrayList = this.trackerPanel.getDrawables(PointMass.class);
        for (PointMass pointMass : arrayList) {
            if (pointMass.getName() != string) continue;
            return pointMass;
        }
        return null;
    }

    protected void updateDisplay() {
        this.setTitle(String.valueOf(TrackerRes.getString("CenterOfMassInspector.Title")) + " \"" + this.cm.getName() + "\"");
        this.checkboxPanel.removeAll();
        for (PointMass pointMass : this.trackerPanel.getDrawables(PointMass.class)) {
            pointMass.removePropertyChangeListener("name", this);
            pointMass.removePropertyChangeListener("color", this);
            pointMass.removePropertyChangeListener("footprint", this);
            pointMass.addPropertyChangeListener("name", this);
            pointMass.addPropertyChangeListener("color", this);
            pointMass.addPropertyChangeListener("footprint", this);
            if (pointMass instanceof CenterOfMass) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(pointMass.getName(), pointMass.getFootprint().getIcon(21, 16));
            if (this.cm.containsMass(pointMass)) {
                jCheckBoxMenuItem.setSelected(true);
            }
            jCheckBoxMenuItem.addActionListener(this.listener);
            this.checkboxPanel.add(jCheckBoxMenuItem);
        }
        FontSizer.setFonts(this.checkboxPanel, FontSizer.getLevel());
        this.pack();
        this.repaint();
    }
}

