/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.CalibrationStep;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.FontSizer;

public class Calibration
extends TTrack {
    protected static final int X_AXIS = 2;
    protected static final int XY_AXES = 1;
    protected static final int Y_AXIS = 0;
    protected NumberField x1Field;
    protected NumberField y1Field;
    protected JLabel point1Label;
    protected JLabel point2Label;
    protected JLabel x1Label;
    protected JLabel y1Label;
    private Component spinnerSeparator;
    private Component[] fieldSeparators = new Component[3];
    protected boolean[] isWorldDataValid = new boolean[2];
    protected ArrayList<String> axisList = new ArrayList();
    protected JSpinner axisSpinner;
    protected ChangeListener axisListener;
    protected JLabel axisLabel = new JLabel();
    protected int axes = 1;
    protected int spinnerTextWidth;
    protected boolean fixedCoordinates = true;
    protected JCheckBoxMenuItem fixedCoordinatesItem;

    public Calibration() {
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.BoldCrosshair"), PointShapeFootprint.getFootprint("Footprint.Crosshair")});
        this.setName(TrackerRes.getString("Calibration.New.Name"));
        this.setColor(this.defaultColors[0]);
        this.viewable = false;
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("Calibration.Unmarked.Hint");
        this.keyFrames.add(0);
        this.createGUI();
    }

    public void setAxisType(int n) {
        if (n == 2 || n == 0 || n == 1) {
            this.axes = n;
        }
    }

    @Override
    public Step createStep(int n, double d, double d2) {
        if (this.isLocked()) {
            return null;
        }
        CalibrationStep calibrationStep = (CalibrationStep)this.getStep(n);
        if (calibrationStep == null) {
            calibrationStep = new CalibrationStep(this, n, d, d2);
            calibrationStep.setFootprint(this.getFootprint());
            this.steps = new TTrack.StepArray(this, calibrationStep);
        } else if (calibrationStep.getPoints()[1] == null) {
            if (this.trackerPanel != null && this.trackerPanel.getSelectedPoint() == calibrationStep.getPoints()[0]) {
                this.trackerPanel.setSelectedPoint(null);
            }
            calibrationStep.addSecondPoint(d, d2);
            this.steps = new TTrack.StepArray(this, calibrationStep);
        } else if (this.trackerPanel != null) {
            TPoint tPoint = this.trackerPanel.getSelectedPoint();
            if (tPoint == null) {
                tPoint = calibrationStep.getPosition(1);
            }
            if (tPoint instanceof CalibrationStep.Position) {
                XMLControlElement xMLControlElement = new XMLControlElement(calibrationStep);
                tPoint.setLocation(d, d2);
                Point2D point2D = tPoint.getWorldPosition(this.trackerPanel);
                if (calibrationStep.points[0] == tPoint) {
                    calibrationStep.setWorldCoordinates(point2D.getX(), point2D.getY(), calibrationStep.worldX1, calibrationStep.worldY1);
                } else {
                    calibrationStep.setWorldCoordinates(calibrationStep.worldX0, calibrationStep.worldY0, point2D.getX(), point2D.getY());
                }
                Undo.postStepEdit(calibrationStep, xMLControlElement);
            }
        }
        this.support.firePropertyChange("step", null, (Object)n);
        return calibrationStep;
    }

    public Step createStep(int n, double d, double d2, double d3, double d4) {
        this.createStep(n, d, d2);
        Step step = this.createStep(n, d3, d4);
        return step;
    }

    @Override
    public TPoint autoMarkAt(int n, double d, double d2) {
        CalibrationStep calibrationStep = (CalibrationStep)this.getStep(n);
        int n2 = this.getTargetIndex();
        ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
        imageCoordSystem.setFixedOrigin(false);
        imageCoordSystem.setFixedAngle(false);
        imageCoordSystem.setFixedScale(false);
        if (calibrationStep == null) {
            calibrationStep = (CalibrationStep)this.createStep(n, d, d2);
            if (calibrationStep != null) {
                return calibrationStep.getPoints()[n2];
            }
        } else {
            TPoint tPoint = calibrationStep.getPoints()[n2];
            if (tPoint == null) {
                if (this.trackerPanel != null && this.trackerPanel.getSelectedPoint() == calibrationStep.getPoints()[0]) {
                    this.trackerPanel.setSelectedPoint(null);
                }
                calibrationStep.addSecondPoint(d, d2);
                this.steps = new TTrack.StepArray(this, calibrationStep);
                return calibrationStep.getPoints()[n2];
            }
            Mark mark = (Mark)calibrationStep.marks.get(this.trackerPanel);
            if (mark == null) {
                double d3 = n2 == 0 ? calibrationStep.worldX0 : calibrationStep.worldX1;
                double d4 = n2 == 0 ? calibrationStep.worldY0 : calibrationStep.worldY1;
                double d5 = imageCoordSystem.worldToImageX(n, d3, d4);
                double d6 = imageCoordSystem.worldToImageY(n, d3, d4);
                tPoint.setLocation(d5, d6);
            }
            tPoint.setAdjusting(true);
            tPoint.setXY(d, d2);
            tPoint.setAdjusting(false);
            return tPoint;
        }
        return null;
    }

    @Override
    public Step getStep(int n) {
        CalibrationStep calibrationStep = (CalibrationStep)this.steps.getStep(n);
        this.refreshStep(calibrationStep);
        return calibrationStep;
    }

    @Override
    public boolean isLocked() {
        boolean bl = super.isLocked();
        if (this.trackerPanel != null) {
            bl = bl || this.trackerPanel.getCoords().isLocked();
        }
        return bl;
    }

    @Override
    public void setTrailVisible(boolean bl) {
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    public int getStepLength() {
        return CalibrationStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    public boolean isFixedCoordinates() {
        return this.fixedCoordinates;
    }

    public void setFixedCoordinates(boolean bl) {
        if (this.fixedCoordinates == bl) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (this.trackerPanel != null) {
            this.trackerPanel.changed = true;
            int n = this.trackerPanel.getFrameNumber();
            Step step = this.getStep(n);
            if (step != null) {
                this.steps = new TTrack.StepArray(this, this.getStep(n));
            }
            this.trackerPanel.repaint();
        }
        if (bl) {
            this.keyFrames.clear();
            this.keyFrames.add(0);
        }
        this.fixedCoordinates = bl;
        Undo.postTrackEdit(this, xMLControlElement);
    }

    @Override
    public void setFootprint(String string) {
        super.setFootprint(string);
        this.setAxisType(this.axes);
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof TrackerPanel && this.isVisible() && this.isEnabled())) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Interactive interactive = null;
        int n3 = trackerPanel.getFrameNumber();
        Step step = this.getStep(n3);
        if (step != null && trackerPanel.getPlayer().getVideoClip().includesFrame(n3)) {
            interactive = step.findInteractive(trackerPanel, n, n2);
        }
        if (interactive != null) {
            this.partName = TrackerRes.getString("Calibration.Point.Name");
            this.hint = TrackerRes.getString("Calibration.Point.Hint");
        } else {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = TrackerRes.getString("Calibration.Halfmarked.Hint");
        }
        return interactive;
    }

    @Override
    public void setLocked(boolean bl) {
        super.setLocked(bl);
        boolean bl2 = !this.isLocked();
        this.xField.setEnabled(bl2);
        this.yField.setEnabled(bl2);
        this.x1Field.setEnabled(bl2);
        this.y1Field.setEnabled(bl2);
        if (this.axisSpinner != null) {
            this.axisSpinner.setEnabled(bl2);
        }
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        JMenu jMenu = super.getMenu(trackerPanel);
        this.lockedItem.setEnabled(!trackerPanel.getCoords().isLocked());
        jMenu.remove(this.deleteTrackItem);
        jMenu.remove(jMenu.getMenuComponent(jMenu.getMenuComponentCount() - 1));
        this.fixedCoordinatesItem.setText(TrackerRes.getString("OffsetOrigin.MenuItem.Fixed"));
        this.fixedCoordinatesItem.setSelected(this.isFixedCoordinates());
        jMenu.add(this.fixedCoordinatesItem);
        jMenu.addSeparator();
        jMenu.add(this.deleteTrackItem);
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        boolean bl;
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        this.axisList.clear();
        String string = TrackerRes.getString("Calibration.Axes.YOnly");
        this.axisList.add(string);
        String string2 = TrackerRes.getString("Calibration.Axes.XY");
        this.axisList.add(string2);
        String string3 = TrackerRes.getString("Calibration.Axes.XOnly");
        this.axisList.add(string3);
        SpinnerListModel spinnerListModel = new SpinnerListModel(this.axisList);
        this.axisSpinner = new JSpinner(spinnerListModel){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width += Calibration.this.spinnerTextWidth / 2;
                return dimension;
            }
        };
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.axisSpinner.getEditor()).getTextField();
        jFormattedTextField.setDisabledTextColor(NumberField.DISABLED_COLOR);
        String string4 = string2;
        string4 = string3.length() > string4.length() ? string3 : string4;
        string4 = string.length() > string4.length() ? string : string4;
        Font font = this.axisSpinner.getFont().deriveFont(0);
        FontSizer.setFonts(this.axisSpinner, FontSizer.getLevel());
        TextLayout textLayout = new TextLayout(string4, font, frc);
        this.spinnerTextWidth = (int)textLayout.getBounds().getWidth();
        spinnerListModel.setValue(this.axes == 1 ? string2 : (this.axes == 2 ? string3 : string));
        this.axisSpinner.addChangeListener(this.axisListener);
        this.axisSpinner.setToolTipText(TrackerRes.getString("Calibration.Spinner.Axes.Tooltip"));
        this.axisLabel.setText(TrackerRes.getString("Calibration.Label.Axes"));
        Border border = BorderFactory.createEmptyBorder(0, 4, 0, 2);
        this.axisLabel.setBorder(border);
        arrayList.add(this.axisLabel);
        arrayList.add(this.axisSpinner);
        arrayList.add(this.spinnerSeparator);
        int n = trackerPanel.getFrameNumber();
        Step step = this.getStep(n);
        String string5 = TrackerRes.getString("Calibration.Label.Point");
        String string6 = TrackerRes.getString("TTrack.Label.Unmarked");
        this.point1Label.setText(String.valueOf(string5) + " 1: ");
        this.point2Label.setText(String.valueOf(string5) + " 2: ");
        this.point1Label.setForeground(this.yLabel.getForeground());
        this.point2Label.setForeground(this.yLabel.getForeground());
        boolean bl2 = step != null;
        boolean bl3 = bl = bl2 && step.getPoints()[1] != null;
        if (!bl2) {
            this.point1Label.setText(String.valueOf(string5) + " 1: " + string6);
            this.point1Label.setForeground(Color.red.darker());
        } else if (!bl) {
            this.point2Label.setText(String.valueOf(string5) + " 2: " + string6);
            this.point2Label.setForeground(Color.red.darker());
        }
        if (this.axes == 0) {
            arrayList.add(this.point1Label);
            if (bl2) {
                arrayList.add(this.yLabel);
                arrayList.add(this.yField);
                arrayList.add(this.fieldSeparators[1]);
                arrayList.add(this.point2Label);
                if (bl) {
                    arrayList.add(this.y1Label);
                    arrayList.add(this.y1Field);
                }
            }
        } else if (this.axes == 2) {
            arrayList.add(this.point1Label);
            if (bl2) {
                arrayList.add(this.xLabel);
                arrayList.add(this.xField);
                arrayList.add(this.fieldSeparators[1]);
                arrayList.add(this.point2Label);
                if (bl) {
                    arrayList.add(this.x1Label);
                    arrayList.add(this.x1Field);
                }
            }
        } else {
            arrayList.add(this.point1Label);
            if (bl2) {
                arrayList.add(this.xLabel);
                arrayList.add(this.xField);
                arrayList.add(this.fieldSeparators[0]);
                arrayList.add(this.yLabel);
                arrayList.add(this.yField);
                arrayList.add(this.fieldSeparators[1]);
                arrayList.add(this.point2Label);
                if (bl) {
                    arrayList.add(this.x1Label);
                    arrayList.add(this.x1Field);
                    arrayList.add(this.fieldSeparators[2]);
                    arrayList.add(this.y1Label);
                    arrayList.add(this.y1Field);
                }
            }
        }
        boolean bl4 = trackerPanel.getCoords().isLocked() || super.isLocked();
        this.xField.setEnabled(!bl4);
        this.yField.setEnabled(!bl4);
        this.x1Field.setEnabled(!bl4);
        this.y1Field.setEnabled(!bl4);
        this.axisSpinner.setEnabled(!bl4);
        this.displayWorldCoordinates();
        return arrayList;
    }

    protected void refreshStep(CalibrationStep calibrationStep) {
        boolean bl;
        if (calibrationStep == null) {
            return;
        }
        int n = 0;
        Iterator iterator = this.keyFrames.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n2 > calibrationStep.n) continue;
            n = n2;
        }
        CalibrationStep calibrationStep2 = (CalibrationStep)this.steps.getStep(n);
        boolean bl2 = bl = calibrationStep2.worldX0 != calibrationStep.worldX0 || calibrationStep2.worldY0 != calibrationStep.worldY0 || calibrationStep2.worldX1 != calibrationStep.worldX1 || calibrationStep2.worldY1 != calibrationStep.worldY1;
        if (bl) {
            calibrationStep.worldX0 = calibrationStep2.worldX0;
            calibrationStep.worldY0 = calibrationStep2.worldY0;
            calibrationStep.worldX1 = calibrationStep2.worldX1;
            calibrationStep.worldY1 = calibrationStep2.worldY1;
        }
        calibrationStep.erase();
    }

    @Override
    public void setFontLevel(int n) {
        super.setFontLevel(n);
        Object[] objectArray = new Object[]{this.point1Label, this.point2Label, this.x1Label, this.y1Label, this.x1Field, this.y1Field, this.axisLabel, this.fixedCoordinatesItem};
        FontSizer.setFonts(objectArray, n);
    }

    @Override
    public String toString() {
        return TrackerRes.getString("Calibration.Name");
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("stepnumber")) {
            if (this.trackerPanel.getSelectedTrack() == this) {
                this.displayWorldCoordinates();
            }
        } else if (string.equals("locked")) {
            boolean bl = !this.isLocked();
            this.xField.setEnabled(bl);
            this.yField.setEnabled(bl);
            this.x1Field.setEnabled(bl);
            this.y1Field.setEnabled(bl);
            this.axisSpinner.setEnabled(bl);
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    protected int getTargetIndex() {
        return super.getTargetIndex();
    }

    @Override
    protected String getTargetDescription(int n) {
        String string = TrackerRes.getString("Calibration.Point.Name");
        return String.valueOf(string) + " " + (n + 1);
    }

    private void setWorldCoordinatesFromFields() {
        boolean bl;
        if (this.trackerPanel == null) {
            return;
        }
        double d = this.xField.getValue();
        double d2 = this.yField.getValue();
        double d3 = this.x1Field.getValue();
        double d4 = this.y1Field.getValue();
        int n = this.trackerPanel.getFrameNumber();
        CalibrationStep calibrationStep = (CalibrationStep)this.getStep(n);
        boolean bl2 = bl = calibrationStep.worldX0 != d || calibrationStep.worldY0 != d2 || calibrationStep.worldX1 != d3 || calibrationStep.worldY1 != d4;
        if (bl) {
            XMLControlElement xMLControlElement = new XMLControlElement(this);
            XMLControlElement xMLControlElement2 = new XMLControlElement(this.trackerPanel.getCoords());
            calibrationStep.setWorldCoordinates(d, d2, d3, d4);
            Undo.postTrackAndCoordsEdit(this, xMLControlElement, xMLControlElement2);
        }
    }

    protected void displayWorldCoordinates() {
        int n = this.trackerPanel == null ? 0 : this.trackerPanel.getFrameNumber();
        CalibrationStep calibrationStep = (CalibrationStep)this.getStep(n);
        if (calibrationStep == null) {
            this.xField.setText(null);
            this.yField.setText(null);
            this.x1Field.setText(null);
            this.y1Field.setText(null);
        } else if (calibrationStep.getPoints()[1] == null) {
            this.xField.setValue(calibrationStep.worldX0);
            this.yField.setValue(calibrationStep.worldY0);
            this.x1Field.setText(null);
            this.y1Field.setText(null);
        } else {
            this.xField.setValue(calibrationStep.worldX0);
            this.yField.setValue(calibrationStep.worldY0);
            this.x1Field.setValue(calibrationStep.worldX1);
            this.y1Field.setValue(calibrationStep.worldY1);
        }
    }

    private void createGUI() {
        this.fixedCoordinatesItem = new JCheckBoxMenuItem(TrackerRes.getString("OffsetOrigin.MenuItem.Fixed"));
        this.fixedCoordinatesItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Calibration.this.setFixedCoordinates(Calibration.this.fixedCoordinatesItem.isSelected());
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Calibration.this.setWorldCoordinatesFromFields();
                ((NumberField)actionEvent.getSource()).requestFocusInWindow();
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Calibration.this.setWorldCoordinatesFromFields();
            }
        };
        this.x1Field = new NumberField(5);
        this.x1Field.setBorder(this.fieldBorder);
        this.y1Field = new NumberField(5);
        this.y1Field.setBorder(this.fieldBorder);
        this.xField.addActionListener(actionListener);
        this.xField.addFocusListener(focusAdapter);
        this.yField.addActionListener(actionListener);
        this.yField.addFocusListener(focusAdapter);
        this.x1Field.addActionListener(actionListener);
        this.x1Field.addFocusListener(focusAdapter);
        this.y1Field.addActionListener(actionListener);
        this.y1Field.addFocusListener(focusAdapter);
        this.point1Label = new JLabel();
        this.point2Label = new JLabel();
        this.point1Label.setBorder(this.xLabel.getBorder());
        this.point2Label.setBorder(this.yLabel.getBorder());
        this.x1Label = new JLabel("x");
        this.y1Label = new JLabel("y");
        this.x1Label.setBorder(this.xLabel.getBorder());
        this.y1Label.setBorder(this.yLabel.getBorder());
        this.fieldSeparators[0] = Box.createRigidArea(new Dimension(4, 4));
        this.fieldSeparators[1] = Box.createRigidArea(new Dimension(8, 4));
        this.fieldSeparators[2] = Box.createRigidArea(new Dimension(4, 4));
        this.axisListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                String string = (String)Calibration.this.axisSpinner.getValue();
                int n = 0;
                while (n < Calibration.this.axisList.size()) {
                    if (Calibration.this.axisList.get(n).equals(string)) {
                        if (Calibration.this.axes == n) {
                            return;
                        }
                        if (Calibration.this.trackerPanel != null) {
                            boolean bl;
                            int n2 = Calibration.this.trackerPanel.getFrameNumber();
                            CalibrationStep calibrationStep = (CalibrationStep)Calibration.this.getStep(n2);
                            boolean bl2 = bl = calibrationStep != null && calibrationStep.getPoints()[1] != null;
                            if (bl) {
                                if (n == 2 && calibrationStep.worldX0 == calibrationStep.worldX1) {
                                    JOptionPane.showMessageDialog(Calibration.this.trackerPanel, TrackerRes.getString("Calibration.Dialog.InvalidXCoordinates.Message"), TrackerRes.getString("Calibration.Dialog.InvalidCoordinates.Title"), 2);
                                    Calibration.this.axisSpinner.setValue(Calibration.this.axisList.get(Calibration.this.axes));
                                    return;
                                }
                                if (n == 0 && calibrationStep.worldY0 == calibrationStep.worldY1) {
                                    JOptionPane.showMessageDialog(Calibration.this.trackerPanel, TrackerRes.getString("Calibration.Dialog.InvalidYCoordinates.Message"), TrackerRes.getString("Calibration.Dialog.InvalidCoordinates.Title"), 2);
                                    Calibration.this.axisSpinner.setValue(Calibration.this.axisList.get(Calibration.this.axes));
                                    return;
                                }
                            }
                        }
                        Calibration.this.setAxisType(n);
                        if (Calibration.this.trackerPanel != null) {
                            Calibration.this.trackerPanel.getTFrame().getTrackBar(Calibration.this.trackerPanel).refresh();
                        }
                    }
                    ++n;
                }
            }
        };
        this.spinnerSeparator = Box.createRigidArea(new Dimension(8, 4));
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            Object object2;
            Calibration calibration = (Calibration)object;
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            xMLControl.setValue("fixed_coordinates", calibration.isFixedCoordinates());
            if (!calibration.steps.isEmpty()) {
                object2 = calibration.getSteps();
                double[][] dArrayArray = new double[((Step[])object2).length][];
                int n = 0;
                while (n < ((Step[])object2).length) {
                    if (object2[n] != null && calibration.keyFrames.contains(n)) {
                        CalibrationStep calibrationStep = (CalibrationStep)object2[n];
                        dArrayArray[n] = new double[]{calibrationStep.worldX0, calibrationStep.worldY0, calibrationStep.worldX1, calibrationStep.worldY1};
                        if (!xMLControl.getPropertyNames().contains("worldX0")) {
                            xMLControl.setValue("worldX0", calibrationStep.worldX0);
                            xMLControl.setValue("worldY0", calibrationStep.worldY0);
                            xMLControl.setValue("worldX1", calibrationStep.worldX1);
                            xMLControl.setValue("worldY1", calibrationStep.worldY1);
                        }
                    }
                    ++n;
                }
                xMLControl.setValue("world_coordinates", dArrayArray);
            }
            object2 = calibration.axes == 2 ? "X" : (calibration.axes == 0 ? "Y" : "XY");
            xMLControl.setValue("axes", object2);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new Calibration();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            double[][] dArray;
            Calibration calibration = (Calibration)object;
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            boolean bl = calibration.isLocked();
            calibration.setLocked(false);
            String string = xMLControl.getString("axes");
            if (string != null) {
                calibration.setAxisType(string.equals("X") ? 2 : (string.equals("Y") ? 0 : 1));
            }
            if (xMLControl.getPropertyNames().contains("fixed_coordinates")) {
                calibration.fixedCoordinates = xMLControl.getBoolean("fixed_coordinates");
            }
            calibration.keyFrames.clear();
            if (calibration.steps.isEmpty()) {
                calibration.createStep(0, 0.0, 0.0, 1.0, 0.0);
            }
            if ((dArray = (double[][])xMLControl.getObject("world_coordinates")) != null) {
                int n = 0;
                while (n < dArray.length) {
                    if (dArray[n] != null) {
                        CalibrationStep calibrationStep = (CalibrationStep)calibration.getStep(n);
                        calibrationStep.worldX0 = dArray[n][0];
                        calibrationStep.worldY0 = dArray[n][1];
                        calibrationStep.worldX1 = dArray[n][2];
                        calibrationStep.worldY1 = dArray[n][3];
                        calibration.keyFrames.add(n);
                    }
                    ++n;
                }
            } else {
                CalibrationStep calibrationStep = (CalibrationStep)calibration.getStep(0);
                calibrationStep.worldX0 = xMLControl.getDouble("worldX0");
                calibrationStep.worldY0 = xMLControl.getDouble("worldY0");
                calibrationStep.worldX1 = xMLControl.getDouble("worldX1");
                calibrationStep.worldY1 = xMLControl.getDouble("worldY1");
                calibration.keyFrames.add(0);
            }
            calibration.setLocked(bl);
            calibration.displayWorldCoordinates();
            return object;
        }
    }
}

