/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import org.opensourcephysics.cabrillo.tracker.BounceMatrix;
import org.opensourcephysics.cabrillo.tracker.BounceModel;

public class BounceParameters {
    private final BounceModel model;
    private final BounceMatrix params;
    private final double square_error;
    private final double initial_step_at;
    private final double[] initial_step_size;

    public BounceParameters(BounceModel bounceModel, BounceMatrix bounceMatrix, double d) {
        this.model = bounceModel;
        this.params = bounceMatrix;
        this.square_error = d;
        this.initial_step_at = 0.0;
        this.initial_step_size = null;
    }

    public BounceParameters(BounceModel bounceModel, BounceMatrix bounceMatrix, double d, double d2, double[] dArray) {
        this.model = bounceModel;
        this.params = bounceMatrix;
        this.square_error = d;
        this.initial_step_at = d2;
        this.initial_step_size = dArray;
    }

    public final BounceModel getModel() {
        return this.model;
    }

    public final BounceMatrix getParams() {
        return this.params;
    }

    public final double getError() {
        return this.square_error;
    }

    public double getStepAt() {
        double d = this.model.getStepAt(this.params);
        if (this.initial_step_size == null) {
            return d;
        }
        if (!this.model.usesStep() || d == this.initial_step_at) {
            return this.initial_step_at;
        }
        throw new RuntimeException("LinearModelParams with steps at different times");
    }

    public double[] getStepSize() {
        int n;
        int n2 = this.params.getColumnDimension();
        double[] dArray = new double[n2];
        if (this.initial_step_size != null) {
            n = 0;
            while (n < dArray.length) {
                dArray[n] = this.initial_step_size[n];
                ++n;
            }
            if (this.model.usesStep() && this.model.getStepAt() != this.initial_step_at) {
                throw new RuntimeException("LinearModelParams getStepSize with steps at different times");
            }
        }
        if (!this.model.usesStep()) {
            return dArray;
        }
        n = this.params.getRowDimension() - 1;
        double[][] dArray2 = this.params.getArray();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3;
            dArray[n4] = dArray[n4] + dArray2[n][n3];
            ++n3;
        }
        return dArray;
    }

    public double[] first_deriv(double d) {
        double[] dArray = this.model.first_deriv(this.params, d);
        if (this.initial_step_size != null && this.initial_step_at < d) {
            int n = 0;
            while (n < dArray.length) {
                int n2 = n;
                dArray[n2] = dArray[n2] + this.initial_step_size[n];
                ++n;
            }
        }
        return dArray;
    }

    public double[] second_deriv(double d) {
        double[] dArray = this.model.second_deriv(this.params, d);
        if (this.initial_step_size != null && Math.round(this.initial_step_at - d) == 0L) {
            int n = 0;
            while (n < dArray.length) {
                int n2 = n;
                dArray[n2] = dArray[n2] + this.initial_step_size[n];
                ++n;
            }
        }
        return dArray;
    }
}

