/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.util.Arrays;
import java.util.Comparator;
import org.opensourcephysics.cabrillo.tracker.BounceModel;
import org.opensourcephysics.cabrillo.tracker.BounceParameters;
import org.opensourcephysics.cabrillo.tracker.Derivative;

public class BounceDerivatives
implements Derivative {
    private int window_size;
    private final int degree = 2;
    private BounceModel poly_model;
    private BounceModel step_model;

    @Override
    public Object[] evaluate(Object[] objectArray) {
        int n;
        int n2;
        int n3;
        int[] nArray = (int[])objectArray[0];
        this.window_size = 1 + nArray[0] * 2;
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        double[] dArray = (double[])objectArray[1];
        double[] dArray2 = (double[])objectArray[2];
        boolean[] blArray = (boolean[])objectArray[3];
        int n7 = dArray.length;
        assert (dArray.length == dArray2.length);
        double[][] dArrayArray = new double[4][];
        double[] dArray3 = new double[n7];
        dArrayArray[0] = dArray3;
        double[] dArray4 = new double[n7];
        dArrayArray[1] = dArray4;
        double[] dArray5 = new double[n7];
        dArrayArray[2] = dArray5;
        double[] dArray6 = new double[n7];
        dArrayArray[3] = dArray6;
        int n8 = 0;
        while (n8 < n7) {
            dArray4[n8] = Double.NaN;
            dArray3[n8] = Double.NaN;
            dArray6[n8] = Double.NaN;
            dArray5[n8] = Double.NaN;
            if (!blArray[n8]) {
                dArray2[n8] = Double.NaN;
                dArray[n8] = Double.NaN;
            }
            ++n8;
        }
        if (n4 >= n7) {
            return dArrayArray;
        }
        n6 = Math.min(n6, (n7 - n4) / n5);
        assert (n4 >= 0);
        assert (n4 < n7);
        assert (n5 > 0);
        this.poly_model = new BounceModel(this.window_size, 2, 0.0);
        BounceParameters[] bounceParametersArray = new BounceParameters[n6];
        this.step_model = new BounceModel(this.window_size, 2, Double.NaN);
        BounceParameters[] bounceParametersArray2 = new BounceParameters[n6];
        int[] nArray2 = new int[n6];
        int n9 = 0;
        while (n9 < n6) {
            n3 = n4 + n5 * n9;
            nArray2[n9] = this.window_size / 2;
            int n10 = -1;
            n2 = this.window_size - 1;
            while (n2 >= 0) {
                n = n3 + n5 * (n2 - nArray2[n9]);
                if (n < 0 || n >= n7 || Double.isNaN(dArray[n]) || Double.isNaN(dArray2[n])) {
                    n10 = n2;
                    break;
                }
                --n2;
            }
            if (n10 >= 0) {
                int n11;
                n2 = this.window_size;
                n = 0;
                while (n < this.window_size) {
                    n11 = n3 + n5 * (n - nArray2[n9]);
                    if (n11 < 0 || n11 >= n7 || Double.isNaN(dArray[n11]) || Double.isNaN(dArray2[n11])) {
                        n2 = n;
                        break;
                    }
                    ++n;
                }
                n = n10 + 1;
                n11 = this.window_size - n2;
                int n12 = n9;
                nArray2[n12] = nArray2[n12] - (n <= n11 ? n : 0 - n11);
                int n13 = this.window_size - 1;
                while (n13 >= 0) {
                    int n14 = n3 + n5 * (n13 - nArray2[n9]);
                    if (n14 >= 0 && n14 < n7 && !Double.isNaN(dArray[n14]) && !Double.isNaN(dArray2[n14])) {
                        --n13;
                        continue;
                    }
                    break;
                }
            } else {
                bounceParametersArray[n9] = this.poly_model.fit_xy(dArray, dArray2, n3 - nArray2[n9] * n5, n5);
                bounceParametersArray2[n9] = this.step_model.fit_xy(dArray, dArray2, n3 - nArray2[n9] * n5, n5);
            }
            ++n9;
        }
        final double[] dArray7 = new double[n6];
        n3 = 0;
        while (n3 < n6) {
            double d;
            if (bounceParametersArray2[n3] != null && (d = bounceParametersArray2[n3].getStepAt()) != 0.0) {
                n = n4 + n5 * n3;
                double d2 = (double)n + (double)n5 * (d - (double)nArray2[n3]);
                double[] dArray8 = bounceParametersArray2[n3].getStepSize();
                int n15 = Math.max(n4, (int)(d2 - 0.5 * (double)(this.window_size - 1) + 0.999));
                while (n15 <= Math.min(n7 - 1, (int)(d2 + 0.5 * (double)(this.window_size - 1) + 0.001))) {
                    int n16 = (n15 - n4) / n5;
                    if (n16 < n6) {
                        if (n16 < 0 || n16 >= n6) {
                            System.out.format("ERROR: c_wind=%d, i_wind=%d, start=%d, i_step_time=%.3f\n", n16, n15, n4, d2);
                        }
                        if (bounceParametersArray[n16] != null) {
                            double d3 = bounceParametersArray[n16].getError();
                            BounceParameters bounceParameters = this.poly_model.fit_xy(dArray, dArray2, n15 - nArray2[n16] * n5, n5, (d2 - (double)n15) / (double)n5 + (double)nArray2[n16], dArray8);
                            double d4 = bounceParameters.getError();
                            int n17 = n3;
                            dArray7[n17] = dArray7[n17] + (d3 - d4);
                        }
                    }
                    ++n15;
                }
            }
            ++n3;
        }
        Integer[] integerArray = new Integer[n6];
        int n18 = 0;
        while (n18 < n6) {
            integerArray[n18] = n18;
            ++n18;
        }
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return Double.compare(dArray7[n2], dArray7[n]);
            }
        });
        BounceParameters[] bounceParametersArray3 = new BounceParameters[n6];
        n2 = 0;
        while (n2 < n6) {
            double d;
            double d5;
            double d6;
            n = integerArray[n2];
            if (bounceParametersArray3[n] == null && bounceParametersArray2[n] != null && !(dArray7[n] < (d6 = 0.6 * (double)this.window_size) * (d5 = bounceParametersArray[n].getError())) && (d = bounceParametersArray2[n].getStepAt()) != 0.0) {
                double d7 = (double)n + d - (double)nArray2[n];
                double[] dArray9 = bounceParametersArray2[n].getStepSize();
                int n19 = (int)d7;
                int n20 = Math.max(0, n19 - this.window_size + 2);
                while (n20 < n19 + this.window_size && n20 < n6) {
                    int n21 = n4 + n5 * n20;
                    if (n21 >= n4 && n21 < n7 && !(d7 <= (double)(n20 - nArray2[n20])) && !(d7 >= (double)(n20 - nArray2[n20] + this.window_size - 1)) && bounceParametersArray3[n20] == null && bounceParametersArray[n20] != null) {
                        BounceParameters bounceParameters;
                        bounceParametersArray3[n20] = bounceParameters = this.poly_model.fit_xy(dArray, dArray2, n21 - nArray2[n20] * n5, n5, d7 - (double)n20 + (double)nArray2[n20], dArray9);
                    }
                    ++n20;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n6) {
            n = n4 + n5 * n2;
            if (bounceParametersArray[n2] != null) {
                BounceParameters bounceParameters = bounceParametersArray3[n2];
                if (bounceParameters == null) {
                    bounceParameters = bounceParametersArray[n2];
                }
                double[] dArray10 = bounceParameters.first_deriv(nArray2[n2]);
                dArray3[n] = dArray10[0];
                dArray4[n] = dArray10[1];
                double[] dArray11 = bounceParameters.second_deriv(nArray2[n2]);
                dArray5[n] = dArray11[0];
                dArray6[n] = dArray11[1];
            }
            ++n2;
        }
        return dArrayArray;
    }
}

