/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackRenderer;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.TemplateMatcher;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class AutoTracker
implements Interactive,
Trackable,
PropertyChangeListener {
    private static Rectangle hitRect = new Rectangle(-4, -4, 8, 8);
    private static TPoint hitPt = new TPoint();
    private static Shape selectionShape;
    private static AffineTransform transform;
    private static Footprint target_footprint;
    private static Footprint inactive_target_footprint;
    private static Footprint corner_footprint;
    private static final float[] DOTTED_LINE;
    private static final float[] DASHED_LINE;
    private static NumberFormat format;
    private static double cornerFactor;
    private static BasicStroke solidBold;
    private static BasicStroke solid;
    private static BasicStroke dotted;
    private static BasicStroke dashed;
    private static int maxEvolveRate;
    private static int defaultEvolveRate;
    private static Icon searchIcon;
    private static Icon stopIcon;
    private static Icon graySearchIcon;
    private static double[] defaultMaskSize;
    private static double[] defaultSearchSize;
    private static int templateIconMagnification;
    private static int predictionLookback;
    private TrackerPanel trackerPanel;
    private TTrack track;
    private Wizard wizard;
    private Shape match = new Ellipse2D.Double();
    private double minMaskRadius = 4.0;
    private Handle maskHandle = new Handle();
    private Corner maskCorner = new Corner();
    private TPoint maskCenter = new TPoint();
    private Handle searchHandle = new Handle();
    private Corner searchCorner = new Corner();
    private TPoint searchCenter = new TPoint();
    private TPoint predictedTarget = new TPoint();
    private Rectangle2D searchRect2D = new Rectangle2D.Double();
    private Shape searchShape;
    private Shape maskShape;
    private Shape matchShape;
    private Shape searchHitShape;
    private Shape maskHitShape;
    private Mark mark;
    private Point[] screenPoints = new Point[]{new Point()};
    private boolean maskVisible;
    private boolean targetVisible;
    private boolean searchVisible;
    private Runnable stepper;
    private boolean stepping;
    private boolean active;
    private boolean paused;
    private boolean marking;
    private boolean lookAhead = true;
    private int goodMatch = 4;
    private int possibleMatch = 1;
    private int evolveAlpha = 63;
    private Map<TTrack, Map<Integer, Map<Integer, FrameData>>> trackFrameData = new HashMap<TTrack, Map<Integer, Map<Integer, FrameData>>>();
    private int lineSpread = -1;
    private boolean isInteracting;
    private double[][] derivatives1 = new double[predictionLookback - 1][];
    private double[][] derivatives2 = new double[predictionLookback - 1][];
    private double[][] derivatives3 = new double[predictionLookback - 1][];

    static {
        transform = new AffineTransform();
        target_footprint = PointShapeFootprint.getFootprint("Footprint.BoldCrosshair");
        inactive_target_footprint = PointShapeFootprint.getFootprint("Footprint.Crosshair");
        corner_footprint = PointShapeFootprint.getFootprint("Footprint.SolidSquare");
        DOTTED_LINE = new float[]{2.0f, 2.0f};
        DASHED_LINE = new float[]{2.0f, 8.0f};
        format = NumberFormat.getNumberInstance();
        cornerFactor = 0.9;
        solidBold = new BasicStroke(2.0f);
        solid = new BasicStroke();
        maxEvolveRate = 100;
        defaultEvolveRate = maxEvolveRate / 5;
        defaultMaskSize = new double[]{9.0, 9.0};
        defaultSearchSize = new double[]{40.0, 40.0};
        templateIconMagnification = 2;
        predictionLookback = 4;
        dotted = new BasicStroke(2.0f, 0, 0, 8.0f, DOTTED_LINE, 0.0f);
        dashed = new BasicStroke(2.0f, 0, 0, 8.0f, DASHED_LINE, 0.0f);
        selectionShape = solidBold.createStrokedShape(hitRect);
        format.setMinimumIntegerDigits(1);
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(1);
        String string = "/org/opensourcephysics/cabrillo/tracker/resources/images/green_light.gif";
        searchIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/cabrillo/tracker/resources/images/red_light.gif";
        stopIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/cabrillo/tracker/resources/images/gray_light.gif";
        graySearchIcon = ResourceLoader.getIcon(string);
    }

    public AutoTracker(TrackerPanel trackerPanel) {
        this.trackerPanel = trackerPanel;
        this.trackerPanel.addDrawable(this);
        this.trackerPanel.addPropertyChangeListener("selectedpoint", this);
        this.trackerPanel.addPropertyChangeListener("selectedtrack", this);
        this.trackerPanel.addPropertyChangeListener("video", this);
        this.trackerPanel.addPropertyChangeListener("stepnumber", this);
        this.stepper = new Runnable(){

            @Override
            public void run() {
                if (!AutoTracker.this.active || AutoTracker.this.track == null) {
                    return;
                }
                if (AutoTracker.this.markCurrentFrame(true)) {
                    if (!AutoTracker.this.canStep()) {
                        AutoTracker.this.stop(true, true);
                        return;
                    }
                    if (AutoTracker.this.stepping) {
                        AutoTracker.this.wizard.refreshInfo();
                        AutoTracker.this.repaint();
                        AutoTracker.this.trackerPanel.getPlayer().step();
                        return;
                    }
                    AutoTracker.this.stop(true, true);
                } else if (!AutoTracker.this.stepping) {
                    AutoTracker.this.stop(true, false);
                } else {
                    AutoTracker.this.paused = true;
                    if (AutoTracker.this.track instanceof PointMass) {
                        PointMass pointMass = (PointMass)AutoTracker.this.track;
                        pointMass.updateDerivatives();
                    }
                    AutoTracker.this.track.firePropertyChange("steps", null, null);
                    AutoTracker.this.wizard.refreshGUI();
                }
                AutoTracker.this.repaint();
            }
        };
        this.wizard = new Wizard();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.wizard.getBounds().width) / 2;
        int n2 = (dimension.height - this.wizard.getBounds().height) / 2;
        this.wizard.setLocation(n, n2);
    }

    protected void setTrack(TTrack tTrack) {
        if (tTrack != null && !tTrack.isAutoTrackable()) {
            tTrack = null;
        }
        if (this.track == tTrack) {
            return;
        }
        if (this.track != null) {
            this.track.removePropertyChangeListener("step", this);
            this.track.removePropertyChangeListener("name", this);
            this.track.removePropertyChangeListener("color", this);
            this.track.removePropertyChangeListener("footprint", this);
        }
        this.track = tTrack;
        if (this.track != null) {
            this.trackerPanel.setSelectedTrack(this.track);
        }
        if (this.track != null) {
            this.track.addPropertyChangeListener("step", this);
            this.track.addPropertyChangeListener("name", this);
            this.track.addPropertyChangeListener("color", this);
            this.track.addPropertyChangeListener("footprint", this);
            this.track.setVisible(true);
            int n = this.trackerPanel.getFrameNumber();
            FrameData frameData = this.getFrame(n);
            TPoint[] tPointArray = frameData.getSearchPoints(true);
            if (tPointArray != null) {
                this.setSearchPoints(tPointArray[0], tPointArray[1]);
            }
        }
        this.wizard.refreshGUI();
    }

    protected void addKeyFrame(TPoint tPoint, double d, double d2) {
        int n = this.trackerPanel.getFrameNumber();
        Target target = new Target();
        Ellipse2D.Double double_ = new Ellipse2D.Double();
        this.maskCenter.setLocation(d, d2);
        this.maskCorner.setLocation(d + defaultMaskSize[0], d2 + defaultMaskSize[1]);
        this.searchCenter.setLocation(d, d2);
        this.searchCorner.setLocation(d + defaultSearchSize[0], d2 + defaultSearchSize[1]);
        Map<Integer, FrameData> map = this.getFrameData();
        KeyFrame keyFrame = new KeyFrame(tPoint, double_, target);
        map.put(n, keyFrame);
        this.clearSearchPointsDownstream();
        this.refreshSearchRect();
        this.refreshKeyFrame(keyFrame);
        this.getWizard().setVisible(true);
        this.trackerPanel.repaint();
    }

    protected void search(boolean bl, boolean bl2) {
        this.stepping = this.stepping || bl2;
        this.wizard.changed = false;
        this.active = true;
        this.paused = false;
        if (!bl || this.markCurrentFrame(false)) {
            if (this.canStep() && (!bl || this.stepping)) {
                this.trackerPanel.getPlayer().step();
                return;
            }
            if (bl && !this.stepping) {
                this.active = false;
            } else {
                this.stop(true, true);
            }
        } else {
            this.paused = true;
        }
        this.getWizard().refreshGUI();
        this.getWizard().helpButton.requestFocusInWindow();
        this.repaint();
    }

    protected void stop(boolean bl, boolean bl2) {
        this.stepping = false;
        this.active = !bl && !this.paused;
        this.paused = false;
        this.wizard.refreshGUI();
        if (bl2) {
            if (this.track instanceof PointMass) {
                PointMass pointMass = (PointMass)this.track;
                pointMass.updateDerivatives();
            }
            this.track.firePropertyChange("steps", null, null);
        }
    }

    public boolean markCurrentFrame(boolean bl) {
        if (this.track == null) {
            return false;
        }
        this.trackerPanel.setSelectedTrack(this.track);
        int n = this.trackerPanel.getFrameNumber();
        FrameData frameData = this.getFrame(n);
        KeyFrame keyFrame = frameData.getKeyFrame();
        if (keyFrame != null && !this.track.isStepComplete(n)) {
            TPoint tPoint = this.findMatchTarget(bl);
            double[] dArray = frameData.getMatchWidthAndHeight();
            if (tPoint != null && (Double.isInfinite(dArray[1]) || dArray[1] >= (double)this.goodMatch)) {
                this.marking = true;
                this.track.autoTrackerMarking = this.track.isAutoAdvance();
                tPoint = this.track.autoMarkAt(n, tPoint.x, tPoint.y);
                frameData.setAutoMarkPoint(tPoint);
                this.track.autoTrackerMarking = false;
                return true;
            }
            if (tPoint == null) {
                frameData.setMatchIcon(null);
            }
        }
        return false;
    }

    public TPoint getPredictedMatchTarget(int n) {
        Object object;
        int n2;
        boolean bl = false;
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        int n3 = videoClip.frameToStep(n);
        TPoint[] tPointArray = new TPoint[predictionLookback];
        if (n3 > 0 && this.track != null) {
            int n4 = 0;
            while (n4 < predictionLookback) {
                if (n3 - n4 - 1 >= 0) {
                    n2 = videoClip.stepToFrame(n3 - n4 - 1);
                    object = this.getFrame(n2);
                    tPointArray[n4] = this.track.steps.isAutofill() && !((FrameData)object).searched ? null : ((FrameData)object).getMarkedPoint();
                }
                ++n4;
            }
        }
        if (tPointArray[0] == null) {
            return null;
        }
        this.predictedTarget.setLocation(tPointArray[0].getX(), tPointArray[0].getY());
        if (!this.lookAhead || tPointArray[1] == null) {
            bl = true;
        }
        if (!bl) {
            double d;
            TPoint tPoint;
            TPoint tPoint2;
            TPoint tPoint3;
            boolean bl2;
            double[][] dArray = this.getDerivatives(tPointArray, 1);
            double[][] dArray2 = this.getDerivatives(tPointArray, 2);
            object = this.getDerivatives(tPointArray, 3);
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < dArray.length) {
                if (dArray[n6] != null) {
                    ++n5;
                    d2 = Math.max(d2, Math.abs(dArray[n6][0]));
                    d3 += dArray[n6][0];
                    d4 = Math.max(d4, Math.abs(dArray[n6][1]));
                    d5 += dArray[n6][1];
                }
                ++n6;
            }
            d3 = Math.abs(d3 / (double)n5);
            d5 = Math.abs(d5 / (double)n5);
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            n5 = 0;
            int n7 = 0;
            while (n7 < dArray2.length) {
                if (dArray2[n7] != null) {
                    ++n5;
                    d6 = Math.max(d6, Math.abs(dArray2[n7][0]));
                    d7 += dArray2[n7][0];
                    d8 = Math.max(d8, Math.abs(dArray2[n7][1]));
                    d9 += dArray2[n7][1];
                }
                ++n7;
            }
            d7 = Math.abs(d7 / (double)n5);
            d9 = Math.abs(d9 / (double)n5);
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            n5 = 0;
            int n8 = 0;
            while (n8 < ((Object)object).length) {
                if (object[n8] != null) {
                    ++n5;
                    d10 = Math.max(d10, Math.abs((double)object[n8][0]));
                    d11 += object[n8][0];
                    d12 = Math.max(d12, Math.abs((double)object[n8][1]));
                    d13 += object[n8][1];
                }
                ++n8;
            }
            d11 = Math.abs(d11 / (double)n5);
            d13 = Math.abs(d13 / (double)n5);
            n8 = tPointArray[2] != null && !(Math.abs(dArray2[0][0]) < d3) ? 0 : 1;
            boolean bl3 = tPointArray[2] == null || Math.abs(dArray2[0][1]) < d5;
            boolean bl4 = tPointArray[2] != null && (tPointArray[3] == null || Math.abs((double)object[0][0]) < d7);
            boolean bl5 = bl2 = tPointArray[2] != null && (tPointArray[3] == null || Math.abs((double)object[0][1]) < d9);
            if (bl4) {
                tPoint3 = tPointArray[2];
                tPoint2 = tPointArray[1];
                tPoint = tPointArray[0];
                d = 3.0 * tPoint.getX() - 3.0 * tPoint2.getX() + tPoint3.getX();
                this.predictedTarget.setLocation(d, this.predictedTarget.y);
                bl = true;
            } else if (n8 != 0) {
                tPoint3 = tPointArray[1];
                tPoint2 = tPointArray[0];
                double d14 = 2.0 * tPoint2.getX() - tPoint3.getX();
                this.predictedTarget.setLocation(d14, this.predictedTarget.y);
                bl = true;
            }
            if (bl2) {
                tPoint3 = tPointArray[2];
                tPoint2 = tPointArray[1];
                tPoint = tPointArray[0];
                d = 3.0 * tPoint.getY() - 3.0 * tPoint2.getY() + tPoint3.getY();
                this.predictedTarget.setLocation(this.predictedTarget.x, d);
                bl = true;
            } else if (bl3) {
                tPoint3 = tPointArray[1];
                tPoint2 = tPointArray[0];
                double d15 = 2.0 * tPoint2.getY() - tPoint3.getY();
                this.predictedTarget.setLocation(this.predictedTarget.x, d15);
                bl = true;
            }
        }
        if (bl) {
            BufferedImage bufferedImage = this.trackerPanel.getVideo().getImage();
            n2 = bufferedImage.getWidth();
            int n9 = bufferedImage.getHeight();
            this.predictedTarget.x = Math.max(this.predictedTarget.x, 0.0);
            this.predictedTarget.x = Math.min(this.predictedTarget.x, (double)n2);
            this.predictedTarget.y = Math.max(this.predictedTarget.y, 0.0);
            this.predictedTarget.y = Math.min(this.predictedTarget.y, (double)n9);
            return this.predictedTarget;
        }
        return null;
    }

    public TPoint findMatchTarget(boolean bl) {
        TPoint[] tPointArray;
        int n = this.trackerPanel.getFrameNumber();
        FrameData frameData = this.getFrame(n);
        if (bl && (tPointArray = this.getPredictedMatchTarget(n)) != null) {
            TPoint tPoint = this.getMatchCenter((TPoint)tPointArray);
            this.setSearchPoints(tPoint, null);
        }
        tPointArray = new TPoint[]{new TPoint(this.searchCenter), new TPoint(this.searchCorner)};
        frameData.setSearchPoints(tPointArray);
        return this.findMatchTarget(this.getSearchRect());
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.track == null || this.wizard == null || !this.wizard.isVisible() || this.trackerPanel.getVideo() == null) {
            this.searchVisible = false;
            this.targetVisible = false;
            this.maskVisible = false;
            return;
        }
        if (this.wizard != null && this.wizard.isVisible() && !this.maskVisible && !this.targetVisible && !this.searchVisible) {
            this.wizard.refreshGUI();
            this.searchVisible = true;
            this.targetVisible = true;
            this.maskVisible = true;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getMark() != null) {
            this.mark.draw(graphics2D, false);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Target target;
        this.isInteracting = false;
        int n3 = this.trackerPanel.getFrameNumber();
        KeyFrame keyFrame = this.getFrame(n3).getKeyFrame();
        if (keyFrame == null || !this.wizard.isVisible() || this.trackerPanel.getVideo() == null) {
            return null;
        }
        hitRect.setLocation(n - AutoTracker.hitRect.width / 2, n2 - AutoTracker.hitRect.height / 2);
        if (this.targetVisible && hitRect.contains((target = keyFrame.getTarget()).getScreenPosition(this.trackerPanel))) {
            this.isInteracting = true;
            return target;
        }
        hitPt.setLocation(n, n2);
        if (this.searchVisible) {
            if (hitRect.contains(this.searchCorner.getScreenPosition(this.trackerPanel))) {
                return this.searchCorner;
            }
            if (this.searchHitShape.intersects(hitRect)) {
                return this.searchHandle;
            }
        }
        if (this.maskVisible) {
            if (hitRect.contains(this.maskCorner.getScreenPosition(this.trackerPanel))) {
                return this.maskCorner;
            }
            if (this.maskHitShape.intersects(hitRect)) {
                return this.maskHandle;
            }
        }
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isInteracting() {
        return this.isInteracting;
    }

    public boolean isInteracting(TTrack tTrack) {
        if (this.getTrack() == tTrack) {
            int n = tTrack.trackerPanel.getFrameNumber();
            FrameData frameData = this.getFrame(n);
            return frameData != null && frameData == frameData.getKeyFrame() && this.isInteracting();
        }
        return false;
    }

    public TemplateMatcher getTemplateMatcher() {
        int n = this.trackerPanel.getFrameNumber();
        KeyFrame keyFrame = this.getFrame(n).getKeyFrame();
        if (keyFrame == null) {
            return null;
        }
        if (keyFrame.getTemplateMatcher() == null) {
            TemplateMatcher templateMatcher = this.createTemplateMatcher();
            keyFrame.setTemplateMatcher(templateMatcher);
        }
        return keyFrame.getTemplateMatcher();
    }

    public Rectangle getSearchRect() {
        return this.searchRect2D.getBounds();
    }

    public void refreshSearchRect() {
        this.searchRect2D.setFrameFromCenter(this.searchCenter, this.searchCorner);
        if (this.moveRectIntoImage(this.searchRect2D)) {
            this.searchCenter.setLocation(this.searchRect2D.getCenterX(), this.searchRect2D.getCenterY());
            this.searchCorner.setLocation(this.searchRect2D.getMaxX(), this.searchRect2D.getMaxY());
        }
        int n = this.trackerPanel.getFrameNumber();
        FrameData frameData = this.getFrame(n);
        TPoint[] tPointArray = new TPoint[]{new TPoint(this.searchCenter), new TPoint(this.searchCorner)};
        frameData.setSearchPoints(tPointArray);
        this.repaint();
    }

    protected void setSearchPoints(TPoint tPoint, TPoint tPoint2) {
        if (tPoint2 == null) {
            BufferedImage bufferedImage = this.trackerPanel.getVideo().getImage();
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int n3 = this.searchRect2D.getBounds().width / 2;
            int n4 = this.searchRect2D.getBounds().height / 2;
            tPoint.x = Math.max(tPoint.x, (double)n3);
            tPoint.x = Math.min(tPoint.x, (double)(n - n3));
            tPoint.y = Math.max(tPoint.y, (double)n4);
            tPoint.y = Math.min(tPoint.y, (double)(n2 - n4));
            double d = tPoint.x - this.searchCenter.x;
            double d2 = tPoint.y - this.searchCenter.y;
            this.searchCenter.x += d;
            this.searchCenter.y += d2;
            this.searchCorner.x += d;
            this.searchCorner.y += d2;
        } else {
            this.searchCenter.setLocation(tPoint);
            this.searchCorner.setLocation(tPoint2);
        }
        this.refreshSearchRect();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        TPoint tPoint;
        String string = propertyChangeEvent.getPropertyName();
        int n = this.trackerPanel.getFrameNumber();
        FrameData frameData = this.getFrame(n);
        KeyFrame keyFrame = frameData.getKeyFrame();
        if (string.equals("selectedpoint")) {
            int n2;
            Cloneable cloneable;
            boolean bl = false;
            tPoint = (TPoint)propertyChangeEvent.getOldValue();
            if (this.wizard.isVisible()) {
                if (tPoint instanceof Corner && keyFrame != null) {
                    bl = true;
                    object = keyFrame.getMask();
                    if (object instanceof Ellipse2D.Double) {
                        cloneable = (Ellipse2D.Double)object;
                        this.maskCorner.x = this.maskCenter.x + ((Ellipse2D.Double)cloneable).width / (2.0 * cornerFactor);
                        this.maskCorner.y = this.maskCenter.y + ((Ellipse2D.Double)cloneable).height / (2.0 * cornerFactor);
                    }
                    this.searchCorner.x = this.searchRect2D.getMaxX();
                    this.searchCorner.y = this.searchRect2D.getMaxY();
                } else if (tPoint instanceof Handle || tPoint instanceof Target) {
                    bl = true;
                }
            }
            object = this.trackerPanel.getSelectedStep();
            cloneable = (TPoint)propertyChangeEvent.getNewValue();
            if (cloneable == this.maskHandle || cloneable == this.maskCorner || cloneable == this.searchHandle || cloneable == this.searchCorner || keyFrame != null && cloneable == keyFrame.getTarget()) {
                this.trackerPanel.setSelectedTrack(this.track);
                bl = true;
            } else if (cloneable != null && object != null && object.getTrack() == this.track && (n2 = object.getPointIndex((TPoint)cloneable)) > -1 && n2 != this.track.getTargetIndex()) {
                this.track.setTargetIndex(n2);
                frameData = this.getFrame(n);
                TPoint[] tPointArray = frameData.getSearchPoints(true);
                if (tPointArray != null) {
                    this.setSearchPoints(tPointArray[0], tPointArray[1]);
                }
                if ((keyFrame = frameData.getKeyFrame()) != null) {
                    this.maskCenter.setLocation(keyFrame.getMaskPoints()[0]);
                    this.maskCorner.setLocation(keyFrame.getMaskPoints()[1]);
                }
                this.wizard.refreshGUI();
                bl = true;
            }
            if (bl) {
                this.repaint();
            }
        } else if (string.equals("selectedtrack") && this.wizard != null) {
            this.wizard.refreshGUI();
        }
        if (this.wizard == null || !this.wizard.isVisible()) {
            return;
        }
        if (string.equals("video") || string.equals("name") || string.equals("color") || string.equals("footprint")) {
            this.wizard.refreshGUI();
        } else if (this.track == null && string.equals("stepnumber")) {
            this.wizard.refreshGUI();
        }
        if (this.track == null || this.trackerPanel.getVideo() == null) {
            return;
        }
        if (string.equals("step") && this.wizard.isVisible()) {
            if (!this.marking) {
                n = (Integer)propertyChangeEvent.getNewValue();
                frameData = this.getFrame(n);
                frameData.decided = true;
                if (this.track.getStep(n) == null) {
                    frameData.clear();
                } else if (!frameData.isKeyFrame()) {
                    frameData.setMatchIcon(null);
                    this.paused = false;
                }
            }
            this.wizard.refreshGUI();
            this.marking = false;
        } else if (string.equals("stepnumber")) {
            TPoint[] tPointArray = frameData.getSearchPoints(true);
            if (tPointArray != null) {
                this.setSearchPoints(tPointArray[0], tPointArray[1]);
            } else if (this.lookAhead && keyFrame != null) {
                tPoint = this.getPredictedMatchTarget(n);
                if (tPoint != null) {
                    this.setSearchPoints(this.getMatchCenter(tPoint), null);
                    object = new TPoint[]{new TPoint(this.searchCenter), new TPoint(this.searchCorner)};
                    frameData.setSearchPoints((TPoint[])object);
                } else {
                    this.repaint();
                }
            }
            if (this.active && !this.paused) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.stepper.run();
                } else {
                    SwingUtilities.invokeLater(this.stepper);
                }
            } else if (this.stepping) {
                this.stop(true, false);
            } else {
                this.wizard.refreshGUI();
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setXY(double d, double d2) {
    }

    @Override
    public void setX(double d) {
    }

    @Override
    public void setY(double d) {
    }

    @Override
    public double getX() {
        return 0.0;
    }

    @Override
    public double getY() {
        return 0.0;
    }

    @Override
    public double getXMin() {
        return 0.0;
    }

    @Override
    public double getXMax() {
        return 0.0;
    }

    @Override
    public double getYMin() {
        return 0.0;
    }

    @Override
    public double getYMax() {
        return 0.0;
    }

    @Override
    public boolean isMeasured() {
        return false;
    }

    protected TPoint findMatchTarget(Rectangle rectangle) {
        Video video = this.trackerPanel.getVideo();
        if (video == null) {
            return null;
        }
        TemplateMatcher templateMatcher = this.getTemplateMatcher();
        if (templateMatcher == null) {
            return null;
        }
        int n = this.trackerPanel.getFrameNumber();
        FrameData frameData = this.getFrame(n);
        frameData.decided = false;
        templateMatcher.setTemplate(frameData.getTemplateToMatch());
        TPoint tPoint = null;
        BufferedImage bufferedImage = video.getImage();
        if (this.lineSpread >= 0) {
            double d = this.trackerPanel.getCoords().getAngle(n);
            double d2 = this.trackerPanel.getCoords().getOriginX(n);
            double d3 = this.trackerPanel.getCoords().getOriginY(n);
            tPoint = templateMatcher.getMatchLocation(bufferedImage, rectangle, d2, d3, d, this.lineSpread);
        } else {
            tPoint = templateMatcher.getMatchLocation(bufferedImage, rectangle);
        }
        double[] dArray = templateMatcher.getMatchWidthAndHeight();
        if (dArray[1] < (double)this.goodMatch && frameData.isAutoMarked()) {
            frameData.trackPoint = null;
        }
        frameData.setMatchWidthAndHeight(dArray);
        frameData.searched = true;
        if (tPoint == null || dArray[1] < (double)this.possibleMatch) {
            frameData.setMatchPoints(null);
            return null;
        }
        BufferedImage bufferedImage2 = templateMatcher.getMatchImage();
        BufferedImage bufferedImage3 = this.createMagnifiedImage(bufferedImage2);
        frameData.setMatchIcon(new ImageIcon(bufferedImage3));
        Rectangle rectangle2 = frameData.getKeyFrame().getMask().getBounds();
        TPoint tPoint2 = new TPoint(tPoint.x + this.maskCenter.x - rectangle2.getX(), tPoint.y + this.maskCenter.y - rectangle2.getY());
        TPoint tPoint3 = new TPoint(tPoint2.x + cornerFactor * (this.maskCorner.x - this.maskCenter.x), tPoint2.y + cornerFactor * (this.maskCorner.y - this.maskCenter.y));
        frameData.setMatchPoints(new TPoint[]{tPoint2, tPoint3, tPoint});
        if (dArray[1] >= (double)this.goodMatch) {
            this.buildEvolvedTemplate(frameData);
            return this.getMatchTarget(tPoint2);
        }
        return null;
    }

    protected void buildEvolvedTemplate(FrameData frameData) {
        TPoint[] tPointArray = frameData.getMatchPoints();
        if (tPointArray == null) {
            return;
        }
        TemplateMatcher templateMatcher = this.getTemplateMatcher();
        templateMatcher.setTemplate(frameData.getTemplate());
        templateMatcher.setWorkingPixels(frameData.getWorkingPixels());
        Rectangle rectangle = frameData.getKeyFrame().getMask().getBounds();
        int n = (int)Math.round(tPointArray[2].getX());
        int n2 = (int)Math.round(tPointArray[2].getY());
        BufferedImage bufferedImage = this.trackerPanel.getVideo().getImage();
        BufferedImage bufferedImage2 = new BufferedImage(rectangle.width, rectangle.height, 1);
        bufferedImage2.createGraphics().drawImage((Image)bufferedImage, -n, -n2, null);
        templateMatcher.buildTemplate(bufferedImage2, this.evolveAlpha, 0);
        templateMatcher.setIndex(frameData.getFrameNumber());
    }

    protected TemplateMatcher createTemplateMatcher() {
        Video video = this.trackerPanel.getVideo();
        int n = this.trackerPanel.getFrameNumber();
        FrameData frameData = this.getFrame(n);
        KeyFrame keyFrame = frameData.getKeyFrame();
        if (video != null && keyFrame != null) {
            Shape shape = keyFrame.getMask();
            BufferedImage bufferedImage = video.getImage();
            Rectangle rectangle = shape.getBounds();
            BufferedImage bufferedImage2 = new BufferedImage(rectangle.width, rectangle.height, 1);
            bufferedImage2.createGraphics().drawImage((Image)bufferedImage, -rectangle.x, -rectangle.y, null);
            transform.setToTranslation(-rectangle.x, -rectangle.y);
            Shape shape2 = transform.createTransformedShape(shape);
            return new TemplateMatcher(bufferedImage2, shape2);
        }
        return null;
    }

    protected Map<Integer, Map<Integer, FrameData>> getIndexFrameData() {
        Map<Integer, Map<Integer, FrameData>> map = this.trackFrameData.get(this.track);
        if (map == null) {
            map = new TreeMap<Integer, Map<Integer, FrameData>>();
            this.trackFrameData.put(this.track, map);
        }
        return map;
    }

    protected Map<Integer, FrameData> getFrameData(int n) {
        Map<Integer, FrameData> map = this.getIndexFrameData().get(n);
        if (map == null) {
            map = new TreeMap<Integer, FrameData>();
            this.getIndexFrameData().put(n, map);
        }
        return map;
    }

    protected Map<Integer, FrameData> getFrameData() {
        int n = this.track == null ? 0 : this.track.getTargetIndex();
        return this.getFrameData(n);
    }

    protected FrameData getFrame(int n) {
        FrameData frameData = this.getFrameData().get(n);
        if (frameData == null) {
            int n2 = this.track == null ? 0 : this.track.getTargetIndex();
            frameData = new FrameData(n2, n);
            this.getFrameData().put(n, frameData);
        }
        return frameData;
    }

    protected int getIndex(TPoint tPoint) {
        int n = tPoint.getFrameNumber(this.trackerPanel);
        Step step = this.track.getStep(n);
        if (step != null) {
            int n2 = 0;
            while (n2 < step.points.length) {
                if (tPoint.equals(step.points[n2])) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    protected TTrack getTrack() {
        return this.track;
    }

    protected void erase() {
        if (this.mark != null) {
            this.trackerPanel.addDirtyRegion(this.mark.getBounds(false));
        }
        this.mark = null;
    }

    protected void repaint() {
        this.erase();
        if (this.getMark() != null) {
            this.trackerPanel.addDirtyRegion(this.mark.getBounds(false));
        }
        this.trackerPanel.repaintDirtyRegion();
    }

    protected void cleanup() {
        this.trackerPanel.removeDrawable(this);
        this.trackerPanel.removePropertyChangeListener(this);
        this.setTrack(null);
        this.wizard.dispose();
    }

    protected Mark getMark() {
        int n = this.trackerPanel.getFrameNumber();
        FrameData frameData = this.getFrame(n);
        KeyFrame keyFrame = frameData.getKeyFrame();
        if (this.track == null || keyFrame == null) {
            return null;
        }
        if (this.mark == null) {
            Object object;
            Object object2;
            int n2 = this.getStatusCode(n);
            Color color = this.track.getFootprint().getColor();
            target_footprint.setColor(color);
            inactive_target_footprint.setColor(color);
            corner_footprint.setColor(color);
            Mark mark = null;
            Mark mark2 = null;
            Mark mark3 = null;
            Mark mark4 = null;
            AffineTransform affineTransform = this.trackerPanel.getPixelTransform();
            if (!this.trackerPanel.isDrawingInImageSpace()) {
                affineTransform.concatenate(this.trackerPanel.getCoords().getToWorldTransform(n));
            }
            TPoint tPoint = this.trackerPanel.getSelectedPoint();
            Point point = null;
            try {
                this.searchShape = affineTransform.createTransformedShape(this.searchRect2D);
                this.searchHitShape = solid.createStrokedShape(this.searchShape);
                this.maskShape = affineTransform.createTransformedShape(keyFrame.getMask());
                this.maskHitShape = solid.createStrokedShape(this.maskShape);
            }
            catch (Exception exception) {
                return null;
            }
            if (tPoint == this.maskHandle) {
                point = this.maskVisible ? this.maskHandle.getScreenPosition(this.trackerPanel) : null;
            } else if (tPoint == this.searchHandle) {
                Point point2 = point = this.searchVisible ? this.searchHandle.getScreenPosition(this.trackerPanel) : null;
            }
            if (frameData.isKeyFrame()) {
                this.maskCenter.setLocation(keyFrame.getMaskPoints()[0]);
                this.maskCorner.setLocation(keyFrame.getMaskPoints()[1]);
            }
            this.screenPoints[0] = this.maskCorner.getScreenPosition(this.trackerPanel);
            if (tPoint == this.maskCorner) {
                point = this.maskVisible ? this.screenPoints[0] : null;
            } else {
                mark2 = corner_footprint.getMark(this.screenPoints);
            }
            this.screenPoints[0] = this.searchCorner.getScreenPosition(this.trackerPanel);
            if (tPoint == this.searchCorner) {
                point = this.searchVisible ? this.screenPoints[0] : null;
            } else {
                mark = corner_footprint.getMark(this.screenPoints);
            }
            this.screenPoints[0] = keyFrame.getTarget().getScreenPosition(this.trackerPanel);
            if (tPoint == keyFrame.getTarget()) {
                point = this.targetVisible ? this.screenPoints[0] : null;
            } else {
                mark3 = target_footprint.getMark(this.screenPoints);
            }
            TPoint[] tPointArray = frameData.getMatchPoints();
            if (tPointArray == null || frameData.isKeyFrame() || n2 == 5) {
                this.matchShape = null;
            } else {
                object2 = tPointArray[0].getScreenPosition(this.trackerPanel);
                object = this.maskCenter.getScreenPosition(this.trackerPanel);
                transform.setToTranslation(((Point)object2).x - ((Point)object).x, ((Point)object2).y - ((Point)object).y);
                this.matchShape = affineTransform.createTransformedShape(this.getMatchShape(tPointArray));
                this.screenPoints[0] = this.getMatchTarget(tPointArray[0]).getScreenPosition(this.trackerPanel);
            }
            if (point != null) {
                transform.setToTranslation(point.x, point.y);
                object2 = transform.createTransformedShape(selectionShape);
                mark4 = new Mark((Shape)object2){
                    private final /* synthetic */ Shape val$selectedShape;
                    {
                        this.val$selectedShape = shape;
                    }

                    @Override
                    public void draw(Graphics2D graphics2D, boolean bl) {
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics2D.fill(this.val$selectedShape);
                    }

                    @Override
                    public Rectangle getBounds(boolean bl) {
                        return this.val$selectedShape.getBounds();
                    }
                };
            }
            object2 = mark2;
            object = mark;
            final Mark mark5 = mark3;
            Mark mark6 = mark4;
            this.mark = new Mark((Mark)object2, (Mark)object, mark6){
                private final /* synthetic */ Mark val$markMaskCorner;
                private final /* synthetic */ Mark val$markSearchCorner;
                private final /* synthetic */ Mark val$markSelection;
                {
                    this.val$markMaskCorner = mark2;
                    this.val$markSearchCorner = mark3;
                    this.val$markSelection = mark4;
                }

                @Override
                public void draw(Graphics2D graphics2D, boolean bl) {
                    boolean bl2;
                    Paint paint = graphics2D.getPaint();
                    Color color = AutoTracker.this.track.getFootprint().getColor();
                    graphics2D.setPaint(color);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    BasicStroke basicStroke = (BasicStroke)graphics2D.getStroke();
                    int n = AutoTracker.this.trackerPanel.getFrameNumber();
                    FrameData frameData = AutoTracker.this.getFrame(n);
                    boolean bl3 = bl2 = frameData != null && frameData.isKeyFrame();
                    if (AutoTracker.this.targetVisible && bl2 && mark5 != null) {
                        mark5.draw(graphics2D, false);
                    }
                    if (AutoTracker.this.matchShape != null && !bl2) {
                        graphics2D.setStroke(dotted);
                        graphics2D.draw(AutoTracker.this.matchShape);
                    }
                    if (AutoTracker.this.maskVisible && bl2) {
                        graphics2D.setStroke(basicStroke);
                        graphics2D.draw(AutoTracker.this.maskShape);
                        if (this.val$markMaskCorner != null) {
                            this.val$markMaskCorner.draw(graphics2D, false);
                        }
                    }
                    if (AutoTracker.this.searchVisible || !bl2) {
                        graphics2D.setStroke(dashed);
                        graphics2D.draw(AutoTracker.this.searchShape);
                        if (this.val$markSearchCorner != null) {
                            this.val$markSearchCorner.draw(graphics2D, false);
                        }
                    }
                    if (this.val$markSelection != null) {
                        this.val$markSelection.draw(graphics2D, false);
                    }
                    graphics2D.setStroke(basicStroke);
                    graphics2D.setPaint(paint);
                }

                @Override
                public Rectangle getBounds(boolean bl) {
                    Rectangle rectangle = AutoTracker.this.searchShape.getBounds();
                    if (this.val$markMaskCorner != null) {
                        rectangle.add(this.val$markMaskCorner.getBounds(bl));
                    }
                    if (this.val$markSearchCorner != null) {
                        rectangle.add(this.val$markSearchCorner.getBounds(bl));
                    }
                    if (mark5 != null) {
                        rectangle.add(mark5.getBounds(bl));
                    }
                    if (this.val$markSelection != null) {
                        rectangle.add(this.val$markSelection.getBounds(bl));
                    }
                    if (AutoTracker.this.maskVisible) {
                        rectangle.add(AutoTracker.this.maskShape.getBounds());
                    }
                    if (AutoTracker.this.matchShape != null) {
                        rectangle.add(AutoTracker.this.matchShape.getBounds());
                    }
                    return rectangle;
                }
            };
        }
        return this.mark;
    }

    protected TPoint getMatchTarget(TPoint tPoint) {
        int n = this.trackerPanel.getFrameNumber();
        double[] dArray = this.getFrame(n).getTargetOffset();
        return new TPoint(tPoint.x + dArray[0], tPoint.y + dArray[1]);
    }

    protected TPoint getMatchCenter(TPoint tPoint) {
        int n = this.trackerPanel.getFrameNumber();
        double[] dArray = this.getFrame(n).getTargetOffset();
        return new TPoint(tPoint.x - dArray[0], tPoint.y - dArray[1]);
    }

    protected void delete(int n) {
        this.trackerPanel.repaint();
        FrameData frameData = this.getFrame(n);
        frameData.clear();
    }

    protected void reset() {
        Object object;
        int n2;
        this.mark = null;
        Map<Integer, FrameData> map = this.getFrameData();
        KeyFrame keyFrame = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n2 : map.keySet()) {
            object = map.get(n2);
            ((FrameData)object).clear();
            if (keyFrame == null && ((FrameData)object).isKeyFrame()) {
                keyFrame = (KeyFrame)object;
            }
            arrayList.add(n2);
        }
        for (int n2 : arrayList) {
            map.remove(n2);
        }
        int n3 = n2 = !this.track.steps.isAutofill() && !(this.track instanceof CoordAxes) ? 0 : 1;
        if (n2 == 0) {
            int n4 = 0;
            while (n4 < this.track.getSteps().length) {
                this.track.steps.setStep(n4, null);
                ++n4;
            }
        }
        this.stop(true, true);
        if (keyFrame != null) {
            int n5 = keyFrame.getFrameNumber();
            object = this.trackerPanel.getPlayer();
            ((VideoPlayer)object).setStepNumber(((VideoPlayer)object).getVideoClip().frameToStep(n5));
        }
        this.repaint();
    }

    protected void refreshKeyFrame(KeyFrame keyFrame) {
        Cloneable cloneable;
        Shape shape = keyFrame.getMask();
        if (shape instanceof Ellipse2D.Double) {
            keyFrame.getMaskPoints()[0].setLocation(this.maskCenter);
            keyFrame.getMaskPoints()[1].setLocation(this.maskCorner);
            cloneable = (Ellipse2D.Double)shape;
            double d = this.maskCenter.sin(this.maskCorner);
            double d2 = this.maskCenter.cos(this.maskCorner);
            if (Double.isNaN(d)) {
                d = -0.707;
                d2 = 0.707;
            }
            double d3 = Math.max(this.minMaskRadius, this.maskCenter.distance(this.maskCorner));
            double d4 = d3 * cornerFactor * d2;
            double d5 = -d3 * cornerFactor * d;
            if (Math.abs(d4) < 1.0) {
                d4 = d4 > 0.0 ? 1.0 : -1.0;
            }
            if (Math.abs(d5) < 1.0) {
                d5 = d5 > 0.0 ? 1.0 : -1.0;
            }
            ((RectangularShape)cloneable).setFrameFromCenter(this.maskCenter.x, this.maskCenter.y, this.maskCenter.x + d4, this.maskCenter.y + d5);
        }
        this.wizard.replaceIcons(keyFrame);
        cloneable = keyFrame.getMarkedPoint();
        if (cloneable != null) {
            keyFrame.getTarget().setXY(((Point2D.Double)cloneable).getX(), ((Point2D.Double)cloneable).getY());
        }
        this.search(true, false);
        this.repaint();
        this.wizard.repaint();
    }

    protected BufferedImage createMagnifiedImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(templateIconMagnification * bufferedImage.getWidth(), templateIconMagnification * bufferedImage.getHeight(), 2);
        bufferedImage2.createGraphics().drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
        return bufferedImage2;
    }

    protected Shape getMatchShape(TPoint[] tPointArray) {
        if (this.match instanceof Ellipse2D.Double) {
            Ellipse2D.Double double_ = (Ellipse2D.Double)this.match;
            double_.setFrameFromCenter(tPointArray[0], tPointArray[1]);
            return double_;
        }
        return null;
    }

    protected int getStatusCode(int n) {
        FrameData frameData = this.getFrame(n);
        if (frameData.isKeyFrame()) {
            return 0;
        }
        double[] dArray = frameData.getMatchWidthAndHeight();
        if (frameData.isMarked()) {
            boolean bl;
            if (frameData.isAutoMarked()) {
                if (dArray[1] > (double)this.goodMatch) {
                    return 1;
                }
                return 6;
            }
            boolean bl2 = bl = this.track instanceof CoordAxes || this.track instanceof OffsetOrigin || this.track instanceof Calibration;
            if (this.track instanceof TapeMeasure) {
                TapeMeasure tapeMeasure = (TapeMeasure)this.track;
                boolean bl3 = bl = !tapeMeasure.isReadOnly();
            }
            if (frameData.searched) {
                if (bl) {
                    if (dArray[1] > (double)this.possibleMatch) {
                        return 8;
                    }
                    return 9;
                }
                if (frameData.decided) {
                    return 5;
                }
                if (dArray[1] > (double)this.possibleMatch) {
                    return 8;
                }
                return 9;
            }
            return 7;
        }
        if (frameData.searched) {
            if (dArray[1] < (double)this.possibleMatch) {
                return 3;
            }
            return 2;
        }
        if (dArray == null) {
            return 7;
        }
        return 4;
    }

    protected boolean canStep() {
        int n;
        VideoPlayer videoPlayer = this.trackerPanel.getPlayer();
        int n2 = videoPlayer.getStepNumber();
        return n2 < (n = videoPlayer.getVideoClip().getStepCount() - 1);
    }

    protected boolean isDrawingKeyFrameFor(TTrack tTrack, int n) {
        int n2 = this.trackerPanel.getFrameNumber();
        if (this.getTrack() == tTrack && this.wizard.isVisible() && this.getFrame(n2).isKeyFrame()) {
            FrameData frameData = this.getFrame(n2);
            return frameData.getIndex() == n;
        }
        return false;
    }

    protected void clearSearchPointsDownstream() {
        int n = this.trackerPanel.getFrameNumber();
        Map<Integer, FrameData> map = this.getFrameData();
        for (Integer n2 : map.keySet()) {
            if (n2 <= n) continue;
            FrameData frameData = map.get(n2);
            if (frameData.isKeyFrame()) break;
            frameData.setSearchPoints(null);
        }
    }

    protected boolean moveRectIntoImage(Rectangle2D rectangle2D) {
        BufferedImage bufferedImage = this.trackerPanel.getVideo().getImage();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        Dimension dimension = new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        boolean bl = false;
        if (n < dimension.width || n2 < dimension.height) {
            bl = true;
            dimension.setSize(Math.min(n, dimension.width), Math.min(n2, dimension.height));
            rectangle2D.setFrame(double_, dimension);
        }
        double d = Math.max(0.0, ((Point2D)double_).getX());
        d = Math.min(d, (double)(n - dimension.width));
        double d2 = Math.max(0.0, ((Point2D)double_).getY());
        d2 = Math.min(d2, (double)(n2 - dimension.height));
        if (d != ((Point2D)double_).getX() || d2 != ((Point2D)double_).getY()) {
            bl = true;
            ((Point2D)double_).setLocation(d, d2);
            rectangle2D.setFrame(double_, dimension);
        }
        return bl;
    }

    protected double[][] getDerivatives(TPoint[] tPointArray, int n) {
        if (tPointArray.length < n + 1) {
            return null;
        }
        if (n == 1) {
            int n2 = 0;
            while (n2 < this.derivatives1.length) {
                if (n2 >= tPointArray.length - 1) {
                    this.derivatives1[n2] = null;
                } else {
                    TPoint tPoint = tPointArray[n2 + 1];
                    TPoint tPoint2 = tPointArray[n2];
                    if (tPoint == null || tPoint2 == null) {
                        this.derivatives1[n2] = null;
                    } else {
                        double d = tPoint2.getX() - tPoint.getX();
                        double d2 = tPoint2.getY() - tPoint.getY();
                        this.derivatives1[n2] = new double[]{d, d2};
                    }
                }
                ++n2;
            }
            return this.derivatives1;
        }
        if (n == 2) {
            int n3 = 0;
            while (n3 < this.derivatives2.length) {
                if (n3 >= tPointArray.length - 2) {
                    this.derivatives2[n3] = null;
                } else {
                    TPoint tPoint = tPointArray[n3 + 2];
                    TPoint tPoint3 = tPointArray[n3 + 1];
                    TPoint tPoint4 = tPointArray[n3];
                    if (tPoint == null || tPoint3 == null || tPoint4 == null) {
                        this.derivatives2[n3] = null;
                    } else {
                        double d = tPoint4.getX() - 2.0 * tPoint3.getX() + tPoint.getX();
                        double d3 = tPoint4.getY() - 2.0 * tPoint3.getY() + tPoint.getY();
                        this.derivatives2[n3] = new double[]{d, d3};
                    }
                }
                ++n3;
            }
            return this.derivatives2;
        }
        if (n == 3) {
            int n4 = 0;
            while (n4 < this.derivatives3.length) {
                if (n4 >= tPointArray.length - 3) {
                    this.derivatives3[n4] = null;
                } else {
                    TPoint tPoint = tPointArray[n4 + 3];
                    TPoint tPoint5 = tPointArray[n4 + 2];
                    TPoint tPoint6 = tPointArray[n4 + 1];
                    TPoint tPoint7 = tPointArray[n4];
                    if (tPoint == null || tPoint5 == null || tPoint6 == null || tPoint7 == null) {
                        this.derivatives3[n4] = null;
                    } else {
                        double d = tPoint7.getX() - 3.0 * tPoint6.getX() + 3.0 * tPoint5.getX() - tPoint.getX();
                        double d4 = tPoint7.getY() - 3.0 * tPoint6.getY() + 3.0 * tPoint5.getY() - tPoint.getY();
                        this.derivatives3[n4] = new double[]{d, d4};
                    }
                }
                ++n4;
            }
            return this.derivatives3;
        }
        return null;
    }

    protected class Corner
    extends TPoint {
        protected Corner() {
        }

        @Override
        public void setXY(double d, double d2) {
            super.setXY(d, d2);
            int n = AutoTracker.this.trackerPanel.getFrameNumber();
            if (this == AutoTracker.this.searchCorner) {
                AutoTracker.this.refreshSearchRect();
                AutoTracker.this.wizard.setChanged();
            } else {
                AutoTracker.this.refreshKeyFrame(AutoTracker.this.getFrame(n).getKeyFrame());
            }
            AutoTracker.this.clearSearchPointsDownstream();
        }
    }

    protected class FrameData {
        private int index;
        private int frameNum;
        private int templateAlpha;
        private int matcherHashCode;
        private double[] targetOffset = new double[]{0.0, 0.0};
        private double[] matchWidthAndHeight;
        private TPoint[] matchPoints;
        private TPoint[] searchPoints;
        TPoint trackPoint;
        private double[] autoMarkLoc;
        private BufferedImage template;
        private Icon templateIcon;
        private Icon matchIcon;
        boolean searched;
        boolean decided;
        int[] workingPixels;

        FrameData(int n, int n2) {
            this.index = n;
            this.frameNum = n2;
        }

        FrameData(KeyFrame keyFrame) {
            this.index = keyFrame.getIndex();
            this.frameNum = keyFrame.getFrameNumber();
            this.matchWidthAndHeight = keyFrame.getMatchWidthAndHeight();
            this.matchPoints = keyFrame.getMatchPoints();
            this.searchPoints = keyFrame.getSearchPoints(false);
            this.targetOffset = keyFrame.getTargetOffset();
            this.matchIcon = keyFrame.getMatchIcon();
            this.templateIcon = keyFrame.getTemplateIcon();
            this.autoMarkLoc = keyFrame.getAutoMarkLoc();
            this.trackPoint = keyFrame.trackPoint;
            this.searched = keyFrame.searched;
        }

        int getFrameNumber() {
            return this.frameNum;
        }

        Icon getTemplateIcon() {
            return this.templateIcon;
        }

        void setTemplateIcon(Icon icon) {
            this.templateIcon = icon;
        }

        Icon getMatchIcon() {
            return this.matchIcon;
        }

        void setMatchIcon(Icon icon) {
            this.matchIcon = icon;
        }

        void setTemplate(TemplateMatcher templateMatcher) {
            this.template = templateMatcher.getTemplate();
            this.templateAlpha = templateMatcher.getAlphas()[0];
            this.workingPixels = templateMatcher.getWorkingPixels(this.workingPixels);
            this.matcherHashCode = templateMatcher.hashCode();
            this.setMatchIcon(null);
            BufferedImage bufferedImage = AutoTracker.this.createMagnifiedImage(this.template);
            this.setTemplateIcon(new ImageIcon(bufferedImage));
        }

        BufferedImage getTemplateToMatch() {
            if (this.template == null || this.newTemplateExists()) {
                this.setTemplate(this.getTemplateMatcher());
            }
            return this.template;
        }

        boolean newTemplateExists() {
            boolean bl;
            if (this.isKeyFrame()) {
                return false;
            }
            TemplateMatcher templateMatcher = this.getTemplateMatcher();
            if (templateMatcher == null) {
                return false;
            }
            boolean bl2 = templateMatcher.getAlphas()[0] != this.templateAlpha || templateMatcher.hashCode() != this.matcherHashCode;
            boolean bl3 = bl = templateMatcher.getIndex() < this.frameNum;
            return bl2 && bl;
        }

        BufferedImage getTemplate() {
            return this.template;
        }

        int[] getWorkingPixels() {
            return this.workingPixels;
        }

        TemplateMatcher getTemplateMatcher() {
            KeyFrame keyFrame = this.getKeyFrame();
            return keyFrame == null ? null : keyFrame.matcher;
        }

        void setTargetOffset(double d, double d2) {
            this.targetOffset = new double[]{d, d2};
        }

        double[] getTargetOffset() {
            if (this.isKeyFrame()) {
                return this.targetOffset;
            }
            return this.getKeyFrame().getTargetOffset();
        }

        void setSearchPoints(TPoint[] tPointArray) {
            this.searchPoints = tPointArray;
        }

        TPoint[] getSearchPoints(boolean bl) {
            if (!bl || this.searchPoints != null || this.isKeyFrame()) {
                return this.searchPoints;
            }
            Map<Integer, FrameData> map = AutoTracker.this.getFrameData(this.index);
            int n = this.frameNum;
            while (n >= 0) {
                FrameData frameData = map.get(n);
                if (frameData != null && (frameData.searchPoints != null || frameData.isKeyFrame())) {
                    return frameData.searchPoints;
                }
                --n;
            }
            return null;
        }

        void setMatchPoints(TPoint[] tPointArray) {
            this.matchPoints = tPointArray;
        }

        TPoint[] getMatchPoints() {
            return this.matchPoints;
        }

        void setMatchWidthAndHeight(double[] dArray) {
            this.matchWidthAndHeight = dArray;
        }

        double[] getMatchWidthAndHeight() {
            return this.matchWidthAndHeight;
        }

        KeyFrame getKeyFrame() {
            if (this.isKeyFrame()) {
                return (KeyFrame)this;
            }
            Map<Integer, FrameData> map = AutoTracker.this.getFrameData(this.index);
            int n = this.frameNum;
            while (n >= 0) {
                FrameData frameData = map.get(n);
                if (frameData != null && frameData.isKeyFrame()) {
                    return (KeyFrame)frameData;
                }
                --n;
            }
            return null;
        }

        int getIndex() {
            return this.index;
        }

        boolean isMarked() {
            return AutoTracker.this.track != null && AutoTracker.this.track.getStep(this.frameNum) != null;
        }

        boolean isAutoMarked() {
            if (this.autoMarkLoc == null || this.trackPoint == null) {
                return false;
            }
            if (this.trackPoint instanceof CoordAxes.AnglePoint) {
                CoordAxes.AnglePoint anglePoint;
                ImageCoordSystem imageCoordSystem = AutoTracker.this.trackerPanel.getCoords();
                double d = imageCoordSystem.getAngle(this.frameNum);
                return Math.abs(d - (anglePoint = (CoordAxes.AnglePoint)this.trackPoint).getAngle()) < 0.001;
            }
            return Math.abs(this.autoMarkLoc[0] - this.trackPoint.getX()) < 0.01 && Math.abs(this.autoMarkLoc[1] - this.trackPoint.getY()) < 0.01;
        }

        void setAutoMarkPoint(TPoint tPoint) {
            double[] dArray;
            this.trackPoint = tPoint;
            if (tPoint == null) {
                dArray = null;
            } else {
                double[] dArray2 = new double[2];
                dArray2[0] = tPoint.getX();
                dArray = dArray2;
                dArray2[1] = tPoint.getY();
            }
            this.autoMarkLoc = dArray;
        }

        double[] getAutoMarkLoc() {
            return this.autoMarkLoc;
        }

        boolean isKeyFrame() {
            return false;
        }

        TPoint getMarkedPoint() {
            if (!this.isMarked()) {
                return null;
            }
            if (this.trackPoint != null) {
                return this.trackPoint;
            }
            return AutoTracker.this.track.getMarkedPoint(this.frameNum, this.index);
        }

        void clear() {
            this.matchPoints = null;
            this.matchWidthAndHeight = null;
            this.matchIcon = null;
            this.autoMarkLoc = null;
            this.searched = false;
            this.decided = false;
            this.trackPoint = null;
            this.workingPixels = null;
            this.matcherHashCode = 0;
            if (!this.isKeyFrame()) {
                this.searchPoints = null;
                this.templateIcon = null;
                this.templateAlpha = 0;
                this.template = null;
            }
        }
    }

    protected class Handle
    extends TPoint {
        protected Handle() {
        }

        @Override
        public void setXY(double d, double d2) {
            double d3 = d - this.getX();
            double d4 = d2 - this.getY();
            super.setXY(d, d2);
            int n = AutoTracker.this.trackerPanel.getFrameNumber();
            if (this == AutoTracker.this.searchHandle) {
                ((AutoTracker)AutoTracker.this).searchCenter.x += d3;
                ((AutoTracker)AutoTracker.this).searchCenter.y += d4;
                ((AutoTracker)AutoTracker.this).searchCorner.x += d3;
                ((AutoTracker)AutoTracker.this).searchCorner.y += d4;
                AutoTracker.this.refreshSearchRect();
                AutoTracker.this.wizard.setChanged();
            } else {
                ((AutoTracker)AutoTracker.this).maskCenter.x += d3;
                ((AutoTracker)AutoTracker.this).maskCenter.y += d4;
                ((AutoTracker)AutoTracker.this).maskCorner.x += d3;
                ((AutoTracker)AutoTracker.this).maskCorner.y += d4;
                KeyFrame keyFrame = AutoTracker.this.getFrame(n).getKeyFrame();
                keyFrame.getMaskPoints()[0].setLocation(AutoTracker.this.maskCenter);
                keyFrame.getMaskPoints()[1].setLocation(AutoTracker.this.maskCorner);
                Target target = keyFrame.getTarget();
                keyFrame.setTargetOffset(target.x - ((AutoTracker)AutoTracker.this).maskCenter.x, target.y - ((AutoTracker)AutoTracker.this).maskCenter.y);
                AutoTracker.this.refreshKeyFrame(keyFrame);
            }
            AutoTracker.this.clearSearchPointsDownstream();
        }

        public void setScreenLocation(int n, int n2, VideoPanel videoPanel) {
            if (this.screenPt == null) {
                this.screenPt = new Point();
            }
            if (this.worldPt == null) {
                this.worldPt = new Point2D.Double();
            }
            this.screenPt.setLocation(n, n2);
            AffineTransform affineTransform = videoPanel.getPixelTransform();
            try {
                affineTransform.inverseTransform(this.screenPt, this.worldPt);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
            this.setLocation(this.worldPt);
            AutoTracker.this.repaint();
        }
    }

    protected class KeyFrame
    extends FrameData {
        private Shape mask;
        private Target target;
        private TPoint[] maskPoints;
        private TemplateMatcher matcher;

        KeyFrame(TPoint tPoint, Shape shape, Target target) {
            super(AutoTracker.this.getIndex(tPoint), tPoint.getFrameNumber(AutoTracker.this.trackerPanel));
            this.maskPoints = new TPoint[]{new TPoint(), new TPoint()};
            this.mask = shape;
            this.target = target;
            this.maskPoints[0].setLocation(AutoTracker.this.maskCenter);
            this.maskPoints[1].setLocation(AutoTracker.this.maskCorner);
        }

        @Override
        boolean isKeyFrame() {
            return true;
        }

        Shape getMask() {
            return this.mask;
        }

        Target getTarget() {
            return this.target;
        }

        TPoint[] getMaskPoints() {
            return this.maskPoints;
        }

        void setTemplateMatcher(TemplateMatcher templateMatcher) {
            this.matcher = templateMatcher;
        }

        boolean isFirstKeyFrame() {
            Map<Integer, FrameData> map = AutoTracker.this.getFrameData(this.getIndex());
            int n = this.getFrameNumber() - 1;
            while (n >= 0) {
                FrameData frameData = map.get(n);
                if (frameData != null && frameData.isKeyFrame()) {
                    return false;
                }
                --n;
            }
            return true;
        }
    }

    static class SpinnerTumbleModel
    extends SpinnerListModel {
        SpinnerTumbleModel(ArrayList<String> arrayList) {
            super(arrayList);
        }

        @Override
        public Object getNextValue() {
            Object object = super.getNextValue();
            if (object == null && this.getList().size() > 0) {
                object = this.getList().get(0);
            }
            return object;
        }

        @Override
        public Object getPreviousValue() {
            Object object = super.getPreviousValue();
            int n = this.getList().size();
            if (object == null && n > 0) {
                object = this.getList().get(n - 1);
            }
            return object;
        }
    }

    class TallSpinner
    extends JSpinner {
        Component comp;

        TallSpinner(SpinnerModel spinnerModel, Component component) {
            super(spinnerModel);
            this.comp = component;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height = this.comp.getPreferredSize().height;
            return dimension;
        }
    }

    protected class Target
    extends TPoint {
        protected Target() {
        }

        @Override
        public void setXY(double d, double d2) {
            super.setXY(d, d2);
            int n = AutoTracker.this.trackerPanel.getFrameNumber();
            FrameData frameData = AutoTracker.this.getFrame(n);
            KeyFrame keyFrame = frameData.getKeyFrame();
            keyFrame.setTargetOffset(d - ((AutoTracker)AutoTracker.this).maskCenter.x, d2 - ((AutoTracker)AutoTracker.this).maskCenter.y);
            ((AutoTracker)AutoTracker.this).track.autoTrackerMarking = AutoTracker.this.track.isAutoAdvance();
            TPoint tPoint = AutoTracker.this.track.autoMarkAt(n, this.getX(), this.getY());
            frameData.setAutoMarkPoint(tPoint);
            ((AutoTracker)AutoTracker.this).track.autoTrackerMarking = false;
            AutoTracker.this.repaint();
            AutoTracker.this.track.repaint();
        }
    }

    protected class Wizard
    extends JDialog
    implements PropertyChangeListener {
        private JButton startButton;
        private JButton searchNextButton;
        private JButton searchThisButton;
        private JButton closeButton;
        private JButton helpButton;
        private JButton deleteButton;
        private JButton keyFrameButton;
        private JButton acceptButton;
        private JButton skipButton;
        private JSpinner evolveSpinner;
        private JSpinner acceptSpinner;
        private JComboBox trackDropdown;
        private JComboBox pointDropdown;
        private boolean isVisible;
        private boolean changed;
        private JTextArea textPane;
        protected JToolBar templateToolbar;
        protected JToolBar searchToolbar;
        protected JToolBar targetToolbar;
        protected JToolBar imageToolbar;
        protected JToolBar trackToolbar;
        private JPanel startPanel;
        private JPanel followupPanel;
        private JPanel infoPanel;
        private JPanel northPanel;
        private JPanel targetPanel;
        private JLabel templateImageLabel;
        private JLabel matchImageLabel;
        private JLabel acceptLabel;
        private JLabel templateLabel;
        private JLabel frameLabel;
        private JLabel evolveRateLabel;
        private JLabel searchLabel;
        private JLabel targetLabel;
        private JLabel pointLabel;
        private JLabel trackLabel;
        protected Dimension textPaneSize;
        private JCheckBox lookAheadCheckbox;
        private JCheckBox oneDCheckbox;
        private Object mouseOverObj;
        private MouseAdapter mouseOverListener;
        private Timer timer;

        public Wizard() {
            super((Frame)AutoTracker.this.trackerPanel.getTFrame(), false);
            this.createGUI();
            this.pack();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("tab")) {
                if (AutoTracker.this.trackerPanel != null && propertyChangeEvent.getNewValue() == AutoTracker.this.trackerPanel) {
                    this.setVisible(this.isVisible);
                } else {
                    boolean bl = this.isVisible;
                    this.setVisible(false);
                    this.isVisible = bl;
                }
            }
        }

        public void setChanged() {
            if (!this.changed) {
                this.changed = true;
                this.refreshGUI();
            }
        }

        @Override
        public void setVisible(boolean bl) {
            super.setVisible(bl);
            TToolBar tToolBar = TToolBar.getToolbar(AutoTracker.this.trackerPanel);
            tToolBar.autotrackerButton.setSelected(bl);
            this.isVisible = bl;
            if (!bl) {
                AutoTracker.this.erase();
                AutoTracker.this.trackerPanel.repaintDirtyRegion();
            } else {
                TTrack tTrack = AutoTracker.this.trackerPanel.getSelectedTrack();
                if (tTrack != null) {
                    AutoTracker.this.setTrack(tTrack);
                }
            }
            this.refreshGUI();
        }

        public void setFontLevel(int n) {
            JComboBox[] jComboBoxArray;
            FontSizer.setFonts(this, FontSizer.getLevel());
            Object[] objectArray = new Object[]{this.acceptButton, this.skipButton};
            FontSizer.setFonts(objectArray, FontSizer.getLevel());
            JComboBox[] jComboBoxArray2 = jComboBoxArray = new JComboBox[]{this.trackDropdown, this.pointDropdown};
            int n2 = jComboBoxArray.length;
            int n3 = 0;
            while (n3 < n2) {
                JComboBox jComboBox = jComboBoxArray2[n3];
                int n4 = jComboBox.getSelectedIndex();
                Object[] objectArray2 = new Object[jComboBox.getItemCount()];
                int n5 = 0;
                while (n5 < objectArray2.length) {
                    objectArray2[n5] = jComboBox.getItemAt(n5);
                    ++n5;
                }
                DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray2);
                jComboBox.setModel(defaultComboBoxModel);
                jComboBox.setSelectedItem(n4);
                ++n3;
            }
            this.refreshStrings();
            this.pack();
        }

        protected void setAlphaFromRate(int n) {
            double d = maxEvolveRate;
            int n2 = (int)(1.0 * (double)n * 255.0 / d);
            if ((double)n >= d) {
                n2 = 255;
            }
            if (n <= 0) {
                n2 = 0;
            }
            AutoTracker.this.evolveAlpha = n2;
        }

        protected void createGUI() {
            TFrame tFrame = AutoTracker.this.trackerPanel.getTFrame();
            if (tFrame != null) {
                tFrame.addPropertyChangeListener("tab", this);
            }
            KeyAdapter keyAdapter = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (!AutoTracker.this.trackerPanel.getPlayer().isEnabled()) {
                        return;
                    }
                    switch (keyEvent.getKeyCode()) {
                        case 33: {
                            if (keyEvent.isShiftDown()) {
                                int n = AutoTracker.this.trackerPanel.getPlayer().getStepNumber() - 5;
                                AutoTracker.this.trackerPanel.getPlayer().setStepNumber(n);
                                break;
                            }
                            AutoTracker.this.trackerPanel.getPlayer().back();
                            break;
                        }
                        case 34: {
                            if (keyEvent.isShiftDown()) {
                                int n = AutoTracker.this.trackerPanel.getPlayer().getStepNumber() + 5;
                                AutoTracker.this.trackerPanel.getPlayer().setStepNumber(n);
                                break;
                            }
                            AutoTracker.this.trackerPanel.getPlayer().step();
                            break;
                        }
                        case 36: {
                            AutoTracker.this.trackerPanel.getPlayer().setStepNumber(0);
                            break;
                        }
                        case 35: {
                            VideoClip videoClip = AutoTracker.this.trackerPanel.getPlayer().getVideoClip();
                            AutoTracker.this.trackerPanel.getPlayer().setStepNumber(videoClip.getStepCount() - 1);
                        }
                    }
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 16) {
                        ((AutoTracker)((Wizard)Wizard.this).AutoTracker.this).trackerPanel.isShiftKeyDown = false;
                    }
                }
            };
            int n = 500;
            this.timer = new Timer(n, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Wizard.this.refreshInfo();
                    Wizard.this.refreshDrawingFlags();
                    AutoTracker.this.erase();
                    AutoTracker.this.trackerPanel.repaint();
                }
            });
            this.timer.setInitialDelay(n);
            this.mouseOverListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    Component component = (Component)mouseEvent.getSource();
                    while (component.getParent() != null) {
                        if (component == Wizard.this.templateToolbar || component == Wizard.this.searchToolbar || component == Wizard.this.targetToolbar || component == Wizard.this.imageToolbar) {
                            Wizard.this.mouseOverObj = component;
                            AutoTracker.this.isInteracting = component == Wizard.this.targetToolbar;
                            AutoTracker.this.isInteracting = true;
                            break;
                        }
                        component = component.getParent();
                    }
                    if (Wizard.this.mouseOverObj == null) {
                        Wizard.this.refreshInfo();
                        Wizard.this.refreshDrawingFlags();
                        AutoTracker.this.erase();
                        AutoTracker.this.trackerPanel.repaint();
                    } else {
                        Wizard.this.timer.restart();
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    Wizard.this.timer.restart();
                    Wizard.this.mouseOverObj = null;
                    AutoTracker.this.isInteracting = false;
                }
            };
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                    if (AutoTracker.this.track != null) {
                        AutoTracker.this.trackerPanel.setSelectedTrack(AutoTracker.this.track);
                    }
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            this.setContentPane(jPanel);
            this.trackDropdown = new JComboBox(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    --dimension.height;
                    return dimension;
                }
            };
            this.trackDropdown.addMouseListener(this.mouseOverListener);
            int n2 = 0;
            while (n2 < this.trackDropdown.getComponentCount()) {
                this.trackDropdown.getComponent(n2).addMouseListener(this.mouseOverListener);
                ++n2;
            }
            this.trackDropdown.setRenderer(new TrackRenderer());
            this.trackDropdown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if ("refresh".equals(Wizard.this.trackDropdown.getName())) {
                        return;
                    }
                    Object[] objectArray = (Object[])Wizard.this.trackDropdown.getSelectedItem();
                    if (objectArray != null) {
                        for (TTrack tTrack : AutoTracker.this.trackerPanel.getTracks()) {
                            if (!objectArray[1].equals(tTrack.getName())) continue;
                            AutoTracker.this.setTrack(tTrack);
                            Wizard.this.refreshGUI();
                        }
                    }
                }
            });
            this.startPanel = new JPanel();
            this.startButton = new JButton();
            this.startButton.setDisabledIcon(graySearchIcon);
            this.startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AutoTracker.this.stepping) {
                        AutoTracker.this.stop(false, false);
                    } else {
                        AutoTracker.this.search(true, true);
                    }
                }
            });
            this.startButton.addKeyListener(keyAdapter);
            this.startPanel.add(this.startButton);
            this.searchThisButton = new JButton();
            this.searchThisButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AutoTracker.this.search(true, false);
                }
            });
            this.searchThisButton.addKeyListener(keyAdapter);
            this.startPanel.add(this.searchThisButton);
            this.searchNextButton = new JButton();
            this.searchNextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AutoTracker.this.search(false, false);
                }
            });
            this.searchNextButton.addKeyListener(keyAdapter);
            this.startPanel.add(this.searchNextButton);
            this.followupPanel = new JPanel();
            this.followupPanel.setBorder(BorderFactory.createEmptyBorder());
            this.followupPanel.setOpaque(false);
            this.imageToolbar = new JToolBar();
            this.imageToolbar.setFloatable(false);
            this.frameLabel = new JLabel();
            this.frameLabel.setOpaque(false);
            this.frameLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.templateImageLabel = new JLabel();
            this.templateImageLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.templateImageLabel.setIconTextGap(3);
            this.templateImageLabel.setHorizontalTextPosition(2);
            this.templateImageLabel.addMouseListener(this.mouseOverListener);
            this.matchImageLabel = new JLabel();
            this.matchImageLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.matchImageLabel.setIconTextGap(3);
            this.matchImageLabel.setHorizontalTextPosition(2);
            this.matchImageLabel.addMouseListener(this.mouseOverListener);
            JPanel jPanel2 = new JPanel();
            jPanel2.setOpaque(false);
            jPanel2.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.add(this.templateImageLabel);
            jPanel2.add(this.matchImageLabel);
            this.imageToolbar.add(this.frameLabel);
            this.imageToolbar.add(jPanel2);
            this.imageToolbar.addMouseListener(this.mouseOverListener);
            this.templateToolbar = new JToolBar();
            this.templateToolbar.setFloatable(false);
            this.templateToolbar.addMouseListener(this.mouseOverListener);
            this.templateLabel = new JLabel();
            this.templateLabel.setOpaque(false);
            this.templateLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.evolveRateLabel = new JLabel();
            this.evolveRateLabel.setOpaque(false);
            this.evolveRateLabel.addMouseListener(this.mouseOverListener);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(defaultEvolveRate, 0, maxEvolveRate, maxEvolveRate / 20);
            this.evolveSpinner = new TallSpinner(spinnerNumberModel, this.trackDropdown);
            int n3 = 0;
            while (n3 < this.evolveSpinner.getComponentCount()) {
                this.evolveSpinner.getComponent(n3).addMouseListener(this.mouseOverListener);
                ++n3;
            }
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.evolveSpinner.getEditor()).getTextField();
            jFormattedTextField.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
                    JFormattedTextField.AbstractFormatter abstractFormatter = new JFormattedTextField.AbstractFormatter(){

                        @Override
                        public String valueToString(Object object) throws ParseException {
                            return String.valueOf(object.toString()) + "%";
                        }

                        @Override
                        public Object stringToValue(String string) throws ParseException {
                            return Integer.parseInt(string.substring(0, string.length() - 1));
                        }
                    };
                    return abstractFormatter;
                }
            });
            jFormattedTextField.addMouseListener(this.mouseOverListener);
            jFormattedTextField.setEnabled(false);
            jFormattedTextField.setDisabledTextColor(Color.BLACK);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Integer n = (Integer)Wizard.this.evolveSpinner.getValue();
                    Wizard.this.setAlphaFromRate(n);
                    int n2 = AutoTracker.this.trackerPanel.getFrameNumber();
                    FrameData frameData = AutoTracker.this.getFrame(n2);
                    AutoTracker.this.buildEvolvedTemplate(frameData);
                    if (frameData.isKeyFrame()) {
                        AutoTracker.this.refreshKeyFrame((KeyFrame)frameData);
                    }
                    AutoTracker.this.stop(true, false);
                    Wizard.this.setChanged();
                }
            };
            this.evolveSpinner.addChangeListener(changeListener);
            this.setAlphaFromRate((Integer)this.evolveSpinner.getValue());
            this.acceptLabel = new JLabel();
            this.acceptLabel.setOpaque(false);
            this.acceptLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            spinnerNumberModel = new SpinnerNumberModel(AutoTracker.this.goodMatch, AutoTracker.this.possibleMatch, 10, 1);
            this.acceptSpinner = new TallSpinner(spinnerNumberModel, this.trackDropdown);
            int n4 = 0;
            while (n4 < this.acceptSpinner.getComponentCount()) {
                this.acceptSpinner.getComponent(n4).addMouseListener(this.mouseOverListener);
                ++n4;
            }
            jFormattedTextField = ((JSpinner.DefaultEditor)this.acceptSpinner.getEditor()).getTextField();
            jFormattedTextField.setEnabled(false);
            jFormattedTextField.setDisabledTextColor(Color.BLACK);
            jFormattedTextField.addMouseListener(this.mouseOverListener);
            changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    AutoTracker.this.goodMatch = (Integer)Wizard.this.acceptSpinner.getValue();
                    Wizard.this.setChanged();
                }
            };
            this.acceptSpinner.addChangeListener(changeListener);
            jPanel2 = new JPanel();
            jPanel2.setOpaque(false);
            jPanel2.add(this.evolveRateLabel);
            jPanel2.add(this.evolveSpinner);
            jPanel2.add(this.acceptLabel);
            jPanel2.add(this.acceptSpinner);
            this.templateToolbar.add(this.templateLabel);
            this.templateToolbar.add(jPanel2);
            this.searchToolbar = new JToolBar();
            this.searchToolbar.setFloatable(false);
            this.searchToolbar.addMouseListener(this.mouseOverListener);
            this.searchLabel = new JLabel();
            this.searchLabel.setOpaque(false);
            this.searchLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.oneDCheckbox = new JCheckBox();
            this.oneDCheckbox.addMouseListener(this.mouseOverListener);
            this.oneDCheckbox.setOpaque(false);
            this.oneDCheckbox.setSelected(AutoTracker.this.lineSpread >= 0);
            this.oneDCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AutoTracker.this.lineSpread = Wizard.this.oneDCheckbox.isSelected() ? 0 : -1;
                    Wizard.this.setChanged();
                    if (Wizard.this.oneDCheckbox.isSelected()) {
                        int n = AutoTracker.this.trackerPanel.getFrameNumber();
                        CoordAxes coordAxes = AutoTracker.this.trackerPanel.getAxes();
                        KeyFrame keyFrame = AutoTracker.this.getFrame(n).getKeyFrame();
                        if (keyFrame != null) {
                            n = keyFrame.getFrameNumber();
                            TPoint[] tPointArray = keyFrame.getMaskPoints();
                            coordAxes.getOrigin().setXY(tPointArray[0].x, tPointArray[0].y);
                        }
                        coordAxes.setVisible(true);
                    }
                    AutoTracker.this.trackerPanel.repaint();
                }
            });
            this.lookAheadCheckbox = new JCheckBox();
            this.lookAheadCheckbox.addMouseListener(this.mouseOverListener);
            this.lookAheadCheckbox.setOpaque(false);
            this.lookAheadCheckbox.setSelected(AutoTracker.this.lookAhead);
            this.lookAheadCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AutoTracker.this.lookAhead = Wizard.this.lookAheadCheckbox.isSelected();
                    Wizard.this.setChanged();
                }
            });
            jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            jPanel2.setOpaque(false);
            jPanel2.add(this.oneDCheckbox);
            jPanel2.add(this.lookAheadCheckbox);
            this.searchToolbar.add(this.searchLabel);
            this.searchToolbar.add(jPanel2);
            this.targetToolbar = new JToolBar();
            this.targetToolbar.setFloatable(false);
            this.targetToolbar.addMouseListener(this.mouseOverListener);
            this.targetLabel = new JLabel();
            this.targetLabel.setOpaque(false);
            this.targetLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.trackLabel = new JLabel();
            this.trackLabel.setOpaque(false);
            this.pointLabel = new JLabel();
            this.pointLabel.setOpaque(false);
            this.pointLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            this.pointDropdown = new JComboBox(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.height = ((Wizard)Wizard.this).trackDropdown.getPreferredSize().height;
                    return dimension;
                }
            };
            this.pointDropdown.addMouseListener(this.mouseOverListener);
            n4 = 0;
            while (n4 < this.pointDropdown.getComponentCount()) {
                this.pointDropdown.getComponent(n4).addMouseListener(this.mouseOverListener);
                ++n4;
            }
            this.pointDropdown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if ("refresh".equals(Wizard.this.pointDropdown.getName())) {
                        return;
                    }
                    String string = (String)Wizard.this.pointDropdown.getSelectedItem();
                    if (string != null) {
                        AutoTracker.this.track.setTargetIndex(string);
                        int n = AutoTracker.this.trackerPanel.getFrameNumber();
                        FrameData frameData = AutoTracker.this.getFrame(n);
                        TPoint[] tPointArray = frameData.getSearchPoints(true);
                        if (tPointArray != null) {
                            AutoTracker.this.setSearchPoints(tPointArray[0], tPointArray[1]);
                        }
                        Wizard.this.refreshGUI();
                    }
                }
            });
            this.targetPanel = new JPanel();
            this.targetPanel.setOpaque(false);
            this.targetPanel.add(this.trackLabel);
            this.targetPanel.add(this.trackDropdown);
            this.targetPanel.add(this.pointLabel);
            this.targetPanel.add(this.pointDropdown);
            this.targetToolbar.add(this.targetLabel);
            this.targetToolbar.add(this.targetPanel);
            this.textPane = new JTextArea();
            this.textPane.setEditable(false);
            this.textPane.setLineWrap(true);
            this.textPane.setWrapStyleWord(true);
            this.textPane.setBorder(BorderFactory.createEmptyBorder());
            this.textPane.setForeground(Color.blue);
            this.textPane.addKeyListener(keyAdapter);
            this.textPane.addMouseListener(this.mouseOverListener);
            this.closeButton = new JButton();
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Wizard.this.setVisible(false);
                }
            });
            this.closeButton.addKeyListener(keyAdapter);
            this.helpButton = new JButton();
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AutoTracker.this.trackerPanel.getTFrame().showHelp("autotracker", 0);
                }
            });
            this.helpButton.addKeyListener(keyAdapter);
            this.acceptButton = new JButton();
            this.acceptButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AutoTracker.this.trackerPanel.getFrameNumber();
                    FrameData frameData = AutoTracker.this.getFrame(n);
                    TemplateMatcher templateMatcher = AutoTracker.this.getTemplateMatcher();
                    templateMatcher.setTemplate(frameData.getTemplate());
                    templateMatcher.setWorkingPixels(frameData.getWorkingPixels());
                    AutoTracker.this.buildEvolvedTemplate(frameData);
                    AutoTracker.this.marking = true;
                    TPoint tPoint = AutoTracker.this.getMatchTarget(frameData.getMatchPoints()[0]);
                    TPoint tPoint2 = AutoTracker.this.track.autoMarkAt(n, tPoint.x, tPoint.y);
                    frameData.setAutoMarkPoint(tPoint2);
                    frameData.decided = true;
                    if (AutoTracker.this.stepping && AutoTracker.this.canStep()) {
                        AutoTracker.this.paused = false;
                        AutoTracker.this.trackerPanel.getPlayer().step();
                    } else {
                        AutoTracker.this.stop(true, true);
                    }
                }
            });
            this.acceptButton.addKeyListener(keyAdapter);
            this.skipButton = new JButton();
            this.skipButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AutoTracker.this.trackerPanel.getFrameNumber();
                    FrameData frameData = AutoTracker.this.getFrame(n);
                    frameData.decided = true;
                    if (AutoTracker.this.canStep()) {
                        AutoTracker.this.paused = false;
                        AutoTracker.this.trackerPanel.getPlayer().step();
                    } else {
                        AutoTracker.this.stop(true, false);
                    }
                }
            });
            this.skipButton.addKeyListener(keyAdapter);
            final AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    Object object2;
                    int n = AutoTracker.this.trackerPanel.getFrameNumber();
                    KeyFrame keyFrame = AutoTracker.this.getFrame(n).getKeyFrame();
                    Map<Integer, FrameData> map = AutoTracker.this.getFrameData();
                    int n2 = -1;
                    block0: for (Integer object32 : map.keySet()) {
                        FrameData n4 = map.get(object32);
                        if (!n4.isKeyFrame() || n4 != keyFrame) continue;
                        object2 = map.keySet().iterator();
                        while (object2.hasNext()) {
                            FrameData frameData;
                            int iterator = object2.next();
                            if (iterator <= object32 || !(frameData = map.get(iterator)).isKeyFrame()) continue;
                            n2 = iterator;
                            break block0;
                        }
                        break block0;
                    }
                    FrameData frameData = new FrameData(keyFrame);
                    map.put(n, frameData);
                    keyFrame = AutoTracker.this.getFrame(n).getKeyFrame();
                    if (keyFrame != null) {
                        AutoTracker.this.maskCenter.setLocation(keyFrame.getMaskPoints()[0]);
                        AutoTracker.this.maskCorner.setLocation(keyFrame.getMaskPoints()[1]);
                    } else {
                        object = new ArrayList();
                        for (int n5 : map.keySet()) {
                            if (n2 > -1 && n5 >= n2) break;
                            object2 = map.get(n5);
                            ((FrameData)object2).clear();
                            ((ArrayList)object).add(n5);
                        }
                        Iterator<Integer> iterator = ((ArrayList)object).iterator();
                        while (iterator.hasNext()) {
                            int n6 = iterator.next();
                            map.remove(n6);
                        }
                    }
                    if (AutoTracker.this.track.getStep(n) == null) {
                        object = AutoTracker.this.getFrame(n);
                        if (object != null) {
                            ((FrameData)object).setTemplateIcon(null);
                            ((FrameData)object).setSearchPoints(null);
                        }
                        for (int n3 : map.keySet()) {
                            if (n3 <= n || ((FrameData)(object = map.get(n3))).isKeyFrame() || AutoTracker.this.track.getStep(n3) != null) continue;
                            ((FrameData)object).clear();
                        }
                    }
                    Wizard.this.refreshGUI();
                    AutoTracker.this.repaint();
                    AutoTracker.this.trackerPanel.repaint();
                }
            };
            final AbstractAction abstractAction2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl;
                    int n = AutoTracker.this.trackerPanel.getFrameNumber();
                    Map<Integer, FrameData> map = AutoTracker.this.getFrameData();
                    FrameData frameData = map.get(n);
                    if (!frameData.isKeyFrame()) {
                        map.get(n).clear();
                        map.remove(n);
                    } else {
                        frameData.clear();
                    }
                    boolean bl2 = bl = ((AutoTracker)((Wizard)Wizard.this).AutoTracker.this).track.steps.isAutofill() || AutoTracker.this.track instanceof CoordAxes;
                    if (!bl && AutoTracker.this.track.getSteps().length > n) {
                        ((AutoTracker)((Wizard)Wizard.this).AutoTracker.this).track.getSteps()[n] = null;
                    }
                    Wizard.this.refreshGUI();
                    AutoTracker.this.repaint();
                    AutoTracker.this.trackerPanel.repaint();
                }
            };
            final AbstractAction abstractAction3 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n3;
                    int n2 = AutoTracker.this.trackerPanel.getFrameNumber();
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    Map<Integer, FrameData> map = AutoTracker.this.getFrameData();
                    for (int n3 : map.keySet()) {
                        if (n3 <= n2) continue;
                        FrameData frameData = map.get(n3);
                        frameData.clear();
                        arrayList.add(n3);
                    }
                    for (int n3 : arrayList) {
                        map.remove(n3);
                    }
                    int n4 = n3 = !((AutoTracker)((Wizard)Wizard.this).AutoTracker.this).track.steps.isAutofill() && !(AutoTracker.this.track instanceof CoordAxes) ? 0 : 1;
                    if (n3 == 0) {
                        Iterator<Integer> iterator = AutoTracker.this.track.getSteps();
                        int n5 = n2 + 1;
                        while (n5 < ((Iterator<Integer>)iterator).length) {
                            iterator[n5] = null;
                            ++n5;
                        }
                    }
                    Wizard.this.refreshGUI();
                    AutoTracker.this.repaint();
                }
            };
            final AbstractAction abstractAction4 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AutoTracker.this.reset();
                }
            };
            this.deleteButton = new JButton();
            this.deleteButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    int n = AutoTracker.this.trackerPanel.getFrameNumber();
                    boolean bl = ((AutoTracker)((Wizard)Wizard.this).AutoTracker.this).track.steps.isAutofill() || AutoTracker.this.track instanceof CoordAxes;
                    boolean bl2 = false;
                    boolean bl3 = AutoTracker.this.getFrame(n).isKeyFrame();
                    int n2 = 0;
                    boolean bl4 = false;
                    if (bl) {
                        object = AutoTracker.this.getFrameData();
                        for (Integer serializable2 : object.keySet()) {
                            FrameData frameData = (FrameData)object.get(serializable2);
                            if (frameData.trackPoint == null) continue;
                            bl4 = bl4 || serializable2 > n;
                            bl2 = bl2 || serializable2 == n;
                            ++n2;
                        }
                    } else {
                        void var9_12;
                        bl2 = AutoTracker.this.track.getStep(n) != null;
                        object = AutoTracker.this.track.getSteps();
                        boolean n3 = false;
                        while (var9_12 < ((Object)object).length) {
                            if (object[var9_12] != null) {
                                bl4 = bl4 || var9_12 > n;
                                ++n2;
                            }
                            ++var9_12;
                        }
                    }
                    object = new JPopupMenu();
                    if (bl3) {
                        JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteThisKeyFrame"));
                        ((JPopupMenu)object).add(jMenuItem);
                        jMenuItem.addActionListener(abstractAction);
                    }
                    if (bl2) {
                        JMenuItem jMenuItem = new JMenuItem(bl ? TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteThisMatch") : TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteThis"));
                        ((JPopupMenu)object).add(jMenuItem);
                        jMenuItem.addActionListener(abstractAction2);
                    }
                    if (bl4) {
                        JMenuItem jMenuItem = new JMenuItem(bl ? TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteLaterMatches") : TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteLater"));
                        ((JPopupMenu)object).add(jMenuItem);
                        jMenuItem.addActionListener(abstractAction3);
                    }
                    if (!(n2 <= 0 || n2 == 1 && bl2)) {
                        JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteAll"));
                        ((JPopupMenu)object).add(jMenuItem);
                        jMenuItem.addActionListener(abstractAction4);
                    }
                    FontSizer.setFonts(object, FontSizer.getLevel());
                    ((JPopupMenu)object).show(Wizard.this.deleteButton, 0, Wizard.this.deleteButton.getHeight());
                }
            });
            this.deleteButton.addKeyListener(keyAdapter);
            this.keyFrameButton = new JButton();
            this.keyFrameButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Serializable serializable22;
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    Map<Integer, FrameData> map = AutoTracker.this.getFrameData();
                    for (Serializable serializable22 : map.keySet()) {
                        FrameData object = map.get(serializable22);
                        if (!object.isKeyFrame()) continue;
                        arrayList.add((Integer)serializable22);
                    }
                    serializable22 = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = Integer.parseInt(actionEvent.getActionCommand());
                            VideoClip videoClip = AutoTracker.this.trackerPanel.getPlayer().getVideoClip();
                            AutoTracker.this.trackerPanel.getPlayer().setStepNumber(videoClip.frameToStep(n));
                        }
                    };
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    for (Integer n : arrayList) {
                        String string = TrackerRes.getString("AutoTracker.Label.Frame");
                        JMenuItem jMenuItem = new JMenuItem(String.valueOf(string) + " " + n);
                        jMenuItem.addActionListener((ActionListener)((Object)serializable22));
                        jMenuItem.setActionCommand(String.valueOf(n));
                        jPopupMenu.add(jMenuItem);
                    }
                    FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                    jPopupMenu.show(Wizard.this.keyFrameButton, 0, Wizard.this.keyFrameButton.getHeight());
                }
            });
            this.keyFrameButton.addKeyListener(keyAdapter);
            this.infoPanel = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    if (Wizard.this.textPaneSize != null) {
                        return Wizard.this.textPaneSize;
                    }
                    return super.getPreferredSize();
                }
            };
            Border border = BorderFactory.createEmptyBorder(4, 6, 4, 6);
            Border border2 = BorderFactory.createEtchedBorder();
            this.infoPanel.setBorder(BorderFactory.createCompoundBorder(border2, border));
            this.infoPanel.setBackground(this.textPane.getBackground());
            this.infoPanel.add((Component)this.textPane, "Center");
            this.infoPanel.add((Component)this.followupPanel, "South");
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
            jPanel3.add(this.templateToolbar);
            jPanel3.add(this.searchToolbar);
            jPanel3.add(this.targetToolbar);
            this.northPanel = new JPanel(new BorderLayout());
            this.northPanel.add((Component)this.startPanel, "North");
            this.northPanel.add((Component)this.imageToolbar, "South");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add((Component)jPanel3, "North");
            jPanel4.add((Component)this.infoPanel, "Center");
            JPanel jPanel5 = new JPanel(new FlowLayout());
            jPanel5.add(this.helpButton);
            jPanel5.add(this.keyFrameButton);
            jPanel5.add(this.deleteButton);
            jPanel5.add(this.closeButton);
            jPanel.add((Component)this.northPanel, "North");
            jPanel.add((Component)jPanel4, "Center");
            jPanel.add((Component)jPanel5, "South");
            this.refreshGUI();
        }

        protected void refreshTextPaneSize() {
            this.textPaneSize = null;
            this.followupPanel.removeAll();
            this.followupPanel.add(this.acceptButton);
            this.textPane.setText(this.getTemplateInstructions());
            Dimension dimension = this.infoPanel.getPreferredSize();
            this.textPane.setText(this.getTargetInstructions());
            dimension.height = Math.max(dimension.height, this.infoPanel.getPreferredSize().height);
            this.textPane.setText(this.getSearchInstructions());
            dimension.height = Math.max(dimension.height, this.infoPanel.getPreferredSize().height);
            dimension.height += 6;
            this.textPaneSize = dimension;
            this.refreshButtons();
            this.refreshInfo();
        }

        protected void refreshStrings() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int n;
                    int n2 = AutoTracker.this.trackerPanel.getFrameNumber();
                    FrameData frameData = AutoTracker.this.getFrame(n2);
                    KeyFrame keyFrame = frameData.getKeyFrame();
                    String string = TrackerRes.getString("AutoTracker.Wizard.Title");
                    if (AutoTracker.this.track != null) {
                        n = AutoTracker.this.track.getTargetIndex();
                        string = String.valueOf(string) + ": " + AutoTracker.this.track.getName() + " " + AutoTracker.this.track.getTargetDescription(n);
                    }
                    Wizard.this.setTitle(string);
                    Wizard.this.frameLabel.setText(String.valueOf(TrackerRes.getString("AutoTracker.Label.Frame")) + " " + n2 + ":");
                    Wizard.this.searchLabel.setText(String.valueOf(TrackerRes.getString("AutoTracker.Label.Search")) + ":");
                    Wizard.this.targetLabel.setText(String.valueOf(TrackerRes.getString("AutoTracker.Label.Target")) + ":");
                    Wizard.this.templateLabel.setText(String.valueOf(TrackerRes.getString("AutoTracker.Label.Template")) + ":");
                    Wizard.this.acceptLabel.setText(TrackerRes.getString("AutoTracker.Label.Automark"));
                    Wizard.this.trackLabel.setText(TrackerRes.getString("AutoTracker.Label.Track"));
                    Wizard.this.pointLabel.setText(TrackerRes.getString("AutoTracker.Label.Point"));
                    Wizard.this.evolveRateLabel.setText(TrackerRes.getString("AutoTracker.Label.EvolutionRate"));
                    Wizard.this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
                    Wizard.this.helpButton.setText(TrackerRes.getString("Dialog.Button.Help"));
                    Wizard.this.acceptButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.Accept"));
                    Wizard.this.keyFrameButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.ShowKeyFrame"));
                    Wizard.this.deleteButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.Delete"));
                    Wizard.this.oneDCheckbox.setText(TrackerRes.getString("AutoTracker.Wizard.Checkbox.XAxis"));
                    Wizard.this.lookAheadCheckbox.setText(TrackerRes.getString("AutoTracker.Wizard.Checkbox.LookAhead"));
                    Wizard.this.matchImageLabel.setText(frameData.getMatchIcon() == null ? null : TrackerRes.getString("AutoTracker.Label.Match"));
                    Wizard.this.templateImageLabel.setText(keyFrame == null ? null : TrackerRes.getString("AutoTracker.Label.Template"));
                    if (AutoTracker.this.trackerPanel.getVideo() != null) {
                        n = AutoTracker.this.stepping && !AutoTracker.this.paused ? 1 : 0;
                        Wizard.this.startButton.setIcon(AutoTracker.this.stepping ? stopIcon : searchIcon);
                        Wizard.this.startButton.setText(AutoTracker.this.stepping ? TrackerRes.getString("AutoTracker.Wizard.Button.Stop") : TrackerRes.getString("AutoTracker.Wizard.Button.Search"));
                        FontSizer.setFonts(Wizard.this.startButton, FontSizer.getLevel());
                        Wizard.this.searchThisButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.SearchThis"));
                        Wizard.this.searchThisButton.setEnabled(n == 0);
                        Wizard.this.searchNextButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.SearchNext"));
                        Wizard.this.searchNextButton.setEnabled(n == 0);
                    }
                    FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
                    Font font = Wizard.this.frameLabel.getFont();
                    int n3 = 0;
                    Rectangle2D rectangle2D = font.getStringBounds(String.valueOf(Wizard.this.searchLabel.getText()) + "   ", fontRenderContext);
                    n3 = Math.max(n3, (int)rectangle2D.getWidth() + 4);
                    rectangle2D = font.getStringBounds(String.valueOf(Wizard.this.frameLabel.getText()) + "   ", fontRenderContext);
                    n3 = Math.max(n3, (int)rectangle2D.getWidth() + 4);
                    rectangle2D = font.getStringBounds(String.valueOf(Wizard.this.templateLabel.getText()) + "   ", fontRenderContext);
                    n3 = Math.max(n3, (int)rectangle2D.getWidth() + 4);
                    rectangle2D = font.getStringBounds(String.valueOf(Wizard.this.targetLabel.getText()) + "   ", fontRenderContext);
                    n3 = Math.max(n3, (int)rectangle2D.getWidth() + 4);
                    Dimension dimension = new Dimension(n3, 20);
                    Wizard.this.frameLabel.setPreferredSize(dimension);
                    Wizard.this.templateLabel.setPreferredSize(dimension);
                    Wizard.this.searchLabel.setPreferredSize(dimension);
                    Wizard.this.targetLabel.setPreferredSize(dimension);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        protected void refreshButtons() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    boolean bl;
                    int n = AutoTracker.this.trackerPanel.getFrameNumber();
                    FrameData frameData = AutoTracker.this.getFrame(n);
                    int n2 = AutoTracker.this.getStatusCode(n);
                    KeyFrame keyFrame = frameData.getKeyFrame();
                    boolean bl2 = keyFrame != null && AutoTracker.this.track != null;
                    boolean bl3 = AutoTracker.this.paused || !AutoTracker.this.stepping;
                    boolean bl4 = frameData.searched && !frameData.newTemplateExists();
                    boolean bl5 = !bl4 || n2 == 5 || Wizard.this.changed && n2 != 0 || frameData == keyFrame && frameData.getMarkedPoint() == null;
                    Wizard.this.startButton.setEnabled(bl2);
                    Wizard.this.searchThisButton.setEnabled(bl2 && bl3 && bl5);
                    Wizard.this.searchNextButton.setEnabled(bl2 && AutoTracker.this.canStep() && bl3);
                    if (Wizard.this.templateImageLabel.getIcon() == null && Wizard.this.matchImageLabel.getIcon() == null) {
                        Wizard.this.templateImageLabel.setText(TrackerRes.getString("AutoTracker.Label.NoTemplate"));
                        Wizard.this.matchImageLabel.setText(null);
                        Wizard.this.imageToolbar.setPreferredSize(Wizard.this.templateToolbar.getPreferredSize());
                        Wizard.this.templateImageLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
                    } else {
                        Wizard.this.imageToolbar.setPreferredSize(null);
                        Wizard.this.templateImageLabel.setBorder(null);
                    }
                    boolean bl6 = bl = AutoTracker.this.track != null;
                    if (bl) {
                        boolean bl7;
                        boolean bl8 = bl7 = ((AutoTracker)((Wizard)Wizard.this).AutoTracker.this).track.steps.isAutofill() || AutoTracker.this.track instanceof CoordAxes;
                        if (bl7) {
                            boolean bl9 = false;
                            Map<Integer, FrameData> map = AutoTracker.this.getFrameData();
                            for (Integer n3 : map.keySet()) {
                                FrameData frameData2 = map.get(n3);
                                if (frameData2.trackPoint == null) continue;
                                bl9 = true;
                                break;
                            }
                            bl = bl9 || frameData == keyFrame;
                        } else {
                            bl = frameData == keyFrame || !AutoTracker.this.track.isEmpty();
                        }
                    }
                    Wizard.this.deleteButton.setEnabled(bl);
                    Wizard.this.keyFrameButton.setEnabled(keyFrame != null);
                    Wizard.this.followupPanel.removeAll();
                    if (n2 == 2 || n2 == 8) {
                        Wizard.this.acceptButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.Accept"));
                        Wizard.this.followupPanel.add(Wizard.this.acceptButton);
                    }
                    if (n2 == 2 || n2 == 3 || n2 == 4 || n2 == 8 || n2 == 9) {
                        Wizard.this.skipButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.Skip"));
                        Wizard.this.followupPanel.add(Wizard.this.skipButton);
                    }
                    Wizard.this.repaint();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        protected void refreshDrawingFlags() {
            if (this.mouseOverObj == this.templateToolbar || this.mouseOverObj == this.imageToolbar) {
                AutoTracker.this.maskVisible = true;
                AutoTracker.this.searchVisible = false;
                AutoTracker.this.targetVisible = false;
            } else if (this.mouseOverObj == this.targetToolbar) {
                AutoTracker.this.targetVisible = true;
                AutoTracker.this.maskVisible = false;
                AutoTracker.this.searchVisible = false;
            } else if (this.mouseOverObj == this.searchToolbar) {
                AutoTracker.this.searchVisible = true;
                AutoTracker.this.maskVisible = false;
                AutoTracker.this.targetVisible = false;
            } else {
                AutoTracker.this.maskVisible = true;
                AutoTracker.this.targetVisible = true;
                AutoTracker.this.searchVisible = true;
            }
        }

        protected void refreshGUI() {
            if (AutoTracker.this.track != null && this.isVisible()) {
                AutoTracker.this.track.setMarkByDefault(false);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Wizard.this.refreshDropdowns();
                    Wizard.this.refreshStrings();
                    Wizard.this.refreshIcons();
                    Wizard.this.refreshButtons();
                    Wizard.this.refreshInfo();
                    Wizard.this.refreshDrawingFlags();
                    Wizard.this.pack();
                    if (Wizard.this.textPaneSize == null) {
                        Wizard.this.refreshTextPaneSize();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        protected void refreshDropdowns() {
            Object object;
            Object object2 = null;
            this.trackDropdown.setName("refresh");
            this.trackDropdown.removeAllItems();
            for (TTrack objectArray : AutoTracker.this.trackerPanel.getTracks()) {
                if (!objectArray.isAutoTrackable()) continue;
                object = objectArray.getFootprint().getIcon(21, 16);
                Object[] objectArray2 = new Object[]{object, objectArray.getName()};
                this.trackDropdown.addItem(objectArray2);
                if (objectArray != AutoTracker.this.track) continue;
                object2 = objectArray2;
            }
            if (AutoTracker.this.track == null) {
                Object[] objectArray = new Object[2];
                objectArray[1] = "           ";
                Object[] n = objectArray;
                this.trackDropdown.insertItemAt(n, 0);
                object2 = n;
            }
            if (object2 != null) {
                this.trackDropdown.setSelectedItem(object2);
            }
            this.trackDropdown.setName(null);
            object2 = null;
            this.pointDropdown.setName("refresh");
            this.pointDropdown.removeAllItems();
            if (AutoTracker.this.track != null) {
                int n = AutoTracker.this.track.getTargetIndex();
                object2 = AutoTracker.this.track.getTargetDescription(n);
                int n2 = 0;
                while (n2 < AutoTracker.this.track.getStepLength()) {
                    object = AutoTracker.this.track.getTargetDescription(n2);
                    if (AutoTracker.this.track.isAutoTrackable(n2) && object != null) {
                        this.pointDropdown.addItem(object);
                    }
                    ++n2;
                }
            } else {
                this.pointDropdown.addItem("         ");
            }
            if (object2 != null) {
                this.pointDropdown.setSelectedItem(object2);
            }
            this.pointDropdown.setName("");
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Wizard.this.startButton.requestFocusInWindow();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        protected void refreshIcons() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (AutoTracker.this.getTemplateMatcher() == null || AutoTracker.this.track == null) {
                        Wizard.this.templateImageLabel.setIcon(null);
                        Wizard.this.matchImageLabel.setIcon(null);
                        return;
                    }
                    int n = AutoTracker.this.trackerPanel.getFrameNumber();
                    FrameData frameData = AutoTracker.this.getFrame(n);
                    Icon icon = frameData.getMatchIcon();
                    Wizard.this.matchImageLabel.setIcon(icon);
                    icon = frameData.getTemplateIcon();
                    if (icon == null) {
                        frameData.getTemplateToMatch();
                        icon = frameData.getTemplateIcon();
                    }
                    Wizard.this.templateImageLabel.setIcon(icon);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        protected void replaceIcons(final KeyFrame keyFrame) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (AutoTracker.this.trackerPanel.getVideo() == null || AutoTracker.this.track == null) {
                        Wizard.this.templateImageLabel.setIcon(null);
                        Wizard.this.matchImageLabel.setIcon(null);
                        return;
                    }
                    keyFrame.setTemplateMatcher(null);
                    TemplateMatcher templateMatcher = AutoTracker.this.getTemplateMatcher();
                    if (templateMatcher != null) {
                        keyFrame.setTemplate(templateMatcher);
                        Icon icon = keyFrame.getTemplateIcon();
                        keyFrame.setMatchIcon(icon);
                        Wizard.this.matchImageLabel.setIcon(icon);
                        Wizard.this.templateImageLabel.setIcon(icon);
                        Wizard.this.pack();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        protected void refreshInfo() {
            if (AutoTracker.this.trackerPanel.getVideo() == null) {
                this.textPane.setForeground(Color.red);
                this.textPane.setText(TrackerRes.getString("AutoTracker.Info.NoVideo"));
                return;
            }
            this.textPane.setForeground(Color.blue);
            if (AutoTracker.this.track == null) {
                this.textPane.setText(TrackerRes.getString("AutoTracker.Info.SelectTrack"));
                return;
            }
            int n = AutoTracker.this.trackerPanel.getFrameNumber();
            FrameData frameData = AutoTracker.this.getFrame(n);
            KeyFrame keyFrame = frameData.getKeyFrame();
            if (keyFrame == null) {
                String string = TrackerRes.getString("AutoTracker.Info.GetStarted");
                string = String.valueOf(string) + " " + TrackerRes.getString("AutoTracker.Info.MouseOver.Instructions");
                this.textPane.setText(string);
                if (this.mouseOverObj == null) {
                    return;
                }
            }
            this.textPane.setForeground(new Color(140, 80, 80));
            if (this.mouseOverObj == this.templateToolbar || this.mouseOverObj == this.imageToolbar) {
                this.textPane.setText(this.getTemplateInstructions());
                return;
            }
            if (this.mouseOverObj == this.targetToolbar) {
                this.textPane.setText(this.getTargetInstructions());
                return;
            }
            if (this.mouseOverObj == this.searchToolbar) {
                this.textPane.setText(this.getSearchInstructions());
                return;
            }
            this.textPane.setForeground(Color.blue);
            int n2 = AutoTracker.this.getStatusCode(n);
            double[] dArray = frameData.getMatchWidthAndHeight();
            this.textPane.setText(this.getStatusInfo(n2, n, dArray));
        }

        protected String getTemplateInstructions() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Mask1"));
            stringBuffer.append(" ");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.GetStarted"));
            stringBuffer.append("\n\n");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Mask2"));
            stringBuffer.append("\n\n");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Title.Settings"));
            stringBuffer.append(": ");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Mask.Instructions"));
            stringBuffer.append("\n\n");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Title.Tip"));
            stringBuffer.append(": ");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Mask.Tip"));
            return stringBuffer.toString();
        }

        protected String getSearchInstructions() {
            StringBuffer stringBuffer = new StringBuffer();
            if (AutoTracker.this.lineSpread >= 0) {
                stringBuffer.append(TrackerRes.getString("AutoTracker.Info.SearchOnAxis"));
            } else {
                stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Search"));
            }
            stringBuffer.append("\n\n");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Title.Settings"));
            stringBuffer.append(": ");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Search.Instructions"));
            stringBuffer.append("\n\n");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Title.Tip"));
            stringBuffer.append(": ");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Search.Tip"));
            return stringBuffer.toString();
        }

        protected String getTargetInstructions() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Target"));
            stringBuffer.append("\n\n");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Title.Settings"));
            stringBuffer.append(": ");
            stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Target.Instructions"));
            return stringBuffer.toString();
        }

        protected String getStatusInfo(int n, int n2, double[] dArray) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.Frame")) + " " + n2);
            switch (n) {
                case 0: {
                    this.textPane.setForeground(Color.blue);
                    stringBuffer.append(" (");
                    stringBuffer.append(TrackerRes.getString("AutoTracker.Info.KeyFrame").toLowerCase());
                    stringBuffer.append("): ");
                    stringBuffer.append(TrackerRes.getString("AutoTracker.Info.KeyFrame.Instructions1"));
                    stringBuffer.append("\n\n");
                    stringBuffer.append(TrackerRes.getString("AutoTracker.Info.KeyFrame.Instructions2"));
                    stringBuffer.append(" ");
                    stringBuffer.append(TrackerRes.getString("AutoTracker.Info.MouseOver.Instructions"));
                    break;
                }
                case 1: {
                    this.textPane.setForeground(Color.green.darker());
                    stringBuffer.append(" (" + TrackerRes.getString("AutoTracker.Info.MatchScore"));
                    stringBuffer.append(" " + format.format(dArray[1]) + "): ");
                    stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Match"));
                    break;
                }
                case 2: {
                    this.textPane.setForeground(Color.red);
                    stringBuffer.append(" (" + TrackerRes.getString("AutoTracker.Info.MatchScore"));
                    stringBuffer.append(" " + format.format(dArray[1]) + "): ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.PossibleOnAxis")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Accept"));
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.Possible")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Accept"));
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Mark"));
                    stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.NewKeyFrame"));
                    if (!AutoTracker.this.canStep()) break;
                    stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Skip"));
                    break;
                }
                case 3: {
                    this.textPane.setForeground(Color.red);
                    stringBuffer.append(": ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatchOnAxis")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatch")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Mark"));
                    stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.NewKeyFrame"));
                    if (!AutoTracker.this.canStep()) break;
                    stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Skip"));
                    break;
                }
                case 4: {
                    this.textPane.setForeground(Color.red);
                    stringBuffer.append(": ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.OutsideXAxis")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.Outside")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Mark"));
                    if (!AutoTracker.this.canStep()) break;
                    stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Skip"));
                    break;
                }
                case 5: {
                    this.textPane.setForeground(Color.blue);
                    stringBuffer.append(": ");
                    stringBuffer.append(TrackerRes.getString("AutoTracker.Info.MarkedByUser"));
                    break;
                }
                case 6: {
                    this.textPane.setForeground(Color.green.darker());
                    stringBuffer.append(" (" + TrackerRes.getString("AutoTracker.Info.MatchScore"));
                    stringBuffer.append(" " + format.format(dArray[1]) + "): ");
                    stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Accepted"));
                    break;
                }
                case 7: {
                    this.textPane.setForeground(Color.blue);
                    stringBuffer.append(" (");
                    stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Unsearched"));
                    stringBuffer.append("): ");
                    stringBuffer.append(TrackerRes.getString("AutoTracker.Info.Instructions"));
                    stringBuffer.append(" ");
                    stringBuffer.append(TrackerRes.getString("AutoTracker.Info.GetStarted"));
                    stringBuffer.append("\n\n");
                    stringBuffer.append(TrackerRes.getString("AutoTracker.Info.MouseOver.Instructions"));
                    break;
                }
                case 8: {
                    this.textPane.setForeground(Color.blue);
                    stringBuffer.append(" (" + TrackerRes.getString("AutoTracker.Info.MatchScore"));
                    stringBuffer.append(" " + format.format(dArray[1]) + "): ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.PossibleReplace")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Replace"));
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Keep"));
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.PossibleReplace")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Replace"));
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Keep"));
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.NewKeyFrame"));
                    break;
                }
                case 9: {
                    this.textPane.setForeground(Color.red);
                    stringBuffer.append(": ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatchOnAxis")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatch")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    if (AutoTracker.this.canStep()) {
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Keep"));
                    }
                    stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.NewKeyFrame"));
                    break;
                }
                case 10: {
                    this.textPane.setForeground(Color.red);
                    stringBuffer.append(": ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatchOnAxis")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        stringBuffer.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatch")) + "\n");
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    if (AutoTracker.this.canStep()) {
                        stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.Keep"));
                    }
                    stringBuffer.append("\n" + TrackerRes.getString("AutoTracker.Info.NewKeyFrame"));
                }
            }
            return stringBuffer.toString();
        }
    }
}

