/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.opensourcephysics.cabrillo.tracker.AnalyticFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class AnalyticParticle
extends ParticleModel {
    UserFunction[] functions;

    @Override
    protected void initializeFunctionPanel() {
        this.functionEditor = new UserFunctionEditor();
        this.functionPanel = new AnalyticFunctionPanel(this.functionEditor, this);
        this.createMassAndTimeParameters();
        String[] stringArray = new String[]{"t"};
        UserFunction[] userFunctionArray = new UserFunction[2];
        userFunctionArray[0] = new UserFunction("x");
        userFunctionArray[0].setNameEditable(false);
        userFunctionArray[0].setExpression("0", stringArray);
        userFunctionArray[0].setDescription(TrackerRes.getString("AnalyticParticle.PositionFunction.X.Description"));
        userFunctionArray[1] = new UserFunction("y");
        userFunctionArray[1].setNameEditable(false);
        userFunctionArray[1].setExpression("0", stringArray);
        userFunctionArray[1].setDescription(TrackerRes.getString("AnalyticParticle.PositionFunction.Y.Description"));
        this.functionEditor.setMainFunctions(userFunctionArray);
    }

    @Override
    protected Point2D[] getNextTracePositions() {
        double d = this.functions[0].evaluate(this.time);
        double d2 = this.functions[1].evaluate(this.time);
        this.point.setLocation(d, d2);
        return new Point2D[]{this.point};
    }

    @Override
    protected void reset() {
        super.reset();
        this.t0 = this.getInitialValues()[0];
        this.functions = this.getFunctionEditor().getMainFunctions();
        if (this.trackerPanel != null) {
            this.erase();
            this.dt = this.trackerPanel.getPlayer().getMeanStepDuration() / (double)(1000 * tracePtsPerStep);
            VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
            int n = Math.min(this.getEndFrame(), videoClip.getFrameCount() - 1);
            while (n > this.getStartFrame() && !videoClip.includesFrame(n)) {
                --n;
            }
            if (n == this.getStartFrame() && !videoClip.includesFrame(this.getStartFrame())) {
                this.steps.setLength(1);
                this.steps.setStep(0, null);
                for (TrackerPanel trackerPanel : this.panels) {
                    this.getVArray(trackerPanel).setLength(0);
                    this.getAArray(trackerPanel).setLength(0);
                }
                this.traceX = new double[0];
                this.traceY = new double[0];
                this.support.firePropertyChange("steps", null, null);
                return;
            }
            int n2 = this.getStartFrame();
            while (n2 < n && !videoClip.includesFrame(n2)) {
                ++n2;
            }
            this.steps.setLength(n2 + 1);
            PositionStep positionStep = (PositionStep)this.getStep(n2);
            int n3 = 0;
            while (n3 < this.steps.length) {
                if (n3 < n2) {
                    this.steps.setStep(n3, null);
                } else if (positionStep == null) {
                    positionStep = new PositionStep(this, n2, 0.0, 0.0);
                    positionStep.setFootprint(this.getFootprint());
                    this.steps.setStep(n2, positionStep);
                }
                ++n3;
            }
            this.getVArray(this.trackerPanel).setLength(0);
            this.getAArray(this.trackerPanel).setLength(0);
            ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
            boolean bl = this.isUseDefaultReferenceFrame();
            while (bl && imageCoordSystem instanceof ReferenceFrame) {
                imageCoordSystem = ((ReferenceFrame)imageCoordSystem).getCoords();
            }
            AffineTransform affineTransform = imageCoordSystem.getToImageTransform(n2);
            UserFunction[] userFunctionArray = this.getFunctionEditor().getMainFunctions();
            this.time = this.trackerPanel.getPlayer().getFrameTime(n2) / 1000.0;
            double d = userFunctionArray[0].evaluate(this.time);
            double d2 = userFunctionArray[1].evaluate(this.time);
            this.point.setLocation(d, d2);
            affineTransform.transform(this.point, this.point);
            this.traceX = new double[]{this.point.getX()};
            this.traceY = new double[]{this.point.getY()};
            positionStep.getPosition().setPosition(this.point);
            this.lastValidFrame = n2;
            this.support.firePropertyChange("step", null, (Object)n2);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    extends ParticleModel.Loader {
        Loader() {
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new AnalyticParticle();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            try {
                XML.getLoader(ParticleModel.class).loadObject(xMLControl, object);
            }
            catch (Exception exception) {
                AnalyticParticle analyticParticle = (AnalyticParticle)object;
                String string = xMLControl.getString("t0");
                analyticParticle.getInitEditor().setExpression("t", string, false);
                String string2 = xMLControl.getString("x");
                analyticParticle.getFunctionEditor().setExpression("x", string2, false);
                String string3 = xMLControl.getString("y");
                analyticParticle.getFunctionEditor().setExpression("y", string3, false);
                analyticParticle.reset();
            }
            return object;
        }
    }
}

