/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool;

import com.xuggle.mediatool.IMediaCoder;
import com.xuggle.mediatool.IMediaGenerator;
import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaViewer;
import com.xuggle.mediatool.MediaListenerAdapter;
import com.xuggle.mediatool.event.IAddStreamEvent;
import com.xuggle.mediatool.event.IAudioSamplesEvent;
import com.xuggle.mediatool.event.ICloseEvent;
import com.xuggle.mediatool.event.IOpenEvent;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IMediaData;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MediaViewer
extends MediaListenerAdapter
implements IMediaListener,
IMediaViewer {
    private static final Logger log = LoggerFactory.getLogger(MediaViewer.class);
    private long mVideoQueueCapacity = TIME_UNIT.convert(1000L, TimeUnit.MILLISECONDS);
    private long mAudioQueueCapacity = TIME_UNIT.convert(1000L, TimeUnit.MILLISECONDS);
    private static final TimeUnit TIME_UNIT = TimeUnit.MICROSECONDS;
    private static final float FONT_SIZE = 20.0f;
    private static final long DEFAULT_VIDEO_EARLY_WINDOW = TIME_UNIT.convert(50L, TimeUnit.MILLISECONDS);
    private static final long DEFAULT_VIDEO_LATE_WINDOW = TIME_UNIT.convert(50L, TimeUnit.MILLISECONDS);
    private static final long DEFAULT_AUDIO_EARLY_WINDOW = TIME_UNIT.convert(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    private static final long DEFAULT_AUDIO_LATE_WINDOW = TIME_UNIT.convert(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    private final Map<Integer, IConverter> mConverters = new HashMap<Integer, IConverter>();
    private final Map<Integer, MediaFrame> mFrames = new HashMap<Integer, MediaFrame>();
    private final Map<Integer, VideoQueue> mVideoQueues = new HashMap<Integer, VideoQueue>();
    private final Map<Integer, AudioQueue> mAudioQueues = new HashMap<Integer, AudioQueue>();
    private final Map<Integer, SourceDataLine> mAudioLines = new HashMap<Integer, SourceDataLine>();
    private final Map<MediaFrame, Integer> mFrameIndex = new HashMap<MediaFrame, Integer>();
    private IContainer mContainer;
    private StatsFrame mStatsFrame;
    private int mNextFrameIndex = 0;
    private final boolean mShowStats;
    private boolean mClosing = false;
    private IMediaViewer.Mode mMode;
    private final int mDefaultCloseOperation;
    private final AtomicLong mStartClockTime = new AtomicLong(Global.NO_PTS);
    private SourceDataLine mDataLine = null;

    public MediaViewer() {
        this(IMediaViewer.Mode.AUDIO_VIDEO, false, 2);
    }

    MediaViewer(IMediaViewer.Mode mode) {
        this(mode, false, 2);
    }

    MediaViewer(boolean showStats) {
        this(IMediaViewer.Mode.AUDIO_VIDEO, showStats, 2);
    }

    MediaViewer(IMediaViewer.Mode mode, boolean showStats) {
        this(mode, showStats, 2);
    }

    MediaViewer(boolean showStats, int defaultCloseOperation) {
        this(IMediaViewer.Mode.AUDIO_VIDEO, showStats, defaultCloseOperation);
    }

    MediaViewer(IMediaViewer.Mode mode, boolean showStats, int defaultCloseOperation) {
        this.setMode(mode);
        this.mShowStats = showStats;
        this.mDefaultCloseOperation = defaultCloseOperation;
    }

    public boolean willShowStatsWindow() {
        return this.mShowStats;
    }

    public int getDefaultCloseOperation() {
        return this.mDefaultCloseOperation;
    }

    private long getMediaTime() {
        if (!this.getMode().isRealTime()) {
            throw new RuntimeException("requested real time when not in real time mode");
        }
        if (this.getMode().playAudio()) {
            if (null == this.mDataLine) {
                return 0L;
            }
            return TIME_UNIT.convert(this.mDataLine.getMicrosecondPosition(), TimeUnit.MICROSECONDS);
        }
        long now = TIME_UNIT.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        this.mStartClockTime.compareAndSet(Global.NO_PTS, now);
        return now - this.mStartClockTime.get();
    }

    private void setMode(IMediaViewer.Mode mode) {
        this.mMode = mode;
    }

    public IMediaViewer.Mode getMode() {
        return this.mMode;
    }

    public void onAddStream(IAddStreamEvent event) {
        if (this.getMode() == IMediaViewer.Mode.DISABLED) {
            return;
        }
        IContainer container = event.getSource().getContainer();
        IStream stream = container.getStream(event.getStreamIndex().intValue());
        IStreamCoder coder = stream.getStreamCoder();
        int streamIndex = event.getStreamIndex();
        if (coder.getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO && this.getMode().showVideo()) {
            MediaFrame frame;
            IConverter converter = this.mConverters.get(streamIndex);
            if (null == converter) {
                converter = ConverterFactory.createConverter("XUGGLER-BGR-24", coder.getPixelType(), coder.getWidth(), coder.getHeight());
                this.mConverters.put(streamIndex, converter);
            }
            if (null == (frame = this.mFrames.get(streamIndex))) {
                frame = new MediaFrame(this.mDefaultCloseOperation, stream, this);
                this.mFrames.put(streamIndex, frame);
                this.mFrameIndex.put(frame, this.mNextFrameIndex++);
            }
            if (this.getMode().isRealTime()) {
                this.getVideoQueue(streamIndex, frame);
            }
        } else if (coder.getCodecType() == ICodec.Type.CODEC_TYPE_AUDIO && this.getMode().playAudio() && this.getMode().isRealTime()) {
            this.getAudioQueue(event.getSource(), streamIndex);
        }
    }

    public void onVideoPicture(IVideoPictureEvent event) {
        if (!this.getMode().showVideo()) {
            return;
        }
        if (null == this.mContainer) {
            if (!(event.getSource() instanceof IMediaCoder)) {
                throw new UnsupportedOperationException();
            }
            this.mContainer = ((IMediaCoder)event.getSource()).getContainer();
        }
        MediaFrame frame = this.mFrames.get(event.getStreamIndex());
        if (this.getMode().isRealTime()) {
            this.getVideoQueue(event.getStreamIndex(), frame).offerMedia(event.getPicture(), event.getTimeStamp(), TimeUnit.MICROSECONDS);
        } else {
            frame.setVideoImage(event.getPicture(), event.getImage());
        }
    }

    private VideoQueue getVideoQueue(int streamIndex, MediaFrame frame) {
        VideoQueue queue = this.mVideoQueues.get(streamIndex);
        if (null == queue) {
            queue = new VideoQueue(this.mVideoQueueCapacity, TIME_UNIT, frame);
            this.mVideoQueues.put(streamIndex, queue);
        }
        return queue;
    }

    public void onAudioSamples(IAudioSamplesEvent event) {
        if (!this.getMode().playAudio()) {
            return;
        }
        if (null == this.mContainer) {
            if (!(event.getSource() instanceof IMediaCoder)) {
                throw new UnsupportedOperationException();
            }
            this.mContainer = ((IMediaCoder)event.getSource()).getContainer();
        }
        IAudioSamples samples = event.getAudioSamples();
        if (this.getMode().isRealTime()) {
            AudioQueue queue = this.getAudioQueue(event.getSource(), event.getStreamIndex());
            if (queue != null) {
                queue.offerMedia(samples, event.getTimeStamp(), event.getTimeUnit());
            }
        } else {
            IStream stream = this.mContainer.getStream(event.getStreamIndex().intValue());
            SourceDataLine line = this.getJavaSoundLine(stream);
            if (line != null) {
                this.playAudio(stream, line, samples);
            }
        }
    }

    private void playAudio(IStream stream, SourceDataLine line, IAudioSamples samples) {
        if (!this.mClosing) {
            int size = samples.getSize();
            line.write(samples.getData().getByteArray(0, size), 0, size);
            this.updateStreamStats(stream, samples);
        }
    }

    private AudioQueue getAudioQueue(IMediaGenerator tool, int streamIndex) {
        if (!(tool instanceof IMediaCoder)) {
            throw new UnsupportedOperationException();
        }
        AudioQueue queue = this.mAudioQueues.get(streamIndex);
        IStream stream = ((IMediaCoder)tool).getContainer().getStream(streamIndex);
        SourceDataLine line = this.getJavaSoundLine(stream);
        if (null == queue && line != null) {
            queue = new AudioQueue(this.mAudioQueueCapacity, TIME_UNIT, stream, line);
            this.mAudioQueues.put(streamIndex, queue);
        }
        return queue;
    }

    private void flush() {
        for (VideoQueue videoQueue : this.mVideoQueues.values()) {
            videoQueue.flush();
        }
        for (AudioQueue audioQueue : this.mAudioQueues.values()) {
            audioQueue.flush();
        }
        for (SourceDataLine sourceDataLine : this.mAudioLines.values()) {
            sourceDataLine.drain();
        }
    }

    public void onOpen(IOpenEvent event) {
        this.mContainer = event.getSource().getContainer();
    }

    public void onClose(ICloseEvent event) {
        this.mClosing = true;
        this.flush();
        for (AudioQueue audioQueue : this.mAudioQueues.values()) {
            audioQueue.close();
        }
        for (VideoQueue videoQueue : this.mVideoQueues.values()) {
            videoQueue.close();
        }
        for (SourceDataLine sourceDataLine : this.mAudioLines.values()) {
            sourceDataLine.stop();
            sourceDataLine.close();
        }
        this.mClosing = false;
    }

    private void updateStreamStats(IStream stream, IMediaData mediaData) {
        if (this.mShowStats) {
            if (null == this.mStatsFrame) {
                this.mStatsFrame = new StatsFrame(2, this);
            }
            this.mStatsFrame.update(stream, mediaData);
        }
    }

    private static void drawStats(IVideoPicture picture, BufferedImage image) {
        if (image == null) {
            throw new RuntimeException("must be used with a IMediaGenerator that created BufferedImages");
        }
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String timeStamp = picture.getFormattedTimeStamp();
        Rectangle2D bounds = g.getFont().getStringBounds(timeStamp, g.getFontRenderContext());
        double inset = bounds.getHeight() / 2.0;
        g.translate(inset, (double)image.getHeight() - inset);
        g.setColor(new Color(255, 255, 255, 128));
        g.fill(bounds);
        g.setColor(Color.BLACK);
        g.drawString(timeStamp, 0, 0);
    }

    private SourceDataLine getJavaSoundLine(IStream stream) {
        IStreamCoder audioCoder = stream.getStreamCoder();
        int streamIndex = stream.getIndex();
        SourceDataLine line = this.mAudioLines.get(streamIndex);
        if (line == null) {
            try {
                AudioFormat audioFormat = new AudioFormat(audioCoder.getSampleRate(), (int)IAudioSamples.findSampleBitDepth(audioCoder.getSampleFormat()), audioCoder.getChannels(), true, false);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(audioFormat);
                line.start();
                this.mAudioLines.put(streamIndex, line);
                if (null == this.mDataLine) {
                    this.mDataLine = line;
                }
            }
            catch (LineUnavailableException lue) {
                log.warn("WARINING: No audio line out available: " + lue);
                line = null;
            }
        }
        return line;
    }

    private static void debug(String format, Object ... args) {
        Formatter formatter = new Formatter();
        log.debug(formatter.format(format, args).toString());
    }

    private static class StatsFrame
    extends PositionFrame {
        public static final long serialVersionUID = 0L;
        private final JPanel mStatsPanel;
        private final BoxLayout mLayout;
        private final Map<IStream, StreamPanel> mStreamPanels = new HashMap<IStream, StreamPanel>();

        public StatsFrame(int defaultCloseOperation, MediaViewer viewer) {
            super(defaultCloseOperation, viewer);
            File file = new File(this.mViewer.mContainer.getURL());
            this.setTitle("Statistics " + file.getName());
            this.mStatsPanel = new JPanel();
            this.mLayout = new BoxLayout(this.mStatsPanel, 1);
            this.mStatsPanel.setLayout(this.mLayout);
            this.getContentPane().add(this.mStatsPanel);
        }

        protected void update(IStream stream, IMediaData mediaData) {
            StreamPanel streamPanel;
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            if ((streamPanel = this.mStreamPanels.get(stream)) == null) {
                streamPanel = new StreamPanel(stream, this);
                this.mStreamPanels.put(stream.copyReference(), streamPanel);
                this.mStatsPanel.add(streamPanel);
                this.adjustSize();
            }
            streamPanel.update(mediaData);
        }

        protected static class StreamPanel
        extends JPanel {
            public static final long serialVersionUID = 0L;
            private final IStream mStream;
            private final StatsFrame mFrame;
            private final Object mMediaLock;
            private IMediaData mMediaData;
            private final TableModel mTableModel;
            private final JTable mTable;
            private final Color[] mColors = new Color[]{new Color(160, 160, 160)};

            public StreamPanel(IStream stream, StatsFrame frame) {
                this.mStream = stream.copyReference();
                this.mFrame = frame;
                this.mMediaLock = new Object();
                this.mMediaData = null;
                this.setBackground(this.mColors[this.mStream.getIndex() % this.mColors.length]);
                this.mTableModel = new AbstractTableModel(){
                    public static final long serialVersionUID = 0L;

                    public int getColumnCount() {
                        return 2;
                    }

                    public int getRowCount() {
                        return Field.values().length;
                    }

                    public Object getValueAt(int row, int col) {
                        return Field.values()[row].getCell(col, StreamPanel.this);
                    }
                };
                this.mTable = new JTable(this.mTableModel);
                this.add(this.mTable);
                TableCellRenderer tableCellRenderer = new TableCellRenderer(){
                    public static final long serialVersionUID = 0L;
                    private final JLabel mLabel = new JLabel();
                    private final JLabel mValue = new JLabel();
                    private final int[] colWidths = new int[]{0, 0};
                    {
                        this.mLabel.setVerticalAlignment(1);
                        this.mLabel.setHorizontalAlignment(4);
                        this.mLabel.setForeground(new Color(128, 128, 128));
                        this.mLabel.setFont(this.mLabel.getFont().deriveFont(13.200001f));
                        this.mLabel.doLayout();
                        this.mValue.setHorizontalAlignment(2);
                        this.mValue.setForeground(new Color(32, 32, 32));
                        this.mValue.setFont(this.mValue.getFont().deriveFont(20.0f));
                        this.mLabel.doLayout();
                    }

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                        JLabel cell = col == 0 ? this.mLabel : this.mValue;
                        cell.setText(null != value ? value.toString() : "NULL");
                        Dimension cellSize = cell.getPreferredSize();
                        if (cellSize.getHeight() > (double)StreamPanel.this.mTable.getRowHeight(row)) {
                            StreamPanel.this.mTable.setRowHeight(row, (int)cellSize.getHeight());
                            StreamPanel.this.mFrame.adjustSize();
                        }
                        if (cellSize.getWidth() > (double)this.colWidths[col]) {
                            this.colWidths[col] = (int)(cellSize.getWidth() * 1.1);
                            StreamPanel.this.mTable.getColumnModel().getColumn(col).setPreferredWidth(this.colWidths[col]);
                            StreamPanel.this.mFrame.adjustSize();
                        }
                        return cell;
                    }
                };
                for (TableColumn column : Collections.list(this.mTable.getColumnModel().getColumns())) {
                    column.setCellRenderer(tableCellRenderer);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update(IMediaData mediaData) {
                Object object = this.mMediaLock;
                synchronized (object) {
                    IMediaData oldMedia = this.mMediaData;
                    this.mMediaData = mediaData.copyReference();
                    if (oldMedia != null) {
                        oldMedia.delete();
                    }
                }
                this.repaint();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static enum Field {
                INDEX("index"){

                    public Object getValue(StreamPanel streamPanel) {
                        return Field.isStreamGood(streamPanel) ? Integer.valueOf(streamPanel.mStream.getIndex()) : null;
                    }
                }
                ,
                ID("id"){

                    public Object getValue(StreamPanel streamPanel) {
                        return Field.isStreamGood(streamPanel) ? Integer.valueOf(streamPanel.mStream.getId()) : null;
                    }
                }
                ,
                TYPE("type"){

                    public Object getValue(StreamPanel streamPanel) {
                        return Field.isStreamGood(streamPanel) ? streamPanel.mStream.getStreamCoder().getCodecType() : null;
                    }
                }
                ,
                NAME("name"){

                    public Object getValue(StreamPanel streamPanel) {
                        return Field.isStreamGood(streamPanel) ? streamPanel.mStream.getStreamCoder().getCodec().getLongName() : null;
                    }
                }
                ,
                DIRECTION("direction"){

                    public Object getValue(StreamPanel streamPanel) {
                        return Field.isStreamGood(streamPanel) ? streamPanel.mStream.getDirection() : null;
                    }
                }
                ,
                TIME("time"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object getValue(StreamPanel streamPanel) {
                        IMediaData data = null;
                        Object object = streamPanel.mMediaLock;
                        synchronized (object) {
                            if (streamPanel.mMediaData != null) {
                                data = streamPanel.mMediaData.copyReference();
                            }
                        }
                        String retval = "";
                        if (data != null) {
                            try {
                                long delta = ((StreamPanel)streamPanel).mFrame.mViewer.getMode().isRealTime() ? TimeUnit.MILLISECONDS.convert(data.getTimeStamp() - ((StreamPanel)streamPanel).mFrame.mViewer.getMediaTime(), TIME_UNIT) : 0L;
                                retval = data.getFormattedTimeStamp() + (delta <= 0L ? " + " : " - ") + Math.abs(delta);
                            }
                            finally {
                                data.delete();
                            }
                        }
                        return retval;
                    }
                };

                private final String mLabel;
                private Object mLastValue;

                private Field(String label) {
                    this.mLabel = label + " ";
                    this.mLastValue = "-";
                }

                private static boolean isStreamGood(StreamPanel streamPanel) {
                    if (null == streamPanel.mStream) {
                        return false;
                    }
                    if (null == streamPanel.mStream.getStreamCoder()) {
                        return false;
                    }
                    return streamPanel.mStream.getStreamCoder().isOpen();
                }

                public String getLabel() {
                    return this.mLabel;
                }

                public Object getCell(int col, StreamPanel streamPanel) {
                    if (0 == col) {
                        return this.getLabel();
                    }
                    Object value = this.getValue(streamPanel);
                    return null != value ? (this.mLastValue = value) : this.mLastValue;
                }

                public abstract Object getValue(StreamPanel var1);
            }
        }
    }

    private class MediaFrame
    extends PositionFrame {
        public static final long serialVersionUID = 0L;
        private BufferedImage mImage;
        private final JPanel mVideoPanel;
        private final IStream mStream;
        private final int mStreamIndex;

        public MediaFrame(int defaultCloseOperation, IStream stream, MediaViewer viewer) {
            super(defaultCloseOperation, viewer);
            this.mStream = stream.copyReference();
            this.mStreamIndex = this.mStream.getIndex();
            this.setTitle("Stream #" + this.mStreamIndex + ", " + this.mStream.getStreamCoder().getCodec().getLongName());
            this.mVideoPanel = new JPanel(){
                public static final long serialVersionUID = 0L;

                public void paint(Graphics graphics) {
                    MediaFrame.this.paintPanel((Graphics2D)graphics);
                }
            };
            this.getContentPane().add(this.mVideoPanel);
            this.setVisible(true);
        }

        protected void setVideoSize(Dimension videoSize) {
            this.mVideoPanel.setPreferredSize(videoSize);
            this.adjustSize();
        }

        protected void setVideoImage(IVideoPicture picture, BufferedImage image) {
            if (null == image) {
                IConverter converter = (IConverter)MediaViewer.this.mConverters.get(this.mStreamIndex);
                image = converter.toImage(picture);
            }
            if (MediaViewer.this.mShowStats) {
                MediaViewer.drawStats(picture, image);
                MediaViewer.this.updateStreamStats(this.mStream, picture);
            }
            this.mImage = image;
            if (null != image) {
                if (this.mVideoPanel.getWidth() != this.mImage.getWidth() || this.mVideoPanel.getHeight() != this.mImage.getHeight()) {
                    this.setVideoSize(new Dimension(this.mImage.getWidth(), this.mImage.getHeight()));
                }
                this.repaint();
            }
        }

        protected void paintPanel(Graphics2D graphics) {
            if (this.mImage != null) {
                graphics.drawImage((Image)this.mImage, 0, 0, null);
            }
        }
    }

    private static class PositionFrame
    extends JFrame {
        protected final MediaViewer mViewer;
        public static final long serialVersionUID = 0L;
        private static Vector<PositionFrame> mFrames = new Vector();

        public PositionFrame(int defaultCloseOperation, MediaViewer viewer) {
            this.setDefaultCloseOperation(defaultCloseOperation);
            this.mViewer = viewer;
            if (mFrames.size() > 0) {
                this.reposition(mFrames.lastElement());
            }
            mFrames.add(this);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    mFrames.remove(PositionFrame.this);
                    if (!mFrames.isEmpty()) {
                        PositionFrame frame = (PositionFrame)mFrames.firstElement();
                        frame.setLocation(0, 0);
                        PositionFrame.this.repositionFrom(frame);
                    }
                }
            });
        }

        protected void reposition(PositionFrame other) {
            this.setLocation(other.getX() + other.getWidth(), other.getY());
        }

        public void repositionFrom(PositionFrame frame) {
            if (mFrames.contains(frame)) {
                for (int i = mFrames.indexOf(frame) + 1; i < mFrames.size(); ++i) {
                    mFrames.get(i).reposition(mFrames.get(i - 1));
                }
            }
        }

        protected void adjustSize() {
            this.pack();
            this.invalidate();
            this.repositionFrom(this);
        }

        public void dispose() {
            super.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelayedItem<Item extends IMediaData> {
        private final Item mItem;
        private final long mTimeStamp;
        final /* synthetic */ MediaViewer this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public DelayedItem(Item timeStamp, long l2) {
            void item;
            this.this$0 = (MediaViewer)l;
            this.mItem = item;
            this.mTimeStamp = (long)timeStamp;
        }

        public Item getItem() {
            return this.mItem;
        }

        public long getTimeStamp() {
            return this.mTimeStamp;
        }
    }

    private abstract class SelfServicingMediaQueue {
        private static final long serialVersionUID = 1L;
        private final Queue<DelayedItem<IMediaData>> mQueue = new LinkedList<DelayedItem<IMediaData>>();
        private final int mStreamIndex;
        private ReentrantLock mLock = new ReentrantLock(true);
        private Condition mCondition = this.mLock.newCondition();
        private boolean mDone = false;
        private final long mCapacity;
        private final long mEarlyWindow;
        private final long mLateWindow;
        private boolean mIsInitialized = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SelfServicingMediaQueue(long capacity, long earlyWindow, long lateWindow, TimeUnit unit, int priority, String name, int streamIndex) {
            this.mCapacity = TIME_UNIT.convert(capacity, unit);
            this.mEarlyWindow = TIME_UNIT.convert(earlyWindow, unit);
            this.mLateWindow = TIME_UNIT.convert(lateWindow, unit);
            this.mStreamIndex = streamIndex;
            Thread t = new Thread(name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        log.debug("thread started");
                        boolean isDone = false;
                        DelayedItem delayedItem = null;
                        SelfServicingMediaQueue selfServicingMediaQueue = SelfServicingMediaQueue.this;
                        synchronized (selfServicingMediaQueue) {
                            SelfServicingMediaQueue.this.mIsInitialized = true;
                            SelfServicingMediaQueue.this.notifyAll();
                        }
                        while (!isDone) {
                            SelfServicingMediaQueue.this.mLock.lock();
                            try {
                                while (!SelfServicingMediaQueue.this.mDone && (delayedItem = (DelayedItem)SelfServicingMediaQueue.this.mQueue.poll()) == null) {
                                    try {
                                        SelfServicingMediaQueue.this.mCondition.await();
                                    }
                                    catch (InterruptedException e) {
                                        MediaFrame frame;
                                        Thread.currentThread().interrupt();
                                        SelfServicingMediaQueue.this.mLock.unlock();
                                        if (null != MediaViewer.this.mStatsFrame) {
                                            MediaViewer.this.mStatsFrame.dispose();
                                            MediaViewer.this.mStatsFrame = null;
                                        }
                                        if (null != (frame = (MediaFrame)MediaViewer.this.mFrames.get(SelfServicingMediaQueue.this.mStreamIndex))) {
                                            frame.dispose();
                                        }
                                        return;
                                    }
                                }
                                SelfServicingMediaQueue.this.mCondition.signalAll();
                                isDone = SelfServicingMediaQueue.this.mDone;
                            }
                            finally {
                                SelfServicingMediaQueue.this.mLock.unlock();
                            }
                            if (null == delayedItem) continue;
                            Object item = delayedItem.getItem();
                            try {
                                long now = MediaViewer.this.getMediaTime();
                                long delta = delayedItem.getTimeStamp() - now;
                                if (delta >= SelfServicingMediaQueue.this.mEarlyWindow) {
                                    try {
                                        1.sleep(TimeUnit.MILLISECONDS.convert(delta / 3L, TIME_UNIT));
                                    }
                                    catch (InterruptedException e) {
                                        MediaFrame frame;
                                        Thread.currentThread().interrupt();
                                        if (item != null) {
                                            ((IMediaData)item).delete();
                                        }
                                        if (null != MediaViewer.this.mStatsFrame) {
                                            MediaViewer.this.mStatsFrame.dispose();
                                            MediaViewer.this.mStatsFrame = null;
                                        }
                                        if (null != (frame = (MediaFrame)MediaViewer.this.mFrames.get(SelfServicingMediaQueue.this.mStreamIndex))) {
                                            frame.dispose();
                                        }
                                        return;
                                    }
                                }
                                if (delta < -SelfServicingMediaQueue.this.mLateWindow) {
                                    MediaViewer.debug("@%5d DROP queue[%2d]: %s[%5d] delta: %d", new Object[]{TimeUnit.MILLISECONDS.convert(now, TIME_UNIT), SelfServicingMediaQueue.this.mQueue.size(), item instanceof IVideoPicture ? "IMAGE" : "sound", TimeUnit.MILLISECONDS.convert(delayedItem.getTimeStamp(), TIME_UNIT), TimeUnit.MILLISECONDS.convert(delta, TIME_UNIT)});
                                    continue;
                                }
                                SelfServicingMediaQueue.this.dispatch((IMediaData)item, delayedItem.getTimeStamp());
                            }
                            finally {
                                if (item == null) continue;
                                ((IMediaData)item).delete();
                            }
                        }
                    }
                    finally {
                        MediaFrame frame;
                        if (null != MediaViewer.this.mStatsFrame) {
                            MediaViewer.this.mStatsFrame.dispose();
                            MediaViewer.this.mStatsFrame = null;
                        }
                        if (null != (frame = (MediaFrame)MediaViewer.this.mFrames.get(SelfServicingMediaQueue.this.mStreamIndex))) {
                            frame.dispose();
                        }
                    }
                }
            };
            t.setPriority(priority);
            t.setDaemon(true);
            SelfServicingMediaQueue selfServicingMediaQueue = this;
            synchronized (selfServicingMediaQueue) {
                t.start();
                try {
                    while (!this.mIsInitialized) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("could not start thread");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            this.mLock.lock();
            try {
                while (!this.mDone && !this.mQueue.isEmpty()) {
                    try {
                        this.mCondition.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.mLock.unlock();
                        return;
                    }
                }
                this.mCondition.signalAll();
            }
            finally {
                this.mLock.unlock();
            }
        }

        public abstract void dispatch(IMediaData var1, long var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void offerMedia(IMediaData item, long timeStamp, TimeUnit unit) {
            long convertedTime = TIME_UNIT.convert(timeStamp, unit);
            this.mLock.lock();
            try {
                while (!this.mDone && !this.mQueue.isEmpty() && convertedTime - this.mQueue.peek().getTimeStamp() > this.mCapacity) {
                    try {
                        this.mCondition.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.mLock.unlock();
                        return;
                    }
                }
                if (!this.mDone) {
                    this.mQueue.offer(new DelayedItem(MediaViewer.this, item.copyReference(), convertedTime));
                }
                this.mCondition.signalAll();
            }
            finally {
                this.mLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.mLock.lock();
            try {
                this.mDone = true;
                this.mCondition.signalAll();
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    private class VideoQueue
    extends SelfServicingMediaQueue {
        public static final long serialVersionUID = 0L;
        private final MediaFrame mMediaFrame;

        public VideoQueue(long capacity, TimeUnit unit, MediaFrame mediaFrame) {
            super(TIME_UNIT.convert(capacity, unit), DEFAULT_VIDEO_EARLY_WINDOW, DEFAULT_VIDEO_LATE_WINDOW, TIME_UNIT, 1, "video stream " + mediaFrame.mStream.getIndex() + " " + mediaFrame.mStream.getStreamCoder().getCodec().getLongName(), mediaFrame.mStream.getIndex());
            this.mMediaFrame = mediaFrame;
        }

        public void dispatch(IMediaData picture, long timeStamp) {
            if (picture instanceof IVideoPicture) {
                this.mMediaFrame.setVideoImage((IVideoPicture)picture, null);
            }
        }
    }

    private class AudioQueue
    extends SelfServicingMediaQueue {
        public static final long serialVersionUID = 0L;
        private final SourceDataLine mLine;
        private final IStream mStream;

        public AudioQueue(long capacity, TimeUnit unit, IStream stream, SourceDataLine sourceDataLine) {
            super(TIME_UNIT.convert(capacity, unit), DEFAULT_AUDIO_EARLY_WINDOW, DEFAULT_AUDIO_LATE_WINDOW, TIME_UNIT, 1, "audio stream " + stream.getIndex() + " " + stream.getStreamCoder().getCodec().getLongName(), stream.getIndex());
            this.mStream = stream;
            this.mLine = sourceDataLine;
        }

        public void dispatch(IMediaData samples, long timeStamp) {
            if (samples instanceof IAudioSamples) {
                MediaViewer.this.playAudio(this.mStream, this.mLine, (IAudioSamples)samples);
            }
        }
    }
}

