/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.test_utils.NameAwareTestClassRunner;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.ISimpleMediaFile;
import com.xuggle.xuggler.ITimeValue;
import com.xuggle.xuggler.SimpleMediaFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=NameAwareTestClassRunner.class)
public class SimpleMediaFileTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String mTestName = null;

    @Before
    public void setUp() {
        this.mTestName = NameAwareTestClassRunner.getTestMethodName();
        this.log.debug("-----START----- {}", (Object)this.mTestName);
    }

    @After
    public void tearDown() {
        this.log.debug("----- END ----- {}", (Object)this.mTestName);
    }

    @Test
    public void testCreation() {
        new SimpleMediaFile();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCopyNull() {
        new SimpleMediaFile(null);
    }

    @Test
    public void testCopy() {
        SimpleMediaFile obj = new SimpleMediaFile();
        obj.setAudioBitRate(123);
        obj.setAudioChannels(2);
        obj.setAudioSampleRate(22050);
        obj.setAudioCodec(ICodec.ID.CODEC_ID_MP3);
        obj.setAudioTimeBase(IRational.make((int)17, (int)100));
        obj.setVideoWidth(1);
        obj.setVideoHeight(2);
        obj.setVideoTimeBase(IRational.make((int)1, (int)100));
        obj.setVideoCodec(ICodec.ID.CODEC_ID_FLV1);
        obj.setVideoPixelFormat(IPixelFormat.Type.ARGB);
        obj.setVideoNumPicturesInGroupOfPictures(12);
        obj.setVideoFrameRate(IRational.make((int)2, (int)15));
        obj.setVideoGlobalQuality(5);
        obj.setDuration(ITimeValue.make((long)1L, (ITimeValue.Unit)ITimeValue.Unit.SECONDS));
        IContainerFormat format = IContainerFormat.make();
        format.setInputFormat("flv");
        obj.setContainerFormat(format);
        obj.setHasVideo(false);
        obj.setHasAudio(false);
        obj.setURL("foo:bar");
        SimpleMediaFile copy = new SimpleMediaFile((ISimpleMediaFile)obj);
        Assert.assertEquals((long)obj.getAudioBitRate(), (long)copy.getAudioBitRate());
        Assert.assertEquals((Object)obj.isAudioBitRateKnown(), (Object)copy.isAudioBitRateKnown());
        Assert.assertEquals((long)obj.getAudioChannels(), (long)copy.getAudioChannels());
        Assert.assertEquals((Object)obj.isAudioChannelsKnown(), (Object)copy.isAudioChannelsKnown());
        Assert.assertEquals((long)obj.getAudioSampleRate(), (long)copy.getAudioSampleRate());
        Assert.assertEquals((Object)obj.isAudioSampleRateKnown(), (Object)copy.isAudioSampleRateKnown());
        Assert.assertEquals((Object)obj.getAudioCodec(), (Object)copy.getAudioCodec());
        Assert.assertEquals((long)obj.getAudioTimeBase().getNumerator(), (long)copy.getAudioTimeBase().getNumerator());
        Assert.assertEquals((long)obj.getAudioTimeBase().getDenominator(), (long)copy.getAudioTimeBase().getDenominator());
        Assert.assertEquals((long)obj.getVideoWidth(), (long)copy.getVideoWidth());
        Assert.assertEquals((Object)obj.isVideoWidthKnown(), (Object)copy.isVideoWidthKnown());
        Assert.assertEquals((long)obj.getVideoHeight(), (long)copy.getVideoHeight());
        Assert.assertEquals((Object)obj.isVideoHeightKnown(), (Object)copy.isVideoHeightKnown());
        Assert.assertEquals((long)obj.getVideoTimeBase().getNumerator(), (long)copy.getVideoTimeBase().getNumerator());
        Assert.assertEquals((long)obj.getVideoTimeBase().getDenominator(), (long)copy.getVideoTimeBase().getDenominator());
        Assert.assertEquals((Object)obj.getVideoCodec(), (Object)copy.getVideoCodec());
        Assert.assertEquals((Object)obj.getVideoPixelFormat(), (Object)copy.getVideoPixelFormat());
        Assert.assertEquals((Object)obj.isVideoPixelFormatKnown(), (Object)copy.isVideoPixelFormatKnown());
        Assert.assertEquals((long)obj.getVideoNumPicturesInGroupOfPictures(), (long)copy.getVideoNumPicturesInGroupOfPictures());
        Assert.assertEquals((Object)obj.isVideoNumPicturesInGroupOfPicturesKnown(), (Object)copy.isVideoNumPicturesInGroupOfPicturesKnown());
        Assert.assertEquals((long)obj.getVideoFrameRate().getNumerator(), (long)copy.getVideoFrameRate().getNumerator());
        Assert.assertEquals((long)obj.getVideoFrameRate().getDenominator(), (long)copy.getVideoFrameRate().getDenominator());
        Assert.assertEquals((long)obj.getVideoGlobalQuality(), (long)copy.getVideoGlobalQuality());
        Assert.assertEquals((Object)obj.isVideoGlobalQualityKnown(), (Object)copy.isVideoGlobalQualityKnown());
        Assert.assertEquals((Object)obj.hasVideo(), (Object)copy.hasVideo());
        Assert.assertEquals((Object)obj.hasAudio(), (Object)copy.hasVideo());
        Assert.assertEquals((Object)obj.getContainerFormat().getInputFormatLongName(), (Object)copy.getContainerFormat().getInputFormatLongName());
        Assert.assertEquals((Object)obj.getDuration(), (Object)copy.getDuration());
        Assert.assertEquals((Object)obj.getURL(), (Object)copy.getURL());
    }

    @Test
    public void testAudioBitRate() {
        int defaultVal = 64000;
        int val = 123;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (long)defaultVal, (long)obj.getAudioBitRate());
        obj.setAudioBitRate(val);
        Assert.assertEquals((String)"set method failed", (long)val, (long)obj.getAudioBitRate());
    }

    @Test
    public void testAudioChannels() {
        int defaultVal = 1;
        int val = 2;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (long)defaultVal, (long)obj.getAudioChannels());
        obj.setAudioChannels(val);
        Assert.assertEquals((String)"set method failed", (long)val, (long)obj.getAudioChannels());
    }

    @Test
    public void testAudioSampleRate() {
        int defaultVal = 44100;
        int val = 22050;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (long)defaultVal, (long)obj.getAudioSampleRate());
        obj.setAudioSampleRate(val);
        Assert.assertEquals((String)"set method failed", (long)val, (long)obj.getAudioSampleRate());
    }

    @Test
    public void testAudioCodec() {
        ICodec.ID defaultVal = ICodec.ID.CODEC_ID_NONE;
        ICodec.ID val = ICodec.ID.CODEC_ID_AAC;
        Assert.assertNotNull((String)"couldn't find codec", (Object)val);
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (Object)defaultVal, (Object)obj.getAudioCodec());
        obj.setAudioCodec(val);
        Assert.assertEquals((String)"set method failed", (Object)val, (Object)obj.getAudioCodec());
    }

    @Test
    public void testAudioTimeBase() {
        IRational val = IRational.make((int)1, (int)500);
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertNull((Object)obj.getAudioTimeBase());
        obj.setAudioTimeBase(val);
        Assert.assertEquals((String)"set method failed", (long)val.getNumerator(), (long)obj.getAudioTimeBase().getNumerator());
        Assert.assertEquals((String)"set method failed", (long)val.getDenominator(), (long)obj.getAudioTimeBase().getDenominator());
    }

    @Test
    public void testVideoCodec() {
        ICodec.ID defaultVal = ICodec.ID.CODEC_ID_NONE;
        ICodec.ID val = ICodec.ID.CODEC_ID_MPEG4;
        Assert.assertNotNull((String)"couldn't find codec", (Object)val);
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (Object)defaultVal, (Object)obj.getVideoCodec());
        obj.setVideoCodec(val);
        Assert.assertEquals((String)"set method failed", (Object)val, (Object)obj.getVideoCodec());
    }

    @Test
    public void testVideoHeight() {
        int defaultVal = 1;
        int val = 123;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (long)defaultVal, (long)obj.getVideoHeight());
        obj.setVideoHeight(val);
        Assert.assertEquals((String)"set method failed", (long)val, (long)obj.getVideoHeight());
    }

    @Test
    public void testVideoWidth() {
        int defaultVal = 1;
        int val = 123;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (long)defaultVal, (long)obj.getVideoWidth());
        obj.setVideoWidth(val);
        Assert.assertEquals((String)"set method failed", (long)val, (long)obj.getVideoWidth());
    }

    @Test
    public void testVideoBitRate() {
        int defaultVal = 320000;
        int val = 123;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (long)defaultVal, (long)obj.getVideoBitRate());
        obj.setVideoBitRate(val);
        Assert.assertEquals((String)"set method failed", (long)val, (long)obj.getVideoBitRate());
    }

    @Test
    public void testVideoTimeBase() {
        IRational val = IRational.make((int)1, (int)500);
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertNull((Object)obj.getVideoTimeBase());
        obj.setVideoTimeBase(val);
        Assert.assertEquals((String)"set method failed", (long)val.getNumerator(), (long)obj.getVideoTimeBase().getNumerator());
        Assert.assertEquals((String)"set method failed", (long)val.getDenominator(), (long)obj.getVideoTimeBase().getDenominator());
    }

    @Test
    public void testVideoFrameRate() {
        IRational val = IRational.make((int)30, (int)1);
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertNull((Object)obj.getVideoFrameRate());
        obj.setVideoFrameRate(val);
        Assert.assertEquals((String)"set method failed", (long)val.getNumerator(), (long)obj.getVideoFrameRate().getNumerator());
        Assert.assertEquals((String)"set method failed", (long)val.getDenominator(), (long)obj.getVideoFrameRate().getDenominator());
    }

    @Test
    public void testVideoPixelFormat() {
        IPixelFormat.Type defaultVal = IPixelFormat.Type.YUV420P;
        IPixelFormat.Type val = IPixelFormat.Type.RGB24;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (Object)defaultVal, (Object)obj.getVideoPixelFormat());
        obj.setVideoPixelFormat(val);
        Assert.assertEquals((String)"set method failed", (Object)val, (Object)obj.getVideoPixelFormat());
    }

    @Test
    public void testVideoNumPicturesInGroupOfPictures() {
        int defaultVal = 15;
        int val = 123;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (long)defaultVal, (long)obj.getVideoNumPicturesInGroupOfPictures());
        obj.setVideoNumPicturesInGroupOfPictures(val);
        Assert.assertEquals((String)"set method failed", (long)val, (long)obj.getVideoNumPicturesInGroupOfPictures());
    }

    @Test
    public void testVideoGlobalQuality() {
        int defaultVal = 0;
        int val = 123;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (long)defaultVal, (long)obj.getVideoGlobalQuality());
        obj.setVideoGlobalQuality(val);
        Assert.assertEquals((String)"set method failed", (long)val, (long)obj.getVideoGlobalQuality());
    }

    @Test
    public void testHasVideo() {
        boolean defaultVal = true;
        boolean val = false;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (Object)defaultVal, (Object)obj.hasVideo());
        obj.setHasVideo(val);
        Assert.assertEquals((String)"set method failed", (Object)val, (Object)obj.hasVideo());
    }

    @Test
    public void testHasAudio() {
        boolean defaultVal = true;
        boolean val = false;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", (Object)defaultVal, (Object)obj.hasAudio());
        obj.setHasAudio(val);
        Assert.assertEquals((String)"set method failed", (Object)val, (Object)obj.hasAudio());
    }

    @Test
    public void testContainerFormat() {
        Object defaultVal = null;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", defaultVal, (Object)obj.getContainerFormat());
        IContainerFormat format = IContainerFormat.make();
        Assert.assertNotNull((Object)format);
        format.setInputFormat("flv");
        Assert.assertNotNull((Object)format.getInputFormatLongName());
        Assert.assertTrue((format.getInputFormatLongName().length() > 0 ? 1 : 0) != 0);
        obj.setContainerFormat(format);
        Assert.assertEquals((Object)format.getInputFormatLongName(), (Object)obj.getContainerFormat().getInputFormatLongName());
    }

    @Test
    public void testDuration() {
        Object defaultVal = null;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", defaultVal, (Object)obj.getDuration());
        ITimeValue expected = ITimeValue.make((long)3L, (ITimeValue.Unit)ITimeValue.Unit.SECONDS);
        obj.setDuration(expected);
        Assert.assertEquals((Object)expected, (Object)obj.getDuration());
    }

    @Test
    public void testURL() {
        Object defaultVal = null;
        SimpleMediaFile obj = new SimpleMediaFile();
        Assert.assertEquals((String)"unexpected default", defaultVal, (Object)obj.getURL());
        String expected = "hello:three";
        obj.setURL(expected);
        Assert.assertEquals((Object)expected, (Object)obj.getURL());
    }
}

