/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.Utils;
import java.nio.ByteBuffer;
import junit.framework.Assert;
import org.junit.Test;

public class IMediaDataTest {
    @Test
    public void testGetByteBuffer() {
        int sampleCount = 1000;
        IAudioSamples mediaData = IAudioSamples.make((long)sampleCount, (long)1L);
        mediaData.setComplete(true, (long)sampleCount, 44000, 1, IAudioSamples.Format.FMT_S16, 0L);
        int byteCount = mediaData.getSize();
        ByteBuffer byteBuffer = mediaData.getByteBuffer();
        Assert.assertEquals((String)"Position should be zero:", (int)byteBuffer.position(), (int)0);
        Assert.assertEquals((String)("Limit should be " + byteCount + ":"), (int)byteBuffer.limit(), (int)byteCount);
    }

    @Test
    public void testByteGetPut() {
        JNIMemoryManager.getMgr().flush();
        byte[] in = new byte[]{56, 44, 24, 127};
        byte[] out = new byte[in.length];
        int sampleCount = 1000;
        IAudioSamples buf = IAudioSamples.make((long)sampleCount, (long)1L);
        buf.setComplete(true, (long)sampleCount, 44000, 1, IAudioSamples.Format.FMT_S16, 0L);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (byte)in[i], (byte)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testShortGetPut() {
        JNIMemoryManager.getMgr().flush();
        short[] in = new short[]{56, 44, 24, 127};
        short[] out = new short[in.length];
        int sampleCount = 1000;
        IAudioSamples buf = IAudioSamples.make((long)sampleCount, (long)1L);
        buf.setComplete(true, (long)sampleCount, 44000, 1, IAudioSamples.Format.FMT_S16, 0L);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (short)in[i], (short)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testIntGetPut() {
        JNIMemoryManager.getMgr().flush();
        int[] in = new int[]{56, 44, 24, 127};
        int[] out = new int[in.length];
        int sampleCount = 1000;
        IAudioSamples buf = IAudioSamples.make((long)sampleCount, (long)1L);
        buf.setComplete(true, (long)sampleCount, 44000, 1, IAudioSamples.Format.FMT_S16, 0L);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (int)in[i], (int)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testCharGetPut() {
        JNIMemoryManager.getMgr().flush();
        char[] in = new char[]{'8', ',', '\u0018', '\u007f'};
        char[] out = new char[in.length];
        int sampleCount = 1000;
        IAudioSamples buf = IAudioSamples.make((long)sampleCount, (long)1L);
        buf.setComplete(true, (long)sampleCount, 44000, 1, IAudioSamples.Format.FMT_S16, 0L);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (char)in[i], (char)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testLongGetPut() {
        JNIMemoryManager.getMgr().flush();
        long[] in = new long[]{56L, 44L, 24L, 127L};
        long[] out = new long[in.length];
        int sampleCount = 1000;
        IAudioSamples buf = IAudioSamples.make((long)sampleCount, (long)1L);
        buf.setComplete(true, (long)sampleCount, 44000, 1, IAudioSamples.Format.FMT_S16, 0L);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (long)in[i], (long)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testDoubleGetPut() {
        JNIMemoryManager.getMgr().flush();
        double[] in = new double[]{56.0, 44.0, 24.0, 127.0};
        double[] out = new double[in.length];
        int sampleCount = 1000;
        IAudioSamples buf = IAudioSamples.make((long)sampleCount, (long)1L);
        buf.setComplete(true, (long)sampleCount, 44000, 1, IAudioSamples.Format.FMT_S16, 0L);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (Object)in[i], (Object)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testFloatGetPut() {
        JNIMemoryManager.getMgr().flush();
        float[] in = new float[]{56.0f, 44.0f, 24.0f, 127.0f};
        float[] out = new float[in.length];
        int sampleCount = 1000;
        IAudioSamples buf = IAudioSamples.make((long)sampleCount, (long)1L);
        buf.setComplete(true, (long)sampleCount, 44000, 1, IAudioSamples.Format.FMT_S16, 0L);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (Object)Float.valueOf(in[i]), (Object)Float.valueOf(out[i]));
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testToStringDoesNotLeak() {
        JNIMemoryManager.getMgr().flush();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        IAudioSamples samples = IAudioSamples.make((long)1024L, (long)2L);
        samples.toString();
        IVideoPicture picture = Utils.getBlankFrame((int)100, (int)100, (int)0);
        picture.toString();
        IPacket packet = IPacket.make((int)1024);
        packet.toString();
        packet.getFormattedTimeStamp();
        IRational timeBase = IRational.make((int)1, (int)25);
        packet.setTimeBase(timeBase);
        timeBase.delete();
        packet.getFormattedTimeStamp();
        packet.delete();
        samples.delete();
        picture.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testSetData() {
        JNIMemoryManager.getMgr().flush();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        int bufSize = 100;
        byte[] inData = new byte[bufSize];
        byte[] outData = new byte[inData.length];
        for (int i = 0; i < inData.length; ++i) {
            inData[i] = (byte)i;
        }
        IBuffer buffer = IBuffer.make(null, (byte[])inData, (int)0, (int)inData.length);
        IAudioSamples samples = IAudioSamples.make((long)1024L, (long)2L);
        samples.setData(buffer);
        IBuffer outBuffer = samples.getData();
        outBuffer.get(0, outData, 0, outData.length);
        for (int i = 0; i < inData.length; ++i) {
            Assert.assertEquals((byte)inData[i], (byte)outData[i]);
        }
        outBuffer.delete();
        samples.toString();
        IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)4, (int)4);
        picture.setData(buffer);
        outBuffer = picture.getData();
        outBuffer.get(0, outData, 0, outData.length);
        for (int i = 0; i < inData.length; ++i) {
            Assert.assertEquals((byte)inData[i], (byte)outData[i]);
        }
        outBuffer.delete();
        IPacket packet = IPacket.make((int)1024);
        packet.setData(buffer);
        outBuffer = packet.getData();
        outBuffer.get(0, outData, 0, outData.length);
        for (int i = 0; i < inData.length; ++i) {
            Assert.assertEquals((byte)inData[i], (byte)outData[i]);
        }
        outBuffer.delete();
        packet.delete();
        samples.delete();
        picture.delete();
        buffer.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }
}

