/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool;

import com.xuggle.mediatool.IMediaDebugListener;
import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaViewer;
import com.xuggle.mediatool.MediaDebugListener;
import com.xuggle.mediatool.MediaListenerAdapter;
import com.xuggle.mediatool.MediaReader;
import com.xuggle.mediatool.MediaViewer;
import com.xuggle.mediatool.MediaWriter;
import com.xuggle.mediatool.event.IAudioSamplesEvent;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class MediaWriterExhaustiveTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final IMediaViewer.Mode mViewerMode;
    static final boolean mTestBroken = !System.getProperty(MediaWriterExhaustiveTest.class.getName() + ".TestBroken", "false").equals("false");
    final String PREFIX;
    public static final String TEST_FILE_DIR = "fixtures";
    public static final boolean[] CONTAINER_READER_CASES = new boolean[]{true, false};
    public static final String[] TEST_VIDEO_FILES = new String[]{"testfile_bw_pattern.flv", "testfile_videoonly_20sec.flv", "subtitled_video.mkv", "testfile.flv", "ucl_h264_aac.mp4", "testfile_h264_mp4a_tmcd.mov", "testfile_mpeg1video_mp2audio.mpg"};
    public static final String[] TEST_VIDEO_TYPES = new String[]{"mov", "avi", "flv", "mpg", "mkv"};
    public static final String[][] BROKEN_TEST_COMBINATIONS = new String[][]{{"testfile_mpeg1video_mp2audio.mpg", "mov"}, {"subtitled_video.mkv", "avi"}, {"subtitled_video.mkv", "flv"}, {"testfile_mpeg1video_mp2audio.mpg", "flv"}, {"subtitled_video.mkv", "mpg"}, {"testfile_bw_pattern.flv", "mpg"}, {"testfile_videoonly_20sec.flv", "mpg"}, {"testfile.flv", "mpg"}};
    private final String mSource;
    private final String mDestination;
    private final boolean mTestContainer;

    @Parameterized.Parameters
    public static Collection<Object[]> converterTypes() {
        Vector<Object[]> parameters = new Vector<Object[]>();
        for (boolean testContainer : CONTAINER_READER_CASES) {
            for (String source : TEST_VIDEO_FILES) {
                for (String destExt : TEST_VIDEO_TYPES) {
                    boolean isBroken = false;
                    for (String[] pair : BROKEN_TEST_COMBINATIONS) {
                        if (!source.equals(pair[0]) || !destExt.equals(pair[1])) continue;
                        isBroken = true;
                        break;
                    }
                    String[] parts = source.split("\\x2E");
                    String destination = (testContainer ? "container" : "reader") + "-" + parts[0] + "-" + parts[1] + "." + destExt;
                    boolean skipTest = isBroken && !mTestBroken || !isBroken && mTestBroken;
                    String description = (skipTest ? "SKIPPING" : " converting ") + " " + (isBroken ? "BROKEN" : " good ") + " " + (testContainer ? "container" : " reader  ") + " " + source + " -> " + destination;
                    if (skipTest) {
                        System.out.println(description);
                        continue;
                    }
                    Object[] tuple = new Object[]{source, destination, isBroken, testContainer, description};
                    parameters.add(tuple);
                }
            }
        }
        return parameters;
    }

    public MediaWriterExhaustiveTest(String source, String destination, boolean isBroken, boolean testContainer, String description) {
        this.log.trace("<init>");
        this.mViewerMode = IMediaViewer.Mode.valueOf((String)System.getProperty(this.getClass().getName() + ".ViewerMode", IMediaViewer.Mode.DISABLED.name()));
        this.PREFIX = this.getClass().getName() + "-";
        System.out.println(description);
        this.mSource = "fixtures/" + source;
        this.mDestination = this.PREFIX + destination;
        this.mTestContainer = testContainer;
    }

    @Test
    @Ignore
    public void transcodeTest() {
        File sourceFile = new File(this.mSource);
        File destinationFile = new File(this.mDestination);
        assert (sourceFile.exists());
        destinationFile.delete();
        assert (!destinationFile.exists());
        MediaReader reader = new MediaReader(this.mSource);
        if (this.mTestContainer) {
            final MediaWriter writer = new MediaWriter(this.mDestination, reader.getContainer());
            writer.setMaskLateStreamExceptions(false);
            writer.addListener((IMediaListener)new MediaViewer(this.mViewerMode, true));
            writer.addListener((IMediaListener)new MediaDebugListener(new IMediaDebugListener.Event[]{IMediaDebugListener.Event.OPEN, IMediaDebugListener.Event.CLOSE}));
            reader.addListener((IMediaListener)new MediaListenerAdapter(){

                public void onVideoPicture(IVideoPictureEvent event) {
                    writer.onVideoPicture(event);
                }

                public void onAudioSamples(IAudioSamplesEvent event) {
                    writer.onAudioSamples(event);
                }
            });
            while (reader.readPacket() == null) {
            }
            writer.close();
        } else {
            MediaWriter writer = new MediaWriter(this.mDestination, (IMediaReader)reader);
            reader.addListener((IMediaListener)writer);
            writer.setMaskLateStreamExceptions(false);
            writer.addListener((IMediaListener)new MediaViewer(this.mViewerMode, true));
            writer.addListener((IMediaListener)new MediaDebugListener(IMediaDebugListener.Mode.EVENT, new IMediaDebugListener.Event[]{IMediaDebugListener.Event.META_DATA}));
            while (reader.readPacket() == null) {
            }
        }
        assert (destinationFile.exists());
        assert (destinationFile.length() > 50000L);
    }
}

