/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool;

import com.xuggle.mediatool.IMediaDebugListener;
import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaViewer;
import com.xuggle.mediatool.MediaDebugListener;
import com.xuggle.mediatool.MediaReader;
import com.xuggle.mediatool.MediaViewer;
import com.xuggle.mediatool.MediaWriter;
import com.xuggle.xuggler.IError;
import java.io.File;
import junit.framework.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaToolTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final IMediaViewer.Mode mViewerMode;
    final String PREFIX;
    public static final String TEST_FILE_DIR = "fixtures";
    public static final String INPUT_FILENAME = "fixtures/testfile_videoonly_20sec.flv";
    public static final int READER_VIDEO_FRAME_COUNT = 300;
    public static final int READER_AUDIO_FRAME_COUNT = 762;
    public static final int READER_PACKET_READ_COUNT = 1062;
    public static final int READER_PACKET_WRITE_COUNT = 0;
    public static final int WRITER_VIDEO_FRAME_COUNT = 300;
    public static final int WRITER_AUDIO_FRAME_COUNT = 762;
    public static final int WRITER_PACKET_READ_COUNT = 0;
    public static final int WRITER_PACKET_WRITE_COUNT = 1065;
    public static final int OUTPUT_FILE_SIZE = 3826466;
    public final String OUTPUT_FILENAME;

    public MediaToolTest() {
        this.log.trace("<init>");
        this.mViewerMode = IMediaViewer.Mode.valueOf((String)System.getProperty(this.getClass().getName() + ".ViewerMode", IMediaViewer.Mode.DISABLED.name()));
        this.PREFIX = this.getClass().getName() + "-";
        this.OUTPUT_FILENAME = this.PREFIX + "output.flv";
        this.log.trace("<init>");
    }

    @Test
    public void testEventCounts() {
        IError rv;
        File inputFile = new File(INPUT_FILENAME);
        File outputFile = new File(this.OUTPUT_FILENAME);
        assert (inputFile.exists());
        outputFile.delete();
        assert (!outputFile.exists());
        MediaReader reader = new MediaReader(INPUT_FILENAME);
        MediaWriter writer = new MediaWriter(this.OUTPUT_FILENAME, (IMediaReader)reader);
        reader.addListener((IMediaListener)writer);
        writer.addListener((IMediaListener)new MediaViewer(this.mViewerMode, true, 0));
        MediaDebugListener readerCounter = new MediaDebugListener(IMediaDebugListener.Mode.URL, new IMediaDebugListener.Event[]{IMediaDebugListener.Event.META_DATA});
        MediaDebugListener writerCounter = new MediaDebugListener(IMediaDebugListener.Mode.EVENT, new IMediaDebugListener.Event[]{IMediaDebugListener.Event.META_DATA});
        reader.addListener((IMediaListener)readerCounter);
        writer.addListener((IMediaListener)writerCounter);
        while ((rv = reader.readPacket()) == null) {
        }
        Assert.assertEquals((Object)IError.Type.ERROR_EOF, (Object)rv.getType());
        Assert.assertEquals((long)300L, (long)readerCounter.getCount(IMediaDebugListener.Event.VIDEO));
        Assert.assertEquals((long)762L, (long)readerCounter.getCount(IMediaDebugListener.Event.AUDIO));
        Assert.assertEquals((long)1L, (long)readerCounter.getCount(IMediaDebugListener.Event.OPEN));
        Assert.assertEquals((long)1L, (long)readerCounter.getCount(IMediaDebugListener.Event.CLOSE));
        Assert.assertEquals((long)2L, (long)readerCounter.getCount(IMediaDebugListener.Event.ADD_STREAM));
        Assert.assertEquals((long)2L, (long)readerCounter.getCount(IMediaDebugListener.Event.OPEN_STREAM));
        Assert.assertEquals((long)2L, (long)readerCounter.getCount(IMediaDebugListener.Event.CLOSE_STREAM));
        Assert.assertEquals((long)1062L, (long)readerCounter.getCount(IMediaDebugListener.Event.READ_PACKET));
        Assert.assertEquals((long)0L, (long)readerCounter.getCount(IMediaDebugListener.Event.WRITE_PACKET));
        Assert.assertEquals((long)0L, (long)readerCounter.getCount(IMediaDebugListener.Event.HEADER));
        Assert.assertEquals((long)0L, (long)readerCounter.getCount(IMediaDebugListener.Event.FLUSH));
        Assert.assertEquals((long)0L, (long)readerCounter.getCount(IMediaDebugListener.Event.TRAILER));
        Assert.assertEquals((long)300L, (long)writerCounter.getCount(IMediaDebugListener.Event.VIDEO));
        Assert.assertEquals((long)762L, (long)writerCounter.getCount(IMediaDebugListener.Event.AUDIO));
        Assert.assertEquals((long)1L, (long)writerCounter.getCount(IMediaDebugListener.Event.OPEN));
        Assert.assertEquals((long)1L, (long)writerCounter.getCount(IMediaDebugListener.Event.CLOSE));
        Assert.assertEquals((long)2L, (long)writerCounter.getCount(IMediaDebugListener.Event.ADD_STREAM));
        Assert.assertEquals((long)2L, (long)writerCounter.getCount(IMediaDebugListener.Event.OPEN_STREAM));
        Assert.assertEquals((long)2L, (long)writerCounter.getCount(IMediaDebugListener.Event.CLOSE_STREAM));
        Assert.assertEquals((long)0L, (long)writerCounter.getCount(IMediaDebugListener.Event.READ_PACKET));
        Assert.assertEquals((long)1065L, (long)writerCounter.getCount(IMediaDebugListener.Event.WRITE_PACKET));
        Assert.assertEquals((long)1L, (long)writerCounter.getCount(IMediaDebugListener.Event.HEADER));
        Assert.assertEquals((long)1L, (long)writerCounter.getCount(IMediaDebugListener.Event.FLUSH));
        Assert.assertEquals((long)1L, (long)writerCounter.getCount(IMediaDebugListener.Event.TRAILER));
        assert (outputFile.exists());
        Assert.assertEquals((float)3826466.0f, (float)outputFile.length(), (float)200.0f);
        this.log.debug("reader " + readerCounter);
        this.log.debug("writer " + writerCounter);
    }
}

