/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool;

import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaViewer;
import com.xuggle.mediatool.MediaListenerAdapter;
import com.xuggle.mediatool.MediaReader;
import com.xuggle.mediatool.MediaViewer;
import com.xuggle.mediatool.event.IAudioSamplesEvent;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IError;
import com.xuggle.xuggler.IVideoResampler;
import junit.framework.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaReaderTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final IMediaViewer.Mode mViewerMode;
    final String PREFIX;
    public static final String TEST_FILE_DIR = "fixtures";
    public static final int TEST_FILE_20_SECONDS_VIDEO_FRAME_COUNT = 300;
    public static final int TEST_FILE_20_SECONDS_AUDIO_FRAME_COUNT = 762;
    public static final String TEST_FILE_20_SECONDS = "fixtures/testfile_videoonly_20sec.flv";

    public MediaReaderTest() {
        this.log.trace("<init>");
        this.mViewerMode = IMediaViewer.Mode.valueOf((String)System.getProperty(this.getClass().getName() + ".ViewerMode", IMediaViewer.Mode.DISABLED.name()));
        this.PREFIX = this.getClass().getName() + "-";
    }

    @Test(expected=RuntimeException.class)
    public void testMediaSourceNotExist() {
        MediaReader mr = new MediaReader("brokenfixtures/testfile_videoonly_20sec.flv");
        mr.setBufferedImageTypeToGenerate(5);
        mr.readPacket();
    }

    @Test
    public void testMediaReaderOpenReadClose() {
        final int[] counts = new int[2];
        MediaReader mr = new MediaReader(TEST_FILE_20_SECONDS);
        mr.addListener((IMediaListener)new MediaViewer(this.mViewerMode, true));
        MediaListenerAdapter mrl = new MediaListenerAdapter(){

            public void onVideoPicture(IVideoPictureEvent event) {
                Assert.assertNotNull((String)"picture should be created", (Object)event.getPicture());
                Assert.assertNull((String)"no buffered image should be created", (Object)event.getImage());
                counts[0] = counts[0] + 1;
            }

            public void onAudioSamples(IAudioSamplesEvent event) {
                Assert.assertNotNull((String)"audio samples should be created", (Object)event.getAudioSamples());
                counts[1] = counts[1] + 1;
            }
        };
        mr.addListener((IMediaListener)mrl);
        IError err = null;
        while ((err = mr.readPacket()) == null) {
        }
        Assert.assertEquals((String)"Loop should complete with an EOF", (Object)IError.Type.ERROR_EOF, (Object)err.getType());
        Assert.assertEquals((String)"incorrect number of video frames:", (int)counts[0], (int)300);
        Assert.assertEquals((String)"incorrect number of audio frames:", (int)counts[1], (int)762);
    }

    @Test
    public void testCreateBufferedImages() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        MediaReader mr = new MediaReader(TEST_FILE_20_SECONDS);
        mr.setBufferedImageTypeToGenerate(5);
        mr.addListener((IMediaListener)new MediaViewer(this.mViewerMode, true));
        MediaListenerAdapter mrl = new MediaListenerAdapter(){

            public void onVideoPicture(IVideoPictureEvent event) {
                Assert.assertNotNull((String)"picture should be created", (Object)event.getPicture());
                Assert.assertNotNull((String)"buffered image should be created", (Object)event.getImage());
            }

            public void onAudioSamples(IAudioSamplesEvent event) {
                Assert.assertNotNull((String)"audio samples should be created", (Object)event.getAudioSamples());
            }
        };
        mr.addListener((IMediaListener)mrl);
        while (mr.readPacket() == null) {
        }
    }

    @Test
    public void testOpenWithContainer() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        final int[] counts = new int[2];
        IContainer container = IContainer.make();
        if (container.open(TEST_FILE_20_SECONDS, IContainer.Type.READ, null, false, true) < 0) {
            throw new IllegalArgumentException("could not open: fixtures/testfile_videoonly_20sec.flv");
        }
        MediaReader mr = new MediaReader(container);
        mr.setBufferedImageTypeToGenerate(5);
        mr.addListener((IMediaListener)new MediaViewer(this.mViewerMode, true));
        MediaListenerAdapter mrl = new MediaListenerAdapter(){

            public void onVideoPicture(IVideoPictureEvent event) {
                Assert.assertNotNull((String)"picture should be created", (Object)event.getPicture());
                Assert.assertNotNull((String)"buffered image should be created", (Object)event.getImage());
                counts[0] = counts[0] + 1;
            }

            public void onAudioSamples(IAudioSamplesEvent event) {
                Assert.assertNotNull((String)"audio samples should be created", (Object)event.getAudioSamples());
                counts[1] = counts[1] + 1;
            }
        };
        mr.addListener((IMediaListener)mrl);
        IError err = null;
        while ((err = mr.readPacket()) == null) {
        }
        Assert.assertEquals((String)"Loop should complete with an EOF", (Object)IError.Type.ERROR_EOF, (Object)err.getType());
        Assert.assertEquals((String)"incorrect number of video frames:", (int)counts[0], (int)300);
        Assert.assertEquals((String)"incorrect number of audio frames:", (int)counts[1], (int)762);
        Assert.assertTrue((String)"container should be open", (boolean)container.isOpened());
        Assert.assertEquals((String)"container should have two streams", (int)2, (int)container.getNumStreams());
        for (int i = 0; i < container.getNumStreams(); ++i) {
            Assert.assertFalse((boolean)container.getStream((long)i).getStreamCoder().isOpen());
        }
    }
}

