/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.ferry.JNIReference;
import com.xuggle.ferry.MemoryTestHelper;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.LinkedList;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class BufferExhaustiveTest {
    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getModels() {
        LinkedList<Object[]> retval = new LinkedList<Object[]>();
        for (JNIMemoryManager.MemoryModel model : JNIMemoryManager.MemoryModel.values()) {
            retval.add(new Object[]{model});
        }
        return retval;
    }

    public BufferExhaustiveTest(JNIMemoryManager.MemoryModel model) {
        JNIMemoryManager.setMemoryModel((JNIMemoryManager.MemoryModel)model);
    }

    @Test
    public void testNoLeaksWhenBufferMadeFromDirectJavaByteBuffer() {
        JNIReference.getMgr().flush();
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
            ByteBuffer nativeBytes = ByteBuffer.allocateDirect(0xA00000);
            IBuffer buf = IBuffer.make(null, (ByteBuffer)nativeBytes, (int)0, (int)nativeBytes.capacity());
            Assert.assertNotNull((Object)buf);
            Assert.assertEquals((long)1L, (long)JNIReference.getMgr().getNumPinnedObjects());
            buf.delete();
            buf = null;
            Assert.assertEquals((long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
            System.gc();
            System.gc();
            System.gc();
            Thread.yield();
        }
        JNIReference.getMgr().flush();
    }

    @Test(timeout=120000L)
    public void testIntBuffersMaintainReferenceToByteBuffer() {
        MemoryTestHelper.forceJavaHeapWeakReferenceClear();
        JNIMemoryManager.collect();
        Assert.assertEquals((long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
        IBuffer buf = IBuffer.make(null, (int)0x100000);
        Assert.assertNotNull((Object)buf);
        Assert.assertEquals((long)1L, (long)JNIReference.getMgr().getNumPinnedObjects());
        ByteBuffer jbuf = buf.getByteBuffer(0, buf.getBufferSize());
        Assert.assertEquals((long)2L, (long)JNIReference.getMgr().getNumPinnedObjects());
        buf.delete();
        Assert.assertEquals((long)1L, (long)JNIReference.getMgr().getNumPinnedObjects());
        IntBuffer ibuf = jbuf.asIntBuffer();
        ibuf.put(0, 15);
        jbuf = null;
        Assert.assertEquals((long)1L, (long)JNIReference.getMgr().getNumPinnedObjects());
        Assert.assertEquals((int)15, (int)ibuf.get(0));
        MemoryTestHelper.forceJavaHeapWeakReferenceClear();
        Assert.assertEquals((long)1L, (long)JNIReference.getMgr().getNumPinnedObjects());
        Assert.assertEquals((int)15, (int)ibuf.get(0));
        ibuf = null;
        MemoryTestHelper.forceJavaHeapWeakReferenceClear();
        JNIMemoryManager.collect();
        Assert.assertEquals((long)0L, (long)JNIReference.getMgr().getNumPinnedObjects());
    }

    @Test(timeout=60000L)
    public void testJNIMemoryManagerCollectionThread() {
        JNIMemoryManager.getMgr().startCollectionThread();
        IBuffer buf = IBuffer.make(null, (int)0x100000);
        Assert.assertNotNull((Object)buf);
        ByteBuffer jbuf = buf.getByteBuffer(0, buf.getBufferSize());
        Assert.assertEquals((long)2L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        buf.delete();
        Assert.assertEquals((long)1L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
        jbuf.put((byte)0);
        jbuf = null;
        MemoryTestHelper.forceJavaHeapWeakReferenceClear();
        JNIMemoryManager.collect();
        JNIMemoryManager.getMgr().stopCollectionThread();
    }

    @Test
    public void testNoLeakingMemoryOnCopy() {
        IBuffer buf = IBuffer.make(null, (int)0x100000);
        Assert.assertNotNull((Object)buf);
        for (int i = 0; i < 1000; ++i) {
            byte[] outBytes = buf.getByteArray(0, buf.getBufferSize());
            Assert.assertEquals((int)outBytes.length, (int)buf.getBufferSize());
            Object var3_3 = null;
        }
    }

    @Test(timeout=300000L)
    public void testDirectByteBufferIncrementsAndDecrementsRefCounts() {
        IBuffer buf = IBuffer.make(null, (int)0x100000);
        Assert.assertNotNull((Object)buf);
        Assert.assertEquals((long)1L, (long)buf.getCurrentRefCount());
        ByteBuffer jbuf = buf.getByteBuffer(0, buf.getBufferSize());
        Assert.assertNotNull((Object)buf);
        Assert.assertEquals((long)2L, (long)buf.getCurrentRefCount());
        jbuf.put(0, (byte)-1);
        jbuf = null;
        while (buf.getCurrentRefCount() > 1L) {
            MemoryTestHelper.forceJavaHeapWeakReferenceClear();
            JNIMemoryManager.collect();
        }
        Assert.assertEquals((long)1L, (long)buf.getCurrentRefCount());
    }
}

