/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import java.util.TreeMap;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.KnownPolynomial;

public class UserFunction
implements KnownFunction,
MultiVarFunction,
Cloneable {
    protected static String[] dummyVars = new String[]{"'", "@", "`", "~", "#"};
    protected String name;
    protected String[] paramNames = new String[0];
    protected double[] paramValues = new double[0];
    protected String[] paramDescriptions = new String[0];
    protected String[] functionNames = new String[0];
    protected String expression = "0";
    protected String inputString = "0";
    protected ParsedMultiVarFunction function = null;
    protected String[] vars = new String[]{"x"};
    protected UserFunction[] references = new UserFunction[0];
    protected boolean nameEditable = true;
    protected String description;
    protected KnownPolynomial polynomial;

    public UserFunction(String string) {
        this.setName(string);
        try {
            this.function = new ParsedMultiVarFunction("0", new String[0]);
            this.functionNames = this.function.getFunctionNames();
        }
        catch (ParserException parserException) {}
    }

    public UserFunction(KnownPolynomial knownPolynomial) {
        this(knownPolynomial.getName());
        this.polynomial = knownPolynomial;
        this.setName(knownPolynomial.getName());
        this.setDescription(knownPolynomial.getDescription());
        String[] stringArray = new String[knownPolynomial.getParameterCount()];
        double[] dArray = new double[knownPolynomial.getParameterCount()];
        String[] stringArray2 = new String[knownPolynomial.getParameterCount()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = knownPolynomial.getParameterName(n);
            dArray[n] = knownPolynomial.getParameterValue(n);
            stringArray2[n] = knownPolynomial.getParameterDescription(n);
            ++n;
        }
        this.setParameters(stringArray, dArray, stringArray2);
        this.setExpression(knownPolynomial.getExpression("x"), new String[]{"x"});
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        if (!this.isNameEditable()) {
            return;
        }
        this.name = string;
    }

    public boolean isNameEditable() {
        return this.nameEditable;
    }

    public void setNameEditable(boolean bl) {
        this.nameEditable = bl;
    }

    public String getIndependentVariable() {
        return this.vars[0];
    }

    public String[] getIndependentVariables() {
        return this.vars;
    }

    public String getInputString() {
        String string = this.inputString;
        int n = 0;
        while (n < this.vars.length) {
            string = string.replaceAll(dummyVars[n], this.vars[n]);
            ++n;
        }
        return string;
    }

    public String getExpression() {
        String string = this.expression;
        int n = 0;
        while (n < this.vars.length) {
            string = string.replaceAll(dummyVars[n], this.vars[n]);
            ++n;
        }
        return string;
    }

    @Override
    public String getExpression(String string) {
        this.vars = new String[]{string};
        return this.getExpression();
    }

    public String getExpression(String[] stringArray) {
        this.vars = stringArray;
        return this.getExpression();
    }

    public String getFullExpression(String[] stringArray) {
        String string = this.getExpression(stringArray);
        UserFunction[] userFunctionArray = this.references;
        int n = this.references.length;
        int n2 = 0;
        while (n2 < n) {
            UserFunction userFunction = userFunctionArray[n2];
            string = string.replaceAll(userFunction.getName(), "(" + userFunction.getFullExpression(stringArray) + ")");
            ++n2;
        }
        return string;
    }

    public boolean setExpression(String string, String[] stringArray) {
        int n;
        this.vars = stringArray;
        String[] stringArray2 = new String[this.references.length + this.paramNames.length + this.vars.length];
        int n2 = 0;
        while (n2 < this.paramNames.length) {
            stringArray2[n2 + this.vars.length] = this.paramNames[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < this.references.length) {
            stringArray2[n2 + this.vars.length + this.paramNames.length] = this.references[n2].getName();
            ++n2;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.vars[0]);
        int n3 = 1;
        while (n3 < this.vars.length) {
            int n4 = arrayList.size();
            n = 0;
            while (n < n4) {
                if (this.vars[n3].length() > ((String)arrayList.get(n)).toString().length()) {
                    arrayList.add(n, this.vars[n3]);
                    break;
                }
                if (n == n4 - 1) {
                    arrayList.add(this.vars[n3]);
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < arrayList.size()) {
            String string2 = ((String)arrayList.get(n3)).toString();
            n = 0;
            while (n < this.vars.length) {
                if (string2.equals(this.vars[n])) {
                    string = string.replaceAll(this.vars[n], dummyVars[n]);
                    stringArray2[n] = dummyVars[n];
                    int n5 = this.vars.length;
                    while (n5 < stringArray2.length) {
                        stringArray2[n5] = stringArray2[n5].replaceAll(this.vars[n], dummyVars[n]);
                        ++n5;
                    }
                    n5 = 0;
                    while (n5 < this.functionNames.length) {
                        String string3 = this.functionNames[n5].replaceAll(this.vars[n], dummyVars[n]);
                        if (!string3.equals(this.functionNames[n5])) {
                            string = string.replaceAll(string3, this.functionNames[n5]);
                        }
                        ++n5;
                    }
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.paramNames.length) {
            string = string.replaceAll(stringArray2[this.vars.length + n3], this.paramNames[n3]);
            stringArray2[this.vars.length + n3] = this.paramNames[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < this.references.length) {
            string = string.replaceAll(stringArray2[this.vars.length + this.paramNames.length + n3], this.references[n3].getName());
            stringArray2[this.vars.length + this.paramNames.length + n3] = this.references[n3].getName();
            ++n3;
        }
        this.inputString = string;
        try {
            this.function = new ParsedMultiVarFunction(string, stringArray2);
            if (string.indexOf("=") == -1) {
                this.expression = string;
                return true;
            }
        }
        catch (ParserException parserException) {
            try {
                this.function = new ParsedMultiVarFunction("0", stringArray2);
            }
            catch (ParserException parserException2) {}
            this.expression = "0";
        }
        return false;
    }

    @Override
    public int getParameterCount() {
        return this.paramNames.length;
    }

    @Override
    public String getParameterName(int n) {
        return this.paramNames[n];
    }

    @Override
    public double getParameterValue(int n) {
        return this.paramValues[n];
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.paramValues[n] = d;
    }

    public void setParameters(String[] stringArray, double[] dArray) {
        this.paramNames = stringArray;
        this.paramValues = dArray;
    }

    @Override
    public void setParameters(String[] stringArray, double[] dArray, String[] stringArray2) {
        this.paramNames = stringArray;
        this.paramValues = dArray;
        if (stringArray2 != null) {
            this.paramDescriptions = stringArray2;
        }
    }

    public void updateReferenceParameters() {
        UserFunction[] userFunctionArray = this.references;
        int n = this.references.length;
        int n2 = 0;
        while (n2 < n) {
            UserFunction userFunction = userFunctionArray[n2];
            userFunction.setParameters(this.paramNames, this.paramValues, this.paramDescriptions);
            userFunction.updateReferenceParameters();
            ++n2;
        }
    }

    public void setReferences(UserFunction[] userFunctionArray) {
        this.references = userFunctionArray;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public String getParameterDescription(int n) {
        if (n >= this.paramDescriptions.length) {
            return null;
        }
        return this.paramDescriptions[n];
    }

    @Override
    public double evaluate(double d) {
        if (this.function == null) {
            return Double.NaN;
        }
        double[] dArray = this.evaluateSupportFunctions(d);
        int n = dArray.length + this.paramValues.length + 1;
        double[] dArray2 = new double[n];
        dArray2[0] = d;
        System.arraycopy(this.paramValues, 0, dArray2, 1, this.paramValues.length);
        System.arraycopy(dArray, 0, dArray2, 1 + this.paramValues.length, dArray.length);
        return this.function.evaluate(dArray2);
    }

    @Override
    public double evaluate(double[] dArray) {
        if (this.function == null) {
            return Double.NaN;
        }
        double[] dArray2 = this.evaluateSupportFunctions(dArray);
        int n = dArray2.length + this.paramValues.length + dArray.length;
        double[] dArray3 = new double[n];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(this.paramValues, 0, dArray3, dArray.length, this.paramValues.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length + this.paramValues.length, dArray2.length);
        return this.function.evaluate(dArray3);
    }

    public boolean evaluatedToNaN() {
        return this.function == null ? false : this.function.evaluatedToNaN();
    }

    @Override
    public UserFunction clone() {
        UserFunction userFunction = new UserFunction(this.name);
        userFunction.setDescription(this.description);
        userFunction.setNameEditable(this.nameEditable);
        userFunction.setParameters(this.paramNames, this.paramValues, this.paramDescriptions);
        UserFunction[] userFunctionArray = new UserFunction[this.references.length];
        int n = 0;
        while (n < userFunctionArray.length) {
            userFunctionArray[n] = this.references[n].clone();
            ++n;
        }
        userFunction.setReferences(userFunctionArray);
        userFunction.setExpression(this.inputString, this.vars);
        userFunction.polynomial = this.polynomial == null ? null : this.polynomial.clone();
        return userFunction;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof UserFunction)) {
            return false;
        }
        UserFunction userFunction = (UserFunction)object;
        if (!this.getName().equals(userFunction.getName())) {
            return false;
        }
        if (!this.getInputString().equals(userFunction.getInputString())) {
            return false;
        }
        int n = this.getParameterCount();
        if (n != userFunction.getParameterCount()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.getParameterName(n2).equals(userFunction.getParameterName(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean updatePolynomial() {
        if (this.polynomial == null) {
            return false;
        }
        this.polynomial.setName(this.getName());
        this.polynomial.setDescription(this.getDescription());
        this.polynomial.setParameters(this.paramNames, this.paramValues, this.paramDescriptions);
        return true;
    }

    protected String replaceParameterNameInExpression(String string, String string2) {
        String[] stringArray = this.getIndependentVariables();
        String string3 = this.getInputString();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if ((string3 = this.replaceInExpression(string, string2, string3, treeMap)) == null) {
            return null;
        }
        for (String string4 : treeMap.keySet()) {
            if (string4.equals(string2)) continue;
            string3 = string3.replaceAll(string4, treeMap.get(string4));
        }
        if (this.setExpression(string3, stringArray)) {
            return string3;
        }
        return null;
    }

    private String replaceInExpression(String string, String string2, String string3, TreeMap<String, String> treeMap) {
        if (treeMap.values().contains(string)) {
            return string3;
        }
        int n = 0;
        while (n < this.getParameterCount()) {
            String string4 = this.getParameterName(n);
            if (!string.equals(string4) && !string2.equals(string4) && string4.contains(string)) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < dummyVars.length) {
                    if (dummyVars[n3].equals(string2)) {
                        n2 = n3 + 1;
                        break;
                    }
                    ++n3;
                }
                if (n2 >= dummyVars.length) {
                    return null;
                }
                if ((string3 = this.replaceInExpression(string4, dummyVars[n2], string3, treeMap)) == null) {
                    return null;
                }
            }
            ++n;
        }
        string3 = string3.replaceAll(string, string2);
        treeMap.put(string2, string);
        return string3;
    }

    protected double[] evaluateSupportFunctions(double d) {
        double[] dArray = new double[this.references.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = this.references[n].evaluate(d);
            ++n;
        }
        return dArray;
    }

    protected double[] evaluateSupportFunctions(double[] dArray) {
        double[] dArray2 = new double[this.references.length];
        int n = 0;
        while (n < dArray2.length) {
            dArray2[n] = this.references[n].evaluate(dArray);
            ++n;
        }
        return dArray2;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            UserFunction userFunction = (UserFunction)object;
            xMLControl.setValue("name", userFunction.getName());
            xMLControl.setValue("description", userFunction.getDescription());
            xMLControl.setValue("name_editable", userFunction.isNameEditable());
            xMLControl.setValue("parameter_names", userFunction.paramNames);
            xMLControl.setValue("parameter_values", userFunction.paramValues);
            xMLControl.setValue("parameter_descriptions", userFunction.paramDescriptions);
            xMLControl.setValue("variables", userFunction.getIndependentVariables());
            xMLControl.setValue("expression", userFunction.getInputString());
            if (userFunction.polynomial != null) {
                xMLControl.setValue("polynomial", userFunction.polynomial.getCoefficients());
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            String string = xMLControl.getString("name");
            return new UserFunction(string);
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Object object2;
            Object[] objectArray;
            String[] stringArray;
            UserFunction userFunction = (UserFunction)object;
            userFunction.setName(xMLControl.getString("name"));
            userFunction.setDescription(xMLControl.getString("description"));
            if (xMLControl.getPropertyNames().contains("name_editable")) {
                userFunction.setNameEditable(xMLControl.getBoolean("name_editable"));
            }
            if ((stringArray = (String[])xMLControl.getObject("parameter_names")) != null) {
                objectArray = (double[])xMLControl.getObject("parameter_values");
                object2 = (String[])xMLControl.getObject("parameter_descriptions");
                userFunction.setParameters(stringArray, (double[])objectArray, (String[])object2);
            }
            if ((objectArray = (Object[])((String[])xMLControl.getObject("variables"))) == null) {
                object2 = xMLControl.getString("variable");
                objectArray = new String[]{object2};
            }
            userFunction.setExpression(xMLControl.getString("expression"), (String[])objectArray);
            object2 = (double[])xMLControl.getObject("polynomial");
            if (object2 != null) {
                userFunction.polynomial = new KnownPolynomial((double[])object2);
            }
            return object;
        }
    }
}

