/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.Library;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.LibraryComPADRE;
import org.opensourcephysics.tools.LibraryManager;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.LibraryTreeNode;
import org.opensourcephysics.tools.LibraryTreePanel;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class LibraryBrowser
extends JPanel {
    public static final String TRACKER_LIBRARY = "http://physlets.org/tracker/library/tracker_library.xml";
    public static final String SHARED_LIBRARY = "http://physlets.org/tracker/library/shared_library.xml";
    protected static final String AND = " AND ";
    protected static final String OR = " OR ";
    protected static final String OPENING = "(";
    protected static final String CLOSING = ")";
    protected static final String MY_LIBRARY_NAME = "my_library.xml";
    protected static final String MY_COLLECTION_NAME = "my_collection.xml";
    protected static final String LIBRARY_HELP_NAME = "library_browser_help.html";
    protected static final String LIBRARY_HELP_BASE = "http://www.opensourcephysics.org/online_help/tools/";
    protected static final String WINDOWS_OSP_DIRECTORY = "/My Documents/OSP/";
    protected static final String OSP_DIRECTORY = "/Documents/OSP/";
    private static LibraryBrowser browser;
    protected static Border buttonBorder;
    protected static boolean webConnected;
    protected static JFrame frame;
    protected static JDialog externalDialog;
    protected static JMenuBar menubar;
    protected static Icon expandIcon;
    protected static Icon contractIcon;
    protected static Icon heavyExpandIcon;
    protected static Icon heavyContractIcon;
    protected static Icon refreshIcon;
    protected static final FileFilter TRACKER_FILTER;
    protected static javax.swing.filechooser.FileFilter filesAndFoldersFilter;
    protected static Timer searchTimer;
    protected static String searchTerm;
    public static boolean fireHelpEvent;
    protected Library library = new Library();
    protected String libraryPath;
    protected JToolBar toolbar;
    protected Action commandAction;
    protected Action searchAction;
    protected Action openRecentAction;
    protected JLabel commandLabel;
    protected JLabel searchLabel;
    protected JTextField commandField;
    protected JTextField searchField;
    protected JMenu fileMenu;
    protected JMenu recentMenu;
    protected JMenu collectionsMenu;
    protected JMenu manageMenu;
    protected JMenu helpMenu;
    protected JMenuItem newItem;
    protected JMenuItem openItem;
    protected JMenuItem saveItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem closeItem;
    protected JMenuItem closeAllItem;
    protected JMenuItem exitItem;
    protected JMenuItem deleteItem;
    protected JMenuItem collectionsItem;
    protected JMenuItem searchItem;
    protected JMenuItem cacheItem;
    protected JMenuItem aboutItem;
    protected JMenuItem logItem;
    protected JMenuItem helpItem;
    protected JButton commandButton;
    protected JButton editButton;
    protected JButton refreshButton;
    protected ActionListener loadCollectionAction;
    protected boolean exitOnClose;
    protected JTabbedPane tabbedPane;
    protected JScrollPane htmlScroller;
    protected PropertyChangeListener treePanelListener;
    protected boolean keyPressed;
    protected boolean textChanged;
    protected TextFrame helpFrame;
    protected JEditorPane htmlAboutPane;
    protected FileFilter dlFileFilter = TRACKER_FILTER;
    protected boolean isRecentPathXML;
    protected LibraryManager libraryManager;

    static {
        TRACKER_FILTER = new TrackerDLFilter();
        filesAndFoldersFilter = new FilesAndFoldersFilter();
        fireHelpEvent = false;
        buttonBorder = BorderFactory.createEtchedBorder();
        Border border = BorderFactory.createEmptyBorder(1, 2, 2, 2);
        buttonBorder = BorderFactory.createCompoundBorder(buttonBorder, border);
        border = BorderFactory.createEmptyBorder(0, 1, 0, 1);
        buttonBorder = BorderFactory.createCompoundBorder(border, buttonBorder);
        menubar = new JMenuBar();
        String string = "/org/opensourcephysics/resources/tools/images/expand.png";
        expandIcon = new ImageIcon(LibraryTreePanel.class.getResource(string));
        string = "/org/opensourcephysics/resources/tools/images/contract.png";
        contractIcon = new ImageIcon(LibraryTreePanel.class.getResource(string));
        string = "/org/opensourcephysics/resources/tools/images/expand_bold.png";
        heavyExpandIcon = new ImageIcon(LibraryTreePanel.class.getResource(string));
        string = "/org/opensourcephysics/resources/tools/images/contract_bold.png";
        heavyContractIcon = new ImageIcon(LibraryTreePanel.class.getResource(string));
        string = "/org/opensourcephysics/resources/tools/images/refresh.gif";
        refreshIcon = new ImageIcon(LibraryTreePanel.class.getResource(string));
    }

    public static LibraryBrowser getBrowser() {
        if (browser == null) {
            browser = LibraryBrowser.getBrowser(null);
        }
        return browser;
    }

    public static LibraryBrowser getBrowser(JDialog jDialog) {
        Object object;
        Object object2;
        boolean bl = false;
        if (frame == null && jDialog == null) {
            bl = true;
            frame = new JFrame();
        }
        if ((externalDialog = jDialog) != null) {
            externalDialog.setDefaultCloseOperation(0);
        }
        if (browser == null) {
            Object object3;
            object2 = System.getProperty("user.home").replace('\\', '/');
            object = OSPRuntime.isWindows() ? WINDOWS_OSP_DIRECTORY : OSP_DIRECTORY;
            String string = String.valueOf(object2) + (String)object + MY_LIBRARY_NAME;
            File file = new File(string);
            boolean bl2 = file.exists();
            if (!bl2) {
                Object object4;
                Object object5;
                object3 = String.valueOf(object2) + (String)object + MY_COLLECTION_NAME;
                File file2 = new File((String)object3);
                if (!file2.exists()) {
                    object5 = ToolsRes.getString("LibraryCollection.Name.Local");
                    object4 = new LibraryCollection((String)object5);
                    String string2 = XML.getDirectoryPath((String)object3);
                    ((LibraryResource)object4).setBasePath(XML.forwardSlash(string2));
                    XMLControlElement xMLControlElement = new XMLControlElement(object4);
                    xMLControlElement.write((String)object3);
                }
                object5 = new Library();
                object4 = ToolsRes.getString("LibraryCollection.Name.Local");
                ((Library)object5).addCollection((String)object3, (String)object4);
                ((Library)object5).save(string);
            }
            if ((object3 = (browser = new LibraryBrowser(string)).getSelectedTreePanel()) != null) {
                ((LibraryTreePanel)object3).setSelectedNode(((LibraryTreePanel)object3).rootNode);
                ((LibraryTreePanel)object3).showInfo(((LibraryTreePanel)object3).rootNode);
            }
            OSPLog.getOSPLog();
        }
        browser.setTitle(ToolsRes.getString("LibraryBrowser.Title"));
        if (externalDialog != null) {
            externalDialog.setContentPane(browser);
            externalDialog.setJMenuBar(menubar);
            externalDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    browser.exit();
                }
            });
            externalDialog.pack();
        } else {
            frame.setContentPane(browser);
            frame.setJMenuBar(menubar);
            frame.setDefaultCloseOperation(0);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    browser.exit();
                }
            });
            try {
                object2 = LibraryBrowser.class.getResource("/org/opensourcephysics/resources/controls/images/osp_icon.gif");
                object = new ImageIcon((URL)object2);
                frame.setIconImage(((ImageIcon)object).getImage());
            }
            catch (Exception exception) {}
            frame.pack();
            if (bl) {
                object2 = Toolkit.getDefaultToolkit().getScreenSize();
                int n = (((Dimension)object2).width - LibraryBrowser.frame.getBounds().width) / 2;
                int n2 = (((Dimension)object2).height - LibraryBrowser.frame.getBounds().height) / 2;
                frame.setLocation(n, n2);
            }
        }
        return browser;
    }

    public void setFontLevel(int n) {
        FontSizer.setFonts(this.getTopLevelAncestor(), n);
        Font font = this.tabbedPane.getFont();
        this.tabbedPane.setFont(FontSizer.getResizedFont(font, n));
        int n2 = 0;
        while (n2 < this.tabbedPane.getTabCount()) {
            LibraryTreePanel libraryTreePanel = this.getTreePanel(n2);
            libraryTreePanel.setFontLevel(n);
            ++n2;
        }
        if (this.libraryManager != null) {
            this.libraryManager.setFontLevel(n);
        }
        FontSizer.setFonts(OSPLog.getOSPLog(), n);
    }

    public void importLibrary(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LibraryBrowser.this.library.importLibrary(string);
                LibraryBrowser.this.refreshCollectionsMenu();
            }
        };
        new Thread(runnable).start();
    }

    public void addOSPLibrary(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LibraryBrowser.this.library.addOSPLibrary(string);
                LibraryBrowser.this.refreshCollectionsMenu();
            }
        };
        new Thread(runnable).start();
    }

    public void addComPADRECollection(String string) {
        this.library.addComPADRECollection(string, LibraryComPADRE.getCollectionName(string));
    }

    public synchronized void refreshCollectionsMenu() {
        Object object;
        Object object2;
        JMenu jMenu = this.collectionsMenu;
        jMenu.removeAll();
        JMenu jMenu2 = new JMenu(ToolsRes.getString("Library.Name.Local"));
        jMenu.add(jMenu2);
        if (!this.library.pathList.isEmpty()) {
            for (String string : this.library.pathList) {
                object2 = this.library.pathToNameMap.get(string);
                object = new JMenuItem((String)object2);
                jMenu2.add((JMenuItem)object);
                ((AbstractButton)object).addActionListener(this.loadCollectionAction);
                ((JComponent)object).setToolTipText(string);
                ((AbstractButton)object).setActionCommand(string);
            }
        }
        if (!this.library.comPADREPathList.isEmpty()) {
            JMenu jMenu3 = new JMenu(ToolsRes.getString("Library.Name.ComPADRE"));
            jMenu.add(jMenu3);
            for (String string : this.library.comPADREPathList) {
                object = this.library.comPADREPathToNameMap.get(string);
                JMenuItem jMenuItem = new JMenuItem((String)object);
                jMenu3.add(jMenuItem);
                jMenuItem.addActionListener(this.loadCollectionAction);
                jMenuItem.setToolTipText(string);
                jMenuItem.setActionCommand(string);
            }
        }
        if (!this.library.ospPathList.isEmpty()) {
            for (String string : this.library.ospPathList) {
                object2 = this.library.ospPathToLibraryMap.get(string);
                object = new JMenu(((Library)object2).getName());
                jMenu.add((JMenuItem)object);
                this.populateSubMenu((JMenu)object, (Library)object2);
            }
        }
        if (!this.library.importedPathList.isEmpty()) {
            jMenu.addSeparator();
            for (String string : this.library.importedPathList) {
                object2 = this.library.importedPathToLibraryMap.get(string);
                object = new JMenu(((Library)object2).getName());
                jMenu.add((JMenuItem)object);
                for (String string2 : ((Library)object2).pathList) {
                    String string3 = ((Library)object2).pathToNameMap.get(string2);
                    JMenuItem jMenuItem = new JMenuItem(string3);
                    ((JMenu)object).add(jMenuItem);
                    jMenuItem.addActionListener(this.loadCollectionAction);
                    jMenuItem.setToolTipText(string2);
                    jMenuItem.setActionCommand(string2);
                }
            }
        }
        FontSizer.setFonts(this.collectionsMenu, FontSizer.getLevel());
    }

    private void populateSubMenu(JMenu jMenu, Library library) {
        JMenuItem jMenuItem;
        Object object;
        for (String string : library.pathList) {
            object = library.pathToNameMap.get(string);
            jMenuItem = new JMenuItem((String)object);
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this.loadCollectionAction);
            jMenuItem.setToolTipText(string);
            jMenuItem.setActionCommand(string);
        }
        if (!library.subPathList.isEmpty()) {
            for (String string : library.subPathList) {
                if (this.library.ospPathList.contains(string)) continue;
                object = library.subPathToLibraryMap.get(string);
                jMenuItem = new JMenu(((Library)object).getName());
                jMenu.add(jMenuItem);
                this.populateSubMenu((JMenu)jMenuItem, (Library)object);
            }
        }
    }

    public void setTitle(String string) {
        if (frame != null) {
            frame.setTitle(string);
        } else if (externalDialog != null) {
            externalDialog.setTitle(string);
        }
    }

    public FileFilter getDLFileFilter() {
        return this.dlFileFilter;
    }

    public void setDLFileFilter(FileFilter fileFilter) {
        this.dlFileFilter = fileFilter;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (externalDialog != null) {
            externalDialog.setVisible(bl);
        } else {
            frame.setVisible(bl);
        }
    }

    public boolean exit() {
        LibraryTreePanel libraryTreePanel = this.getSelectedTreePanel();
        if (libraryTreePanel != null) {
            libraryTreePanel.refreshEntryFields();
        }
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            LibraryTreePanel libraryTreePanel2 = this.getTreePanel(n);
            if (!libraryTreePanel2.saveChanges(this.getTabTitle(n))) {
                return false;
            }
            ++n;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.tabbedPane.getTabCount();
        int n3 = 0;
        while (n3 < n2) {
            String string = this.getTreePanel((int)n3).pathToRoot;
            if (!string.equals("")) {
                arrayList.add(string);
            }
            ++n3;
        }
        this.library.openTabPaths = arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
        this.library.save(this.libraryPath);
        if (this.exitOnClose) {
            System.exit(0);
        } else {
            this.refreshGUI();
            this.setVisible(false);
        }
        return true;
    }

    private LibraryBrowser(String string) {
        super(new BorderLayout());
        this.libraryPath = string;
        this.library.browser = this;
        this.createGUI();
        this.refreshGUI();
        this.refreshCollectionsMenu();
        this.editButton.requestFocusInWindow();
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LibraryBrowser.this.refreshGUI();
                LibraryBrowser.this.refreshCollectionsMenu();
                if (LibraryBrowser.this.libraryManager != null) {
                    LibraryBrowser.this.libraryManager.refreshGUI();
                }
                LibraryTreePanel.htmlPanesByNode.clear();
                LibraryTreePanel libraryTreePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (libraryTreePanel != null) {
                    libraryTreePanel.showInfo(libraryTreePanel.getSelectedNode());
                }
            }
        });
    }

    protected LibraryManager getManager() {
        if (this.libraryManager == null) {
            this.libraryManager = externalDialog != null ? new LibraryManager(this, externalDialog) : new LibraryManager(this, frame);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this.libraryManager.getBounds().width) / 2;
            int n2 = (dimension.height - this.libraryManager.getBounds().height) / 2;
            this.libraryManager.setLocation(n, n2);
        }
        if (this.library.pathList.size() > 0 && this.libraryManager.collectionList.getSelectedIndex() == -1) {
            this.libraryManager.collectionList.setSelectedIndex(0);
        }
        if (this.library.importedPathList.size() > 0 && this.libraryManager.guestList.getSelectedIndex() == -1) {
            this.libraryManager.guestList.setSelectedIndex(0);
        }
        this.libraryManager.setFontLevel(FontSizer.getLevel());
        return this.libraryManager;
    }

    protected LibraryTreePanel getSelectedTreePanel() {
        return (LibraryTreePanel)this.tabbedPane.getSelectedComponent();
    }

    protected LibraryTreePanel getTreePanel(int n) {
        return (LibraryTreePanel)this.tabbedPane.getComponentAt(n);
    }

    protected String getTabTitle(String string) {
        int n = this.getTabIndexFromPath(string);
        return n > -1 ? this.getTabTitle(n) : null;
    }

    protected String getTabTitle(int n) {
        String string = this.tabbedPane.getTitleAt(n);
        if (string.endsWith("*")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected int getTabIndexFromPath(String string) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            LibraryTreePanel libraryTreePanel = this.getTreePanel(n);
            if (libraryTreePanel.pathToRoot.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected int getTabIndexFromTitle(String string) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            String string2 = this.tabbedPane.getTitleAt(n);
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void loadTab(String string, List<String> list) {
        string = XML.forwardSlash(string);
        this.library.addRecent(string, false);
        this.refreshRecentMenu();
        int n = this.getTabIndexFromPath(string);
        if (n > -1) {
            this.tabbedPane.setSelectedIndex(n);
            LibraryTreePanel libraryTreePanel = this.getTreePanel(n);
            libraryTreePanel.setSelectionPath(list);
            return;
        }
        TabLoader tabLoader = this.addTab(string, list);
        if (tabLoader == null) {
            return;
        }
        tabLoader.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Integer n;
                if ("progress".equals(propertyChangeEvent.getPropertyName()) && (n = (Integer)propertyChangeEvent.getNewValue()) > -1) {
                    LibraryBrowser.this.tabbedPane.setSelectedIndex(n);
                }
            }
        });
        tabLoader.execute();
    }

    protected LibraryResource loadResource(String string) {
        this.isRecentPathXML = false;
        File file = new File(string);
        if (file.isDirectory()) {
            return this.createCollection(file, file, this.dlFileFilter);
        }
        if (LibraryComPADRE.isComPADREPath(string)) {
            return LibraryComPADRE.getCollection(string);
        }
        XMLControlElement xMLControlElement = new XMLControlElement(string);
        if (!xMLControlElement.failedToRead() && xMLControlElement.getObjectClass() != null && LibraryResource.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            this.isRecentPathXML = true;
            return (LibraryResource)xMLControlElement.loadObject(null);
        }
        return this.createResource(file, file.getParentFile(), this.dlFileFilter);
    }

    protected LibraryResource createResource(File file, File file2, FileFilter fileFilter) {
        if (file == null || !file.exists()) {
            return null;
        }
        if (!fileFilter.accept(file)) {
            return null;
        }
        String string = file.getName();
        String string2 = XML.forwardSlash(file.getAbsolutePath());
        String string3 = XML.forwardSlash(file2.getAbsolutePath());
        String string4 = XML.getPathRelativeTo(string2, string3);
        LibraryResource libraryResource = new LibraryResource(string);
        libraryResource.setBasePath(string3);
        libraryResource.setTarget(string4);
        string = string.toLowerCase();
        if (string.indexOf(".htm") > -1) {
            libraryResource.setHTMLPath(string4);
            libraryResource.setType("HTML");
        }
        if (string.endsWith(".zip") && fileFilter == TRACKER_FILTER) {
            libraryResource.setType("Tracker");
        }
        if (string.endsWith(".trz")) {
            libraryResource.setType("Tracker");
        }
        return libraryResource;
    }

    protected LibraryCollection createCollection(File file, File file2, FileFilter fileFilter) {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        Object object5;
        File[] fileArray;
        HTMLFilter hTMLFilter = new HTMLFilter();
        File[] fileArray2 = file.listFiles(hTMLFilter);
        HashSet<Object> hashSet = new HashSet<Object>();
        String string2 = file.getName();
        LibraryCollection libraryCollection = new LibraryCollection(string2);
        if (file2 == file) {
            libraryCollection.setBasePath(XML.forwardSlash(file2.getAbsolutePath()));
        }
        File[] fileArray3 = fileArray2;
        int n = fileArray2.length;
        int n2 = 0;
        while (n2 < n) {
            fileArray = fileArray3[n2];
            if (XML.stripExtension(fileArray.getName()).equals(String.valueOf(string2) + "_info")) {
                object5 = XML.getPathRelativeTo(fileArray.getAbsolutePath(), file2.getAbsolutePath());
                libraryCollection.setHTMLPath((String)object5);
                object4 = ResourceLoader.getHTMLCode(fileArray.getAbsolutePath());
                object3 = ResourceLoader.getTitleFromHTMLCode((String)object4);
                if (object3 != null) {
                    libraryCollection.setName((String)object3);
                }
                hashSet.add(fileArray);
            }
            ++n2;
        }
        object5 = fileArray = file.listFiles(new DirectoryFilter());
        int n3 = fileArray.length;
        n = 0;
        while (n < n3) {
            File file3 = object5[n];
            object4 = this.createCollection(file3, file2, fileFilter);
            if (((LibraryCollection)object4).getResources().length > 0) {
                libraryCollection.addResource((LibraryResource)object4);
            }
            ++n;
        }
        File[] fileArray4 = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
        object4 = fileArray4;
        int n4 = fileArray4.length;
        n3 = 0;
        while (n3 < n4) {
            Object object6 = object4[n3];
            if (!hTMLFilter.accept((File)object6)) {
                object3 = XML.getPathRelativeTo(((File)object6).getAbsolutePath(), file2.getAbsolutePath());
                string = ((File)object6).getName();
                object2 = XML.stripExtension(string);
                object = new LibraryResource(string);
                libraryCollection.addResource((LibraryResource)object);
                ((LibraryResource)object).setTarget((String)object3);
                if (string.toLowerCase().endsWith(".zip") && fileFilter == TRACKER_FILTER) {
                    ((LibraryResource)object).setType("Tracker");
                }
                if (string.toLowerCase().endsWith(".trz")) {
                    ((LibraryResource)object).setType("Tracker");
                }
                File[] fileArray5 = fileArray2;
                int n5 = fileArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    File file4 = fileArray5[n6];
                    String string3 = XML.stripExtension(file4.getName());
                    if (string3.equals(String.valueOf(object2) + "_info")) {
                        if ("".equals(((LibraryResource)object).getHTMLPath())) {
                            object3 = XML.getPathRelativeTo(file4.getAbsolutePath(), file2.getAbsolutePath());
                            ((LibraryResource)object).setHTMLPath((String)object3);
                            String string4 = ResourceLoader.getHTMLCode(file4.getAbsolutePath());
                            String string5 = ResourceLoader.getTitleFromHTMLCode(string4);
                            if (string5 != null) {
                                ((LibraryResource)object).setName(string5);
                            }
                        }
                        hashSet.add(file4);
                        break;
                    }
                    ++n6;
                }
            }
            ++n3;
        }
        int n7 = 0;
        object3 = fileArray2;
        int n8 = fileArray2.length;
        n4 = 0;
        while (n4 < n8) {
            File file5 = object3[n4];
            if (!hashSet.contains(file5) && fileFilter.accept(file5)) {
                string = file5.getName();
                object2 = new LibraryResource(string);
                object = XML.getPathRelativeTo(file5.getAbsolutePath(), file2.getAbsolutePath());
                ((LibraryResource)object2).setHTMLPath((String)object);
                ((LibraryResource)object2).setType("HTML");
                libraryCollection.insertResource((LibraryResource)object2, n7++);
            }
            ++n4;
        }
        return libraryCollection;
    }

    protected TabLoader addTab(String string, List<String> list) {
        if (string == null) {
            return null;
        }
        File file = ResourceLoader.getSearchCacheFile(string);
        boolean bl = file.exists();
        if (!bl && !LibraryBrowser.isWebConnected() && string.startsWith("http:")) {
            JOptionPane.showMessageDialog(this, ToolsRes.getString("LibraryBrowser.Dialog.ServerUnavailable.Message"), ToolsRes.getString("LibraryBrowser.Dialog.ServerUnavailable.Title"), 2);
            return null;
        }
        TabLoader tabLoader = new TabLoader(string, -1, list);
        return tabLoader;
    }

    protected void refreshTabTitle(String string, LibraryResource libraryResource) {
        Object object;
        boolean bl;
        int n = this.getTabIndexFromPath(string);
        if (n == -1) {
            return;
        }
        String string2 = libraryResource.getTitle(string);
        if (string.contains("http://www.compadre.org/osp/services/REST/osp_tracker.cfm?verb=Identify&OSPType=Tracker") && this.tabbedPane.getTabComponentAt(n) == null) {
            bl = string.contains("OSPPrimary");
            object = bl ? expandIcon : contractIcon;
            Icon icon = bl ? heavyExpandIcon : heavyContractIcon;
            final TabTitle tabTitle = new TabTitle((Icon)object, icon);
            FontSizer.setFonts(tabTitle, FontSizer.getLevel());
            tabTitle.iconLabel.setToolTipText(bl ? ToolsRes.getString("LibraryBrowser.Tooltip.Expand") : ToolsRes.getString("LibraryBrowser.Tooltip.Contract"));
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = tabTitle.normalIcon == contractIcon;
                    int n = LibraryBrowser.this.getTabIndexFromTitle(tabTitle.titleLabel.getText());
                    if (n > -1) {
                        LibraryTreePanel libraryTreePanel = LibraryBrowser.this.getTreePanel(n);
                        String string = LibraryComPADRE.getCollectionPath(libraryTreePanel.pathToRoot, bl);
                        new TabLoader(string, n, null).execute();
                        tabTitle.setIcons(bl ? expandIcon : contractIcon, bl ? heavyExpandIcon : heavyContractIcon);
                        tabTitle.iconLabel.setToolTipText(bl ? ToolsRes.getString("LibraryBrowser.Tooltip.Expand") : ToolsRes.getString("LibraryBrowser.Tooltip.Contract"));
                    }
                }
            };
            tabTitle.setAction(abstractAction);
            this.tabbedPane.setTabComponentAt(n, tabTitle);
        }
        this.tabbedPane.setTitleAt(n, (bl = this.getTreePanel(n).isChanged()) ? String.valueOf(string2) + "*" : string2);
        this.library.getNameMap().put(string, string2);
        if (n == this.tabbedPane.getSelectedIndex()) {
            object = " '" + string2 + "'";
            this.closeItem.setText(String.valueOf(ToolsRes.getString("LibraryBrowser.MenuItem.CloseTab")) + (String)object);
        }
    }

    protected void createGUI() {
        double d = 1.0 + (double)FontSizer.getLevel() * 0.25;
        int n = (int)(d * 800.0);
        int n2 = (int)(d * 440.0);
        this.setPreferredSize(new Dimension(n, n2));
        this.loadCollectionAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryBrowser.this.loadTab(actionEvent.getActionCommand(), null);
            }
        };
        this.commandAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                boolean bl;
                if (actionEvent == null) {
                    return;
                }
                LibraryBrowser.this.commandField.setBackground(Color.white);
                LibraryBrowser.this.commandField.setForeground(LibraryTreePanel.defaultForeground);
                if (!LibraryBrowser.this.commandButton.isEnabled()) {
                    return;
                }
                String string = LibraryBrowser.this.commandField.getText().trim();
                if (string.equals("")) {
                    return;
                }
                string = XML.forwardSlash(string);
                string = ResourceLoader.getNonURIPath(string);
                Resource resource = null;
                String string2 = string;
                if (!string.startsWith("http://www.compadre.org/OSP/") && XML.getExtension(string) == null) {
                    while (string2.endsWith("/")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    if (!string2.equals("")) {
                        String string3 = XML.getName(string2);
                        string2 = String.valueOf(string2) + "/" + string3 + ".xml";
                        resource = ResourceLoader.getResource(string2);
                    }
                }
                if (resource != null) {
                    string = string2;
                } else {
                    resource = ResourceLoader.getResourceZipURLsOK(string);
                }
                if (resource == null) {
                    LibraryBrowser.this.commandField.setForeground(LibraryTreePanel.darkRed);
                    return;
                }
                boolean bl2 = bl = resource.getFile() != null && resource.getFile().isDirectory();
                if (!bl) {
                    object = new XMLControlElement(string);
                    boolean bl3 = bl = !object.failedToRead() && object.getObjectClass() == LibraryCollection.class;
                }
                if (bl) {
                    LibraryBrowser.this.loadTab(string, null);
                    LibraryBrowser.this.refreshGUI();
                    object = LibraryBrowser.this.getSelectedTreePanel();
                    if (object != null && ((LibraryTreePanel)object).pathToRoot.equals(string)) {
                        ((LibraryTreePanel)object).setSelectedNode(((LibraryTreePanel)object).rootNode);
                        LibraryBrowser.this.commandField.setBackground(Color.white);
                        LibraryBrowser.this.commandField.repaint();
                    }
                    return;
                }
                object = null;
                LibraryTreePanel libraryTreePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (libraryTreePanel != null && libraryTreePanel.getSelectedNode() != null) {
                    object = libraryTreePanel.getSelectedNode().record.getClone();
                    ((LibraryResource)object).setBasePath(libraryTreePanel.getSelectedNode().getBasePath());
                } else {
                    object = new LibraryResource("");
                    ((LibraryResource)object).setTarget(string);
                }
                LibraryBrowser.this.firePropertyChange("target", null, object);
            }
        };
        this.commandLabel = new JLabel();
        this.commandLabel.setAlignmentX(0.5f);
        this.commandLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
        this.commandField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = Math.max(dimension.width, 400);
                return dimension;
            }
        };
        LibraryTreePanel.defaultForeground = this.commandField.getForeground();
        this.commandField.addActionListener(this.commandAction);
        this.commandField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = LibraryBrowser.this.commandField.getText();
                LibraryBrowser.this.commandButton.setEnabled(!"".equals(string));
                LibraryBrowser.this.textChanged = LibraryBrowser.this.keyPressed;
                LibraryTreePanel libraryTreePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (libraryTreePanel != null) {
                    libraryTreePanel.command = string;
                    LibraryTreeNode libraryTreeNode = libraryTreePanel.getSelectedNode();
                    if (libraryTreeNode != null && libraryTreeNode.isRoot() && libraryTreeNode.record instanceof LibraryCollection && libraryTreePanel.pathToRoot.equals(string)) {
                        LibraryBrowser.this.commandButton.setEnabled(false);
                    }
                } else {
                    LibraryBrowser.this.commandField.setBackground(Color.yellow);
                    LibraryBrowser.this.commandField.setForeground(LibraryTreePanel.defaultForeground);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                LibraryBrowser.this.commandButton.setEnabled(!"".equals(LibraryBrowser.this.commandField.getText()));
                LibraryBrowser.this.textChanged = LibraryBrowser.this.keyPressed;
                LibraryTreePanel libraryTreePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (libraryTreePanel != null) {
                    libraryTreePanel.command = LibraryBrowser.this.commandField.getText();
                } else {
                    LibraryBrowser.this.commandField.setBackground(Color.yellow);
                    LibraryBrowser.this.commandField.setForeground(LibraryTreePanel.defaultForeground);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.commandField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                LibraryBrowser.this.keyPressed = true;
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                LibraryTreePanel libraryTreePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (libraryTreePanel != null && LibraryBrowser.this.textChanged && keyEvent.getKeyCode() != 10) {
                    LibraryBrowser.this.commandField.setBackground(Color.yellow);
                    LibraryBrowser.this.commandField.setForeground(LibraryTreePanel.defaultForeground);
                    libraryTreePanel.setSelectedNode(null);
                }
                LibraryBrowser.this.keyPressed = false;
                LibraryBrowser.this.textChanged = false;
            }
        });
        this.commandField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                LibraryBrowser.this.commandField.selectAll();
            }
        });
        this.commandButton = new JButton(this.commandAction);
        this.commandButton.setOpaque(false);
        this.commandButton.setBorder(buttonBorder);
        this.searchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                searchTerm = LibraryBrowser.this.searchField.getText();
                if ("".equals(searchTerm.trim())) {
                    return;
                }
                LibraryBrowser.this.searchField.selectAll();
                LibraryBrowser.this.searchField.setBackground(Color.white);
                class Searcher
                extends SwingWorker<LibraryTreePanel, Object> {
                    Searcher() {
                    }

                    @Override
                    public LibraryTreePanel doInBackground() {
                        Set<LibraryResource> set = LibraryBrowser.this.getSearchCacheTargets();
                        Iterator<LibraryResource> iterator = set.iterator();
                        while (iterator.hasNext()) {
                            LibraryResource libraryResource = iterator.next();
                            if (!(this).LibraryBrowser.this.library.noSearchSet.contains(libraryResource.collectionPath)) continue;
                            iterator.remove();
                        }
                        return LibraryBrowser.this.searchFor(searchTerm.trim(), set);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void done() {
                        try {
                            LibraryTreePanel libraryTreePanel = (LibraryTreePanel)this.get();
                            if (libraryTreePanel == null) {
                                Toolkit.getDefaultToolkit().beep();
                                final Color color = (this).LibraryBrowser.this.searchField.getForeground();
                                (this).LibraryBrowser.this.searchField.setText(ToolsRes.getString("LibraryBrowser.Search.NotFound"));
                                (this).LibraryBrowser.this.searchField.setForeground(Color.RED);
                                (this).LibraryBrowser.this.searchField.setBackground(Color.white);
                                if (searchTimer == null) {
                                    searchTimer = new Timer(1000, new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent actionEvent) {
                                            (((Searcher)this).this).LibraryBrowser.this.searchField.setText(searchTerm);
                                            (((Searcher)this).this).LibraryBrowser.this.searchField.setForeground(color);
                                            (((Searcher)this).this).LibraryBrowser.this.searchField.selectAll();
                                            (((Searcher)this).this).LibraryBrowser.this.searchField.setBackground(Color.white);
                                        }
                                    });
                                    searchTimer.setRepeats(false);
                                    searchTimer.start();
                                } else {
                                    searchTimer.restart();
                                }
                                return;
                            }
                            String string = "'" + searchTerm.trim() + "'";
                            int n = LibraryBrowser.this.getTabIndexFromTitle(string);
                            JTabbedPane jTabbedPane = (this).LibraryBrowser.this.tabbedPane;
                            synchronized (jTabbedPane) {
                                if (n > -1) {
                                    (this).LibraryBrowser.this.tabbedPane.setComponentAt(n, libraryTreePanel);
                                } else {
                                    (this).LibraryBrowser.this.tabbedPane.addTab(string, libraryTreePanel);
                                }
                                (this).LibraryBrowser.this.tabbedPane.setSelectedComponent(libraryTreePanel);
                            }
                            LibraryTreePanel.htmlPanesByNode.remove(libraryTreePanel.rootNode);
                            libraryTreePanel.showInfo(libraryTreePanel.rootNode);
                            LibraryBrowser.this.refreshGUI();
                        }
                        catch (Exception exception) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                }
                new Searcher().execute();
            }
        };
        this.searchLabel = new JLabel();
        this.searchLabel.setAlignmentX(0.5f);
        this.searchLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
        this.searchField = new LibraryTreePanel.EntryField(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.width = (int)(120.0 * (1.0 + (double)FontSizer.getLevel() * 0.25));
                return dimension;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = (int)(120.0 * (1.0 + (double)FontSizer.getLevel() * 0.25));
                return dimension;
            }
        };
        this.searchField.addActionListener(this.searchAction);
        this.refreshButton = new JButton(refreshIcon);
        this.refreshButton.setBorder(buttonBorder);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreePanel libraryTreePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (libraryTreePanel != null) {
                    LibraryTreeNode libraryTreeNode = libraryTreePanel.getSelectedNode();
                    if (libraryTreeNode == libraryTreePanel.rootNode) {
                        LibraryResource libraryResource;
                        File file = ResourceLoader.getSearchCacheFile(libraryTreePanel.pathToRoot);
                        if (file.exists()) {
                            file.delete();
                        }
                        if ((libraryResource = LibraryBrowser.this.loadResource(libraryTreePanel.pathToRoot)) != null) {
                            libraryTreePanel.setRootResource(libraryResource, libraryTreePanel.pathToRoot, libraryTreePanel.rootNode.isEditable(), false);
                            LibraryBrowser.this.refreshTabTitle(libraryTreePanel.pathToRoot, libraryTreePanel.rootResource);
                            if (libraryTreePanel.metadataLoader != null) {
                                libraryTreePanel.metadataLoader.cancel();
                            }
                            LibraryTreePanel libraryTreePanel2 = libraryTreePanel;
                            libraryTreePanel2.getClass();
                            libraryTreePanel.metadataLoader = libraryTreePanel2.new LibraryTreePanel.MetadataLoader(true, null);
                            libraryTreePanel.metadataLoader.execute();
                            return;
                        }
                    } else if (libraryTreeNode != null) {
                        File file;
                        Object object;
                        LibraryTreePanel.HTMLPane hTMLPane = new LibraryTreePanel.HTMLPane();
                        hTMLPane.setText("<h2>" + ToolsRes.getString("LibraryBrowser.Info.Refreshing") + " '" + libraryTreeNode + "'</h2>");
                        libraryTreePanel.htmlScroller.setViewportView(hTMLPane);
                        URL uRL = libraryTreeNode.getHTMLURL();
                        if (uRL != null) {
                            object = ResourceLoader.getOSPCacheFile(uRL.toExternalForm());
                            if (((File)object).exists()) {
                                ((File)object).delete();
                            }
                            LibraryTreePanel.htmlPanesByURL.remove(uRL);
                        }
                        if ((object = libraryTreeNode.getAbsoluteTarget()) != null && (file = libraryTreeNode.getThumbnailFile()).exists()) {
                            file.delete();
                            libraryTreeNode.record.setThumbnail(null);
                        }
                        libraryTreeNode.record.setMetadata(null);
                        libraryTreeNode.record.setDescription(null);
                        LibraryTreePanel libraryTreePanel3 = libraryTreePanel;
                        libraryTreePanel3.getClass();
                        libraryTreePanel3.new LibraryTreePanel.NodeLoader(libraryTreeNode).execute();
                    }
                }
            }
        });
        this.tabbedPane = new JTabbedPane(1){

            @Override
            public void setTitleAt(int n, String string) {
                super.setTitleAt(n, string);
                Component component = LibraryBrowser.this.tabbedPane.getTabComponentAt(n);
                if (component != null) {
                    TabTitle tabTitle = (TabTitle)component;
                    tabTitle.setTitle(string);
                }
            }
        };
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LibraryBrowser.this.refreshGUI();
                LibraryTreePanel libraryTreePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (libraryTreePanel != null) {
                    LibraryTreeNode libraryTreeNode = libraryTreePanel.getSelectedNode();
                    if (libraryTreeNode != null) {
                        String string = libraryTreeNode.isRoot() ? libraryTreePanel.pathToRoot : libraryTreeNode.getAbsoluteTarget();
                        LibraryBrowser.this.commandField.setText(string);
                        libraryTreePanel.showInfo(libraryTreeNode);
                    } else {
                        LibraryBrowser.this.commandField.setText(libraryTreePanel.command);
                        LibraryBrowser.this.commandField.setCaretPosition(0);
                    }
                }
                LibraryBrowser.this.commandField.setBackground(Color.white);
                LibraryBrowser.this.commandField.setForeground(LibraryTreePanel.defaultForeground);
                if (LibraryBrowser.this.libraryManager != null && LibraryBrowser.this.libraryManager.isVisible()) {
                    LibraryBrowser.this.libraryManager.refreshGUI();
                }
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.Close"));
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = (this).LibraryBrowser.this.tabbedPane.getSelectedIndex();
                            LibraryBrowser.this.closeTab(n);
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    final LibraryTreePanel libraryTreePanel = LibraryBrowser.this.getSelectedTreePanel();
                    if (!"".equals(libraryTreePanel.pathToRoot) && !LibraryBrowser.this.library.containsPath(libraryTreePanel.pathToRoot, false)) {
                        jMenuItem = new JMenuItem(ToolsRes.getString("LibraryBrowser.MenuItem.AddToLibrary"));
                        jMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                LibraryBrowser.this.addToCollections(libraryTreePanel.pathToRoot);
                            }
                        });
                        jPopupMenu.addSeparator();
                        jPopupMenu.add(jMenuItem);
                    }
                    FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                    jPopupMenu.show(LibraryBrowser.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY() + 8);
                }
            }
        });
        this.treePanelListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("collection_edit")) {
                    LibraryBrowser.this.refreshGUI();
                } else if (string.equals("target")) {
                    Object object;
                    LibraryResource libraryResource = null;
                    if (propertyChangeEvent.getNewValue() instanceof LibraryTreeNode) {
                        object = (LibraryTreeNode)propertyChangeEvent.getNewValue();
                        if (((LibraryTreeNode)object).record instanceof LibraryCollection) {
                            LibraryBrowser.this.setCursor(Cursor.getPredefinedCursor(3));
                            if (!LibraryComPADRE.loadResources((LibraryTreeNode)object)) {
                                LibraryBrowser.this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(LibraryBrowser.this, ToolsRes.getString("LibraryBrowser.Dialog.NoResources.Message"), ToolsRes.getString("LibraryBrowser.Dialog.NoResources.Title"), -1);
                                return;
                            }
                            ((LibraryTreeNode)object).createChildNodes();
                            LibraryTreePanel.htmlPanesByNode.remove(object);
                            LibraryTreeNode libraryTreeNode = (LibraryTreeNode)((DefaultMutableTreeNode)object).getLastChild();
                            TreePath treePath = new TreePath(libraryTreeNode.getPath());
                            LibraryBrowser.this.getSelectedTreePanel().tree.scrollPathToVisible(treePath);
                            LibraryBrowser.this.getSelectedTreePanel().showInfo((LibraryTreeNode)object);
                            LibraryBrowser.this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                        libraryResource = ((LibraryTreeNode)object).record.getClone();
                        libraryResource.setBasePath(((LibraryTreeNode)object).getBasePath());
                    } else {
                        libraryResource = (LibraryResource)propertyChangeEvent.getNewValue();
                    }
                    object = libraryResource.getTarget();
                    if (object != null && (((String)object).toLowerCase().endsWith(".pdf") || ((String)object).toLowerCase().endsWith(".html") || ((String)object).toLowerCase().endsWith(".htm"))) {
                        object = XML.getResolvedPath((String)object, libraryResource.getBasePath());
                        object = ResourceLoader.getURIPath((String)object);
                        LibraryBrowser.this.setCursor(Cursor.getPredefinedCursor(3));
                        OSPDesktop.displayURL((String)object);
                        LibraryBrowser.this.setCursor(Cursor.getDefaultCursor());
                    } else {
                        LibraryBrowser.this.firePropertyChange("target", propertyChangeEvent.getOldValue(), libraryResource);
                    }
                }
            }
        };
        this.editButton = new JButton();
        this.editButton.setOpaque(false);
        this.editButton.setBorder(buttonBorder);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final LibraryTreePanel libraryTreePanel = LibraryBrowser.this.getSelectedTreePanel();
                if (!libraryTreePanel.isEditing()) {
                    libraryTreePanel.setEditing(true);
                    LibraryBrowser.this.refreshGUI();
                } else if (!libraryTreePanel.isChanged()) {
                    libraryTreePanel.setEditing(false);
                    LibraryBrowser.this.refreshGUI();
                } else {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("LibraryBrowser.MenuItem.SaveEdits"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = LibraryBrowser.this.save();
                            if (string == null) {
                                return;
                            }
                            libraryTreePanel.setEditing(false);
                            LibraryBrowser.this.refreshGUI();
                        }
                    });
                    jMenuItem = new JMenuItem(ToolsRes.getString("LibraryBrowser.MenuItem.Discard"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            libraryTreePanel.setEditing(false);
                            libraryTreePanel.revert();
                            LibraryBrowser.this.refreshGUI();
                        }
                    });
                    FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                    jPopupMenu.show(LibraryBrowser.this.editButton, 0, LibraryBrowser.this.editButton.getHeight());
                }
            }
        });
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        Border border = BorderFactory.createEmptyBorder(1, 2, 1, 2);
        Border border2 = BorderFactory.createEtchedBorder();
        this.toolbar.setBorder(BorderFactory.createCompoundBorder(border2, border));
        this.toolbar.add(this.commandLabel);
        this.toolbar.add(this.commandField);
        this.toolbar.add(this.commandButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.searchLabel);
        this.toolbar.add(this.searchField);
        this.toolbar.addSeparator();
        this.toolbar.add(this.editButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.refreshButton);
        this.add((Component)this.toolbar, "North");
        this.fileMenu = new JMenu();
        menubar.add(this.fileMenu);
        this.newItem = new JMenuItem();
        int n3 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, n3));
        this.newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = LibraryBrowser.this.createNewCollection();
                LibraryBrowser.this.library.addRecent(string, false);
                LibraryBrowser.this.refreshRecentMenu();
            }
        });
        this.openItem = new JMenuItem();
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, n3));
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryBrowser.this.open();
            }
        });
        this.closeItem = new JMenuItem();
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = LibraryBrowser.this.tabbedPane.getSelectedIndex();
                if (LibraryBrowser.this.closeTab(n)) {
                    LibraryBrowser.this.refreshGUI();
                }
            }
        });
        this.closeAllItem = new JMenuItem();
        this.closeAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = LibraryBrowser.this.tabbedPane.getTabCount() - 1;
                while (n >= 0) {
                    if (!LibraryBrowser.this.closeTab(n)) break;
                    --n;
                }
                LibraryBrowser.this.refreshGUI();
            }
        });
        this.recentMenu = new JMenu();
        this.fileMenu.add(this.recentMenu);
        this.saveItem = new JMenuItem();
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, n3));
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryBrowser.this.save();
            }
        });
        this.saveAsItem = new JMenuItem();
        this.saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = LibraryBrowser.this.saveAs();
                LibraryBrowser.this.library.addRecent(string, false);
                LibraryBrowser.this.refreshRecentMenu();
            }
        });
        this.exitItem = new JMenuItem();
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, n3));
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryBrowser.this.exit();
            }
        });
        this.collectionsMenu = new JMenu();
        menubar.add(this.collectionsMenu);
        this.manageMenu = new JMenu();
        menubar.add(this.manageMenu);
        this.collectionsItem = new JMenuItem();
        this.manageMenu.add(this.collectionsItem);
        this.collectionsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryManager libraryManager = browser.getManager();
                libraryManager.tabbedPane.setSelectedComponent(libraryManager.collectionsPanel);
                libraryManager.setVisible(true);
            }
        });
        this.searchItem = new JMenuItem();
        this.manageMenu.add(this.searchItem);
        this.searchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryManager libraryManager = browser.getManager();
                libraryManager.tabbedPane.setSelectedComponent(libraryManager.searchPanel);
                libraryManager.setVisible(true);
            }
        });
        this.cacheItem = new JMenuItem();
        this.manageMenu.add(this.cacheItem);
        this.cacheItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryManager libraryManager = browser.getManager();
                libraryManager.tabbedPane.setSelectedComponent(libraryManager.cachePanel);
                libraryManager.setVisible(true);
            }
        });
        this.helpMenu = new JMenu();
        menubar.add(this.helpMenu);
        this.helpItem = new JMenuItem();
        this.helpItem.setAccelerator(KeyStroke.getKeyStroke(72, n3));
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryBrowser.this.showHelp();
            }
        });
        this.helpMenu.add(this.helpItem);
        this.helpMenu.addSeparator();
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, n3));
        this.logItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Point point = new Frame().getLocation();
                OSPLog oSPLog = OSPLog.getOSPLog();
                if (oSPLog.getLocation().x == point.x && oSPLog.getLocation().y == point.y) {
                    oSPLog.setLocationRelativeTo(LibraryBrowser.this);
                }
                ((Window)oSPLog).setVisible(true);
            }
        });
        this.helpMenu.add(this.logItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, n3));
        this.aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LibraryBrowser.this.showAboutDialog();
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.htmlAboutPane = new LibraryTreePanel.HTMLPane();
        this.htmlScroller = new JScrollPane(this.htmlAboutPane);
        this.htmlAboutPane.setText(this.getAboutLibraryBrowserText());
        this.htmlAboutPane.setCaretPosition(0);
        if (externalDialog != null) {
            externalDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    new LibraryLoader().execute();
                }
            });
        } else {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    new LibraryLoader().execute();
                }
            });
        }
    }

    protected void refreshGUI() {
        if (this.tabbedPane.getTabCount() == 0) {
            this.remove(this.tabbedPane);
            this.add((Component)this.htmlScroller, "Center");
            this.validate();
        } else {
            this.remove(this.htmlScroller);
            this.add((Component)this.tabbedPane, "Center");
        }
        this.setTitle(ToolsRes.getString("LibraryBrowser.Title"));
        this.fileMenu.setText(ToolsRes.getString("Menu.File"));
        this.newItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.New"));
        this.openItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.Open"));
        this.closeAllItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.CloseAll"));
        this.saveItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.Save"));
        this.saveAsItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.SaveAs"));
        this.exitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.collectionsMenu.setText(ToolsRes.getString("LibraryBrowser.Menu.Collections"));
        this.manageMenu.setText(ToolsRes.getString("LibraryBrowser.Menu.Manage"));
        this.collectionsItem.setText(String.valueOf(ToolsRes.getString("LibraryManager.Tab.MyLibrary")) + "...");
        this.searchItem.setText(String.valueOf(ToolsRes.getString("LibraryManager.Tab.Search")) + "...");
        this.cacheItem.setText(String.valueOf(ToolsRes.getString("LibraryManager.Tab.Cache")) + "...");
        this.helpMenu.setText(ToolsRes.getString("Menu.Help"));
        this.helpItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.Help"));
        this.logItem.setText(ToolsRes.getString("MenuItem.Log"));
        this.aboutItem.setText(ToolsRes.getString("MenuItem.About"));
        this.commandLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Target"));
        this.commandButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Load"));
        this.commandField.setToolTipText(ToolsRes.getString("LibraryBrowser.Field.Command.Tooltip"));
        this.searchLabel.setText(ToolsRes.getString("LibraryBrowser.Label.Search"));
        this.searchField.setToolTipText(ToolsRes.getString("LibraryBrowser.Field.Search.Tooltip"));
        this.saveAsItem.setEnabled(true);
        this.refreshRecentMenu();
        this.fileMenu.removeAll();
        this.fileMenu.add(this.newItem);
        this.fileMenu.add(this.openItem);
        this.fileMenu.add(this.recentMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeItem);
        this.fileMenu.add(this.closeAllItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveItem);
        this.fileMenu.add(this.saveAsItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitItem);
        LibraryTreePanel libraryTreePanel = this.getSelectedTreePanel();
        if (libraryTreePanel != null) {
            this.editButton.setText(!libraryTreePanel.isEditing() ? ToolsRes.getString("LibraryBrowser.Button.OpenEditor") : ToolsRes.getString("LibraryBrowser.Button.CloseEditor"));
            this.editButton.setEnabled(libraryTreePanel.isEditable());
            String string = " '" + this.getTabTitle(libraryTreePanel.pathToRoot) + "'";
            this.closeItem.setText(String.valueOf(ToolsRes.getString("LibraryBrowser.MenuItem.CloseTab")) + string);
            this.closeItem.setEnabled(true);
            this.closeAllItem.setEnabled(true);
            this.saveItem.setEnabled(libraryTreePanel.isChanged());
            int n = this.tabbedPane.getSelectedIndex();
            String string2 = this.tabbedPane.getTitleAt(n);
            if (libraryTreePanel.isChanged() && !string2.endsWith("*")) {
                this.tabbedPane.setTitleAt(n, String.valueOf(string2) + "*");
            } else if (!libraryTreePanel.isChanged() && string2.endsWith("*")) {
                this.tabbedPane.setTitleAt(n, string2.substring(0, string2.length() - 1));
            }
            libraryTreePanel.refreshGUI();
        } else {
            this.refreshButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Tooltip.Refresh"));
            this.editButton.setText(ToolsRes.getString("LibraryBrowser.Button.OpenEditor"));
            this.saveItem.setEnabled(false);
            this.closeItem.setText(ToolsRes.getString("LibraryBrowser.MenuItem.CloseTab"));
            this.closeItem.setEnabled(false);
            this.closeAllItem.setEnabled(false);
            this.editButton.setEnabled(false);
            this.refreshButton.setEnabled(false);
            this.commandField.setText(null);
            this.commandButton.setEnabled(false);
            this.saveAsItem.setEnabled(false);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRecentMenu() {
        ArrayList<String> arrayList = this.library.recentTabs;
        synchronized (arrayList) {
            this.recentMenu.setText(ToolsRes.getString("LibraryBrowser.Menu.OpenRecent"));
            this.recentMenu.setEnabled(!this.library.recentTabs.isEmpty());
            if (this.openRecentAction == null) {
                this.openRecentAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = actionEvent.getActionCommand();
                        LibraryBrowser.this.library.addRecent(string, false);
                        int n = LibraryBrowser.this.getTabIndexFromPath(string);
                        if (n > -1) {
                            LibraryBrowser.this.tabbedPane.setSelectedIndex(n);
                            return;
                        }
                        TabLoader tabLoader = LibraryBrowser.this.addTab(string, null);
                        if (tabLoader != null) {
                            tabLoader.addPropertyChangeListener(new PropertyChangeListener(){

                                @Override
                                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                    Integer n;
                                    if ("progress".equals(propertyChangeEvent.getPropertyName()) && (n = (Integer)propertyChangeEvent.getNewValue()) > -1) {
                                        (this).LibraryBrowser.this.tabbedPane.setSelectedIndex(n);
                                        LibraryBrowser.this.refreshGUI();
                                    }
                                }
                            });
                            tabLoader.execute();
                        } else {
                            LibraryBrowser.this.library.recentTabs.remove(string);
                            LibraryBrowser.this.refreshRecentMenu();
                            JOptionPane.showMessageDialog(LibraryBrowser.this, String.valueOf(ToolsRes.getString("LibraryBrowser.Dialog.FileNotFound.Message")) + ": " + string, ToolsRes.getString("LibraryBrowser.Dialog.FileNotFound.Title"), 2);
                        }
                    }
                };
            }
            this.recentMenu.removeAll();
            this.recentMenu.setEnabled(!this.library.recentTabs.isEmpty());
            for (String string : this.library.recentTabs) {
                String string2 = this.library.getNameMap().get(string);
                if (string2 == null) {
                    string2 = XML.getName(string);
                }
                JMenuItem jMenuItem = new JMenuItem(string2);
                jMenuItem.setActionCommand(string);
                jMenuItem.setToolTipText(string);
                jMenuItem.addActionListener(this.openRecentAction);
                this.recentMenu.add(jMenuItem);
            }
        }
        FontSizer.setFonts(this.recentMenu, FontSizer.getLevel());
    }

    protected void open() {
        Object object;
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        javax.swing.filechooser.FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        int n = fileFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = fileFilterArray[n2];
            jFileChooser.removeChoosableFileFilter((javax.swing.filechooser.FileFilter)object);
            ++n2;
        }
        jFileChooser.addChoosableFileFilter(filesAndFoldersFilter);
        jFileChooser.addChoosableFileFilter(Launcher.getXMLFilter());
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter(filesAndFoldersFilter);
        object = GUIUtils.showOpenDialog(this);
        jFileChooser.removeChoosableFileFilter(filesAndFoldersFilter);
        jFileChooser.removeChoosableFileFilter(Launcher.getXMLFilter());
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setFileSelectionMode(0);
        if (object != null) {
            this.open(((File)object).getAbsolutePath());
        }
    }

    protected void open(String string) {
        if (string == null) {
            return;
        }
        this.loadTab(string, null);
    }

    protected boolean closeTab(int n) {
        if (n < 0 || n >= this.tabbedPane.getTabCount()) {
            return true;
        }
        LibraryTreePanel libraryTreePanel = this.getTreePanel(n);
        if (!libraryTreePanel.saveChanges(this.getTabTitle(n))) {
            return false;
        }
        this.tabbedPane.removeTabAt(n);
        return true;
    }

    protected String save() {
        LibraryTreePanel libraryTreePanel = this.getSelectedTreePanel();
        String string = libraryTreePanel.save();
        this.refreshGUI();
        return string;
    }

    protected String saveAs() {
        String string = ToolsRes.getString("LibraryBrowser.FileChooser.Title.SaveAs");
        String string2 = this.getChooserSavePath(string);
        if (string2 != null) {
            string2 = XML.forwardSlash(string2);
            LibraryTreePanel libraryTreePanel = this.getSelectedTreePanel();
            libraryTreePanel.setRootResource(libraryTreePanel.rootResource, string2, true, true);
            string2 = this.save();
            libraryTreePanel.setEditing(true);
            this.refreshTabTitle(string2, libraryTreePanel.rootResource);
            this.refreshGUI();
            this.commandField.setForeground(LibraryTreePanel.defaultForeground);
        }
        return string2;
    }

    protected String getChooserSavePath(String string) {
        int n;
        File file = GUIUtils.showSaveDialog(this, string);
        if (file == null) {
            return null;
        }
        String string2 = file.getAbsolutePath();
        String string3 = XML.getExtension(string2);
        if (string3 == null && (file = new File(string2 = String.valueOf(XML.stripExtension(string2)) + ".xml")).exists() && (n = JOptionPane.showConfirmDialog(this, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
            return null;
        }
        return string2;
    }

    protected Set<LibraryResource> getSearchCacheTargets() {
        TreeSet<LibraryResource> treeSet = new TreeSet<LibraryResource>();
        File file = ResourceLoader.getSearchCache();
        XMLFilter xMLFilter = new XMLFilter();
        List<File> list = ResourceLoader.getFiles(file, xMLFilter);
        for (File file2 : list) {
            XMLControlElement xMLControlElement = new XMLControlElement(file2.getAbsolutePath());
            if (xMLControlElement.failedToRead() || !LibraryResource.class.isAssignableFrom(xMLControlElement.getObjectClass())) continue;
            LibraryResource libraryResource = (LibraryResource)xMLControlElement.loadObject(null);
            libraryResource.collectionPath = xMLControlElement.getString("real_path");
            treeSet.add(libraryResource);
        }
        return treeSet;
    }

    protected LibraryTreePanel searchFor(String string, Set<LibraryResource> set) {
        Comparable<LibraryTreeNode> comparable2;
        LibraryResource libraryResource2;
        List<String[]> list;
        if (string == null || string.trim().equals("")) {
            return null;
        }
        TreeMap<LibraryResource, Object> treeMap = new TreeMap<LibraryResource, Object>();
        for (LibraryResource object2 : set) {
            if (object2 == null) continue;
            if (object2 instanceof LibraryCollection) {
                list = this.searchCollectionFor(string, (LibraryCollection)object2);
                for (LibraryResource libraryResource2 : list.keySet()) {
                    libraryResource2.collectionPath = object2.collectionPath;
                    treeMap.put(libraryResource2, (List)list.get(libraryResource2));
                }
                continue;
            }
            list = this.searchResourceFor(string, object2);
            if (list == null) continue;
            treeMap.put(object2, list);
        }
        if (treeMap.isEmpty()) {
            return null;
        }
        String string2 = "'" + string + "'";
        LibraryTreePanel libraryTreePanel = this.createLibraryTreePanel();
        list = String.valueOf(ToolsRes.getString("LibraryBrowser.SearchResults")) + ": " + string2;
        libraryResource2 = new LibraryCollection((String)((Object)list));
        libraryTreePanel.setRootResource(libraryResource2, "", false, false);
        LibraryTreeNode libraryTreeNode = libraryTreePanel.rootNode;
        for (Comparable<LibraryTreeNode> comparable2 : treeMap.keySet()) {
            LibraryResource libraryResource3 = ((LibraryResource)comparable2).getClone();
            ((LibraryCollection)libraryResource2).addResource(libraryResource3);
            LibraryTreeNode libraryTreeNode2 = new LibraryTreeNode(libraryResource3, libraryTreePanel);
            libraryTreeNode2.setBasePath(((LibraryResource)comparable2).getInheritedBasePath());
            libraryTreePanel.insertChildAt(libraryTreeNode2, libraryTreeNode, libraryTreeNode.getChildCount());
        }
        comparable2 = (LibraryTreeNode)libraryTreeNode.getLastChild();
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)comparable2)).getPath());
        libraryTreePanel.tree.scrollPathToVisible(treePath);
        libraryTreePanel.isChanged = false;
        return libraryTreePanel;
    }

    protected Map<LibraryResource, List<String[]>> searchCollectionFor(String string, LibraryCollection libraryCollection) {
        String[] stringArray = string.split(AND);
        String[] stringArray2 = string.split(OR);
        if (stringArray.length > 1 && stringArray2.length == 1) {
            Map<LibraryResource, List<String[]>> map = this.searchCollectionFor(stringArray[0], libraryCollection);
            OSPLog.finer("AND '" + stringArray[0] + "' (found: " + map.size() + CLOSING);
            int n = 1;
            while (n < stringArray.length) {
                Map<LibraryResource, List<String[]>> map2 = this.searchCollectionFor(stringArray[n], libraryCollection);
                OSPLog.finer("AND '" + stringArray[n] + "' (found: " + map.size() + CLOSING);
                map = this.applyAND(map, map2);
                ++n;
            }
            OSPLog.finer("AND found: " + map.size());
            return map;
        }
        if (stringArray2.length > 1 && stringArray.length == 1) {
            Map<LibraryResource, List<String[]>> map = this.searchCollectionFor(stringArray2[0], libraryCollection);
            OSPLog.finer("OR '" + stringArray2[0] + "' (found: " + map.size() + CLOSING);
            int n = 1;
            while (n < stringArray2.length) {
                Map<LibraryResource, List<String[]>> map3 = this.searchCollectionFor(stringArray2[n], libraryCollection);
                OSPLog.finer("OR '" + stringArray2[n] + "' (found: " + map.size() + CLOSING);
                map = this.applyOR(map, map3);
                ++n;
            }
            OSPLog.finer("OR found: " + map.size());
            return map;
        }
        if (stringArray2.length > 1 && stringArray.length > 1) {
            String[] stringArray3 = this.getNextSplit(string);
            Map<LibraryResource, List<String[]>> map = this.searchCollectionFor(stringArray3[0], libraryCollection);
            while (stringArray3.length > 2) {
                String string2 = stringArray3[1];
                String string3 = stringArray3[2];
                stringArray3 = this.getNextSplit(string3);
                Map<LibraryResource, List<String[]>> map4 = this.searchCollectionFor(stringArray3[0], libraryCollection);
                if (string2.equals(AND)) {
                    map = this.applyAND(map, map4);
                    continue;
                }
                if (!string2.equals(OR)) continue;
                map = this.applyOR(map, map4);
            }
            return map;
        }
        TreeMap<LibraryResource, List<String[]>> treeMap = new TreeMap<LibraryResource, List<String[]>>();
        List<String[]> list = this.searchResourceFor(string, libraryCollection);
        if (list != null) {
            treeMap.put(libraryCollection, list);
        }
        LibraryResource[] libraryResourceArray = libraryCollection.getResources();
        int n = libraryResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            LibraryResource libraryResource = libraryResourceArray[n2];
            if (libraryResource != null) {
                if (libraryResource instanceof LibraryCollection) {
                    Map<LibraryResource, List<String[]>> map = this.searchCollectionFor(string, (LibraryCollection)libraryResource);
                    for (LibraryResource libraryResource2 : map.keySet()) {
                        treeMap.put(libraryResource2, map.get(libraryResource2));
                    }
                } else {
                    list = this.searchResourceFor(string, libraryResource);
                    if (list != null) {
                        treeMap.put(libraryResource, list);
                    }
                }
            }
            ++n2;
        }
        return treeMap;
    }

    protected List<String[]> searchResourceFor(String string, LibraryResource libraryResource) {
        TreeSet<LibraryResource.Metadata> treeSet;
        String string2;
        String string3 = string.toLowerCase();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string4 = libraryResource.getName();
        if (string4.toLowerCase().contains(string3)) {
            arrayList.add(new String[]{"name", string4});
        }
        if ((string2 = libraryResource.getType()).toLowerCase().contains(string3)) {
            arrayList.add(new String[]{"type", string2});
        }
        if ((treeSet = libraryResource.getMetadata()) != null) {
            for (LibraryResource.Metadata metadata : treeSet) {
                String string5 = metadata.getData()[0];
                String string6 = metadata.getData()[1];
                if (string6.toLowerCase().indexOf(string3) <= -1) continue;
                arrayList.add(new String[]{string5, string6});
            }
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    protected String[] getNextSplit(String string) {
        int n;
        String[] stringArray = string.split(AND, 2);
        String[] stringArray2 = string.split(OR, 2);
        String[] stringArray3 = string.split(Pattern.quote(OPENING), 2);
        int n2 = stringArray[0].length() <= stringArray2[0].length() ? (stringArray[0].length() <= stringArray3[0].length() ? 0 : 2) : (n = stringArray2[0].length() <= stringArray3[0].length() ? 1 : 2);
        if (n == 2 && stringArray3.length > 1) {
            String[] stringArray4 = this.getParenthesisSplit(stringArray3[1]);
            if (stringArray4.length == 1) {
                return new String[]{stringArray4[0]};
            }
            int n3 = stringArray4[1].indexOf(AND);
            int n4 = stringArray4[1].indexOf(OR);
            if (n3 == -1 && n4 == -1) {
                return new String[]{stringArray3[1]};
            }
            if (n3 > -1 && (n4 == -1 || n3 < n4)) {
                return new String[]{stringArray4[0], AND, stringArray4[1].substring(n3 + AND.length())};
            }
            if (n4 > -1 && (n3 == -1 || n4 < n3)) {
                return new String[]{stringArray4[0], OR, stringArray4[1].substring(n4 + OR.length())};
            }
        }
        switch (n) {
            case 0: {
                if (stringArray.length == 1) {
                    return new String[]{stringArray[0]};
                }
                return new String[]{stringArray[0], AND, stringArray[1]};
            }
            case 1: {
                if (stringArray2.length == 1) {
                    return new String[]{stringArray2[0]};
                }
                return new String[]{stringArray2[0], OR, stringArray2[1]};
            }
        }
        return new String[]{string};
    }

    protected String[] getParenthesisSplit(String string) {
        String[] stringArray;
        int n = 1;
        int n2 = 1;
        int n3 = string.indexOf(OPENING, n);
        int n4 = string.indexOf(CLOSING, n);
        while (n2 > 0) {
            if (n3 > -1 && n3 < n4) {
                ++n2;
                n = n3 + 1;
                n3 = string.indexOf(OPENING, n);
                continue;
            }
            if (n4 > -1) {
                --n2;
                n = n4 + 1;
                n4 = string.indexOf(CLOSING, n);
                continue;
            }
            return new String[]{string};
        }
        String string2 = string.substring(0, n - 1);
        String string3 = string.substring(n);
        if (string3.trim().equals("")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string2;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = string2;
            stringArray = stringArray3;
            stringArray3[1] = string3;
        }
        return stringArray;
    }

    protected Map<LibraryResource, List<String[]>> applyAND(Map<LibraryResource, List<String[]>> map, Map<LibraryResource, List<String[]>> map2) {
        TreeMap<LibraryResource, List<String[]>> treeMap = new TreeMap<LibraryResource, List<String[]>>();
        Set<LibraryResource> set = map.keySet();
        for (LibraryResource libraryResource : map2.keySet()) {
            if (!set.contains(libraryResource)) continue;
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(map.get(libraryResource));
            arrayList.addAll(map2.get(libraryResource));
            treeMap.put(libraryResource, arrayList);
        }
        return treeMap;
    }

    protected Map<LibraryResource, List<String[]>> applyOR(Map<LibraryResource, List<String[]>> map, Map<LibraryResource, List<String[]>> map2) {
        ArrayList arrayList;
        TreeMap<LibraryResource, List<String[]>> treeMap = new TreeMap<LibraryResource, List<String[]>>();
        for (LibraryResource libraryResource : map.keySet()) {
            arrayList = new ArrayList();
            arrayList.addAll(map.get(libraryResource));
            treeMap.put(libraryResource, arrayList);
        }
        for (LibraryResource libraryResource : map2.keySet()) {
            if (treeMap.keySet().contains(libraryResource)) {
                ((List)treeMap.get(libraryResource)).addAll((Collection)map2.get(libraryResource));
                continue;
            }
            arrayList = new ArrayList();
            arrayList.addAll(map2.get(libraryResource));
            treeMap.put(libraryResource, arrayList);
        }
        return treeMap;
    }

    protected void addToCollections(String string) {
        LibraryResource libraryResource;
        if (this.library.containsPath(string, true)) {
            return;
        }
        String string2 = this.getTabTitle(string);
        if (string2 == null && (libraryResource = this.loadResource(string)) != null) {
            string2 = libraryResource.getName();
        }
        if (string2.equals("")) {
            string2 = XML.getName(string);
        }
        this.library.addCollection(string, string2);
        this.refreshCollectionsMenu();
        this.refreshGUI();
    }

    protected String createNewCollection() {
        String string = ToolsRes.getString("LibraryBrowser.FileChooser.Title.SaveCollectionAs");
        String string2 = this.getChooserSavePath(string);
        if (string2 != null) {
            LibraryCollection libraryCollection = new LibraryCollection(null);
            XMLControlElement xMLControlElement = new XMLControlElement(libraryCollection);
            xMLControlElement.write(string2);
            string2 = XML.forwardSlash(string2);
            TabLoader tabLoader = this.addTab(string2, null);
            if (tabLoader == null) {
                return null;
            }
            tabLoader.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Integer n;
                    if ("progress".equals(propertyChangeEvent.getPropertyName()) && (n = (Integer)propertyChangeEvent.getNewValue()) > -1) {
                        LibraryBrowser.this.tabbedPane.setSelectedIndex(n);
                        LibraryTreePanel libraryTreePanel = LibraryBrowser.this.getSelectedTreePanel();
                        libraryTreePanel.setEditing(true);
                        LibraryBrowser.this.refreshGUI();
                    }
                }
            });
            tabLoader.execute();
        }
        return string2;
    }

    protected String getUniqueName(String string, String string2) {
        if (this.isDuplicateName(string = string.trim(), string2)) {
            int n = 2;
            String string3 = String.valueOf(string) + " (" + n + CLOSING;
            while (this.isDuplicateName(string3, string2)) {
                string3 = String.valueOf(string) + " (" + ++n + CLOSING;
            }
            return string3;
        }
        return string;
    }

    protected boolean isDuplicateName(String string, String string2) {
        for (String string3 : this.library.getNames()) {
            if (string3.equals(string2) || !string.equals(string3)) continue;
            return true;
        }
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            Object object = this.tabbedPane.getTitleAt(n);
            if (((String)object).endsWith("*")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (!((String)object).equals(string2) && string.equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected LibraryTreePanel createLibraryTreePanel() {
        LibraryTreePanel libraryTreePanel = new LibraryTreePanel(this);
        libraryTreePanel.addPropertyChangeListener(this.treePanelListener);
        return libraryTreePanel;
    }

    protected void showAboutDialog() {
        String string = String.valueOf(ToolsRes.getString("LibraryBrowser.Title")) + " 2.0,  Dec 2012\n" + "Open Source Physics Project\n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this, string, String.valueOf(ToolsRes.getString("Dialog.About.Title")) + " " + ToolsRes.getString("LibraryBrowser.Title"), 1);
    }

    protected void showHelp() {
        Object object;
        if (fireHelpEvent) {
            this.firePropertyChange("help", null, null);
            return;
        }
        String string = XML.getResolvedPath(LIBRARY_HELP_NAME, LIBRARY_HELP_BASE);
        if (ResourceLoader.getResource(string) == null) {
            object = "/org/opensourcephysics/resources/tools/html/";
            string = XML.getResolvedPath(LIBRARY_HELP_NAME, (String)object);
        }
        if (this.helpFrame == null || !string.equals(this.helpFrame.getTitle())) {
            this.helpFrame = new TextFrame(string);
            this.helpFrame.enableHyperlinks();
            this.helpFrame.setSize(760, 560);
            object = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (((Dimension)object).width - this.helpFrame.getBounds().width) / 2;
            int n2 = (((Dimension)object).height - this.helpFrame.getBounds().height) / 2;
            this.helpFrame.setLocation(n, n2);
        }
        this.helpFrame.setVisible(true);
    }

    protected String getAboutLibraryBrowserText() {
        String string = "org/opensourcephysics/resources/tools/images/compadre_banner.jpg";
        Resource resource = ResourceLoader.getResource(string);
        String string2 = "<p align=\"center\"><img src=\"" + resource.getURL() + "\"></p>";
        String string3 = String.valueOf(string2) + "<h1>Open Source Physics Digital Library Browser</h1>" + "<p>The OSP Digital Library Browser enables you to browse, organize and access collections of digital library resources " + "such as EJS models and Tracker experiments. Collections and resources may be on a local drive or remote server.</p>" + "<ul>" + "  <li>Open a collection by choosing from the <strong>Collections</strong> menu or entering a URL directly in the toolbar " + "as with a web browser.</li>" + "\t <li>Collections are organized and displayed in a tree. Each tree node is a resource or sub-collection. " + "Click a node to learn about the resource or double-click to download and/or open it in EJS or Tracker.</li>" + "\t <li>Build and organize your own local collection by clicking the <strong>Open Editor</strong> button. " + "Collections are stored as xml documents that contain references to the actual resource files. " + "For more information, see the Help menu.</li>" + "\t <li>Share your collections by uploading all files to the web or a local network. For more information, see the Help menu.</li>" + "</ul>" + "<h2>ComPADRE Digital Library</h2>" + "<p>The ComPADRE Pathway, a part of the National Science Digital Library, is a growing network of educational resource " + "collections supporting teachers and students in Physics and Astronomy. As a user you may explore collections designed to meet " + "your specific needs and help build the network by recommending resources, commenting on resources, and starting or joining " + "discussions. For more information, see &lt;<b><a href=\"http://www.compadre.org/OSP/\">http://www.compadre.org/OSP/</a></b>&gt;. " + "To recommend an OSP resource for ComPADRE, visit the Suggest a Resource page at &lt;<b><a href=" + "\"http://www.compadre.org/osp/items/suggest.cfm\">http://www.compadre.org/osp/items/suggest.cfm</a></b>&gt;.&nbsp; " + "Contact the OSP Collection editor, Wolfgang Christian, for additional information.</p>";
        return string3;
    }

    public static void main(String[] stringArray) {
        LibraryBrowser libraryBrowser = LibraryBrowser.getBrowser();
        libraryBrowser.addOSPLibrary(TRACKER_LIBRARY);
        libraryBrowser.addOSPLibrary(SHARED_LIBRARY);
        libraryBrowser.addComPADRECollection("http://www.compadre.org/osp/services/REST/osp_jars.cfm?verb=Identify&OSPType=EJS%20Model&AttachedDocument=Source%20Code&OSPPrimary=Subject");
        libraryBrowser.addComPADRECollection("http://www.compadre.org/osp/services/REST/osp_tracker.cfm?verb=Identify&OSPType=Tracker&OSPPrimary=Subject");
        libraryBrowser.refreshCollectionsMenu();
        libraryBrowser.exitOnClose = true;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - libraryBrowser.getBounds().width) / 2;
        int n2 = (dimension.height - libraryBrowser.getBounds().height) / 2;
        libraryBrowser.setLocation(n, n2);
        libraryBrowser.setVisible(true);
    }

    protected static boolean isWebConnected() {
        return webConnected;
    }

    protected static String getRedirectFromHTMLCode(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("<!--");
        if (stringArray.length > 1) {
            int n = 1;
            while (n < stringArray.length) {
                if (stringArray[n].trim().startsWith("redirect:")) {
                    String[] stringArray2 = stringArray[n].split("-->");
                    return stringArray2.length > 1 ? stringArray2[0].substring(9).trim() : null;
                }
                ++n;
            }
        }
        return null;
    }

    static class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.getName().startsWith("_")) {
                return false;
            }
            return file.isDirectory();
        }
    }

    static class FilesAndFoldersFilter
    extends javax.swing.filechooser.FileFilter {
        FilesAndFoldersFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file != null;
        }

        @Override
        public String getDescription() {
            return ToolsRes.getString("LibraryBrowser.FilesAndFoldersFilter.Description");
        }
    }

    static class HTMLFilter
    implements FileFilter {
        HTMLFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file == null || file.isDirectory()) {
                return false;
            }
            String string = file.getName();
            if (string.startsWith("_")) {
                return false;
            }
            String string2 = XML.getExtension(string);
            if (string2 == null) {
                return false;
            }
            return string2.toLowerCase().startsWith("htm");
        }
    }

    class LibraryLoader
    extends SwingWorker<Library, Object> {
        LibraryLoader() {
        }

        @Override
        public Library doInBackground() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    webConnected = ResourceLoader.isURLAvailable("http://www.opensourcephysics.org");
                    if (!webConnected) {
                        JOptionPane.showMessageDialog(LibraryBrowser.this, ToolsRes.getString("LibraryBrowser.Dialog.ServerUnavailable.Message"), ToolsRes.getString("LibraryBrowser.Dialog.ServerUnavailable.Title"), 2);
                    }
                }
            };
            if (!LibraryBrowser.this.libraryPath.startsWith("http:")) {
                LibraryBrowser.this.library.load(LibraryBrowser.this.libraryPath);
                if (LibraryBrowser.this.library.openTabPaths != null) {
                    TabLoader tabLoader;
                    Object object;
                    String string;
                    String[] stringArray;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String[] stringArray2 = stringArray = LibraryBrowser.this.library.openTabPaths;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        string = stringArray2[n2];
                        object = ResourceLoader.getSearchCacheFile(string);
                        if (((File)object).exists()) {
                            tabLoader = LibraryBrowser.this.addTab(string, null);
                            if (tabLoader != null) {
                                tabLoader.execute();
                            }
                        } else {
                            arrayList.add(string);
                        }
                        ++n2;
                    }
                    if (!arrayList.isEmpty()) {
                        stringArray = arrayList.toArray(new String[arrayList.size()]);
                        arrayList.clear();
                        stringArray2 = stringArray;
                        n = stringArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            string = stringArray2[n2];
                            object = ResourceLoader.getResource(string);
                            if (object != null && !string.startsWith("http:")) {
                                tabLoader = LibraryBrowser.this.addTab(string, null);
                                if (tabLoader != null) {
                                    tabLoader.execute();
                                }
                            } else {
                                arrayList.add(string);
                            }
                            ++n2;
                        }
                    }
                    boolean bl = arrayList.isEmpty();
                    LibraryBrowser.this.library.openTabPaths = bl ? null : arrayList.toArray(new String[arrayList.size()]);
                }
                runnable.run();
            } else {
                runnable.run();
                if (webConnected) {
                    LibraryBrowser.this.library.load(LibraryBrowser.this.libraryPath);
                }
            }
            return LibraryBrowser.this.library;
        }

        @Override
        protected void done() {
            try {
                Library library = (Library)this.get();
                if (library.openTabPaths != null) {
                    String[] stringArray = library.openTabPaths;
                    int n = library.openTabPaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TabLoader tabLoader;
                        boolean bl;
                        String string = stringArray[n2];
                        boolean bl2 = bl = LibraryBrowser.isWebConnected() && string.startsWith("http:");
                        if (bl && (tabLoader = LibraryBrowser.this.addTab(string, null)) != null) {
                            tabLoader.execute();
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {}
            LibraryBrowser.this.refreshCollectionsMenu();
            LibraryBrowser.this.refreshRecentMenu();
        }
    }

    class TabLoader
    extends SwingWorker<LibraryTreePanel, Object> {
        String path;
        int index;
        List<String> treePath;
        boolean saveToCache = true;

        TabLoader(String string, int n, List<String> list) {
            this.path = string;
            this.index = n;
            this.treePath = list;
        }

        @Override
        public LibraryTreePanel doInBackground() {
            LibraryResource libraryResource;
            LibraryBrowser.this.setCursor(Cursor.getPredefinedCursor(3));
            String string = this.path;
            File file = ResourceLoader.getSearchCacheFile(this.path);
            if (file.exists() && this.path.startsWith("http:")) {
                string = file.getAbsolutePath();
                this.saveToCache = false;
            }
            if ((libraryResource = LibraryBrowser.this.loadResource(string)) != null) {
                LibraryTreePanel libraryTreePanel = this.index < 0 ? LibraryBrowser.this.createLibraryTreePanel() : LibraryBrowser.this.getTreePanel(this.index);
                boolean bl = !this.path.startsWith("http:") && this.path.toLowerCase().endsWith(".xml");
                libraryTreePanel.setRootResource(libraryResource, this.path, bl, LibraryBrowser.this.isRecentPathXML);
                return libraryTreePanel;
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                LibraryTreePanel libraryTreePanel = (LibraryTreePanel)this.get();
                if (libraryTreePanel != null) {
                    libraryTreePanel.setFontLevel(FontSizer.getLevel());
                    if (this.index < 0) {
                        LibraryBrowser.this.tabbedPane.addTab("", libraryTreePanel);
                        this.index = LibraryBrowser.this.tabbedPane.getTabCount() - 1;
                    }
                    LibraryBrowser.this.refreshTabTitle(this.path, libraryTreePanel.rootResource);
                    LibraryBrowser.this.tabbedPane.setToolTipTextAt(this.index, this.path);
                    libraryTreePanel.setSelectionPath(this.treePath);
                    if (libraryTreePanel.metadataLoader != null) {
                        libraryTreePanel.metadataLoader.cancel();
                    }
                    LibraryTreePanel libraryTreePanel2 = libraryTreePanel;
                    libraryTreePanel2.getClass();
                    libraryTreePanel.metadataLoader = libraryTreePanel2.new LibraryTreePanel.MetadataLoader(this.saveToCache, this.treePath);
                    libraryTreePanel.metadataLoader.execute();
                    this.setProgress(this.index);
                } else {
                    String string = ToolsRes.getString("LibraryBrowser.Dialog.CollectionNotFound.Message");
                    JOptionPane.showMessageDialog(LibraryBrowser.this, String.valueOf(string) + ":\n" + this.path, ToolsRes.getString("LibraryBrowser.Dialog.CollectionNotFound.Title"), 2);
                    LibraryBrowser.this.library.removeRecent(this.path);
                    LibraryBrowser.this.refreshRecentMenu();
                    this.setProgress(-1);
                }
            }
            catch (Exception exception) {}
            LibraryBrowser.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    class TabTitle
    extends JPanel {
        JLabel titleLabel;
        JLabel iconLabel;
        Icon normalIcon;
        Icon boldIcon;
        Action action;

        TabTitle(Icon icon, Icon icon2) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.titleLabel = new JLabel();
            this.iconLabel = new JLabel();
            this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.iconLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = LibraryBrowser.this.getTabIndexFromTitle(TabTitle.this.titleLabel.getText());
                    if (n > -1 && ((TabTitle)TabTitle.this).LibraryBrowser.this.tabbedPane.getSelectedIndex() != n) {
                        ((TabTitle)TabTitle.this).LibraryBrowser.this.tabbedPane.setSelectedIndex(n);
                    }
                    TabTitle.this.action.actionPerformed(null);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    TabTitle.this.iconLabel.setIcon(TabTitle.this.boldIcon);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    TabTitle.this.iconLabel.setIcon(TabTitle.this.normalIcon);
                }
            });
            this.add((Component)this.titleLabel, "West");
            this.add((Component)this.iconLabel, "East");
            this.setIcons(icon, icon2);
        }

        void setTitle(String string) {
            this.titleLabel.setText(string);
        }

        void setIcons(Icon icon, Icon icon2) {
            this.normalIcon = icon;
            this.boldIcon = icon2;
            this.iconLabel.setIcon(this.normalIcon);
        }

        void setAction(Action action) {
            this.action = action;
        }
    }

    static class TrackerDLFilter
    implements FileFilter {
        static {
            String string = "org.opensourcephysics.media.xuggle.XuggleIO";
            try {
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getMethod("registerWithVideoIO", null);
                method.invoke(null, null);
            }
            catch (Exception exception) {}
        }

        TrackerDLFilter() {
        }

        @Override
        public boolean accept(File file) {
            Object object;
            if (file == null || file.isDirectory()) {
                return false;
            }
            String string = file.getName();
            if (string.startsWith("_")) {
                return false;
            }
            String string2 = XML.getExtension(string);
            if (string2 == null) {
                return false;
            }
            if ((string2 = string2.toLowerCase()).equals("trk")) {
                return true;
            }
            if (string2.indexOf("htm") > -1) {
                return true;
            }
            if (string2.equals("pdf")) {
                return true;
            }
            if (string2.equals("trz")) {
                return true;
            }
            String[] stringArray = VideoIO.getVideoExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray[n2];
                if (string2.equals(((String)object).toLowerCase())) {
                    return true;
                }
                ++n2;
            }
            if (string2.equals("zip")) {
                object = ResourceLoader.getZipContents(file.getAbsolutePath());
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (!string3.toLowerCase().endsWith(".trk")) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class XMLFilter
    implements FileFilter {
        XMLFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = XML.getExtension(file.getName());
            if (string == null) {
                return false;
            }
            return string.toLowerCase().equals("xml");
        }
    }
}

