/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class Library {
    protected String name;
    protected ArrayList<String> pathList = new ArrayList();
    protected HashMap<String, String> pathToNameMap = new HashMap();
    protected ArrayList<String> comPADREPathList = new ArrayList();
    protected HashMap<String, String> comPADREPathToNameMap = new HashMap();
    protected ArrayList<String> ospPathList = new ArrayList();
    protected HashMap<String, Library> ospPathToLibraryMap = new HashMap();
    protected ArrayList<String> importedPathList = new ArrayList();
    protected HashMap<String, Library> importedPathToLibraryMap = new HashMap();
    protected ArrayList<String> subPathList = new ArrayList();
    protected HashMap<String, Library> subPathToLibraryMap = new HashMap();
    protected HashMap<String, String> allPathsToNameMap = new HashMap();
    protected Set<String> noSearchSet = new TreeSet<String>();
    protected String[] openTabPaths;
    protected ArrayList<String> recentTabs = new ArrayList();
    protected int maxRecentTabCount = 6;
    protected String chooserDir;
    protected LibraryBrowser browser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOSPLibrary(String string) {
        if (this.ospPathList.contains(string)) {
            return false;
        }
        ArrayList<String> arrayList = this.ospPathList;
        synchronized (arrayList) {
            XMLControlElement xMLControlElement;
            block5: {
                xMLControlElement = new XMLControlElement(string);
                if (!xMLControlElement.failedToRead() && xMLControlElement.getObjectClass() == Library.class) break block5;
                return false;
            }
            Library library = new Library();
            xMLControlElement.loadObject(library);
            library.browser = this.browser;
            this.ospPathList.add(string);
            this.ospPathToLibraryMap.put(string, library);
        }
        return true;
    }

    public boolean importLibrary(String string) {
        if (this.importedPathList.contains(string)) {
            return false;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(string);
        if (xMLControlElement.failedToRead() || xMLControlElement.getObjectClass() != Library.class) {
            return false;
        }
        Library library = new Library();
        library.browser = this.browser;
        xMLControlElement.loadObject(library);
        return this.importLibrary(string, library);
    }

    public boolean addComPADRECollection(String string, String string2) {
        if (this.comPADREPathList.contains(string = string.trim())) {
            return false;
        }
        this.comPADREPathList.add(string);
        this.comPADREPathToNameMap.put(string, string2.trim());
        this.allPathsToNameMap.put(string, string2.trim());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubLibrary(String string) {
        if (this.subPathList.contains(string)) {
            return false;
        }
        ArrayList<String> arrayList = this.subPathList;
        synchronized (arrayList) {
            XMLControlElement xMLControlElement;
            block5: {
                xMLControlElement = new XMLControlElement(string);
                if (!xMLControlElement.failedToRead() && xMLControlElement.getObjectClass() == Library.class) break block5;
                return false;
            }
            Library library = new Library();
            library.browser = this.browser;
            xMLControlElement.loadObject(library);
            this.subPathList.add(string);
            this.subPathToLibraryMap.put(string, library);
        }
        return true;
    }

    public String toString() {
        return this.getName();
    }

    protected void setCache(String string) {
        File file = string == null ? ResourceLoader.getDefaultOSPCache() : new File(string);
        ResourceLoader.setOSPCache(file);
    }

    protected void setName(String string) {
        if (string == null) {
            string = System.getProperty("user.home").replace('\\', '/');
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            string = String.valueOf(XML.getName(string)) + " " + ToolsRes.getString("Library.Name");
        }
        this.name = string;
    }

    protected String getName() {
        return this.name;
    }

    protected void save(String string) {
        if (string == null) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        xMLControlElement.write(string);
    }

    protected void load(String string) {
        if (string == null) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(string);
        xMLControlElement.loadObject(this);
    }

    protected Collection<String> getNames() {
        return this.pathToNameMap.values();
    }

    protected boolean isEmpty() {
        return this.pathList.isEmpty();
    }

    protected boolean containsPath(String string, boolean bl) {
        int n = (string = string.trim()).indexOf("&OSPPrimary=Subject");
        if (n > -1) {
            string = string.substring(0, n);
        }
        boolean bl2 = this.pathList.contains(string);
        if (bl) {
            bl2 = bl2 || this.comPADREPathList.contains(string) || this.ospPathList.contains(string);
        }
        return bl2;
    }

    protected void addCollection(String string, String string2) {
        if (this.pathList.contains(string = string.trim())) {
            return;
        }
        this.pathList.add(string);
        this.pathToNameMap.put(string, string2.trim());
        this.allPathsToNameMap.put(string, string2.trim());
    }

    protected void renameCollection(String string, String string2) {
        if (!this.pathList.contains(string = string.trim())) {
            return;
        }
        this.pathToNameMap.put(string, string2.trim());
        this.allPathsToNameMap.put(string, string2.trim());
    }

    protected TreeSet<String> getAllPaths() {
        Library library;
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(this.pathList);
        treeSet.addAll(this.comPADREPathList);
        treeSet.addAll(this.ospPathList);
        if (!this.subPathList.isEmpty()) {
            for (String string : this.subPathList) {
                library = this.subPathToLibraryMap.get(string);
                treeSet.addAll(library.getAllPaths());
            }
        }
        for (String string : this.ospPathList) {
            library = this.ospPathToLibraryMap.get(string);
            treeSet.addAll(library.getAllPaths());
        }
        return treeSet;
    }

    protected HashMap<String, String> getNameMap() {
        return this.allPathsToNameMap;
    }

    protected Library getCloneForExport() {
        Library library = new Library();
        library.pathList = this.pathList;
        library.pathToNameMap = this.pathToNameMap;
        library.name = this.name;
        return library;
    }

    protected boolean importLibrary(String string, Library library) {
        if (this.importedPathList.contains(string)) {
            return false;
        }
        this.importedPathList.add(string);
        this.importedPathToLibraryMap.put(string, library);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRecent(String string, boolean bl) {
        if (string == null) {
            return;
        }
        ArrayList<String> arrayList = this.recentTabs;
        synchronized (arrayList) {
            while (this.recentTabs.contains(string)) {
                this.recentTabs.remove(string);
            }
            if (bl) {
                this.recentTabs.add(string);
            } else {
                this.recentTabs.add(0, string);
            }
            while (this.recentTabs.size() > this.maxRecentTabCount) {
                this.recentTabs.remove(this.recentTabs.size() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRecent(String string) {
        if (string == null) {
            return;
        }
        ArrayList<String> arrayList = this.recentTabs;
        synchronized (arrayList) {
            while (this.recentTabs.contains(string)) {
                this.recentTabs.remove(string);
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            int n;
            String[] stringArray;
            Object object2;
            Library library = (Library)object;
            xMLControl.setValue("name", library.getName());
            if (!library.pathList.isEmpty()) {
                object2 = library.pathList.toArray(new String[0]);
                xMLControl.setValue("collection_paths", object2);
                stringArray = new String[((String[])object2).length];
                n = 0;
                while (n < ((String[])object2).length) {
                    stringArray[n] = library.pathToNameMap.get(object2[n]);
                    ++n;
                }
                xMLControl.setValue("collection_names", stringArray);
            }
            if (!library.subPathList.isEmpty()) {
                object2 = library.subPathList.toArray(new String[0]);
                xMLControl.setValue("sublibrary_paths", object2);
            }
            if (!library.importedPathList.isEmpty()) {
                object2 = library.importedPathList.toArray(new String[0]);
                xMLControl.setValue("imported_library_paths", object2);
            }
            xMLControl.setValue("open_tabs", library.openTabPaths);
            xMLControl.setValue("chooser_directory", library.chooserDir);
            if (!library.recentTabs.isEmpty()) {
                object2 = library.recentTabs.toArray(new String[0]);
                xMLControl.setValue("recently_opened", object2);
                stringArray = new String[((Object)object2).length];
                n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = library.getNameMap().get(object2[n]);
                    if (stringArray[n] == null) {
                        stringArray[n] = XML.getName((String)object2[n]);
                    }
                    ++n;
                }
                xMLControl.setValue("recently_opened_names", stringArray);
            }
            if (!library.noSearchSet.isEmpty()) {
                object2 = library.noSearchSet.toArray(new String[0]);
                xMLControl.setValue("no_search_paths", object2);
            }
            if (ResourceLoader.getOSPCache() != null) {
                object2 = ResourceLoader.getOSPCache();
                xMLControl.setValue("cache", ((File)object2).getPath());
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new Library();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            String[] stringArray;
            int n;
            String[] stringArray2;
            int n2;
            Object object2;
            Library library = (Library)object;
            library.setName(xMLControl.getString("name"));
            String[] stringArray3 = (String[])xMLControl.getObject("collection_paths");
            if (stringArray3 != null) {
                object2 = (String[])xMLControl.getObject("collection_names");
                library.pathList.clear();
                library.pathToNameMap.clear();
                n2 = 0;
                while (n2 < stringArray3.length) {
                    if (stringArray3[n2] != null && object2[n2] != null) {
                        library.pathList.add(stringArray3[n2]);
                        library.pathToNameMap.put(stringArray3[n2], object2[n2]);
                        library.allPathsToNameMap.put(stringArray3[n2], object2[n2]);
                    }
                    ++n2;
                }
            }
            if ((stringArray3 = (String[])xMLControl.getObject("sublibrary_paths")) != null) {
                stringArray2 = stringArray3;
                n = stringArray3.length;
                n2 = 0;
                while (n2 < n) {
                    object2 = stringArray2[n2];
                    library.addSubLibrary((String)object2);
                    ++n2;
                }
            }
            if ((stringArray3 = (String[])xMLControl.getObject("imported_library_paths")) != null) {
                stringArray2 = stringArray3;
                n = stringArray3.length;
                n2 = 0;
                while (n2 < n) {
                    object2 = stringArray2[n2];
                    library.importLibrary((String)object2);
                    ++n2;
                }
            }
            stringArray3 = (String[])xMLControl.getObject("recently_opened");
            object2 = (String[])xMLControl.getObject("recently_opened_names");
            if (stringArray3 != null) {
                stringArray = stringArray3;
                int n3 = stringArray3.length;
                n = 0;
                while (n < n3) {
                    String string = stringArray[n];
                    library.addRecent(string, true);
                    ++n;
                }
                if (object2 != null) {
                    int n4 = 0;
                    while (n4 < ((String[])object2).length) {
                        library.getNameMap().put(stringArray3[n4], object2[n4]);
                        ++n4;
                    }
                }
            }
            if ((stringArray3 = (String[])xMLControl.getObject("no_search_paths")) != null) {
                stringArray = stringArray3;
                int n5 = stringArray3.length;
                n = 0;
                while (n < n5) {
                    String string = stringArray[n];
                    library.noSearchSet.add(string);
                    ++n;
                }
            }
            library.openTabPaths = (String[])xMLControl.getObject("open_tabs");
            library.chooserDir = xMLControl.getString("chooser_directory");
            if (ResourceLoader.getOSPCache() == null) {
                library.setCache(xMLControl.getString("cache"));
            }
            return object;
        }
    }
}

