/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

public class DataFunctionEditor
extends FunctionEditor {
    private DatasetManager data;
    static Color[] markerColors = new Color[]{Color.green.darker(), Color.red, Color.cyan.darker(), Color.yellow.darker(), Color.blue};

    public DataFunctionEditor(DatasetManager datasetManager) {
        this.data = datasetManager;
        for (Dataset dataset : datasetManager.getDatasets()) {
            if (!(dataset instanceof DataFunction)) continue;
            this.objects.add(dataset);
        }
    }

    public DatasetManager getData() {
        return this.data;
    }

    @Override
    public String getName(Object object) {
        return object == null ? null : ((DataFunction)object).getYColumnName();
    }

    @Override
    public String getExpression(Object object) {
        return object == null ? null : ((DataFunction)object).getInputString();
    }

    @Override
    public String getDescription(Object object) {
        return object == null ? null : ((DataFunction)object).getYColumnDescription();
    }

    @Override
    public void setDescription(Object object, String string) {
        if (object != null) {
            if (string != null && string.trim().equals("")) {
                string = null;
            }
            ((DataFunction)object).setYColumnDescription(string);
            super.setDescription(object, string);
        }
    }

    @Override
    public String getTooltip(Object object) {
        return object == null ? null : ((DataFunction)object).getYColumnDescription();
    }

    @Override
    public boolean isNameEditable(Object object) {
        return true;
    }

    @Override
    public boolean isExpressionEditable(Object object) {
        return true;
    }

    @Override
    public void evaluateAll() {
        super.evaluateAll();
        int n = 0;
        while (n < this.evaluate.size()) {
            DataFunction dataFunction = (DataFunction)this.evaluate.get(n);
            dataFunction.setExpression(dataFunction.getInputString());
            ++n;
        }
    }

    @Override
    public Object addObject(Object object, int n, boolean bl, boolean bl2) {
        if ((object = super.addObject(object, n, bl, bl2)) != null) {
            this.firePropertyChange("function", null, object);
        }
        return object;
    }

    @Override
    public Object removeObject(Object object, boolean bl) {
        if ((object = super.removeObject(object, bl)) != null) {
            this.firePropertyChange("function", object, null);
        }
        return object;
    }

    @Override
    protected void refreshGUI() {
        super.refreshGUI();
        Border border = this.getBorder();
        if (border != null && border instanceof TitledBorder) {
            ((TitledBorder)border).setTitle(ToolsRes.getString("DataFunctionEditor.Border.Title"));
        }
    }

    @Override
    protected boolean isDisallowedName(Object object, String string) {
        ArrayList<Dataset> arrayList = this.data.getDatasets();
        int n = 0;
        while (n < arrayList.size()) {
            Dataset dataset = arrayList.get(n);
            if (object != null && dataset == object && this.getName(object).equals(string)) {
                return false;
            }
            if (n == 0 && TeXParser.removeSubscripting(dataset.getXColumnName()).equals(string)) {
                return true;
            }
            if (TeXParser.removeSubscripting(dataset.getYColumnName()).equals(string)) {
                return true;
            }
            ++n;
        }
        return super.isDisallowedName(object, string);
    }

    @Override
    protected String getVariablesString(String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        int n = stringBuffer.length();
        boolean bl = true;
        if (this.paramEditor != null) {
            object = this.paramEditor.getParameters();
            int n2 = 0;
            while (n2 < ((Parameter[])object).length) {
                if (!bl) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(object[n2].getName());
                bl = false;
                ++n2;
            }
        }
        object = this.getName(this.getSelectedObject());
        ArrayList<Dataset> arrayList = this.data.getDatasets();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            String string2;
            Dataset dataset = arrayList.get(n3);
            if (n3 == 0) {
                string2 = dataset.getXColumnName();
                if (!bl) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(TeXParser.removeSubscripting(string2));
                bl = false;
            }
            if (!(string2 = dataset.getYColumnName()).equals(object)) {
                if (!bl) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(TeXParser.removeSubscripting(string2));
                bl = false;
            }
            ++n3;
        }
        if (stringBuffer.length() == n) {
            return ToolsRes.getString("FunctionPanel.Instructions.Help");
        }
        return String.valueOf(ToolsRes.getString("FunctionPanel.Instructions.ValueCell")) + string + stringBuffer.toString();
    }

    @Override
    protected boolean isInvalidExpression(Object object) {
        DataFunction dataFunction = (DataFunction)object;
        return !dataFunction.getInputString().equals(dataFunction.getExpression());
    }

    @Override
    protected Object createObject(String string, String string2, Object object) {
        DataFunction dataFunction = (DataFunction)object;
        if (dataFunction != null && dataFunction.getYColumnName().equals(string) && dataFunction.getInputString().equals(string2)) {
            return dataFunction;
        }
        if (dataFunction == null) {
            dataFunction = new DataFunction(this.data);
            int n = this.objects.size();
            if (n < markerColors.length) {
                dataFunction.setMarkerColor(markerColors[n], markerColors[n].darker());
                dataFunction.setLineColor(markerColors[n]);
            }
            dataFunction.setYColumnName(string);
            dataFunction.setExpression(string2);
        } else if (!dataFunction.getYColumnName().equals(string)) {
            dataFunction.setYColumnName(string);
        } else {
            dataFunction.setExpression(string2);
        }
        return dataFunction;
    }

    @Override
    protected void paste() {
        XMLControl[] xMLControlArray = this.getClipboardContents();
        if (xMLControlArray == null) {
            return;
        }
        int n = 0;
        while (n < xMLControlArray.length) {
            DataFunction dataFunction = new DataFunction(this.data);
            Object object = xMLControlArray[n].loadObject(dataFunction);
            this.addObject(object, true);
            ++n;
        }
        this.evaluateAll();
    }
}

