/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.tools.DataTool;

public class DataColumn
extends Dataset {
    boolean deletable = false;
    double shift;
    boolean shifted = false;

    public DataColumn() {
        super.setXColumnVisible(false);
        super.setXYColumnNames("row", this.getYColumnName());
    }

    public void setPoints(double[] dArray) {
        this.clear();
        double[] dArray2 = DataTool.getRowArray(dArray.length);
        this.append(dArray2, dArray);
    }

    @Override
    public void setXYColumnNames(String string, String string2) {
        super.setXYColumnNames("row", string2);
    }

    @Override
    public void setXYColumnNames(String string, String string2, String string3) {
        super.setXYColumnNames("row", string2, string3);
    }

    @Override
    public void setXColumnVisible(boolean bl) {
    }

    @Override
    public double[] getYPoints() {
        double[] dArray = new double[this.index];
        int n = 0;
        while (n < this.index) {
            dArray[n] = this.isShifted() ? this.ypoints[n] + this.shift : this.ypoints[n];
            ++n;
        }
        return dArray;
    }

    public void setShifted(boolean bl) {
        this.shifted = bl;
    }

    public boolean isShifted() {
        return this.shifted;
    }

    public boolean setShift(double d) {
        if (this.shift == d) {
            return false;
        }
        this.shift = d;
        return true;
    }

    public double getShift() {
        return this.shift;
    }

    public boolean setShiftedValue(int n, double d) {
        if (n < 0 || n >= this.getIndex()) {
            return false;
        }
        double d2 = d - this.ypoints[n];
        if (!Double.isNaN(d2)) {
            return this.setShift(d2);
        }
        return false;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            DataColumn dataColumn = (DataColumn)object;
            double d = dataColumn.getShift();
            if (d != 0.0) {
                xMLControl.setValue("shift", d);
                dataColumn.shift = 0.0;
            }
            Dataset.getLoader().saveObject(xMLControl, dataColumn);
            dataColumn.shift = d;
            if (dataColumn.deletable) {
                xMLControl.setValue("deletable", true);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new DataColumn();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            DataColumn dataColumn = (DataColumn)object;
            Dataset.getLoader().loadObject(xMLControl, dataColumn);
            if (xMLControl.getPropertyNames().contains("shift")) {
                dataColumn.shift = xMLControl.getDouble("shift");
            }
            dataColumn.deletable = xMLControl.getBoolean("deletable");
            return object;
        }
    }
}

