/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CheckTreeSelectionModel
extends DefaultTreeSelectionModel {
    private TreeModel model;
    private PropertyChangeSupport support;

    public CheckTreeSelectionModel(TreeModel treeModel) {
        this.model = treeModel;
        this.setSelectionMode(4);
        this.support = new SwingPropertyChangeSupport(this);
    }

    public boolean isPathUnselected(TreePath treePath) {
        if (this.isSelectionEmpty()) {
            return true;
        }
        if (this.isPathOrAncestorSelected(treePath)) {
            return false;
        }
        TreePath[] treePathArray = this.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            if (treePath.isDescendant(treePathArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isPathOrAncestorSelected(TreePath treePath) {
        while (treePath != null && !this.isPathSelected(treePath)) {
            treePath = treePath.getParentPath();
        }
        return treePath != null;
    }

    @Override
    public void setSelectionPaths(TreePath[] treePathArray) {
        super.clearSelection();
        this.addSelectionPaths(treePathArray);
    }

    @Override
    public void addSelectionPaths(TreePath[] treePathArray) {
        Object object;
        TreePath treePath;
        if (treePathArray == null) {
            return;
        }
        TreePath[] treePathArray2 = this.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            if (this.isSelectionEmpty()) break;
            treePath = treePathArray[n];
            object = this.getSelectionPaths();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n2 = 0;
            while (n2 < ((TreePath[])object).length) {
                if (treePath.isDescendant((TreePath)object[n2])) {
                    arrayList.add(object[n2]);
                }
                ++n2;
            }
            super.removeSelectionPaths(arrayList.toArray(new TreePath[0]));
            ++n;
        }
        n = 0;
        while (n < treePathArray.length) {
            treePath = treePathArray[n];
            object = null;
            while (this.isSiblingsSelected(treePath)) {
                object = treePath;
                if (treePath.getParentPath() == null) break;
                treePath = treePath.getParentPath();
            }
            if (object != null) {
                if (((TreePath)object).getParentPath() != null) {
                    this.addSelectionPath(((TreePath)object).getParentPath());
                } else {
                    if (!this.isSelectionEmpty()) {
                        this.removeSelectionPaths(this.getSelectionPaths());
                    }
                    super.addSelectionPaths(new TreePath[]{object});
                }
            } else {
                super.addSelectionPaths(new TreePath[]{treePath});
            }
            ++n;
        }
        this.support.firePropertyChange("treepaths", treePathArray2, this.getSelectionPaths());
    }

    @Override
    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (this.isSelectionEmpty()) {
            return;
        }
        TreePath[] treePathArray2 = this.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            TreePath treePath = treePathArray[n];
            if (treePath.getPathCount() == 1) {
                super.removeSelectionPaths(new TreePath[]{treePath});
            } else if (this.isPathSelected(treePath)) {
                super.removeSelectionPaths(new TreePath[]{treePath});
            } else {
                this.unselectAncestor(treePath);
            }
            ++n;
        }
        this.support.firePropertyChange("treepaths", treePathArray2, this.getSelectionPaths());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private boolean isSiblingsSelected(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return true;
        }
        Object object = treePath.getLastPathComponent();
        Object object2 = treePath2.getLastPathComponent();
        int n = this.model.getChildCount(object2);
        int n2 = 0;
        while (n2 < n) {
            Object object3 = this.model.getChild(object2, n2);
            if (!object3.equals(object) && !this.isPathSelected(treePath2.pathByAddingChild(object3))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void unselectAncestor(TreePath treePath) {
        Stack<TreePath> stack = new Stack<TreePath>();
        stack.push(treePath);
        TreePath treePath2 = treePath.getParentPath();
        while (treePath2 != null && !this.isPathSelected(treePath2)) {
            stack.push(treePath2);
            treePath2 = treePath2.getParentPath();
        }
        if (treePath2 == null) {
            return;
        }
        stack.push(treePath2);
        while (!stack.isEmpty()) {
            TreePath treePath3 = (TreePath)stack.pop();
            super.removeSelectionPaths(new TreePath[]{treePath3});
            if (stack.isEmpty()) {
                return;
            }
            Object object = treePath3.getLastPathComponent();
            int n = this.model.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.model.getChild(object, n2);
                super.addSelectionPaths(new TreePath[]{treePath3.pathByAddingChild(object2)});
                ++n2;
            }
        }
    }
}

