/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public class LUPDecomposition {
    private double[][] rows;
    private int[] permutation = null;
    private int parity = 1;

    public LUPDecomposition(double[][] dArray) throws IllegalArgumentException {
        int n = dArray.length;
        if (dArray[0].length != n) {
            throw new IllegalArgumentException("Illegal system: a" + n + " by " + dArray[0].length + " matrix is not a square matrix");
        }
        this.initialize(dArray);
    }

    private double[] backwardSubstitution(double[] dArray) {
        int n = this.rows.length;
        double[] dArray2 = new double[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            dArray2[n2] = dArray[n2];
            int n3 = n2 + 1;
            while (n3 < n) {
                int n4 = n2;
                dArray2[n4] = dArray2[n4] - this.rows[n2][n3] * dArray2[n3];
                ++n3;
            }
            int n5 = n2;
            dArray2[n5] = dArray2[n5] / this.rows[n2][n2];
            --n2;
        }
        return dArray2;
    }

    private void decompose() {
        int n = this.rows.length;
        this.permutation = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.permutation[n2] = n2;
            ++n2;
        }
        this.parity = 1;
        try {
            n2 = 0;
            while (n2 < n) {
                this.swapRows(n2, this.largestPivot(n2));
                this.pivot(n2);
                ++n2;
            }
        }
        catch (ArithmeticException arithmeticException) {
            this.parity = 0;
        }
    }

    private boolean decomposed() {
        if (this.parity == 1 && this.permutation == null) {
            this.decompose();
        }
        return this.parity != 0;
    }

    public double determinant() {
        if (!this.decomposed()) {
            return Double.NaN;
        }
        double d = this.parity;
        int n = 0;
        while (n < this.rows.length) {
            d *= this.rows[n][n];
            ++n;
        }
        return d;
    }

    private double[] forwardSubstitution(double[] dArray) {
        int n = this.rows.length;
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = dArray[this.permutation[n2]];
            int n3 = 0;
            while (n3 <= n2 - 1) {
                int n4 = n2;
                dArray2[n4] = dArray2[n4] - this.rows[n2][n3] * dArray2[n3];
                ++n3;
            }
            ++n2;
        }
        return dArray2;
    }

    private void initialize(double[][] dArray) {
        int n = dArray.length;
        this.rows = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            System.arraycopy(dArray[n2], 0, this.rows[n2], 0, n);
            ++n2;
        }
        this.permutation = null;
        this.parity = 1;
    }

    public double[][] inverseMatrixComponents() {
        if (!this.decomposed()) {
            return null;
        }
        int n = this.rows.length;
        double[][] dArray = new double[n][n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                dArray2[n3] = 0.0;
                ++n3;
            }
            dArray2[n2] = 1.0;
            dArray2 = this.solve(dArray2);
            n3 = 0;
            while (n3 < n) {
                if (Double.isNaN(dArray2[n3])) {
                    return null;
                }
                dArray[n3][n2] = dArray2[n3];
                ++n3;
            }
            ++n2;
        }
        return dArray;
    }

    public static void symmetrizeComponents(double[][] dArray) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n + 1;
            while (n2 < dArray.length) {
                double[] dArray2 = dArray[n];
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + dArray[n2][n];
                double[] dArray3 = dArray[n];
                int n4 = n2;
                dArray3[n4] = dArray3[n4] * 0.5;
                dArray[n2][n] = dArray[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    private int largestPivot(int n) {
        double d = Math.abs(this.rows[n][n]);
        int n2 = n;
        int n3 = n + 1;
        while (n3 < this.rows.length) {
            double d2 = Math.abs(this.rows[n3][n]);
            if (d2 > d) {
                d = d2;
                n2 = n3;
            }
            ++n3;
        }
        return n2;
    }

    private void pivot(int n) {
        double d = 1.0 / this.rows[n][n];
        int n2 = n + 1;
        int n3 = this.rows.length;
        int n4 = n2;
        while (n4 < n3) {
            double[] dArray = this.rows[n4];
            int n5 = n;
            dArray[n5] = dArray[n5] * d;
            int n6 = n2;
            while (n6 < n3) {
                double[] dArray2 = this.rows[n4];
                int n7 = n6;
                dArray2[n7] = dArray2[n7] - this.rows[n4][n] * this.rows[n][n6];
                ++n6;
            }
            ++n4;
        }
    }

    public double[] solve(double[] dArray) {
        return this.decomposed() ? this.backwardSubstitution(this.forwardSubstitution(dArray)) : null;
    }

    private void swapRows(int n, int n2) {
        if (n != n2) {
            int n3 = 0;
            while (n3 < this.rows.length) {
                double d = this.rows[n][n3];
                this.rows[n][n3] = this.rows[n2][n3];
                this.rows[n2][n3] = d;
                ++n3;
            }
            n3 = this.permutation[n];
            this.permutation[n] = this.permutation[n2];
            this.permutation[n2] = n3;
            this.parity = -this.parity;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'[', ' '};
        int n = this.rows.length;
        int n2 = 0;
        while (n2 < n) {
            cArray[0] = 123;
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append(cArray);
                stringBuffer.append(this.rows[n2][n3]);
                cArray[0] = 32;
                ++n3;
            }
            stringBuffer.append('}');
            stringBuffer.append('\n');
            ++n2;
        }
        if (this.permutation != null) {
            stringBuffer.append(this.parity == 1 ? (char)'+' : '-');
            stringBuffer.append("( " + this.permutation[0]);
            n2 = 1;
            while (n2 < n) {
                stringBuffer.append(", " + this.permutation[n2]);
                ++n2;
            }
            stringBuffer.append(')');
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

