/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.xuggle;

import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.MediaToolAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.ResourceLoader;

public class XuggleThumbnailTool
extends MediaToolAdapter {
    private static final XuggleThumbnailTool THUMBNAIL_TOOL = new XuggleThumbnailTool();
    private static final int TARGET_FRAME_NUMBER = 15;
    private BufferedImage thumbnail;
    private Graphics2D g;
    private boolean finished;
    private int frameNumber;
    private BufferedImage overlay;
    private Dimension dim;

    public static void start() {
    }

    public static synchronized BufferedImage createThumbnailImage(Dimension dimension, String string) {
        THUMBNAIL_TOOL.initialize(dimension);
        String string2 = string.startsWith("http:") ? ResourceLoader.getURIPath(string) : string;
        IMediaReader iMediaReader = ToolFactory.makeReader(string2);
        iMediaReader.setBufferedImageTypeToGenerate(5);
        iMediaReader.addListener(THUMBNAIL_TOOL);
        while (!THUMBNAIL_TOOL.isFinished() && iMediaReader.readPacket() == null) {
        }
        iMediaReader.close();
        return XuggleThumbnailTool.THUMBNAIL_TOOL.thumbnail;
    }

    public static synchronized File createThumbnailFile(Dimension dimension, String string, String string2) {
        BufferedImage bufferedImage = XuggleThumbnailTool.createThumbnailImage(dimension, string);
        return VideoIO.writeImageFile(bufferedImage, string2);
    }

    @Override
    public void onVideoPicture(IVideoPictureEvent iVideoPictureEvent) {
        if (!this.isFinished()) {
            BufferedImage bufferedImage = iVideoPictureEvent.getImage();
            double d = this.dim.getWidth() / (double)bufferedImage.getWidth();
            double d2 = this.dim.getHeight() / (double)bufferedImage.getHeight();
            double d3 = Math.min(d, d2);
            int n = (int)((double)bufferedImage.getWidth() * d3);
            int n2 = (int)((double)bufferedImage.getHeight() * d3);
            this.thumbnail = new BufferedImage(n, n2, 5);
            this.g = this.thumbnail.createGraphics();
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d3, d3);
            this.g.setTransform(affineTransform);
            this.g.drawImage((Image)bufferedImage, 0, 0, null);
            if (this.overlay != null) {
                this.g.scale(1.0 / d3, 1.0 / d3);
                Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.overlay.getWidth(), this.overlay.getHeight());
                double d4 = ((RectangularShape)float_).getHeight();
                this.g.translate(0.5 * d4, (double)this.thumbnail.getHeight() - 1.5 * d4);
                this.g.setComposite(AlphaComposite.getInstance(3, 0.2f));
                this.g.drawImage((Image)this.overlay, 0, 0, null);
            }
            ++this.frameNumber;
            this.finished = this.frameNumber >= 15;
        }
        super.onVideoPicture(iVideoPictureEvent);
    }

    private void initialize(Dimension dimension) {
        this.dim = dimension;
        this.finished = false;
        this.frameNumber = 0;
    }

    private boolean isFinished() {
        return this.finished;
    }
}

