/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.quicktime;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.media.core.ScratchVideoRecorder;
import org.opensourcephysics.media.quicktime.QT;
import org.opensourcephysics.media.quicktime.QTVideoType;
import quicktime.QTException;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.std.StdQTConstants;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.image.ImageDescription;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.SampleDescription;
import quicktime.std.movies.media.VideoMedia;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;

public class QTVideoRecorder
extends ScratchVideoRecorder
implements StdQTConstants {
    private Movie movie;
    private Track videoTrack;
    private VideoMedia videoMedia;
    private boolean editing;

    public QTVideoRecorder(QTVideoType qTVideoType) {
        super(qTVideoType);
        QT.start();
    }

    @Override
    protected void saveScratch() throws IOException {
        if (this.movie != null && this.editing) {
            try {
                this.videoMedia.endEdits();
                int n = 0;
                int n2 = 0;
                boolean bl = true;
                this.videoTrack.insertMedia(n, n2, this.videoMedia.getDuration(), (float)bl);
                this.editing = false;
                OpenMovieFile openMovieFile = OpenMovieFile.asWrite((QTFile)new QTFile(this.scratchFile));
                this.movie.addResource(openMovieFile, -1, this.scratchFile.getName());
                openMovieFile.close();
                this.movie = null;
                OSPLog.finest("saved " + this.frameCount + " frames in " + this.scratchFile);
            }
            catch (QTException qTException) {
                throw new IOException("caught in saveScratch: " + qTException.toString());
            }
        }
    }

    @Override
    protected boolean startRecording() {
        if (this.dim == null) {
            if (this.frameImage != null) {
                this.dim = new Dimension(this.frameImage.getWidth(null), this.frameImage.getHeight(null));
            } else {
                return false;
            }
        }
        try {
            this.createMovie();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    protected boolean append(Image image) {
        Object object;
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            bufferedImage = new BufferedImage(this.dim.width, this.dim.height, 1);
            object = bufferedImage.createGraphics();
            ((Graphics)object).drawImage(image, 0, 0, null);
        }
        object = new ByteArrayOutputStream();
        try {
            if (!this.editing) {
                this.videoMedia.beginEdits();
                this.editing = true;
            }
            ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)object);
            QTHandle qTHandle = new QTHandle(((ByteArrayOutputStream)object).toByteArray());
            DataRef dataRef = new DataRef((QTHandleRef)qTHandle, 1702392864, "png");
            GraphicsImporter graphicsImporter = new GraphicsImporter(dataRef);
            ImageDescription imageDescription = graphicsImporter.getImageDescription();
            int n = (int)(this.frameDuration * 0.6);
            this.videoMedia.addSample((QTHandleRef)qTHandle, 0, qTHandle.getSize(), n, (SampleDescription)imageDescription, 1, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private void createMovie() throws IOException {
        try {
            this.movie = Movie.createMovieFile((QTFile)new QTFile(this.scratchFile), (int)1414942532, (int)-1879048192);
            int n = 600;
            boolean bl = false;
            this.videoTrack = this.movie.newTrack((float)this.dim.width, (float)this.dim.height, (float)bl);
            this.videoMedia = new VideoMedia(this.videoTrack, n);
            this.editing = false;
        }
        catch (QTException qTException) {
            throw new IOException("caught in createMovie: " + qTException.toString());
        }
    }
}

