/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPanel;

public class VideoFrame
extends DrawingFrame {
    protected Action openAction;
    protected Action saveAction;
    protected Action openVideoAction;
    protected JMenuItem openItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem saveItem;
    protected JMenuItem openVideoItem;
    protected JMenuItem exitItem;

    public VideoFrame(VideoPanel videoPanel) {
        this(MediaRes.getString("VideoFrame.Title"), videoPanel);
    }

    public VideoFrame(String string, VideoPanel videoPanel) {
        super(string, videoPanel);
        if (!OSPRuntime.appletMode) {
            this.createActions();
            this.modifyMenuBar();
        }
    }

    protected void modifyMenuBar() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.openItem = this.fileMenu.insert(this.openAction, 0);
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.saveAsItem = new JMenuItem(MediaRes.getString("VideoFrame.MenuItem.SaveAs"));
        this.fileMenu.insert(this.saveAsItem, 1);
        this.saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoIO.save(null, (VideoPanel)VideoFrame.this.drawingPanel);
            }
        });
        this.saveItem = this.fileMenu.insert(this.saveAction, 2);
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, n));
        this.fileMenu.insertSeparator(5);
        this.fileMenu.addSeparator();
        this.exitItem = new JMenuItem(MediaRes.getString("VideoFrame.MenuItem.Exit"));
        this.fileMenu.add(this.exitItem);
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.setJMenuBar(this.getJMenuBar());
    }

    protected void createActions() {
        this.openAction = new AbstractAction(MediaRes.getString("VideoFrame.MenuItem.Open"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoIO.open(null, (VideoPanel)VideoFrame.this.drawingPanel);
            }
        };
        this.saveAction = new AbstractAction(MediaRes.getString("VideoFrame.MenuItem.Save"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoPanel videoPanel = (VideoPanel)VideoFrame.this.drawingPanel;
                VideoIO.save(videoPanel.getDataFile(), videoPanel);
            }
        };
    }
}

