/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;

public class ResizeFilter
extends Filter {
    private double widthFactor = 1.0;
    private double heightFactor = 1.0;
    private int wIn;
    private int hIn;
    private BufferedImage input;
    private BufferedImage output;
    private BufferedImage source;
    private Graphics2D gIn;
    private Graphics2D gOut;
    private Inspector inspector;
    private JLabel widthLabel;
    private JLabel heightLabel;
    private JLabel inputLabel;
    private JLabel outputLabel;
    private IntegerField widthInField;
    private IntegerField heightInField;
    private IntegerField widthOutField;
    private IntegerField heightOutField;

    public ResizeFilter() {
        this.hasInspector = true;
    }

    public void setWidthFactor(double d) {
        this.source = null;
        Double d2 = new Double(this.widthFactor);
        this.widthFactor = Math.min(Math.abs(d), 10.0);
        this.widthFactor = Math.max(this.widthFactor, 0.01);
        this.support.firePropertyChange("width", d2, new Double(this.widthFactor));
    }

    public void setHeightFactor(double d) {
        this.source = null;
        Double d2 = new Double(this.heightFactor);
        this.heightFactor = Math.min(Math.abs(d), 10.0);
        this.heightFactor = Math.max(this.heightFactor, 0.01);
        this.support.firePropertyChange("height", d2, new Double(this.heightFactor));
    }

    public double getWidthFactor() {
        return this.widthFactor;
    }

    public double getHeightFactor() {
        return this.heightFactor;
    }

    @Override
    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.gOut.drawImage((Image)this.input, 0, 0, null);
        return this.output;
    }

    @Override
    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                this.inspector.setVisible(false);
            }
            this.inspector = new Inspector();
        }
        this.inspector.initialize();
        return this.inspector;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.widthLabel.setText(MediaRes.getString("Filter.Resize.Label.Width"));
        this.heightLabel.setText(MediaRes.getString("Filter.Resize.Label.Height"));
        this.inputLabel.setText(MediaRes.getString("Filter.Resize.Label.Input"));
        this.outputLabel.setText(MediaRes.getString("Filter.Resize.Label.Output"));
        if (this.inspector != null) {
            this.inspector.setTitle(MediaRes.getString("Filter.Resize.Title"));
            this.inspector.pack();
        }
        boolean bl = this.isEnabled();
        this.inputLabel.setEnabled(bl);
        this.outputLabel.setEnabled(bl);
        this.heightLabel.setEnabled(bl);
        this.widthLabel.setEnabled(bl);
        this.widthInField.setEnabled(bl);
        this.heightInField.setEnabled(bl);
        this.widthOutField.setEnabled(bl);
        this.heightOutField.setEnabled(bl);
        int n = (int)((double)this.wIn * this.widthFactor);
        int n2 = (int)((double)this.hIn * this.heightFactor);
        this.widthInField.setIntValue(this.wIn);
        this.widthOutField.setIntValue(n);
        this.heightInField.setIntValue(this.hIn);
        this.heightOutField.setIntValue(n2);
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.wIn = this.source.getWidth();
        this.hIn = this.source.getHeight();
        if (this.wIn == 720 && this.hIn == 480 && this.widthFactor == 1.0 && this.heightFactor == 1.0) {
            this.widthFactor = 0.889;
        }
        int n = (int)((double)this.wIn * this.widthFactor);
        int n2 = (int)((double)this.hIn * this.heightFactor);
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.wIn, this.hIn, 1);
            this.gIn = this.input.createGraphics();
        }
        this.output = new BufferedImage(n, n2, 1);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.widthFactor, this.heightFactor);
        this.gOut = this.output.createGraphics();
        this.gOut.setTransform(affineTransform);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private class Inspector
    extends JDialog {
        public Inspector() {
            super(ResizeFilter.this.frame, !(ResizeFilter.this.frame instanceof OSPFrame));
            this.setTitle(MediaRes.getString("Filter.Resize.Title"));
            this.setResizable(false);
            this.createGUI();
            ResizeFilter.this.refresh();
            this.pack();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            this.setLocation(n, n2);
        }

        void createGUI() {
            ResizeFilter.this.inputLabel = new JLabel();
            ResizeFilter.this.outputLabel = new JLabel();
            ResizeFilter.this.widthLabel = new JLabel();
            ResizeFilter.this.widthInField = new IntegerField(4);
            ResizeFilter.this.widthInField.setEditable(false);
            ((ResizeFilter)ResizeFilter.this).widthInField.format.applyPattern("0");
            ResizeFilter.this.widthOutField = new IntegerField(4);
            ((ResizeFilter)ResizeFilter.this).widthOutField.format.applyPattern("0");
            ResizeFilter.this.widthOutField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResizeFilter.this.setWidthFactor(1.0 * (double)ResizeFilter.this.widthOutField.getIntValue() / (double)ResizeFilter.this.wIn);
                    ResizeFilter.this.refresh();
                    ResizeFilter.this.widthOutField.selectAll();
                }
            });
            ResizeFilter.this.widthOutField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    ResizeFilter.this.widthOutField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    ResizeFilter.this.setWidthFactor(1.0 * (double)ResizeFilter.this.widthOutField.getIntValue() / (double)ResizeFilter.this.wIn);
                    ResizeFilter.this.refresh();
                }
            });
            ResizeFilter.this.heightLabel = new JLabel();
            ResizeFilter.this.heightInField = new IntegerField(4);
            ResizeFilter.this.heightInField.setEditable(false);
            ((ResizeFilter)ResizeFilter.this).heightInField.format.applyPattern("0");
            ResizeFilter.this.heightOutField = new IntegerField(4);
            ((ResizeFilter)ResizeFilter.this).heightOutField.format.applyPattern("0");
            ResizeFilter.this.heightOutField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResizeFilter.this.setHeightFactor(1.0 * (double)ResizeFilter.this.heightOutField.getIntValue() / (double)ResizeFilter.this.hIn);
                    ResizeFilter.this.refresh();
                    ResizeFilter.this.heightOutField.selectAll();
                }
            });
            ResizeFilter.this.heightOutField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    ResizeFilter.this.heightOutField.selectAll();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    ResizeFilter.this.setHeightFactor(1.0 * (double)ResizeFilter.this.heightOutField.getIntValue() / (double)ResizeFilter.this.hIn);
                    ResizeFilter.this.refresh();
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            this.setContentPane(jPanel);
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel2 = new JPanel(gridBagLayout);
            jPanel.add((Component)jPanel2, "Center");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(4, 2, 0, 2);
            gridBagLayout.setConstraints(ResizeFilter.this.widthLabel, gridBagConstraints);
            jPanel2.add(ResizeFilter.this.widthLabel);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(4, 0, 0, 8);
            gridBagLayout.setConstraints(ResizeFilter.this.heightLabel, gridBagConstraints);
            jPanel2.add(ResizeFilter.this.heightLabel);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 4, 0, 2);
            gridBagConstraints.weightx = 0.2;
            gridBagLayout.setConstraints(ResizeFilter.this.inputLabel, gridBagConstraints);
            jPanel2.add(ResizeFilter.this.inputLabel);
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(ResizeFilter.this.outputLabel, gridBagConstraints);
            jPanel2.add(ResizeFilter.this.outputLabel);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(4, 2, 0, 2);
            gridBagLayout.setConstraints(ResizeFilter.this.widthInField, gridBagConstraints);
            jPanel2.add(ResizeFilter.this.widthInField);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(4, 0, 0, 8);
            gridBagLayout.setConstraints(ResizeFilter.this.heightInField, gridBagConstraints);
            jPanel2.add(ResizeFilter.this.heightInField);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(4, 2, 0, 2);
            gridBagLayout.setConstraints(ResizeFilter.this.widthOutField, gridBagConstraints);
            jPanel2.add(ResizeFilter.this.widthOutField);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(4, 0, 0, 8);
            gridBagLayout.setConstraints(ResizeFilter.this.heightOutField, gridBagConstraints);
            jPanel2.add(ResizeFilter.this.heightOutField);
            JPanel jPanel3 = new JPanel(new FlowLayout());
            jPanel3.add(ResizeFilter.this.ableButton);
            jPanel3.add(ResizeFilter.this.closeButton);
            jPanel.add((Component)jPanel3, "South");
        }

        void initialize() {
            ResizeFilter.this.refresh();
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            ResizeFilter resizeFilter = (ResizeFilter)object;
            xMLControl.setValue("width_factor", resizeFilter.widthFactor);
            xMLControl.setValue("height_factor", resizeFilter.heightFactor);
            if (resizeFilter.frame != null && resizeFilter.inspector != null && resizeFilter.inspector.isVisible()) {
                int n = ((ResizeFilter)resizeFilter).inspector.getLocation().x - resizeFilter.frame.getLocation().x;
                int n2 = ((ResizeFilter)resizeFilter).inspector.getLocation().y - resizeFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new ResizeFilter();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            ResizeFilter resizeFilter = (ResizeFilter)object;
            if (xMLControl.getPropertyNames().contains("width_factor")) {
                resizeFilter.setWidthFactor(xMLControl.getDouble("width_factor"));
            }
            if (xMLControl.getPropertyNames().contains("height_factor")) {
                resizeFilter.setHeightFactor(xMLControl.getDouble("height_factor"));
            }
            resizeFilter.inspectorX = xMLControl.getInt("inspector_x");
            resizeFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }
}

