/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideoRecorder;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ImageVideo
extends VideoAdapter {
    protected Component observer = new JPanel();
    protected BufferedImage[] images = new BufferedImage[0];
    protected String[] paths = new String[0];
    protected boolean readOnly = false;
    protected double deltaT = 100.0;

    public ImageVideo(String string) throws IOException {
        this.readOnly = true;
        this.append(string);
    }

    public ImageVideo(String string, boolean bl) throws IOException {
        this(string, bl, true);
    }

    public ImageVideo(String string, boolean bl, boolean bl2) throws IOException {
        this.readOnly = bl2;
        this.append(string, bl);
    }

    public ImageVideo(Image image) {
        if (image != null) {
            this.insert(new Image[]{image}, 0, null);
        }
    }

    public ImageVideo(Image[] imageArray) {
        if (imageArray != null && imageArray.length > 0 && imageArray[0] != null) {
            this.insert(imageArray, 0, null);
        }
    }

    @Override
    public void setFrameNumber(int n) {
        super.setFrameNumber(n);
        this.rawImage = this.getImageAtFrame(this.getFrameNumber(), this.rawImage);
        this.isValidImage = false;
        this.isValidFilteredImage = false;
        this.firePropertyChange("framenumber", null, new Integer(this.getFrameNumber()));
    }

    @Override
    public double getTime() {
        return (double)this.getFrameNumber() * this.deltaT;
    }

    public void setFrameDuration(double d) {
        this.deltaT = d;
    }

    @Override
    public void setTime(double d) {
        int n = (int)(d / this.deltaT);
        n = Math.max(n, 0);
        n = Math.min(n, this.getFrameCount() - 1);
        this.setFrameNumber(n);
    }

    @Override
    public double getStartTime() {
        return 0.0;
    }

    @Override
    public void setStartTime(double d) {
    }

    @Override
    public double getEndTime() {
        return this.getDuration();
    }

    @Override
    public void setEndTime(double d) {
    }

    @Override
    public double getDuration() {
        return (double)this.length() * this.deltaT;
    }

    @Override
    public double getFrameTime(int n) {
        return (double)n * this.deltaT;
    }

    public Image[] getImages() {
        return this.images;
    }

    public void append(String string) throws IOException {
        this.insert(string, this.length());
    }

    public void append(String string, boolean bl) throws IOException {
        this.insert(string, this.length(), bl);
    }

    public void insert(String string, int n) throws IOException {
        Object[] objectArray = this.loadImages(string, true, true);
        Image[] imageArray = (Image[])objectArray[0];
        if (imageArray.length > 0) {
            String[] stringArray = (String[])objectArray[1];
            this.insert(imageArray, n, stringArray);
        }
    }

    public void insert(String string, int n, boolean bl) throws IOException {
        Object[] objectArray = this.loadImages(string, false, bl);
        Image[] imageArray = (Image[])objectArray[0];
        if (imageArray.length > 0) {
            String[] stringArray = (String[])objectArray[1];
            this.insert(imageArray, n, stringArray);
        }
    }

    public void insert(Image image, int n) {
        if (image == null) {
            return;
        }
        this.insert(new Image[]{image}, n, null);
    }

    public String remove(int n) {
        if (this.readOnly) {
            return null;
        }
        int n2 = this.images.length;
        if (n2 == 1 || n2 <= n) {
            return null;
        }
        String string = this.paths[n];
        BufferedImage[] bufferedImageArray = new BufferedImage[n2 - 1];
        System.arraycopy(this.images, 0, bufferedImageArray, 0, n);
        System.arraycopy(this.images, n + 1, bufferedImageArray, n, n2 - 1 - n);
        this.images = bufferedImageArray;
        String[] stringArray = new String[n2 - 1];
        System.arraycopy(this.paths, 0, stringArray, 0, n);
        System.arraycopy(this.paths, n + 1, stringArray, n, n2 - 1 - n);
        this.paths = stringArray;
        this.rawImage = n < n2 - 1 ? this.getImageAtFrame(n, this.rawImage) : this.getImageAtFrame(n - 1, this.rawImage);
        this.frameCount = this.images.length;
        this.endFrameNumber = this.frameCount - 1;
        Dimension dimension = this.getSize();
        if (dimension.height != this.size.height || dimension.width != this.size.width) {
            this.firePropertyChange("size", this.size, dimension);
            this.size = dimension;
            this.refreshBufferedImage();
        }
        return string;
    }

    public Dimension getSize() {
        int n = this.images[0].getWidth(this.observer);
        int n2 = this.images[0].getHeight(this.observer);
        int n3 = 1;
        while (n3 < this.images.length) {
            n = Math.max(n, this.images[n3].getWidth(this.observer));
            n2 = Math.max(n2, this.images[n3].getHeight(this.observer));
            ++n3;
        }
        return new Dimension(n, n2);
    }

    public boolean isFileBased() {
        return this.getValidPaths().length == this.paths.length;
    }

    public boolean isEditable() {
        return !this.readOnly;
    }

    public void setEditable(boolean bl) throws IOException {
        if (bl && this.isEditable()) {
            return;
        }
        if (!bl && !this.isEditable()) {
            return;
        }
        String string = this.paths[0];
        boolean bl2 = this.readOnly = !bl;
        if (this.readOnly) {
            this.paths = new String[0];
        }
        this.images = new BufferedImage[0];
        System.gc();
        this.append(string, true);
    }

    public boolean saveInvalidImages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<BufferedImage> arrayList2 = new ArrayList<BufferedImage>();
        int n = 0;
        while (n < this.paths.length) {
            if (this.paths[n].equals("")) {
                arrayList.add(this.paths[n]);
                arrayList2.add(this.images[n]);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        n = JOptionPane.showConfirmDialog(null, String.valueOf(MediaRes.getString("ImageVideo.Dialog.UnsavedImages.Message1")) + XML.NEW_LINE + MediaRes.getString("ImageVideo.Dialog.UnsavedImages.Message2"), MediaRes.getString("ImageVideo.Dialog.UnsavedImages.Title"), 0, 2);
        if (n == 0) {
            File file;
            block10: {
                ImageVideoRecorder imageVideoRecorder = new ImageVideoRecorder();
                imageVideoRecorder.setExpectedFrameCount(arrayList2.size());
                file = imageVideoRecorder.selectFile();
                if (file != null) break block10;
                return false;
            }
            try {
                String string = file.getAbsolutePath();
                BufferedImage[] bufferedImageArray = arrayList2.toArray(new BufferedImage[0]);
                String[] stringArray = ImageVideoRecorder.saveImages(string, bufferedImageArray);
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.paths.length) {
                    if (this.paths[n3].equals("")) {
                        this.paths[n3] = stringArray[n2++];
                    }
                    ++n3;
                }
                if (this.getProperty("name") == null) {
                    this.setProperty("name", XML.getName(string));
                    this.setProperty("path", string);
                    this.setProperty("absolutePath", string);
                }
                return true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    @Override
    protected void finalize() {
    }

    private Image getImageAtFrame(int n, Image image) {
        if (this.readOnly && n < this.paths.length) {
            Image image2;
            if (!this.paths[n].equals("") && (image2 = ResourceLoader.getImage(this.paths[n])) != null) {
                return image2;
            }
        } else if (n < this.images.length && this.images[n] != null) {
            return this.images[n];
        }
        return image;
    }

    private int length() {
        if (this.readOnly) {
            return this.paths.length;
        }
        return this.images.length;
    }

    private Object[] loadImages(String string, boolean bl, boolean bl2) throws IOException {
        Object object;
        Resource resource = ResourceLoader.getResource(string);
        if (resource == null) {
            throw new IOException("Image " + string + " not found");
        }
        Image image = resource.getImage();
        if (image == null) {
            throw new IOException("\"" + string + "\" is not an image");
        }
        if (this.getProperty("name") == null) {
            this.setProperty("name", XML.getName(string));
            this.setProperty("path", string);
            this.setProperty("absolutePath", resource.getAbsolutePath());
        }
        if (!bl && !bl2) {
            Image[] imageArray = new Image[]{image};
            String[] stringArray = new String[]{string};
            return new Object[]{imageArray, stringArray};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        String string2 = XML.getName(string);
        String string3 = "";
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string3 = string.substring(n).toLowerCase();
            string = string.substring(0, n);
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = 1;
        while (n4 < n2) {
            try {
                n3 = Integer.parseInt(string.substring(n2 - n4));
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
            ++n4;
        }
        if (--n4 == 0) {
            Image[] imageArray = new Image[]{image};
            String[] stringArray = new String[]{String.valueOf(string) + string3};
            return new Object[]{imageArray, stringArray};
        }
        ArrayList<Image> arrayList2 = new ArrayList<Image>();
        arrayList2.add(image);
        int n5 = 10;
        n4 = Math.min(n4, 4);
        switch (n4) {
            case 1: {
                n5 = 10;
                break;
            }
            case 2: {
                n5 = 100;
                break;
            }
            case 3: {
                n5 = 1000;
                break;
            }
            case 4: {
                n5 = 10000;
            }
        }
        String string4 = string.substring(0, n2 - n4);
        try {
            boolean bl3 = false;
            while (n3 < n5 - 1) {
                object = String.valueOf(++n3);
                int n6 = n4 - object.length();
                int n7 = 0;
                while (n7 < n6) {
                    object = "0" + (String)object;
                    ++n7;
                }
                string = String.valueOf(string4) + (String)object + string3;
                if (this.readOnly && !arrayList2.isEmpty() ? ResourceLoader.getResource(string) == null : (image = ResourceLoader.getImage(string)) == null) break;
                if (!bl3 && bl) {
                    bl3 = true;
                    n7 = JOptionPane.showOptionDialog(null, "\"" + string2 + "\" " + MediaRes.getString("ImageVideo.Dialog.LoadSequence.Message") + XML.NEW_LINE + MediaRes.getString("ImageVideo.Dialog.LoadSequence.Query"), MediaRes.getString("ImageVideo.Dialog.LoadSequence.Title"), 0, 3, null, new String[]{MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.SingleImage"), MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.AllImages")}, MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.AllImages"));
                    if (n7 == 0) break;
                }
                if (!this.readOnly || arrayList2.isEmpty()) {
                    arrayList2.add(image);
                }
                arrayList.add(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        Image[] imageArray = arrayList2.toArray(new Image[0]);
        object = arrayList.toArray(new String[0]);
        return new Object[]{imageArray, object};
    }

    public String[] getValidPaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.paths.length) {
            if (!this.paths[n].equals("")) {
                arrayList.add(this.paths[n]);
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    protected String[] getValidPathsRelativeTo(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.paths.length) {
            if (!this.paths[n].equals("")) {
                arrayList.add(XML.getPathRelativeTo(this.paths[n], string));
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    protected void insert(Image[] imageArray, int n, String[] stringArray) {
        String[] stringArray2;
        if (this.readOnly && stringArray == null) {
            return;
        }
        int n2 = this.length();
        n = Math.min(n, n2);
        int n3 = imageArray.length;
        BufferedImage[] bufferedImageArray = new BufferedImage[n3];
        int n4 = 0;
        while (n4 < imageArray.length) {
            stringArray2 = imageArray[n4];
            if (stringArray2 instanceof BufferedImage) {
                bufferedImageArray[n4] = (BufferedImage)stringArray2;
            } else {
                int n5 = stringArray2.getWidth(null);
                int n6 = stringArray2.getHeight(null);
                bufferedImageArray[n4] = new BufferedImage(n5, n6, 1);
                bufferedImageArray[n4].createGraphics().drawImage((Image)stringArray2, 0, 0, null);
            }
            ++n4;
        }
        BufferedImage[] bufferedImageArray2 = new BufferedImage[n2 + n3];
        System.arraycopy(this.images, 0, bufferedImageArray2, 0, n);
        System.arraycopy(bufferedImageArray, 0, bufferedImageArray2, n, n3);
        System.arraycopy(this.images, n, bufferedImageArray2, n + n3, n2 - n);
        this.images = bufferedImageArray2;
        if (stringArray == null) {
            stringArray = new String[imageArray.length];
            int n7 = 0;
            while (n7 < stringArray.length) {
                stringArray[n7] = "";
                ++n7;
            }
        }
        n3 = stringArray.length;
        stringArray2 = new String[n2 + n3];
        System.arraycopy(this.paths, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, 0, stringArray2, n, n3);
        System.arraycopy(this.paths, n, stringArray2, n + n3, n2 - n);
        this.paths = stringArray2;
        this.rawImage = this.getImageAtFrame(n, this.rawImage);
        this.frameCount = this.length();
        this.endFrameNumber = this.frameCount - 1;
        if (this.coords == null) {
            this.size = new Dimension(this.rawImage.getWidth(this.observer), this.rawImage.getHeight(this.observer));
            this.refreshBufferedImage();
            this.coords = new ImageCoordSystem(this.frameCount);
            this.coords.addPropertyChangeListener(this);
            this.aspects = new DoubleArray(this.frameCount, 1.0);
        } else {
            this.coords.setLength(this.frameCount);
            this.aspects.setLength(this.frameCount);
        }
        Dimension dimension = this.getSize();
        if (dimension.height != this.size.height || dimension.width != this.size.width) {
            this.firePropertyChange("size", this.size, dimension);
            this.size = dimension;
            this.refreshBufferedImage();
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            ImageVideo imageVideo = (ImageVideo)object;
            String string = (String)imageVideo.getProperty("base");
            String[] stringArray = imageVideo.getValidPathsRelativeTo(string);
            if (stringArray.length > 0) {
                xMLControl.setValue("paths", stringArray);
                xMLControl.setValue("path", stringArray[0]);
            }
            if (!imageVideo.getFilterStack().isEmpty()) {
                xMLControl.setValue("filters", imageVideo.getFilterStack().getFilters());
            }
            xMLControl.setValue("delta_t", imageVideo.deltaT);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            String string;
            VideoType videoType;
            Object object3;
            Object object2;
            String[] stringArray = (String[])xMLControl.getObject("paths");
            if (stringArray == null) {
                try {
                    object2 = xMLControl.getString("path");
                    boolean bl = xMLControl.getBoolean("sequence");
                    if (object2 != null) {
                        ImageVideo imageVideo = new ImageVideo((String)object2, bl);
                        return imageVideo;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
            }
            if ((object2 = (Object)((boolean[])xMLControl.getObject("sequences"))) != null) {
                try {
                    ImageVideo imageVideo = new ImageVideo(stringArray[0], (boolean)object2[0]);
                    int n = 1;
                    while (n < stringArray.length) {
                        imageVideo.append(stringArray[n], (boolean)object2[n]);
                        ++n;
                    }
                    return imageVideo;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            if (stringArray.length == 0) {
                return null;
            }
            ImageVideo imageVideo = null;
            ArrayList<String> arrayList = null;
            int n = 0;
            while (n < stringArray.length) {
                try {
                    if (imageVideo == null) {
                        imageVideo = new ImageVideo(stringArray[n], false);
                    } else {
                        imageVideo.append(stringArray[n], false);
                    }
                }
                catch (Exception exception) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add("\"" + stringArray[n] + "\"");
                }
                ++n;
            }
            if (arrayList != null) {
                String string2 = (String)arrayList.get(0);
                int n2 = 1;
                while (n2 < arrayList.size()) {
                    string2 = String.valueOf(string2) + ", " + (String)arrayList.get(n2);
                    ++n2;
                }
                JOptionPane.showMessageDialog(null, String.valueOf(MediaRes.getString("ImageVideo.Dialog.MissingImages.Message")) + ":\n" + string2, MediaRes.getString("ImageVideo.Dialog.MissingImages.Title"), 2);
            }
            if (imageVideo == null) {
                return null;
            }
            imageVideo.rawImage = imageVideo.images[0];
            Collection collection = (Collection)Collection.class.cast(xMLControl.getObject("filters"));
            if (collection != null) {
                imageVideo.getFilterStack().clear();
                for (Object object3 : collection) {
                    imageVideo.getFilterStack().addFilter((Filter)object3);
                }
            }
            if ((videoType = VideoIO.getVideoType("image", (String)(object3 = XML.getExtension(string = stringArray[0])))) != null) {
                imageVideo.setProperty("video_type", videoType);
            }
            imageVideo.deltaT = xMLControl.getDouble("delta_t");
            return imageVideo;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            return object;
        }
    }
}

