/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SortDecorator
implements TableModel,
TableModelListener {
    private TableModel realModel;
    private int[] indexes;
    private int sortedColumn;

    public SortDecorator(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("null models are not allowed");
        }
        this.realModel = tableModel;
        this.realModel.addTableModelListener(this);
        this.allocate();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 >= this.getColumnCount()) {
            return null;
        }
        if (this.indexes.length <= n) {
            this.allocate();
        }
        return this.realModel.getValueAt(this.indexes[n], n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.indexes.length <= n) {
            this.allocate();
        }
        this.realModel.setValueAt(object, this.indexes[n], n2);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.allocate();
    }

    public void sort(int n) {
        this.sortedColumn = n;
        int n2 = this.getRowCount();
        if (this.indexes.length <= n2) {
            this.allocate();
        }
        if (this.realModel.getColumnClass(n) == Double.class || this.realModel.getColumnClass(n) == Integer.class) {
            int n3;
            Double[][] doubleArray = new Double[n2][2];
            if (this.realModel.getColumnClass(n) == Double.class) {
                n3 = 0;
                while (n3 < n2) {
                    doubleArray[n3][0] = (Double)this.realModel.getValueAt(n3, n);
                    doubleArray[n3][1] = 1.0 * (double)this.indexes[n3];
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < n2) {
                    doubleArray[n3][0] = ((Integer)this.realModel.getValueAt(n3, n)).doubleValue();
                    doubleArray[n3][1] = 1.0 * (double)this.indexes[n3];
                    ++n3;
                }
            }
            Arrays.sort(doubleArray, new Comparator<Double[]>(){

                @Override
                public int compare(Double[] doubleArray, Double[] doubleArray2) {
                    if (doubleArray[0] == null || doubleArray2[0] == null) {
                        return doubleArray2[0] == doubleArray[0] ? 0 : (doubleArray2[0] == null ? -1 : 1);
                    }
                    return doubleArray2[0] < doubleArray[0] ? 1 : (doubleArray2[0] > doubleArray[0] ? -1 : 0);
                }
            });
            n3 = 0;
            while (n3 < n2) {
                this.indexes[n3] = doubleArray[n3][1].intValue();
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n4 + 1;
                while (n5 < n2) {
                    if (this.compare(this.indexes[n4], this.indexes[n5], n) < 0) {
                        this.swap(n4, n5);
                    }
                    ++n5;
                }
                ++n4;
            }
        }
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    public int compare(int n, int n2, int n3) {
        Object object = this.realModel.getValueAt(n, n3);
        Object object2 = this.realModel.getValueAt(n2, n3);
        if (object != null && object2 == null) {
            return 1;
        }
        if (object == null && object2 != null) {
            return -1;
        }
        if (object == null && object2 == null) {
            return 0;
        }
        if (object instanceof Integer && object2 instanceof Integer) {
            int n4 = (Integer)object;
            int n5 = (Integer)object2;
            return n5 < n4 ? -1 : (n5 > n4 ? 1 : 0);
        }
        if (object instanceof Double && object2 instanceof Double) {
            double d = (Double)object;
            double d2 = (Double)object2;
            return d2 < d ? -1 : (d2 > d ? 1 : 0);
        }
        if (object instanceof Integer && object2 instanceof Double) {
            int n6 = (Integer)object;
            double d = (Double)object2;
            return d < (double)n6 ? -1 : (d > (double)n6 ? 1 : 0);
        }
        if (object instanceof Double && object2 instanceof Integer) {
            double d = (Double)object;
            int n7 = (Integer)object2;
            return (double)n7 < d ? -1 : ((double)n7 > d ? 1 : 0);
        }
        int n8 = object2.toString().compareTo(object.toString());
        return n8 < 0 ? -1 : (n8 > 0 ? 1 : 0);
    }

    private void allocate() {
        this.indexes = new int[this.getRowCount()];
        int n = 0;
        while (n < this.indexes.length) {
            this.indexes[n] = n;
            ++n;
        }
    }

    @Override
    public int getRowCount() {
        return this.realModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.realModel.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        if (n >= this.getColumnCount()) {
            return "unknown";
        }
        return this.realModel.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n >= this.getColumnCount()) {
            return Object.class;
        }
        return this.realModel.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 >= this.getColumnCount()) {
            return false;
        }
        return this.realModel.isCellEditable(n, n2);
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.realModel.addTableModelListener(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.realModel.removeTableModelListener(tableModelListener);
    }
}

