/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ResizableIcon
implements Icon {
    protected int baseWidth;
    protected int baseHeight;
    protected int w;
    protected int h;
    protected BufferedImage baseImage;
    protected Icon icon;

    public ResizableIcon(URL uRL) {
        this(new ImageIcon(uRL));
    }

    public ResizableIcon(Icon icon) {
        while (icon instanceof ResizableIcon) {
            icon = ((ResizableIcon)icon).icon;
        }
        this.icon = icon;
        this.baseWidth = this.w = icon.getIconWidth();
        this.baseHeight = this.h = icon.getIconHeight();
    }

    @Override
    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.icon == null) {
            return;
        }
        if (this.baseImage == null || this.baseImage.getWidth() != this.baseWidth || this.baseImage.getHeight() != this.baseHeight) {
            this.baseImage = new BufferedImage(this.baseWidth, this.baseHeight, 2);
        }
        Graphics2D graphics2D = this.baseImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, this.baseWidth, this.baseHeight);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        this.icon.paintIcon(component, graphics2D, 0, 0);
        graphics.drawImage(this.baseImage, n, n2, this.w, this.h, component);
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }

    public Icon getBaseIcon() {
        return this.icon;
    }

    public void resize(int n) {
        int n2 = Math.max(n, 1);
        this.w = n2 * this.baseWidth;
        this.h = n2 * this.baseHeight;
    }
}

