/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;

public class OSPLayout
extends BorderLayout {
    public static int macOffset;
    ArrayList<Component> list = new ArrayList();
    public static final String TOP_LEFT_CORNER = "TopLeftCorner";
    public static final String TOP_RIGHT_CORNER = "TopRightCorner";
    public static final String BOTTOM_LEFT_CORNER = "BottomLeftCorner";
    public static final String BOTTOM_RIGHT_CORNER = "BottomRightCorner";
    public static final String CENTERED = "Centered";
    Component topLeftCorner;
    Component topRightCorner;
    Component bottomLeftCorner;
    Component bottomRightCorner;
    Component centeredComp;
    Rectangle layoutRect = new Rectangle(0, 0, 0, 0);
    Component[] components = new Component[0];

    static {
        try {
            macOffset = "Mac OS X".equals(System.getProperty("os.name")) ? 16 : 0;
        }
        catch (SecurityException securityException) {}
    }

    public OSPLayout() {
        this(0, 0);
    }

    public OSPLayout(int n, int n2) {
        super(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (!this.list.contains(component)) {
            this.list.add(component);
            this.components = this.list.toArray(new Component[0]);
        }
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object instanceof String && TOP_LEFT_CORNER.equals(object)) {
                this.list.remove(this.topLeftCorner);
                this.topLeftCorner = component;
            } else if (object instanceof String && TOP_RIGHT_CORNER.equals(object)) {
                this.list.remove(this.topRightCorner);
                this.topRightCorner = component;
            } else if (object instanceof String && BOTTOM_LEFT_CORNER.equals(object)) {
                this.list.remove(this.bottomLeftCorner);
                this.bottomLeftCorner = component;
            } else if (object instanceof String && BOTTOM_RIGHT_CORNER.equals(object)) {
                this.list.remove(this.bottomRightCorner);
                this.bottomRightCorner = component;
            } else if (object instanceof String && CENTERED.equals(object)) {
                this.list.remove(this.centeredComp);
                this.centeredComp = component;
            } else {
                super.addLayoutComponent(component, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component component) {
        if (this.list.contains(component)) {
            this.list.remove(component);
            this.components = this.list.toArray(new Component[0]);
        }
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component == this.topLeftCorner) {
                this.topLeftCorner = null;
            } else if (component == this.topRightCorner) {
                this.topRightCorner = null;
            } else if (component == this.bottomLeftCorner) {
                this.bottomLeftCorner = null;
            } else if (component == this.bottomRightCorner) {
                this.bottomRightCorner = null;
            } else if (component == this.centeredComp) {
                this.centeredComp = null;
            } else {
                super.removeLayoutComponent(component);
            }
        }
    }

    @Override
    public void layoutContainer(Container container) {
        super.layoutContainer(container);
        this.doMyLayout(container);
    }

    public boolean quickLayout(Container container, Component component) {
        if (container == null || component == null) {
            return false;
        }
        Insets insets = container.getInsets();
        int n = insets.top;
        int n2 = container.getHeight() - insets.bottom;
        int n3 = insets.left;
        int n4 = container.getWidth() - insets.right;
        if (this.topLeftCorner == component) {
            Dimension dimension = component.getPreferredSize();
            component.setSize(dimension.width, dimension.height);
            component.setBounds(n3, n, dimension.width, dimension.height);
        } else if (this.topRightCorner == component) {
            Dimension dimension = component.getPreferredSize();
            component.setSize(dimension.width, dimension.height);
            component.setBounds(n4 - dimension.width, n, dimension.width, dimension.height);
        } else if (this.bottomLeftCorner == component) {
            Dimension dimension = component.getPreferredSize();
            component.setSize(dimension.width, dimension.height);
            component.setBounds(n3, n2 - dimension.height, dimension.width, dimension.height);
        } else if (this.bottomRightCorner == component) {
            Dimension dimension = component.getPreferredSize();
            component.setSize(dimension.width, dimension.height);
            component.setBounds(n4 - dimension.width - macOffset, n2 - dimension.height, dimension.width, dimension.height);
        } else if (this.centeredComp == component) {
            Dimension dimension = component.getPreferredSize();
            component.setSize(dimension.width, dimension.height);
            component.setBounds((n4 - n3 - dimension.width) / 2, (n2 - n - dimension.height) / 2, dimension.width, dimension.height);
        } else {
            return false;
        }
        return true;
    }

    public void checkLayoutRect(Container container, Rectangle rectangle) {
        if (this.layoutRect.equals(rectangle)) {
            return;
        }
        this.layoutContainer(container);
    }

    public Component[] getComponents() {
        return this.components;
    }

    void doMyLayout(Container container) {
        Dimension dimension;
        Insets insets = container.getInsets();
        int n = insets.top;
        int n2 = container.getHeight() - insets.bottom;
        int n3 = insets.left;
        int n4 = container.getWidth() - insets.right;
        Component component = null;
        if (this.topLeftCorner != null) {
            component = this.topLeftCorner;
            dimension = component.getPreferredSize();
            component.setSize(dimension.width, dimension.height);
            component.setBounds(n3, n, dimension.width, dimension.height);
        }
        if (this.topRightCorner != null) {
            component = this.topRightCorner;
            dimension = component.getPreferredSize();
            component.setSize(dimension.width, dimension.height);
            component.setBounds(n4 - dimension.width, n, dimension.width, dimension.height);
        }
        if (this.bottomLeftCorner != null) {
            component = this.bottomLeftCorner;
            dimension = component.getPreferredSize();
            component.setSize(dimension.width, dimension.height);
            component.setBounds(n3, n2 - dimension.height, dimension.width, dimension.height);
        }
        if (this.bottomRightCorner != null) {
            component = this.bottomRightCorner;
            dimension = component.getPreferredSize();
            component.setSize(dimension.width + macOffset, dimension.height);
            component.setBounds(n4 - dimension.width - macOffset, n2 - dimension.height, dimension.width, dimension.height);
        }
        if (this.centeredComp != null) {
            component = this.centeredComp;
            dimension = component.getPreferredSize();
            component.setSize(dimension.width, dimension.height);
            component.setBounds((n4 - n3 - dimension.width) / 2, (n2 - n - dimension.height) / 2, dimension.width, dimension.height);
        }
    }
}

