/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.util.Dictionary;
import java.util.Hashtable;

public class DisplayColors {
    static Color[] phaseColors = null;
    static Dictionary<Integer, Color> lineColors = new Hashtable<Integer, Color>();
    static Dictionary<Integer, Color> markerColors = new Hashtable<Integer, Color>();

    static {
        lineColors.put(0, Color.RED);
        lineColors.put(1, Color.GREEN.darker());
        lineColors.put(2, Color.BLUE);
        lineColors.put(3, Color.YELLOW.darker());
        lineColors.put(4, Color.CYAN.darker());
        lineColors.put(5, Color.MAGENTA);
        markerColors.put(0, Color.RED);
        markerColors.put(1, Color.GREEN.darker());
        markerColors.put(2, Color.BLUE);
        markerColors.put(3, Color.YELLOW.darker());
        markerColors.put(4, Color.CYAN.darker());
        markerColors.put(5, Color.MAGENTA);
    }

    private DisplayColors() {
    }

    public static Color[] getPhaseToColorArray() {
        if (phaseColors == null) {
            phaseColors = new Color[256];
            int n = 0;
            while (n < 256) {
                double d = Math.abs(Math.sin(Math.PI * (double)n / 255.0));
                int n2 = (int)(255.0 * d * d);
                d = Math.abs(Math.sin(Math.PI * (double)n / 255.0 + 1.0471975511965976));
                int n3 = (int)(255.0 * d * d * Math.sqrt(d));
                d = Math.abs(Math.sin(Math.PI * (double)n / 255.0 + 2.0943951023931953));
                int n4 = (int)(255.0 * d * d);
                DisplayColors.phaseColors[n] = new Color(n4, n3, n2);
                ++n;
            }
        }
        return phaseColors;
    }

    public static Color phaseToColor(double d) {
        int n = (int)(127.5 * (1.0 + d / Math.PI));
        n %= 255;
        if (phaseColors == null) {
            return DisplayColors.getPhaseToColorArray()[n];
        }
        return phaseColors[n];
    }

    public static Color randomColor() {
        return new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
    }

    public static Color getLineColor(int n) {
        Color color = lineColors.get(n);
        if (color == null) {
            float f = (float)((double)n * Math.PI / 12.0) % 1.0f;
            float f2 = 1.0f;
            float f3 = 0.5f;
            color = Color.getHSBColor(f, f2, f3);
            lineColors.put(n, color);
        }
        return color;
    }

    public static Color getMarkerColor(int n) {
        Color color = markerColors.get(n);
        if (color == null) {
            color = DisplayColors.getLineColor(n).brighter().brighter();
            markerColors.put(n, color);
        }
        return color;
    }
}

