/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class CellBorder
extends AbstractBorder {
    protected int thickness;
    protected Color lineColor;

    public CellBorder(Color color) {
        this(color, 1);
    }

    public CellBorder(Color color, int n) {
        this.lineColor = color;
        this.thickness = n;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(this.lineColor);
        int n5 = 0;
        while (n5 < this.thickness) {
            graphics.drawLine(n, n2 + n5, n + n3 - 1, n2 + n5);
            graphics.drawLine(n + n5, n2, n + n5, n2 + n4 - 1);
            ++n5;
        }
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.thickness + 1, this.thickness + 1, 1, 1);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.left = insets.top = this.thickness + 1;
        insets.bottom = 1;
        insets.right = 1;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }
}

